/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.exporter;

import com.fujitsu.tsc.desktop.exporter.model.XmlDocument;
import com.fujitsu.tsc.desktop.importer.models.DefineARMDatasetModel;
import com.fujitsu.tsc.desktop.importer.models.DefineARMDisplayModel;
import com.fujitsu.tsc.desktop.importer.models.DefineARMResultModel;
import com.fujitsu.tsc.desktop.importer.models.DefineCodelistModel;
import com.fujitsu.tsc.desktop.importer.models.DefineCommentModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDatasetModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDictionaryModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDocumentModel;
import com.fujitsu.tsc.desktop.importer.models.DefineMethodModel;
import com.fujitsu.tsc.desktop.importer.models.DefineModel;
import com.fujitsu.tsc.desktop.importer.models.DefineStandardModel;
import com.fujitsu.tsc.desktop.importer.models.DefineStudyModel;
import com.fujitsu.tsc.desktop.importer.models.DefineValueModel;
import com.fujitsu.tsc.desktop.importer.models.DefineVariableModel;
import com.fujitsu.tsc.desktop.importer.models.DefineWCModel;
import com.fujitsu.tsc.desktop.util.Config;
import com.fujitsu.tsc.desktop.util.Utils;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;

public class DefineXmlWriter2 {
    private static Logger logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
    private Config config;
    private OutputStreamWriter sw;
    private BufferedWriter writer;
    private final String DELIMITER;
    private final String DEFAULTLANG = "en";
    private final String DEFINE_VERSION;

    public DefineXmlWriter2(Config config) throws UnsupportedEncodingException, FileNotFoundException {
        this.config = config;
        this.DELIMITER = config.valueDelimiter;
        this.DEFINE_VERSION = config.e2dDefineVersion;
    }

    public XmlDocument bind(DefineModel define) {
        Object wc;
        List<DefineValueModel> values;
        XmlDocument.XmlElement alias_element;
        List supp_docs;
        List acrfs;
        List<DefineStandardModel> standards;
        XmlDocument.XmlHeader xml_header = new XmlDocument.XmlHeader(this.config.e2dXmlEncoding);
        XmlDocument.XmlElement root_element = new XmlDocument.XmlElement("ODM");
        XmlDocument xml_document = new XmlDocument(xml_header, root_element);
        XmlDocument.ProcessingInstruction processing_instruction = new XmlDocument.ProcessingInstruction("xml-stylesheet");
        processing_instruction.addInstruction("type", "text/xsl");
        processing_instruction.addInstruction("href", this.config.e2dStylesheetLocation);
        xml_document.addProcessingInstruction(processing_instruction);
        DefineStudyModel study = define.getStudy();
        root_element.addAttribute("xmlns", "http://www.cdisc.org/ns/odm/v1.3");
        root_element.addAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        if ("2.0.0".equals(this.DEFINE_VERSION)) {
            root_element.addAttribute("xmlns:def", "http://www.cdisc.org/ns/def/v2.0");
        } else {
            root_element.addAttribute("xmlns:def", "http://www.cdisc.org/ns/def/v2.1");
        }
        if (this.config.e2dDatasetType == Config.DatasetType.ADaM && this.config.e2dIncludeResultMetadata) {
            root_element.addAttribute("xmlns:arm", "http://www.cdisc.org/ns/arm/v1.0");
        }
        root_element.addAttribute("ODMVersion", "1.3.2");
        root_element.addAttribute("FileOID", StringUtils.isEmpty((CharSequence)study.file_oid) ? UUID.randomUUID().toString() : study.file_oid);
        root_element.addAttribute("FileType", "Snapshot");
        String creation_date_time = DefineXmlWriter2.calendarToIso8601(Calendar.getInstance());
        root_element.addAttribute("CreationDateTime", creation_date_time);
        if (StringUtils.isNotEmpty((CharSequence)study.as_of_date_time)) {
            root_element.addAttribute("AsOfDateTime", study.as_of_date_time);
        }
        if (StringUtils.isNotEmpty((CharSequence)study.originator)) {
            root_element.addAttribute("Originator", study.originator);
        }
        root_element.addAttribute("SourceSystem", Config.SOFTWARE_NAME);
        root_element.addAttribute("SourceSystemVersion", Config.SOFTWARE_VERSION);
        if (!"2.0.0".equals(this.DEFINE_VERSION)) {
            root_element.addAttribute("def:Context", study.context);
        }
        XmlDocument.XmlElement study_element = new XmlDocument.XmlElement("Study");
        root_element.addElement(study_element);
        study_element.addAttribute("OID", study.toStudyOid());
        XmlDocument.XmlElement global_var_elem = new XmlDocument.XmlElement("GlobalVariables");
        study_element.addElement(global_var_elem);
        XmlDocument.XmlElement study_name_elem = new XmlDocument.XmlElement("StudyName");
        global_var_elem.addElement(study_name_elem);
        study_name_elem.addText(study.study_name);
        XmlDocument.XmlElement study_desc_elem = new XmlDocument.XmlElement("StudyDescription");
        global_var_elem.addElement(study_desc_elem);
        study_desc_elem.addText(study.study_description);
        XmlDocument.XmlElement protocol_name_elem = new XmlDocument.XmlElement("ProtocolName");
        global_var_elem.addElement(protocol_name_elem);
        protocol_name_elem.addText(study.protocol_name);
        XmlDocument.XmlElement md_ver_element = new XmlDocument.XmlElement("MetaDataVersion");
        study_element.addElement(md_ver_element);
        md_ver_element.addAttribute("OID", study.toMetaDataOid());
        md_ver_element.addAttribute("Name", study.metadata_name);
        md_ver_element.addAttribute("Description", study.metadata_description);
        if ("2.0.0".equals(this.DEFINE_VERSION)) {
            md_ver_element.addAttribute("def:DefineVersion", this.config.e2dDefineVersion);
            md_ver_element.addAttribute("def:StandardName", this.config.e2dDatasetType.name() + "-IG");
            String standard_version = "";
            if (StringUtils.isEmpty((CharSequence)study.standard_version)) {
                DefineStandardModel standard = define.listSortedStandard().stream().filter(o -> o.standard_type == DefineStandardModel.StandardType.IG && StringUtils.equals((CharSequence)o.standard_name, (CharSequence)(this.config.e2dDatasetType.name() + "IG"))).findFirst().orElse(null);
                if (standard != null) {
                    standard_version = standard.standard_version;
                }
            } else {
                standard_version = study.standard_version;
            }
            md_ver_element.addAttribute("def:StandardVersion", standard_version);
        } else {
            if (StringUtils.isEmpty((CharSequence)study.define_version)) {
                md_ver_element.addAttribute("def:DefineVersion", study.define_version);
            } else {
                md_ver_element.addAttribute("def:DefineVersion", "2.1.0");
            }
            md_ver_element.addAttribute("def:CommentOID", study.comment_oid);
        }
        if (!"2.0.0".equals(this.DEFINE_VERSION) && !(standards = define.listSortedStandard()).isEmpty()) {
            XmlDocument.XmlElement standards_element = new XmlDocument.XmlElement("def:Standards");
            md_ver_element.addElement(standards_element);
            for (DefineStandardModel standard : standards) {
                XmlDocument.XmlElement xmlElement = new XmlDocument.XmlElement("def:Standard");
                standards_element.addElement(xmlElement);
                xmlElement.addAttribute("OID", standard.toOid());
                xmlElement.addAttribute("Name", standard.standard_name);
                xmlElement.addAttribute("Type", standard.standard_type.name());
                xmlElement.addAttribute("PublishingSet", standard.publishing_set);
                xmlElement.addAttribute("Version", standard.standard_version);
                xmlElement.addAttribute("Status", standard.standard_status);
                xmlElement.addAttribute("def:CommentOID", standard.comment_oid);
            }
        }
        if (!(acrfs = define.listSortedDocument().stream().filter(o -> o.document_type == DefineModel.DocType.AnnotatedCRF).collect(Collectors.toList())).isEmpty()) {
            XmlDocument.XmlElement acrf_element = new XmlDocument.XmlElement("def:AnnotatedCRF");
            md_ver_element.addElement(acrf_element);
            for (Iterator acrf : acrfs) {
                XmlDocument.XmlElement xmlElement = new XmlDocument.XmlElement("def:DocumentRef");
                xmlElement.addAttribute("leafID", ((DefineDocumentModel)((Object)acrf)).toOid());
                acrf_element.addElement(xmlElement);
            }
        }
        if (!(supp_docs = define.listSortedDocument().stream().filter(o -> o.document_type == DefineModel.DocType.SupplementalDoc).collect(Collectors.toList())).isEmpty()) {
            XmlDocument.XmlElement supp_doc_element = new XmlDocument.XmlElement("def:SupplementalDoc");
            md_ver_element.addElement(supp_doc_element);
            for (DefineDocumentModel defineDocumentModel : supp_docs) {
                XmlDocument.XmlElement doc_ref_element = new XmlDocument.XmlElement("def:DocumentRef");
                doc_ref_element.addAttribute("leafID", defineDocumentModel.toOid());
                supp_doc_element.addElement(doc_ref_element);
            }
        }
        List<DefineDatasetModel> datasets = define.listSortedDataset();
        for (DefineDatasetModel defineDatasetModel : datasets) {
            if ("2.0.0".equals(this.DEFINE_VERSION) && defineDatasetModel.has_no_data == DefineModel.YorNull.Yes) continue;
            XmlDocument.XmlElement ig_def_element = new XmlDocument.XmlElement("ItemGroupDef");
            md_ver_element.addElement(ig_def_element);
            ig_def_element.addAttribute("OID", defineDatasetModel.toOid());
            if (this.config.e2dDatasetType != Config.DatasetType.ADaM) {
                ig_def_element.addAttribute("Domain", defineDatasetModel.domain);
            }
            ig_def_element.addAttribute("Name", defineDatasetModel.dataset_name);
            ig_def_element.addAttribute("Repeating", defineDatasetModel.repeating.name());
            ig_def_element.addAttribute("IsReferenceData", defineDatasetModel.is_reference_data.name());
            ig_def_element.addAttribute("SASDatasetName", defineDatasetModel.sas_dataset_name);
            ig_def_element.addAttribute("Purpose", defineDatasetModel.purpose);
            ig_def_element.addAttribute("def:Structure", defineDatasetModel.structure);
            if ("2.0.0".equals(this.DEFINE_VERSION)) {
                ig_def_element.addAttribute("def:Class", defineDatasetModel.dataset_class);
            }
            ig_def_element.addAttribute("def:ArchiveLocationID", defineDatasetModel.getLeafOid());
            ig_def_element.addAttribute("def:CommentOID", defineDatasetModel.comment_oid);
            if (!"2.0.0".equals(this.DEFINE_VERSION)) {
                if (StringUtils.isEmpty((CharSequence)defineDatasetModel.standard_oid)) {
                    ig_def_element.addAttribute("def:IsNonStandard", DefineModel.YorNull.Yes.name());
                } else {
                    ig_def_element.addAttribute("def:StandardOID", defineDatasetModel.standard_oid);
                }
                if (defineDatasetModel.has_no_data == DefineModel.YorNull.Yes) {
                    ig_def_element.addAttribute("def:HasNoData", DefineModel.YorNull.Yes.name());
                }
            }
            XmlDocument.XmlElement desc_element2 = new XmlDocument.XmlElement("Description");
            ig_def_element.addElement(desc_element2);
            XmlDocument.XmlElement trans_element = new XmlDocument.XmlElement("TranslatedText");
            desc_element2.addElement(trans_element);
            trans_element.addAttribute("xml:lang", "en");
            trans_element.addText(defineDatasetModel.description);
            List variables = define.listSortedVariable().stream().filter(o -> StringUtils.equals((CharSequence)o.dataset_name, (CharSequence)dataset.dataset_name)).collect(Collectors.toList());
            int order_number = 1;
            for (DefineVariableModel variable : variables) {
                if ("2.0.0".equals(this.DEFINE_VERSION) && (defineDatasetModel.has_no_data == DefineModel.YorNull.Yes || variable.has_no_data == DefineModel.YorNull.Yes) || variable.is_supp == DefineModel.YorN.Yes) continue;
                XmlDocument.XmlElement variable_element = new XmlDocument.XmlElement("ItemRef");
                ig_def_element.addElement(variable_element);
                variable_element.addAttribute("ItemOID", variable.toOid());
                variable_element.addAttribute("OrderNumber", String.valueOf(order_number++));
                variable_element.addAttribute("Mandatory", variable.mandatory.name());
                variable_element.addAttribute("KeySequence", variable.key_sequence);
                variable_element.addAttribute("MethodOID", variable.method_oid);
                variable_element.addAttribute("Role", variable.role);
                variable_element.addAttribute("RoleCodeListOID", variable.role_codelist);
                if ("2.0.0".equals(this.DEFINE_VERSION)) continue;
                if (variable.is_non_standard == DefineModel.YorNull.Yes) {
                    variable_element.addAttribute("def:IsNonStandard", DefineModel.YorNull.Yes.name());
                }
                if (variable.has_no_data != DefineModel.YorNull.Yes) continue;
                variable_element.addAttribute("def:HasNoData", DefineModel.YorNull.Yes.name());
            }
            if (StringUtils.isNotEmpty((CharSequence)defineDatasetModel.alias_name)) {
                XmlDocument.XmlElement alias_element2 = new XmlDocument.XmlElement("Alias");
                ig_def_element.addElement(alias_element2);
                alias_element2.addAttribute("Context", "DomainDescription");
                alias_element2.addAttribute("Name", defineDatasetModel.alias_name);
            }
            if (!"2.0.0".equals(this.DEFINE_VERSION) && StringUtils.isNotEmpty((CharSequence)defineDatasetModel.dataset_class)) {
                XmlDocument.XmlElement class_element = new XmlDocument.XmlElement("def:Class");
                ig_def_element.addElement(class_element);
                class_element.addAttribute("Name", defineDatasetModel.dataset_class);
                if (StringUtils.isNotEmpty((CharSequence)defineDatasetModel.dataset_subclass)) {
                    XmlDocument.XmlElement subclass_element = new XmlDocument.XmlElement("def:SubClass");
                    class_element.addElement(subclass_element);
                    subclass_element.addAttribute("Name", defineDatasetModel.dataset_subclass);
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)defineDatasetModel.leaf_href) || defineDatasetModel.has_no_data != null) continue;
            XmlDocument.XmlElement leaf_element = new XmlDocument.XmlElement("def:leaf");
            ig_def_element.addElement(leaf_element);
            leaf_element.addAttribute("ID", defineDatasetModel.getLeafOid());
            leaf_element.addAttribute("xlink:href", defineDatasetModel.leaf_href);
            XmlDocument.XmlElement title_element = new XmlDocument.XmlElement("def:title");
            leaf_element.addElement(title_element);
            title_element.addText(defineDatasetModel.leaf_title);
        }
        List<DefineVariableModel> variables = define.listSortedVariable();
        for (DefineVariableModel variable : variables) {
            List values2;
            DefineDatasetModel dataset = define.listSortedDataset().stream().filter(o -> StringUtils.equals((CharSequence)variable.dataset_name, (CharSequence)o.dataset_name)).findFirst().orElse(null);
            if ("2.0.0".equals(this.DEFINE_VERSION) && (dataset != null && dataset.has_no_data == DefineModel.YorNull.Yes || variable.has_no_data == DefineModel.YorNull.Yes) || variable.is_supp == DefineModel.YorN.Yes) continue;
            XmlDocument.XmlElement item_def_element = new XmlDocument.XmlElement("ItemDef");
            md_ver_element.addElement(item_def_element);
            item_def_element.addAttribute("OID", variable.toOid());
            item_def_element.addAttribute("Name", variable.variable_name);
            item_def_element.addAttribute("DataType", variable.data_type);
            item_def_element.addAttribute("Length", DefineXmlWriter2.getRepeatLength(variable.length, variable.repeat_n_length));
            item_def_element.addAttribute("SignificantDigits", variable.significant_digits);
            item_def_element.addAttribute("SASFieldName", variable.sas_field_name);
            item_def_element.addAttribute("def:DisplayFormat", variable.display_format);
            item_def_element.addAttribute("def:CommentOID", variable.comment_oid);
            XmlDocument.XmlElement desc_element3 = new XmlDocument.XmlElement("Description");
            item_def_element.addElement(desc_element3);
            XmlDocument.XmlElement trans_element = new XmlDocument.XmlElement("TranslatedText");
            desc_element3.addElement(trans_element);
            trans_element.addAttribute("xml:lang", "en");
            trans_element.addText(variable.variable_label);
            if (StringUtils.isNotEmpty((CharSequence)variable.codelist)) {
                XmlDocument.XmlElement cl_ref_element = new XmlDocument.XmlElement("CodeListRef");
                item_def_element.addElement(cl_ref_element);
                cl_ref_element.addAttribute("CodeListOID", DefineCodelistModel.createCodelistOid(variable.codelist));
            }
            if (StringUtils.isNotEmpty((CharSequence)variable.origin)) {
                XmlDocument.XmlElement origin_element = new XmlDocument.XmlElement("def:Origin");
                item_def_element.addElement(origin_element);
                if ("2.0.0".equals(this.DEFINE_VERSION)) {
                    if ("Collected".equals(variable.origin)) {
                        if ("Vendor".equals(variable.source)) {
                            origin_element.addAttribute("Type", "eDT");
                        } else {
                            origin_element.addAttribute("Type", "CRF");
                        }
                    } else {
                        origin_element.addAttribute("Type", variable.origin);
                    }
                } else {
                    if ("CRF".equals(variable.origin) || "eDT".equals(variable.origin)) {
                        origin_element.addAttribute("Type", "Collected");
                    } else {
                        origin_element.addAttribute("Type", variable.origin);
                    }
                    origin_element.addAttribute("Source", variable.source);
                }
                if (StringUtils.isNotEmpty((CharSequence)variable.predecessor)) {
                    XmlDocument.XmlElement desc_element2 = new XmlDocument.XmlElement("Description");
                    origin_element.addElement(desc_element2);
                    XmlDocument.XmlElement trans_element2 = new XmlDocument.XmlElement("TranslatedText");
                    desc_element2.addElement(trans_element2);
                    trans_element2.addAttribute("xml:lang", "en");
                    trans_element2.addText(variable.predecessor);
                }
                if (StringUtils.isNotEmpty((CharSequence)variable.crf_page_type)) {
                    XmlDocument.XmlElement doc_ref_element = new XmlDocument.XmlElement("def:DocumentRef");
                    origin_element.addElement(doc_ref_element);
                    doc_ref_element.addAttribute("leafID", DefineDocumentModel.createOid(variable.crf_id));
                    XmlDocument.XmlElement pdf_page_element = new XmlDocument.XmlElement("def:PDFPageRef");
                    doc_ref_element.addElement(pdf_page_element);
                    pdf_page_element.addAttribute("Type", variable.crf_page_type);
                    pdf_page_element.addAttribute("PageRefs", variable.crf_page_reference);
                    pdf_page_element.addAttribute("FirstPage", variable.crf_first_page);
                    pdf_page_element.addAttribute("LastPage", variable.crf_last_page);
                    if (!"2.0.0".equals(this.DEFINE_VERSION)) {
                        pdf_page_element.addAttribute("Title", variable.crf_page_title);
                    }
                }
            }
            if (!(values2 = define.listSortedValue().stream().filter(o -> StringUtils.equals((CharSequence)o.dataset_name, (CharSequence)variable.dataset_name) && StringUtils.equals((CharSequence)o.variable_name, (CharSequence)variable.variable_name)).collect(Collectors.toList())).isEmpty()) {
                XmlDocument.XmlElement val_list_ref_element = new XmlDocument.XmlElement("def:ValueListRef");
                item_def_element.addElement(val_list_ref_element);
                val_list_ref_element.addAttribute("ValueListOID", DefineVariableModel.createValueListOid(variable.dataset_name, variable.variable_name));
                XmlDocument.XmlElement val_list_def_element = new XmlDocument.XmlElement("def:ValueListDef");
                md_ver_element.addElement(val_list_def_element);
                val_list_def_element.addAttribute("OID", DefineVariableModel.createValueListOid(variable.dataset_name, variable.variable_name));
                int order_number = 1;
                for (DefineValueModel value : values2) {
                    if ("2.0.0".equals(this.DEFINE_VERSION) && (dataset != null && dataset.has_no_data == DefineModel.YorNull.Yes || variable.has_no_data == DefineModel.YorNull.Yes || value.has_no_data == DefineModel.YorNull.Yes)) continue;
                    XmlDocument.XmlElement item_ref_element = new XmlDocument.XmlElement("ItemRef");
                    val_list_def_element.addElement(item_ref_element);
                    item_ref_element.addAttribute("ItemOID", value.toOid());
                    item_ref_element.addAttribute("OrderNumber", String.valueOf(order_number++));
                    item_ref_element.addAttribute("Mandatory", value.mandatory.name());
                    item_ref_element.addAttribute("KeySequence", value.key_sequence);
                    item_ref_element.addAttribute("MethodOID", value.method_oid);
                    if (!"2.0.0".equals(this.DEFINE_VERSION) && variable.has_no_data == DefineModel.YorNull.Yes) {
                        item_ref_element.addAttribute("def:HasNoData", DefineModel.YorNull.Yes.name());
                    }
                    for (DefineWCModel.DefineWCPk pk : value.where_clause_pks) {
                        DefineWCModel wc2 = define.get(pk);
                        XmlDocument.XmlElement wc_ref_element = new XmlDocument.XmlElement("def:WhereClauseRef");
                        item_ref_element.addElement(wc_ref_element);
                        wc_ref_element.addAttribute("WhereClauseOID", wc2.toOid());
                        XmlDocument.XmlElement wc_def_element = new XmlDocument.XmlElement("def:WhereClauseDef");
                        md_ver_element.addElement(wc_def_element);
                        wc_def_element.addAttribute("OID", wc2.toOid());
                        wc_def_element.addAttribute("def:CommentOID", wc2.comment_oid);
                        for (DefineWCModel.WCCondition wc_condition : wc2.wc_conditions) {
                            XmlDocument.XmlElement range_check_element = new XmlDocument.XmlElement("RangeCheck");
                            wc_def_element.addElement(range_check_element);
                            range_check_element.addAttribute("Comparator", wc_condition.operator);
                            range_check_element.addAttribute("SoftHard", "Soft");
                            range_check_element.addAttribute("def:ItemOID", DefineVariableModel.createOid(wc_condition.dataset_name, wc_condition.variable_name));
                            for (String check_value : wc_condition.values) {
                                XmlDocument.XmlElement check_value_element = new XmlDocument.XmlElement("CheckValue");
                                range_check_element.addElement(check_value_element);
                                check_value_element.addText(check_value);
                            }
                        }
                    }
                    XmlDocument.XmlElement val_item_def_element = new XmlDocument.XmlElement("ItemDef");
                    md_ver_element.addElement(val_item_def_element);
                    val_item_def_element.addAttribute("OID", value.toOid());
                    val_item_def_element.addAttribute("Name", value.value_name);
                    val_item_def_element.addAttribute("DataType", value.data_type);
                    val_item_def_element.addAttribute("Length", value.length);
                    val_item_def_element.addAttribute("SignificantDigits", value.significant_digits);
                    val_item_def_element.addAttribute("SASFieldName", value.sas_field_name);
                    val_item_def_element.addAttribute("def:DisplayFormat", value.display_format);
                    val_item_def_element.addAttribute("def:CommentOID", value.comment_oid);
                    XmlDocument.XmlElement val_desc_element = new XmlDocument.XmlElement("Description");
                    val_item_def_element.addElement(val_desc_element);
                    XmlDocument.XmlElement val_trans_element = new XmlDocument.XmlElement("TranslatedText");
                    val_desc_element.addElement(val_trans_element);
                    val_trans_element.addAttribute("xml:lang", "en");
                    val_trans_element.addText(value.value_label);
                    if (StringUtils.isNotEmpty((CharSequence)value.codelist)) {
                        XmlDocument.XmlElement cl_ref_element = new XmlDocument.XmlElement("CodeListRef");
                        val_item_def_element.addElement(cl_ref_element);
                        cl_ref_element.addAttribute("CodeListOID", DefineCodelistModel.createCodelistOid(value.codelist));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)value.origin)) {
                        XmlDocument.XmlElement val_origin_element = new XmlDocument.XmlElement("def:Origin");
                        val_item_def_element.addElement(val_origin_element);
                        if ("2.0.0".equals(this.DEFINE_VERSION)) {
                            if ("Collected".equals(value.origin)) {
                                if ("Vendor".equals(value.source)) {
                                    val_origin_element.addAttribute("Type", "eDT");
                                } else {
                                    val_origin_element.addAttribute("Type", "CRF");
                                }
                            } else {
                                val_origin_element.addAttribute("Type", value.origin);
                            }
                        } else {
                            if ("CRF".equals(variable.origin) || "eDT".equals(value.origin)) {
                                val_origin_element.addAttribute("Type", "Collected");
                            } else {
                                val_origin_element.addAttribute("Type", value.origin);
                            }
                            val_origin_element.addAttribute("Source", value.source);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)value.predecessor)) {
                            XmlDocument.XmlElement desc_element2 = new XmlDocument.XmlElement("Description");
                            val_origin_element.addElement(desc_element2);
                            XmlDocument.XmlElement trans_element2 = new XmlDocument.XmlElement("TranslatedText");
                            desc_element2.addElement(trans_element2);
                            trans_element2.addAttribute("xml:lang", "en");
                            trans_element2.addText(value.predecessor);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)value.crf_page_type)) {
                            XmlDocument.XmlElement doc_ref_element = new XmlDocument.XmlElement("def:DocumentRef");
                            val_origin_element.addElement(doc_ref_element);
                            doc_ref_element.addAttribute("leafID", DefineDocumentModel.createOid(value.crf_id));
                            XmlDocument.XmlElement pdf_page_element = new XmlDocument.XmlElement("def:PDFPageRef");
                            doc_ref_element.addElement(pdf_page_element);
                            pdf_page_element.addAttribute("Type", value.crf_page_type);
                            pdf_page_element.addAttribute("PageRefs", value.crf_page_reference);
                            pdf_page_element.addAttribute("FirstPage", value.crf_first_page);
                            pdf_page_element.addAttribute("LastPage", value.crf_last_page);
                            if (!"2.0.0".equals(this.DEFINE_VERSION)) {
                                pdf_page_element.addAttribute("Title", value.crf_page_title);
                            }
                        }
                    }
                    if ("2.0.0".equals(this.DEFINE_VERSION) || !StringUtils.isNotEmpty((CharSequence)value.alias_context) || !StringUtils.isNotEmpty((CharSequence)value.alias_name)) continue;
                    XmlDocument.XmlElement alias_element3 = new XmlDocument.XmlElement("Alias");
                    val_item_def_element.addElement(alias_element3);
                    alias_element3.addAttribute("Context", value.alias_context);
                    alias_element3.addAttribute("Name", value.alias_name);
                }
            }
            if ("2.0.0".equals(this.DEFINE_VERSION) || !StringUtils.isNotEmpty((CharSequence)variable.alias_context) || !StringUtils.isNotEmpty((CharSequence)variable.alias_name)) continue;
            alias_element = new XmlDocument.XmlElement("Alias");
            item_def_element.addElement(alias_element);
            alias_element.addAttribute("Context", variable.alias_context);
            alias_element.addAttribute("Name", variable.alias_name);
        }
        if (this.config.e2dDatasetType != Config.DatasetType.ADaM) {
            this.addAutoSuppElements(define, xml_document);
        }
        List<DefineCodelistModel> list = define.listSortedCodelist();
        HashSet referenced_cl_ids = new HashSet();
        if ("2.0.0".equals(this.DEFINE_VERSION)) {
            referenced_cl_ids.addAll(define.listSortedVariable().stream().filter(o -> o.has_no_data_derived == null).map(o -> o.codelist).collect(Collectors.toSet()));
            referenced_cl_ids.addAll(define.listSortedVariable().stream().filter(o -> o.has_no_data_derived == null).map(o -> o.role_codelist).collect(Collectors.toSet()));
            referenced_cl_ids.addAll(define.listSortedValue().stream().filter(o -> o.has_no_data_derived == null).map(o -> o.codelist).collect(Collectors.toSet()));
        } else {
            referenced_cl_ids.addAll(define.listSortedVariable().stream().map(o -> o.codelist).collect(Collectors.toSet()));
            referenced_cl_ids.addAll(define.listSortedVariable().stream().map(o -> o.role_codelist).collect(Collectors.toSet()));
            referenced_cl_ids.addAll(define.listSortedValue().stream().map(o -> o.codelist).collect(Collectors.toSet()));
        }
        XmlDocument.XmlElement last_cl_element = null;
        String last_codelist_id = "";
        for (DefineCodelistModel codelist : list) {
            XmlDocument.XmlElement item_element;
            if (!referenced_cl_ids.contains(codelist.codelist_id)) {
                logger.warn((Object)("The codelist " + codelist.codelist_id + " is not referenced and thus skipped."));
                continue;
            }
            if (!StringUtils.equals((CharSequence)codelist.codelist_id, (CharSequence)last_codelist_id)) {
                XmlDocument.XmlElement cl_element = new XmlDocument.XmlElement("CodeList");
                md_ver_element.addElement(cl_element);
                cl_element.addAttribute("OID", codelist.getCodelistOid());
                cl_element.addAttribute("Name", codelist.codelist_label);
                cl_element.addAttribute("DataType", codelist.data_type);
                if (!"2.0.0".equals(this.DEFINE_VERSION)) {
                    if (StringUtils.isEmpty((CharSequence)codelist.codelist_code)) {
                        cl_element.addAttribute("def:IsNonStandard", DefineModel.YorNull.Yes.name());
                    }
                    cl_element.addAttribute("def:StandardOID", codelist.standard_oid);
                }
                cl_element.addAttribute("SASFormatName", codelist.sas_format_name);
                if (!"2.0.0".equals(this.DEFINE_VERSION)) {
                    cl_element.addAttribute("def:CommentOID", codelist.comment_oid);
                }
                if (StringUtils.isNotEmpty((CharSequence)codelist.codelist_code)) {
                    alias_element = new XmlDocument.XmlElement("Alias");
                    cl_element.addElement(alias_element);
                    alias_element.addAttribute("Context", "nci:ExtCodeID");
                    alias_element.addAttribute("Name", codelist.codelist_code);
                }
                last_codelist_id = codelist.codelist_id;
                last_cl_element = cl_element;
            }
            if (StringUtils.isEmpty((CharSequence)codelist.decode)) {
                item_element = new XmlDocument.XmlElement("EnumeratedItem");
                last_cl_element.addElement(item_element);
                item_element.addAttribute("CodedValue", codelist.submission_value);
                item_element.addAttribute("Rank", codelist.rank);
                item_element.addAttribute("OrderNumber", codelist.order_number);
                if (codelist.extended_value == DefineModel.YorNull.Yes) {
                    item_element.addAttribute("def:ExtendedValue", codelist.extended_value.name());
                }
                if (StringUtils.isNotEmpty((CharSequence)codelist.code)) {
                    alias_element = new XmlDocument.XmlElement("Alias");
                    item_element.addElement(alias_element);
                    alias_element.addAttribute("Context", "nci:ExtCodeID");
                    alias_element.addAttribute("Name", codelist.code);
                }
                if (StringUtils.isNotEmpty((CharSequence)codelist.alias_context) && StringUtils.isNotEmpty((CharSequence)codelist.alias_name)) {
                    alias_element = new XmlDocument.XmlElement("Alias");
                    item_element.addElement(alias_element);
                    alias_element.addAttribute("Context", codelist.alias_context);
                    alias_element.addAttribute("Name", codelist.alias_name);
                }
            } else {
                item_element = new XmlDocument.XmlElement("CodeListItem");
                last_cl_element.addElement(item_element);
                item_element.addAttribute("CodedValue", codelist.submission_value);
                item_element.addAttribute("Rank", codelist.rank);
                item_element.addAttribute("OrderNumber", codelist.order_number);
                if (codelist.extended_value == DefineModel.YorNull.Yes) {
                    item_element.addAttribute("def:ExtendedValue", codelist.extended_value.name());
                }
                XmlDocument.XmlElement decode_element = new XmlDocument.XmlElement("Decode");
                item_element.addElement(decode_element);
                XmlDocument.XmlElement trans_element = new XmlDocument.XmlElement("TranslatedText");
                decode_element.addElement(trans_element);
                trans_element.addAttribute("xml:lang", codelist.xml_lang);
                trans_element.addText(codelist.decode);
                if (StringUtils.isNotEmpty((CharSequence)codelist.code)) {
                    XmlDocument.XmlElement alias_element4 = new XmlDocument.XmlElement("Alias");
                    item_element.addElement(alias_element4);
                    alias_element4.addAttribute("Context", "nci:ExtCodeID");
                    alias_element4.addAttribute("Name", codelist.code);
                }
                if (StringUtils.isNotEmpty((CharSequence)codelist.alias_context) && StringUtils.isNotEmpty((CharSequence)codelist.alias_name)) {
                    XmlDocument.XmlElement alias_element2 = new XmlDocument.XmlElement("Alias");
                    item_element.addElement(alias_element2);
                    alias_element2.addAttribute("Context", codelist.alias_context);
                    alias_element2.addAttribute("Name", codelist.alias_name);
                }
            }
            if (StringUtils.equals((CharSequence)codelist.codelist_id, (CharSequence)last_codelist_id) || !StringUtils.isNotEmpty((CharSequence)codelist.codelist_code)) continue;
            XmlDocument.XmlElement alias_element3 = new XmlDocument.XmlElement("Alias");
            last_cl_element.addElement(alias_element3);
            alias_element3.addAttribute("Context", "nci:ExtCodeID");
            alias_element3.addAttribute("Name", codelist.codelist_code);
        }
        List<DefineDictionaryModel> dictionaries = define.listSortedDictionary();
        for (DefineDictionaryModel dictionary : dictionaries) {
            XmlDocument.XmlElement cl_element = new XmlDocument.XmlElement("CodeList");
            md_ver_element.addElement(cl_element);
            cl_element.addAttribute("OID", dictionary.toOid());
            cl_element.addAttribute("Name", dictionary.dictionary_name);
            cl_element.addAttribute("DataType", dictionary.data_type);
            if (!"2.0.0".equals(this.DEFINE_VERSION)) {
                cl_element.addAttribute("def:CommentOID", dictionary.comment_oid);
            }
            XmlDocument.XmlElement dictionary_element = new XmlDocument.XmlElement("ExternalCodeList");
            cl_element.addElement(dictionary_element);
            dictionary_element.addAttribute("Dictionary", dictionary.dictionary_name);
            dictionary_element.addAttribute("Version", dictionary.dictionary_version);
            dictionary_element.addAttribute("ref", dictionary.dictionary_ref);
            dictionary_element.addAttribute("href", dictionary.dictionary_href);
        }
        List<DefineMethodModel> methods = define.listSortedMethod();
        HashSet referenced_method_oids = new HashSet();
        if ("2.0.0".equals(this.DEFINE_VERSION)) {
            referenced_method_oids.addAll(define.listSortedVariable().stream().filter(o -> o.has_no_data_derived == null).map(o -> o.method_oid).collect(Collectors.toSet()));
            referenced_method_oids.addAll(define.listSortedValue().stream().filter(o -> o.has_no_data_derived == null).map(o -> o.method_oid).collect(Collectors.toSet()));
        } else {
            referenced_method_oids.addAll(define.listSortedVariable().stream().map(o -> o.method_oid).collect(Collectors.toSet()));
            referenced_method_oids.addAll(define.listSortedValue().stream().map(o -> o.method_oid).collect(Collectors.toSet()));
        }
        for (DefineMethodModel method : methods) {
            if (!referenced_method_oids.contains(method.oid)) {
                logger.warn((Object)("The method " + method.oid + " is not referenced and thus skipped."));
                continue;
            }
            XmlDocument.XmlElement method_element = new XmlDocument.XmlElement("MethodDef");
            md_ver_element.addElement(method_element);
            method_element.addAttribute("OID", method.oid);
            method_element.addAttribute("Name", method.method_name);
            method_element.addAttribute("Type", method.method_type);
            XmlDocument.XmlElement xmlElement = new XmlDocument.XmlElement("Description");
            method_element.addElement(xmlElement);
            XmlDocument.XmlElement trans_element = new XmlDocument.XmlElement("TranslatedText");
            xmlElement.addElement(trans_element);
            trans_element.addAttribute("xml:lang", method.description_lang);
            trans_element.addText(method.description);
            for (DefineModel.DocumentRef document_ref : method.document_refs) {
                XmlDocument.XmlElement doc_ref_element = new XmlDocument.XmlElement("def:DocumentRef");
                method_element.addElement(doc_ref_element);
                doc_ref_element.addAttribute("leafID", DefineDocumentModel.createOid(document_ref.document_id));
                if (!StringUtils.isNotEmpty((CharSequence)document_ref.document_page_type)) continue;
                XmlDocument.XmlElement pdf_page_element = new XmlDocument.XmlElement("def:PDFPageRef");
                doc_ref_element.addElement(pdf_page_element);
                pdf_page_element.addAttribute("Type", document_ref.document_page_type);
                pdf_page_element.addAttribute("PageRefs", document_ref.document_page_reference);
                pdf_page_element.addAttribute("FirstPage", document_ref.document_first_page);
                pdf_page_element.addAttribute("LastPage", document_ref.document_last_page);
                if ("2.0.0".equals(this.DEFINE_VERSION)) continue;
                pdf_page_element.addAttribute("Title", document_ref.document_page_title);
            }
            if (!StringUtils.isNotEmpty((CharSequence)method.formal_expression)) continue;
            Iterator<DefineWCModel.DefineWCPk> expression_element = new XmlDocument.XmlElement("FormalExpression");
            method_element.addElement((XmlDocument.XmlElement)((Object)expression_element));
            ((XmlDocument.XmlElement)((Object)expression_element)).addAttribute("Context", method.formal_expression_context);
            ((XmlDocument.XmlElement)((Object)expression_element)).addText(method.formal_expression);
        }
        List<DefineCommentModel> comments = define.listSortedComment();
        HashSet<String> referenced_comment_oids = new HashSet<String>();
        if ("2.0.0".equals(this.DEFINE_VERSION)) {
            referenced_comment_oids.addAll(define.listSortedDataset().stream().filter(o -> o.has_no_data == null).map(o -> o.comment_oid).collect(Collectors.toSet()));
            referenced_comment_oids.addAll(define.listSortedVariable().stream().filter(o -> o.has_no_data_derived == null).map(o -> o.comment_oid).collect(Collectors.toSet()));
            values = define.listSortedValue();
            for (DefineValueModel value : values) {
                if (value.has_no_data_derived != null) continue;
                referenced_comment_oids.add(value.comment_oid);
                for (DefineWCModel.DefineWCPk wc_pk : value.where_clause_pks) {
                    wc = define.get(wc_pk);
                    if (wc == null) continue;
                    referenced_comment_oids.add(((DefineWCModel)wc).comment_oid);
                }
            }
        } else {
            if (define.getStudy() != null) {
                referenced_comment_oids.add(define.getStudy().comment_oid);
            }
            referenced_comment_oids.addAll(define.listSortedStandard().stream().map(o -> o.comment_oid).collect(Collectors.toSet()));
            referenced_comment_oids.addAll(define.listSortedDataset().stream().map(o -> o.comment_oid).collect(Collectors.toSet()));
            referenced_comment_oids.addAll(define.listSortedVariable().stream().map(o -> o.comment_oid).collect(Collectors.toSet()));
            referenced_comment_oids.addAll(define.listSortedDictionary().stream().map(o -> o.comment_oid).collect(Collectors.toSet()));
            referenced_comment_oids.addAll(define.listSortedCodelist().stream().map(o -> o.comment_oid).collect(Collectors.toSet()));
            values = define.listSortedValue();
            for (DefineValueModel value : values) {
                referenced_comment_oids.add(value.comment_oid);
                for (DefineWCModel.DefineWCPk wc_pk : value.where_clause_pks) {
                    wc = define.get(wc_pk);
                    if (wc == null) continue;
                    referenced_comment_oids.add(((DefineWCModel)wc).comment_oid);
                }
            }
        }
        if (this.config.e2dDatasetType == Config.DatasetType.ADaM && this.config.e2dIncludeResultMetadata) {
            referenced_comment_oids.addAll(define.listSortedARMResult().stream().map(o -> o.dataset_comment_oid).collect(Collectors.toSet()));
            Set wc_pks = define.listSortedARMDataset().stream().map(o -> o.where_clause_pk).collect(Collectors.toSet());
            Iterator iterator = wc_pks.iterator();
            while (iterator.hasNext()) {
                DefineWCModel.DefineWCPk wc_pk = (DefineWCModel.DefineWCPk)iterator.next();
                DefineWCModel wc3 = define.get(wc_pk);
                if (wc3 == null) continue;
                referenced_comment_oids.add(wc3.comment_oid);
            }
        }
        for (DefineCommentModel defineCommentModel : comments) {
            if (!referenced_comment_oids.contains(defineCommentModel.oid)) {
                logger.warn((Object)("The comment " + defineCommentModel.oid + " is not referenced and thus skipped."));
                continue;
            }
            XmlDocument.XmlElement comment_element = new XmlDocument.XmlElement("def:CommentDef");
            md_ver_element.addElement(comment_element);
            comment_element.addAttribute("OID", defineCommentModel.oid);
            XmlDocument.XmlElement desc_element4 = new XmlDocument.XmlElement("Description");
            comment_element.addElement(desc_element4);
            XmlDocument.XmlElement trans_element = new XmlDocument.XmlElement("TranslatedText");
            desc_element4.addElement(trans_element);
            trans_element.addAttribute("xml:lang", defineCommentModel.comment_lang);
            trans_element.addText(defineCommentModel.comment_text);
            for (DefineModel.DocumentRef document_ref : defineCommentModel.document_refs) {
                XmlDocument.XmlElement doc_ref_element = new XmlDocument.XmlElement("def:DocumentRef");
                comment_element.addElement(doc_ref_element);
                doc_ref_element.addAttribute("leafID", DefineDocumentModel.createOid(document_ref.document_id));
                if (!StringUtils.isNotEmpty((CharSequence)document_ref.document_page_type)) continue;
                XmlDocument.XmlElement pdf_page_element = new XmlDocument.XmlElement("def:PDFPageRef");
                doc_ref_element.addElement(pdf_page_element);
                pdf_page_element.addAttribute("Type", document_ref.document_page_type);
                pdf_page_element.addAttribute("PageRefs", document_ref.document_page_reference);
                pdf_page_element.addAttribute("FirstPage", document_ref.document_first_page);
                pdf_page_element.addAttribute("LastPage", document_ref.document_last_page);
                if ("2.0.0".equals(this.DEFINE_VERSION)) continue;
                pdf_page_element.addAttribute("Title", document_ref.document_page_title);
            }
        }
        List<DefineDocumentModel> documents = define.listSortedDocument();
        for (DefineDocumentModel document : documents) {
            XmlDocument.XmlElement leaf_element = new XmlDocument.XmlElement("def:leaf");
            md_ver_element.addElement(leaf_element);
            leaf_element.addAttribute("ID", document.toOid());
            leaf_element.addAttribute("xlink:href", document.document_href);
            if (!StringUtils.isNotEmpty((CharSequence)document.document_title)) continue;
            XmlDocument.XmlElement title_element = new XmlDocument.XmlElement("def:title");
            leaf_element.addElement(title_element);
            title_element.addText(document.document_title);
        }
        if (this.config.e2dDatasetType == Config.DatasetType.ADaM && this.config.e2dIncludeResultMetadata) {
            List<DefineARMDisplayModel> list2 = define.listSortedARMDisplay();
            List<DefineARMDatasetModel> arm_datasets = define.listSortedARMDataset();
            XmlDocument.XmlElement displays_element = new XmlDocument.XmlElement("arm:AnalysisResultDisplays");
            md_ver_element.addElement(displays_element);
            for (DefineARMDisplayModel display : list2) {
                XmlDocument.XmlElement display_element = new XmlDocument.XmlElement("arm:ResultDisplay");
                displays_element.addElement(display_element);
                display_element.addAttribute("OID", display.toOid());
                display_element.addAttribute("Name", display.display_name);
                XmlDocument.XmlElement display_desc_element = new XmlDocument.XmlElement("Description");
                display_element.addElement(display_desc_element);
                XmlDocument.XmlElement display_trans_element = new XmlDocument.XmlElement("TranslatedText");
                display_desc_element.addElement(display_trans_element);
                display_trans_element.addAttribute("xml:lang", display.display_lang);
                display_trans_element.addText(display.display_desc);
                for (DefineModel.DocumentRef document_ref : display.document_refs) {
                    XmlDocument.XmlElement doc_ref_element = new XmlDocument.XmlElement("def:DocumentRef");
                    display_element.addElement(doc_ref_element);
                    doc_ref_element.addAttribute("leafID", DefineDocumentModel.createOid(document_ref.document_id));
                    if (!StringUtils.isNotEmpty((CharSequence)document_ref.document_page_type)) continue;
                    XmlDocument.XmlElement pdf_page_element = new XmlDocument.XmlElement("def:PDFPageRef");
                    doc_ref_element.addElement(pdf_page_element);
                    pdf_page_element.addAttribute("Type", document_ref.document_page_type);
                    pdf_page_element.addAttribute("PageRefs", document_ref.document_page_reference);
                    pdf_page_element.addAttribute("FirstPage", document_ref.document_first_page);
                    pdf_page_element.addAttribute("LastPage", document_ref.document_last_page);
                    if ("2.0.0".equals(this.DEFINE_VERSION)) continue;
                    pdf_page_element.addAttribute("Title", document_ref.document_page_title);
                }
                for (DefineARMResultModel.DefineARMResultPk result_pk : display.arm_result_pks) {
                    DefineARMResultModel result = define.get(result_pk);
                    XmlDocument.XmlElement result_element = new XmlDocument.XmlElement("arm:AnalysisResult");
                    display_element.addElement(result_element);
                    result_element.addAttribute("OID", result.toOid());
                    result_element.addAttribute("ParameterOID", result.param_oid);
                    result_element.addAttribute("AnalysisReason", result.analysis_reason);
                    result_element.addAttribute("AnalysisPurpose", result.analysis_purpose);
                    XmlDocument.XmlElement result_desc_element = new XmlDocument.XmlElement("Description");
                    result_element.addElement(result_desc_element);
                    XmlDocument.XmlElement result_trans_element = new XmlDocument.XmlElement("TranslatedText");
                    result_desc_element.addElement(result_trans_element);
                    result_trans_element.addAttribute("xml:lang", result.result_lang);
                    result_trans_element.addText(result.result_desc);
                    XmlDocument.XmlElement datasets_element = new XmlDocument.XmlElement("arm:AnalysisDatasets");
                    result_element.addElement(datasets_element);
                    datasets_element.addAttribute("def:CommentOID", result.dataset_comment_oid);
                    List filtered_arm_datasets = arm_datasets.stream().filter(o -> StringUtils.equals((CharSequence)o.display_name, (CharSequence)result.display_name) && StringUtils.equals((CharSequence)o.result_key, (CharSequence)result.result_key)).collect(Collectors.toList());
                    for (DefineARMDatasetModel arm_dataset : filtered_arm_datasets) {
                        XmlDocument.XmlElement dataset_element = new XmlDocument.XmlElement("arm:AnalysisDataset");
                        datasets_element.addElement(dataset_element);
                        dataset_element.addAttribute("ItemGroupOID", arm_dataset.dataset_oid);
                        DefineWCModel wc4 = define.get(arm_dataset.where_clause_pk);
                        XmlDocument.XmlElement wc_ref_element = new XmlDocument.XmlElement("def:WhereClauseRef");
                        dataset_element.addElement(wc_ref_element);
                        wc_ref_element.addAttribute("WhereClauseOID", wc4.toOid());
                        XmlDocument.XmlElement wc_def_element = new XmlDocument.XmlElement("def:WhereClauseDef");
                        md_ver_element.addElement(wc_def_element);
                        wc_def_element.addAttribute("OID", wc4.toOid());
                        wc_def_element.addAttribute("def:CommentOID", wc4.comment_oid);
                        for (DefineWCModel.WCCondition wc_condition : wc4.wc_conditions) {
                            XmlDocument.XmlElement range_check_element = new XmlDocument.XmlElement("RangeCheck");
                            wc_def_element.addElement(range_check_element);
                            range_check_element.addAttribute("Comparator", wc_condition.operator);
                            range_check_element.addAttribute("SoftHard", "Soft");
                            range_check_element.addAttribute("def:ItemOID", DefineVariableModel.createOid(wc_condition.dataset_name, wc_condition.variable_name));
                            for (String check_value : wc_condition.values) {
                                XmlDocument.XmlElement check_value_element = new XmlDocument.XmlElement("CheckValue");
                                range_check_element.addElement(check_value_element);
                                check_value_element.addText(check_value);
                            }
                        }
                        if (arm_dataset.analysis_variable_oids.isEmpty()) continue;
                        for (String analysis_variable_oid : arm_dataset.analysis_variable_oids) {
                            XmlDocument.XmlElement analysis_var_element = new XmlDocument.XmlElement("arm:AnalysisVariable");
                            dataset_element.addElement(analysis_var_element);
                            analysis_var_element.addAttribute("ItemOID", analysis_variable_oid);
                        }
                    }
                    if (StringUtils.isNotEmpty((CharSequence)result.docm_text)) {
                        XmlDocument.XmlElement docm_element = new XmlDocument.XmlElement("arm:Documentation");
                        result_element.addElement(docm_element);
                        XmlDocument.XmlElement desc_element5 = new XmlDocument.XmlElement("Description");
                        docm_element.addElement(desc_element5);
                        XmlDocument.XmlElement trans_element = new XmlDocument.XmlElement("TranslatedText");
                        desc_element5.addElement(trans_element);
                        trans_element.addAttribute("xml:lang", result.docm_lang);
                        trans_element.addText(result.docm_text);
                        for (DefineModel.DocumentRef document_ref : result.docm_document_refs) {
                            XmlDocument.XmlElement doc_ref_element = new XmlDocument.XmlElement("def:DocumentRef");
                            docm_element.addElement(doc_ref_element);
                            doc_ref_element.addAttribute("leafID", DefineDocumentModel.createOid(document_ref.document_id));
                            if (!StringUtils.isNotEmpty((CharSequence)document_ref.document_page_type)) continue;
                            XmlDocument.XmlElement pdf_page_element = new XmlDocument.XmlElement("def:PDFPageRef");
                            doc_ref_element.addElement(pdf_page_element);
                            pdf_page_element.addAttribute("Type", document_ref.document_page_type);
                            pdf_page_element.addAttribute("PageRefs", document_ref.document_page_reference);
                            pdf_page_element.addAttribute("FirstPage", document_ref.document_first_page);
                            pdf_page_element.addAttribute("LastPage", document_ref.document_last_page);
                            if ("2.0.0".equals(this.DEFINE_VERSION)) continue;
                            pdf_page_element.addAttribute("Title", document_ref.document_page_title);
                        }
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)result.prog_code_text) && result.prog_code_document_refs.isEmpty()) continue;
                    XmlDocument.XmlElement prog_code_element = new XmlDocument.XmlElement("arm:ProgrammingCode");
                    result_element.addElement(prog_code_element);
                    prog_code_element.addAttribute("Context", result.prog_code_context);
                    if (StringUtils.isNotEmpty((CharSequence)result.prog_code_text)) {
                        XmlDocument.XmlElement code_element = new XmlDocument.XmlElement("arm:Code");
                        prog_code_element.addElement(code_element);
                        code_element.addText(result.prog_code_text);
                    }
                    for (DefineModel.DocumentRef document_ref : result.docm_document_refs) {
                        XmlDocument.XmlElement doc_ref_element = new XmlDocument.XmlElement("def:DocumentRef");
                        prog_code_element.addElement(doc_ref_element);
                        doc_ref_element.addAttribute("leafID", DefineDocumentModel.createOid(document_ref.document_id));
                        if (!StringUtils.isNotEmpty((CharSequence)document_ref.document_page_type)) continue;
                        XmlDocument.XmlElement pdf_page_element = new XmlDocument.XmlElement("def:PDFPageRef");
                        doc_ref_element.addElement(pdf_page_element);
                        pdf_page_element.addAttribute("Type", document_ref.document_page_type);
                        pdf_page_element.addAttribute("PageRefs", document_ref.document_page_reference);
                        pdf_page_element.addAttribute("FirstPage", document_ref.document_first_page);
                        pdf_page_element.addAttribute("LastPage", document_ref.document_last_page);
                        if ("2.0.0".equals(this.DEFINE_VERSION)) continue;
                        pdf_page_element.addAttribute("Title", document_ref.document_page_title);
                    }
                }
            }
        }
        return xml_document;
    }

    public void addAutoSuppElements(DefineModel define, XmlDocument xml_document) {
        List<Object> supp_variables = new ArrayList();
        supp_variables = "2.0.0".equals(this.DEFINE_VERSION) ? define.listSortedVariable().stream().filter(o -> o.is_supp == DefineModel.YorN.Yes && o.has_no_data == null).collect(Collectors.toList()) : define.listSortedVariable().stream().filter(o -> o.is_supp == DefineModel.YorN.Yes).collect(Collectors.toList());
        Set str_datasets = supp_variables.stream().map(o -> o.dataset_name).collect(Collectors.toSet());
        List datasets_w_supp = define.listSortedDataset().stream().filter(o -> str_datasets.contains(o.dataset_name)).sorted((o1, o2) -> StringUtils.compare((String)o1.dataset_name, (String)o2.dataset_name)).collect(Collectors.toList());
        XmlDocument.XmlElement root_element = xml_document.getRootElement();
        XmlDocument.XmlElement study_element = root_element.getElementByName("Study");
        XmlDocument.XmlElement md_ver_element = study_element.getElementByName("MetaDataVersion");
        for (DefineDatasetModel dataset_w_supp : datasets_w_supp) {
            List vars_w_data;
            String dataset_name = "SUPP" + dataset_w_supp.dataset_name;
            XmlDocument.XmlElement ig_def_element = new XmlDocument.XmlElement("ItemGroupDef");
            md_ver_element.addElement(ig_def_element);
            ig_def_element.addAttribute("OID", DefineDatasetModel.createOid(dataset_name));
            ig_def_element.addAttribute("Domain", "SUPP" + dataset_w_supp.domain);
            ig_def_element.addAttribute("Name", dataset_name);
            ig_def_element.addAttribute("Repeating", DefineModel.YorN.Yes.name());
            ig_def_element.addAttribute("IsReferenceData", DefineModel.YorN.No.name());
            ig_def_element.addAttribute("SASDatasetName", dataset_name);
            ig_def_element.addAttribute("Purpose", dataset_w_supp.purpose);
            ig_def_element.addAttribute("def:Structure", "One record per IDVAR, IDVARVAL, and QNAM value per subject");
            if ("2.0.0".equals(this.DEFINE_VERSION)) {
                ig_def_element.addAttribute("def:Class", "RELATIONSHIP");
            }
            ig_def_element.addAttribute("def:ArchiveLocationID", DefineDatasetModel.createLeafOid(dataset_name));
            if (!"2.0.0".equals(this.DEFINE_VERSION)) {
                if (StringUtils.isEmpty((CharSequence)dataset_w_supp.standard_oid)) {
                    ig_def_element.addAttribute("def:IsNonStandard", DefineModel.YorNull.Yes.name());
                } else {
                    ig_def_element.addAttribute("def:StandardOID", dataset_w_supp.standard_oid);
                }
                if (dataset_w_supp.has_no_data == DefineModel.YorNull.Yes) {
                    ig_def_element.addAttribute("def:HasNoData", DefineModel.YorNull.Yes.name());
                } else {
                    List filtered_supp_variables = supp_variables.stream().filter(o -> StringUtils.equals((CharSequence)dataset_w_supp.dataset_name, (CharSequence)o.dataset_name)).collect(Collectors.toList());
                    List variables_w_data = filtered_supp_variables.stream().filter(o -> o.has_no_data == null).collect(Collectors.toList());
                    if (variables_w_data.isEmpty()) {
                        ig_def_element.addAttribute("def:HasNoData", DefineModel.YorNull.Yes.name());
                    }
                }
            }
            XmlDocument.XmlElement desc_element = new XmlDocument.XmlElement("Description");
            ig_def_element.addElement(desc_element);
            XmlDocument.XmlElement trans_element = new XmlDocument.XmlElement("TranslatedText");
            desc_element.addElement(trans_element);
            trans_element.addAttribute("xml:lang", "en");
            trans_element.addText("Supplemental Qualifiers for " + dataset_w_supp.dataset_name);
            List<SuppVariable> enum_supp_variables = Arrays.asList(SuppVariable.STUDYID, SuppVariable.RDOMAIN, SuppVariable.USUBJID, SuppVariable.IDVAR, SuppVariable.IDVARVAL, SuppVariable.QNAM, SuppVariable.QLABEL, SuppVariable.QVAL, SuppVariable.QORIG, SuppVariable.QEVAL);
            DefineVariableModel studyid = define.listSortedVariable().stream().filter(o -> StringUtils.equals((CharSequence)o.dataset_name, (CharSequence)dataset_w_supp.dataset_name) && "STUDYID".equals(o.variable_name)).findFirst().orElse(null);
            DefineVariableModel usubjid = define.listSortedVariable().stream().filter(o -> StringUtils.equals((CharSequence)o.dataset_name, (CharSequence)dataset_w_supp.dataset_name) && "USUBJID".equals(o.variable_name)).findFirst().orElse(null);
            DefineVariableModel seq = define.listSortedVariable().stream().filter(o -> StringUtils.equals((CharSequence)o.dataset_name, (CharSequence)dataset_w_supp.dataset_name) && (dataset_w_supp.domain + "SEQ").equals(o.variable_name)).findFirst().orElse(null);
            List filtered_supp_variables = supp_variables.stream().filter(o -> StringUtils.equals((CharSequence)o.dataset_name, (CharSequence)dataset_w_supp.dataset_name)).collect(Collectors.toList());
            int order_number = 1;
            for (SuppVariable enum_supp_variable : enum_supp_variables) {
                DefineVariableModel filtered_supp_variable;
                XmlDocument.XmlElement item_ref_element = new XmlDocument.XmlElement("ItemRef");
                ig_def_element.addElement(item_ref_element);
                item_ref_element.addAttribute("ItemOID", DefineVariableModel.createOid(dataset_name, enum_supp_variable.name()));
                item_ref_element.addAttribute("OrderNumber", String.valueOf(order_number++));
                DefineModel.YorN mandatory = DefineModel.YorN.No;
                if (enum_supp_variable == SuppVariable.STUDYID || enum_supp_variable == SuppVariable.RDOMAIN || enum_supp_variable == SuppVariable.USUBJID || enum_supp_variable == SuppVariable.QNAM || enum_supp_variable == SuppVariable.QLABEL || enum_supp_variable == SuppVariable.QVAL || enum_supp_variable == SuppVariable.QORIG) {
                    mandatory = DefineModel.YorN.Yes;
                }
                item_ref_element.addAttribute("Mandatory", mandatory.name());
                if (enum_supp_variable == SuppVariable.STUDYID) {
                    item_ref_element.addAttribute("KeySequence", "1");
                    item_ref_element.addAttribute("MethodOID", studyid.method_oid);
                } else if (enum_supp_variable == SuppVariable.RDOMAIN) {
                    item_ref_element.addAttribute("KeySequence", "2");
                } else if (enum_supp_variable == SuppVariable.USUBJID) {
                    item_ref_element.addAttribute("KeySequence", "3");
                    item_ref_element.addAttribute("MethodOID", usubjid.method_oid);
                } else if (enum_supp_variable == SuppVariable.IDVAR) {
                    item_ref_element.addAttribute("KeySequence", "4");
                } else if (enum_supp_variable == SuppVariable.IDVARVAL) {
                    item_ref_element.addAttribute("KeySequence", "5");
                } else if (enum_supp_variable == SuppVariable.QNAM) {
                    item_ref_element.addAttribute("KeySequence", "6");
                }
                XmlDocument.XmlElement item_def_element = new XmlDocument.XmlElement("ItemDef");
                md_ver_element.addElement(item_def_element);
                item_def_element.addAttribute("OID", DefineVariableModel.createOid(dataset_name, enum_supp_variable.name()));
                item_def_element.addAttribute("Name", enum_supp_variable.name());
                item_def_element.addAttribute("DataType", "text");
                if (enum_supp_variable == SuppVariable.STUDYID) {
                    if (studyid != null) {
                        item_def_element.addAttribute("Length", studyid.length);
                    }
                } else if (enum_supp_variable == SuppVariable.RDOMAIN) {
                    item_def_element.addAttribute("Length", "2");
                } else if (enum_supp_variable == SuppVariable.USUBJID) {
                    if (usubjid != null) {
                        item_def_element.addAttribute("Length", usubjid.length);
                    }
                } else if (enum_supp_variable == SuppVariable.IDVAR) {
                    if ("DM".equals(dataset_w_supp.dataset_name)) {
                        item_def_element.addAttribute("Length", "1");
                    } else {
                        item_def_element.addAttribute("Length", "5");
                    }
                } else if (enum_supp_variable == SuppVariable.IDVARVAL) {
                    if ("DM".equals(dataset_w_supp.dataset_name)) {
                        item_def_element.addAttribute("Length", "1");
                    } else if (seq != null) {
                        item_def_element.addAttribute("Length", seq.length);
                    }
                } else if (enum_supp_variable == SuppVariable.QNAM) {
                    int length = 1;
                    for (int i = 0; i < filtered_supp_variables.size(); ++i) {
                        filtered_supp_variable = (DefineVariableModel)filtered_supp_variables.get(i);
                        if (length >= filtered_supp_variable.variable_name.length()) continue;
                        length = filtered_supp_variable.variable_name.length();
                    }
                    item_def_element.addAttribute("Length", String.valueOf(length));
                } else if (enum_supp_variable == SuppVariable.QLABEL) {
                    int length = 1;
                    for (int i = 0; i < filtered_supp_variables.size(); ++i) {
                        filtered_supp_variable = (DefineVariableModel)filtered_supp_variables.get(i);
                        if (length >= filtered_supp_variable.variable_label.length()) continue;
                        length = filtered_supp_variable.variable_label.length();
                    }
                    item_def_element.addAttribute("Length", String.valueOf(length));
                } else if (enum_supp_variable == SuppVariable.QVAL) {
                    int length = 1;
                    for (int i = 0; i < filtered_supp_variables.size(); ++i) {
                        filtered_supp_variable = (DefineVariableModel)filtered_supp_variables.get(i);
                        int parsed_length = NumberUtils.toInt((String)DefineXmlWriter2.getRepeatLength(filtered_supp_variable.length, filtered_supp_variable.repeat_n_length));
                        if (length >= parsed_length) continue;
                        length = parsed_length;
                    }
                    item_def_element.addAttribute("Length", String.valueOf(length));
                } else if (enum_supp_variable == SuppVariable.QORIG) {
                    int length = 1;
                    for (int i = 0; i < filtered_supp_variables.size(); ++i) {
                        filtered_supp_variable = (DefineVariableModel)filtered_supp_variables.get(i);
                        if (length >= filtered_supp_variable.origin.length()) continue;
                        length = filtered_supp_variable.origin.length();
                    }
                    item_def_element.addAttribute("Length", String.valueOf(length));
                } else if (enum_supp_variable == SuppVariable.QEVAL) {
                    int length = 1;
                    for (int i = 0; i < filtered_supp_variables.size(); ++i) {
                        filtered_supp_variable = (DefineVariableModel)filtered_supp_variables.get(i);
                        if (length >= filtered_supp_variable.evaluator.length()) continue;
                        length = filtered_supp_variable.evaluator.length();
                    }
                    item_def_element.addAttribute("Length", String.valueOf(length));
                }
                item_def_element.addAttribute("SASFieldName", enum_supp_variable.name());
                XmlDocument.XmlElement item_desc_element = new XmlDocument.XmlElement("Description");
                item_def_element.addElement(item_desc_element);
                XmlDocument.XmlElement item_trans_element = new XmlDocument.XmlElement("TranslatedText");
                item_desc_element.addElement(item_trans_element);
                item_trans_element.addAttribute("xml:lang", "en");
                item_trans_element.addText(enum_supp_variable.label());
                XmlDocument.XmlElement origin_element = new XmlDocument.XmlElement("def:Origin");
                if (enum_supp_variable == SuppVariable.STUDYID) {
                    if (!"2.0.0".equals(this.DEFINE_VERSION) && ("CRF".equals(studyid.origin) || "eDT".equals(studyid.origin))) {
                        origin_element.addAttribute("Type", "Collected");
                        origin_element.addAttribute("Source", studyid.source);
                    } else if ("Collected".equals(studyid.origin)) {
                        if ("Vendor".equals(studyid.source)) {
                            origin_element.addAttribute("Type", "eDT");
                        } else {
                            origin_element.addAttribute("Type", "CRF");
                        }
                    } else {
                        origin_element.addAttribute("Type", studyid.origin);
                    }
                    item_def_element.addElement(origin_element);
                } else if (enum_supp_variable == SuppVariable.RDOMAIN) {
                    origin_element.addAttribute("Type", "Assigned");
                    item_def_element.addElement(origin_element);
                } else if (enum_supp_variable == SuppVariable.USUBJID) {
                    if (!"2.0.0".equals(this.DEFINE_VERSION) && ("CRF".equals(usubjid.origin) || "eDT".equals(usubjid.origin))) {
                        origin_element.addAttribute("Type", "Collected");
                        origin_element.addAttribute("Source", usubjid.source);
                    } else if ("Collected".equals(usubjid.origin)) {
                        if ("Vendor".equals(usubjid.source)) {
                            origin_element.addAttribute("Type", "eDT");
                        } else {
                            origin_element.addAttribute("Type", "CRF");
                        }
                    } else {
                        origin_element.addAttribute("Type", usubjid.origin);
                    }
                    item_def_element.addElement(origin_element);
                } else if (enum_supp_variable != SuppVariable.QVAL) {
                    origin_element.addAttribute("Type", "Assigned");
                    item_def_element.addElement(origin_element);
                }
                if (enum_supp_variable != SuppVariable.QVAL) continue;
                XmlDocument.XmlElement val_list_element = new XmlDocument.XmlElement("def:ValueListRef");
                item_def_element.addElement(val_list_element);
                String value_list_oid = DefineVariableModel.createValueListOid(dataset_name, enum_supp_variable.name());
                val_list_element.addAttribute("ValueListOID", value_list_oid);
                XmlDocument.XmlElement val_list_def_element = new XmlDocument.XmlElement("def:ValueListDef");
                md_ver_element.addElement(val_list_def_element);
                val_list_def_element.addAttribute("OID", value_list_oid);
                int val_order_number = 1;
                for (int i = 0; i < filtered_supp_variables.size(); ++i) {
                    DefineVariableModel is_supp_variable = (DefineVariableModel)filtered_supp_variables.get(i);
                    String value_name = is_supp_variable.variable_name;
                    XmlDocument.XmlElement value_element = new XmlDocument.XmlElement("ItemRef");
                    val_list_def_element.addElement(value_element);
                    String val_item_oid = DefineValueModel.createOid(dataset_name, enum_supp_variable.name(), value_name, "");
                    value_element.addAttribute("ItemOID", val_item_oid);
                    value_element.addAttribute("OrderNumber", String.valueOf(val_order_number++));
                    value_element.addAttribute("Mandatory", is_supp_variable.mandatory.name());
                    value_element.addAttribute("MethodOID", is_supp_variable.method_oid);
                    if (is_supp_variable.has_no_data == DefineModel.YorNull.Yes) {
                        value_element.addAttribute("def:HasNoData", DefineModel.YorNull.Yes.name());
                    }
                    XmlDocument.XmlElement wc_ref_element = new XmlDocument.XmlElement("def:WhereClauseRef");
                    value_element.addElement(wc_ref_element);
                    String wc_oid = DefineWCModel.createOid(dataset_name, enum_supp_variable.name(), value_name, "", "");
                    wc_ref_element.addAttribute("WhereClauseOID", wc_oid);
                    XmlDocument.XmlElement wc_def_element = new XmlDocument.XmlElement("def:WhereClauseDef");
                    md_ver_element.addElement(wc_def_element);
                    wc_def_element.addAttribute("OID", wc_oid);
                    XmlDocument.XmlElement range_check_element = new XmlDocument.XmlElement("RangeCheck");
                    wc_def_element.addElement(range_check_element);
                    range_check_element.addAttribute("Comparator", "EQ");
                    range_check_element.addAttribute("SoftHard", "Soft");
                    range_check_element.addAttribute("def:ItemOID", DefineVariableModel.createOid(dataset_name, "QNAM"));
                    XmlDocument.XmlElement check_value_element = new XmlDocument.XmlElement("CheckValue");
                    range_check_element.addElement(check_value_element);
                    check_value_element.addText(is_supp_variable.variable_name);
                    XmlDocument.XmlElement val_item_def_element = new XmlDocument.XmlElement("ItemDef");
                    md_ver_element.addElement(val_item_def_element);
                    val_item_def_element.addAttribute("OID", val_item_oid);
                    val_item_def_element.addAttribute("Name", value_name);
                    val_item_def_element.addAttribute("DataType", is_supp_variable.data_type);
                    val_item_def_element.addAttribute("Length", DefineXmlWriter2.getRepeatLength(is_supp_variable.length, is_supp_variable.repeat_n_length));
                    val_item_def_element.addAttribute("SignificantDigits", is_supp_variable.significant_digits);
                    val_item_def_element.addAttribute("SASFieldName", is_supp_variable.sas_field_name);
                    val_item_def_element.addAttribute("def:DisplayFormat", is_supp_variable.display_format);
                    val_item_def_element.addAttribute("def:CommentOID", is_supp_variable.comment_oid);
                    XmlDocument.XmlElement val_desc_element = new XmlDocument.XmlElement("Description");
                    val_item_def_element.addElement(val_desc_element);
                    XmlDocument.XmlElement val_trans_element = new XmlDocument.XmlElement("TranslatedText");
                    val_desc_element.addElement(val_trans_element);
                    val_trans_element.addAttribute("xml:lang", "en");
                    val_trans_element.addText(is_supp_variable.variable_label);
                    if (StringUtils.isNotEmpty((CharSequence)is_supp_variable.codelist)) {
                        XmlDocument.XmlElement cl_ref_element = new XmlDocument.XmlElement("CodeListRef");
                        val_item_def_element.addElement(cl_ref_element);
                        cl_ref_element.addAttribute("CodeListOID", DefineCodelistModel.createCodelistOid(is_supp_variable.codelist));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)is_supp_variable.origin)) {
                        XmlDocument.XmlElement val_origin_element = new XmlDocument.XmlElement("def:Origin");
                        val_item_def_element.addElement(val_origin_element);
                        if ("2.0.0".equals(this.DEFINE_VERSION)) {
                            if ("Collected".equals(is_supp_variable.origin)) {
                                if ("Vendor".equals(is_supp_variable.source)) {
                                    val_origin_element.addAttribute("Type", "eDT");
                                } else {
                                    val_origin_element.addAttribute("Type", "CRF");
                                }
                            } else {
                                val_origin_element.addAttribute("Type", is_supp_variable.origin);
                            }
                        } else {
                            if ("CRF".equals(is_supp_variable.origin) || "eDT".equals(is_supp_variable.origin)) {
                                val_origin_element.addAttribute("Type", "Collected");
                            } else {
                                val_origin_element.addAttribute("Type", is_supp_variable.origin);
                            }
                            val_origin_element.addAttribute("Source", is_supp_variable.source);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)is_supp_variable.predecessor)) {
                            XmlDocument.XmlElement desc_element2 = new XmlDocument.XmlElement("Description");
                            val_origin_element.addElement(desc_element2);
                            XmlDocument.XmlElement trans_element2 = new XmlDocument.XmlElement("TranslatedText");
                            desc_element2.addElement(trans_element2);
                            trans_element2.addAttribute("xml:lang", "en");
                            trans_element2.addText(is_supp_variable.predecessor);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)is_supp_variable.crf_page_type)) {
                            XmlDocument.XmlElement doc_ref_element = new XmlDocument.XmlElement("def:DocumentRef");
                            val_origin_element.addElement(doc_ref_element);
                            doc_ref_element.addAttribute("leafID", DefineDocumentModel.createOid(is_supp_variable.crf_id));
                            XmlDocument.XmlElement pdf_page_element = new XmlDocument.XmlElement("def:PDFPageRef");
                            doc_ref_element.addElement(pdf_page_element);
                            pdf_page_element.addAttribute("Type", is_supp_variable.crf_page_type);
                            pdf_page_element.addAttribute("PageRefs", is_supp_variable.crf_page_reference);
                            pdf_page_element.addAttribute("FirstPage", is_supp_variable.crf_first_page);
                            pdf_page_element.addAttribute("LastPage", is_supp_variable.crf_last_page);
                            if (!"2.0.0".equals(this.DEFINE_VERSION)) {
                                pdf_page_element.addAttribute("Title", is_supp_variable.crf_page_title);
                            }
                        }
                    }
                    if ("2.0.0".equals(this.DEFINE_VERSION) || !StringUtils.isNotEmpty((CharSequence)is_supp_variable.alias_context) || !StringUtils.isNotEmpty((CharSequence)is_supp_variable.alias_name)) continue;
                    XmlDocument.XmlElement alias_element = new XmlDocument.XmlElement("Alias");
                    val_item_def_element.addElement(alias_element);
                    alias_element.addAttribute("Context", is_supp_variable.alias_context);
                    alias_element.addAttribute("Name", is_supp_variable.alias_name);
                }
            }
            if (!"2.0.0".equals(this.DEFINE_VERSION) || Utils.isSplitDataset(this.config.e2dDatasetType, dataset_name)) {
                XmlDocument.XmlElement alias_element = new XmlDocument.XmlElement("Alias");
                ig_def_element.addElement(alias_element);
                alias_element.addAttribute("Context", "DomainDescription");
                alias_element.addAttribute("Name", dataset_w_supp.description);
            }
            if (!"2.0.0".equals(this.DEFINE_VERSION)) {
                XmlDocument.XmlElement class_element = new XmlDocument.XmlElement("def:Class");
                ig_def_element.addElement(class_element);
                class_element.addAttribute("Name", "RELATIONSHIP");
            }
            if ((vars_w_data = filtered_supp_variables.stream().filter(o -> o.has_no_data_derived == null).collect(Collectors.toList())).isEmpty()) continue;
            XmlDocument.XmlElement leaf_element = new XmlDocument.XmlElement("def:leaf");
            ig_def_element.addElement(leaf_element);
            leaf_element.addAttribute("ID", DefineDatasetModel.createLeafOid(dataset_name));
            leaf_element.addAttribute("xlink:href", dataset_name.toLowerCase() + ".xpt");
            XmlDocument.XmlElement title_element = new XmlDocument.XmlElement("def:title");
            leaf_element.addElement(title_element);
            title_element.addText(dataset_name.toLowerCase() + ".xpt");
        }
    }

    public static String getRepeatLength(String str_length, List<String> str_length_0_n) {
        String default_length = "";
        if (StringUtils.isEmpty((CharSequence)str_length)) {
            return default_length;
        }
        if (str_length_0_n == null || str_length_0_n.size() == 0) {
            return str_length;
        }
        if (str_length_0_n.isEmpty()) {
            return default_length;
        }
        return str_length_0_n.get(0);
    }

    public void writeout(XmlDocument xml_document) throws IOException {
        this.sw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.config.e2dOutputLocation, false), this.config.e2dXmlEncoding);
        this.writer = new BufferedWriter(this.sw);
        XmlDocument.XmlElement root_element = xml_document.getRootElement();
        XmlDocument.XmlElement study_element = root_element.getElementByName("Study");
        final XmlDocument.XmlElement md_ver_element = study_element.getElementByName("MetaDataVersion");
        final List<String> ordered_child_elements = Arrays.asList("def:AnnotatedCRF", "def:SupplementalDoc", "def:ValueListDef", "def:WhereClauseDef", "ItemGroupDef", "ItemDef", "CodeList", "MethodDef", "def:CommentDef", "def:leaf", "arm:AnalysisResultDisplays");
        md_ver_element.sortElements(new Comparator<XmlDocument.XmlElement>(){

            @Override
            public int compare(XmlDocument.XmlElement o1, XmlDocument.XmlElement o2) {
                if (StringUtils.equals((CharSequence)o1.getName(), (CharSequence)o2.getName())) {
                    return Integer.compare(md_ver_element.getElementIndex(o1), md_ver_element.getElementIndex(o2));
                }
                return Integer.compare(ordered_child_elements.indexOf(o1.getName()), ordered_child_elements.indexOf(o2.getName()));
            }
        });
        List<XmlDocument.XmlElement> codelist_elements = md_ver_element.getElementsByName("CodeList");
        for (XmlDocument.XmlElement codelist_element : codelist_elements) {
            final List<String> ordered_child_elements2 = Arrays.asList("EnumeratedItem", "CodeListItem", "ExternalCodeList", "Alias");
            codelist_element.sortElements(new Comparator<XmlDocument.XmlElement>(){

                @Override
                public int compare(XmlDocument.XmlElement o1, XmlDocument.XmlElement o2) {
                    if (StringUtils.equals((CharSequence)o1.getName(), (CharSequence)o2.getName())) {
                        return Integer.compare(md_ver_element.getElementIndex(o1), md_ver_element.getElementIndex(o2));
                    }
                    return Integer.compare(ordered_child_elements2.indexOf(o1.getName()), ordered_child_elements2.indexOf(o2.getName()));
                }
            });
        }
        this.writer.write(xml_document.toString());
        this.writer.close();
        this.sw.close();
    }

    private static String calendarToIso8601(Calendar cal) {
        return cal.get(1) + "-" + DefineXmlWriter2.twoDigits(cal.get(2) + 1) + "-" + DefineXmlWriter2.twoDigits(cal.get(5)) + "T" + DefineXmlWriter2.twoDigits(cal.get(11)) + ":" + DefineXmlWriter2.twoDigits(cal.get(12)) + ":" + DefineXmlWriter2.twoDigits(cal.get(13));
    }

    private static String twoDigits(int n) {
        if (n >= 0 && n <= 9) {
            return new String("0" + new Integer(n).toString());
        }
        return new Integer(n).toString();
    }

    public static enum SuppVariable {
        STUDYID("Study Identifier"),
        RDOMAIN("Related Domain Abbreviation"),
        USUBJID("Unique Subject Identifier"),
        IDVAR("Identifying Variable"),
        IDVARVAL("Identifying Variable Value"),
        QNAM("Qualifier Variable Name"),
        QLABEL("Qualifier Variable Label"),
        QVAL("Data Value"),
        QORIG("Origin"),
        QEVAL("Evaluator");

        private String label;

        private SuppVariable(String label) {
            this.label = label;
        }

        private String label() {
            return this.label;
        }
    }
}

