/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.exporter;

import com.fujitsu.tsc.desktop.exporter.TableNotFoundException;
import com.fujitsu.tsc.desktop.exporter.WhereClause;
import com.fujitsu.tsc.desktop.util.MetaDataReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelReader
implements MetaDataReader {
    private static Logger logger;
    private FileInputStream in;
    private Workbook workbook;
    private Hashtable<String, Sheet> sheetHash;
    private Hashtable<String, Iterator<Row>> iteratorHash;
    private Hashtable<String, List<String>> headerListHash;
    private String currentTableName;
    private Hashtable<String, WhereClause[]> clauseArrayHash;
    private Hashtable<String, HashSet<String>> uniqueKeysHash;
    private Hashtable<String, HashSet<String>> actualKeysHash;

    public ExcelReader(String dataSourceLocation, String tableName) throws TableNotFoundException, InvalidFormatException, IOException {
        logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
        this.init(dataSourceLocation, tableName);
    }

    public ExcelReader(String dataSourceLocation, String tableName, WhereClause[] clauseArray) throws TableNotFoundException, InvalidFormatException, IOException {
        logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
        this.init(dataSourceLocation, tableName);
        this.setWhereClause(tableName, clauseArray);
    }

    @Override
    public void setTable(String tableName, WhereClause[] clauseArray) throws TableNotFoundException {
        this.init(tableName);
        this.setWhereClause(tableName, clauseArray);
    }

    @Override
    public void setTable(String tableName) throws TableNotFoundException {
        this.init(tableName);
        this.clearWhereClause(tableName);
    }

    private void setWhereClause(String tableName, WhereClause[] clauseArray) {
        this.clauseArrayHash.put(tableName, clauseArray);
    }

    private void clearWhereClause(String tableName) {
        this.clauseArrayHash.remove(tableName);
    }

    @Override
    public void setUniqueKeys(String tableName, HashSet keys) {
        this.uniqueKeysHash.put(tableName, keys);
        this.actualKeysHash.put(tableName, new HashSet());
    }

    @Override
    public void clearUniqueKeys(String tableName) {
        this.uniqueKeysHash.remove(tableName);
        this.actualKeysHash.put(tableName, new HashSet());
    }

    @Override
    public Hashtable<String, String> read() {
        return this.read(this.currentTableName);
    }

    @Override
    public Hashtable<String, String> read(String sheetName) {
        Hashtable<String, String> hash = null;
        Row r = null;
        while (this.iteratorHash.get(sheetName).hasNext()) {
            hash = new Hashtable<String, String>();
            r = this.iteratorHash.get(sheetName).next();
            for (int i = 0; i < this.headerListHash.get(sheetName).size(); ++i) {
                if (hash.containsKey(this.headerListHash.get(sheetName).get(i))) continue;
                hash.put(this.headerListHash.get(sheetName).get(i), new DataFormatter().formatCellValue(r.getCell(i)));
            }
            if ((this.clauseArrayHash.get(sheetName) == null || this.meetsWhereClause(sheetName, hash)) && this.isUniqueRecord(sheetName, hash)) break;
            hash = null;
        }
        return hash;
    }

    @Override
    public String getTableName() {
        return this.currentTableName;
    }

    @Override
    public WhereClause[] getWhereClause() {
        return this.getWhereClause(this.currentTableName);
    }

    public WhereClause[] getWhereClause(String tableName) {
        return this.clauseArrayHash.get(tableName);
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
        }
    }

    private void init(String dataSourceLocation, String tableName) throws FileNotFoundException, TableNotFoundException {
        try {
            if (this.in != null) {
                this.in.close();
            }
            this.in = new FileInputStream(dataSourceLocation);
            this.workbook = new XSSFWorkbook((InputStream)this.in);
            this.sheetHash = new Hashtable();
            this.iteratorHash = new Hashtable();
            this.headerListHash = new Hashtable();
            this.clauseArrayHash = new Hashtable();
            this.uniqueKeysHash = new Hashtable();
            this.actualKeysHash = new Hashtable();
            this.init(tableName);
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
        }
    }

    private void init(String tableName) throws TableNotFoundException {
        this.clearUniqueKeys(tableName);
        if (this.sheetHash.get(tableName) != null) {
            this.currentTableName = tableName;
            this.iteratorHash.put(tableName, this.sheetHash.get(tableName).rowIterator());
            this.iteratorHash.get(tableName).next();
        } else {
            Sheet sheet = this.workbook.getSheet(tableName);
            if (sheet != null) {
                this.currentTableName = tableName;
                this.sheetHash.put(tableName, sheet);
                this.iteratorHash.put(tableName, sheet.rowIterator());
                Row r = this.iteratorHash.get(tableName).next();
                ArrayList<String> headerList = new ArrayList<String>();
                if (r != null) {
                    Cell cell = null;
                    int i = 0;
                    while ((cell = r.getCell(i)) != null) {
                        headerList.add(cell.getStringCellValue());
                        ++i;
                    }
                    this.headerListHash.put(tableName, headerList);
                }
            } else {
                throw new TableNotFoundException(tableName);
            }
        }
    }

    private boolean meetsWhereClause(String sheetName, Hashtable<String, String> hash) {
        WhereClause[] clauseArray = this.clauseArrayHash.get(sheetName);
        for (int i = 0; i < clauseArray.length; ++i) {
            if (clauseArray[i].getOperator() == WhereClause.Operator.EQ) {
                if (hash.get(clauseArray[i].getVariable()).equals(clauseArray[i].getValue())) continue;
                return false;
            }
            if (clauseArray[i].getOperator() == WhereClause.Operator.NE) {
                if (!hash.get(clauseArray[i].getVariable()).equals(clauseArray[i].getValue())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isUniqueRecord(String sheetName, Hashtable<String, String> hash) {
        Set uniqueKeys = this.uniqueKeysHash.get(sheetName);
        if (uniqueKeys == null || uniqueKeys.isEmpty()) {
            return true;
        }
        String keyString = "";
        for (String key : uniqueKeys) {
            if ("".equals(keyString)) {
                keyString = hash.get(key);
                continue;
            }
            keyString = keyString + "/" + hash.get(key);
        }
        Set actualKeys = this.actualKeysHash.get(sheetName);
        if (actualKeys.contains(keyString)) {
            return false;
        }
        actualKeys.add(keyString);
        return true;
    }
}

