/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.gui;

import com.fujitsu.tsc.desktop.gui.GuiConstants;
import com.fujitsu.tsc.desktop.util.Config;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = -1976452718671539689L;
    private static Logger logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
    private JLabel aboutSw;
    private JLabel swVersion;
    private JLabel url;
    private JLabel copyright;
    private JSeparator separator1;
    private JButton closeButton;

    public AboutDialog(JFrame frame) {
        super(frame);
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().setBackground(GuiConstants.COLOR_BG);
        this.setPreferredSize(new Dimension(GuiConstants.ABOUT_WIDTH, GuiConstants.ABOUT_HEIGHT));
        this.setResizable(false);
        this.aboutSw = new JLabel("About " + Config.SOFTWARE_NAME);
        this.aboutSw.setFont(new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE_TITLE));
        this.aboutSw.setForeground(GuiConstants.FONT_COLOR_TITLE);
        this.swVersion = new JLabel("Version: " + Config.SOFTWARE_VERSION);
        this.swVersion.setFont(new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE, GuiConstants.FONT_SIZE));
        this.swVersion.setForeground(GuiConstants.FONT_COLOR);
        this.url = new JLabel(GuiConstants.WEBSITE_URL);
        this.url.setFont(new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE, GuiConstants.FONT_SIZE));
        this.url.setForeground(Color.BLUE);
        this.url.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Desktop.isDesktopSupported() && AboutDialog.this.url.getText() != null) {
                    try {
                        Desktop.getDesktop().browse(new URI(AboutDialog.this.url.getText()));
                    }
                    catch (IOException ex) {
                        logger.error((Object)ex.getMessage());
                    }
                    catch (URISyntaxException ex) {
                        logger.error((Object)ex.getMessage());
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                AboutDialog.this.url.setCursor(new Cursor(12));
            }
        });
        this.separator1 = new JSeparator();
        this.copyright = new JLabel(GuiConstants.COPYRIGHT);
        this.copyright.setFont(new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE, GuiConstants.FONT_SIZE));
        this.copyright.setForeground(GuiConstants.FONT_COLOR);
        this.closeButton = new JButton("Close");
        this.closeButton.setFont(new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE, GuiConstants.FONT_SIZE));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.setVisible(false);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGap(GuiConstants.ABOUT_GAP_LEFT, GuiConstants.ABOUT_GAP_LEFT, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.aboutSw, -2, -1, -2).addComponent(this.swVersion, -2, -1, -2).addComponent(this.url, -2, -1, -2).addComponent(this.copyright, -2, -1, -2)).addComponent(this.separator1).addGroup(groupLayout.createSequentialGroup().addGap(GuiConstants.ABOUT_GAP_LEFT, GuiConstants.ABOUT_GAP_LEFT, Short.MAX_VALUE).addComponent(this.closeButton))).addGap(GuiConstants.ABOUT_GAP_LEFT, GuiConstants.ABOUT_GAP_LEFT, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(GuiConstants.ABOUT_GAP_TOP, GuiConstants.ABOUT_GAP_TOP, Short.MAX_VALUE).addComponent(this.aboutSw, -2, -1, -2).addGap(GuiConstants.ABOUT_GAP_VERTICAL).addComponent(this.swVersion, -2, -1, -2).addGap(GuiConstants.ABOUT_GAP_VERTICAL).addComponent(this.url, -2, -1, -2).addGap(GuiConstants.ABOUT_GAP_VERTICAL).addComponent(this.copyright, -2, -1, -2).addGap(GuiConstants.ABOUT_GAP_VERTICAL).addComponent(this.separator1, -2, -1, -2).addGap(GuiConstants.ABOUT_GAP_VERTICAL).addComponent(this.closeButton, -2, -1, -2).addGap(GuiConstants.ABOUT_GAP_BOTTOM, GuiConstants.ABOUT_GAP_BOTTOM, Short.MAX_VALUE));
        this.pack();
    }
}

