/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.gui;

import com.fujitsu.tsc.desktop.exporter.DefineXmlWriter2;
import com.fujitsu.tsc.desktop.exporter.model.XmlDocument;
import com.fujitsu.tsc.desktop.gui.EditorPaneAppender;
import com.fujitsu.tsc.desktop.gui.FilePathTransferHandler;
import com.fujitsu.tsc.desktop.gui.GuiConstants;
import com.fujitsu.tsc.desktop.gui.GuiMain;
import com.fujitsu.tsc.desktop.importer.SdtmAdamSpecImporter;
import com.fujitsu.tsc.desktop.importer.models.DefineModel;
import com.fujitsu.tsc.desktop.util.Config;
import com.fujitsu.tsc.desktop.util.ErrorLog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DefineExportPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
    private Config config;
    private GuiMain parent;
    private Font titleFont;
    private Font defaultFont;
    private Font submitFont;
    private JPanel headerPanel;
    private JLabel titleL;
    private JPanel bodyPanel;
    private JLabel defineVersionL;
    protected JComboBox<String> defineVersionCB;
    private JLabel datasetTypeL;
    protected JComboBox<String> datasetTypeCB;
    protected JCheckBox includeResultMetadataCB;
    private JLabel xmlEncodingL;
    protected JComboBox<String> xmlEncodingCB;
    private JLabel stylesheetLocationL;
    protected JTextField stylesheetLocationTF;
    private JLabel dataSourceLocationL;
    protected JTextField dataSourceLocationTF;
    private JLabel outputLocationL;
    protected JTextField outputLocationTF;
    private JButton browseButton1;
    private JButton clearButton1;
    private JButton browseButton2;
    private JButton clearButton2;
    protected JFileChooser fileChooser1;
    private FileNameExtensionFilter filter1;
    protected JFileChooser fileChooser2;
    private JPanel footerPanel;
    private JButton runButton;

    public DefineExportPanel(GuiMain parent, Config config) {
        this.config = config;
        this.parent = parent;
        this.titleFont = new Font(GuiConstants.FONT_NAME_TITLE, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE_TITLE);
        this.defaultFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE, GuiConstants.FONT_SIZE);
        this.submitFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE);
        this.setBackground(GuiConstants.COLOR_BORDER);
        this.initHeaderPanel();
        this.initBodyPanel();
        this.initFooterPanel();
        GroupLayout panelLayout = new GroupLayout(this);
        this.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerPanel, -2, -1, Short.MAX_VALUE).addComponent(this.bodyPanel, -2, -1, Short.MAX_VALUE).addComponent(this.footerPanel, -2, -1, Short.MAX_VALUE));
        panelLayout.setVerticalGroup(panelLayout.createSequentialGroup().addGap(GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK).addComponent(this.headerPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.bodyPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.footerPanel, -2, -1, -2));
    }

    private void initHeaderPanel() {
        this.headerPanel = new JPanel();
        this.headerPanel.setBackground(GuiConstants.COLOR_BG);
        this.titleL = new JLabel("Convert from Excel to Define-XML");
        this.titleL.setFont(this.titleFont);
        this.titleL.setForeground(GuiConstants.FONT_COLOR_TITLE);
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        headerPanelLayout.setAutoCreateContainerGaps(true);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, Short.MAX_VALUE));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, -2));
    }

    private void initBodyPanel() {
        this.bodyPanel = new JPanel();
        this.bodyPanel.setBackground(GuiConstants.COLOR_BG);
        this.defineVersionL = new JLabel("Define-XML Version:");
        this.defineVersionCB = new JComboBox<String>(Config.DEFINE_VERSIONS);
        this.datasetTypeL = new JLabel("Dataset Type:");
        this.datasetTypeCB = new JComboBox<String>(Config.DatasetType.stringValues());
        this.includeResultMetadataCB = new JCheckBox("Include Result Metadata");
        this.includeResultMetadataCB.setOpaque(false);
        this.xmlEncodingL = new JLabel("XML Encoding:");
        this.xmlEncodingCB = new JComboBox<String>(Config.ENCODING);
        this.stylesheetLocationL = new JLabel("Stylesheet Location (.xsl):");
        this.stylesheetLocationTF = new JTextField("");
        this.dataSourceLocationL = new JLabel("Data Source Location:");
        this.dataSourceLocationTF = new JTextField("");
        this.outputLocationL = new JLabel("Output Location:");
        this.outputLocationTF = new JTextField("");
        this.browseButton1 = new JButton("Browse");
        this.clearButton1 = new JButton("Clear");
        this.browseButton2 = new JButton("Browse");
        this.clearButton2 = new JButton("Clear");
        this.fileChooser1 = new JFileChooser();
        this.filter1 = new FileNameExtensionFilter("EXCEL (.xlsx)", "xlsx");
        this.fileChooser1.setFileFilter(this.filter1);
        this.dataSourceLocationTF.setTransferHandler(new FilePathTransferHandler(this.dataSourceLocationTF, this.fileChooser1, this.filter1));
        this.fileChooser2 = new JFileChooser();
        this.fileChooser2.setFileSelectionMode(1);
        this.outputLocationTF.setTransferHandler(new FilePathTransferHandler(this.outputLocationTF, this.fileChooser2));
        this.datasetTypeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String strType = (String)((JComboBox)e.getSource()).getSelectedItem();
                if (GuiConstants.getDatasetTypeValue(strType) == Config.DatasetType.ADaM) {
                    DefineExportPanel.this.includeResultMetadataCB.setVisible(true);
                } else {
                    DefineExportPanel.this.includeResultMetadataCB.setVisible(false);
                }
            }
        });
        this.browseButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = DefineExportPanel.this.fileChooser1.showOpenDialog(DefineExportPanel.this);
                if (selected == 0) {
                    DefineExportPanel.this.dataSourceLocationTF.setText(DefineExportPanel.this.fileChooser1.getSelectedFile().getPath());
                } else if (selected == 1 || selected == -1) {
                    // empty if block
                }
            }
        });
        this.clearButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefineExportPanel.this.dataSourceLocationTF.setText("");
            }
        });
        this.browseButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = DefineExportPanel.this.fileChooser2.showOpenDialog(DefineExportPanel.this);
                if (selected == 0) {
                    DefineExportPanel.this.outputLocationTF.setText(DefineExportPanel.this.fileChooser2.getSelectedFile().getPath() + System.getProperty("file.separator") + GuiConstants.DEFINE_FILE_NAME);
                } else if (selected == 1 || selected == -1) {
                    // empty if block
                }
            }
        });
        this.clearButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefineExportPanel.this.outputLocationTF.setText("");
            }
        });
        this.defineVersionL.setFont(this.defaultFont);
        this.defineVersionCB.setFont(this.defaultFont);
        this.datasetTypeL.setFont(this.defaultFont);
        this.datasetTypeCB.setFont(this.defaultFont);
        this.includeResultMetadataCB.setFont(this.defaultFont);
        this.xmlEncodingL.setFont(this.defaultFont);
        this.xmlEncodingCB.setFont(this.defaultFont);
        this.stylesheetLocationL.setFont(this.defaultFont);
        this.stylesheetLocationTF.setForeground(GuiConstants.FONT_COLOR_ON_WHITE);
        this.dataSourceLocationL.setFont(this.defaultFont);
        this.dataSourceLocationTF.setEditable(false);
        this.outputLocationL.setFont(this.defaultFont);
        this.outputLocationTF.setForeground(GuiConstants.FONT_COLOR_ON_WHITE);
        this.browseButton1.setFont(this.defaultFont);
        this.clearButton1.setFont(this.defaultFont);
        this.browseButton2.setFont(this.defaultFont);
        this.clearButton2.setFont(this.defaultFont);
        this.defineVersionCB.setSelectedItem(this.config.e2dDefineVersion);
        this.datasetTypeCB.setSelectedItem(this.config.e2dDatasetType.name());
        if (this.config.e2dIncludeResultMetadata) {
            this.includeResultMetadataCB.setSelected(true);
        }
        this.xmlEncodingCB.setSelectedItem(this.config.e2dXmlEncoding);
        this.stylesheetLocationTF.setText(this.config.e2dStylesheetLocation);
        this.dataSourceLocationTF.setText(this.config.e2dDataSourceLocation);
        this.outputLocationTF.setText(this.config.e2dOutputLocation);
        GroupLayout bodyPanelLayout = new GroupLayout(this.bodyPanel);
        this.bodyPanel.setLayout(bodyPanelLayout);
        bodyPanelLayout.setHorizontalGroup(bodyPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.BODY_GAP_LEFT, GuiConstants.BODY_GAP_LEFT).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defineVersionL).addComponent(this.datasetTypeL).addComponent(this.xmlEncodingL).addComponent(this.stylesheetLocationL).addComponent(this.dataSourceLocationL).addComponent(this.outputLocationL)).addGap(GuiConstants.BODY_GAP_HORIZONTAL, GuiConstants.BODY_GAP_HORIZONTAL, GuiConstants.BODY_GAP_HORIZONTAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defineVersionCB, -2, 160, -2).addGroup(bodyPanelLayout.createSequentialGroup().addComponent(this.datasetTypeCB, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.includeResultMetadataCB)).addComponent(this.xmlEncodingCB, -2, 160, -2).addComponent(this.stylesheetLocationTF, -1, 255, Short.MAX_VALUE).addComponent(this.dataSourceLocationTF, -1, 255, Short.MAX_VALUE).addComponent(this.outputLocationTF, -1, 255, Short.MAX_VALUE)).addGap(GuiConstants.BODY_GAP_HORIZONTAL, GuiConstants.BODY_GAP_HORIZONTAL, GuiConstants.BODY_GAP_HORIZONTAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browseButton1).addComponent(this.browseButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.clearButton1).addComponent(this.clearButton2)).addContainerGap(GuiConstants.BODY_GAP_RIGHT, GuiConstants.BODY_GAP_RIGHT));
        bodyPanelLayout.setVerticalGroup(bodyPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.BODY_GAP_TOP, GuiConstants.BODY_GAP_TOP).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defineVersionL).addComponent(this.defineVersionCB, -2, -1, -2)).addGap(GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.datasetTypeL).addComponent(this.datasetTypeCB, -2, -1, -2).addComponent(this.includeResultMetadataCB)).addGap(GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.xmlEncodingL).addComponent(this.xmlEncodingCB, -2, -1, -2)).addGap(GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stylesheetLocationL).addComponent(this.stylesheetLocationTF, -2, -1, -2)).addGap(GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataSourceLocationL).addComponent(this.dataSourceLocationTF, -2, -1, -2).addComponent(this.browseButton1).addComponent(this.clearButton1)).addGap(GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputLocationL).addComponent(this.outputLocationTF, -2, -1, -2).addComponent(this.browseButton2).addComponent(this.clearButton2)).addContainerGap(GuiConstants.BODY_GAP_BOTTOM, GuiConstants.BODY_GAP_BOTTOM));
    }

    private void initFooterPanel() {
        this.footerPanel = new JPanel();
        this.footerPanel.setBackground(GuiConstants.COLOR_BG);
        this.runButton = new JButton("Generate");
        this.runButton.setFont(this.submitFont);
        this.runButton.setForeground(GuiConstants.COLOR_BTN_FG_SUBMIT);
        this.runButton.setBackground(GuiConstants.COLOR_BTN_BG_SUBMIT);
        this.runButton.setActionCommand("Generate");
        this.runButton.addActionListener(this);
        GroupLayout footerPanelLayout = new GroupLayout(this.footerPanel);
        footerPanelLayout.setAutoCreateContainerGaps(true);
        this.footerPanel.setLayout(footerPanelLayout);
        footerPanelLayout.setHorizontalGroup(footerPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.FOOTER_GAP_LEFT, Short.MAX_VALUE).addComponent(this.runButton));
        footerPanelLayout.setVerticalGroup(footerPanelLayout.createSequentialGroup().addComponent(this.runButton).addContainerGap(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    public String validateEntry() {
        if (this.defineVersionCB.getSelectedItem() == null) {
            return "Define-XML Version cannot be blank.";
        }
        if (this.datasetTypeCB.getSelectedItem() == null) {
            return "Dataset Type cannot be blank.";
        }
        if (this.xmlEncodingCB.getSelectedItem() == null) {
            return "XML Encoding cannot be blank.";
        }
        if (StringUtils.isEmpty((CharSequence)this.stylesheetLocationTF.getText())) {
            return "Stylesheet Location cannot be blank.";
        }
        if (StringUtils.isEmpty((CharSequence)this.dataSourceLocationTF.getText())) {
            return "Data Source Location cannot be blank.";
        }
        if (StringUtils.isEmpty((CharSequence)this.outputLocationTF.getText())) {
            return "Output Location cannot be blank.";
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Generate".equals(command)) {
            String errMessage = this.validateEntry();
            if (StringUtils.isEmpty((CharSequence)errMessage)) {
                this.parent.showPanel(this.parent.defineExportResultPanel);
                this.parent.defineExportResultPanel.clearBodyPanel();
                Runnable exportDefine = new Runnable(){

                    @Override
                    public void run() {
                        EditorPaneAppender epAppender = new EditorPaneAppender();
                        epAppender.setEditorPane(((DefineExportPanel)DefineExportPanel.this).parent.defineExportResultPanel.gResultEditorPane);
                        epAppender.setLayout((Layout)new PatternLayout("%-5p %c{2} - %m%n"));
                        logger.addAppender((Appender)epAppender);
                        ((DefineExportPanel)DefineExportPanel.this).config.e2dDefineVersion = DefineExportPanel.this.defineVersionCB.getSelectedItem().toString();
                        ((DefineExportPanel)DefineExportPanel.this).config.e2dDatasetType = Config.DatasetType.valueOf(DefineExportPanel.this.datasetTypeCB.getSelectedItem().toString());
                        ((DefineExportPanel)DefineExportPanel.this).config.e2dIncludeResultMetadata = DefineExportPanel.this.includeResultMetadataCB.isSelected();
                        ((DefineExportPanel)DefineExportPanel.this).config.e2dXmlEncoding = DefineExportPanel.this.xmlEncodingCB.getSelectedItem().toString();
                        ((DefineExportPanel)DefineExportPanel.this).config.e2dStylesheetLocation = DefineExportPanel.this.stylesheetLocationTF.getText();
                        ((DefineExportPanel)DefineExportPanel.this).config.e2dDataSourceLocation = DefineExportPanel.this.dataSourceLocationTF.getText();
                        ((DefineExportPanel)DefineExportPanel.this).config.e2dOutputLocation = DefineExportPanel.this.outputLocationTF.getText();
                        XSSFWorkbook workbook = null;
                        logger.info((Object)"Opening the source Excel file...");
                        try {
                            File sourceFile = new File(((DefineExportPanel)DefineExportPanel.this).config.e2dDataSourceLocation);
                            workbook = new XSSFWorkbook(sourceFile);
                            logger.info((Object)"Loading...");
                            SdtmAdamSpecImporter importer = new SdtmAdamSpecImporter(DefineExportPanel.this.config, (Workbook)workbook);
                            List<ErrorLog> error_logs = importer.parse();
                            if (error_logs.isEmpty()) {
                                logger.info((Object)"Loading completed.");
                            } else {
                                List error_log_errors = error_logs.stream().filter(o -> o.getErrorLevel() == ErrorLog.ErrorLevel.ERROR).collect(Collectors.toList());
                                if (error_log_errors.isEmpty()) {
                                    logger.warn((Object)"The following warning(s) found during loading:");
                                    for (ErrorLog error_log : error_logs) {
                                        logger.warn((Object)error_log.print());
                                    }
                                    logger.info((Object)"Continue processing...");
                                } else {
                                    logger.error((Object)"The following error(s) found during loading:");
                                    for (ErrorLog error_log_error : error_log_errors) {
                                        logger.error((Object)error_log_error.print());
                                    }
                                    logger.error((Object)"Processing suspended.");
                                    return;
                                }
                            }
                            if ("2.0.0".equals(((DefineExportPanel)DefineExportPanel.this).config.e2dDefineVersion)) {
                                logger.info((Object)"Writing Define-XML 2.0 to the target file...");
                            } else {
                                logger.info((Object)"Writing Define-XML 2.1 to the target file...");
                            }
                            DefineXmlWriter2 writer = new DefineXmlWriter2(DefineExportPanel.this.config);
                            DefineModel define = importer.getDefineModel();
                            XmlDocument xml_document = writer.bind(define);
                            writer.writeout(xml_document);
                            logger.info((Object)"Define-XML has been successfully created.");
                            ((DefineExportPanel)DefineExportPanel.this).parent.defineExportResultPanel.outputLocationUrl.setText(new File(DefineExportPanel.this.outputLocationTF.getText()).getCanonicalPath());
                            logger.removeAppender((Appender)epAppender);
                        }
                        catch (Exception ex) {
                            logger.error((Object)ExceptionUtils.getStackTrace((Throwable)ex));
                            logger.removeAppender((Appender)epAppender);
                        }
                    }
                };
                new Thread(exportDefine).start();
            } else {
                Object[] options = new String[]{"OK"};
                JLabel errMessageL = new JLabel(errMessage);
                errMessageL.setFont(this.defaultFont);
                JOptionPane.showOptionDialog(this.parent, errMessageL, "Message", -1, 2, null, options, "OK");
            }
        }
    }
}

