/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer;

import com.fujitsu.tsc.desktop.importer.EdtSpecCreator;
import com.fujitsu.tsc.desktop.importer.models.EdcKeysModel;
import com.fujitsu.tsc.desktop.importer.models.OdmCodelistModel;
import com.fujitsu.tsc.desktop.importer.models.OdmFieldModel;
import com.fujitsu.tsc.desktop.importer.models.OdmFormModel;
import com.fujitsu.tsc.desktop.importer.models.OdmModel;
import com.fujitsu.tsc.desktop.importer.models.OdmStudyModel;
import com.fujitsu.tsc.desktop.util.Config;
import com.opencsv.exceptions.CsvException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CrfSpecCreator {
    private static final int MAX_ROW_SIZE = 10000;
    private static List<RegexDateMatcher> dateMatchers = new ArrayList<RegexDateMatcher>();
    private static Pattern integerRegex;
    private static Pattern floatRegex;
    private Config config;
    private OdmModel crf;
    private OdmStudyModel study;
    private File[] srcFiles;
    private List<String[]> lines = new ArrayList<String[]>();

    public CrfSpecCreator(Config config, OdmStudyModel params, File[] srcFiles) {
        this.config = config;
        this.crf = new OdmModel();
        this.crf.put(params);
        this.study = this.crf.getStudy();
        this.srcFiles = srcFiles;
    }

    public OdmModel create() throws IOException, CsvException {
        for (int i = 0; i < this.srcFiles.length; ++i) {
            File srcFile = this.srcFiles[i];
            String form_id = srcFile.getName().substring(0, srcFile.getName().lastIndexOf(46)).toUpperCase();
            OdmFormModel.OdmFormPk formKey = new OdmFormModel.OdmFormPk(form_id);
            OdmFormModel form = new OdmFormModel(formKey);
            form.ordinal = i + 1;
            form.name = form_id;
            this.crf.put(formKey, form);
            this.lines = EdtSpecCreator.readToStringArray(srcFile, this.study.encoding, this.study.delimiter, this.study.text_qualifier);
            ArrayList<Integer> codeColumns = new ArrayList<Integer>();
            for (int j = 0; j < this.columnSize(); ++j) {
                String field_id = this.getColumnName(j);
                OdmFieldModel.OdmFieldPk fieldKey = new OdmFieldModel.OdmFieldPk(form_id, "", field_id);
                OdmFieldModel field = new OdmFieldModel(fieldKey);
                field.ordinal = j + 1;
                field.form_name = form.name;
                field.name = field_id;
                field.level = 0;
                field.mandatory = "No";
                if (this.lines != null && this.lines.size() > this.study.header_line) {
                    ColumnType columnType = this.getColumnType(j);
                    switch (columnType.getType()) {
                        case DATE: {
                            field.data_type = "datetime";
                            this.updateEdcDateFormat(columnType.detail);
                            this.updateEdcUnkDateTimeText(StringUtils.defaultString((String)this.searchUnkDateTime(j, columnType.getDetail())));
                            break;
                        }
                        case STRING: {
                            field.data_type = "text";
                            codeColumns.add(j);
                            field.crf_codelist = field_id;
                            break;
                        }
                        case INTEGER: {
                            field.data_type = "integer";
                            codeColumns.add(j);
                            field.crf_codelist = field_id;
                            break;
                        }
                        case FLOAT: {
                            field.data_type = "float";
                            break;
                        }
                    }
                } else {
                    field.data_type = "text";
                }
                this.crf.put(fieldKey, field);
            }
            for (Integer colIndex : codeColumns) {
                LinkedHashSet<Object> userCodes = new LinkedHashSet<Object>();
                for (int r = this.study.header_line; r < this.lines.size(); ++r) {
                    String txt = this.getStr(r, colIndex);
                    if (!StringUtils.isNotBlank((CharSequence)txt)) continue;
                    userCodes.add(txt);
                }
                boolean all_empty = true;
                for (String string : userCodes) {
                    if (StringUtils.isEmpty((CharSequence)string)) continue;
                    all_empty = false;
                    break;
                }
                if (all_empty) {
                    OdmFieldModel.OdmFieldPk fieldKey = new OdmFieldModel.OdmFieldPk(form_id, "", this.getColumnName(colIndex));
                    OdmFieldModel odmFieldModel = this.crf.get(fieldKey);
                    if (odmFieldModel == null) continue;
                    odmFieldModel.crf_codelist = "";
                    continue;
                }
                for (String string : userCodes) {
                    OdmCodelistModel.OdmCodelistPk codelistKey = new OdmCodelistModel.OdmCodelistPk(this.getColumnName(colIndex), string);
                    OdmCodelistModel codelist = new OdmCodelistModel(codelistKey);
                    codelist.codelist_label = codelist.codelist;
                    codelist.data_type = this.getColumnType(colIndex).getType() == CType.STRING ? "text" : "integer";
                    codelist.submission_value = codelist.user_code;
                    this.crf.put(codelistKey, codelist);
                }
            }
        }
        HashMap field_id_map = new HashMap();
        List<OdmFieldModel> fields = this.crf.listField();
        for (OdmFieldModel field : fields) {
            List cached_fields = (List)field_id_map.get(field.field_id);
            if (cached_fields == null) {
                ArrayList<OdmFieldModel> new_list = new ArrayList<OdmFieldModel>();
                new_list.add(field);
                field_id_map.put(field.field_id, new_list);
                continue;
            }
            cached_fields.add(field);
        }
        List<OdmFormModel> forms = this.crf.listForm();
        int form_count = forms.size();
        Set common_fields = field_id_map.keySet();
        Iterator iterator = common_fields.iterator();
        while (iterator.hasNext()) {
            String common_field = (String)iterator.next();
            int count = ((List)field_id_map.get(common_field)).size();
            if (count >= form_count / 2) continue;
            iterator.remove();
        }
        List common_fields_list = new ArrayList(common_fields).stream().sorted().collect(Collectors.toList());
        EdcKeysModel edc_keys = new EdcKeysModel();
        edc_keys.form_id = "<filename>";
        for (int i = 0; i < common_fields_list.size(); ++i) {
            edc_keys.common_vars = i == 0 ? (String)common_fields_list.get(0) : edc_keys.common_vars + this.config.valueDelimiter + (String)common_fields_list.get(i);
        }
        this.crf.put(edc_keys);
        for (OdmFieldModel field : fields) {
            if (!common_fields.contains(field.field_id)) continue;
            field.is_log = "TRUE";
        }
        return this.crf;
    }

    private String getStr(int rowIndex, int colIndex) {
        String rtn = this.lines.get(rowIndex)[colIndex];
        return rtn;
    }

    private String searchUnkDateTime(int columnIdx, String format) {
        List<String> MON = Arrays.asList("JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC");
        RegexDateMatcher matcher = null;
        for (RegexDateMatcher dateMatcher : dateMatchers) {
            if (!dateMatcher.getFormat().equals(format)) continue;
            matcher = dateMatcher;
            break;
        }
        for (int i = this.study.header_line; i < this.lines.size(); ++i) {
            String txt = this.getStr(i, columnIdx);
            if (StringUtils.isEmpty((CharSequence)txt)) continue;
            List<String> strs = matcher.getMatchStrings(txt);
            for (String str : strs) {
                if (StringUtils.isNumeric((CharSequence)str) || MON.contains(str.toUpperCase())) continue;
                return str;
            }
        }
        return null;
    }

    private void updateEdcDateFormat(String str) {
        if (StringUtils.isEmpty((CharSequence)this.study.edc_date_format) && StringUtils.isNotEmpty((CharSequence)str)) {
            this.study.edc_date_format = str;
        }
    }

    private void updateEdcUnkDateTimeText(String str) {
        if (StringUtils.isEmpty((CharSequence)this.study.edc_unk_date_time_text) && StringUtils.isNotEmpty((CharSequence)str)) {
            this.study.edc_unk_date_time_text = str;
        }
    }

    private ColumnType getColumnType(int columnIdx) {
        String txt = this.getStr(this.study.header_line, columnIdx);
        if (integerRegex.matcher(txt).find()) {
            return new ColumnType(CType.INTEGER);
        }
        if (floatRegex.matcher(txt).find()) {
            return new ColumnType(CType.FLOAT);
        }
        for (RegexDateMatcher matcher : dateMatchers) {
            if (!matcher.isMatch(txt)) continue;
            return new ColumnType(CType.DATE, matcher.getFormat());
        }
        return new ColumnType(CType.STRING);
    }

    private String getColumnName(int columnIdx) {
        if (this.study.header_line >= 1) {
            return this.getStr(0, columnIdx);
        }
        return "Column" + columnIdx;
    }

    private int columnSize() {
        return this.lines.get(0).length;
    }

    static {
        dateMatchers.add(new RegexDateMatcher("^(\\d{4})/(\\d{2})/(\\d{2})$", "YYYY/MM/DD"));
        dateMatchers.add(new RegexDateMatcher("^(\\d{4})/(\\d{2})/(\\d{2}) (\\d{2}):(\\d{2}):(\\d{2})$", "YYYY/MM/DD HH24:MI:SS"));
        dateMatchers.add(new RegexDateMatcher("^(\\d{4})-(\\d{2})-(\\d{2})$", "YYYY-MM-DD"));
        dateMatchers.add(new RegexDateMatcher("^(\\d{4})-(\\d{2})-(\\d{2})\"T\"(\\d{2}):(\\d{2}):(\\d{2})$", "YYYY-MM-DD\"T\"HH24:MI:SS"));
        dateMatchers.add(new RegexDateMatcher("^(\\d{2})(\\D{3})(\\d{4}) (\\d{2}):(\\d{2}):(\\d{2})$", "DDMONYYYY HH24:MI:SS"));
        dateMatchers.add(new RegexDateMatcher("^(\\d{2})(\\D{3})(\\d{4})$", "DDMONYYYY"));
        integerRegex = Pattern.compile("^[1-9]+?\\d*?$");
        floatRegex = Pattern.compile("^[+-]?\\d+?\\.\\d+?$");
    }

    public static enum YorN {
        Yes,
        No;

    }

    private static class RegexDateMatcher {
        private Pattern pattern;
        private String format;

        public RegexDateMatcher(String regex, String format) {
            this.format = format;
            this.pattern = Pattern.compile(regex);
        }

        boolean isMatch(String str) {
            return this.pattern.matcher(str).find();
        }

        List<String> getMatchStrings(String str) {
            Matcher matcher = this.pattern.matcher(str);
            ArrayList<String> rtn = new ArrayList<String>();
            boolean res = matcher.find();
            if (res) {
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    rtn.add(matcher.group(i + 1));
                }
            }
            return rtn;
        }

        public String getFormat() {
            return this.format;
        }
    }

    private static enum CType {
        DATE,
        STRING,
        INTEGER,
        FLOAT;

    }

    private class ColumnType {
        private final CType ctype;
        private String detail;

        public ColumnType(CType cType) {
            this.ctype = cType;
        }

        public ColumnType(CType cType, String detail) {
            this.ctype = cType;
            this.detail = detail;
        }

        public CType getType() {
            return this.ctype;
        }

        public String getDetail() {
            return this.detail;
        }
    }
}

