/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer;

import com.fujitsu.tsc.desktop.importer.OdmImportError;
import com.fujitsu.tsc.desktop.importer.models.OdmCodelistModel;
import com.fujitsu.tsc.desktop.importer.models.OdmConditionModel;
import com.fujitsu.tsc.desktop.importer.models.OdmEventFormModel;
import com.fujitsu.tsc.desktop.importer.models.OdmEventModel;
import com.fujitsu.tsc.desktop.importer.models.OdmFieldModel;
import com.fujitsu.tsc.desktop.importer.models.OdmFormModel;
import com.fujitsu.tsc.desktop.importer.models.OdmMethodModel;
import com.fujitsu.tsc.desktop.importer.models.OdmModel;
import com.fujitsu.tsc.desktop.importer.models.OdmStudyModel;
import com.fujitsu.tsc.desktop.importer.models.OdmUnitModel;
import com.fujitsu.tsc.desktop.util.Config;
import com.fujitsu.tsc.desktop.util.ErrorInfo;
import com.fujitsu.tsc.desktop.util.TscStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OdmXmlReader
extends DefaultHandler {
    private static Logger logger;
    private static String MESSAGE_ORPHANED;
    private Config config;
    private Locator locator;
    private List<ErrorInfo> errors = new ArrayList<ErrorInfo>();
    private TscStack path_stack = new TscStack();
    private OdmModel odm = new OdmModel();
    private String study_oid = "";
    private String metadata_version_oid = "";
    private String cached_study_oid = "";
    private String cached_metadata_version_oid = "";
    private String cached_unit_id = "";
    private String cached_xml_lang = "";
    private int cached_unit_ordinal = 1;
    private Map<String, OdmUnitModel> cached_units = new HashMap<String, OdmUnitModel>();
    private String cached_event_id = "";
    private int cached_event_ordinal = 1;
    private Map<String, OdmEventModel> cached_events = new HashMap<String, OdmEventModel>();
    private String cached_form_id = "";
    private int cached_eventform_ordinal = 1;
    private Map<String, OdmEventFormModel> cached_eventforms = new HashMap<String, OdmEventFormModel>();
    private int cached_form_ordinal = 1;
    private String cached_itemgroup_id = "";
    private int cached_itemgroup_ordinal = 1;
    private String cached_item_id = "";
    private int cached_item_ordinal = 1;
    private String cached_codelist_id = "";
    private String cached_user_code = "";
    private int cached_codelist_ordinal = 1;
    private Map<String, OdmCodelistModel> cached_codelists = new HashMap<String, OdmCodelistModel>();
    private String cached_method_id = "";
    private int cached_method_ordinal = 1;
    private String cached_condition_id = "";
    private int cached_condition_ordinal = 1;

    public OdmXmlReader(Config config, String study_oid, String metadata_version_oid) {
        logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
        this.config = config;
        this.study_oid = study_oid;
        this.metadata_version_oid = metadata_version_oid;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) {
        this.path_stack.push(qName);
        this.bindAttributes(this.path_stack.getPath(), attr);
    }

    private void bindAttributes(String path, Attributes attr) {
        if ("/ODM/".equals(path)) {
            OdmStudyModel study = new OdmStudyModel();
            study.file_oid = attr.getValue("FileOID");
            study.odm_version = attr.getValue("ODMVersion");
            study.file_type = attr.getValue("FileType");
            study.as_of_date_time = attr.getValue("AsOfDateTime");
            study.originator = attr.getValue("Originator");
            study.source_system = attr.getValue("ddedcp:SourceDataFrom");
            if (StringUtils.isEmpty((CharSequence)study.source_system)) {
                study.source_system = attr.getValue("SourceSystem");
            }
            this.odm.put(study);
        } else if ("/ODM/Study/".equals(path)) {
            this.cached_study_oid = attr.getValue("OID");
            if (StringUtils.isEmpty((CharSequence)this.study_oid)) {
                this.study_oid = this.cached_study_oid;
            }
            if (this.study_oid.equals(this.cached_study_oid)) {
                OdmStudyModel study = this.odm.getStudy();
                if (study != null) {
                    study.study_oid = attr.getValue("OID");
                    this.odm.put(study);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/".equals(path)) {
            this.cached_metadata_version_oid = attr.getValue("OID");
            if (this.metadata_version_oid != null && this.metadata_version_oid.equals("")) {
                this.metadata_version_oid = this.cached_metadata_version_oid;
            }
            if (this.study_oid.equals(this.cached_study_oid) && this.metadata_version_oid.equals(this.cached_metadata_version_oid)) {
                OdmStudyModel study = this.odm.getStudy();
                if (study != null) {
                    study.metadata_oid = attr.getValue("OID");
                    study.metadata_name = attr.getValue("Name");
                    study.metadata_description = attr.getValue("Description");
                    this.odm.put(study);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/Protocol/Description/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                OdmStudyModel study = this.odm.getStudy();
                if (study != null) {
                    study.protocol_description_lang = attr.getValue("xml:lang");
                    this.odm.put(study);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/BasicDefinitions/MeasurementUnit/".equals(path)) {
            if (this.study_oid.equals(this.cached_study_oid)) {
                this.cached_unit_id = attr.getValue("OID");
                OdmUnitModel.OdmUnitPk key = new OdmUnitModel.OdmUnitPk(this.cached_unit_id, "");
                OdmUnitModel unit = new OdmUnitModel(key);
                unit.unit_name = attr.getValue("Name");
                unit.ordinal = this.cached_unit_ordinal++;
                this.cached_units.put(this.cached_unit_id, unit);
            }
        } else if ("/ODM/Study/BasicDefinitions/MeasurementUnit/Symbol/TranslatedText/".equals(path)) {
            if (this.study_oid.equals(this.cached_study_oid)) {
                OdmUnitModel cached_unit = this.cached_units.get(this.cached_unit_id);
                this.cached_xml_lang = StringUtils.isEmpty((CharSequence)attr.getValue("xml:lang")) ? "" : attr.getValue("xml:lang");
                OdmUnitModel.OdmUnitPk key = new OdmUnitModel.OdmUnitPk(this.cached_unit_id, this.cached_xml_lang);
                OdmUnitModel unit = new OdmUnitModel(key);
                unit.copy(cached_unit);
                this.odm.put(key, unit);
            }
        } else if ("/ODM/Study/MetaDataVersion/Protocol/StudyEventRef/".equals(path)) {
            if (this.isTarget()) {
                OdmEventModel.OdmEventPk key = new OdmEventModel.OdmEventPk(attr.getValue("StudyEventOID"));
                OdmEventModel cached_event = new OdmEventModel(key);
                try {
                    cached_event.ordinal = Integer.parseInt(attr.getValue("OrderNumber"));
                }
                catch (Exception ex) {
                    cached_event.ordinal = this.cached_event_ordinal++;
                }
                cached_event.mandatory = attr.getValue("Mandatory");
                cached_event.collection_exception_cnd = attr.getValue("CollectionExceptionConditionOID");
                this.cached_events.put(cached_event.event_id, cached_event);
            }
        } else if ("/ODM/Study/MetaDataVersion/StudyEventDef/".equals(path)) {
            if (this.isTarget()) {
                this.cached_event_id = attr.getValue("OID");
                OdmEventModel event = this.cached_events.get(this.cached_event_id);
                event.event_name = attr.getValue("Name");
                event.repeating = attr.getValue("Repeating");
                event.event_type = attr.getValue("Type");
                event.category = attr.getValue("Category");
                this.odm.put(new OdmEventModel.OdmEventPk(event.event_id), event);
                OdmEventFormModel.OdmEventFormPk key = new OdmEventFormModel.OdmEventFormPk(this.cached_event_id, "");
                OdmEventFormModel cached_eventform = new OdmEventFormModel(key);
                cached_eventform.event_name = attr.getValue("Name");
                this.cached_eventforms.put(cached_eventform.event_id, cached_eventform);
            }
        } else if ("/ODM/Study/MetaDataVersion/StudyEventDef/Description/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                OdmEventModel.OdmEventPk key = new OdmEventModel.OdmEventPk(this.cached_event_id);
                OdmEventModel event = this.odm.get(key);
                if (event != null) {
                    event.xml_lang = attr.getValue("xml:lang");
                    this.odm.put(key, event);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/StudyEventDef/Alias/".equals(path)) {
            if (this.isTarget()) {
                OdmEventModel.OdmEventPk key = new OdmEventModel.OdmEventPk(this.cached_event_id);
                OdmEventModel event = this.odm.get(key);
                if (event != null) {
                    event.alias_context = this.concat(event.alias_context, attr.getValue("Context"));
                    event.alias_name = this.concat(event.alias_name, attr.getValue("Name"));
                    this.odm.put(key, event);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/StudyEventDef/FormRef/".equals(path)) {
            if (this.isTarget()) {
                OdmEventFormModel cached_eventform = this.cached_eventforms.get(this.cached_event_id);
                OdmEventFormModel.OdmEventFormPk key = new OdmEventFormModel.OdmEventFormPk(this.cached_event_id, attr.getValue("FormOID"));
                OdmEventFormModel eventform = new OdmEventFormModel(key);
                eventform.copy(cached_eventform);
                try {
                    eventform.ordinal = Integer.parseInt(attr.getValue("OrderNumber"));
                }
                catch (Exception ex) {
                    eventform.ordinal = this.cached_eventform_ordinal++;
                }
                eventform.mandatory = attr.getValue("Mandatory");
                eventform.collection_exception_cnd = attr.getValue("CollectionExceptionConditionOID");
                this.odm.put(key, eventform);
            }
        } else if ("/ODM/Study/MetaDataVersion/FormDef/".equals(path)) {
            if (this.isTarget()) {
                this.cached_form_id = attr.getValue("OID");
                OdmFormModel.OdmFormPk key = new OdmFormModel.OdmFormPk(this.cached_form_id);
                OdmFormModel form = new OdmFormModel(key);
                form.name = attr.getValue("Name");
                form.ordinal = this.cached_form_ordinal++;
                form.repeating = attr.getValue("Repeating");
                this.odm.put(new OdmFormModel.OdmFormPk(form.form_id), form);
                this.odm.updateEventForm(form.form_id, form.name);
            }
        } else if ("/ODM/Study/MetaDataVersion/FormDef/Description/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                OdmFormModel.OdmFormPk key = new OdmFormModel.OdmFormPk(this.cached_form_id);
                OdmFormModel form = this.odm.get(key);
                if (form != null) {
                    form.xml_lang = attr.getValue("xml:lang");
                    this.odm.put(key, form);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/FormDef/ArchiveLayout/".equals(path)) {
            if (this.isTarget()) {
                OdmFormModel.OdmFormPk key = new OdmFormModel.OdmFormPk(this.cached_form_id);
                OdmFormModel form = this.odm.get(key);
                if (form != null) {
                    form.pdf_file = attr.getValue("PdfFileName");
                    this.odm.put(key, form);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/FormDef/Alias/".equals(path)) {
            if (this.isTarget()) {
                OdmFormModel.OdmFormPk key = new OdmFormModel.OdmFormPk(this.cached_form_id);
                OdmFormModel form = this.odm.get(key);
                if (form != null) {
                    form.alias_context = this.concat(form.alias_context, attr.getValue("Context"));
                    form.alias_name = this.concat(form.alias_name, attr.getValue("Name"));
                    this.odm.put(key, form);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/FormDef/ItemGroupRef/".equals(path)) {
            if (this.isTarget()) {
                OdmFieldModel.OdmFieldPk key = new OdmFieldModel.OdmFieldPk(this.cached_form_id, attr.getValue("ItemGroupOID"), attr.getValue("ItemGroupOID"));
                OdmFieldModel itemgroup = new OdmFieldModel(key);
                try {
                    itemgroup.ordinal = Integer.parseInt(attr.getValue("OrderNumber"));
                }
                catch (Exception ex) {
                    itemgroup.ordinal = this.cached_itemgroup_ordinal++;
                }
                itemgroup.level = 1;
                itemgroup.mandatory = attr.getValue("Mandatory");
                itemgroup.condition_id = attr.getValue("CollectionExceptionConditionOID");
                this.odm.put(key, itemgroup);
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemGroupDef/".equals(path)) {
            if (this.isTarget()) {
                this.cached_itemgroup_id = attr.getValue("OID");
                List<OdmFieldModel> itemgroups = this.odm.getItemGroupById(this.cached_itemgroup_id);
                if (itemgroups != null) {
                    this.cached_item_ordinal = 1;
                    for (OdmFieldModel itemgroup : itemgroups) {
                        itemgroup.name = attr.getValue("Name");
                        itemgroup.repeating = attr.getValue("Repeating");
                        itemgroup.is_reference_data = attr.getValue("IsReferenceData");
                        itemgroup.sas_name = attr.getValue("SASDatasetName");
                        this.odm.put(itemgroup.getKey(), itemgroup);
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemGroupDef/Description/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                List<OdmFieldModel> itemgroups = this.odm.getItemGroupById(this.cached_itemgroup_id);
                if (itemgroups != null) {
                    for (OdmFieldModel itemgroup : itemgroups) {
                        itemgroup.description_xml_lang = attr.getValue("xml:lang");
                        this.odm.put(itemgroup.getKey(), itemgroup);
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemGroupDef/ItemRef/".equals(path)) {
            if (this.isTarget()) {
                List<OdmFieldModel> itemgroups = this.odm.getItemGroupById(this.cached_itemgroup_id);
                if (itemgroups != null) {
                    for (OdmFieldModel itemgroup : itemgroups) {
                        OdmFieldModel.OdmFieldPk key = new OdmFieldModel.OdmFieldPk(itemgroup.form_id, itemgroup.item_group_oid, attr.getValue("ItemOID"));
                        OdmFieldModel item = new OdmFieldModel(key);
                        try {
                            item.ordinal = Integer.parseInt(attr.getValue("OrderNumber"));
                        }
                        catch (Exception ex) {
                            item.ordinal = this.cached_item_ordinal++;
                        }
                        item.level = 0;
                        item.mandatory = attr.getValue("Mandatory");
                        item.key_sequence = attr.getValue("KeySequence");
                        item.method_id = attr.getValue("MethodOID");
                        item.condition_id = attr.getValue("CollectionExceptionConditionOID");
                        this.odm.put(key, item);
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemGroupDef/Alias/".equals(path)) {
            if (this.isTarget()) {
                List<OdmFieldModel> itemgroups = this.odm.getItemGroupById(this.cached_itemgroup_id);
                if (itemgroups != null) {
                    for (OdmFieldModel itemgroup : itemgroups) {
                        itemgroup.alias_context = this.concat(itemgroup.alias_context, attr.getValue("Context"));
                        itemgroup.alias_name = this.concat(itemgroup.alias_name, attr.getValue("Name"));
                        this.odm.put(itemgroup.getKey(), itemgroup);
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/".equals(path)) {
            if (this.isTarget()) {
                this.cached_item_id = attr.getValue("OID");
                List<OdmFieldModel> items = this.odm.getItemById(this.cached_item_id);
                if (items != null) {
                    for (OdmFieldModel item : items) {
                        item.name = attr.getValue("Name");
                        item.control_type = attr.getValue("ddedcp:InputFormatTyp");
                        item.section_label = attr.getValue("ddedcp:SectionLabel");
                        item.data_type = attr.getValue("DataType");
                        try {
                            if (!StringUtils.isEmpty((CharSequence)attr.getValue("Length"))) {
                                item.length = Integer.parseInt(attr.getValue("Length"));
                            }
                            if (!StringUtils.isEmpty((CharSequence)attr.getValue("SignificantDigits"))) {
                                item.significant_digits = Integer.parseInt(attr.getValue("SignificantDigits"));
                            }
                        }
                        catch (Exception ex) {
                            OdmImportError error = new OdmImportError(new OdmFieldModel.OdmFieldPk(item.form_id, item.item_group_oid, item.field_id));
                            error.putMessage("Error parsing ItemDef Length/SignificantDigits attributes.");
                            logger.warn((Object)error.toString());
                        }
                        item.sas_name = attr.getValue("SASFieldName");
                        this.odm.put(item.getKey(), item);
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/Description/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                List<OdmFieldModel> items = this.odm.getItemById(this.cached_item_id);
                if (items != null) {
                    for (OdmFieldModel item : items) {
                        item.description_xml_lang = attr.getValue("xml:lang");
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/Question/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                List<OdmFieldModel> items = this.odm.getItemById(this.cached_item_id);
                if (items != null) {
                    for (OdmFieldModel item : items) {
                        item.question_xml_lang = attr.getValue("xml:lang");
                        this.odm.put(item.getKey(), item);
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/MeasurementUnitRef/".equals(path)) {
            if (this.isTarget()) {
                List<OdmFieldModel> items = this.odm.getItemById(this.cached_item_id);
                if (items != null) {
                    for (OdmFieldModel item : items) {
                        item.crf_unit = this.concat(item.crf_unit, attr.getValue("MeasurementUnitOID"));
                        this.odm.put(item.getKey(), item);
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/RangeCheck/".equals(path)) {
            if (this.isTarget()) {
                List<OdmFieldModel> items = this.odm.getItemById(this.cached_item_id);
                if (items != null) {
                    for (OdmFieldModel item : items) {
                        item.range_check = attr.getValue("Comparator");
                        item.soft_hard = attr.getValue("SoftHard");
                        this.odm.put(item.getKey(), item);
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/RangeCheck/FormalExpression/".equals(path)) {
            if (this.isTarget()) {
                List<OdmFieldModel> items = this.odm.getItemById(this.cached_item_id);
                if (items != null) {
                    for (OdmFieldModel item : items) {
                        item.formal_expression_context = attr.getValue("Context");
                        this.odm.put(item.getKey(), item);
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/CodeListRef/".equals(path)) {
            if (this.isTarget()) {
                List<OdmFieldModel> items = this.odm.getItemById(this.cached_item_id);
                if (items != null) {
                    for (OdmFieldModel item : items) {
                        item.crf_codelist = attr.getValue("CodeListOID");
                        this.odm.put(item.getKey(), item);
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/Alias/".equals(path)) {
            if (this.isTarget()) {
                List<OdmFieldModel> items = this.odm.getItemById(this.cached_item_id);
                if (items != null) {
                    for (OdmFieldModel item : items) {
                        item.alias_context = this.concat(item.alias_context, attr.getValue("Context"));
                        item.alias_name = this.concat(item.alias_name, attr.getValue("Name"));
                        this.odm.put(item.getKey(), item);
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/CodeList/".equals(path)) {
            if (this.isTarget()) {
                this.cached_codelist_id = attr.getValue("OID");
                this.cached_codelist_ordinal = 1;
                OdmCodelistModel.OdmCodelistPk key = new OdmCodelistModel.OdmCodelistPk(this.cached_codelist_id, "");
                OdmCodelistModel codelist = new OdmCodelistModel(key);
                codelist.codelist_label = attr.getValue("Name");
                codelist.data_type = attr.getValue("DataType");
                codelist.sas_format_name = attr.getValue("SASFormatName");
                this.cached_codelists.put(this.cached_codelist_id, codelist);
            }
        } else if ("/ODM/Study/MetaDataVersion/CodeList/Description/TranslatedText".equals(path)) {
            if (this.isTarget()) {
                OdmCodelistModel codelist = this.cached_codelists.get(this.cached_codelist_id);
                codelist.xml_lang = attr.getValue("xml:lang");
                this.cached_codelists.put(this.cached_codelist_id, codelist);
            }
        } else if ("/ODM/Study/MetaDataVersion/CodeList/CodeListItem/".equals(path)) {
            if (this.isTarget()) {
                OdmCodelistModel cached_codelist = this.cached_codelists.get(this.cached_codelist_id);
                this.cached_user_code = attr.getValue("CodedValue");
                OdmCodelistModel.OdmCodelistPk key = new OdmCodelistModel.OdmCodelistPk(this.cached_codelist_id, this.cached_user_code);
                OdmCodelistModel codelist = new OdmCodelistModel(key);
                codelist.copy(cached_codelist);
                codelist.submission_value = codelist.user_code;
                try {
                    if (!StringUtils.isEmpty((CharSequence)attr.getValue("Rank"))) {
                        codelist.rank = Integer.parseInt(attr.getValue("Rank"));
                    }
                    if (!StringUtils.isEmpty((CharSequence)attr.getValue("OrderNumber"))) {
                        codelist.ordinal = codelist.order_number = Integer.valueOf(Integer.parseInt(attr.getValue("OrderNumber")));
                    }
                }
                catch (Exception ex) {
                    codelist.ordinal = this.cached_codelist_ordinal++;
                    OdmImportError error = new OdmImportError(new OdmCodelistModel.OdmCodelistPk(codelist.codelist, codelist.user_code));
                    error.putMessage("Error parsing Codelist Rank/OrderNumber attributes.");
                    logger.warn((Object)error.toString());
                }
                this.odm.put(key, codelist);
            }
        } else if ("/ODM/Study/MetaDataVersion/CodeList/CodeListItem/Decode/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                OdmCodelistModel.OdmCodelistPk key = new OdmCodelistModel.OdmCodelistPk(this.cached_codelist_id, this.cached_user_code);
                OdmCodelistModel codelist = this.odm.get(key);
                if (codelist != null) {
                    codelist.xml_lang = attr.getValue("xml:lang");
                    this.odm.put(key, codelist);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/CodeList/CodeListItem/Alias/".equals(path)) {
            if (this.isTarget()) {
                OdmCodelistModel.OdmCodelistPk key = new OdmCodelistModel.OdmCodelistPk(this.cached_codelist_id, this.cached_user_code);
                OdmCodelistModel codelist = this.odm.get(key);
                if (codelist != null) {
                    codelist.alias_context = this.concat(codelist.alias_context, attr.getValue("Context"));
                    codelist.alias_name = this.concat(codelist.alias_name, attr.getValue("Name"));
                    if (codelist.alias_context.equals("SDTM")) {
                        codelist.code = attr.getValue("Name");
                    }
                    this.odm.put(key, codelist);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/CodeList/EnumeratedItem/".equals(path)) {
            if (this.isTarget()) {
                OdmCodelistModel cached_codelist = this.cached_codelists.get(this.cached_codelist_id);
                this.cached_user_code = attr.getValue("CodedValue");
                OdmCodelistModel.OdmCodelistPk key = new OdmCodelistModel.OdmCodelistPk(this.cached_codelist_id, this.cached_user_code);
                OdmCodelistModel codelist = new OdmCodelistModel(key);
                codelist.copy(cached_codelist);
                try {
                    if (!StringUtils.isEmpty((CharSequence)attr.getValue("Rank"))) {
                        codelist.rank = Integer.parseInt(attr.getValue("Rank"));
                    }
                    if (!StringUtils.isEmpty((CharSequence)attr.getValue("OrderNumber"))) {
                        codelist.order_number = Integer.parseInt(attr.getValue("OrderNumber"));
                    }
                    codelist.ordinal = codelist.order_number;
                }
                catch (Exception ex) {
                    codelist.ordinal = this.cached_codelist_ordinal++;
                    OdmImportError error = new OdmImportError(new OdmCodelistModel.OdmCodelistPk(codelist.codelist, codelist.user_code));
                    error.putMessage("Error parsing Codelist Rank/OrderNumber attributes.");
                    logger.warn((Object)error.toString());
                }
                this.odm.put(key, codelist);
            }
        } else if ("/ODM/Study/MetaDataVersion/CodeList/EnumeratedItem/Alias/".equals(path)) {
            if (this.isTarget()) {
                OdmCodelistModel.OdmCodelistPk key = new OdmCodelistModel.OdmCodelistPk(this.cached_codelist_id, this.cached_user_code);
                OdmCodelistModel codelist = this.odm.get(key);
                if (codelist != null) {
                    codelist.alias_context = this.concat(codelist.alias_context, attr.getValue("Context"));
                    codelist.alias_name = this.concat(codelist.alias_name, attr.getValue("Name"));
                    if (codelist.alias_context.equals("SDTM")) {
                        codelist.code = attr.getValue("Name");
                    }
                    this.odm.put(key, codelist);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/CodeList/Alias/".equals(path)) {
            if (this.isTarget()) {
                this.odm.updateCodelist(this.cached_codelist_id, attr.getValue("Context"), attr.getValue("Name"), this.config.valueDelimiter);
            }
        } else if ("/ODM/Study/MetaDataVersion/MethodDef/".equals(path)) {
            if (this.isTarget()) {
                this.cached_method_id = attr.getValue("OID");
                OdmMethodModel.OdmMethodPk key = new OdmMethodModel.OdmMethodPk(this.cached_method_id);
                OdmMethodModel method = new OdmMethodModel(key);
                method.method_name = attr.getValue("Name");
                method.method_type = attr.getValue("Type");
                method.ordinal = this.cached_method_ordinal++;
                this.odm.put(key, method);
            }
        } else if ("/ODM/Study/MetaDataVersion/MethodDef/Description/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                OdmMethodModel.OdmMethodPk key = new OdmMethodModel.OdmMethodPk(this.cached_method_id);
                OdmMethodModel method = this.odm.get(key);
                if (method != null) {
                    method.xml_lang = attr.getValue("xml:lang");
                    this.odm.put(key, method);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/MethodDef/FormalExpression/".equals(path)) {
            if (this.isTarget()) {
                OdmMethodModel.OdmMethodPk key = new OdmMethodModel.OdmMethodPk(this.cached_method_id);
                OdmMethodModel method = this.odm.get(key);
                if (method != null) {
                    method.formal_expression_context = attr.getValue("Context");
                    this.odm.put(key, method);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/MethodDef/Alias/".equals(path)) {
            if (this.isTarget()) {
                OdmMethodModel.OdmMethodPk key = new OdmMethodModel.OdmMethodPk(this.cached_method_id);
                OdmMethodModel method = this.odm.get(key);
                if (method != null) {
                    method.alias_context = this.concat(method.alias_context, attr.getValue("Context"));
                    method.alias_name = this.concat(method.alias_name, attr.getValue("Name"));
                    this.odm.put(key, method);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ConditionDef/".equals(path)) {
            if (this.isTarget()) {
                this.cached_condition_id = attr.getValue("OID");
                OdmConditionModel.OdmConditionPk key = new OdmConditionModel.OdmConditionPk(this.cached_condition_id);
                OdmConditionModel condition = new OdmConditionModel(key);
                condition.condition_name = attr.getValue("Name");
                condition.ordinal = this.cached_condition_ordinal++;
                this.odm.put(key, condition);
            }
        } else if ("/ODM/Study/MetaDataVersion/ConditionDef/Description/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                OdmConditionModel.OdmConditionPk key = new OdmConditionModel.OdmConditionPk(this.cached_condition_id);
                OdmConditionModel condition = this.odm.get(key);
                if (condition != null) {
                    condition.xml_lang = attr.getValue("xml:lang");
                    this.odm.put(key, condition);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ConditionDef/FormalExpression/".equals(path)) {
            if (this.isTarget()) {
                OdmConditionModel.OdmConditionPk key = new OdmConditionModel.OdmConditionPk(this.cached_condition_id);
                OdmConditionModel condition = this.odm.get(key);
                if (condition != null) {
                    condition.formal_expression_context = attr.getValue("Context");
                    this.odm.put(key, condition);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ConditionDef/Alias/".equals(path) && this.isTarget()) {
            OdmConditionModel.OdmConditionPk key = new OdmConditionModel.OdmConditionPk(this.cached_condition_id);
            OdmConditionModel condition = this.odm.get(key);
            if (condition != null) {
                condition.alias_context = this.concat(condition.alias_context, attr.getValue("Context"));
                condition.alias_name = this.concat(condition.alias_name, attr.getValue("Name"));
                this.odm.put(key, condition);
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String text = new String(ch, start, length).trim();
        if (text != null) {
            this.bindText(this.path_stack.getPath(), text);
        }
    }

    public void bindText(String path, String text) {
        if ("/ODM/Study/GlobalVariables/StudyName/".equals(path)) {
            if (this.study_oid.equals(this.cached_study_oid)) {
                OdmStudyModel study = this.odm.getStudy();
                if (study != null) {
                    study.study_name = study.study_name + text;
                    this.odm.put(study);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/GlobalVariables/StudyDescription/".equals(path)) {
            if (this.study_oid.equals(this.cached_study_oid)) {
                OdmStudyModel study = this.odm.getStudy();
                if (study != null) {
                    study.study_description = study.study_description + text;
                    this.odm.put(study);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/GlobalVariables/ProtocolName/".equals(path)) {
            if (this.study_oid.equals(this.cached_study_oid)) {
                OdmStudyModel study = this.odm.getStudy();
                if (study != null) {
                    study.protocol_name = study.protocol_name + text;
                    this.odm.put(study);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/Protocol/Description/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                OdmStudyModel study = this.odm.getStudy();
                if (study != null) {
                    study.protocol_description = study.protocol_description + text;
                    this.odm.put(study);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/BasicDefinitions/MeasurementUnit/Symbol/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                OdmUnitModel.OdmUnitPk key = new OdmUnitModel.OdmUnitPk(this.cached_unit_id, this.cached_xml_lang);
                OdmUnitModel unit = this.odm.get(key);
                if (unit != null) {
                    unit.symbol = unit.symbol + text;
                    this.odm.put(key, unit);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/StudyEventDef/Description/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                OdmEventModel.OdmEventPk key = new OdmEventModel.OdmEventPk(this.cached_event_id);
                OdmEventModel event = this.odm.get(key);
                if (event != null) {
                    event.description = event.description + text;
                    this.odm.put(key, event);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/FormDef/Description/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                OdmFormModel.OdmFormPk key = new OdmFormModel.OdmFormPk(this.cached_form_id);
                OdmFormModel form = this.odm.get(key);
                if (form != null) {
                    form.description = form.description + text;
                    this.odm.put(key, form);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemGroupDef/Description/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                List<OdmFieldModel> itemgroups = this.odm.getItemGroupById(this.cached_itemgroup_id);
                if (itemgroups != null) {
                    for (OdmFieldModel itemgroup : itemgroups) {
                        OdmFieldModel.OdmFieldPk key = itemgroup.getKey();
                        itemgroup.description = itemgroup.description + text;
                        this.odm.put(key, itemgroup);
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/Description/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                List<OdmFieldModel> items = this.odm.getItemById(this.cached_item_id);
                if (items != null) {
                    for (OdmFieldModel item : items) {
                        OdmFieldModel.OdmFieldPk key = item.getKey();
                        item.description = item.description + text;
                        this.odm.put(key, item);
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/Question/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                List<OdmFieldModel> items = this.odm.getItemById(this.cached_item_id);
                if (items != null) {
                    for (OdmFieldModel item : items) {
                        OdmFieldModel.OdmFieldPk key = item.getKey();
                        item.question = item.question + text;
                        this.odm.put(key, item);
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/RangeCheck/ErrorMessage/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                List<OdmFieldModel> items = this.odm.getItemById(this.cached_item_id);
                if (items != null) {
                    for (OdmFieldModel item : items) {
                        OdmFieldModel.OdmFieldPk key = item.getKey();
                        item.range_check_error = item.range_check_error + text;
                        this.odm.put(key, item);
                    }
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/CodeList/CodeListItem/Decode/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                OdmCodelistModel.OdmCodelistPk key = new OdmCodelistModel.OdmCodelistPk(this.cached_codelist_id, this.cached_user_code);
                OdmCodelistModel codelist = this.odm.get(key);
                if (codelist != null) {
                    codelist.decode = codelist.decode + text;
                    this.odm.put(key, codelist);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/MethodDef/Description/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                OdmMethodModel.OdmMethodPk key = new OdmMethodModel.OdmMethodPk(this.cached_method_id);
                OdmMethodModel method = this.odm.get(key);
                if (method != null) {
                    method.description = method.description + text;
                    this.odm.put(key, method);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/MethodDef/FormalExpression/".equals(path)) {
            if (this.isTarget()) {
                OdmMethodModel.OdmMethodPk key = new OdmMethodModel.OdmMethodPk(this.cached_method_id);
                OdmMethodModel method = this.odm.get(key);
                if (method != null) {
                    method.formal_expression = method.formal_expression + text;
                    this.odm.put(key, method);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ConditionDef/Description/TranslatedText/".equals(path)) {
            if (this.isTarget()) {
                OdmConditionModel.OdmConditionPk key = new OdmConditionModel.OdmConditionPk(this.cached_condition_id);
                OdmConditionModel condition = this.odm.get(key);
                if (condition != null) {
                    condition.description = condition.description + text;
                    this.odm.put(key, condition);
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ConditionDef/FormalExpression/".equals(path) && this.isTarget()) {
            OdmConditionModel.OdmConditionPk key = new OdmConditionModel.OdmConditionPk(this.cached_condition_id);
            OdmConditionModel condition = this.odm.get(key);
            if (condition != null) {
                condition.formal_expression = condition.formal_expression + text;
                this.odm.put(key, condition);
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        this.path_stack.pop();
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        ErrorInfo error = new ErrorInfo();
        error.setId(exception.getSystemId());
        error.setLine(exception.getLineNumber());
        error.setColumn(exception.getColumnNumber());
        error.setMessage(exception.getMessage());
        error.setMessage(exception.getMessage() + "\nnear the line number " + this.locator.getLineNumber() + ".");
        this.errors.add(error);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        ErrorInfo error = new ErrorInfo();
        error.setId(exception.getSystemId());
        error.setLine(exception.getLineNumber());
        error.setColumn(exception.getColumnNumber());
        error.setMessage(exception.getMessage() + "\nnear the line number " + this.locator.getLineNumber() + ".");
        this.errors.add(error);
    }

    public OdmModel getOdmModel() {
        return this.odm;
    }

    public List<ErrorInfo> getErrors() {
        return this.errors;
    }

    private boolean isTarget() {
        return this.study_oid.equals(this.cached_study_oid) && this.metadata_version_oid.equals(this.cached_metadata_version_oid);
    }

    private String concat(String current_text, String new_text) {
        if (StringUtils.isEmpty((CharSequence)current_text)) {
            return new_text;
        }
        return current_text + this.config.valueDelimiter + new_text;
    }

    static {
        MESSAGE_ORPHANED = "An orphaned element found.";
    }
}

