/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer.models;

import com.fujitsu.tsc.desktop.importer.models.DefineModel;
import com.fujitsu.tsc.desktop.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefineARMResultModel
implements Comparable<DefineARMResultModel> {
    public final String display_name;
    public final String result_key;
    public Integer ordinal;
    public String result_desc = "";
    public String result_lang = "";
    public String param_oid = "";
    public String param_dataset = "";
    public String analysis_reason = "";
    public String analysis_purpose = "";
    public String docm_text = "";
    public String docm_lang = "";
    public List<DefineModel.DocumentRef> docm_document_refs = new ArrayList<DefineModel.DocumentRef>();
    public String prog_code_context = "";
    public String prog_code_text = "";
    public List<DefineModel.DocumentRef> prog_code_document_refs = new ArrayList<DefineModel.DocumentRef>();
    public String dataset_comment_oid = "";

    public DefineARMResultModel(DefineARMResultPk key) {
        this.display_name = key.display_name;
        this.result_key = key.result_key;
        this.result_desc = "";
        this.result_lang = "";
        this.param_oid = "";
        this.param_dataset = "";
        this.analysis_reason = "";
        this.analysis_purpose = "";
        this.docm_text = "";
        this.docm_lang = "";
        this.docm_document_refs = new ArrayList<DefineModel.DocumentRef>();
        this.prog_code_context = "";
        this.prog_code_text = "";
        this.prog_code_document_refs = new ArrayList<DefineModel.DocumentRef>();
        this.dataset_comment_oid = "";
    }

    public String toOid() {
        return DefineARMResultModel.createOid(this.display_name, this.result_key);
    }

    public static String createOid(String display_name, String result_key) {
        return "AR." + Utils.codedText(display_name) + "." + Utils.codedText(result_key);
    }

    public String getDocumentationIdString(String delimiter) {
        String rtn = "";
        for (int i = 0; i < this.docm_document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.docm_document_refs.get((int)i).document_id;
        }
        return rtn;
    }

    public String getDocumentationPageTypeString(String delimiter) {
        String rtn = "";
        for (int i = 0; i < this.docm_document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.docm_document_refs.get((int)i).document_page_type;
        }
        return rtn;
    }

    public String getDocumentationPageRefString(String delimiter) {
        String rtn = "";
        if (this.docm_document_refs.isEmpty()) {
            return rtn;
        }
        List document_page_references = this.docm_document_refs.stream().map(o -> o.document_page_reference).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_page_references.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.docm_document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.docm_document_refs.get((int)i).document_page_reference;
        }
        return rtn;
    }

    public String getDocumentationFirstPageString(String delimiter) {
        String rtn = "";
        if (this.docm_document_refs.isEmpty()) {
            return rtn;
        }
        List document_first_pages = this.docm_document_refs.stream().map(o -> o.document_first_page).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_first_pages.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.docm_document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.docm_document_refs.get((int)i).document_first_page;
        }
        return rtn;
    }

    public String getDocumentationLastPageString(String delimiter) {
        String rtn = "";
        if (this.docm_document_refs.isEmpty()) {
            return rtn;
        }
        List document_last_pages = this.docm_document_refs.stream().map(o -> o.document_last_page).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_last_pages.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.docm_document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.docm_document_refs.get((int)i).document_last_page;
        }
        return rtn;
    }

    public String getCodeIdString(String delimiter) {
        String rtn = "";
        for (int i = 0; i < this.docm_document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.docm_document_refs.get((int)i).document_id;
        }
        return rtn;
    }

    public String getCodePageTypeString(String delimiter) {
        String rtn = "";
        for (int i = 0; i < this.docm_document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.docm_document_refs.get((int)i).document_page_type;
        }
        return rtn;
    }

    public String getCodePageRefString(String delimiter) {
        String rtn = "";
        if (this.docm_document_refs.isEmpty()) {
            return rtn;
        }
        List document_page_references = this.docm_document_refs.stream().map(o -> o.document_page_reference).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_page_references.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.docm_document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.docm_document_refs.get((int)i).document_page_reference;
        }
        return rtn;
    }

    public String getCodeFirstPageString(String delimiter) {
        String rtn = "";
        if (this.docm_document_refs.isEmpty()) {
            return rtn;
        }
        List document_first_pages = this.docm_document_refs.stream().map(o -> o.document_first_page).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_first_pages.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.docm_document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.docm_document_refs.get((int)i).document_first_page;
        }
        return rtn;
    }

    public String getCodeLastPageString(String delimiter) {
        String rtn = "";
        if (this.docm_document_refs.isEmpty()) {
            return rtn;
        }
        List document_last_pages = this.docm_document_refs.stream().map(o -> o.document_last_page).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_last_pages.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.docm_document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.docm_document_refs.get((int)i).document_last_page;
        }
        return rtn;
    }

    @Override
    public int compareTo(DefineARMResultModel result) {
        if (StringUtils.equals((CharSequence)this.display_name, (CharSequence)result.display_name)) {
            return this.result_key.compareTo(result.result_key);
        }
        return this.display_name.compareTo(result.display_name);
    }

    public static class DefineARMResultPk
    implements Comparable<DefineARMResultPk> {
        public final String display_name;
        public final String result_key;

        public DefineARMResultPk(String display_name, String result_key) {
            this.display_name = display_name;
            this.result_key = result_key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.display_name.equals(((DefineARMResultPk)obj).display_name) && this.result_key.equals(((DefineARMResultPk)obj).result_key);
        }

        @Override
        public int compareTo(DefineARMResultPk key) {
            return (this.display_name + this.result_key).compareTo(key.display_name + key.result_key);
        }

        public String toString() {
            String rtn = "Display Name: " + this.display_name + System.lineSeparator();
            rtn = rtn + "Result Key: " + this.result_key;
            return rtn;
        }

        public int hashCode() {
            return Objects.hash(this.display_name, this.result_key);
        }
    }
}

