/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer.models;

import com.fujitsu.tsc.desktop.importer.models.DefineModel;
import com.fujitsu.tsc.desktop.util.Utils;
import java.util.Objects;

public class DefineDocumentModel
implements Comparable<DefineDocumentModel> {
    public final String document_id;
    public Integer ordinal;
    public DefineModel.DocType document_type;
    public String document_href;
    public String document_title;
    public String user_note1;
    public String user_note2;

    public DefineDocumentModel(DefineDocumentPk key) {
        this.document_id = key.document_id;
        this.ordinal = 0;
        this.document_type = DefineModel.DocType.Other;
        this.document_href = "";
        this.document_title = "";
        this.user_note1 = "";
        this.user_note2 = "";
    }

    public String toOid() {
        return DefineDocumentModel.createOid(this.document_id);
    }

    public static String createOid(String document_id) {
        return "LF." + Utils.codedText(document_id);
    }

    @Override
    public int compareTo(DefineDocumentModel document) {
        if (this.document_type == document.document_type) {
            return this.document_id.compareTo(document.document_id);
        }
        return this.document_type.ordinal() - document.document_type.ordinal();
    }

    public static class DefineDocumentPk
    implements Comparable<DefineDocumentPk> {
        public final String document_id;

        public DefineDocumentPk(String document_id) {
            this.document_id = document_id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.document_id.equals(((DefineDocumentPk)obj).document_id);
        }

        @Override
        public int compareTo(DefineDocumentPk key) {
            return this.document_id.compareTo(key.document_id);
        }

        public String toString() {
            String rtn = "Document ID: " + this.document_id;
            return rtn;
        }

        public int hashCode() {
            return Objects.hash(this.document_id);
        }
    }
}

