/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer.models;

import com.fujitsu.tsc.desktop.importer.models.DefineModel;
import com.fujitsu.tsc.desktop.importer.models.DefineValueModel;
import com.fujitsu.tsc.desktop.importer.models.DefineVariableModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefineMethodModel
implements Comparable<DefineMethodModel> {
    public final String oid;
    public String method_name;
    public Integer ordinal;
    public String method_type;
    public String description;
    public String description_lang;
    public List<DefineModel.DocumentRef> document_refs;
    public String formal_expression_context;
    public String formal_expression;
    public String user_note1;
    public String user_note2;

    public DefineMethodModel(DefineMethodPk key) {
        this.oid = key.oid;
        this.method_name = "";
        this.ordinal = 0;
        this.method_type = "";
        this.description = "";
        this.description_lang = "";
        this.document_refs = new ArrayList<DefineModel.DocumentRef>();
        this.formal_expression_context = "";
        this.formal_expression = "";
        this.user_note1 = "";
        this.user_note2 = "";
    }

    public void copy(DefineMethodModel method) {
        if (!StringUtils.isEmpty((CharSequence)method.method_name)) {
            this.method_name = method.method_name;
        }
        if (method.ordinal > 0) {
            this.ordinal = method.ordinal;
        }
        if (!StringUtils.isEmpty((CharSequence)method.method_type)) {
            this.method_type = method.method_type;
        }
        if (!StringUtils.isEmpty((CharSequence)method.description)) {
            this.description = method.description;
        }
        if (!StringUtils.isEmpty((CharSequence)method.description_lang)) {
            this.description_lang = method.description_lang;
        }
        if (!this.document_refs.isEmpty()) {
            this.document_refs = method.document_refs;
        }
        if (!StringUtils.isEmpty((CharSequence)method.formal_expression_context)) {
            this.formal_expression_context = method.formal_expression_context;
        }
        if (!StringUtils.isEmpty((CharSequence)method.formal_expression)) {
            this.formal_expression = method.formal_expression;
        }
        if (!StringUtils.isEmpty((CharSequence)method.user_note1)) {
            this.user_note1 = method.user_note1;
        }
        if (!StringUtils.isEmpty((CharSequence)method.user_note2)) {
            this.user_note2 = method.user_note2;
        }
    }

    public static String createMethodOID(Object obj) {
        String PREFIX = "MT.";
        if (obj == null) {
            return "";
        }
        if (obj.getClass() == DefineVariableModel.class) {
            return "MT." + ((DefineVariableModel)obj).toOid();
        }
        if (obj.getClass() == DefineValueModel.class) {
            return "MT." + ((DefineValueModel)obj).toOid();
        }
        return "";
    }

    public String getDocumentIdString(String delimiter) {
        String rtn = "";
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_id;
        }
        return rtn;
    }

    public String getDocumentPageTypeString(String delimiter) {
        String rtn = "";
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_page_type;
        }
        return rtn;
    }

    public String getDocumentPageRefString(String delimiter) {
        String rtn = "";
        if (this.document_refs.isEmpty()) {
            return rtn;
        }
        List document_page_references = this.document_refs.stream().map(o -> o.document_page_reference).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_page_references.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_page_reference;
        }
        return rtn;
    }

    public String getDocumentFirstPageString(String delimiter) {
        String rtn = "";
        if (this.document_refs.isEmpty()) {
            return rtn;
        }
        List document_first_pages = this.document_refs.stream().map(o -> o.document_first_page).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_first_pages.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_first_page;
        }
        return rtn;
    }

    public String getDocumentLastPageString(String delimiter) {
        String rtn = "";
        if (this.document_refs.isEmpty()) {
            return rtn;
        }
        List document_last_pages = this.document_refs.stream().map(o -> o.document_last_page).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_last_pages.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_last_page;
        }
        return rtn;
    }

    public String getDocumentPageTitleString(String delimiter) {
        String rtn = "";
        if (this.document_refs.isEmpty()) {
            return rtn;
        }
        List document_page_titles = this.document_refs.stream().map(o -> o.document_page_title).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_page_titles.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_page_title;
        }
        return rtn;
    }

    @Override
    public int compareTo(DefineMethodModel wc) {
        return this.oid.compareTo(wc.oid);
    }

    public static class DefineMethodPk
    implements Comparable<DefineMethodPk> {
        public final String oid;

        public DefineMethodPk(String oid) {
            this.oid = oid;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.oid.equals(((DefineMethodPk)obj).oid);
        }

        @Override
        public int compareTo(DefineMethodPk key) {
            return this.oid.compareTo(key.oid);
        }

        public String toString() {
            String rtn = "Method OID: " + this.oid;
            return rtn;
        }

        public int hashCode() {
            return Objects.hash(this.oid);
        }
    }
}

