/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.exporter;

import com.fujitsu.tsc.desktop.exporter.ExcelReader;
import com.fujitsu.tsc.desktop.exporter.InvalidOidSyntaxException;
import com.fujitsu.tsc.desktop.exporter.RequiredValueMissingException;
import com.fujitsu.tsc.desktop.exporter.SuppUtil;
import com.fujitsu.tsc.desktop.exporter.TableNotFoundException;
import com.fujitsu.tsc.desktop.exporter.WhereClause;
import com.fujitsu.tsc.desktop.exporter.XmlGenerator;
import com.fujitsu.tsc.desktop.util.Config;
import com.fujitsu.tsc.desktop.util.InvalidParameterException;
import com.fujitsu.tsc.desktop.util.MetaDataReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class DefineXmlWriter {
    private static Logger logger;
    private Config config;
    private MetaDataReader reader;
    private MetaDataReader reader2;
    private OutputStreamWriter sw;
    private BufferedWriter writer;
    private String xmlEncoding;
    private String stylesheetLocation;
    private Config.DatasetType datasetType;
    private int indent;
    private String strAnnotatedCRF;
    private String domainKey;
    private String wDomainKey;
    private final String DELIMITER;
    private final String DEFAULTLANG = "en";
    private Hashtable<String, String> hashUSUBJID;
    private List<String> emptyDatasets;
    private List<String> emptyCodelists;
    private SuppUtil suppUtil;
    private ErrorHint errHint = new ErrorHint();

    public DefineXmlWriter(Config config) throws InvalidParameterException, TableNotFoundException, FileNotFoundException, IOException, RequiredValueMissingException, InvalidFormatException {
        String codelist_id;
        Hashtable<String, String> hash;
        logger = LogManager.getLogger();
        this.config = config;
        this.DELIMITER = config.valueDelimiter;
        this.hashUSUBJID = new Hashtable();
        this.emptyDatasets = new ArrayList<String>();
        this.emptyCodelists = new ArrayList<String>();
        if (!this.config.dataSourceType.name().equals("EXCEL")) {
            throw new InvalidParameterException("dataSourceType", this.config.dataSourceType.name());
        }
        this.reader = new ExcelReader(this.config.e2dDataSourceLocation, this.config.defineDatasetTableName);
        this.reader2 = new ExcelReader(this.config.e2dDataSourceLocation, this.config.defineVariableTableName);
        this.datasetType = this.config.e2dDatasetType;
        if (this.datasetType.equals((Object)Config.DatasetType.ADaM)) {
            this.domainKey = "Dataset Name";
            this.wDomainKey = "W Dataset Name";
        } else {
            this.domainKey = "Domain";
            this.wDomainKey = "W Domain";
        }
        this.xmlEncoding = this.config.e2dXmlEncoding;
        this.stylesheetLocation = this.config.e2dStylesheetLocation;
        this.sw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.config.e2dOutputLocation, false), this.xmlEncoding);
        this.writer = new BufferedWriter(this.sw);
        this.indent = 0;
        ArrayList<String> emptySuppDatasets = new ArrayList<String>();
        while ((hash = this.reader.read()) != null) {
            String dataset_name = hash.get("Dataset Name");
            SuppUtil.IsEmpty isEmpty = SuppUtil.IsEmpty.parse(hash.get("Is Empty"));
            if (isEmpty == SuppUtil.IsEmpty.Yes) {
                this.emptyDatasets.add(dataset_name);
                continue;
            }
            if (isEmpty != SuppUtil.IsEmpty.SUPP) continue;
            emptySuppDatasets.add(dataset_name);
        }
        this.reader.close();
        ArrayList<String> nonEmptyCodelists = new ArrayList<String>();
        while ((hash = this.reader2.read()) != null) {
            String dataset_name = hash.get("Dataset Name");
            codelist_id = hash.get("Codelist");
            if (StringUtils.isEmpty((CharSequence)codelist_id)) continue;
            if (this.emptyDatasets.contains(dataset_name)) {
                this.emptyCodelists.add(codelist_id);
                continue;
            }
            if (emptySuppDatasets.contains(dataset_name) && "Yes".equals(hash.get("Is SUPP"))) {
                this.emptyCodelists.add(codelist_id);
                continue;
            }
            nonEmptyCodelists.add(codelist_id);
        }
        Iterator<String> codelist_itr = this.emptyCodelists.iterator();
        while (codelist_itr.hasNext()) {
            codelist_id = codelist_itr.next();
            if (!nonEmptyCodelists.contains(codelist_id)) continue;
            codelist_itr.remove();
        }
        this.reader2.close();
        if (!this.datasetType.equals((Object)Config.DatasetType.ADaM)) {
            this.reader.setTable(config.defineDatasetTableName);
            this.reader2.setTable(config.defineVariableTableName);
            this.suppUtil = new SuppUtil(this.reader, this.reader2);
            this.reader.close();
            this.reader2.close();
        }
    }

    public void writeXMLHeader() throws IOException, RequiredValueMissingException {
        this.errHint.setErrorHint(TagType.XMLHEADER, "", "", "", "");
        try {
            String str = "<?xml version=\"1.0\" encoding=\"" + this.xmlEncoding + "\"?>";
            this.writer.write(str);
            this.writer.newLine();
            str = "<?xml-stylesheet type=\"text/xsl\" href=\"" + this.stylesheetLocation + "\"?>";
            this.writer.write(str);
            this.writer.newLine();
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeStudySection() throws TableNotFoundException, IOException, RequiredValueMissingException {
        this.errHint.setErrorHint(TagType.STUDY, "", "", "", "");
        try {
            Hashtable<String, String> hashNormalized;
            this.reader.setTable(this.config.defineStudyTableName);
            Hashtable<String, String> hash = new Hashtable<String, String>();
            while ((hashNormalized = this.reader.read()) != null) {
                hash.put(hashNormalized.get("Property Name"), hashNormalized.get("Property Value"));
            }
            Calendar cal = Calendar.getInstance();
            String str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<ODM xmlns=\"http://www.cdisc.org/ns/odm/v1.3\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:def=\"http://www.cdisc.org/ns/def/v2.0\"" + (this.datasetType.equals((Object)Config.DatasetType.ADaM) && this.config.e2dIncludeResultMetadata ? " xmlns:arm=\"http://www.cdisc.org/ns/arm/v1.0\"" : "") + " ODMVersion=\"" + (((String)hash.get("ODMVersion")).equals("") ? this.config.defineOdmVersion : (String)hash.get("ODMVersion")) + "\" FileOID=\"" + (((String)hash.get("FileOID")).equals("") ? UUID.randomUUID().toString() : (String)hash.get("FileOID")) + "\" FileType=\"" + (((String)hash.get("FileType")).equals("") ? this.config.defineFileType : (String)hash.get("FileType")) + "\" CreationDateTime=\"" + cal.get(1) + "-" + DefineXmlWriter.twoDigits(cal.get(2) + 1) + "-" + DefineXmlWriter.twoDigits(cal.get(5)) + "T" + DefineXmlWriter.twoDigits(cal.get(11)) + ":" + DefineXmlWriter.twoDigits(cal.get(12)) + ":" + DefineXmlWriter.twoDigits(cal.get(13)) + (((String)hash.get("AsOfDateTime")).equals("") ? "" : "\" AsOfDateTime=\"" + (String)hash.get("AsOfDateTime")) + (((String)hash.get("Originator")).equals("") ? "" : "\" Originator=\"" + (String)hash.get("Originator")) + "\" SourceSystem=\"" + Config.SOFTWARE_NAME + "\" SourceSystemVersion=\"" + Config.SOFTWARE_VERSION + "\">";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<Study OID=\"" + (String)hash.get("StudyOID") + "\">";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<GlobalVariables>";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<StudyName>" + (String)hash.get("StudyName") + "</StudyName>";
            this.writer.write(str);
            this.writer.newLine();
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<StudyDescription>" + XmlGenerator.escapeString((String)hash.get("StudyDescription")) + "</StudyDescription>";
            this.writer.write(str);
            this.writer.newLine();
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<ProtocolName>" + (String)hash.get("ProtocolName") + "</ProtocolName>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</GlobalVariables>";
            this.writer.write(str);
            this.writer.newLine();
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<MetaDataVersion OID=\"" + (String)hash.get("MetaDataOID") + "\" Name=\"" + XmlGenerator.escapeString((String)hash.get("MetaDataName")) + "\" Description=\"" + XmlGenerator.escapeString((String)hash.get("MetaDataDescription")) + "\" def:DefineVersion=\"" + (String)hash.get("DefineVersion") + "\" def:StandardName=\"" + (String)hash.get("StandardName") + "\" def:StandardVersion=\"" + (String)hash.get("StandardVersion") + "\">";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            this.reader.close();
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeDocumentSection(String docType) throws TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        this.errHint.setErrorHint(TagType.DOCUMENTREF, "", "", "", "");
        try {
            this.reader.setTable(this.config.defineDocumentTableName, new WhereClause[]{new WhereClause("Type", WhereClause.Operator.EQ, docType)});
            Hashtable<Object, Object> hash = new Hashtable();
            String str = null;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<def:" + docType + ">";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            while ((hash = this.reader.read()) != null) {
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<def:DocumentRef leafID=\"" + this.createOID(TagType.DOCUMENTREF, "", "", "", "", (String)hash.get("ID")) + "\"/>";
                this.writer.write(str);
                this.writer.newLine();
                if (!docType.equals("AnnotatedCRF") || this.strAnnotatedCRF != null) continue;
                this.strAnnotatedCRF = (String)hash.get("ID");
            }
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</def:" + docType + ">";
            this.writer.write(str);
            this.writer.newLine();
            this.reader.close();
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeItemGroupDefSection() throws InvalidParameterException, TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        try {
            this.reader.setTable(this.config.defineDatasetTableName);
            Hashtable<Object, Object> hash = new Hashtable();
            Hashtable<String, String> hash2 = new Hashtable();
            String str = null;
            while ((hash = this.reader.read()) != null) {
                String dataset_name = (String)hash.get("Dataset Name");
                this.errHint.setErrorHint(TagType.ITEMGROUPDEF, dataset_name, "", "", "");
                if (this.emptyDatasets.contains(dataset_name)) continue;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ItemGroupDef OID=\"" + this.createOID(TagType.ITEMGROUPDEF, (String)hash.get("Dataset Name"), "", "", "", "") + (this.datasetType.equals((Object)Config.DatasetType.ADaM) ? "" : "\" Domain=\"" + (String)hash.get("Domain")) + "\" Name=\"" + (String)hash.get("Dataset Name") + "\" Repeating=\"" + (String)hash.get("Repeating") + "\" IsReferenceData=\"" + (String)hash.get("IsReferenceData") + "\" SASDatasetName=\"" + (String)hash.get("Dataset Name") + "\" Purpose=\"" + (String)hash.get("Purpose") + "\" def:Structure=\"" + XmlGenerator.escapeString((String)hash.get("Structure")) + "\" def:Class=\"" + (((String)hash.get("Class")).equals("FINDINGS ABOUT") ? "FINDINGS" : (String)hash.get("Class")) + (((String)hash.get("Comment")).equals("") ? "" : "\" def:CommentOID=\"" + this.createOID(TagType.COMMENTDEF, (String)hash.get("Dataset Name"), "", "", "", "")) + "\" def:ArchiveLocationID=\"" + this.createOID(TagType.LEAF, "", "", "", "", (String)hash.get("Dataset Name")) + "\">";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<Description>";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<TranslatedText xml:lang=\"en\">" + (hash.containsKey("TranslatedText") ? XmlGenerator.escapeString((String)hash.get("TranslatedText")) : (hash.containsKey("Description") ? XmlGenerator.escapeString((String)hash.get("Description")) : "")) + "</TranslatedText>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</Description>";
                this.writer.write(str);
                this.writer.newLine();
                this.reader2.setTable(this.config.defineVariableTableName, new WhereClause[]{new WhereClause(this.domainKey, WhereClause.Operator.EQ, (String)hash.get(this.domainKey))});
                int orderNumber = 1;
                while ((hash2 = this.reader2.read()) != null) {
                    this.writeVariableRefs(hash2, (String)hash.get("Dataset Name"), orderNumber++);
                }
                if (!this.datasetType.equals((Object)Config.DatasetType.ADaM) && hash.get("Alias") != null && !((String)hash.get("Alias")).equals("")) {
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<Alias Context=\"DomainDescription\" Name=\"" + XmlGenerator.escapeString((String)hash.get("Alias")) + "\"/>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<def:leaf ID=\"" + this.createOID(TagType.LEAF, "", "", "", "", (String)hash.get("Dataset Name")) + "\" xlink:href=\"" + (String)hash.get("href") + "\">";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<def:title>" + XmlGenerator.escapeString((String)hash.get("Title")) + "</def:title>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</def:leaf>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</ItemGroupDef>";
                this.writer.write(str);
                this.writer.newLine();
                this.reader2.close();
                this.reader.close();
            }
            if (this.suppUtil.isAutoSuppActive()) {
                this.writeSuppItemGroupDefSection();
            }
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeSuppItemGroupDefSection() throws InvalidParameterException, TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        try {
            String str = null;
            for (SuppUtil.SuppDataset dataset : this.suppUtil.listSuppDatasets()) {
                String name = dataset.dataset_name;
                this.errHint.setErrorHint(TagType.ITEMGROUPDEF, "SUPP" + name, "", "", "");
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ItemGroupDef OID=\"" + this.createOID(TagType.ITEMGROUPDEF, "SUPP" + name, "", "", "", "") + (this.datasetType.equals((Object)Config.DatasetType.ADaM) ? "" : "\" Domain=\"" + dataset.domain) + "\" Name=\"SUPP" + name + "\" Repeating=\"Yes\" IsReferenceData=\"No\" SASDatasetName=\"SUPP" + name + "\" Purpose=\"Tabulation\" def:Structure=\"One record per IDVAR, IDVARVAL, and QNAM value per subject\" def:Class=\"RELATIONSHIP\" def:ArchiveLocationID=\"" + this.createOID(TagType.LEAF, "", "", "", "", "SUPP" + name) + "\">";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<Description>";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<TranslatedText xml:lang=\"en\">Supplemental Qualifiers for " + name + "</TranslatedText>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</Description>";
                this.writer.write(str);
                this.writer.newLine();
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ItemRef ItemOID=\"" + this.createOID(TagType.ITEMREF, "SUPP" + name, "SUPP" + name, "STUDYID", "", "") + "\" OrderNumber=\"1\" Mandatory=\"Yes\" KeySequence=\"1\"/>";
                this.writer.write(str);
                this.writer.newLine();
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ItemRef ItemOID=\"" + this.createOID(TagType.ITEMREF, "SUPP" + name, "SUPP" + name, "RDOMAIN", "", "") + "\" OrderNumber=\"2\" Mandatory=\"Yes\" KeySequence=\"2\"/>";
                this.writer.write(str);
                this.writer.newLine();
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ItemRef ItemOID=\"" + this.createOID(TagType.ITEMREF, "SUPP" + name, "SUPP" + name, "USUBJID", "", "") + "\" OrderNumber=\"3\" Mandatory=\"Yes\" KeySequence=\"3" + (this.hashUSUBJID.containsKey(name) ? "\" MethodOID=\"" + this.hashUSUBJID.get(name) : "") + "\"/>";
                this.writer.write(str);
                this.writer.newLine();
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ItemRef ItemOID=\"" + this.createOID(TagType.ITEMREF, "SUPP" + name, "SUPP" + name, "IDVAR", "", "") + "\" OrderNumber=\"4\" Mandatory=\"No\" KeySequence=\"4\"/>";
                this.writer.write(str);
                this.writer.newLine();
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ItemRef ItemOID=\"" + this.createOID(TagType.ITEMREF, "SUPP" + name, "SUPP" + name, "IDVARVAL", "", "") + "\" OrderNumber=\"5\" Mandatory=\"No\" KeySequence=\"5\"/>";
                this.writer.write(str);
                this.writer.newLine();
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ItemRef ItemOID=\"" + this.createOID(TagType.ITEMREF, "SUPP" + name, "SUPP" + name, "QNAM", "", "") + "\" OrderNumber=\"6\" Mandatory=\"Yes\" KeySequence=\"6\"/>";
                this.writer.write(str);
                this.writer.newLine();
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ItemRef ItemOID=\"" + this.createOID(TagType.ITEMREF, "SUPP" + name, "SUPP" + name, "QLABEL", "", "") + "\" OrderNumber=\"7\" Mandatory=\"Yes\"/>";
                this.writer.write(str);
                this.writer.newLine();
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ItemRef ItemOID=\"" + this.createOID(TagType.ITEMREF, "SUPP" + name, "SUPP" + name, "QVAL", "", "") + "\" OrderNumber=\"8\" Mandatory=\"Yes\"/>";
                this.writer.write(str);
                this.writer.newLine();
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ItemRef ItemOID=\"" + this.createOID(TagType.ITEMREF, "SUPP" + name, "SUPP" + name, "QORIG", "", "") + "\" OrderNumber=\"9\" Mandatory=\"Yes\"/>";
                this.writer.write(str);
                this.writer.newLine();
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ItemRef ItemOID=\"" + this.createOID(TagType.ITEMREF, "SUPP" + name, "SUPP" + name, "QEVAL", "", "") + "\" OrderNumber=\"10\" Mandatory=\"No\"/>";
                this.writer.write(str);
                this.writer.newLine();
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<def:leaf ID=\"" + this.createOID(TagType.LEAF, "", "", "", "", "SUPP" + name) + "\" xlink:href=\"supp" + name.toLowerCase() + ".xpt\">";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<def:title>supp" + name.toLowerCase() + ".xpt</def:title>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</def:leaf>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</ItemGroupDef>";
                this.writer.write(str);
                this.writer.newLine();
            }
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    private void writeVariableRefs(Hashtable<String, String> hash, String dataset, int orderNumber) throws IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        this.errHint.setErrorHint(TagType.ITEMREF, hash.get("Dataset Name"), hash.get("Variable Name"), "", "");
        try {
            int N = 0;
            String variable_name = hash.get("Variable Name");
            String strN = hash.get("Repeat N");
            if (!StringUtils.isEmpty((CharSequence)strN)) {
                try {
                    N = Integer.parseInt(strN);
                    if (N > 99) {
                        N = 0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            for (int i = 0; i <= N; ++i) {
                String is_supp = hash.get("Is SUPP");
                if (!(StringUtils.isEmpty((CharSequence)is_supp) || N <= 0 || "TSVAL".equals(variable_name) || "COVAL".equals(variable_name))) {
                    is_supp = "Yes";
                }
                if (!StringUtils.isEmpty((CharSequence)variable_name)) {
                    variable_name = variable_name.length() >= 8 && 1 <= N && N < 10 ? variable_name.substring(0, 7) + N : (variable_name.length() == 7 && 10 <= N && N < 100 ? variable_name.substring(0, 6) + N : variable_name + N);
                }
                if (is_supp != null && is_supp.equals("Yes")) continue;
                String str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ItemRef ItemOID=\"" + this.createOID(TagType.ITEMREF, hash.get(this.domainKey), hash.get("Dataset Name"), variable_name, "", "");
                str = str + "\" OrderNumber=\"" + new Integer(orderNumber).toString() + "\"";
                str = hash.get("Mandatory").equals("Yes") ? str + " Mandatory=\"Yes\"" : str + " Mandatory=\"No\"";
                if (hash.get("Key Sequence") != null && !hash.get("Key Sequence").equals("")) {
                    str = str + " KeySequence=\"" + hash.get("Key Sequence") + "\"";
                }
                if (hash.get("Origin").equals("Derived")) {
                    str = str + " MethodOID=\"" + this.createOID(TagType.METHODDEF, hash.get(this.domainKey), hash.get("Dataset Name"), hash.get("Variable Name"), "", "") + "\"";
                    if (hash.get("Variable Name").equals("USUBJID")) {
                        this.hashUSUBJID.put(hash.get("Dataset Name"), this.createOID(TagType.METHODDEF, hash.get(this.domainKey), hash.get("Dataset Name"), hash.get("Variable Name"), "", ""));
                    }
                }
                if (hash.get("Role") != null && !hash.get("Role").equals("")) {
                    str = str + " Role=\"" + hash.get("Role") + "\"";
                    if (hash.get("Role Codelist") != null && !hash.get("Role Codelist").equals("")) {
                        str = str + " RoleCodeListOID=\"" + this.createOID(TagType.CODELISTREF, "", "", "", "", DefineXmlWriter.formatCodeListID(hash.get("Role Codelist"))) + "\"";
                    } else if (hash.get("Role codelist") != null && !hash.get("Role codelist").equals("")) {
                        str = str + " RoleCodeListOID=\"" + this.createOID(TagType.CODELISTREF, "", "", "", "", DefineXmlWriter.formatCodeListID(hash.get("Role codelist"))) + "\"";
                    }
                }
                str = str + "/>";
                this.writer.write(str);
                this.writer.newLine();
            }
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeItemDefSection() throws TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        this.reader.setTable(this.config.defineVariableTableName, new WhereClause[]{new WhereClause(this.domainKey, WhereClause.Operator.NE, "")});
        this.writeItemDefSection(this.reader);
        this.reader.setTable(this.config.defineValueTableName, new WhereClause[]{new WhereClause("Value Key", WhereClause.Operator.NE, "")});
        HashSet uniqueKeys = new HashSet();
        Collections.addAll(uniqueKeys, "Dataset Name", "Variable Name", "Value Key");
        this.reader.setUniqueKeys(this.reader.getTableName(), uniqueKeys);
        this.writeItemDefSection(this.reader);
        if (this.suppUtil.isAutoSuppActive()) {
            this.writeSuppItemDefSection();
        }
        this.reader.close();
    }

    private void writeItemDefSection(MetaDataReader reader) throws IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        try {
            Hashtable<Object, Object> hash = new Hashtable();
            String str = null;
            while ((hash = reader.read()) != null) {
                String dataset_name = (String)hash.get("Dataset Name");
                String variable_name = (String)hash.get("Variable Name");
                this.errHint.setErrorHint(TagType.ITEMDEF, (String)hash.get(this.domainKey), variable_name, (String)hash.get("Value Key"), "");
                if (this.emptyDatasets.contains(dataset_name)) continue;
                Set<String> supp_dataset_names = this.suppUtil.getSuppDatasetNames();
                Set<String> supp_variables = this.suppUtil.getSuppVariableNames();
                if (supp_variables.contains(dataset_name + "/" + variable_name) && !supp_dataset_names.contains(dataset_name)) continue;
                int N = SuppUtil.parseRepeatN((String)hash.get("Repeat N"));
                N = supp_dataset_names.contains(dataset_name) ? N : 0;
                for (int i = 0; i <= N; ++i) {
                    String r_is_supp = SuppUtil.getRepeatIsSupp(variable_name, (String)hash.get("Is SUPP"), N);
                    String r_variable_name = SuppUtil.getRepeatVariableName(variable_name, N);
                    String r_variable_label = SuppUtil.getRepeatVariableLabel((String)hash.get("Label"), N);
                    String r_length = SuppUtil.getRepeatLength((String)hash.get("Length"), N);
                    String r_sas_field_name = SuppUtil.getRepeatSasFieldName(r_variable_name, (String)hash.get("SASFieldName"), N);
                    if ((this.datasetType.equals((Object)Config.DatasetType.SDTM) || this.datasetType.equals((Object)Config.DatasetType.SEND)) && !((String)hash.get("Domain")).equals("DM") && (((String)hash.get("Variable Name")).equals("STUDYID") || ((String)hash.get("Variable Name")).equals("USUBJID"))) continue;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<ItemDef OID=\"";
                    if (reader.getTableName().equals(this.config.defineVariableTableName)) {
                        str = r_is_supp != null && r_is_supp.equals("Yes") ? str + this.createOID(TagType.ITEMDEF, "SUPP" + (String)hash.get("Dataset Name"), "SUPP" + (String)hash.get("Dataset Name"), "QVAL", variable_name, "") + "\" Name=\"" + variable_name : str + this.createOID(TagType.ITEMDEF, (String)hash.get(this.domainKey), (String)hash.get("Dataset Name"), variable_name, "", "") + "\" Name=\"" + variable_name;
                    } else if (reader.getTableName().equals(this.config.defineValueTableName)) {
                        str = str + this.createOID(TagType.ITEMDEF, (String)hash.get(this.domainKey), (String)hash.get("Dataset Name"), (String)hash.get("Variable Name"), (String)hash.get("Value Key"), "") + "\" Name=\"" + (String)hash.get("Value Name");
                    }
                    str = str + "\" DataType=\"" + (String)hash.get("DataType") + (r_length == null || r_length.equals("") ? "" : "\" Length=\"" + r_length) + (hash.get("SignificantDigits") == null || ((String)hash.get("SignificantDigits")).equals("") ? "" : "\" SignificantDigits=\"" + (String)hash.get("SignificantDigits"));
                    if (reader.getTableName().equals(this.config.defineVariableTableName)) {
                        str = str + "\" SASFieldName=\"" + (r_sas_field_name == null || r_sas_field_name.equals("") ? variable_name : r_sas_field_name);
                    } else if (reader.getTableName().equals(this.config.defineValueTableName)) {
                        str = str + "\" SASFieldName=\"" + (hash.get("SASFieldName") == null || ((String)hash.get("SASFieldName")).equals("") ? (String)hash.get("Value Name") : (String)hash.get("SASFieldName"));
                    }
                    str = str + (hash.get("DisplayFormat") == null || ((String)hash.get("DisplayFormat")).equals("") ? "" : "\" def:DisplayFormat=\"" + (String)hash.get("DisplayFormat"));
                    if (hash.get("Comment") != null && !((String)hash.get("Comment")).equals("")) {
                        if (reader.getTableName().equals(this.config.defineVariableTableName)) {
                            str = hash.get("Is SUPP") != null && ((String)hash.get("Is SUPP")).equals("Yes") ? str + "\" def:CommentOID=\"" + this.createOID(TagType.COMMENTDEF, "SUPP" + (String)hash.get("Dataset Name"), "SUPP" + (String)hash.get("Dataset Name"), "QVAL", (String)hash.get("Variable Name"), "") : str + "\" def:CommentOID=\"" + this.createOID(TagType.COMMENTDEF, (String)hash.get(this.domainKey), (String)hash.get("Dataset Name"), (String)hash.get("Variable Name"), "", "");
                        } else if (reader.getTableName().equals(this.config.defineValueTableName)) {
                            str = str + "\" def:CommentOID=\"" + this.createOID(TagType.COMMENTDEF, (String)hash.get(this.domainKey), (String)hash.get("Dataset Name"), (String)hash.get("Variable Name"), (String)hash.get("Value Key"), "");
                        }
                    }
                    str = str + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<TranslatedText xml:lang=\"en\">" + XmlGenerator.escapeString(r_variable_label) + "</TranslatedText>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "</Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                    if (hash.get("Codelist") != null && !((String)hash.get("Codelist")).equals("")) {
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<CodeListRef CodeListOID=\"" + this.createOID(TagType.CODELISTREF, "", "", "", "", DefineXmlWriter.formatCodeListID((String)hash.get("Codelist"))) + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    if (hash.get("Origin") != null && ((String)hash.get("Origin")).equals("CRF")) {
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<def:Origin Type=\"CRF\">";
                        this.writer.write(str);
                        this.writer.newLine();
                        ++this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<def:DocumentRef leafID=\"" + this.createOID(TagType.LEAF, "", "", "", "", hash.get("CRF ID") != null && !((String)hash.get("CRF ID")).equals("") ? (String)hash.get("CRF ID") : this.strAnnotatedCRF) + "\">";
                        this.writer.write(str);
                        this.writer.newLine();
                        ++this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<def:PDFPageRef PageRefs=\"" + (String)hash.get("CRF Page Reference") + "\" Type=\"" + (String)hash.get("CRF Page Type") + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                        --this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "</def:DocumentRef>";
                        this.writer.write(str);
                        this.writer.newLine();
                        --this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "</def:Origin>";
                        this.writer.write(str);
                        this.writer.newLine();
                    } else if (hash.get("Origin") != null && ((String)hash.get("Origin")).equals("Predecessor")) {
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<def:Origin Type=\"Predecessor\">";
                        this.writer.write(str);
                        this.writer.newLine();
                        ++this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<Description>";
                        this.writer.write(str);
                        this.writer.newLine();
                        ++this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<TranslatedText xml:lang=\"en\">" + XmlGenerator.escapeString((String)hash.get("Predecessor/Derivation")) + "</TranslatedText>";
                        this.writer.write(str);
                        this.writer.newLine();
                        --this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "</Description>";
                        this.writer.write(str);
                        this.writer.newLine();
                        --this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "</def:Origin>";
                        this.writer.write(str);
                        this.writer.newLine();
                    } else if (hash.get("Origin") != null && !((String)hash.get("Origin")).equals("")) {
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<def:Origin Type=\"" + (String)hash.get("Origin") + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    if (reader.getTableName().equals(this.config.defineVariableTableName) && hash.get("Has Value Metadata") != null && (((String)hash.get("Has Value Metadata")).equals("Y") || ((String)hash.get("Has Value Metadata")).equals("Yes"))) {
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<def:ValueListRef ValueListOID=\"" + this.createOID(TagType.VALUELISTREF, (String)hash.get(this.domainKey), (String)hash.get("Dataset Name"), (String)hash.get("Variable Name"), "", "") + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    --this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "</ItemDef>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
            }
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    private void writeSuppItemDefSection() throws TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        String str = null;
        boolean isFirst = true;
        for (String name : this.suppUtil.getSuppDatasetNames()) {
            this.errHint.setErrorHint(TagType.ITEMDEF, "SUPP" + name, "SUPP" + name, "", "");
            if (isFirst) {
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ItemDef OID=\"" + this.createOID(TagType.ITEMDEF, "SUPP" + name, "SUPP" + name, "RDOMAIN", "", "") + "\" Name=\"RDOMAIN\" DataType=\"text\" Length=\"2\" SASFieldName=\"RDOMAIN\" def:CommentOID=\"" + this.createOID(TagType.COMMENTDEF, "SUPP" + name, "SUPP" + name, "RDOMAIN", "", "") + "\">";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<Description>";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<TranslatedText xml:lang=\"en\">Related Domain Abbreviation</TranslatedText>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</Description>";
                this.writer.write(str);
                this.writer.newLine();
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<def:Origin Type=\"Assigned\"/>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</ItemDef>";
                this.writer.write(str);
                this.writer.newLine();
                isFirst = false;
            }
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<ItemDef OID=\"" + this.createOID(TagType.ITEMDEF, "SUPP" + name, "SUPP" + name, "IDVAR", "", "") + "\" Name=\"IDVAR\" DataType=\"text" + (name.equals("DM") ? "\" Length=\"1" : "\" Length=\"5") + "\" SASFieldName=\"IDVAR\">";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<Description>";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<TranslatedText xml:lang=\"en\">Identifying Variable</TranslatedText>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</Description>";
            this.writer.write(str);
            this.writer.newLine();
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<def:Origin Type=\"Assigned\"/>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</ItemDef>";
            this.writer.write(str);
            this.writer.newLine();
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<ItemDef OID=\"" + this.createOID(TagType.ITEMDEF, "SUPP" + name, "SUPP" + name, "IDVARVAL", "", "") + "\" Name=\"IDVARVAL\" DataType=\"text" + (name.equals("DM") ? "\" Length=\"1" : "\" Length=\"" + this.suppUtil.getIdVarvalLength(name)) + "\" SASFieldName=\"IDVARVAL\">";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<Description>";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<TranslatedText xml:lang=\"en\">Identifying Variable Value</TranslatedText>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</Description>";
            this.writer.write(str);
            this.writer.newLine();
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<def:Origin Type=\"Assigned\"/>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</ItemDef>";
            this.writer.write(str);
            this.writer.newLine();
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<ItemDef OID=\"" + this.createOID(TagType.ITEMDEF, "SUPP" + name, "SUPP" + name, "QNAM", "", "") + "\" Name=\"QNAM\" DataType=\"text\" Length=\"" + this.suppUtil.getQnamLength(name) + "\" SASFieldName=\"QNAM\">";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<Description>";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<TranslatedText xml:lang=\"en\">Qualifier Variable Name</TranslatedText>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</Description>";
            this.writer.write(str);
            this.writer.newLine();
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<def:Origin Type=\"Assigned\"/>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</ItemDef>";
            this.writer.write(str);
            this.writer.newLine();
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<ItemDef OID=\"" + this.createOID(TagType.ITEMDEF, "SUPP" + name, "SUPP" + name, "QLABEL", "", "") + "\" Name=\"QLABEL\" DataType=\"text\" Length=\"" + this.suppUtil.getQlabelLength(name) + "\" SASFieldName=\"QLABEL\">";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<Description>";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<TranslatedText xml:lang=\"en\">Qualifier Variable Label</TranslatedText>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</Description>";
            this.writer.write(str);
            this.writer.newLine();
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<def:Origin Type=\"Assigned\"/>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</ItemDef>";
            this.writer.write(str);
            this.writer.newLine();
            String qvalDataType = this.suppUtil.getQvalDataType(name);
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<ItemDef OID=\"" + this.createOID(TagType.ITEMDEF, "SUPP" + name, "SUPP" + name, "QVAL", "", "") + "\" Name=\"QVAL\" DataType=\"" + qvalDataType + ("text".equals(qvalDataType) || "integer".equals(qvalDataType) || "float".equals(qvalDataType) ? "\" Length=\"" + this.suppUtil.getQvalLength(name) : "") + ("float".equals(qvalDataType) ? "\" SignificantDigits=\"" + this.suppUtil.getQvalSigDigits(name) : "") + "\" SASFieldName=\"QVAL\">";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<Description>";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<TranslatedText xml:lang=\"en\">Data Value</TranslatedText>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</Description>";
            this.writer.write(str);
            this.writer.newLine();
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<def:ValueListRef ValueListOID=\"" + this.createOID(TagType.VALUELISTREF, "SUPP" + name, "SUPP" + name, "QVAL", "", "") + "\"/>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</ItemDef>";
            this.writer.write(str);
            this.writer.newLine();
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<ItemDef OID=\"" + this.createOID(TagType.ITEMDEF, "SUPP" + name, "SUPP" + name, "QORIG", "", "") + "\" Name=\"QORIG\" DataType=\"text\" Length=\"" + this.suppUtil.getQorigLength(name) + "\" SASFieldName=\"QORIG\">";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<Description>";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<TranslatedText xml:lang=\"en\">Origin</TranslatedText>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</Description>";
            this.writer.write(str);
            this.writer.newLine();
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<def:Origin Type=\"Assigned\"/>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</ItemDef>";
            this.writer.write(str);
            this.writer.newLine();
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<ItemDef OID=\"" + this.createOID(TagType.ITEMDEF, "SUPP" + name, "SUPP" + name, "QEVAL", "", "") + "\" Name=\"QEVAL\" DataType=\"text\" Length=\"" + this.suppUtil.getQevalLength(name) + "\" SASFieldName=\"QEVAL\">";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<Description>";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<TranslatedText xml:lang=\"en\">Evaluator</TranslatedText>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</Description>";
            this.writer.write(str);
            this.writer.newLine();
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<def:Origin Type=\"Assigned\"/>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</ItemDef>";
            this.writer.write(str);
            this.writer.newLine();
        }
    }

    public void writeValueListDefSection() throws TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        try {
            this.reader.setTable(this.config.defineValueTableName, new WhereClause[]{new WhereClause("Value Key", WhereClause.Operator.NE, "")});
            HashSet uniqueKeys = new HashSet();
            Collections.addAll(uniqueKeys, "Dataset Name", "Variable Name", "Value Key");
            this.reader.setUniqueKeys(this.reader.getTableName(), uniqueKeys);
            Hashtable<Object, Object> hash = new Hashtable();
            String str = null;
            String prevDomainKey = null;
            String prevVariableName = null;
            int orderNumber = 1;
            boolean isBlank = true;
            while ((hash = this.reader.read()) != null) {
                this.errHint.setErrorHint(TagType.VALUELISTDEF, (String)hash.get(this.domainKey), (String)hash.get("Variable Name"), (String)hash.get("Value Key"), "");
                if (this.emptyDatasets.contains(hash.get("Dataset Name"))) continue;
                isBlank = false;
                if (prevVariableName == null || !(prevDomainKey + prevVariableName).equals((String)hash.get("Dataset Name") + (String)hash.get("Variable Name"))) {
                    orderNumber = 1;
                    if (prevVariableName != null) {
                        --this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "</def:ValueListDef>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<def:ValueListDef OID=\"" + this.createOID(TagType.VALUELISTDEF, (String)hash.get(this.domainKey), (String)hash.get("Dataset Name"), (String)hash.get("Variable Name"), "", "") + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                }
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ItemRef ItemOID=\"" + this.createOID(TagType.ITEMREF, (String)hash.get(this.domainKey), (String)hash.get("Dataset Name"), (String)hash.get("Variable Name"), (String)hash.get("Value Key"), "") + "\" OrderNumber=\"" + orderNumber + "\" Mandatory=\"" + (((String)hash.get("Mandatory")).equals("Yes") ? "Yes" : "No");
                if (((String)hash.get("Origin")).equals("Derived")) {
                    str = str + "\" MethodOID=\"" + this.createOID(TagType.METHODDEF, (String)hash.get(this.domainKey), (String)hash.get("Dataset Name"), (String)hash.get("Variable Name"), (String)hash.get("Value Key"), "");
                }
                if (hash.get("WhereClauseValue") != null && !((String)hash.get("WhereClauseValue")).equals("")) {
                    str = str + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<def:WhereClauseRef WhereClauseOID=\"" + this.createOID(TagType.WHERECLAUSEREF, (String)hash.get(this.domainKey), (String)hash.get("Dataset Name"), (String)hash.get("Variable Name"), (String)hash.get("Value Key"), "") + "\"/>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "</ItemRef>";
                    this.writer.write(str);
                    this.writer.newLine();
                } else {
                    str = str + "\"/>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
                ++orderNumber;
                prevDomainKey = (String)hash.get("Dataset Name");
                prevVariableName = (String)hash.get("Variable Name");
            }
            if (!isBlank) {
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</def:ValueListDef>";
                this.writer.write(str);
                this.writer.newLine();
            }
            this.reader.close();
            if (this.suppUtil.isAutoSuppActive()) {
                this.writeSuppValueListDefSection();
            }
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeSuppValueListDefSection() throws TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        try {
            String str = null;
            int orderNumber = 1;
            for (String name : this.suppUtil.getSuppDatasetNames()) {
                this.errHint.setErrorHint(TagType.VALUELISTDEF, "SUPP" + name, "SUPP" + name, "QVAL", "");
                orderNumber = 1;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<def:ValueListDef OID=\"" + this.createOID(TagType.VALUELISTDEF, "SUPP" + name, "SUPP" + name, "QVAL", "", "") + "\">";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                for (SuppUtil.Variable var : this.suppUtil.listSuppVariables(name)) {
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<ItemRef ItemOID=\"" + this.createOID(TagType.ITEMREF, "SUPP" + name, "SUPP" + name, "QVAL", var.variable_name, "") + "\" OrderNumber=\"" + orderNumber + "\" Mandatory=\"" + ("Yes".equals(var.mandatory) ? "Yes" : "No") + (StringUtils.equals((CharSequence)"Derived", (CharSequence)var.origin.origin) ? "\" MethodOID=\"" + this.createOID(TagType.METHODDEF, "SUPP" + name, "SUPP" + name, "QVAL", var.variable_name, "") : "") + "\" >";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<def:WhereClauseRef WhereClauseOID=\"" + this.createOID(TagType.WHERECLAUSEREF, "SUPP" + name, "SUPP" + name, "QNAM", var.variable_name, "") + "\"/>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "</ItemRef>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++orderNumber;
                }
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</def:ValueListDef>";
                this.writer.write(str);
                this.writer.newLine();
            }
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeWhereClauseDefSection() throws TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        this.reader.setTable(this.config.defineValueTableName);
        this.writeWhereClauseDefSection(this.reader);
        if (this.datasetType.equals((Object)Config.DatasetType.ADaM) && this.config.e2dIncludeResultMetadata) {
            this.reader.setTable(this.config.defineResult2TableName, new WhereClause[]{new WhereClause("WhereClauseVariable", WhereClause.Operator.NE, "")});
            this.writeWhereClauseDefSection(this.reader);
        }
        if (this.suppUtil.isAutoSuppActive()) {
            this.writeSuppWhereClauseDefSection();
        }
    }

    public void writeWhereClauseDefSection(MetaDataReader reader) throws TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        try {
            Hashtable<Object, Object> hash = new Hashtable();
            String str = null;
            boolean isNewWhereClause = true;
            String prevKey = null;
            boolean isBlank = true;
            while ((hash = reader.read()) != null) {
                if (this.emptyDatasets.contains(hash.get("W Dataset Name"))) continue;
                isBlank = false;
                boolean haveWC = false;
                if (reader.getTableName().equals(this.config.defineValueTableName)) {
                    if (hash.get("WhereClauseValue") != null && !((String)hash.get("WhereClauseValue")).equals("")) {
                        haveWC = true;
                    }
                } else if (reader.getTableName().equals(this.config.defineResult2TableName) && hash.get("W Result Key") != null && !((String)hash.get("W Result Key")).equals("") && hash.get("W Display Name") != null && !((String)hash.get("W Display Name")).equals("") && hash.get("W Dataset Name") != null && !((String)hash.get("W Dataset Name")).equals("")) {
                    haveWC = true;
                }
                if (reader.getTableName().equals(this.config.defineValueTableName)) {
                    this.errHint.setErrorHint(TagType.WHERECLAUSEDEF, (String)hash.get(this.wDomainKey), (String)hash.get("W Variable Name"), (String)hash.get("W Value Key"), "");
                } else if (reader.getTableName().equals(this.config.defineResult2TableName)) {
                    this.errHint.setErrorHint(TagType.WHERECLAUSEDEF, "", "", "", "WhereClauseVariable=" + (String)hash.get("WhereClauseVariable"));
                }
                if (reader.getTableName().equals(this.config.defineValueTableName)) {
                    isNewWhereClause = haveWC ? prevKey == null || !prevKey.equals((String)hash.get(this.wDomainKey) + "." + (String)hash.get("W Variable Name") + "." + (String)hash.get("W Value Key")) : false;
                }
                if (reader.getTableName().equals(this.config.defineResult2TableName)) {
                    isNewWhereClause = haveWC ? prevKey == null || !prevKey.equals((String)hash.get("W Display Name") + "." + (String)hash.get("W Result Key") + "." + (String)hash.get("W Dataset Name")) : false;
                }
                if (isNewWhereClause) {
                    if (prevKey != null) {
                        --this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "</def:WhereClauseDef>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    str = DefineXmlWriter.insertIndent(this.indent);
                    if (reader.getTableName().equals(this.config.defineValueTableName)) {
                        if (haveWC) {
                            str = str + "<def:WhereClauseDef OID=\"" + this.createOID(TagType.WHERECLAUSEDEF, (String)hash.get(this.wDomainKey), (String)hash.get("W Dataset Name"), (String)hash.get("W Variable Name"), (String)hash.get("W Value Key"), "");
                            if (hash.get("WhereClause Comment") != null && !((String)hash.get("WhereClause Comment")).equals("")) {
                                str = str + "\" def:CommentOID=\"" + this.createOID(TagType.COMMENTDEF, (String)hash.get(this.wDomainKey), (String)hash.get("W Dataset Name"), (String)hash.get("W Variable Name"), (String)hash.get("W Value Key"), "WC");
                            }
                        }
                    } else if (reader.getTableName().equals(this.config.defineResult2TableName)) {
                        if (haveWC) {
                            str = str + "<def:WhereClauseDef OID=\"" + this.createOID(TagType.WHERECLAUSEDEF, "", "", "", "", (String)hash.get("W Display Name") + "." + (String)hash.get("W Result Key") + "." + (String)hash.get("W Dataset Name"));
                        }
                        if (hash.get("WhereClause Comment") != null && !((String)hash.get("WhereClause Comment")).equals("")) {
                            str = str + "\" def:CommentOID=\"" + this.createOID(TagType.COMMENTDEF, "", "", "", "", "WC." + (String)hash.get("W Display Name") + "." + (String)hash.get("W Result Key") + "." + (String)hash.get("W Dataset Name"));
                        }
                    }
                    str = str + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                }
                str = DefineXmlWriter.insertIndent(this.indent);
                if (reader.getTableName().equals(this.config.defineValueTableName)) {
                    if (haveWC) {
                        str = str + "<RangeCheck SoftHard=\"Soft\" def:ItemOID=\"" + this.createOID(TagType.ITEMDEF, (String)hash.get(this.wDomainKey), (String)hash.get("WhereClauseDataset"), (String)hash.get("WhereClauseVariable"), "", "");
                    }
                } else if (reader.getTableName().equals(this.config.defineResult2TableName) && haveWC) {
                    str = str + "<RangeCheck SoftHard=\"Soft\" def:ItemOID=\"" + this.createOID(TagType.ITEMDEF, (String)hash.get(this.wDomainKey), (String)hash.get("WhereClauseDataset"), (String)hash.get("WhereClauseVariable"), "", "");
                }
                if (haveWC) {
                    str = str + "\" Comparator=\"" + (String)hash.get("WhereClauseOperator") + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    String[] checkValues = ((String)hash.get("WhereClauseValue")).split(this.DELIMITER);
                    for (int i = 0; i < checkValues.length; ++i) {
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<CheckValue>" + XmlGenerator.escapeString(checkValues[i].trim()) + "</CheckValue>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    --this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "</RangeCheck>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
                if (reader.getTableName().equals(this.config.defineValueTableName)) {
                    if (!haveWC) continue;
                    prevKey = (String)hash.get("W Dataset Name") + "." + (String)hash.get("W Variable Name") + "." + (String)hash.get("W Value Key");
                    continue;
                }
                if (!reader.getTableName().equals(this.config.defineResult2TableName) || !haveWC) continue;
                prevKey = (String)hash.get("W Display Name") + "." + (String)hash.get("W Result Key") + "." + (String)hash.get("W Dataset Name");
            }
            if (!isBlank) {
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</def:WhereClauseDef>";
                this.writer.write(str);
                this.writer.newLine();
            }
            reader.close();
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeSuppWhereClauseDefSection() throws TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        try {
            String str = null;
            for (String name : this.suppUtil.getSuppDatasetNames()) {
                this.errHint.setErrorHint(TagType.WHERECLAUSEDEF, "SUPP" + name, "SUPP" + name, "QNAM", "");
                for (SuppUtil.Variable var : this.suppUtil.listSuppVariables(name)) {
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<def:WhereClauseDef OID=\"" + this.createOID(TagType.WHERECLAUSEDEF, "SUPP" + name, "SUPP" + name, "QNAM", var.variable_name, "");
                    str = str + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<RangeCheck SoftHard=\"Soft\" def:ItemOID=\"" + this.createOID(TagType.ITEMDEF, "SUPP" + name, "SUPP" + name, "QNAM", "", "") + "\" Comparator=\"EQ\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<CheckValue>" + var.variable_name + "</CheckValue>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "</RangeCheck>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "</def:WhereClauseDef>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
            }
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeCodelistSection() throws TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        try {
            this.reader.setTable(this.config.defineCodelistTableName);
            Hashtable<Object, Object> hash = new Hashtable();
            String str = null;
            String prevCodelistID = null;
            String prevCodelistCode = null;
            boolean isBlank = true;
            boolean hasDecodeValue = false;
            while ((hash = this.reader.read()) != null) {
                this.errHint.setErrorHint(TagType.CODELIST, "", "", "", (String)hash.get("Codelist ID"));
                if (this.emptyCodelists.contains(hash.get("Codelist ID"))) continue;
                if (prevCodelistID == null || !prevCodelistID.equals(hash.get("Codelist ID"))) {
                    hasDecodeValue = hash.get("Translated Text") != null && !((String)hash.get("Translated Text")).equals("") || hash.get("Decode") != null && !((String)hash.get("Decode")).equals("");
                    if (prevCodelistID != null) {
                        if (prevCodelistCode != null && !prevCodelistCode.equals("")) {
                            str = DefineXmlWriter.insertIndent(this.indent);
                            str = str + "<Alias Name=\"" + prevCodelistCode + "\" Context=\"nci:ExtCodeID\"/>";
                            this.writer.write(str);
                            this.writer.newLine();
                        }
                        --this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "</CodeList>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    isBlank = false;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<CodeList OID=\"" + this.createOID(TagType.CODELIST, "", "", "", "", (String)hash.get("Codelist ID")) + "\" Name=\"" + XmlGenerator.escapeString((String)hash.get("Codelist Label")) + "\" DataType=\"" + (String)hash.get("DataType") + (hash.get("SASFormatName") == null || ((String)hash.get("SASFormatName")).equals("") ? "" : "\" SASFormatName=\"" + (String)hash.get("SASFormatName")) + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                }
                if (!hasDecodeValue) {
                    if (hash.get("Codelist Code") != null && !((String)hash.get("Codelist Code")).equals("")) {
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<EnumeratedItem CodedValue=\"" + XmlGenerator.escapeString((String)hash.get("Submission Value")) + (hash.get("Order Number") == null || ((String)hash.get("Order Number")).equals("") ? "" : "\" OrderNumber=\"" + (String)hash.get("Order Number")) + (hash.get("ExtendedValue") != null && ((String)hash.get("ExtendedValue")).equals("Yes") ? "\" def:ExtendedValue=\"" + (String)hash.get("ExtendedValue") : "") + "\">";
                        this.writer.write(str);
                        this.writer.newLine();
                        ++this.indent;
                        if (hash.get("ExtendedValue") != null && !((String)hash.get("ExtendedValue")).equals("Yes")) {
                            str = DefineXmlWriter.insertIndent(this.indent);
                            str = str + "<Alias Name=\"" + (String)hash.get("Code") + "\" Context=\"nci:ExtCodeID\"/>";
                            this.writer.write(str);
                            this.writer.newLine();
                        }
                        --this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "</EnumeratedItem>";
                        this.writer.write(str);
                        this.writer.newLine();
                    } else {
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<EnumeratedItem CodedValue=\"" + XmlGenerator.escapeString((String)hash.get("Submission Value")) + (hash.get("Rank") == null || ((String)hash.get("Rank")).equals("") ? "" : "\" Rank=\"" + (String)hash.get("Rank")) + (hash.get("Order Number") == null || ((String)hash.get("Order Number")).equals("") ? "" : "\" OrderNumber=\"" + (String)hash.get("Order Number")) + (hash.get("ExtendedValue") != null && ((String)hash.get("ExtendedValue")).equals("Yes") ? "\" def:ExtendedValue=\"" + (String)hash.get("ExtendedValue") : "") + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                } else {
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<CodeListItem CodedValue=\"" + XmlGenerator.escapeString((String)hash.get("Submission Value")) + (hash.get("Rank") == null || ((String)hash.get("Rank")).equals("") ? "" : "\" Rank=\"" + (String)hash.get("Rank")) + (hash.get("Order Number") == null || ((String)hash.get("Order Number")).equals("") ? "" : "\" OrderNumber=\"" + (String)hash.get("Order Number")) + (hash.get("ExtendedValue") != null && ((String)hash.get("ExtendedValue")).equals("Yes") ? "\" def:ExtendedValue=\"" + (String)hash.get("ExtendedValue") : "") + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<Decode>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<TranslatedText xml:lang=\"" + (hash.get("xml:lang") != null && !((String)hash.get("xml:lang")).equals("") ? (String)hash.get("xml:lang") : "en") + "\">" + (hash.get("Translated Text") == null || ((String)hash.get("Translated Text")).equals("") ? XmlGenerator.escapeString((String)hash.get("Decode")) : XmlGenerator.escapeString((String)hash.get("Translated Text"))) + "</TranslatedText>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "</Decode>";
                    this.writer.write(str);
                    this.writer.newLine();
                    if (hash.get("Codelist Code") != null && !((String)hash.get("Codelist Code")).equals("") && !((String)hash.get("ExtendedValue")).equals("Yes")) {
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<Alias Name=\"" + (String)hash.get("Code") + "\" Context=\"nci:ExtCodeID\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    --this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "</CodeListItem>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
                prevCodelistID = (String)hash.get("Codelist ID");
                prevCodelistCode = (String)hash.get("Codelist Code");
            }
            if (prevCodelistCode != null && !prevCodelistCode.equals("")) {
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<Alias Name=\"" + prevCodelistCode + "\" Context=\"nci:ExtCodeID\"/>";
                this.writer.write(str);
                this.writer.newLine();
            }
            if (!isBlank) {
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</CodeList>";
                this.writer.write(str);
                this.writer.newLine();
            }
            this.reader.setTable(this.config.defineDictionaryTableName);
            while ((hash = this.reader.read()) != null) {
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<CodeList OID=\"" + this.createOID(TagType.CODELIST, "", "", "", "", (String)hash.get("Dictionary ID")) + "\" Name=\"" + XmlGenerator.escapeString((String)hash.get("Name")) + "\" DataType=\"" + (String)hash.get("DataType") + "\">";
                ++this.indent;
                this.writer.write(str);
                this.writer.newLine();
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<ExternalCodeList Dictionary=\"" + (String)hash.get("Dictionary ID") + "\" Version=\"" + (String)hash.get("Version") + (hash.get("ref") == null || ((String)hash.get("ref")).equals("") ? "" : "\" ref=\"" + XmlGenerator.escapeString((String)hash.get("ref"))) + (hash.get("href") == null || ((String)hash.get("href")).equals("") ? "" : "\" href=\"" + XmlGenerator.escapeString((String)hash.get("href"))) + "\"/>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</CodeList>";
                this.writer.write(str);
                this.writer.newLine();
            }
            this.reader.close();
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeMethodDefSection() throws TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        this.reader.setTable(this.config.defineVariableTableName, new WhereClause[]{new WhereClause("Origin", WhereClause.Operator.EQ, "Derived")});
        this.writeMethodDefSection(this.reader);
        this.reader.setTable(this.config.defineValueTableName, new WhereClause[]{new WhereClause("Origin", WhereClause.Operator.EQ, "Derived")});
        this.writeMethodDefSection(this.reader);
        this.reader.close();
    }

    private void writeMethodDefSection(MetaDataReader reader) throws IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        try {
            Hashtable<Object, Object> hash = new Hashtable();
            String str = null;
            while ((hash = reader.read()) != null) {
                this.errHint.setErrorHint(TagType.METHODDEF, (String)hash.get(this.domainKey), (String)hash.get("Variable Name"), (String)hash.get("Value Key"), "");
                String dataset_name = (String)hash.get("Dataset Name");
                String is_supp = (String)hash.get("Is SUPP");
                if (this.emptyDatasets.contains(dataset_name)) continue;
                Set<String> supp_dataset_names = this.suppUtil.getSuppDatasetNames();
                if ("Yes".equals(is_supp) && !supp_dataset_names.contains(dataset_name) || hash.get("Variable Name") == null || hash.get("Predecessor/Derivation") == null && ((String)hash.get("Predecessor/Derivation")).equals("") || (this.datasetType.equals((Object)Config.DatasetType.SDTM) || this.datasetType.equals((Object)Config.DatasetType.SEND)) && !((String)hash.get("Domain")).equals("DM") && (((String)hash.get("Variable Name")).equals("STUDYID") || ((String)hash.get("Variable Name")).equals("USUBJID"))) continue;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<MethodDef OID=\"";
                if (reader.getTableName().equals(this.config.defineVariableTableName) && (is_supp == null || !is_supp.equals("Yes"))) {
                    str = str + this.createOID(TagType.METHODDEF, (String)hash.get(this.domainKey), (String)hash.get("Dataset Name"), (String)hash.get("Variable Name"), "", "") + "\" Name=\"Algorithm to derive " + (String)hash.get("Variable Name");
                } else if (reader.getTableName().equals(this.config.defineValueTableName)) {
                    str = str + this.createOID(TagType.METHODDEF, (String)hash.get(this.domainKey), (String)hash.get("Dataset Name"), (String)hash.get("Variable Name"), (String)hash.get("Value Key"), "") + "\" Name=\"Algorithm to derive " + (String)hash.get("Variable Name") + "." + (String)hash.get("Value Key");
                } else if (reader.getTableName().equals(this.config.defineVariableTableName) && is_supp != null && is_supp.equals("Yes")) {
                    str = str + this.createOID(TagType.METHODDEF, "SUPP" + (String)hash.get(this.domainKey), "SUPP" + (String)hash.get("Dataset Name"), "QVAL", (String)hash.get("Variable Name"), "") + "\" Name=\"Algorithm to derive SUPP" + (String)hash.get("Dataset Name") + "." + (String)hash.get("Variable Name");
                }
                str = str + "\" Type=\"" + (String)hash.get("Derivation Type") + "\">";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<Description>";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<TranslatedText xml:lang=\"" + (hash.get("xml:lang") != null && !((String)hash.get("xml:lang")).equals("") ? (String)hash.get("xml:lang") : "en") + "\">" + XmlGenerator.escapeString((String)hash.get("Predecessor/Derivation")) + "</TranslatedText>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</Description>";
                this.writer.write(str);
                this.writer.newLine();
                if (hash.get("FormalExpression Text") != null && !((String)hash.get("FormalExpression Text")).equals("")) {
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<FormalExpression Context=\"" + XmlGenerator.escapeString((String)hash.get("FormalExpression Context")) + "\">" + XmlGenerator.escapeString((String)hash.get("FormalExpression Text")) + "</FormalExpression>";
                    this.writer.write(str);
                    this.writer.newLine();
                } else if (hash.get("Formal expression") != null && !((String)hash.get("Formal expression")).equals("")) {
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<FormalExpression Context=\"" + XmlGenerator.escapeString((String)hash.get("Formal expression context")) + "\">" + XmlGenerator.escapeString((String)hash.get("Formal expression")) + "</FormalExpression>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
                if ((hash.get("Comment") == null || ((String)hash.get("Comment")).equals("")) && hash.get("DocumentID") != null && !((String)hash.get("DocumentID")).equals("")) {
                    String[] checkValues = ((String)hash.get("DocumentID")).split(this.DELIMITER);
                    for (int i = 0; i < checkValues.length; ++i) {
                        if (hash.get("Document Page Type") != null && hash.get("Document Page Reference") != null && i < Arrays.asList(((String)hash.get("Document Page Type")).split(this.DELIMITER)).size() && i < Arrays.asList(((String)hash.get("Document Page Reference")).split(this.DELIMITER)).size() && !Arrays.asList(((String)hash.get("Document Page Type")).split(this.DELIMITER)).get(i).trim().equals("")) {
                            str = DefineXmlWriter.insertIndent(this.indent);
                            str = str + "<def:DocumentRef leafID=\"" + this.createOID(TagType.LEAF, "", "", "", "", checkValues[i].trim()) + "\">";
                            this.writer.write(str);
                            this.writer.newLine();
                            ++this.indent;
                            str = DefineXmlWriter.insertIndent(this.indent);
                            str = str + "<def:PDFPageRef PageRefs=\"" + Arrays.asList(((String)hash.get("Document Page Reference")).split(this.DELIMITER)).get(i).trim() + "\" Type=\"" + Arrays.asList(((String)hash.get("Document Page Type")).split(this.DELIMITER)).get(i).trim() + "\"/>";
                            this.writer.write(str);
                            this.writer.newLine();
                            --this.indent;
                            str = DefineXmlWriter.insertIndent(this.indent);
                            str = str + "</def:DocumentRef>";
                            this.writer.write(str);
                            this.writer.newLine();
                            continue;
                        }
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<def:DocumentRef leafID=\"" + this.createOID(TagType.LEAF, "", "", "", "", checkValues[i].trim()) + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                }
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</MethodDef>";
                this.writer.write(str);
                this.writer.newLine();
            }
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeCommentDefSection() throws TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        this.reader.setTable(this.config.defineDatasetTableName, new WhereClause[]{new WhereClause("Comment", WhereClause.Operator.NE, "")});
        this.writeCommentDefSection(this.reader);
        this.reader.setTable(this.config.defineVariableTableName, new WhereClause[]{new WhereClause("Comment", WhereClause.Operator.NE, "")});
        this.writeCommentDefSection(this.reader);
        if (this.suppUtil.isAutoSuppActive()) {
            for (String name : this.suppUtil.getSuppDatasetNames()) {
                String str = null;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<def:CommentDef OID=\"";
                str = str + this.createOID(TagType.COMMENTDEF, "SUPP" + name, "SUPP" + name, "RDOMAIN", "", "");
                str = str + "\">";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<Description>";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<TranslatedText xml:lang=\"en\">Domain abbreviation from where data originated.</TranslatedText>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</Description>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</def:CommentDef>";
                this.writer.write(str);
                this.writer.newLine();
            }
        }
        this.reader.setTable(this.config.defineValueTableName, new WhereClause[]{new WhereClause("Comment", WhereClause.Operator.NE, "")});
        HashSet uniqueKeys = new HashSet();
        Collections.addAll(uniqueKeys, "Dataset Name", "Variable Name", "Value Key");
        this.reader.setUniqueKeys(this.reader.getTableName(), uniqueKeys);
        this.writeCommentDefSection(this.reader);
        this.reader.setTable(this.config.defineValueTableName, new WhereClause[]{new WhereClause("WhereClause Comment", WhereClause.Operator.NE, ""), new WhereClause("Value Key", WhereClause.Operator.NE, "")});
        this.writeCommentDefSection(this.reader);
        if (this.datasetType.equals((Object)Config.DatasetType.ADaM) && this.config.e2dIncludeResultMetadata) {
            this.reader.setTable(this.config.defineResult1TableName, new WhereClause[]{new WhereClause("Datasets Comment", WhereClause.Operator.NE, "")});
            this.writeCommentDefSection(this.reader);
        }
        if (this.datasetType.equals((Object)Config.DatasetType.ADaM) && this.config.e2dIncludeResultMetadata) {
            this.reader.setTable(this.config.defineResult2TableName, new WhereClause[]{new WhereClause("WhereClause Comment", WhereClause.Operator.NE, "")});
            this.writeCommentDefSection(this.reader);
        }
        this.reader.close();
    }

    private void writeCommentDefSection(MetaDataReader reader) throws IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        try {
            Hashtable<Object, Object> hash = new Hashtable();
            String str = null;
            while ((hash = reader.read()) != null) {
                if (reader.getTableName().equals(this.config.defineValueTableName)) {
                    this.errHint.setErrorHint(TagType.COMMENTDEF, (String)hash.get(this.wDomainKey), (String)hash.get("W Variable Name"), (String)hash.get("W Value Key"), "");
                } else if (reader.getTableName().equals(this.config.defineResult2TableName)) {
                    this.errHint.setErrorHint(TagType.COMMENTDEF, "", "", "", "Result Key=" + (String)hash.get("Result Key"));
                } else if (reader.getTableName().equals(this.config.defineResult2TableName)) {
                    this.errHint.setErrorHint(TagType.COMMENTDEF, "", "", "", "WhereClauseVariable=" + (String)hash.get("WhereClauseVariable"));
                } else if (reader.getTableName().equals(this.config.defineVariableTableName) && hash.get("Is SUPP") != null && ((String)hash.get("Is SUPP")).equals("Yes")) {
                    this.errHint.setErrorHint(TagType.COMMENTDEF, "SUPP" + (String)hash.get("Dataset Name"), "SUPP" + (String)hash.get("Dataset Name"), (String)hash.get("Variable Name"), "");
                } else {
                    this.errHint.setErrorHint(TagType.COMMENTDEF, (String)hash.get(this.domainKey), (String)hash.get("Variable Name"), (String)hash.get("Value Key"), "");
                }
                if (this.emptyDatasets.contains(hash.get("Dataset Name")) || this.emptyDatasets.contains(hash.get("W Dataset Name"))) continue;
                Set<String> supp_dataset_names = this.suppUtil.getSuppDatasetNames();
                if ("Yes".equals(hash.get("Is SUPP")) && !supp_dataset_names.contains(hash.get("Dataset Name")) || !reader.getTableName().equals(this.config.defineDatasetTableName) && !reader.getTableName().equals(this.config.defineResult1TableName) && !reader.getTableName().equals(this.config.defineResult2TableName) && (hash.get("Variable Name") == null || (this.datasetType.equals((Object)Config.DatasetType.SDTM) || this.datasetType.equals((Object)Config.DatasetType.SEND)) && !((String)hash.get("Domain")).equals("DM") && (((String)hash.get("Variable Name")).equals("STUDYID") || ((String)hash.get("Variable Name")).equals("USUBJID")))) continue;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<def:CommentDef OID=\"";
                if (reader.getTableName().equals(this.config.defineDatasetTableName)) {
                    str = str + this.createOID(TagType.COMMENTDEF, (String)hash.get("Dataset Name"), "", "", "", "");
                } else if (reader.getTableName().equals(this.config.defineVariableTableName) && (hash.get("Is SUPP") == null || !((String)hash.get("Is SUPP")).equals("Yes"))) {
                    str = str + this.createOID(TagType.COMMENTDEF, (String)hash.get(this.domainKey), (String)hash.get("Dataset Name"), (String)hash.get("Variable Name"), "", "");
                } else if (reader.getTableName().equals(this.config.defineVariableTableName) && hash.get("Is SUPP") != null && ((String)hash.get("Is SUPP")).equals("Yes")) {
                    str = str + this.createOID(TagType.COMMENTDEF, "SUPP" + (String)hash.get("Dataset Name"), "SUPP" + (String)hash.get("Dataset Name"), "QVAL", (String)hash.get("Variable Name"), "");
                } else if (reader.getTableName().equals(this.config.defineValueTableName) && reader.getWhereClause()[0].getVariable().equals("Comment")) {
                    str = str + this.createOID(TagType.COMMENTDEF, (String)hash.get(this.domainKey), (String)hash.get("Dataset Name"), (String)hash.get("Variable Name"), (String)hash.get("Value Key"), "");
                } else if (reader.getTableName().equals(this.config.defineValueTableName) && reader.getWhereClause()[0].getVariable().equals("WhereClause Comment")) {
                    str = str + this.createOID(TagType.COMMENTDEF, (String)hash.get(this.wDomainKey), (String)hash.get("W Dataset Name"), (String)hash.get("W Variable Name"), (String)hash.get("W Value Key"), "WC");
                } else if (reader.getTableName().equals(this.config.defineResult1TableName)) {
                    str = str + this.createOID(TagType.COMMENTDEF, "", "", "", "", "Datasets." + (String)hash.get("W Display Name") + "." + (String)hash.get("Result Key"));
                } else if (reader.getTableName().equals(this.config.defineResult2TableName)) {
                    str = str + this.createOID(TagType.COMMENTDEF, "", "", "", "", "WC." + (String)hash.get("W Display Name") + "." + (String)hash.get("W Result Key") + "." + (String)hash.get("W Dataset Name"));
                }
                str = str + "\">";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<Description>";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<TranslatedText xml:lang=\"";
                str = reader.getTableName().equals(this.config.defineValueTableName) && reader.getWhereClause()[0].getVariable().equals("WhereClause Comment") ? str + (hash.get("W xml:lang") != null && !((String)hash.get("W xml:lang")).equals("") ? (String)hash.get("W xml:lang") : "en") + "\">" + XmlGenerator.escapeString((String)hash.get("WhereClause Comment")) : (reader.getTableName().equals(this.config.defineResult1TableName) ? str + (hash.get("Datasets xml:lang") != null && !((String)hash.get("Datasets xml:lang")).equals("") ? (String)hash.get("Datasets xml:lang") : "en") + "\">" + XmlGenerator.escapeString((String)hash.get("Datasets Comment")) : (reader.getTableName().equals(this.config.defineResult2TableName) ? str + (hash.get("W xml:lang") != null && !((String)hash.get("W xml:lang")).equals("") ? (String)hash.get("W xml:lang") : "en") + "\">" + XmlGenerator.escapeString((String)hash.get("WhereClause Comment")) : str + (hash.get("xml:lang") != null && !((String)hash.get("xml:lang")).equals("") ? (String)hash.get("xml:lang") : "en") + "\">" + XmlGenerator.escapeString((String)hash.get("Comment"))));
                str = str + "</TranslatedText>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</Description>";
                this.writer.write(str);
                this.writer.newLine();
                if (!(reader.getTableName().equals(this.config.defineValueTableName) && reader.getWhereClause()[0].getVariable().equals("WhereClause Comment") || hash.get("DocumentID") == null || ((String)hash.get("DocumentID")).equals(""))) {
                    String[] checkValues = ((String)hash.get("DocumentID")).split(this.DELIMITER);
                    for (int i = 0; i < checkValues.length; ++i) {
                        if (hash.get("Document Page Type") != null && hash.get("Document Page Reference") != null && i < Arrays.asList(((String)hash.get("Document Page Type")).split(this.DELIMITER)).size() && i < Arrays.asList(((String)hash.get("Document Page Reference")).split(this.DELIMITER)).size() && !Arrays.asList(((String)hash.get("Document Page Type")).split(this.DELIMITER)).get(i).trim().equals("")) {
                            str = DefineXmlWriter.insertIndent(this.indent);
                            str = str + "<def:DocumentRef leafID=\"" + this.createOID(TagType.LEAF, "", "", "", "", checkValues[i].trim()) + "\">";
                            this.writer.write(str);
                            this.writer.newLine();
                            ++this.indent;
                            str = DefineXmlWriter.insertIndent(this.indent);
                            str = str + "<def:PDFPageRef PageRefs=\"" + Arrays.asList(((String)hash.get("Document Page Reference")).split(this.DELIMITER)).get(i).trim() + "\" Type=\"" + Arrays.asList(((String)hash.get("Document Page Type")).split(this.DELIMITER)).get(i).trim() + "\"/>";
                            this.writer.write(str);
                            this.writer.newLine();
                            --this.indent;
                            str = DefineXmlWriter.insertIndent(this.indent);
                            str = str + "</def:DocumentRef>";
                            this.writer.write(str);
                            this.writer.newLine();
                            continue;
                        }
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<def:DocumentRef leafID=\"" + this.createOID(TagType.LEAF, "", "", "", "", checkValues[i].trim()) + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                }
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</def:CommentDef>";
                this.writer.write(str);
                this.writer.newLine();
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeLeafSection() throws TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        try {
            this.reader.setTable(this.config.defineDocumentTableName);
            Hashtable<Object, Object> hash = new Hashtable();
            String str = null;
            while ((hash = this.reader.read()) != null) {
                this.errHint.setErrorHint(TagType.LEAF, "", "", "", (String)hash.get("ID"));
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<def:leaf ID=\"" + this.createOID(TagType.LEAF, "", "", "", "", (String)hash.get("ID")) + "\" xlink:href=\"" + (String)hash.get("href") + "\">";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<def:title>" + (String)hash.get("Title") + "</def:title>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</def:leaf>";
                this.writer.write(str);
                this.writer.newLine();
            }
            this.reader.close();
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeAnalysisResultSection() throws TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        try {
            this.reader.setTable(this.config.defineResult1TableName);
            Hashtable<String, String> hash = null;
            Hashtable<String, String> hash2 = null;
            String str = null;
            String[] checkValues = null;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "<arm:AnalysisResultDisplays>";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            do {
                int i;
                if (hash == null) {
                    hash = this.reader.read();
                }
                this.errHint.setErrorHint(TagType.RESULTDISPLAY, "", "", "", "Display Name=" + hash.get("Display Name"));
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<arm:ResultDisplay OID=\"" + this.createOID(TagType.RESULTDISPLAY, "", "", "", "", hash.get("Display Name")) + "\" Name=\"" + hash.get("Display Name") + "\">";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<Description>";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "<TranslatedText xml:lang=\"" + (hash.get("Display xml:lang") != null && !hash.get("Display xml:lang").equals("") ? hash.get("Display xml:lang") : "en") + "\">" + XmlGenerator.escapeString(hash.get("Display Description")) + "</TranslatedText>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</Description>";
                this.writer.write(str);
                this.writer.newLine();
                if (hash.get("Leaf ID") != null && !hash.get("Leaf ID").equals("")) {
                    checkValues = hash.get("Leaf ID").split(this.DELIMITER);
                    for (i = 0; i < checkValues.length; ++i) {
                        if (hash.get("Leaf Page Type") != null && hash.get("Leaf Page Reference") != null && i < Arrays.asList(hash.get("Leaf Page Type").split(this.DELIMITER)).size() && i < Arrays.asList(hash.get("Leaf Page Reference").split(this.DELIMITER)).size() && !Arrays.asList(hash.get("Leaf Page Type").split(this.DELIMITER)).get(i).trim().equals("")) {
                            str = DefineXmlWriter.insertIndent(this.indent);
                            str = str + "<def:DocumentRef leafID=\"" + this.createOID(TagType.DOCUMENTREF, "", "", "", "", checkValues[i].trim()) + "\">";
                            this.writer.write(str);
                            this.writer.newLine();
                            ++this.indent;
                            str = DefineXmlWriter.insertIndent(this.indent);
                            str = str + "<def:PDFPageRef PageRefs=\"" + hash.get("Leaf Page Reference") + "\" Type=\"" + hash.get("Leaf Page Type") + "\"/>";
                            this.writer.write(str);
                            this.writer.newLine();
                            --this.indent;
                            str = DefineXmlWriter.insertIndent(this.indent);
                            str = str + "</def:DocumentRef>";
                            this.writer.write(str);
                            this.writer.newLine();
                            continue;
                        }
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<def:DocumentRef leafID=\"" + this.createOID(TagType.DOCUMENTREF, "", "", "", "", checkValues[i].trim()) + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                }
                do {
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<arm:AnalysisResult OID=\"" + this.createOID(TagType.RESULT, "", "", "", "", hash.get("W Display Name") + "." + hash.get("Result Key")) + (hash.get("ParameterOID Dataset") != null && !hash.get("ParameterOID Dataset").equals("") ? "\" ParameterOID=\"" + this.createOID(TagType.ITEMDEF, hash.get("ParameterOID Dataset"), hash.get("ParameterOID Dataset"), "PARAMCD", "", "") : "") + "\" AnalysisReason=\"" + hash.get("Analysis Reason") + "\" AnalysisPurpose=\"" + hash.get("Analysis Purpose") + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<TranslatedText xml:lang=\"" + (hash.get("Result xml:lang") != null && !hash.get("Result xml:lang").equals("") ? hash.get("Result xml:lang") : "en") + "\">" + XmlGenerator.escapeString(hash.get("Result Description")) + "</TranslatedText>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "</Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "<arm:AnalysisDatasets" + (hash.get("Datasets Comment") != null && !hash.get("Datasets Comment").equals("") ? " def:CommentOID=\"" + this.createOID(TagType.COMMENTDEF, "", "", "", "", "Datasets." + hash.get("W Display Name") + "." + hash.get("Result Key")) + "\"" : "") + ">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    this.reader2.setTable(this.config.defineResult2TableName, new WhereClause[]{new WhereClause("Display Name", WhereClause.Operator.EQ, hash.get("W Display Name")), new WhereClause("Result Key", WhereClause.Operator.EQ, hash.get("Result Key"))});
                    while ((hash2 = this.reader2.read()) != null) {
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<arm:AnalysisDataset ItemGroupOID=\"" + this.createOID(TagType.ITEMGROUPDEF, hash2.get("Dataset Name"), hash2.get("Dataset Name"), "", "", "") + "\">";
                        this.writer.write(str);
                        this.writer.newLine();
                        ++this.indent;
                        if (hash2.get("WhereClauseVariable") != null && hash2.get("WhereClauseVariable") != "") {
                            str = DefineXmlWriter.insertIndent(this.indent);
                            str = str + "<def:WhereClauseRef WhereClauseOID=\"" + this.createOID(TagType.WHERECLAUSEREF, "", "", "", "", hash2.get("Display Name") + "." + hash.get("Result Key") + "." + hash2.get("Dataset Name")) + "\"/>";
                            this.writer.write(str);
                            this.writer.newLine();
                        }
                        if (hash2.get("Analysis Variable") != null && hash2.get("Analysis Variable") != "") {
                            checkValues = hash2.get("Analysis Variable").split(this.DELIMITER);
                            for (i = 0; i < checkValues.length; ++i) {
                                str = DefineXmlWriter.insertIndent(this.indent);
                                str = str + "<arm:AnalysisVariable ItemOID=\"" + this.createOID(TagType.ITEMDEF, hash2.get("Dataset Name"), hash2.get("Dataset Name"), checkValues[i].trim(), "", "") + "\"/>";
                                this.writer.write(str);
                                this.writer.newLine();
                            }
                        }
                        --this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "</arm:AnalysisDataset>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    --this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "</arm:AnalysisDatasets>";
                    this.writer.write(str);
                    this.writer.newLine();
                    if (hash.get("Documentation ID") != null && !hash.get("Documentation ID").equals("") || hash.get("Documentation Text") != null && !hash.get("Documentation Text").equals("")) {
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<arm:Documentation>";
                        this.writer.write(str);
                        this.writer.newLine();
                        ++this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<Description>";
                        this.writer.write(str);
                        this.writer.newLine();
                        ++this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<TranslatedText xml:lang=\"" + (hash.get("Documentation xml:lang") != null && !hash.get("Documentation xml:lang").equals("") ? hash.get("Documentation xml:lang") : "en") + "\">" + XmlGenerator.escapeString(hash.get("Documentation Text")) + "</TranslatedText>";
                        this.writer.write(str);
                        this.writer.newLine();
                        --this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "</Description>";
                        this.writer.write(str);
                        this.writer.newLine();
                        if (hash.get("Documentation ID") != null && !hash.get("Documentation ID").equals("")) {
                            checkValues = hash.get("Documentation ID").split(this.DELIMITER);
                            for (i = 0; i < checkValues.length; ++i) {
                                if (hash.get("Documentation Page Type") != null && hash.get("Documentation Page Reference") != null && i < Arrays.asList(hash.get("Documentation Page Type").split(this.DELIMITER)).size() && i < Arrays.asList(hash.get("Documentation Page Reference").split(this.DELIMITER)).size() && !Arrays.asList(hash.get("Documentation Page Type").split(this.DELIMITER)).get(i).trim().equals("")) {
                                    str = DefineXmlWriter.insertIndent(this.indent);
                                    str = str + "<def:DocumentRef leafID=\"" + this.createOID(TagType.DOCUMENTREF, "", "", "", "", checkValues[i].trim()) + "\">";
                                    this.writer.write(str);
                                    this.writer.newLine();
                                    ++this.indent;
                                    str = DefineXmlWriter.insertIndent(this.indent);
                                    str = str + "<def:PDFPageRef PageRefs=\"" + hash.get("Documentation Page Reference") + "\" Type=\"" + hash.get("Documentation Page Type") + "\"/>";
                                    this.writer.write(str);
                                    this.writer.newLine();
                                    --this.indent;
                                    str = DefineXmlWriter.insertIndent(this.indent);
                                    str = str + "</def:DocumentRef>";
                                    this.writer.write(str);
                                    this.writer.newLine();
                                    continue;
                                }
                                str = DefineXmlWriter.insertIndent(this.indent);
                                str = str + "<def:DocumentRef leafID=\"" + this.createOID(TagType.DOCUMENTREF, "", "", "", "", checkValues[i].trim()) + "\"/>";
                                this.writer.write(str);
                                this.writer.newLine();
                            }
                        }
                        --this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "</arm:Documentation>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    if (hash.get("Programming Code Text") != null && !hash.get("Programming Code Text").equals("") || hash.get("Programming Code Document ID") != null && !hash.get("Programming Code Document ID").equals("")) {
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "<arm:ProgrammingCode" + (hash.get("Programming Code Context") != null && !hash.get("Programming Code Context").equals("") ? " Context=\"" + hash.get("Programming Code Context") + "\"" : "") + ">";
                        this.writer.write(str);
                        this.writer.newLine();
                        ++this.indent;
                        if (hash.get("Programming Code Text") != null && !hash.get("Programming Code Text").equals("")) {
                            str = DefineXmlWriter.insertIndent(this.indent);
                            str = str + "<arm:Code>";
                            this.writer.write(str);
                            this.writer.newLine();
                            str = XmlGenerator.escapeString(hash.get("Programming Code Text"));
                            this.writer.write(str);
                            this.writer.newLine();
                            str = DefineXmlWriter.insertIndent(this.indent);
                            str = str + "</arm:Code>";
                            this.writer.write(str);
                            this.writer.newLine();
                        }
                        if (hash.get("Programming Code Document ID") != null && !hash.get("Programming Code Document ID").equals("")) {
                            checkValues = hash.get("Programming Code Document ID").split(this.DELIMITER);
                            for (i = 0; i < checkValues.length; ++i) {
                                if (hash.get("Programming Code Document Page Type") != null && hash.get("Programming Code Document Page Reference") != null && i < Arrays.asList(hash.get("Programming Code Document Page Type").split(this.DELIMITER)).size() && i < Arrays.asList(hash.get("Programming Code Document Page Reference").split(this.DELIMITER)).size() && !Arrays.asList(hash.get("Programming Code Document Page Type").split(this.DELIMITER)).get(i).trim().equals("")) {
                                    str = DefineXmlWriter.insertIndent(this.indent);
                                    str = str + "<def:DocumentRef leafID=\"" + this.createOID(TagType.DOCUMENTREF, "", "", "", "", checkValues[i].trim()) + "\">";
                                    this.writer.write(str);
                                    this.writer.newLine();
                                    ++this.indent;
                                    str = DefineXmlWriter.insertIndent(this.indent);
                                    str = str + "<def:PDFPageRef PageRefs=\"" + hash.get("Programming Code Document Page Reference") + "\" Type=\"" + hash.get("Programming Code Document Page Type") + "\"/>";
                                    this.writer.write(str);
                                    this.writer.newLine();
                                    --this.indent;
                                    str = DefineXmlWriter.insertIndent(this.indent);
                                    str = str + "</def:DocumentRef>";
                                    this.writer.write(str);
                                    this.writer.newLine();
                                    continue;
                                }
                                str = DefineXmlWriter.insertIndent(this.indent);
                                str = str + "<def:DocumentRef leafID=\"" + this.createOID(TagType.DOCUMENTREF, "", "", "", "", checkValues[i].trim()) + "\"/>";
                                this.writer.write(str);
                                this.writer.newLine();
                            }
                        }
                        --this.indent;
                        str = DefineXmlWriter.insertIndent(this.indent);
                        str = str + "</arm:ProgrammingCode>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    --this.indent;
                    str = DefineXmlWriter.insertIndent(this.indent);
                    str = str + "</arm:AnalysisResult>";
                    this.writer.write(str);
                    this.writer.newLine();
                } while ((hash = this.reader.read()) != null && (hash.get("Display Name") == null || hash.get("Display Name").equals("")));
                --this.indent;
                str = DefineXmlWriter.insertIndent(this.indent);
                str = str + "</arm:ResultDisplay>";
                this.writer.write(str);
                this.writer.newLine();
            } while (hash != null);
            --this.indent;
            str = DefineXmlWriter.insertIndent(this.indent);
            str = str + "</arm:AnalysisResultDisplays>";
            this.writer.write(str);
            this.writer.newLine();
            this.reader.close();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeEndTag(String tag) throws IOException {
        --this.indent;
        String str = DefineXmlWriter.insertIndent(this.indent);
        str = str + "</" + tag + ">";
        this.writer.write(str);
        this.writer.newLine();
    }

    public void writeXmlComment(String comment) throws IOException {
        String str = DefineXmlWriter.insertIndent(this.indent);
        str = str + "<!-- " + comment + " -->";
        this.writer.write(str);
        this.writer.newLine();
    }

    public void close() throws IOException {
        this.writer.close();
        this.sw.close();
    }

    private static String insertIndent(int indent) {
        String str = "";
        for (int i = 0; i < indent; ++i) {
            str = str + "  ";
        }
        return str;
    }

    private String createOID(TagType tagType, String domainKey, String datasetName, String variableName, String valueKey, String param) throws InvalidOidSyntaxException, RequiredValueMissingException {
        try {
            String str = null;
            String formattedDatasetName = null;
            if (!datasetName.equals("")) {
                formattedDatasetName = datasetName.replace(" ", "").replace(this.DELIMITER, "-");
            }
            switch (tagType) {
                case ITEMGROUPDEF: {
                    if (!domainKey.equals("")) {
                        str = "IG." + domainKey;
                        break;
                    }
                    throw new InvalidOidSyntaxException("ItemGroupDef");
                }
                case ITEMDEF: 
                case ITEMREF: {
                    if (!domainKey.equals("") && !variableName.equals("")) {
                        if (!valueKey.equals("")) {
                            if (this.datasetType.equals((Object)Config.DatasetType.ADaM)) {
                                str = "IT." + domainKey + "." + variableName + "." + valueKey;
                                break;
                            }
                            str = "IT." + formattedDatasetName + "." + variableName + "." + valueKey;
                            break;
                        }
                        if ((this.datasetType.equals((Object)Config.DatasetType.SDTM) || this.datasetType.equals((Object)Config.DatasetType.SEND)) && (variableName.equals("STUDYID") || variableName.equals("USUBJID"))) {
                            str = "IT." + variableName;
                            break;
                        }
                        if (this.datasetType.equals((Object)Config.DatasetType.ADaM)) {
                            str = "IT." + domainKey + "." + variableName;
                            break;
                        }
                        if (this.suppUtil.isAutoSuppActive() && variableName.equals("RDOMAIN")) {
                            if (domainKey.startsWith("SUPP") && !domainKey.equals("SUPPQUAL")) {
                                str = "IT.SUPP." + variableName;
                                break;
                            }
                            str = "IT." + domainKey + "." + variableName;
                            break;
                        }
                        str = "IT." + formattedDatasetName + "." + variableName;
                        break;
                    }
                    throw new InvalidOidSyntaxException("ItemDef/ItemRef");
                }
                case VALUELISTDEF: 
                case VALUELISTREF: {
                    if (!domainKey.equals("") && !variableName.equals("")) {
                        if (this.datasetType.equals((Object)Config.DatasetType.ADaM)) {
                            str = "VL." + domainKey + "." + variableName;
                            break;
                        }
                        str = "VL." + domainKey + "." + formattedDatasetName + "." + variableName;
                        break;
                    }
                    throw new InvalidOidSyntaxException("ValueListDef/ValueListRef");
                }
                case WHERECLAUSEDEF: 
                case WHERECLAUSEREF: {
                    if (!domainKey.equals("") && !variableName.equals("")) {
                        if (this.datasetType.equals((Object)Config.DatasetType.ADaM)) {
                            str = "WC." + domainKey + "." + variableName + "." + valueKey;
                            break;
                        }
                        str = "WC." + domainKey + "." + formattedDatasetName + "." + variableName + "." + valueKey;
                        break;
                    }
                    if (!param.equals("")) {
                        str = "WC." + param;
                        break;
                    }
                    throw new InvalidOidSyntaxException("WhereClauseDef/WhereClauseRef");
                }
                case CODELIST: 
                case CODELISTREF: {
                    if (!param.equals("")) {
                        str = "CL." + param;
                        break;
                    }
                    throw new InvalidOidSyntaxException("CodeListDef/CodeListRef");
                }
                case METHODDEF: {
                    if (!domainKey.equals("") && !variableName.equals("")) {
                        if (!valueKey.equals("")) {
                            if (!variableName.equals("STUDYID") && !variableName.equals("USUBJID")) {
                                if (this.datasetType.equals((Object)Config.DatasetType.ADaM)) {
                                    str = "MT." + domainKey + "." + variableName + "." + valueKey;
                                    break;
                                }
                                str = "MT." + domainKey + "." + formattedDatasetName + "." + variableName + "." + valueKey;
                                break;
                            }
                            str = "MT." + variableName + "." + valueKey;
                            break;
                        }
                        if (!(variableName.equals("STUDYID") || variableName.equals("USUBJID") || this.suppUtil.isAutoSuppActive() && variableName.equals("RDOMAIN"))) {
                            if (this.datasetType.equals((Object)Config.DatasetType.ADaM)) {
                                str = "MT." + domainKey + "." + variableName;
                                break;
                            }
                            str = "MT." + domainKey + "." + formattedDatasetName + "." + variableName;
                            break;
                        }
                        if (this.suppUtil.isAutoSuppActive() && variableName.equals("RDOMAIN")) {
                            if (domainKey.startsWith("SUPP") && !domainKey.equals("SUPPQUAL")) {
                                str = "MT.SUPP." + variableName;
                                break;
                            }
                            str = "MT." + domainKey + "." + variableName;
                            break;
                        }
                        str = "MT." + variableName;
                        break;
                    }
                    if (!param.equals("")) {
                        str = "MT." + param;
                        break;
                    }
                    throw new InvalidOidSyntaxException("MethodDef/MethodRef");
                }
                case COMMENTDEF: {
                    if (!domainKey.equals("")) {
                        if (!variableName.equals("")) {
                            if (!valueKey.equals("")) {
                                if (!param.equals("")) {
                                    if (this.datasetType.equals((Object)Config.DatasetType.ADaM)) {
                                        str = "COM." + domainKey + "." + variableName + "." + valueKey + "." + param;
                                        break;
                                    }
                                    str = "COM." + domainKey + "." + formattedDatasetName + "." + variableName + "." + valueKey + "." + param;
                                    break;
                                }
                                if (this.datasetType.equals((Object)Config.DatasetType.ADaM)) {
                                    str = "COM." + domainKey + "." + variableName + "." + valueKey;
                                    break;
                                }
                                str = "COM." + domainKey + "." + formattedDatasetName + "." + variableName + "." + valueKey;
                                break;
                            }
                            if (variableName.equals("STUDYID") || variableName.equals("USUBJID")) {
                                if (this.datasetType.equals((Object)Config.DatasetType.ADaM)) {
                                    str = "COM." + domainKey + "." + variableName;
                                    break;
                                }
                                str = "COM." + variableName;
                                break;
                            }
                            if (this.datasetType.equals((Object)Config.DatasetType.ADaM)) {
                                str = "COM." + domainKey + "." + variableName;
                                break;
                            }
                            str = "COM." + domainKey + "." + formattedDatasetName + "." + variableName;
                            break;
                        }
                        str = "COM." + domainKey;
                        break;
                    }
                    if (!param.equals("")) {
                        str = "COM." + param;
                        break;
                    }
                    throw new InvalidOidSyntaxException("CommentDef/CommentRef");
                }
                case LEAF: 
                case DOCUMENTREF: {
                    if (!param.equals("")) {
                        str = "LF." + param;
                        break;
                    }
                    throw new InvalidOidSyntaxException("Leaf/DocumentRef");
                }
                case RESULTDISPLAY: {
                    if (!param.equals("")) {
                        str = "RD." + param;
                        break;
                    }
                    throw new InvalidOidSyntaxException("AnalysisResultDisplay");
                }
                case RESULT: {
                    if (!param.equals("")) {
                        str = "AR." + param;
                        break;
                    }
                    throw new InvalidOidSyntaxException("AnalysisResult");
                }
                default: {
                    throw new InvalidOidSyntaxException("Unknown");
                }
            }
            return str;
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    private static String twoDigits(int n) {
        if (n >= 0 && n <= 9) {
            return new String("0" + new Integer(n).toString());
        }
        return new Integer(n).toString();
    }

    private static String formatCodeListID(String strId) {
        return strId;
    }

    private static String createSASFormatName(String strId) {
        if (strId.length() > 8) {
            return strId.substring(0, 7);
        }
        return strId;
    }

    protected class ErrorHint {
        protected TagType tagType = TagType.DEFAULT;
        protected String domainKey = "";
        protected String variableName = "";
        protected String valueKey = "";
        protected String param = "";

        protected ErrorHint() {
        }

        protected void setErrorHint(TagType tagType, String domainKey, String variableName, String valueKey, String param) {
            this.tagType = tagType;
            this.domainKey = domainKey == null ? "null" : domainKey;
            this.variableName = variableName == null ? "null" : variableName;
            this.valueKey = valueKey == null ? "null" : valueKey;
            this.param = param == null ? "null" : param;
        }
    }

    public static enum TagType {
        DEFAULT,
        XMLHEADER,
        STUDY,
        ITEMGROUPDEF,
        ITEMDEF,
        ITEMREF,
        VALUELISTDEF,
        VALUELISTREF,
        WHERECLAUSEDEF,
        WHERECLAUSEREF,
        CODELIST,
        CODELISTREF,
        METHODDEF,
        COMMENTDEF,
        LEAF,
        DOCUMENTREF,
        RESULTDISPLAY,
        RESULT;

    }
}

