/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.gui;

import com.fujitsu.tsc.desktop.gui.GuiConstants;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.TransferHandler;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.JTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilePathTransferHandler
extends TransferHandler {
    private static Logger logger = LogManager.getLogger();
    private JTextComponent textComponent;
    private JList<String> listComponent;
    private FileNameExtensionFilter filter;
    private JFileChooser chooser;
    private int fileSelectionMode;
    private boolean multiSelectionEnabled;
    private Transferable t;
    private List<File> fileList;

    public FilePathTransferHandler(JTextComponent component, JFileChooser chooser) {
        this.textComponent = component;
        this.chooser = chooser;
        this.fileSelectionMode = chooser.getFileSelectionMode();
    }

    public FilePathTransferHandler(JTextComponent component, JFileChooser chooser, FileNameExtensionFilter filter) {
        this.textComponent = component;
        this.chooser = chooser;
        this.fileSelectionMode = chooser.getFileSelectionMode();
        this.filter = filter;
    }

    public FilePathTransferHandler(JList component, JFileChooser chooser) {
        this.listComponent = component;
        this.chooser = chooser;
        this.multiSelectionEnabled = chooser.isMultiSelectionEnabled();
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        if (info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            info.setDropAction(1);
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        try {
            if (!info.isDrop()) {
                return false;
            }
            this.t = info.getTransferable();
            this.fileList = (List)this.t.getTransferData(DataFlavor.javaFileListFlavor);
            if (this.textComponent != null) {
                if (this.fileSelectionMode == 1) {
                    if (this.fileList.get(0).isDirectory()) {
                        this.textComponent.setText(this.fileList.get(0).getAbsolutePath() + System.getProperty("file.separator") + GuiConstants.DEFINE_FILE_NAME);
                        this.chooser.setCurrentDirectory(this.fileList.get(0).getParentFile());
                        return true;
                    }
                    return false;
                }
                if (Arrays.asList(this.filter.getExtensions()).contains(this.fileList.get(0).getName().substring(this.fileList.get(0).getName().lastIndexOf(46) + 1))) {
                    this.textComponent.setText(this.fileList.get(0).getAbsolutePath());
                    this.chooser.setCurrentDirectory(this.fileList.get(0).getParentFile());
                    return true;
                }
                return false;
            }
            if (this.listComponent != null) {
                Vector<String> paths = new Vector<String>();
                for (File f : this.fileList) {
                    paths.add(f.getAbsolutePath());
                }
                this.listComponent.setListData(paths);
                return true;
            }
            return false;
        }
        catch (UnsupportedFlavorException ex) {
            logger.error(ex.getMessage());
            return false;
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
            return false;
        }
    }
}

