/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.gui;

import com.fujitsu.tsc.desktop.gui.AboutDialog;
import com.fujitsu.tsc.desktop.gui.CrfSpecCreatePanel;
import com.fujitsu.tsc.desktop.gui.CrfSpecCreateResultPanel;
import com.fujitsu.tsc.desktop.gui.DefineExportPanel;
import com.fujitsu.tsc.desktop.gui.DefineExportResultPanel;
import com.fujitsu.tsc.desktop.gui.DefineImportPanel;
import com.fujitsu.tsc.desktop.gui.DefineImportResultPanel;
import com.fujitsu.tsc.desktop.gui.DesktopMenuBar;
import com.fujitsu.tsc.desktop.gui.EdtSpecCreatePanel;
import com.fujitsu.tsc.desktop.gui.EdtSpecCreateResultPanel;
import com.fujitsu.tsc.desktop.gui.GuiConstants;
import com.fujitsu.tsc.desktop.gui.OdmExportPanel;
import com.fujitsu.tsc.desktop.gui.OdmExportResultPanel;
import com.fujitsu.tsc.desktop.gui.OdmImportPanel;
import com.fujitsu.tsc.desktop.gui.OdmImportResultPanel;
import com.fujitsu.tsc.desktop.gui.XmlToHtmlPanel;
import com.fujitsu.tsc.desktop.gui.XmlToHtmlResultPanel;
import com.fujitsu.tsc.desktop.gui.XmlValidatePanel;
import com.fujitsu.tsc.desktop.gui.XmlValidateResultPanel;
import com.fujitsu.tsc.desktop.util.Config;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiMain
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 5574971135909932382L;
    private static Logger logger;
    private float ratio;
    private Properties prop;
    private Config config;
    private Font defaultFont;
    private JPanel bodyPanel;
    private JPanel commandPanel;
    private JPanel selectorPanel;
    private HashMap<String, JPanel[]> screen = new HashMap();
    protected DefineExportPanel defineExportPanel;
    protected DefineExportResultPanel defineExportResultPanel;
    protected DefineImportPanel defineImportPanel;
    protected DefineImportResultPanel defineImportResultPanel;
    protected XmlToHtmlPanel xmlToHtmlPanel;
    protected XmlToHtmlResultPanel xmlToHtmlResultPanel;
    protected OdmExportPanel odmExportPanel;
    protected OdmExportResultPanel odmExportResultPanel;
    protected OdmImportPanel odmImportPanel;
    protected OdmImportResultPanel odmImportResultPanel;
    protected CrfSpecCreatePanel crfSpecCreatePanel;
    protected CrfSpecCreateResultPanel crfSpecCreateResultPanel;
    protected EdtSpecCreatePanel edtSpecCreatePanel;
    protected EdtSpecCreateResultPanel edtSpecCreateResultPanel;
    protected XmlValidatePanel xmlValidatePanel;
    protected XmlValidateResultPanel xmlValidateResultPanel;
    protected AboutDialog aboutDialog;

    public GuiMain() {
        this.initComponents();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode mode = env.getDefaultScreenDevice().getDisplayMode();
        this.setResizable(false);
        this.setPreferredSize(new Dimension(Float.valueOf(GuiConstants.FRAME_WIDTH).intValue(), Float.valueOf(GuiConstants.FRAME_HEIGHT).intValue()));
        this.defaultFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE, Float.valueOf((float)GuiConstants.FONT_SIZE * this.ratio).intValue());
        this.setJMenuBar(new DesktopMenuBar(this));
        ImageIcon icon = new ImageIcon(GuiConstants.INFINITY_IMAGE_PATH);
        this.setIconImage(icon.getImage());
        this.setTitle(Config.SOFTWARE_NAME + " " + Config.SOFTWARE_VERSION);
        try {
            logger.info("loading property...");
            this.prop = new Properties();
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream("./properties/main.properties"), Config.DEFAULT_ENCODING);
            this.prop.load(reader);
            reader.close();
        }
        catch (IllegalArgumentException ex) {
            logger.error(ex.getMessage());
        }
        catch (FileNotFoundException ex) {
            logger.error(ex.getMessage());
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
        }
        this.config = new Config(this.prop);
        this.defineExportPanel = new DefineExportPanel(this, this.config);
        this.defineExportResultPanel = new DefineExportResultPanel(this);
        this.defineImportPanel = new DefineImportPanel(this, this.config);
        this.defineImportResultPanel = new DefineImportResultPanel(this);
        this.xmlToHtmlPanel = new XmlToHtmlPanel(this, this.config);
        this.xmlToHtmlResultPanel = new XmlToHtmlResultPanel(this);
        this.odmExportPanel = new OdmExportPanel(this, this.config);
        this.odmExportResultPanel = new OdmExportResultPanel(this);
        this.odmImportPanel = new OdmImportPanel(this, this.config);
        this.odmImportResultPanel = new OdmImportResultPanel(this);
        this.crfSpecCreatePanel = new CrfSpecCreatePanel(this, this.config);
        this.crfSpecCreateResultPanel = new CrfSpecCreateResultPanel(this);
        this.edtSpecCreatePanel = new EdtSpecCreatePanel(this, this.config);
        this.edtSpecCreateResultPanel = new EdtSpecCreateResultPanel(this);
        this.xmlValidatePanel = new XmlValidatePanel(this, this.config);
        this.xmlValidateResultPanel = new XmlValidateResultPanel(this);
        this.aboutDialog = new AboutDialog(this);
        this.showPanel(this.defineExportPanel);
    }

    public void showPanel(JPanel panel) {
        this.getContentPane().removeAll();
        this.getContentPane().add(panel);
        this.getContentPane().repaint();
        this.pack();
    }

    public static void main(String[] args) {
        logger = LogManager.getLogger();
        logger.info(Config.SOFTWARE_NAME + " " + Config.SOFTWARE_VERSION);
        logger.info(GuiConstants.COPYRIGHT);
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            logger.error(ex.getMessage());
        }
        catch (InstantiationException ex) {
            logger.error(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            logger.error(ex.getMessage());
        }
        catch (UnsupportedLookAndFeelException ex) {
            logger.error(ex.getMessage());
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GuiMain().setVisible(true);
            }
        });
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Object[] options = new String[]{"Yes", "No"};
        switch (JOptionPane.showOptionDialog(this, "Are you sure to close the window?", "Select an option", 0, 3, null, options, options[0])) {
            case 0: {
                logger.info("saving property...");
                try {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream("./properties/main.properties"), Config.DEFAULT_ENCODING);
                    this.prop.setProperty("e2dDefineVersion", (String)this.defineExportPanel.defineVersionCB.getSelectedItem());
                    this.prop.setProperty("e2dDatasetType", (String)this.defineExportPanel.datasetTypeCB.getSelectedItem());
                    this.prop.setProperty("e2dIncludeResultMetadata", Boolean.toString(this.defineExportPanel.includeResultMetadataCB.isSelected()));
                    this.prop.setProperty("e2dXmlEncoding", (String)this.defineExportPanel.xmlEncodingCB.getSelectedItem());
                    this.prop.setProperty("e2dStylesheetLocation", this.defineExportPanel.stylesheetLocationTF.getText());
                    this.prop.setProperty("e2dDataSourceLocation", this.defineExportPanel.dataSourceLocationTF.getText());
                    this.prop.setProperty("e2dOutputLocation", this.defineExportPanel.outputLocationTF.getText());
                    this.prop.setProperty("defineStudyTableName", this.config.defineStudyTableName);
                    this.prop.setProperty("defineDocumentTableName", this.config.defineDocumentTableName);
                    this.prop.setProperty("defineDatasetTableName", this.config.defineDatasetTableName);
                    this.prop.setProperty("defineVariableTableName", this.config.defineVariableTableName);
                    this.prop.setProperty("defineValueTableName", this.config.defineValueTableName);
                    this.prop.setProperty("defineResult1TableName", this.config.defineResult1TableName);
                    this.prop.setProperty("defineResult2TableName", this.config.defineResult2TableName);
                    this.prop.setProperty("defineDictionaryTableName", this.config.defineDictionaryTableName);
                    this.prop.setProperty("defineCodelistTableName", this.config.defineCodelistTableName);
                    this.prop.setProperty("valueDelimiter", this.config.valueDelimiter);
                    this.prop.setProperty("oidMode", this.config.oidMode.name());
                    this.prop.setProperty("d2eDefineVersion", (String)this.defineImportPanel.defineVersionCB.getSelectedItem());
                    this.prop.setProperty("d2eDatasetType", (String)this.defineImportPanel.datasetTypeCB.getSelectedItem());
                    this.prop.setProperty("d2eSeparateSheet", Boolean.toString(this.defineImportPanel.separateSheetCB.isSelected()));
                    this.prop.setProperty("d2eMergeNSVtoParent", Boolean.toString(this.defineImportPanel.mergeNSVtoParentCB.isSelected()));
                    this.prop.setProperty("d2eDataSourceLocation", this.defineImportPanel.dataSourceLocationTF.getText());
                    this.prop.setProperty("d2eOutputLocation", this.defineImportPanel.outputLocationTF.getText());
                    this.prop.setProperty("x2hXmlLocation", this.xmlToHtmlPanel.xmlLocationTF.getText());
                    this.prop.setProperty("x2hXslLocation", this.xmlToHtmlPanel.xslLocationTF.getText());
                    this.prop.setProperty("x2hOutputLocation", this.xmlToHtmlPanel.outputLocationTF.getText());
                    this.prop.setProperty("o2eOdmVersion", (String)this.odmExportPanel.odmVersionCB.getSelectedItem());
                    this.prop.setProperty("e2oXmlEncoding", (String)this.odmExportPanel.xmlEncodingCB.getSelectedItem());
                    this.prop.setProperty("e2oStylesheetLocation", this.odmExportPanel.stylesheetLocationTF.getText());
                    this.prop.setProperty("e2oDataSourceLocation", this.odmExportPanel.dataSourceLocationTF.getText());
                    this.prop.setProperty("e2oOutputLocation", this.odmExportPanel.outputLocationTF.getText());
                    this.prop.setProperty("odmStudyTableName", this.config.odmStudyTableName);
                    this.prop.setProperty("odmUnitTableName", this.config.odmUnitTableName);
                    this.prop.setProperty("odmEventTableName", this.config.odmEventTableName);
                    this.prop.setProperty("odmEventFormTableName", this.config.odmEventFormTableName);
                    this.prop.setProperty("odmFormTableName", this.config.odmFormTableName);
                    this.prop.setProperty("odmFieldTableName", this.config.odmFieldTableName);
                    this.prop.setProperty("odmCodelistTableName", this.config.odmCodelistTableName);
                    this.prop.setProperty("odmMethodTableName", this.config.odmMethodTableName);
                    this.prop.setProperty("odmConditionTableName", this.config.odmConditionTableName);
                    this.prop.setProperty("o2eOdmVersion", (String)this.odmImportPanel.odmVersionCB.getSelectedItem());
                    this.prop.setProperty("o2eOdmLocation", this.odmImportPanel.dataSourceLocationTF.getText());
                    this.prop.setProperty("o2eOutputLocation", this.odmImportPanel.outputLocationTF.getText());
                    this.prop.setProperty("crfArchitectLocation", this.crfSpecCreatePanel.architectLocationTF.getText());
                    this.prop.setProperty("crfSourceFiles", this.getSingleString(this.crfSpecCreatePanel.sourceFilesLI.getModel()));
                    this.prop.setProperty("crfHeaderCnt", this.crfSpecCreatePanel.headerCntTF.getText());
                    this.prop.setProperty("crfHeaderRow", this.crfSpecCreatePanel.headerRowTF.getText());
                    this.prop.setProperty("crfEncoding", (String)this.crfSpecCreatePanel.encodingCB.getSelectedItem());
                    this.prop.setProperty("crfDelimiter", this.crfSpecCreatePanel.delimiterTF.getText());
                    this.prop.setProperty("crfTextQualifier", (String)this.crfSpecCreatePanel.textQualifierCB.getSelectedItem());
                    this.prop.setProperty("crfOutputLocation", this.crfSpecCreatePanel.outputLocationTF.getText());
                    this.prop.setProperty("edtType", (String)this.edtSpecCreatePanel.edtTypeCB.getSelectedItem());
                    this.prop.setProperty("edtHeaderCnt", this.edtSpecCreatePanel.headerCntTF.getText());
                    this.prop.setProperty("edtHeaderRow", this.edtSpecCreatePanel.headerRowTF.getText());
                    this.prop.setProperty("edtEncoding", (String)this.edtSpecCreatePanel.encodingCB.getSelectedItem());
                    this.prop.setProperty("edtDelimitedOrFixed", (String)this.edtSpecCreatePanel.delimitedOrFixedCB.getSelectedItem());
                    this.prop.setProperty("edtDelimiter", this.edtSpecCreatePanel.delimiterTF.getText());
                    this.prop.setProperty("edtTextQualifier", (String)this.edtSpecCreatePanel.textQualifierCB.getSelectedItem());
                    this.prop.setProperty("edtDataSourceLocation", this.edtSpecCreatePanel.dataSourceLocationTF.getText());
                    this.prop.setProperty("edtOutputLocation", this.edtSpecCreatePanel.outputLocationTF.getText());
                    this.prop.setProperty("validateXmlLocation", this.xmlValidatePanel.xmlLocationTF.getText());
                    this.prop.setProperty("validateSchemaLocation", this.xmlValidatePanel.schemaLocationTF.getText());
                    this.prop.store(writer, "This file is automatically updated when the GUI window is closed.");
                    writer.close();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage());
                }
                logger.info("Terminated.");
                System.exit(0);
            }
            case 1: {
                break;
            }
        }
    }

    private String getSingleString(ListModel<String> list) {
        String singleString = "";
        for (int i = 0; i < list.getSize(); ++i) {
            singleString = i == 0 ? singleString + list.getElementAt(i) : singleString + "|" + list.getElementAt(i);
        }
        return singleString;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

