/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.gui;

import com.fujitsu.tsc.desktop.gui.GuiConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiLineTableCellRenderer
extends JTextArea
implements TableCellRenderer {
    private static Logger logger = LogManager.getLogger();
    private Font defaultFont;

    public MultiLineTableCellRenderer() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(GuiConstants.FONT_COLOR_ON_WHITE);
            this.setBackground(table.getBackground());
        }
        if (value != null) {
            this.setText(value.toString());
        } else {
            this.setText("");
        }
        this.adjustRowHeight(table, row, column);
        return this;
    }

    private void adjustRowHeight(JTable table, int row, int column) {
        this.setSize(new Dimension(table.getTableHeader().getColumnModel().getColumn(column).getWidth(), this.getRowHeight()));
        table.setRowHeight(row, this.getPreferredSize().height);
    }
}

