/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.gui;

import com.fujitsu.tsc.desktop.util.ErrorInfo;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.xml.sax.SAXParseException;

public class XmlValidationAppender {
    private JTable table;
    private int nextLineNum;

    public XmlValidationAppender(JTable table) {
        this.table = table;
        this.nextLineNum = 0;
    }

    public void writeNext(SAXParseException ex) {
        String br = System.lineSeparator();
        TableModel model = this.table.getModel();
        if (model.getRowCount() <= this.nextLineNum) {
            ((DefaultTableModel)model).addRow(new String[]{null, null});
        }
        model.setValueAt("Line: " + ex.getLineNumber() + br + "Column: " + ex.getColumnNumber(), this.nextLineNum, 0);
        model.setValueAt(ex.getMessage(), this.nextLineNum, 1);
        ++this.nextLineNum;
    }

    public void writeNext(ErrorInfo ex) {
        String br = System.getProperty("line.separator");
        TableModel model = this.table.getModel();
        if (model.getRowCount() <= this.nextLineNum) {
            ((DefaultTableModel)model).addRow(new String[]{null, null});
        }
        if (ex.getLine() != 0) {
            model.setValueAt("Line: " + ex.getLine() + br + "Column: " + ex.getColumn(), this.nextLineNum, 0);
        }
        model.setValueAt(ex.getMessage(), this.nextLineNum, 1);
        ++this.nextLineNum;
    }

    public void writeSuccessMessage() {
        TableModel model = this.table.getModel();
        model.setValueAt("No errors have been found. The define.xml has been validated against the specified schema successfully.", this.nextLineNum++, 1);
    }

    public void writeErrorMessage(String err) {
        TableModel model = this.table.getModel();
        if (model.getRowCount() <= this.nextLineNum) {
            ((DefaultTableModel)model).addRow(new String[]{null, null});
        }
        if (err == null) {
            model.setValueAt("Failed to import define.xml. Exiting the program... ", this.nextLineNum++, 1);
        } else {
            model.setValueAt(err, this.nextLineNum++, 1);
        }
    }

    public void clear() {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
        model.addRow(new String[]{null, null});
    }

    public void writeMessage(int i) {
        TableModel model = this.table.getModel();
        if (model.getRowCount() <= this.nextLineNum) {
            ((DefaultTableModel)model).addRow(new String[]{null, null});
        }
        if (i == 0) {
            model.setValueAt("The above fatal errors have been found in define.xml.", this.nextLineNum++, 1);
        } else if (i == 1) {
            model.setValueAt("No fatal errors have been found in define.xml. Importing...", this.nextLineNum++, 1);
        } else if (i == 2) {
            model.setValueAt("An Excel file has been created. But the above warning(s) exist.", this.nextLineNum++, 1);
        } else if (i == 3) {
            model.setValueAt("An Excel file has been created. No warnings have been found.", this.nextLineNum++, 1);
        }
    }

    public void writeMessage(String message) {
        TableModel model = this.table.getModel();
        if (model.getRowCount() <= this.nextLineNum) {
            ((DefaultTableModel)model).addRow(new String[]{null, null});
        }
        model.setValueAt(message, this.nextLineNum++, 1);
    }

    public void writeMessage(Exception e) {
        TableModel model = this.table.getModel();
        if (model.getRowCount() <= this.nextLineNum) {
            ((DefaultTableModel)model).addRow(new String[]{null, null});
        }
        model.setValueAt(e.getMessage(), this.nextLineNum++, 1);
    }
}

