/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelWriter2 {
    private XSSFWorkbook wb = new XSSFWorkbook();
    private XSSFCellStyle cellStyle = this.createCellStyle(this.wb);
    private XSSFCellStyle cellStyleGray = this.createCellStyleGray(this.wb);
    private XSSFCellStyle cellStyleRed = this.createCellStyleRed(this.wb);
    private XSSFCellStyle cellStyleYellow = this.createCellStyleYellow(this.wb);

    public <T> void addData(String sheetName, T obj, Class<T> clz) throws IllegalArgumentException, IllegalAccessException {
        XSSFSheet sheet = this.wb.createSheet(sheetName);
        Row row = sheet.createRow(0);
        this.setCellValue(row, 0, this.cellStyleRed, "Property Name");
        this.setCellValue(row, 1, this.cellStyleRed, "Property Value");
        List fields = FieldUtils.getFieldsListWithAnnotation(clz, ExcelColumn.class);
        Collections.sort(fields, (o1, o2) -> Integer.compare(o1.getAnnotation(ExcelColumn.class).ordinal(), o2.getAnnotation(ExcelColumn.class).ordinal()));
        int rowCount = 1;
        for (Field field : fields) {
            String propName = field.getAnnotation(ExcelColumn.class).name();
            String propValue = field.get(obj) == null ? "" : field.get(obj).toString();
            row = sheet.createRow(rowCount);
            this.setCellValue(row, 0, this.cellStyleGray, propName);
            this.setCellValue(row, 1, this.cellStyleYellow, propValue);
            ++rowCount;
        }
        this.autoSizeColumn((Sheet)sheet, 20000);
    }

    public <T> void addData(String sheetName, List<T> objs, Class<T> clz) throws IllegalArgumentException, IllegalAccessException {
        int i;
        XSSFSheet sheet = this.wb.createSheet(sheetName);
        List fields = FieldUtils.getFieldsListWithAnnotation(clz, ExcelColumn.class);
        Collections.sort(fields, (o1, o2) -> Integer.compare(o1.getAnnotation(ExcelColumn.class).ordinal(), o2.getAnnotation(ExcelColumn.class).ordinal()));
        Row row = sheet.createRow(0);
        for (i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.get(i);
            String propName = field.getAnnotation(ExcelColumn.class).name();
            this.setCellValue(row, i, this.cellStyleRed, propName);
        }
        for (i = 0; i < objs.size(); ++i) {
            T obj = objs.get(i);
            row = sheet.createRow(i + 1);
            for (int j = 0; j < fields.size(); ++j) {
                Field field = (Field)fields.get(j);
                String propValue = null;
                String name = field.getName();
                propValue = "length".equals(field.getName()) || "significant_digits".equals(field.getName()) ? ((Integer)field.get(obj) < 1 ? "" : field.get(obj).toString()) : (field.get(obj) == null ? "" : field.get(obj).toString());
                this.setCellValue(row, j, this.cellStyleYellow, propValue);
            }
        }
        this.autoSizeColumn((Sheet)sheet, 20000);
    }

    private void setCellValue(Row row, int idx, XSSFCellStyle style, String value) {
        Cell cell = row.createCell(idx);
        if (style != null) {
            cell.setCellStyle((CellStyle)style);
        }
        cell.setCellValue(StringUtils.defaultString((String)value));
    }

    public void writeout(File outFile) throws FileNotFoundException, IOException {
        try (FileOutputStream out = new FileOutputStream(outFile);){
            this.wb.write((OutputStream)out);
        }
    }

    public XSSFCellStyle createCellStyle(XSSFWorkbook book) {
        XSSFCellStyle style = book.createCellStyle();
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        XSSFFont font = book.createFont();
        font.setFontName("Calibri");
        style.setFont((Font)font);
        return style;
    }

    public XSSFCellStyle createCellStyleRed(XSSFWorkbook book) {
        XSSFCellStyle style = book.createCellStyle();
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(new XSSFColor(new Color(192, 80, 77), (IndexedColorMap)new DefaultIndexedColorMap()));
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        XSSFFont font = book.createFont();
        font.setFontName("Calibri");
        font.setColor(IndexedColors.WHITE.index);
        style.setFont((Font)font);
        return style;
    }

    public XSSFCellStyle createCellStyleYellow(XSSFWorkbook book) {
        XSSFCellStyle style = book.createCellStyle();
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(new XSSFColor(new Color(255, 255, 153), (IndexedColorMap)new DefaultIndexedColorMap()));
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        XSSFFont font = book.createFont();
        font.setFontName("Calibri");
        style.setFont((Font)font);
        return style;
    }

    public XSSFCellStyle createCellStyleGray(XSSFWorkbook book) {
        XSSFCellStyle style = book.createCellStyle();
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(new XSSFColor(new Color(217, 217, 217), (IndexedColorMap)new DefaultIndexedColorMap()));
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        XSSFFont font = book.createFont();
        font.setFontName("Calibri");
        style.setFont((Font)font);
        return style;
    }

    public void autoSizeColumn(Sheet sheet, int maxWidth) {
        int maxCellNum = 1;
        for (Row row : sheet) {
            maxCellNum = Math.max(maxCellNum, row.getLastCellNum());
        }
        for (int i = 0; i < maxCellNum; ++i) {
            sheet.autoSizeColumn(i);
            int width = sheet.getColumnWidth(i) + 2000;
            width = Math.min(maxWidth, width);
            sheet.setColumnWidth(i, width);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ExcelColumn {
        public String name();

        public int ordinal();
    }
}

