/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer.models;

import com.fujitsu.tsc.desktop.importer.models.DefineARMDatasetModel;
import com.fujitsu.tsc.desktop.importer.models.DefineARMDisplayModel;
import com.fujitsu.tsc.desktop.importer.models.DefineARMResultModel;
import com.fujitsu.tsc.desktop.importer.models.DefineCodelistModel;
import com.fujitsu.tsc.desktop.importer.models.DefineCommentModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDatasetModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDictionaryModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDocumentModel;
import com.fujitsu.tsc.desktop.importer.models.DefineMethodModel;
import com.fujitsu.tsc.desktop.importer.models.DefineStandardModel;
import com.fujitsu.tsc.desktop.importer.models.DefineStudyModel;
import com.fujitsu.tsc.desktop.importer.models.DefineValueModel;
import com.fujitsu.tsc.desktop.importer.models.DefineVariableModel;
import com.fujitsu.tsc.desktop.importer.models.DefineWCModel;
import com.fujitsu.tsc.desktop.util.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefineModel {
    private DefineStudyModel define_study = new DefineStudyModel();
    private Map<DefineStandardModel.DefineStandardPk, DefineStandardModel> map_define_standard = new HashMap<DefineStandardModel.DefineStandardPk, DefineStandardModel>();
    private Map<DefineDocumentModel.DefineDocumentPk, DefineDocumentModel> map_define_document = new HashMap<DefineDocumentModel.DefineDocumentPk, DefineDocumentModel>();
    private Map<DefineDatasetModel.DefineDatasetPk, DefineDatasetModel> map_define_dataset = new HashMap<DefineDatasetModel.DefineDatasetPk, DefineDatasetModel>();
    private Map<DefineVariableModel.DefineVariablePk, DefineVariableModel> map_define_variable = new HashMap<DefineVariableModel.DefineVariablePk, DefineVariableModel>();
    private Map<DefineValueModel.DefineValuePk, DefineValueModel> map_define_value = new HashMap<DefineValueModel.DefineValuePk, DefineValueModel>();
    private Map<DefineWCModel.DefineWCPk, DefineWCModel> map_define_wc = new HashMap<DefineWCModel.DefineWCPk, DefineWCModel>();
    private Map<DefineDictionaryModel.DefineDictionaryPk, DefineDictionaryModel> map_define_dictionary = new HashMap<DefineDictionaryModel.DefineDictionaryPk, DefineDictionaryModel>();
    private Map<DefineCodelistModel.DefineCodelistPk, DefineCodelistModel> map_define_codelist = new HashMap<DefineCodelistModel.DefineCodelistPk, DefineCodelistModel>();
    private Map<DefineARMDisplayModel.DefineARMDisplayPk, DefineARMDisplayModel> map_define_arm_display = new HashMap<DefineARMDisplayModel.DefineARMDisplayPk, DefineARMDisplayModel>();
    private Map<DefineARMResultModel.DefineARMResultPk, DefineARMResultModel> map_define_arm_result = new HashMap<DefineARMResultModel.DefineARMResultPk, DefineARMResultModel>();
    private Map<DefineARMDatasetModel.DefineARMDatasetPk, DefineARMDatasetModel> map_define_arm_dataset = new HashMap<DefineARMDatasetModel.DefineARMDatasetPk, DefineARMDatasetModel>();
    private Map<DefineMethodModel.DefineMethodPk, DefineMethodModel> map_define_method = new HashMap<DefineMethodModel.DefineMethodPk, DefineMethodModel>();
    private Map<DefineCommentModel.DefineCommentPk, DefineCommentModel> map_define_comment = new HashMap<DefineCommentModel.DefineCommentPk, DefineCommentModel>();

    public void put(DefineStudyModel study) {
        this.define_study = study;
    }

    public DefineStudyModel getStudy() {
        return this.define_study;
    }

    public List<DefineStandardModel> listSortedStandard() {
        ArrayList<DefineStandardModel> rtn = new ArrayList();
        rtn = this.map_define_standard.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<DefineDocumentModel> listSortedDocument() {
        ArrayList<DefineDocumentModel> rtn = new ArrayList();
        rtn = this.map_define_document.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<DefineDatasetModel> listSortedDataset() {
        ArrayList<DefineDatasetModel> rtn = new ArrayList();
        rtn = this.map_define_dataset.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<DefineVariableModel> listSortedVariable() {
        ArrayList<DefineVariableModel> rtn = new ArrayList();
        rtn = this.map_define_variable.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<DefineValueModel> listSortedValue() {
        ArrayList<DefineValueModel> rtn = new ArrayList();
        rtn = this.map_define_value.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<DefineDictionaryModel> listSortedDictionary() {
        ArrayList<DefineDictionaryModel> rtn = new ArrayList();
        rtn = this.map_define_dictionary.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<DefineCodelistModel> listSortedCodelist() {
        ArrayList<DefineCodelistModel> rtn = new ArrayList();
        rtn = this.map_define_codelist.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<DefineARMDisplayModel> listSortedARMDisplay() {
        ArrayList<DefineARMDisplayModel> rtn = new ArrayList();
        rtn = this.map_define_arm_display.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<DefineARMResultModel> listSortedARMResult() {
        ArrayList<DefineARMResultModel> rtn = new ArrayList();
        rtn = this.map_define_arm_result.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<DefineARMDatasetModel> listSortedARMDataset() {
        ArrayList<DefineARMDatasetModel> rtn = new ArrayList();
        rtn = this.map_define_arm_dataset.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<DefineMethodModel> listSortedMethod() {
        ArrayList<DefineMethodModel> rtn = new ArrayList();
        rtn = this.map_define_method.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<DefineCommentModel> listSortedComment() {
        ArrayList<DefineCommentModel> rtn = new ArrayList();
        rtn = this.map_define_comment.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public DefineDocumentModel get(DefineDocumentModel.DefineDocumentPk key) {
        return this.map_define_document.get(key);
    }

    public void put(DefineStandardModel.DefineStandardPk key, DefineStandardModel standard) {
        this.map_define_standard.put(key, standard);
    }

    public DefineStandardModel get(DefineStandardModel.DefineStandardPk key) {
        return this.map_define_standard.get(key);
    }

    public void put(DefineDocumentModel.DefineDocumentPk key, DefineDocumentModel document) {
        this.map_define_document.put(key, document);
    }

    public DefineDatasetModel get(DefineDatasetModel.DefineDatasetPk key) {
        return this.map_define_dataset.get(key);
    }

    public void put(DefineDatasetModel.DefineDatasetPk key, DefineDatasetModel dataset) {
        this.map_define_dataset.put(key, dataset);
    }

    public DefineVariableModel get(DefineVariableModel.DefineVariablePk key) {
        return this.map_define_variable.get(key);
    }

    public void put(DefineVariableModel.DefineVariablePk key, DefineVariableModel variable) {
        this.map_define_variable.put(key, variable);
    }

    public void remove(DefineVariableModel.DefineVariablePk key) {
        this.map_define_variable.remove(key);
    }

    public List<DefineVariableModel> getVariableByOid(String item_oid) {
        ArrayList<DefineVariableModel> rtn = new ArrayList<DefineVariableModel>();
        Set<Map.Entry<DefineVariableModel.DefineVariablePk, DefineVariableModel>> entries = this.map_define_variable.entrySet();
        for (Map.Entry<DefineVariableModel.DefineVariablePk, DefineVariableModel> entry : entries) {
            DefineVariableModel variable = entry.getValue();
            if (!StringUtils.equals((CharSequence)variable.variable_oid, (CharSequence)item_oid)) continue;
            rtn.add(variable);
        }
        return rtn;
    }

    public DefineValueModel get(DefineValueModel.DefineValuePk key) {
        return this.map_define_value.get(key);
    }

    public void put(DefineValueModel.DefineValuePk key, DefineValueModel value) {
        this.map_define_value.put(key, value);
    }

    public DefineWCModel get(DefineWCModel.DefineWCPk key) {
        return this.map_define_wc.get(key);
    }

    public void put(DefineWCModel.DefineWCPk key, DefineWCModel wc) {
        this.map_define_wc.put(key, wc);
    }

    public DefineDictionaryModel get(DefineDictionaryModel.DefineDictionaryPk key) {
        return this.map_define_dictionary.get(key);
    }

    public void put(DefineDictionaryModel.DefineDictionaryPk key, DefineDictionaryModel dictionary) {
        this.map_define_dictionary.put(key, dictionary);
    }

    public DefineCodelistModel get(DefineCodelistModel.DefineCodelistPk key) {
        return this.map_define_codelist.get(key);
    }

    public void put(DefineCodelistModel.DefineCodelistPk key, DefineCodelistModel codelist) {
        this.map_define_codelist.put(key, codelist);
    }

    public List<DefineCodelistModel> getCodelistByCodelistId(String codelist_oid) {
        ArrayList<DefineCodelistModel> rtn = new ArrayList<DefineCodelistModel>();
        Set<Map.Entry<DefineCodelistModel.DefineCodelistPk, DefineCodelistModel>> entries = this.map_define_codelist.entrySet();
        for (Map.Entry<DefineCodelistModel.DefineCodelistPk, DefineCodelistModel> entry : entries) {
            DefineCodelistModel codelist = entry.getValue();
            if (!StringUtils.equals((CharSequence)codelist.codelist_id, (CharSequence)codelist_oid)) continue;
            rtn.add(codelist);
        }
        return rtn;
    }

    public DefineARMDisplayModel get(DefineARMDisplayModel.DefineARMDisplayPk key) {
        return this.map_define_arm_display.get(key);
    }

    public void put(DefineARMDisplayModel.DefineARMDisplayPk key, DefineARMDisplayModel arm) {
        this.map_define_arm_display.put(key, arm);
    }

    public DefineARMResultModel get(DefineARMResultModel.DefineARMResultPk key) {
        return this.map_define_arm_result.get(key);
    }

    public void put(DefineARMResultModel.DefineARMResultPk key, DefineARMResultModel result) {
        this.map_define_arm_result.put(key, result);
    }

    public DefineARMDatasetModel get(DefineARMDatasetModel.DefineARMDatasetPk key) {
        return this.map_define_arm_dataset.get(key);
    }

    public void put(DefineARMDatasetModel.DefineARMDatasetPk key, DefineARMDatasetModel arm) {
        this.map_define_arm_dataset.put(key, arm);
    }

    public DefineMethodModel get(DefineMethodModel.DefineMethodPk key) {
        return this.map_define_method.get(key);
    }

    public void put(DefineMethodModel.DefineMethodPk key, DefineMethodModel method) {
        this.map_define_method.put(key, method);
    }

    public DefineCommentModel get(DefineCommentModel.DefineCommentPk key) {
        return this.map_define_comment.get(key);
    }

    public void put(DefineCommentModel.DefineCommentPk key, DefineCommentModel comment) {
        this.map_define_comment.put(key, comment);
    }

    public void convertToAutoSupp() {
        Object key;
        ArrayList<DefineVariableModel> qvals = new ArrayList<DefineVariableModel>();
        Set<Map.Entry<DefineVariableModel.DefineVariablePk, DefineVariableModel>> variable_entries = this.map_define_variable.entrySet();
        for (Map.Entry<DefineVariableModel.DefineVariablePk, DefineVariableModel> entry : variable_entries) {
            DefineVariableModel defineVariableModel = entry.getValue();
            if (!StringUtils.startsWith((CharSequence)defineVariableModel.dataset_name, (CharSequence)"SUPP") || !"QVAL".equals(defineVariableModel.variable_name)) continue;
            qvals.add(defineVariableModel);
        }
        ArrayList<DefineValueModel> qval_values = new ArrayList<DefineValueModel>();
        for (DefineVariableModel defineVariableModel : qvals) {
            List<DefineValueModel> values = this.listSortedValue();
            for (DefineValueModel value : values) {
                if (!StringUtils.equals((CharSequence)defineVariableModel.valuelist_oid, (CharSequence)value.valuelist_oid)) continue;
                qval_values.add(value);
            }
        }
        ArrayList<DefineValueModel> arrayList = new ArrayList<DefineValueModel>();
        block3: for (DefineValueModel qval_value : qval_values) {
            for (DefineWCModel.DefineWCPk where_caluse_pk : qval_value.where_clause_pks) {
                DefineWCModel wc = this.map_define_wc.get(where_caluse_pk);
                if (wc != null && !wc.wc_conditions.isEmpty()) {
                    for (DefineWCModel.WCCondition wc_condition : wc.wc_conditions) {
                        if (!"QNAM".equals(wc_condition.variable_name)) continue;
                        if (wc_condition.values.isEmpty()) break;
                        qval_value.qnam = wc_condition.values.get(0);
                        arrayList.add(qval_value);
                        break;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)qval_value.qnam)) continue;
                continue block3;
            }
        }
        for (DefineValueModel nsv : arrayList) {
            String dataset_name = StringUtils.substring((String)nsv.dataset_name, (int)4);
            key = new DefineVariableModel.DefineVariablePk(dataset_name, nsv.qnam);
            DefineVariableModel variable = new DefineVariableModel((DefineVariableModel.DefineVariablePk)key);
            variable.variable_name = nsv.qnam;
            List filtered_variables = this.map_define_variable.values().stream().filter(o -> StringUtils.equals((CharSequence)dataset_name, (CharSequence)o.dataset_name)).collect(Collectors.toList());
            variable.ordinal = filtered_variables.size() + 1;
            variable.domain = nsv.domain;
            variable.is_supp = YorN.Yes;
            variable.variable_label = nsv.value_label;
            if (nsv.has_no_data == YorNull.Yes) {
                variable.has_no_data = nsv.has_no_data;
            } else {
                DefineDatasetModel dataset = this.map_define_dataset.values().stream().filter(o -> StringUtils.equals((CharSequence)nsv.dataset_name, (CharSequence)o.dataset_name)).findFirst().orElse(null);
                if (dataset != null) {
                    variable.has_no_data = dataset.has_no_data;
                }
            }
            variable.mandatory = nsv.mandatory;
            variable.key_sequence = nsv.key_sequence;
            variable.data_type = nsv.data_type;
            variable.length = nsv.length;
            variable.significant_digits = nsv.significant_digits;
            variable.sas_field_name = nsv.sas_field_name;
            variable.display_format = nsv.display_format;
            variable.codelist = nsv.codelist;
            variable.origin = nsv.origin;
            variable.source = nsv.source;
            variable.crf_id = nsv.crf_id;
            variable.crf_page_type = nsv.crf_page_type;
            variable.crf_page_reference = nsv.crf_page_reference;
            variable.crf_first_page = nsv.crf_first_page;
            variable.crf_last_page = nsv.crf_last_page;
            variable.crf_page_title = nsv.crf_page_title;
            variable.predecessor = nsv.predecessor;
            variable.method_oid = nsv.method_oid;
            variable.comment_oid = nsv.comment_oid;
            variable.user_note1 = nsv.user_note1;
            variable.user_note2 = nsv.user_note2;
            this.map_define_variable.put((DefineVariableModel.DefineVariablePk)key, variable);
        }
        Iterator<DefineValueModel.DefineValuePk> iterator = this.map_define_value.keySet().iterator();
        while (iterator.hasNext()) {
            DefineValueModel.DefineValuePk key2 = iterator.next();
            DefineValueModel value = this.map_define_value.get(key2);
            if (!StringUtils.startsWith((CharSequence)value.dataset_name, (CharSequence)"SUPP")) continue;
            for (DefineWCModel.DefineWCPk where_clause_pk : value.where_clause_pks) {
                this.map_define_wc.remove(where_clause_pk);
            }
            iterator.remove();
        }
        Iterator<DefineVariableModel.DefineVariablePk> variable_iterator = this.map_define_variable.keySet().iterator();
        while (variable_iterator.hasNext()) {
            DefineVariableModel.DefineVariablePk key3 = variable_iterator.next();
            if (!StringUtils.startsWith((CharSequence)key3.dataset_name, (CharSequence)"SUPP")) continue;
            variable_iterator.remove();
        }
        Iterator<DefineDatasetModel.DefineDatasetPk> dataset_iterator = this.map_define_dataset.keySet().iterator();
        while (dataset_iterator.hasNext()) {
            key = dataset_iterator.next();
            if (!StringUtils.startsWith((CharSequence)((DefineDatasetModel.DefineDatasetPk)key).dataset_name, (CharSequence)"SUPP")) continue;
            dataset_iterator.remove();
        }
    }

    public void updateHasSupp() {
        List<DefineVariableModel> variables = this.listSortedVariable();
        for (DefineVariableModel variable : variables) {
            if (variable.is_supp != YorN.Yes) continue;
            DefineDatasetModel dataset = this.get(new DefineDatasetModel.DefineDatasetPk(variable.dataset_name));
            dataset.has_supp = YorN.Yes;
        }
    }

    public void updateVariableOrdinal() {
        Set<Map.Entry<DefineVariableModel.DefineVariablePk, DefineVariableModel>> entries = this.map_define_variable.entrySet();
        for (Map.Entry<DefineVariableModel.DefineVariablePk, DefineVariableModel> entry : entries) {
            DefineVariableModel variable = entry.getValue();
            DefineDatasetModel dataset = this.map_define_dataset.get(new DefineDatasetModel.DefineDatasetPk(variable.dataset_name));
            if (dataset == null) continue;
            variable.dataset_ordinal = dataset.ordinal;
        }
    }

    public void updateVLM() {
        List<DefineVariableModel> variables = this.listSortedVariable();
        Set<Map.Entry<DefineValueModel.DefineValuePk, DefineValueModel>> entries = this.map_define_value.entrySet();
        for (Map.Entry<DefineValueModel.DefineValuePk, DefineValueModel> entry : entries) {
            DefineValueModel value = entry.getValue();
            DefineVariableModel variable = variables.stream().filter(o -> StringUtils.equals((CharSequence)value.valuelist_oid, (CharSequence)o.valuelist_oid)).findFirst().orElse(null);
            if (variable != null) {
                variable.has_vlm = YorN.Yes;
                value.dataset_name = variable.dataset_name;
                value.variable_name = variable.variable_name;
            }
            for (int i = 0; i < value.where_clause_pks.size(); ++i) {
                DefineWCModel.DefineWCPk where_clause_pk = value.where_clause_pks.get(i);
                DefineWCModel wc = this.map_define_wc.get(where_clause_pk);
                if (value.where_clause_pks.size() > 1) {
                    wc.group_id = "WC" + (i + 1);
                }
                if (wc == null || wc.wc_conditions.isEmpty()) continue;
                for (DefineWCModel.WCCondition wc_condition : wc.wc_conditions) {
                    DefineVariableModel wc_variable = variables.stream().filter(o -> StringUtils.equals((CharSequence)wc_condition.variable_oid, (CharSequence)o.variable_oid)).findFirst().orElse(null);
                    if (wc_variable == null) continue;
                    wc_condition.dataset_name = wc_variable.dataset_name;
                    wc_condition.variable_name = wc_variable.variable_name;
                }
            }
        }
    }

    public void updateARMDisplay() {
        List<DefineVariableModel> variables = this.listSortedVariable();
        List<DefineARMDisplayModel> displays = this.listSortedARMDisplay();
        for (DefineARMDisplayModel display : displays) {
            for (DefineARMResultModel.DefineARMResultPk result_pk : display.arm_result_pks) {
                DefineARMResultModel result = this.map_define_arm_result.get(result_pk);
                DefineVariableModel variable = variables.stream().filter(o -> StringUtils.equals((CharSequence)result.param_oid, (CharSequence)o.variable_oid)).findFirst().orElse(null);
                if (variable == null) continue;
                result.param_dataset = variable.dataset_name;
            }
        }
    }

    public void updateARMDataset() {
        List<DefineDatasetModel> datasets = this.listSortedDataset();
        List<DefineVariableModel> variables = this.listSortedVariable();
        List<DefineARMDatasetModel> arm_datasets = this.listSortedARMDataset();
        for (DefineARMDatasetModel arm_dataset : arm_datasets) {
            DefineWCModel wc;
            DefineDatasetModel dataset = datasets.stream().filter(o -> StringUtils.equals((CharSequence)arm_dataset.dataset_oid, (CharSequence)o.dataset_oid)).findFirst().orElse(null);
            List filtered_variables = variables.stream().filter(o -> arm_dataset.analysis_variable_oids.contains(o.variable_oid)).collect(Collectors.toList());
            if (dataset != null) {
                arm_dataset.dataset_name = dataset.dataset_name;
            }
            if (!filtered_variables.isEmpty()) {
                for (DefineVariableModel filtered_variable : filtered_variables) {
                    arm_dataset.analysis_variables.add(filtered_variable.variable_name);
                }
            }
            if (arm_dataset.where_clause_pk == null || (wc = this.map_define_wc.get(arm_dataset.where_clause_pk)) == null || wc.wc_conditions.isEmpty()) continue;
            for (DefineWCModel.WCCondition wc_condition : wc.wc_conditions) {
                DefineVariableModel wc_variable = variables.stream().filter(o -> StringUtils.equals((CharSequence)wc_condition.variable_oid, (CharSequence)o.variable_oid)).findFirst().orElse(null);
                if (wc_variable == null) continue;
                wc_condition.dataset_name = wc_variable.dataset_name;
                wc_condition.variable_name = wc_variable.variable_name;
            }
        }
    }

    public void processRepeatN(Config.DatasetType type) {
        if (type == null || type == Config.DatasetType.ADaM) {
            return;
        }
        List variables = this.listSortedVariable().stream().filter(o -> o.repeat_n > 0).collect(Collectors.toList());
        boolean is_auto_supp = false;
        List supp_datasets = this.listSortedDataset().stream().filter(o -> StringUtils.startsWith((CharSequence)o.dataset_name, (CharSequence)"SUPP") && !"SUPPQUAL".equals(o.dataset_name)).collect(Collectors.toList());
        if (supp_datasets.isEmpty()) {
            is_auto_supp = true;
        }
        for (DefineVariableModel variable : variables) {
            for (int i = 1; i <= variable.repeat_n; ++i) {
                DefineDatasetModel supp_dataset = supp_datasets.stream().filter(o -> ("SUPP" + variable.dataset_name).equals(o.dataset_name)).findFirst().orElse(null);
                String variable_name = DefineModel.getRepeatVariableName(variable.variable_name, i);
                if (is_auto_supp || supp_dataset == null) {
                    DefineVariableModel.DefineVariablePk new_var_pk = new DefineVariableModel.DefineVariablePk(variable.dataset_name, DefineVariableModel.createOid(variable.dataset_name, variable_name));
                    DefineVariableModel new_var = new DefineVariableModel(new_var_pk);
                    new_var.copy(variable);
                    new_var.variable_name = variable_name;
                    new_var.ordinal = variable.ordinal + i;
                    new_var.is_supp = "TSVAL".equals(variable.variable_name) || "COVAL".equals(variable.variable_name) ? YorN.No : YorN.Yes;
                    new_var.repeat_n = 0;
                    new_var.variable_label = DefineModel.getRepeatVariableLabel(variable.variable_label, i);
                    new_var.length = variable.repeat_n_length.size() > i ? variable.repeat_n_length.get(i) : variable.length;
                    new_var.repeat_n_length = new ArrayList<String>();
                    new_var.sas_field_name = new_var.variable_name;
                    this.put(new_var_pk, new_var);
                    this.shiftOrdinal(new_var);
                    continue;
                }
                DefineValueModel.DefineValuePk new_value_pk = new DefineValueModel.DefineValuePk(DefineValueModel.createOid(supp_dataset.dataset_name, "QVAL", variable_name, ""));
                DefineValueModel new_value = new DefineValueModel(new_value_pk);
                new_value.dataset_name = supp_dataset.dataset_name;
                new_value.variable_name = "QVAL";
                new_value.value_name = variable_name;
                new_value.ordinal = i;
                new_value.value_label = DefineModel.getRepeatVariableLabel(variable.variable_label, i);
                new_value.mandatory = variable.mandatory;
                new_value.data_type = variable.data_type;
                new_value.length = variable.repeat_n_length.size() > i ? variable.repeat_n_length.get(i) : variable.length;
                new_value.significant_digits = variable.significant_digits;
                new_value.display_format = variable.display_format;
                new_value.sas_field_name = variable_name;
                new_value.codelist = variable.codelist;
                new_value.origin = variable.origin;
                new_value.source = variable.source;
                new_value.crf_id = variable.crf_id;
                new_value.crf_page_type = variable.crf_page_type;
                new_value.crf_page_reference = variable.crf_page_reference;
                new_value.crf_first_page = variable.crf_first_page;
                new_value.crf_last_page = variable.crf_last_page;
                new_value.crf_page_title = variable.crf_page_title;
                new_value.predecessor = variable.predecessor;
                new_value.method_oid = variable.method_oid;
                new_value.comment_oid = variable.comment_oid;
                new_value.alias_context = variable.alias_context;
                new_value.alias_name = variable.alias_name;
                new_value.user_note1 = variable.user_note1;
                new_value.user_note2 = variable.user_note2;
                String wc_oid = DefineWCModel.createOid(supp_dataset.dataset_name, variable_name, "QVAL", "", "");
                DefineWCModel.DefineWCPk wc_pk = new DefineWCModel.DefineWCPk(wc_oid);
                DefineWCModel wc = new DefineWCModel(wc_pk);
                DefineWCModel.WCCondition wc_condition = new DefineWCModel.WCCondition();
                wc_condition.dataset_name = supp_dataset.dataset_name;
                wc_condition.variable_name = "QVAL";
                wc_condition.operator = "EQ";
                wc_condition.values.add(variable_name);
                wc.wc_conditions.add(wc_condition);
                this.put(wc_pk, wc);
                new_value.where_clause_pks.add(wc_pk);
                this.put(new_value_pk, new_value);
                this.shiftOrdinal(new_value);
                DefineVariableModel qval = this.get(new DefineVariableModel.DefineVariablePk(supp_dataset.dataset_name, DefineVariableModel.createOid(supp_dataset.dataset_name, "QVAL")));
                qval.valuelist_oid = DefineVariableModel.createValueListOid(supp_dataset.dataset_name, "QVAL");
            }
        }
        for (int i = 0; i < variables.size(); ++i) {
            DefineVariableModel variable;
            variable = (DefineVariableModel)variables.get(i);
            if (!is_auto_supp || variable.is_supp != YorN.Yes || variable.repeat_n <= 0) continue;
            this.remove(variable.getKey());
        }
    }

    public void shiftOrdinal(DefineVariableModel var_to_insert) {
        List variables = this.listSortedVariable().stream().filter(o -> StringUtils.equals((CharSequence)var_to_insert.dataset_name, (CharSequence)o.dataset_name)).collect(Collectors.toList());
        for (DefineVariableModel variable : variables) {
            if (StringUtils.equals((CharSequence)variable.variable_oid, (CharSequence)var_to_insert.variable_oid) || variable.ordinal < var_to_insert.ordinal) continue;
            variable.ordinal = variable.ordinal + 1;
        }
    }

    public void shiftOrdinal(DefineValueModel val_to_insert) {
        List values = this.listSortedValue().stream().filter(o -> StringUtils.equals((CharSequence)val_to_insert.dataset_name, (CharSequence)o.dataset_name) && StringUtils.equals((CharSequence)val_to_insert.variable_name, (CharSequence)o.variable_name)).collect(Collectors.toList());
        for (DefineValueModel value : values) {
            if (StringUtils.equals((CharSequence)value.value_oid, (CharSequence)val_to_insert.value_oid) || value.ordinal < val_to_insert.ordinal) continue;
            value.ordinal = value.ordinal + 1;
        }
    }

    public static String getRepeatVariableName(String variable_name, int N) {
        if (StringUtils.isEmpty((CharSequence)variable_name)) {
            return variable_name;
        }
        if (N == 0) {
            return variable_name;
        }
        variable_name = "CMCLASCD".equals(variable_name) ? (N < 10 ? "CMCLSCD" + N : "CMCLSC" + N) : (variable_name.length() >= 8 && 1 <= N && N < 10 ? variable_name.substring(0, 7) + N : (variable_name.length() == 7 && 10 <= N && N < 100 ? variable_name.substring(0, 6) + N : variable_name + N));
        return variable_name;
    }

    public static String getRepeatVariableLabel(String variable_label, int N) {
        if (StringUtils.isEmpty((CharSequence)variable_label)) {
            return variable_label;
        }
        if (N == 0) {
            return variable_label;
        }
        variable_label = variable_label.length() >= 39 && 1 <= N && N < 10 ? variable_label.substring(0, 38) + " " + N : (variable_label.length() == 38 && 10 <= N && N < 100 ? variable_label.substring(0, 37) + " " + N : variable_label + " " + N);
        return variable_label;
    }

    public static class DocumentRef {
        public String document_id;
        public String document_page_type;
        public String document_page_reference;
        public String document_first_page;
        public String document_last_page;
        public String document_page_title;

        public DocumentRef(String document_id) {
            this.document_id = document_id;
            this.document_page_type = "";
            this.document_page_reference = "";
            this.document_first_page = "";
            this.document_last_page = "";
            this.document_page_title = "";
        }
    }

    public static enum DocType {
        AnnotatedCRF,
        SupplementalDoc,
        Other;


        public static DocType parse(String docType) {
            if ("AnnotatedCRF".equals(docType)) {
                return AnnotatedCRF;
            }
            if ("SupplementalDoc".equals(docType)) {
                return SupplementalDoc;
            }
            return Other;
        }
    }

    public static enum YorNull {
        Yes;


        public static YorNull parse(String yOrNull) {
            if ("Yes".equals(yOrNull)) {
                return Yes;
            }
            if ("Y".equals(yOrNull)) {
                return Yes;
            }
            return null;
        }
    }

    public static enum YorN {
        Yes,
        No;


        public static YorN parse(String yOrN) {
            if ("Yes".equals(yOrN)) {
                return Yes;
            }
            if ("Y".equals(yOrN)) {
                return Yes;
            }
            return No;
        }
    }
}

