/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer.models;

import com.fujitsu.tsc.desktop.importer.models.DefineModel;
import com.fujitsu.tsc.desktop.importer.models.DefineVariableModel;
import com.fujitsu.tsc.desktop.importer.models.DefineWCModel;
import com.fujitsu.tsc.desktop.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefineValueModel
implements Comparable<DefineValueModel> {
    public final String value_oid;
    public String valuelist_oid;
    public String dataset_name;
    public String variable_name;
    public String value_name;
    public String value_key;
    public Integer ordinal;
    public String domain;
    public String value_label;
    public DefineModel.YorNull has_no_data;
    public DefineModel.YorNull has_no_data_derived;
    public DefineModel.YorN mandatory;
    public String key_sequence;
    public String data_type;
    public String length;
    public String significant_digits;
    public String sas_field_name;
    public String display_format;
    public String codelist;
    public String origin;
    public String source;
    public String crf_id;
    public String crf_page_type;
    public String crf_page_reference;
    public String crf_first_page;
    public String crf_last_page;
    public String crf_page_title;
    public String predecessor;
    public String method_oid;
    public String comment_oid;
    public String alias_context;
    public String alias_name;
    public String user_note1;
    public String user_note2;
    public List<DefineWCModel.DefineWCPk> where_clause_pks;
    public String qnam;

    public DefineValueModel(DefineValuePk key) {
        this.value_oid = key.value_oid;
        this.valuelist_oid = "";
        this.dataset_name = "";
        this.variable_name = "";
        this.value_name = "";
        this.value_key = "";
        this.ordinal = 0;
        this.domain = "";
        this.value_label = "";
        this.has_no_data = null;
        this.has_no_data_derived = null;
        this.mandatory = DefineModel.YorN.No;
        this.key_sequence = "";
        this.data_type = "";
        this.length = "";
        this.significant_digits = "";
        this.sas_field_name = "";
        this.display_format = "";
        this.codelist = "";
        this.origin = "";
        this.source = "";
        this.crf_id = "";
        this.crf_page_type = "";
        this.crf_page_reference = "";
        this.crf_first_page = "";
        this.crf_last_page = "";
        this.crf_page_title = "";
        this.predecessor = "";
        this.method_oid = "";
        this.comment_oid = "";
        this.alias_context = "";
        this.alias_name = "";
        this.user_note1 = "";
        this.user_note2 = "";
        this.where_clause_pks = new ArrayList<DefineWCModel.DefineWCPk>();
        this.qnam = "";
    }

    public DefineValuePk getKey() {
        return new DefineValuePk(this.value_oid);
    }

    public String toOid() {
        return this.value_oid;
    }

    public static String createOid(String dataset_name, String variable_name, String value_name, String value_key) {
        String value_oid = "";
        if (StringUtils.isEmpty((CharSequence)dataset_name) || StringUtils.isEmpty((CharSequence)variable_name) || StringUtils.isEmpty((CharSequence)value_name)) {
            return value_oid;
        }
        value_oid = StringUtils.isEmpty((CharSequence)value_key) ? "IT." + dataset_name + "." + variable_name + "." + Utils.codedText(value_name) : "IT." + dataset_name + "." + variable_name + "." + Utils.codedText(value_key);
        return value_oid;
    }

    public DefineModel.YorNull deriveHasNoData(DefineModel define) {
        DefineVariableModel variable = define.get(new DefineVariableModel.DefineVariablePk(this.dataset_name, DefineVariableModel.createOid(this.dataset_name, this.variable_name)));
        if (variable == null || variable.has_no_data_derived == null) {
            return this.has_no_data;
        }
        return DefineModel.YorNull.Yes;
    }

    @Override
    public int compareTo(DefineValueModel value) {
        if (this.dataset_name.equals(value.dataset_name)) {
            if (this.variable_name.equals(value.variable_name)) {
                return this.value_name.compareTo(value.value_name);
            }
            return this.variable_name.compareTo(value.variable_name);
        }
        return this.dataset_name.compareTo(value.dataset_name);
    }

    public static class DefineValuePk
    implements Comparable<DefineValuePk> {
        public final String value_oid;

        public DefineValuePk(String value_oid) {
            this.value_oid = value_oid;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.value_oid.equals(((DefineValuePk)obj).value_oid);
        }

        @Override
        public int compareTo(DefineValuePk key) {
            return this.value_oid.compareTo(key.value_oid);
        }

        public String toString() {
            String rtn = "ValueOID: " + this.value_oid;
            return rtn;
        }

        public int hashCode() {
            return Objects.hash(this.value_oid);
        }
    }
}

