/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer.models;

import com.fujitsu.tsc.desktop.importer.models.EdcKeysModel;
import com.fujitsu.tsc.desktop.importer.models.OdmCodelistModel;
import com.fujitsu.tsc.desktop.importer.models.OdmConditionModel;
import com.fujitsu.tsc.desktop.importer.models.OdmEventFormModel;
import com.fujitsu.tsc.desktop.importer.models.OdmEventModel;
import com.fujitsu.tsc.desktop.importer.models.OdmFieldModel;
import com.fujitsu.tsc.desktop.importer.models.OdmFormModel;
import com.fujitsu.tsc.desktop.importer.models.OdmMethodModel;
import com.fujitsu.tsc.desktop.importer.models.OdmStudyModel;
import com.fujitsu.tsc.desktop.importer.models.OdmUnitModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class OdmModel {
    private OdmStudyModel odm_study = new OdmStudyModel();
    private Map<OdmUnitModel.OdmUnitPk, OdmUnitModel> map_odm_unit = new HashMap<OdmUnitModel.OdmUnitPk, OdmUnitModel>();
    private int unit_max_ordinal = 0;
    private Map<OdmEventModel.OdmEventPk, OdmEventModel> map_odm_event = new HashMap<OdmEventModel.OdmEventPk, OdmEventModel>();
    private Map<OdmEventFormModel.OdmEventFormPk, OdmEventFormModel> map_odm_eventform = new HashMap<OdmEventFormModel.OdmEventFormPk, OdmEventFormModel>();
    private Map<OdmFormModel.OdmFormPk, OdmFormModel> map_odm_form = new HashMap<OdmFormModel.OdmFormPk, OdmFormModel>();
    private Map<OdmFieldModel.OdmFieldPk, OdmFieldModel> map_odm_field = new HashMap<OdmFieldModel.OdmFieldPk, OdmFieldModel>();
    private Map<OdmCodelistModel.OdmCodelistPk, OdmCodelistModel> map_odm_codelist = new HashMap<OdmCodelistModel.OdmCodelistPk, OdmCodelistModel>();
    private Map<OdmMethodModel.OdmMethodPk, OdmMethodModel> map_odm_method = new HashMap<OdmMethodModel.OdmMethodPk, OdmMethodModel>();
    private Map<OdmConditionModel.OdmConditionPk, OdmConditionModel> map_odm_condition = new HashMap<OdmConditionModel.OdmConditionPk, OdmConditionModel>();
    private EdcKeysModel edc_keys = new EdcKeysModel();

    public void put(OdmStudyModel study) {
        this.odm_study = study;
    }

    public OdmStudyModel getStudy() {
        return this.odm_study;
    }

    public List<OdmUnitModel> listUnit() {
        ArrayList<OdmUnitModel> rtn = new ArrayList();
        rtn = this.map_odm_unit.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<OdmEventModel> listEvent() {
        ArrayList<OdmEventModel> rtn = new ArrayList();
        rtn = this.map_odm_event.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<OdmEventFormModel> listEventForm() {
        ArrayList<OdmEventFormModel> rtn = new ArrayList();
        rtn = this.map_odm_eventform.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<OdmFormModel> listForm() {
        ArrayList<OdmFormModel> rtn = new ArrayList();
        rtn = this.map_odm_form.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<OdmFieldModel> listField() {
        ArrayList<OdmFieldModel> rtn = new ArrayList();
        rtn = this.map_odm_field.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<OdmCodelistModel> listCodelist() {
        ArrayList<OdmCodelistModel> rtn = new ArrayList();
        rtn = this.map_odm_codelist.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<OdmMethodModel> listMethod() {
        ArrayList<OdmMethodModel> rtn = new ArrayList();
        rtn = this.map_odm_method.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public List<OdmConditionModel> listCondition() {
        ArrayList<OdmConditionModel> rtn = new ArrayList();
        rtn = this.map_odm_condition.values().stream().sorted().collect(Collectors.toList());
        return rtn;
    }

    public void put(OdmUnitModel.OdmUnitPk key, OdmUnitModel unit) {
        this.map_odm_unit.put(key, unit);
        if (unit != null && unit.ordinal > this.unit_max_ordinal) {
            this.unit_max_ordinal = unit.ordinal;
        }
    }

    public OdmUnitModel get(OdmUnitModel.OdmUnitPk key) {
        return this.map_odm_unit.get(key);
    }

    public int getUnitMaxOrdinal() {
        return this.unit_max_ordinal;
    }

    public void put(OdmEventModel.OdmEventPk key, OdmEventModel event) {
        this.map_odm_event.put(key, event);
    }

    public OdmEventModel get(OdmEventModel.OdmEventPk key) {
        return this.map_odm_event.get(key);
    }

    public void put(OdmEventFormModel.OdmEventFormPk key, OdmEventFormModel eventform) {
        this.map_odm_eventform.put(key, eventform);
    }

    public OdmEventFormModel get(OdmEventFormModel.OdmEventFormPk key) {
        return this.map_odm_eventform.get(key);
    }

    public void put(OdmFormModel.OdmFormPk key, OdmFormModel form) {
        this.map_odm_form.put(key, form);
    }

    public OdmFormModel get(OdmFormModel.OdmFormPk key) {
        return this.map_odm_form.get(key);
    }

    public void updateEventForm(String form_id, String form_name) {
        Set<OdmEventFormModel.OdmEventFormPk> keys = this.map_odm_eventform.keySet();
        for (OdmEventFormModel.OdmEventFormPk key : keys) {
            OdmEventFormModel eventform = this.map_odm_eventform.get(key);
            if (!eventform.form_id.equals(form_id)) continue;
            eventform.form_name = form_name;
            this.map_odm_eventform.put(key, eventform);
        }
    }

    public void put(OdmFieldModel.OdmFieldPk key, OdmFieldModel field) {
        this.map_odm_field.put(key, field);
    }

    public OdmFieldModel get(OdmFieldModel.OdmFieldPk key) {
        return this.map_odm_field.get(key);
    }

    public List<OdmFieldModel> getItemGroupById(String item_group_oid) {
        ArrayList<OdmFieldModel> rtn = new ArrayList<OdmFieldModel>();
        Set<OdmFieldModel.OdmFieldPk> keys = this.map_odm_field.keySet();
        for (OdmFieldModel.OdmFieldPk key : keys) {
            OdmFieldModel itemgroup = this.map_odm_field.get(key);
            if (!itemgroup.field_id.equals(item_group_oid) || !itemgroup.item_group_oid.equals(item_group_oid)) continue;
            rtn.add(itemgroup);
        }
        return rtn;
    }

    public List<OdmFieldModel> getItemById(String item_oid) {
        ArrayList<OdmFieldModel> rtn = new ArrayList<OdmFieldModel>();
        Set<OdmFieldModel.OdmFieldPk> keys = this.map_odm_field.keySet();
        for (OdmFieldModel.OdmFieldPk key : keys) {
            OdmFieldModel item = this.map_odm_field.get(key);
            if (!item.field_id.equals(item_oid)) continue;
            rtn.add(item);
        }
        return rtn;
    }

    public void updateFieldFormName() {
        Set<OdmFieldModel.OdmFieldPk> keys = this.map_odm_field.keySet();
        for (OdmFieldModel.OdmFieldPk key : keys) {
            OdmFieldModel field = this.map_odm_field.get(key);
            OdmFormModel form = this.map_odm_form.get(new OdmFormModel.OdmFormPk(key.form_id));
            if (field == null || form == null) continue;
            field.form_name = form.name;
        }
    }

    public void updateFieldId(String delimiter) {
        HashSet<String> common_vars_set = new HashSet<String>();
        String[] common_vars_array = StringUtils.split((String)this.edc_keys.common_vars, (String)delimiter);
        if (common_vars_array == null) {
            return;
        }
        for (int i = 0; i < common_vars_array.length; ++i) {
            common_vars_set.add(common_vars_array[i]);
        }
        Set<OdmFieldModel.OdmFieldPk> keys = this.map_odm_field.keySet();
        HashMap<OdmFieldModel.OdmFieldPk, OdmFieldModel> new_fields_map = new HashMap<OdmFieldModel.OdmFieldPk, OdmFieldModel>();
        Iterator<OdmFieldModel.OdmFieldPk> iterator = keys.iterator();
        while (iterator.hasNext()) {
            OdmFieldModel.OdmFieldPk key = iterator.next();
            if (common_vars_set.contains(key.field_id)) continue;
            String new_field_id = key.form_id + "." + key.field_id;
            OdmFieldModel.OdmFieldPk new_key = new OdmFieldModel.OdmFieldPk(key.form_id, key.item_group_oid, new_field_id);
            OdmFieldModel new_field = OdmFieldModel.clone(this.map_odm_field.get(key), new_key);
            iterator.remove();
            new_fields_map.put(new_key, new_field);
        }
        for (OdmFieldModel.OdmFieldPk key : new_fields_map.keySet()) {
            this.map_odm_field.put(key, (OdmFieldModel)new_fields_map.get(key));
        }
    }

    public void put(OdmCodelistModel.OdmCodelistPk key, OdmCodelistModel codelist) {
        this.map_odm_codelist.put(key, codelist);
    }

    public OdmCodelistModel get(OdmCodelistModel.OdmCodelistPk key) {
        return this.map_odm_codelist.get(key);
    }

    public void updateCodelist(String codelist_id, String alias_context, String alias_name, String DELIMITER) {
        Set<OdmCodelistModel.OdmCodelistPk> keys = this.map_odm_codelist.keySet();
        for (OdmCodelistModel.OdmCodelistPk key : keys) {
            OdmCodelistModel codelist = this.map_odm_codelist.get(key);
            if (!codelist.codelist.equals(codelist_id)) continue;
            codelist.alias_context = StringUtils.isEmpty((CharSequence)alias_context) ? alias_context : codelist.alias_context + DELIMITER + alias_context;
            codelist.alias_name = StringUtils.isEmpty((CharSequence)alias_name) ? alias_name : codelist.alias_name + DELIMITER + alias_name;
            if (codelist.alias_context.equals("SDTM")) {
                codelist.code = alias_name;
            }
            this.map_odm_codelist.put(key, codelist);
        }
    }

    public void removeCodelist(String codelist_id) {
        Set<OdmCodelistModel.OdmCodelistPk> keys = this.map_odm_codelist.keySet();
        Iterator<OdmCodelistModel.OdmCodelistPk> iterator = keys.iterator();
        while (iterator.hasNext()) {
            OdmCodelistModel.OdmCodelistPk key = iterator.next();
            if (!StringUtils.equals((CharSequence)codelist_id, (CharSequence)key.codelist)) continue;
            iterator.remove();
        }
    }

    public void put(OdmMethodModel.OdmMethodPk key, OdmMethodModel method) {
        this.map_odm_method.put(key, method);
    }

    public OdmMethodModel get(OdmMethodModel.OdmMethodPk key) {
        return this.map_odm_method.get(key);
    }

    public void put(OdmConditionModel.OdmConditionPk key, OdmConditionModel condition) {
        this.map_odm_condition.put(key, condition);
    }

    public OdmConditionModel get(OdmConditionModel.OdmConditionPk key) {
        return this.map_odm_condition.get(key);
    }

    public void put(EdcKeysModel edc_keys) {
        this.edc_keys = edc_keys;
    }

    public EdcKeysModel getEdcKeys() {
        return this.edc_keys;
    }

    public void updateEdcKeys(String delimiter) {
        HashSet<String> common_vars_set = new HashSet<String>();
        String[] edc_keys_array = StringUtils.split((String)this.edc_keys.common_vars, (String)delimiter);
        if (edc_keys_array == null) {
            return;
        }
        for (int i = 0; i < edc_keys_array.length; ++i) {
            common_vars_set.add(edc_keys_array[i]);
        }
        if (StringUtils.equals((CharSequence)this.odm_study.source_system, (CharSequence)"Medidata Rave")) {
            if (common_vars_set.contains("Subject")) {
                this.edc_keys.subject_id = "Subject";
            }
            if (common_vars_set.contains("Folder")) {
                this.edc_keys.visit_id = "Folder";
            }
            if (common_vars_set.contains("InstanceRepeatNumber")) {
                this.edc_keys.visit_repeat_key = "InstanceRepeatNumber";
            }
            this.edc_keys.form_id = "<filename>";
            if (common_vars_set.contains("PageRepeatNumber")) {
                this.edc_keys.form_repeat_key = "PageRepeatNumber";
            }
            this.edc_keys.itemgroup_id = "<filename>";
            if (common_vars_set.contains("RecordPosition")) {
                this.edc_keys.itemgroup_repeat_key = "RecordPosition";
            }
        }
    }
}

