/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer.models;

import com.fujitsu.tsc.desktop.util.Utils;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefineStandardModel
implements Comparable<DefineStandardModel> {
    public final String standard_oid;
    public String standard_name;
    public String standard_version;
    public String publishing_set;
    public Integer ordinal;
    public StandardType standard_type;
    public String standard_status;
    public String comment_oid;
    public String user_note1;
    public String user_note2;

    public DefineStandardModel(DefineStandardPk key) {
        this.standard_oid = key.standard_oid;
        this.standard_name = "";
        this.standard_version = "";
        this.publishing_set = "";
        this.ordinal = 0;
        this.standard_type = StandardType.IG;
        this.standard_status = "";
        this.comment_oid = "";
        this.user_note1 = "";
        this.user_note2 = "";
    }

    public String toOid() {
        return DefineStandardModel.createOid(this.standard_name, this.standard_version, this.publishing_set);
    }

    public static String createOid(String standard_name, String standard_version, String publishing_set) {
        String coded_standard_name = Utils.codedText(standard_name);
        String coded_standard_version = Utils.codedText(standard_version);
        String coded_publishing_set = "";
        if (StringUtils.isNotEmpty((CharSequence)publishing_set)) {
            coded_publishing_set = Utils.codedText(publishing_set);
        }
        String rtn = "STD." + coded_standard_name + "_" + coded_standard_version;
        if (StringUtils.isNotEmpty((CharSequence)coded_publishing_set)) {
            rtn = rtn + "_" + coded_publishing_set;
        }
        return rtn;
    }

    public String name(StandardType std_type) {
        if (std_type == StandardType.CT) {
            return this.publishing_set + " " + this.standard_version;
        }
        return this.standard_name + " " + this.standard_version;
    }

    @Override
    public int compareTo(DefineStandardModel standard) {
        if (this.standard_name == standard.standard_name) {
            if (this.standard_version == standard.standard_version) {
                return this.publishing_set.compareTo(standard.publishing_set);
            }
            return this.standard_version.compareTo(standard.standard_version);
        }
        return this.standard_name.compareTo(standard.standard_name);
    }

    public static enum StandardType {
        CT,
        IG;


        public static StandardType parse(String standard_type) {
            if ("CT".equals(standard_type)) {
                return CT;
            }
            return IG;
        }
    }

    public static class DefineStandardPk
    implements Comparable<DefineStandardPk> {
        public final String standard_oid;

        public DefineStandardPk(String standard_oid) {
            this.standard_oid = standard_oid;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.standard_oid.equals(((DefineStandardPk)obj).standard_oid);
        }

        @Override
        public int compareTo(DefineStandardPk key) {
            return this.standard_oid.compareTo(key.standard_oid);
        }

        public String toString() {
            String rtn = "Standard OID: " + this.standard_oid;
            return rtn;
        }

        public int hashCode() {
            return Objects.hash(this.standard_oid);
        }
    }
}

