/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.util;

import java.util.Properties;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static Logger logger = LogManager.getLogger();
    public static String SOFTWARE_NAME = "tsClinical Metadata";
    public static String SOFTWARE_VERSION = "1.1.3 (Open Source Edition)";
    public static String[] DEFINE_VERSIONS = new String[]{"2.0.0", "2.1.n"};
    public static String[] ODM_VERSIONS = new String[]{"1.3.2"};
    public static String[] EDT_TYPE = new String[]{"Screening (Denormalized)", "KeyCode Table", "Exposure (Normalized)", "Exposure (Denormalized)", "Deviation (Normalized)", "Deviation (Denormalized)", "Coding (MedDRA)", "Coding (WHO DD)", "Coding (Other)", "Test Results (LAB Normalized)", "Test Results (LAB Denormalized)", "Test Results (ECG Normalized)", "Test Results (ECG Denormalized)", "Test Results (Other Normalized)", "Test Results (Other Denormalized)", "Other"};
    public static String[] ENCODING = new String[]{"UTF-8", "ISO-8859-1", "Shift_JIS"};
    public static String DEFAULT_ENCODING = "UTF-8";
    public static String[] DELIMITED_FIXED = new String[]{"Delimited"};
    public static String[] TEXT_QUALIFIER = new String[]{"\"", "'", "(None)"};
    public String e2dDefineVersion = "";
    public DatasetType e2dDatasetType = DatasetType.SDTM;
    public boolean e2dIncludeResultMetadata = false;
    public String e2dXmlEncoding = "UTF-8";
    public String e2dStylesheetLocation = "";
    public String e2dDataSourceLocation = "";
    public String e2dOutputLocation = "";
    public String defineStudyTableName = "STUDY";
    public String defineMethodTableName = "METHOD";
    public String defineCommentTableName = "COMMENT";
    public String defineStandardTableName = "STANDARD";
    public String defineDocumentTableName = "DOCUMENT";
    public String defineDatasetTableName = "DATASET";
    public String defineVariableTableName = "VARIABLE";
    public String defineValueTableName = "VALUE";
    public String defineResult1TableName = "RESULT1";
    public String defineResult2TableName = "RESULT2";
    public String defineDictionaryTableName = "DICTIONARY";
    public String defineCodelistTableName = "CODELIST";
    public String valueDelimiter = ";";
    public String defineOdmVersion = "1.3.2";
    public String defineFileType = "Snapshot";
    public static final String PROPERTIES_PATH = "./properties/main.properties";
    public DataSourceType dataSourceType = DataSourceType.EXCEL;
    public RunMode runMode;
    public OidMode oidMode = OidMode.EXACT;
    public String d2eDefineVersion = "2.0.0";
    public String d2eDatasetType = "SDTM";
    public boolean d2eSeparateSheet = false;
    public boolean d2eMergeNSVtoParent = true;
    public String schema1SourceLocation = "./schema/hard/cdisc-define-2.0/define2-0-0.xsd";
    public String schema2SourceLocation = "./schema/soft/cdisc-define-2.0/define2-0-0.xsd";
    public String d2eDataSourceLocation;
    public String d2eOutputLocation;
    public String x2hXmlLocation;
    public String x2hXslLocation;
    public String x2hOutputLocation;
    public String e2oOdmVersion = "1.3.2";
    public String e2oXmlEncoding = "UTF-8";
    public String e2oStylesheetLocation;
    public String e2oDataSourceLocation;
    public String e2oOutputLocation;
    public String odmStudyTableName = "STUDY";
    public String odmUnitTableName = "UNIT";
    public String odmEventTableName = "EVENT";
    public String odmEventFormTableName = "EVENTxFORM";
    public String odmFormTableName = "FORM";
    public String odmFieldTableName = "FIELD";
    public String odmCodelistTableName = "CODELIST";
    public String odmMethodTableName = "METHOD";
    public String odmConditionTableName = "CONDITION";
    public String o2eOdmVersion = "1.3.2";
    public String o2eOdmLocation;
    public String o2eOutputLocation;
    public String crfArchitectLocation;
    public String[] crfSourceFiles;
    public String crfHeaderCnt;
    public String crfHeaderRow;
    public String crfEncoding = "UTF-8";
    public String crfDelimiter;
    public String crfTextQualifier = "\"";
    public String crfOutputLocation;
    public String edtType = "Test Results (LAB Normalized)";
    public String edtHeaderCnt;
    public String edtHeaderRow;
    public String edtEncoding = "UTF-8";
    public String edtDelimitedOrFixed = "Delimited";
    public String edtDelimiter;
    public String edtTextQualifier = "\"";
    public String edtDataSourceLocation;
    public String edtOutputLocation;
    public String edtGeneralTableName = "GENERAL";
    public String edtColumnTableName = "COLUMN";
    public String edtCodelistTableName = "CODELIST";
    public String validateXmlLocation;
    public String validateSchemaLocation;

    public Config() {
    }

    public Config(Properties prop) {
        try {
            this.initConfig(prop);
        }
        catch (IllegalArgumentException ex) {
            logger.error(ex.getMessage());
            logger.error("Exiting the program...");
            System.exit(-1);
        }
    }

    private void initConfig(Properties prop) throws IllegalArgumentException {
        if (!prop.getProperty("e2dDefineVersion", "").equals("")) {
            this.e2dDefineVersion = prop.getProperty("e2dDefineVersion");
        }
        if (!prop.getProperty("e2dDatasetType", "").equals("")) {
            this.e2dDatasetType = DatasetType.valueOf(prop.getProperty("e2dDatasetType"));
        }
        if (!prop.getProperty("e2dXmlEncoding", "").equals("")) {
            this.e2dXmlEncoding = prop.getProperty("e2dXmlEncoding");
        }
        if (!prop.getProperty("e2dStylesheetLocation", "").equals("")) {
            this.e2dStylesheetLocation = prop.getProperty("e2dStylesheetLocation");
        }
        if (!prop.getProperty("e2dDataSourceLocation", "").equals("")) {
            this.e2dDataSourceLocation = prop.getProperty("e2dDataSourceLocation");
        }
        if (!prop.getProperty("e2dOutputLocation", "").equals("")) {
            this.e2dOutputLocation = prop.getProperty("e2dOutputLocation");
        }
        if (prop.getProperty("e2dIncludeResultMetadata", "").toUpperCase().equals("TRUE")) {
            this.e2dIncludeResultMetadata = true;
        }
        if (!prop.getProperty("defineStudyTableName", "").equals("")) {
            this.defineStudyTableName = prop.getProperty("defineStudyTableName");
        }
        if (!prop.getProperty("defineMethodTableName", "").equals("")) {
            this.defineMethodTableName = prop.getProperty("defineMethodTableName");
        }
        if (!prop.getProperty("defineCommentTableName", "").equals("")) {
            this.defineCommentTableName = prop.getProperty("defineCommentTableName");
        }
        if (!prop.getProperty("defineStandardTableName", "").equals("")) {
            this.defineStandardTableName = prop.getProperty("defineStandardTableName");
        }
        if (!prop.getProperty("defineDocumentTableName", "").equals("")) {
            this.defineDocumentTableName = prop.getProperty("defineDocumentTableName");
        }
        if (!prop.getProperty("defineDatasetTableName", "").equals("")) {
            this.defineDatasetTableName = prop.getProperty("defineDatasetTableName");
        }
        if (!prop.getProperty("defineVariableTableName", "").equals("")) {
            this.defineVariableTableName = prop.getProperty("defineVariableTableName");
        }
        if (!prop.getProperty("defineValueTableName", "").equals("")) {
            this.defineValueTableName = prop.getProperty("defineValueTableName");
        }
        if (!prop.getProperty("defineResult1TableName", "").equals("")) {
            this.defineResult1TableName = prop.getProperty("defineResult1TableName");
        }
        if (!prop.getProperty("defineResult2TableName", "").equals("")) {
            this.defineResult2TableName = prop.getProperty("defineResult2TableName");
        }
        if (!prop.getProperty("defineDictionaryTableName", "").equals("")) {
            this.defineDictionaryTableName = prop.getProperty("defineDictionaryTableName");
        }
        if (!prop.getProperty("defineCodelistTableName", "").equals("")) {
            this.defineCodelistTableName = prop.getProperty("defineCodelistTableName");
        }
        if (!prop.getProperty("valueDelimiter", "").equals("")) {
            this.valueDelimiter = prop.getProperty("valueDelimiter");
        }
        if (!prop.getProperty("d2eDefineVersion", "").equals("")) {
            this.d2eDefineVersion = prop.getProperty("d2eDefineVersion");
        }
        if (!prop.getProperty("d2eDatasetType", "").equals("")) {
            this.d2eDatasetType = prop.getProperty("d2eDatasetType");
        }
        this.d2eSeparateSheet = prop.getProperty("d2eSeparateSheet", "").toUpperCase().equals("TRUE");
        this.d2eMergeNSVtoParent = prop.getProperty("d2eMergeNSVtoParent", "").toUpperCase().equals("TRUE");
        if (!prop.getProperty("d2eDataSourceLocation", "").equals("")) {
            this.d2eDataSourceLocation = prop.getProperty("d2eDataSourceLocation");
        }
        if (!prop.getProperty("d2eOutputLocation", "").equals("")) {
            this.d2eOutputLocation = prop.getProperty("d2eOutputLocation");
        }
        if (!prop.getProperty("x2hXmlLocation", "").equals("")) {
            this.x2hXmlLocation = prop.getProperty("x2hXmlLocation");
        }
        if (!prop.getProperty("x2hXslLocation", "").equals("")) {
            this.x2hXslLocation = prop.getProperty("x2hXslLocation");
        }
        if (!prop.getProperty("x2hOutputLocation", "").equals("")) {
            this.x2hOutputLocation = prop.getProperty("x2hOutputLocation");
        }
        if (!prop.getProperty("e2oOdmVersion", "").equals("")) {
            this.e2oOdmVersion = prop.getProperty("e2oOdmVersion");
        }
        if (!prop.getProperty("e2oXmlEncoding", "").equals("")) {
            this.e2oXmlEncoding = prop.getProperty("e2oXmlEncoding");
        }
        if (!prop.getProperty("e2oStylesheetLocation", "").equals("")) {
            this.e2oStylesheetLocation = prop.getProperty("e2oStylesheetLocation");
        }
        if (!prop.getProperty("e2oDataSourceLocation", "").equals("")) {
            this.e2oDataSourceLocation = prop.getProperty("e2oDataSourceLocation");
        }
        if (!prop.getProperty("e2oOutputLocation", "").equals("")) {
            this.e2oOutputLocation = prop.getProperty("e2oOutputLocation");
        }
        if (!prop.getProperty("odmStudyTableName", "").equals("")) {
            this.odmStudyTableName = prop.getProperty("odmStudyTableName");
        }
        if (!prop.getProperty("odmUnitTableName", "").equals("")) {
            this.odmUnitTableName = prop.getProperty("odmUnitTableName");
        }
        if (!prop.getProperty("odmEventTableName", "").equals("")) {
            this.odmEventTableName = prop.getProperty("odmEventTableName");
        }
        if (!prop.getProperty("odmEventFormTableName", "").equals("")) {
            this.odmEventFormTableName = prop.getProperty("odmEventFormTableName");
        }
        if (!prop.getProperty("odmFormTableName", "").equals("")) {
            this.odmFormTableName = prop.getProperty("odmFormTableName");
        }
        if (!prop.getProperty("odmFieldTableName", "").equals("")) {
            this.odmFieldTableName = prop.getProperty("odmFieldTableName");
        }
        if (!prop.getProperty("odmCodelistTableName", "").equals("")) {
            this.odmCodelistTableName = prop.getProperty("odmCodelistTableName");
        }
        if (!prop.getProperty("odmMethodTableName", "").equals("")) {
            this.odmMethodTableName = prop.getProperty("odmMethodTableName");
        }
        if (!prop.getProperty("oidMode", "").equals("")) {
            this.oidMode = OidMode.valueOf(prop.getProperty("oidMode"));
        }
        if (!prop.getProperty("o2eOdmVersion", "").equals("")) {
            this.o2eOdmVersion = prop.getProperty("o2eOdmVersion");
        }
        if (!prop.getProperty("o2eOdmLocation", "").equals("")) {
            this.o2eOdmLocation = prop.getProperty("o2eOdmLocation");
        }
        if (!prop.getProperty("o2eOutputLocation", "").equals("")) {
            this.o2eOutputLocation = prop.getProperty("o2eOutputLocation");
        }
        if (!prop.getProperty("crfArchitectLocation", "").equals("")) {
            this.crfArchitectLocation = prop.getProperty("crfArchitectLocation");
        }
        if (!prop.getProperty("crfSourceFiles", "").equals("")) {
            String tmpCrfSourceFiles = prop.getProperty("crfSourceFiles");
            this.crfSourceFiles = tmpCrfSourceFiles.split("\\|");
        }
        if (!prop.getProperty("crfHeaderCnt", "").equals("")) {
            this.crfHeaderCnt = prop.getProperty("crfHeaderCnt");
        }
        if (!prop.getProperty("crfHeaderRow", "").equals("")) {
            this.crfHeaderRow = prop.getProperty("crfHeaderRow");
        }
        if (!prop.getProperty("crfEncoding", "").equals("")) {
            this.crfEncoding = prop.getProperty("crfEncoding");
        }
        if (!prop.getProperty("crfDelimiter", "").equals("")) {
            this.crfDelimiter = prop.getProperty("crfDelimiter");
        }
        if (!prop.getProperty("crfTextQualifier", "").equals("")) {
            this.crfTextQualifier = prop.getProperty("crfTextQualifier");
        }
        if (!prop.getProperty("crfOutputLocation", "").equals("")) {
            this.crfOutputLocation = prop.getProperty("crfOutputLocation");
        }
        if (!prop.getProperty("edtType", "").equals("")) {
            this.edtType = prop.getProperty("edtType");
        }
        if (!prop.getProperty("edtHeaderCnt", "").equals("")) {
            this.edtHeaderCnt = prop.getProperty("edtHeaderCnt");
        }
        if (!prop.getProperty("edtHeaderRow", "").equals("")) {
            this.edtHeaderRow = prop.getProperty("edtHeaderRow");
        }
        if (!prop.getProperty("edtEncoding", "").equals("")) {
            this.edtEncoding = prop.getProperty("edtEncoding");
        }
        if (!prop.getProperty("edtDelimitedOrFixed", "").equals("")) {
            this.edtDelimitedOrFixed = prop.getProperty("edtDelimitedOrFixed");
        }
        if (!prop.getProperty("edtDelimiter", "").equals("")) {
            this.edtDelimiter = prop.getProperty("edtDelimiter");
        }
        if (!prop.getProperty("edtTextQualifier", "").equals("")) {
            this.edtTextQualifier = prop.getProperty("edtTextQualifier");
        }
        if (!prop.getProperty("edtDataSourceLocation", "").equals("")) {
            this.edtDataSourceLocation = prop.getProperty("edtDataSourceLocation");
        }
        if (!prop.getProperty("edtOutputLocation", "").equals("")) {
            this.edtOutputLocation = prop.getProperty("edtOutputLocation");
        }
        if (!prop.getProperty("edtGeneralTableName", "").equals("")) {
            this.edtGeneralTableName = prop.getProperty("edtGeneralTableName");
        }
        if (!prop.getProperty("edtColumnTableName", "").equals("")) {
            this.edtColumnTableName = prop.getProperty("edtColumnTableName");
        }
        if (!prop.getProperty("edtCodelistTableName", "").equals("")) {
            this.edtCodelistTableName = prop.getProperty("edtCodelistTableName");
        }
        if (!prop.getProperty("validateXmlLocation", "").equals("")) {
            this.validateXmlLocation = prop.getProperty("validateXmlLocation");
        }
        if (!prop.getProperty("validateSchemaLocation", "").equals("")) {
            this.validateSchemaLocation = prop.getProperty("validateSchemaLocation");
        }
    }

    public static enum OidMode {
        NATIVE,
        EXACT;

    }

    public static enum RunMode {
        CLI,
        GUI,
        API;

    }

    public static enum DataSourceType {
        EXCEL;

    }

    public static enum DatasetType {
        SDTM,
        ADaM,
        SEND;


        public static String[] stringValues() {
            return (String[])Stream.of(DatasetType.values()).map(Enum::name).toArray(String[]::new);
        }
    }
}

