/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.exporter;

import com.fujitsu.tsc.desktop.exporter.ExcelReader;
import com.fujitsu.tsc.desktop.exporter.InvalidOidSyntaxException;
import com.fujitsu.tsc.desktop.exporter.RequiredValueMissingException;
import com.fujitsu.tsc.desktop.exporter.TableNotFoundException;
import com.fujitsu.tsc.desktop.exporter.WhereClause;
import com.fujitsu.tsc.desktop.exporter.XmlGenerator;
import com.fujitsu.tsc.desktop.util.Config;
import com.fujitsu.tsc.desktop.util.InvalidParameterException;
import com.fujitsu.tsc.desktop.util.MetaDataReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class OdmXmlWriter {
    private static Logger logger;
    private Config config;
    private MetaDataReader reader;
    private OutputStreamWriter sw;
    private BufferedWriter writer;
    private String xmlEncoding;
    private String stylesheetLocation;
    private Config.OidMode oidMode;
    private String sourceSystem = "";
    private int indent;
    private final String DELIMITER;
    private final String DEFAULTLANG = "en";
    private Hashtable<String, String> formNameMandatoryHash = new Hashtable();
    private Hashtable<String, String> formNameRepeatingHash = new Hashtable();
    private ErrorHint errHint = new ErrorHint();

    public OdmXmlWriter(Config config) throws InvalidParameterException, TableNotFoundException, InvalidParameterException, RequiredValueMissingException, InvalidFormatException, IOException {
        logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
        this.config = config;
        this.DELIMITER = config.valueDelimiter;
        try {
            if (!this.config.dataSourceType.name().equals("EXCEL")) {
                throw new InvalidParameterException("dataSourceType", this.config.dataSourceType.name());
            }
            this.reader = new ExcelReader(this.config.e2oDataSourceLocation, this.config.odmFormTableName);
            this.xmlEncoding = this.config.e2oXmlEncoding;
            this.stylesheetLocation = this.config.e2oStylesheetLocation;
            this.oidMode = this.config.oidMode;
            this.sw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.config.e2oOutputLocation, false), this.xmlEncoding);
            this.writer = new BufferedWriter(this.sw);
            this.indent = 0;
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeXMLHeader() throws IOException, RequiredValueMissingException {
        this.errHint.setErrorHint(OdmTagType.XMLHEADER, "", "", "", "", "");
        try {
            String str = "<?xml version=\"1.0\" encoding=\"" + this.xmlEncoding + "\"?>";
            this.writer.write(str);
            this.writer.newLine();
            if (this.stylesheetLocation != null && !this.stylesheetLocation.equals("")) {
                str = "<?xml-stylesheet type=\"text/xsl\" href=\"" + this.stylesheetLocation + "\"?>";
                this.writer.write(str);
                this.writer.newLine();
            }
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeStudySection() throws TableNotFoundException, IOException, RequiredValueMissingException {
        this.errHint.setErrorHint(OdmTagType.STUDY, "", "", "", "", "");
        try {
            Hashtable<String, String> hashNormalized;
            this.reader.setTable(this.config.odmStudyTableName);
            Hashtable<String, String> hash = new Hashtable<String, String>();
            while ((hashNormalized = this.reader.read()) != null) {
                hash.put(hashNormalized.get("Property Name"), hashNormalized.get("Property Value"));
            }
            this.sourceSystem = (String)hash.get("Source System");
            Calendar cal = Calendar.getInstance();
            String str = OdmXmlWriter.insertIndent(this.indent);
            str = str + "<ODM xmlns=\"http://www.cdisc.org/ns/odm/v1.3\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"" + (StringUtils.isNotEmpty((CharSequence)this.sourceSystem) ? " xmlns:ddedcp=\"http://www.fujitsu.com/ddedcp/odm\"" : "") + " ODMVersion=\"" + (((String)hash.get("ODMVersion")).equals("") ? this.config.e2oOdmVersion : (String)hash.get("ODMVersion")) + "\" FileOID=\"" + (((String)hash.get("FileOID")).equals("") ? UUID.randomUUID().toString() : (String)hash.get("FileOID")) + "\" FileType=\"" + (((String)hash.get("FileType")).equals("") ? this.config.defineFileType : (String)hash.get("FileType")) + "\" CreationDateTime=\"" + cal.get(1) + "-" + OdmXmlWriter.twoDigits(cal.get(2) + 1) + "-" + OdmXmlWriter.twoDigits(cal.get(5)) + "T" + OdmXmlWriter.twoDigits(cal.get(11)) + ":" + OdmXmlWriter.twoDigits(cal.get(12)) + ":" + OdmXmlWriter.twoDigits(cal.get(13)) + (((String)hash.get("AsOfDateTime")).equals("") ? "" : "\" AsOfDateTime=\"" + (String)hash.get("AsOfDateTime")) + (((String)hash.get("Originator")).equals("") ? "" : "\" Originator=\"" + (String)hash.get("Originator")) + "\" SourceSystem=\"" + Config.SOFTWARE_NAME + "\" SourceSystemVersion=\"" + Config.SOFTWARE_VERSION + (StringUtils.isNotEmpty((CharSequence)this.sourceSystem) ? "\" ddedcp:SourceDataFrom=\"" + this.sourceSystem : "") + "\">";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = OdmXmlWriter.insertIndent(this.indent);
            str = str + "<Study OID=\"" + (((String)hash.get("StudyOID")).equals("") ? UUID.randomUUID().toString() : (String)hash.get("StudyOID")) + "\">";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = OdmXmlWriter.insertIndent(this.indent);
            str = str + "<GlobalVariables>";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            str = OdmXmlWriter.insertIndent(this.indent);
            str = str + "<StudyName>" + (String)hash.get("StudyName") + "</StudyName>";
            this.writer.write(str);
            this.writer.newLine();
            str = OdmXmlWriter.insertIndent(this.indent);
            str = str + "<StudyDescription>" + XmlGenerator.escapeString((String)hash.get("StudyDescription")) + "</StudyDescription>";
            this.writer.write(str);
            this.writer.newLine();
            str = OdmXmlWriter.insertIndent(this.indent);
            str = str + "<ProtocolName>" + (String)hash.get("ProtocolName") + "</ProtocolName>";
            this.writer.write(str);
            this.writer.newLine();
            --this.indent;
            str = OdmXmlWriter.insertIndent(this.indent);
            str = str + "</GlobalVariables>";
            this.writer.write(str);
            this.writer.newLine();
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeUnitSection() throws TableNotFoundException, IOException, RequiredValueMissingException, InvalidOidSyntaxException {
        this.errHint.setErrorHint(OdmTagType.MEASUREMENTUNIT, "", "", "", "", "");
        try {
            this.reader.setTable(this.config.odmUnitTableName);
            Hashtable<Object, Object> hash = new Hashtable();
            boolean isSheetStart = true;
            boolean isUnitStart = true;
            String prevUnitName = null;
            int unitNumber = 0;
            String str = null;
            while ((hash = this.reader.read()) != null) {
                if (prevUnitName != null) {
                    isUnitStart = !prevUnitName.equals(hash.get("Name"));
                }
                prevUnitName = (String)hash.get("Name");
                this.errHint.setErrorHint(OdmTagType.MEASUREMENTUNIT, "", "", "", "", (String)hash.get("Name"));
                if (isSheetStart) {
                    ++unitNumber;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<BasicDefinitions>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<MeasurementUnit OID=\"" + this.createOID(OdmTagType.MEASUREMENTUNIT, "", "", "", "", (String)hash.get("ID")) + "\" Name=\"" + (String)hash.get("Name") + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<Symbol>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                }
                if (isUnitStart && !isSheetStart) {
                    ++unitNumber;
                    --this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "</Symbol>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "</MeasurementUnit>";
                    this.writer.write(str);
                    this.writer.newLine();
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<MeasurementUnit OID=\"" + this.createOID(OdmTagType.MEASUREMENTUNIT, "", "", "", "", (String)hash.get("ID")) + "\" Name=\"" + (String)hash.get("Name") + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<Symbol>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                }
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "<TranslatedText" + (StringUtils.isEmpty((CharSequence)((CharSequence)hash.get("xml:lang"))) ? "" : " xml:lang=\"" + (String)hash.get("xml:lang") + "\"") + ">" + XmlGenerator.escapeString((String)hash.get("Symbol")) + "</TranslatedText>";
                this.writer.write(str);
                this.writer.newLine();
                if (!isSheetStart) continue;
                isSheetStart = false;
            }
            if (unitNumber > 0) {
                --this.indent;
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "</Symbol>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "</MeasurementUnit>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "</BasicDefinitions>";
                this.writer.write(str);
                this.writer.newLine();
            }
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeProtocolSection() throws TableNotFoundException, IOException, RequiredValueMissingException, InvalidOidSyntaxException {
        try {
            Hashtable<String, String> hashNormalized;
            this.errHint.setErrorHint(OdmTagType.PROTOCOL, "", "", "", "", "");
            this.reader.setTable(this.config.odmStudyTableName);
            Hashtable<Object, Object> hash = new Hashtable<String, String>();
            while ((hashNormalized = this.reader.read()) != null) {
                hash.put(hashNormalized.get("Property Name"), hashNormalized.get("Property Value"));
            }
            String str = OdmXmlWriter.insertIndent(this.indent);
            str = str + "<MetaDataVersion OID=\"" + (((String)hash.get("MetaDataOID")).equals("") ? UUID.randomUUID().toString() : (String)hash.get("MetaDataOID")) + "\" Name=\"" + (String)hash.get("MetaDataName") + "\" Description=\"" + (String)hash.get("MetaDataDescription") + "\">";
            this.writer.write(str);
            this.writer.newLine();
            ++this.indent;
            String protocolDescription = XmlGenerator.escapeString((String)hash.get("ProtocolDescription"));
            String protocolDescriptionLang = (String)hash.get("ProtocolDescription xml:lang");
            if (protocolDescription != null && !protocolDescription.equals("")) {
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "<Protocol>";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "<Description>";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "<TranslatedText" + (StringUtils.isEmpty((CharSequence)protocolDescriptionLang) ? "" : " xml:lang=\"" + protocolDescriptionLang + "\"") + ">" + XmlGenerator.escapeString(protocolDescription) + "</TranslatedText>";
                this.writer.write(str);
                this.writer.newLine();
                --this.indent;
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "</Description>";
                this.writer.write(str);
                this.writer.newLine();
            }
            this.reader.setTable(this.config.odmEventTableName);
            int i = 1;
            while ((hash = this.reader.read()) != null) {
                this.errHint.setErrorHint(OdmTagType.STUDYEVENTREF, (String)hash.get("Name"), "", "", "", "");
                if (i == 1 && (protocolDescription == null || protocolDescription.equals(""))) {
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<Protocol>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                }
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "<StudyEventRef StudyEventOID=\"" + this.createOID(OdmTagType.STUDYEVENTREF, (String)hash.get("ID"), "", "", "", "") + "\" OrderNumber=\"" + i++ + "\" Mandatory=\"" + (String)hash.get("Mandatory") + (((String)hash.get("CollectionExceptionCondition")).equals("") ? "" : "\" CollectionExceptionConditionOID=\"" + this.createOID(OdmTagType.CONDITIONDEF, "", "", "", "", (String)hash.get("CollectionExceptionCondition"))) + "\"/>";
                this.writer.write(str);
                this.writer.newLine();
            }
            if (i != 1 || protocolDescription != null && !protocolDescription.equals("")) {
                --this.indent;
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "</Protocol>";
                this.writer.write(str);
                this.writer.newLine();
            }
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeEventDefSection() throws TableNotFoundException, IOException, RequiredValueMissingException, InvalidOidSyntaxException {
        this.errHint.setErrorHint(OdmTagType.STUDYEVENTDEF, "", "", "", "", "");
        try {
            Hashtable<Object, Object> hash = new Hashtable();
            Hashtable<Object, Object> hash2 = new Hashtable();
            Hashtable<Object, Object> formNameIdHash = new Hashtable<Object, Object>();
            String str = new String();
            int order = 1;
            this.reader.setTable(this.config.odmFormTableName);
            while ((hash = this.reader.read(this.config.odmFormTableName)) != null) {
                this.errHint.setErrorHint(OdmTagType.FORMDEF, "", (String)hash.get("Name"), "", "", "");
                formNameIdHash.put(hash.get("Name"), hash.get("ID"));
            }
            this.reader.setTable(this.config.odmEventTableName);
            while ((hash = this.reader.read(this.config.odmEventTableName)) != null) {
                this.errHint.setErrorHint(OdmTagType.STUDYEVENTDEF, (String)hash.get("Name"), "", "", "", "");
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "<StudyEventDef OID=\"" + this.createOID(OdmTagType.STUDYEVENTDEF, (String)hash.get("ID"), "", "", "", "") + "\" Name=\"" + (String)hash.get("Name") + "\" Repeating=\"" + (String)hash.get("Repeating") + "\" Type=\"" + (String)hash.get("Type") + (((String)hash.get("Category")).equals("") ? "" : "\" Category=\"" + (String)hash.get("Category")) + "\">";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                if (hash.get("Description") != null && !((String)hash.get("Description")).equals("")) {
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<TranslatedText" + (StringUtils.isEmpty((CharSequence)((CharSequence)hash.get("xml:lang"))) ? "" : " xml:lang=\"" + (String)hash.get("xml:lang") + "\"") + ">" + XmlGenerator.escapeString((String)hash.get("Description")) + "</TranslatedText>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "</Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
                this.reader.setTable(this.config.odmEventFormTableName, new WhereClause[]{new WhereClause("Event Name", WhereClause.Operator.EQ, (String)hash.get("Name"))});
                while ((hash2 = this.reader.read(this.config.odmEventFormTableName)) != null) {
                    this.errHint.setErrorHint(OdmTagType.FORMREF, (String)hash2.get("Event Name"), (String)hash2.get("Form Name"), "", "", "");
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<FormRef FormOID=\"" + this.createOID(OdmTagType.FORMREF, "", (String)formNameIdHash.get(hash2.get("Form Name")), "", "", "") + "\" OrderNumber=\"" + order++ + "\" Mandatory=\"" + (String)hash2.get("Mandatory") + (((String)hash2.get("CollectionExceptionCondition")).equals("") ? "" : "\" CollectionExceptionConditionOID=\"" + this.createOID(OdmTagType.CONDITIONDEF, "", "", "", "", (String)hash2.get("CollectionExceptionCondition"))) + "\"/>";
                    this.writer.write(str);
                    this.writer.newLine();
                    this.formNameMandatoryHash.put((String)hash2.get("Form Name"), (String)hash2.get("Mandatory"));
                }
                if (hash.get("Alias Name") != null && !((String)hash.get("Alias Name")).equals("")) {
                    String[] strAliasName = ((String)hash.get("Alias Name")).split(this.DELIMITER);
                    String[] strAliasContext = ((String)hash.get("Alias Context")).split(this.DELIMITER);
                    for (int i2 = 0; i2 < strAliasName.length; ++i2) {
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "<Alias Context=\"" + strAliasContext[i2].trim() + "\" Name=\"" + strAliasName[i2].trim() + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                }
                --this.indent;
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "</StudyEventDef>";
                this.writer.write(str);
                this.writer.newLine();
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
            throw new RequiredValueMissingException(ex, this.errHint);
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeFormDefSection() throws TableNotFoundException, IOException, RequiredValueMissingException, InvalidOidSyntaxException {
        try {
            this.errHint.setErrorHint(OdmTagType.FORMDEF, "", "", "", "", "");
            Hashtable<Object, Object> hash = new Hashtable();
            Hashtable<Object, Object> hash2 = new Hashtable();
            String str = new String();
            this.reader.setTable(this.config.odmFormTableName);
            while ((hash = this.reader.read(this.config.odmFormTableName)) != null) {
                this.errHint.setErrorHint(OdmTagType.FORMDEF, "", (String)hash.get("Name"), "", "", "");
                String isRepeating = (String)hash.get("Repeating");
                if (StringUtils.isEmpty((CharSequence)isRepeating)) {
                    isRepeating = "No";
                }
                this.formNameRepeatingHash.put((String)hash.get("Name"), isRepeating);
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "<FormDef OID=\"" + this.createOID(OdmTagType.FORMDEF, "", (String)hash.get("ID"), "", "", "") + "\" Name=\"" + XmlGenerator.escapeString((String)hash.get("Name")) + "\" Repeating=\"" + isRepeating + "\">";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                if (hash.get("Description") != null && !((String)hash.get("Description")).equals("")) {
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<TranslatedText" + (StringUtils.isEmpty((CharSequence)((CharSequence)hash.get("xml:lang"))) ? "" : " xml:lang=\"" + (String)hash.get("xml:lang") + "\"") + ">" + XmlGenerator.escapeString((String)hash.get("Description")) + "</TranslatedText>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "</Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
                this.reader.setTable(this.config.odmFieldTableName, new WhereClause[]{new WhereClause("Form Name", WhereClause.Operator.EQ, (String)hash.get("Name"))});
                int i = 1;
                int itemGroupNumber = 0;
                while ((hash2 = this.reader.read(this.config.odmFieldTableName)) != null) {
                    this.errHint.setErrorHint(OdmTagType.ITEMGROUPREF, "", (String)hash2.get("Form Name"), (String)hash2.get("Item Name"), "", "");
                    if (((String)hash2.get("Level")).equals("1")) {
                        String conditionId = (String)hash2.get("Condition ID");
                        if (StringUtils.isEmpty((CharSequence)conditionId)) {
                            conditionId = (String)hash2.get("CollectionExceptionCondition");
                        }
                        ++itemGroupNumber;
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "<ItemGroupRef ItemGroupOID=\"" + this.createOID(OdmTagType.ITEMGROUPREF, "", "", (String)hash2.get("ID"), "", "") + "\" OrderNumber=\"" + i++ + "\" Mandatory=\"" + (String)hash2.get("Mandatory") + (StringUtils.isEmpty((CharSequence)conditionId) ? "" : "\" CollectionExceptionConditionOID=\"" + this.createOID(OdmTagType.CONDITIONDEF, "", "", "", "", conditionId)) + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                        continue;
                    }
                    if (itemGroupNumber != 0) continue;
                    String mandatory = this.formNameMandatoryHash.get(hash2.get("Form Name"));
                    if (StringUtils.isEmpty((CharSequence)mandatory)) {
                        mandatory = "No";
                    }
                    ++itemGroupNumber;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<ItemGroupRef ItemGroupOID=\"" + this.createOID(OdmTagType.ITEMGROUPDEF, "", "", this.createOID(OdmTagType.FORMDEF, "", (String)hash.get("ID"), "", "", ""), "", "") + "\" OrderNumber=\"" + i++ + "\" Mandatory=\"" + mandatory + "\"/>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
                if (hash.get("PdfFileName") != null && !((String)hash.get("PdfFileName")).equals("")) {
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<ArchiveLayout OID=\"" + this.createOID(OdmTagType.ARCHIVELAYOUT, "", "", "", "", (String)hash.get("PdfFileName")) + "\" PdfFileName=\"" + (String)hash.get("PdfFileName") + "\"/>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
                if (hash.get("Alias Name") != null && !((String)hash.get("Alias Name")).equals("")) {
                    String[] strAliasName = ((String)hash.get("Alias Name")).split(this.DELIMITER);
                    String[] strAliasContext = ((String)hash.get("Alias Context")).split(this.DELIMITER);
                    for (int i2 = 0; i2 < strAliasName.length; ++i2) {
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "<Alias Context=\"" + strAliasContext[i2].trim() + "\" Name=\"" + strAliasName[i2].trim() + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                }
                --this.indent;
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "</FormDef>";
                this.writer.write(str);
                this.writer.newLine();
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeItemGroupDefSection() throws TableNotFoundException, IOException, RequiredValueMissingException, InvalidOidSyntaxException {
        try {
            int i2;
            Hashtable<Object, Object> hash = new Hashtable();
            Hashtable<Object, Object> formNameIdHash = new Hashtable<Object, Object>();
            String str = new String();
            boolean isSheetStart = true;
            boolean isFormStart = true;
            String prevFormName = null;
            int itemGroupNumber = 0;
            int orderNumber = 1;
            String[] strAliasName = null;
            String[] strAliasContext = null;
            this.reader.setTable(this.config.odmFormTableName);
            while ((hash = this.reader.read(this.config.odmFormTableName)) != null) {
                formNameIdHash.put(hash.get("Name"), hash.get("ID"));
            }
            this.reader.setTable(this.config.odmFieldTableName);
            while ((hash = this.reader.read(this.config.odmFieldTableName)) != null) {
                String conditionId;
                if (prevFormName != null) {
                    if (prevFormName.equals(hash.get("Form Name"))) {
                        isFormStart = false;
                    } else {
                        isFormStart = true;
                        itemGroupNumber = 0;
                    }
                }
                prevFormName = (String)hash.get("Form Name");
                if (((String)hash.get("Level")).equals("1")) {
                    this.errHint.setErrorHint(OdmTagType.ITEMGROUPDEF, "", "", (String)hash.get("Item Name"), "", "");
                    ++itemGroupNumber;
                    if (!isSheetStart) {
                        if (strAliasName[0] != null && !strAliasName[0].equals("")) {
                            for (i2 = 0; i2 < strAliasName.length; ++i2) {
                                str = OdmXmlWriter.insertIndent(this.indent);
                                str = str + "<Alias Context=\"" + strAliasContext[i2].trim() + "\" Name=\"" + strAliasName[i2].trim() + "\"/>";
                                this.writer.write(str);
                                this.writer.newLine();
                            }
                        }
                        --this.indent;
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "</ItemGroupDef>";
                        this.writer.write(str);
                        this.writer.newLine();
                        strAliasName = null;
                        strAliasContext = null;
                    } else {
                        isSheetStart = false;
                    }
                    orderNumber = 1;
                    strAliasContext = ((String)hash.get("Alias Context")).split(this.DELIMITER);
                    strAliasName = ((String)hash.get("Alias Name")).split(this.DELIMITER);
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<ItemGroupDef OID=\"" + this.createOID(OdmTagType.ITEMGROUPDEF, "", "", (String)hash.get("ID"), "", "") + "\" Name=\"" + (String)hash.get("Item Name") + "\" Repeating=\"" + (String)hash.get("Repeating") + (((String)hash.get("IsReferenceData")).equals("") ? "" : "\" IsReferenceData=\"" + (String)hash.get("IsReferenceData")) + (((String)hash.get("SAS Name")).equals("") ? "" : "\" SASDatasetName=\"" + (String)hash.get("SAS Name")) + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    if (hash.get("Description") == null || ((String)hash.get("Description")).equals("")) continue;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<TranslatedText" + (StringUtils.isEmpty((CharSequence)((CharSequence)hash.get("Description xml:lang"))) ? "" : " xml:lang=\"" + (String)hash.get("Description xml:lang") + "\"") + ">" + XmlGenerator.escapeString((String)hash.get("Description")) + "</TranslatedText>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "</Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                    continue;
                }
                this.errHint.setErrorHint(OdmTagType.ITEMREF, "", "", "", (String)hash.get("Item Name"), "");
                if (isSheetStart) {
                    isSheetStart = false;
                    strAliasContext = ((String)hash.get("Alias Context")).split(this.DELIMITER);
                    strAliasName = ((String)hash.get("Alias Name")).split(this.DELIMITER);
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<ItemGroupDef OID=\"" + this.createOID(OdmTagType.ITEMGROUPDEF, "", "", this.createOID(OdmTagType.FORMDEF, "", (String)formNameIdHash.get(hash.get("Form Name")), "", "", ""), "", "") + "\" Name=\"DEFAULT_" + ++itemGroupNumber + "\" Repeating=\"" + this.formNameRepeatingHash.get(hash.get("Form Name")) + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                } else if (isFormStart) {
                    isFormStart = false;
                    if (strAliasName[0] != null && !strAliasName[0].equals("")) {
                        for (i2 = 0; i2 < strAliasName.length; ++i2) {
                            str = OdmXmlWriter.insertIndent(this.indent);
                            str = str + "<Alias Context=\"" + strAliasContext[i2].trim() + "\" Name=\"" + strAliasName[i2].trim() + "\"/>";
                            this.writer.write(str);
                            this.writer.newLine();
                        }
                    }
                    --this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "</ItemGroupDef>";
                    this.writer.write(str);
                    this.writer.newLine();
                    strAliasName = null;
                    strAliasContext = null;
                    orderNumber = 1;
                    strAliasContext = ((String)hash.get("Alias Context")).split(this.DELIMITER);
                    strAliasName = ((String)hash.get("Alias Name")).split(this.DELIMITER);
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<ItemGroupDef OID=\"" + this.createOID(OdmTagType.ITEMGROUPDEF, "", "", this.createOID(OdmTagType.FORMDEF, "", (String)formNameIdHash.get(hash.get("Form Name")), "", "", ""), "", "") + "\" Name=\"DEFAULT_" + ++itemGroupNumber + "\" Repeating=\"" + this.formNameRepeatingHash.get(hash.get("Form Name")) + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                }
                String methodId = (String)hash.get("Method ID");
                if (StringUtils.isEmpty((CharSequence)methodId)) {
                    methodId = (String)hash.get("Derivation");
                }
                if (StringUtils.isEmpty((CharSequence)(conditionId = (String)hash.get("Condition ID")))) {
                    conditionId = (String)hash.get("CollectionExceptionCondition");
                }
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "<ItemRef ItemOID=\"" + this.createOID(OdmTagType.ITEMREF, "", "", "", (String)hash.get("ID"), "") + "\" OrderNumber=\"" + orderNumber++ + "\" Mandatory=\"" + (String)hash.get("Mandatory") + (((String)hash.get("Key Sequence")).equals("") ? "" : "\" KeySequence=\"" + (String)hash.get("Key Sequence")) + (StringUtils.isEmpty((CharSequence)methodId) ? "" : "\" MethodOID=\"" + this.createOID(OdmTagType.METHODDEF, "", "", "", "", methodId)) + (StringUtils.isEmpty((CharSequence)conditionId) ? "" : "\" CollectionExceptionConditionOID=\"" + this.createOID(OdmTagType.CONDITIONDEF, "", "", "", "", conditionId)) + "\"/>";
                this.writer.write(str);
                this.writer.newLine();
            }
            if (itemGroupNumber > 0) {
                if (strAliasName[0] != null && !strAliasName[0].equals("")) {
                    for (i2 = 0; i2 < strAliasName.length; ++i2) {
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "<Alias Context=\"" + strAliasContext[i2].trim() + "\" Name=\"" + strAliasName[i2].trim() + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                }
                --this.indent;
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "</ItemGroupDef>";
                this.writer.write(str);
                this.writer.newLine();
                strAliasName = null;
                strAliasContext = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
            throw new RequiredValueMissingException(ex, this.errHint);
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeItemDefSection() throws TableNotFoundException, IOException, RequiredValueMissingException, InvalidOidSyntaxException {
        try {
            this.errHint.setErrorHint(OdmTagType.ITEMDEF, "", "", "", "", "");
            Hashtable<Object, Object> hash = new Hashtable();
            Hashtable<Object, Object> unitNameIdHash = new Hashtable<Object, Object>();
            String str = new String();
            this.reader.setTable(this.config.odmUnitTableName);
            while ((hash = this.reader.read(this.config.odmUnitTableName)) != null) {
                this.errHint.setErrorHint(OdmTagType.MEASUREMENTUNIT, "", (String)hash.get("Name"), "", "", "");
                unitNameIdHash.put(hash.get("Name"), hash.get("ID"));
            }
            this.reader.setTable(this.config.odmFieldTableName, new WhereClause[]{new WhereClause("Level", WhereClause.Operator.EQ, "0")});
            HashSet<String> itemOids = new HashSet<String>();
            while ((hash = this.reader.read(this.config.odmFieldTableName)) != null) {
                int i2;
                String[] strUnitName;
                this.errHint.setErrorHint(OdmTagType.ITEMDEF, "", "", "", (String)hash.get("Item Name"), "");
                String itemOid = this.createOID(OdmTagType.ITEMDEF, "", "", "", (String)hash.get("ID"), "");
                if (itemOids.contains(itemOid)) continue;
                itemOids.add(itemOid);
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "<ItemDef OID=\"" + itemOid + "\" Name=\"" + XmlGenerator.escapeString((String)hash.get("Item Name")) + "\" DataType=\"" + (String)hash.get("DataType") + (((String)hash.get("Length")).equals("") ? "" : "\" Length=\"" + (String)hash.get("Length")) + (((String)hash.get("SignificantDigits")).equals("") ? "" : "\" SignificantDigits=\"" + (String)hash.get("SignificantDigits")) + (((String)hash.get("SAS Name")).equals("") ? "" : "\" SASFieldName=\"" + (String)hash.get("SAS Name")) + (StringUtils.isEmpty((CharSequence)((CharSequence)hash.get("ControlType"))) ? "" : "\" ddedcp:InputFormatTyp=\"" + (String)hash.get("ControlType")) + (StringUtils.isEmpty((CharSequence)((CharSequence)hash.get("Section Label"))) ? "" : "\" ddedcp:SectionLabelStyle=\"2") + (StringUtils.isEmpty((CharSequence)((CharSequence)hash.get("Section Label"))) ? "" : "\" ddedcp:SectionLabel=\"" + XmlGenerator.escapeString((String)hash.get("Section Label"))) + "\">";
                this.writer.write(str);
                this.writer.newLine();
                ++this.indent;
                if (hash.get("Description") != null && !((String)hash.get("Description")).equals("")) {
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<TranslatedText" + (StringUtils.isEmpty((CharSequence)((CharSequence)hash.get("Description xml:lang"))) ? "" : " xml:lang=\"" + (String)hash.get("Description xml:lang") + "\"") + ">" + XmlGenerator.escapeString((String)hash.get("Description")) + "</TranslatedText>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "</Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
                if (hash.get("Question") != null && !((String)hash.get("Question")).equals("")) {
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<Question>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<TranslatedText" + (StringUtils.isEmpty((CharSequence)((CharSequence)hash.get("Question xml:lang"))) ? "" : " xml:lang=\"" + (String)hash.get("Question xml:lang") + "\"") + ">" + XmlGenerator.escapeString((String)hash.get("Question")) + "</TranslatedText>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "</Question>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
                if (hash.get("Unit Name") != null && !((String)hash.get("Unit Name")).equals("")) {
                    strUnitName = ((String)hash.get("Unit Name")).split(this.DELIMITER);
                    for (int i22 = 0; i22 < strUnitName.length; ++i22) {
                        this.errHint.setErrorHint(OdmTagType.ITEMDEF, "", "", "", (String)hash.get("Item Name"), strUnitName[i22].trim());
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "<MeasurementUnitRef MeasurementUnitOID=\"" + this.createOID(OdmTagType.MEASUREMENTUNIT, "", "", "", "", (String)unitNameIdHash.get(strUnitName[i22].trim())) + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                }
                this.errHint.setErrorHint(OdmTagType.ITEMDEF, "", "", "", (String)hash.get("Item Name"), "");
                if (hash.get("RangeCheck") != null && !((String)hash.get("RangeCheck")).equals("") || hash.get("Formal Expression") != null && !((String)hash.get("Formal Expression")).equals("")) {
                    if (hash.get("RangeCheck") != null && !((String)hash.get("RangeCheck")).equals("")) {
                        String[] strRangeCheck = ((String)hash.get("RangeCheck")).split(" ", 2);
                        String[] strCheckValue = strRangeCheck[1].split(this.DELIMITER);
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "<RangeCheck Comparator=\"" + strRangeCheck[0].trim() + "\" SoftHard=\"" + (String)hash.get("SoftHard") + "\">";
                        this.writer.write(str);
                        this.writer.newLine();
                        ++this.indent;
                        for (i2 = 0; i2 < strCheckValue.length; ++i2) {
                            str = OdmXmlWriter.insertIndent(this.indent);
                            str = str + "<CheckValue>" + strCheckValue[i2].trim() + "</CheckValue>";
                            this.writer.write(str);
                            this.writer.newLine();
                        }
                    } else {
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "<RangeCheck SoftHard=\"" + (String)hash.get("SoftHard") + "\">";
                        this.writer.write(str);
                        this.writer.newLine();
                        ++this.indent;
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "<FormalExpression Context=\"" + (String)hash.get("Formal Expression Context") + "\">" + XmlGenerator.escapeString((String)hash.get("Formal Expression")) + "</FormalExpression>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    if (hash.get("Unit Name") != null && !((String)hash.get("Unit Name")).equals("")) {
                        strUnitName = ((String)hash.get("Unit Name")).split(this.DELIMITER);
                        for (int i23 = 0; i23 < strUnitName.length; ++i23) {
                            this.errHint.setErrorHint(OdmTagType.ITEMDEF, "", "", "", (String)hash.get("Item Name"), strUnitName[i23].trim());
                            str = OdmXmlWriter.insertIndent(this.indent);
                            str = str + "<MeasurementUnitRef MeasurementUnitOID=\"" + this.createOID(OdmTagType.MEASUREMENTUNIT, "", "", "", "", (String)unitNameIdHash.get(strUnitName[i23].trim())) + "\"/>";
                            this.writer.write(str);
                            this.writer.newLine();
                        }
                    }
                    this.errHint.setErrorHint(OdmTagType.ITEMDEF, "", "", "", (String)hash.get("Item Name"), "");
                    if (hash.get("RangeCheck Error Message") != null && !((String)hash.get("RangeCheck Error Message")).equals("")) {
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "<ErrorMessage>";
                        this.writer.write(str);
                        this.writer.newLine();
                        ++this.indent;
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "<TranslatedText" + (StringUtils.isEmpty((CharSequence)((CharSequence)hash.get("Question xml:lang"))) ? "" : " xml:lang=\"" + (String)hash.get("Question xml:lang") + "\"") + ">" + XmlGenerator.escapeString((String)hash.get("RangeCheck Error Message")) + "</TranslatedText>";
                        this.writer.write(str);
                        this.writer.newLine();
                        --this.indent;
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "</ErrorMessage>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    --this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "</RangeCheck>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
                if (hash.get("Codelist") != null && !((String)hash.get("Codelist")).equals("")) {
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<CodeListRef CodeListOID=\"" + this.createOID(OdmTagType.CODELISTREF, "", "", "", "", (String)hash.get("Codelist")) + "\"/>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
                if (hash.get("Alias Name") != null && !((String)hash.get("Alias Name")).equals("")) {
                    String[] strAliasName = ((String)hash.get("Alias Name")).split(this.DELIMITER);
                    String[] strAliasContext = ((String)hash.get("Alias Context")).split(this.DELIMITER);
                    for (i2 = 0; i2 < strAliasName.length; ++i2) {
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "<Alias Context=\"" + strAliasContext[i2].trim() + "\" Name=\"" + strAliasName[i2].trim() + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                }
                --this.indent;
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "</ItemDef>";
                this.writer.write(str);
                this.writer.newLine();
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeCodelistSection() throws TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException {
        try {
            this.errHint.setErrorHint(OdmTagType.CODELIST, "", "", "", "", "");
            this.reader.setTable(this.config.odmCodelistTableName);
            Hashtable<Object, Object> hash = new Hashtable();
            String str = null;
            String prevCodelistID = null;
            String prevCodelistCode = null;
            boolean hasDecodeValue = false;
            while ((hash = this.reader.read(this.config.odmCodelistTableName)) != null) {
                int i2;
                String[] strAliasContext;
                String[] strAliasName;
                this.errHint.setErrorHint(OdmTagType.CODELIST, "", "", "", "", (String)hash.get("Codelist ID"));
                if (prevCodelistID == null || !prevCodelistID.equals(hash.get("Codelist ID"))) {
                    hasDecodeValue = hash.get("Translated Text") != null && !((String)hash.get("Translated Text")).equals("") || hash.get("Decode") != null && !((String)hash.get("Decode")).equals("");
                    if (prevCodelistID != null) {
                        if (prevCodelistCode != null && !prevCodelistCode.equals("")) {
                            str = OdmXmlWriter.insertIndent(this.indent);
                            str = str + "<Alias Name=\"" + prevCodelistCode + "\" Context=\"nci:ExtCodeID\"/>";
                            this.writer.write(str);
                            this.writer.newLine();
                        }
                        --this.indent;
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "</CodeList>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<CodeList OID=\"" + this.createOID(OdmTagType.CODELIST, "", "", "", "", (String)hash.get("Codelist ID")) + "\" Name=\"" + XmlGenerator.escapeString((String)hash.get("Codelist Label")) + "\" DataType=\"" + (String)hash.get("DataType") + (hash.get("SASFormatName") == null || ((String)hash.get("SASFormatName")).equals("") ? "" : "\" SASFormatName=\"" + (String)hash.get("SASFormatName")) + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                }
                if (!hasDecodeValue) {
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<EnumeratedItem CodedValue=\"" + XmlGenerator.escapeString((String)hash.get("Submission Value")) + (hash.get("Rank") == null || ((String)hash.get("Rank")).equals("") ? "" : "\" Rank=\"" + (String)hash.get("Rank")) + (hash.get("Order Number") == null || ((String)hash.get("Order Number")).equals("") ? "" : "\" OrderNumber=\"" + (String)hash.get("Order Number")) + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    if (hash.get("Alias Name") != null && !((String)hash.get("Alias Name")).equals("")) {
                        strAliasName = ((String)hash.get("Alias Name")).split(this.DELIMITER);
                        strAliasContext = ((String)hash.get("Alias Context")).split(this.DELIMITER);
                        for (i2 = 0; i2 < strAliasName.length; ++i2) {
                            str = OdmXmlWriter.insertIndent(this.indent);
                            str = str + "<Alias Context=\"" + strAliasContext[i2].trim() + "\" Name=\"" + strAliasName[i2].trim() + "\"/>";
                            this.writer.write(str);
                            this.writer.newLine();
                        }
                    }
                    if (hash.get("Code") != null && !((String)hash.get("Code")).equals("")) {
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "<Alias Name=\"" + (String)hash.get("Code") + "\" Context=\"nci:ExtCodeID\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    --this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "</EnumeratedItem>";
                    this.writer.write(str);
                    this.writer.newLine();
                } else {
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<CodeListItem CodedValue=\"" + XmlGenerator.escapeString((String)hash.get("Submission Value")) + (hash.get("Rank") == null || ((String)hash.get("Rank")).equals("") ? "" : "\" Rank=\"" + (String)hash.get("Rank")) + (hash.get("Order Number") == null || ((String)hash.get("Order Number")).equals("") ? "" : "\" OrderNumber=\"" + (String)hash.get("Order Number")) + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<Decode>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<TranslatedText" + (StringUtils.isEmpty((CharSequence)((CharSequence)hash.get("xml:lang"))) ? "" : " xml:lang=\"" + (String)hash.get("xml:lang") + "\"") + ">" + (hash.get("Translated Text") == null || ((String)hash.get("Translated Text")).equals("") ? XmlGenerator.escapeString((String)hash.get("Decode")) : XmlGenerator.escapeString((String)hash.get("Translated Text"))) + "</TranslatedText>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "</Decode>";
                    this.writer.write(str);
                    this.writer.newLine();
                    if (hash.get("Alias Name") != null && !((String)hash.get("Alias Name")).equals("")) {
                        strAliasName = ((String)hash.get("Alias Name")).split(this.DELIMITER);
                        strAliasContext = ((String)hash.get("Alias Context")).split(this.DELIMITER);
                        for (i2 = 0; i2 < strAliasName.length; ++i2) {
                            str = OdmXmlWriter.insertIndent(this.indent);
                            str = str + "<Alias Context=\"" + strAliasContext[i2].trim() + "\" Name=\"" + strAliasName[i2].trim() + "\"/>";
                            this.writer.write(str);
                            this.writer.newLine();
                        }
                    }
                    if (hash.get("Code") != null && !((String)hash.get("Code")).equals("")) {
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "<Alias Name=\"" + (String)hash.get("Code") + "\" Context=\"nci:ExtCodeID\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    --this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "</CodeListItem>";
                    this.writer.write(str);
                    this.writer.newLine();
                }
                prevCodelistID = (String)hash.get("Codelist ID");
                prevCodelistCode = (String)hash.get("Codelist Code");
            }
            if (prevCodelistCode != null && !prevCodelistCode.equals("")) {
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "<Alias Name=\"" + prevCodelistCode + "\" Context=\"nci:ExtCodeID\"/>";
                this.writer.write(str);
                this.writer.newLine();
            }
            if (prevCodelistID != null && !prevCodelistID.equals("")) {
                --this.indent;
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "</CodeList>";
                this.writer.write(str);
                this.writer.newLine();
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    public void writeConditionDefSection() throws TableNotFoundException, IOException, RequiredValueMissingException, InvalidOidSyntaxException {
        this.errHint.setErrorHint(OdmTagType.CONDITIONDEF, "", "", "", "", "");
        try {
            this.reader.setTable(this.config.odmConditionTableName);
            Hashtable<Object, Object> hash = new Hashtable();
            String prevConditionName = null;
            int conditionNumber = 0;
            String str = null;
            String[] strAliasName = null;
            String[] strAliasContext = null;
            while ((hash = this.reader.read(this.config.odmConditionTableName)) != null) {
                String conditionName;
                this.errHint.setErrorHint(OdmTagType.CONDITIONDEF, "", "", "", "", "");
                String conditionId = (String)hash.get("ID");
                if (StringUtils.isEmpty((CharSequence)conditionId)) {
                    conditionId = (String)hash.get("Condition ID");
                }
                if (StringUtils.isEmpty((CharSequence)(conditionName = (String)hash.get("Name")))) {
                    conditionName = (String)hash.get("Condition Name");
                }
                if (prevConditionName == null || !prevConditionName.equals(conditionName)) {
                    ++conditionNumber;
                    if (prevConditionName != null) {
                        if (strAliasName[0] != null && !strAliasName[0].equals("")) {
                            for (int i2 = 0; i2 < strAliasName.length; ++i2) {
                                str = OdmXmlWriter.insertIndent(this.indent);
                                str = str + "<Alias Context=\"" + strAliasContext[i2].trim() + "\" Name=\"" + strAliasName[i2].trim() + "\"/>";
                                this.writer.write(str);
                                this.writer.newLine();
                            }
                        }
                        strAliasName = null;
                        strAliasContext = null;
                        --this.indent;
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "</ConditionDef>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<ConditionDef OID=\"" + this.createOID(OdmTagType.CONDITIONDEF, "", "", "", "", conditionId) + "\" Name=\"" + conditionName + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<TranslatedText" + (StringUtils.isEmpty((CharSequence)((CharSequence)hash.get("xml:lang"))) ? "" : " xml:lang=\"" + (String)hash.get("xml:lang") + "\"") + ">" + XmlGenerator.escapeString((String)hash.get("Description")) + "</TranslatedText>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "</Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                    strAliasName = ((String)hash.get("Alias Name")).split(this.DELIMITER);
                    strAliasContext = ((String)hash.get("Alias Context")).split(this.DELIMITER);
                }
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "<FormalExpression Context=\"" + (String)hash.get("Formal Expression Context") + "\">" + XmlGenerator.escapeString((String)hash.get("Formal Expression")) + "</FormalExpression>";
                this.writer.write(str);
                this.writer.newLine();
                prevConditionName = conditionName;
            }
            if (conditionNumber > 0) {
                if (strAliasName[0] != null && !strAliasName[0].equals("")) {
                    for (int i2 = 0; i2 < strAliasName.length; ++i2) {
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "<Alias Context=\"" + strAliasContext[i2].trim() + "\" Name=\"" + strAliasName[i2].trim() + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                }
                strAliasName = null;
                strAliasContext = null;
                --this.indent;
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "</ConditionDef>";
                this.writer.write(str);
                this.writer.newLine();
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
        catch (TableNotFoundException ex) {
            logger.info((Object)"No ConditionDef section found. Skipping...");
        }
    }

    public void writeMethodDefSection() throws TableNotFoundException, IOException, RequiredValueMissingException, InvalidOidSyntaxException {
        this.errHint.setErrorHint(OdmTagType.METHODDEF, "", "", "", "", "");
        try {
            this.reader.setTable(this.config.odmMethodTableName);
            Hashtable<Object, Object> hash = new Hashtable();
            String prevMethodName = null;
            int methodNumber = 0;
            String str = null;
            String[] strAliasName = null;
            String[] strAliasContext = null;
            while ((hash = this.reader.read(this.config.odmMethodTableName)) != null) {
                String methodType;
                String methodName;
                this.errHint.setErrorHint(OdmTagType.METHODDEF, "", "", "", "", "");
                String methodId = (String)hash.get("ID");
                if (StringUtils.isEmpty((CharSequence)methodId)) {
                    methodId = (String)hash.get("Method ID");
                }
                if (StringUtils.isEmpty((CharSequence)(methodName = (String)hash.get("Name")))) {
                    methodName = (String)hash.get("Method Name");
                }
                if (StringUtils.isEmpty((CharSequence)(methodType = (String)hash.get("Type")))) {
                    methodType = (String)hash.get("Method Type");
                }
                if (prevMethodName == null || !prevMethodName.equals(methodName)) {
                    ++methodNumber;
                    if (prevMethodName != null) {
                        if (strAliasName[0] != null && !strAliasName[0].equals("")) {
                            for (int i2 = 0; i2 < strAliasName.length; ++i2) {
                                str = OdmXmlWriter.insertIndent(this.indent);
                                str = str + "<Alias Context=\"" + strAliasContext[i2].trim() + "\" Name=\"" + strAliasName[i2].trim() + "\"/>";
                                this.writer.write(str);
                                this.writer.newLine();
                            }
                        }
                        strAliasName = null;
                        strAliasContext = null;
                        --this.indent;
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "</MethodDef>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<MethodDef OID=\"" + this.createOID(OdmTagType.METHODDEF, "", "", "", "", methodId) + "\" Name=\"" + methodName + "\" Type=\"" + methodType + "\">";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                    ++this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "<TranslatedText" + (StringUtils.isEmpty((CharSequence)((CharSequence)hash.get("xml:lang"))) ? "" : " xml:lang=\"" + (String)hash.get("xml:lang") + "\"") + ">" + XmlGenerator.escapeString((String)hash.get("Description")) + "</TranslatedText>";
                    this.writer.write(str);
                    this.writer.newLine();
                    --this.indent;
                    str = OdmXmlWriter.insertIndent(this.indent);
                    str = str + "</Description>";
                    this.writer.write(str);
                    this.writer.newLine();
                    strAliasName = ((String)hash.get("Alias Name")).split(this.DELIMITER);
                    strAliasContext = ((String)hash.get("Alias Context")).split(this.DELIMITER);
                }
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "<FormalExpression Context=\"" + (String)hash.get("Formal Expression Context") + "\">" + XmlGenerator.escapeString((String)hash.get("Formal Expression")) + "</FormalExpression>";
                this.writer.write(str);
                this.writer.newLine();
                prevMethodName = methodName;
            }
            if (methodNumber > 0) {
                if (strAliasName[0] != null && !strAliasName[0].equals("")) {
                    for (int i2 = 0; i2 < strAliasName.length; ++i2) {
                        str = OdmXmlWriter.insertIndent(this.indent);
                        str = str + "<Alias Context=\"" + strAliasContext[i2].trim() + "\" Name=\"" + strAliasName[i2].trim() + "\"/>";
                        this.writer.write(str);
                        this.writer.newLine();
                    }
                }
                strAliasName = null;
                strAliasContext = null;
                --this.indent;
                str = OdmXmlWriter.insertIndent(this.indent);
                str = str + "</MethodDef>";
                this.writer.write(str);
                this.writer.newLine();
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
        catch (TableNotFoundException ex) {
            logger.info((Object)"No MethodDef section found. Skipping...");
        }
    }

    public void writeEndTag(String tag) throws IOException {
        --this.indent;
        String str = OdmXmlWriter.insertIndent(this.indent);
        str = str + "</" + tag + ">";
        this.writer.write(str);
        this.writer.newLine();
    }

    public void writeXmlComment(String comment) throws IOException {
        String str = OdmXmlWriter.insertIndent(this.indent);
        str = str + "<!-- " + comment + " -->";
        this.writer.write(str);
        this.writer.newLine();
    }

    public void close() throws IOException {
        this.reader.close();
        this.writer.close();
        this.sw.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String createOID(OdmTagType odmTagType, String eventId, String formId, String groupId, String fieldId, String param) throws InvalidOidSyntaxException, RequiredValueMissingException {
        try {
            String str = null;
            if (this.oidMode.equals((Object)Config.OidMode.EXACT)) {
                switch (odmTagType) {
                    case MEASUREMENTUNIT: 
                    case MEASUREMENTUNITREF: {
                        if (param.equals("")) throw new InvalidOidSyntaxException("MeasurementUnit/MeasurementUnitRef");
                        return param;
                    }
                    case STUDYEVENTDEF: 
                    case STUDYEVENTREF: {
                        if (eventId.equals("")) throw new InvalidOidSyntaxException("StudyEventDef/StudyEventRef");
                        return eventId;
                    }
                    case FORMDEF: 
                    case FORMREF: {
                        if (formId.equals("")) throw new InvalidOidSyntaxException("FormDef/FormRef");
                        return formId;
                    }
                    case ITEMGROUPDEF: 
                    case ITEMGROUPREF: {
                        if (groupId.equals("")) throw new InvalidOidSyntaxException("ItemGroupDef/ItemGroupRef");
                        return groupId;
                    }
                    case ITEMDEF: 
                    case ITEMREF: {
                        if (fieldId.equals("")) throw new InvalidOidSyntaxException("ItemDef/ItemRef");
                        return fieldId;
                    }
                    case CODELIST: 
                    case CODELISTREF: {
                        if (param.equals("")) throw new InvalidOidSyntaxException("Codelist/CodelistRef");
                        return param;
                    }
                    case METHODDEF: {
                        if (param.equals("")) throw new InvalidOidSyntaxException("MethodDef/MethodRef");
                        return param;
                    }
                    case CONDITIONDEF: {
                        if (param.equals("")) throw new InvalidOidSyntaxException("ConditionDef/ConditionRef");
                        return param;
                    }
                    case ARCHIVELAYOUT: {
                        if (param.equals("")) throw new InvalidOidSyntaxException("ArchiveLayout");
                        return param;
                    }
                    default: {
                        throw new InvalidOidSyntaxException("Unknown");
                    }
                }
            }
            switch (odmTagType) {
                case MEASUREMENTUNIT: 
                case MEASUREMENTUNITREF: {
                    if (param.equals("")) throw new InvalidOidSyntaxException("MeasurementUnit/MeasurementUnitRef");
                    return "MU." + param;
                }
                case STUDYEVENTDEF: 
                case STUDYEVENTREF: {
                    if (eventId.equals("")) throw new InvalidOidSyntaxException("StudyEventDef/StudyEventRef");
                    return "EV." + eventId;
                }
                case FORMDEF: 
                case FORMREF: {
                    if (formId.equals("")) throw new InvalidOidSyntaxException("FormDef/FormRef");
                    return "FR." + formId;
                }
                case ITEMGROUPDEF: 
                case ITEMGROUPREF: {
                    if (groupId.equals("")) throw new InvalidOidSyntaxException("ItemGroupDef/ItemGroupRef");
                    return "IG." + groupId;
                }
                case ITEMDEF: 
                case ITEMREF: {
                    if (fieldId.equals("")) throw new InvalidOidSyntaxException("ItemDef/ItemRef");
                    return "IT." + fieldId;
                }
                case CODELIST: 
                case CODELISTREF: {
                    if (param.equals("")) throw new InvalidOidSyntaxException("Codelist/CodelistRef");
                    return "CL." + param;
                }
                case METHODDEF: {
                    if (param.equals("")) throw new InvalidOidSyntaxException("MethodDef/MethodRef");
                    return "MT." + param;
                }
                case CONDITIONDEF: {
                    if (param.equals("")) throw new InvalidOidSyntaxException("ConditionDef/ConditionRef");
                    return "CD." + param;
                }
                case ARCHIVELAYOUT: {
                    if (param.equals("")) throw new InvalidOidSyntaxException("ArchiveLayout");
                    return "LF." + param;
                }
                default: {
                    throw new InvalidOidSyntaxException("Unknown");
                }
            }
        }
        catch (NullPointerException ex) {
            throw new RequiredValueMissingException(ex, this.errHint);
        }
    }

    private static String insertIndent(int indent) {
        String str = "";
        for (int i = 0; i < indent; ++i) {
            str = str + "  ";
        }
        return str;
    }

    private static String twoDigits(int n) {
        if (n >= 0 && n <= 9) {
            return new String("0" + new Integer(n).toString());
        }
        return new Integer(n).toString();
    }

    protected class ErrorHint {
        protected OdmTagType odmTagType = OdmTagType.DEFAULT;
        protected String eventName = "";
        protected String formName = "";
        protected String groupName = "";
        protected String fieldName = "";
        protected String param = "";

        protected ErrorHint() {
        }

        protected void setErrorHint(OdmTagType odmTagType, String eventName, String formName, String groupName, String fieldName, String param) {
            this.odmTagType = odmTagType;
            this.eventName = eventName == null ? "null" : eventName;
            this.formName = formName == null ? "null" : formName;
            this.groupName = groupName == null ? "null" : groupName;
            this.fieldName = fieldName == null ? "null" : fieldName;
            this.param = param == null ? "null" : param;
        }
    }

    public static enum OdmTagType {
        DEFAULT,
        XMLHEADER,
        STUDY,
        MEASUREMENTUNIT,
        MEASUREMENTUNITREF,
        PROTOCOL,
        STUDYEVENTDEF,
        STUDYEVENTREF,
        FORMDEF,
        FORMREF,
        ITEMGROUPDEF,
        ITEMGROUPREF,
        ITEMDEF,
        ITEMREF,
        CODELIST,
        CODELISTREF,
        METHODDEF,
        CONDITIONDEF,
        ARCHIVELAYOUT;

    }
}

