/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.exporter;

import com.fujitsu.tsc.desktop.exporter.DefineXmlWriter;
import com.fujitsu.tsc.desktop.exporter.InvalidOidSyntaxException;
import com.fujitsu.tsc.desktop.exporter.OdmXmlWriter;
import com.fujitsu.tsc.desktop.exporter.RequiredValueMissingException;
import com.fujitsu.tsc.desktop.exporter.TableNotFoundException;
import com.fujitsu.tsc.desktop.util.Config;
import com.fujitsu.tsc.desktop.util.InvalidParameterException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class XmlGenerator {
    private static Logger logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
    private Properties prop;
    private Config config;
    private Config.RunMode mode;

    public XmlGenerator() {
        this.config = new Config();
        this.mode = this.config.runMode;
    }

    public XmlGenerator(Config config) {
        this.config = config;
        this.mode = Config.RunMode.API;
    }

    public XmlGenerator(Config config, Config.RunMode mode) {
        this.config = config;
        this.mode = mode;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void generateDefineXml() throws InvalidParameterException, TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException, InvalidFormatException {
        try {
            logger.info((Object)"Launching the program...");
            logger.info((Object)("Creating define.xml for " + (Object)((Object)this.config.e2dDatasetType) + "..."));
            DefineXmlWriter writer = new DefineXmlWriter(this.config);
            logger.info((Object)"Writing XML Header...");
            writer.writeXMLHeader();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing Study Section...");
            writer.writeStudySection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing Document Section...");
            if (this.config.e2dDatasetType.name().equals("SDTM")) {
                writer.writeDocumentSection("AnnotatedCRF");
            }
            writer.writeDocumentSection("SupplementalDoc");
            logger.info((Object)"Done.");
            logger.info((Object)"Writing ValueListDef Section...");
            writer.writeValueListDefSection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing WhereClauseDef Section...");
            writer.writeWhereClauseDefSection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing ItemGroupDef Section...");
            writer.writeItemGroupDefSection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing ItemDef Section...");
            writer.writeItemDefSection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing Codelist Section...");
            writer.writeCodelistSection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing MethodDef Section...");
            writer.writeMethodDefSection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing CommentDef Section...");
            writer.writeCommentDefSection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing Leaf Section...");
            writer.writeLeafSection();
            logger.info((Object)"Done.");
            if (this.config.e2dDatasetType.name().equals("ADaM") && this.config.e2dIncludeResultMetadata) {
                logger.info((Object)"Writing AnalysisResult Section...");
                writer.writeAnalysisResultSection();
                logger.info((Object)"Done.");
            }
            writer.writeEndTag("MetaDataVersion");
            writer.writeEndTag("Study");
            writer.writeEndTag("ODM");
            logger.info((Object)"Define.xml has been created.");
            writer.close();
        }
        catch (InvalidParameterException ex) {
            logger.error((Object)ex.getMessage());
            logger.error((Object)"Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(1);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            throw ex;
        }
        catch (TableNotFoundException ex) {
            logger.error((Object)ex.getMessage());
            logger.error((Object)"Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(2);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            throw ex;
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)ex.getMessage());
            logger.error((Object)"Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(3);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            throw ex;
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            logger.error((Object)"Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(4);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            throw ex;
        }
        catch (InvalidOidSyntaxException ex) {
            logger.error((Object)ex.getMessage());
            logger.error((Object)"Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(5);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            throw ex;
        }
        catch (RequiredValueMissingException ex) {
            logger.error((Object)ex.getMessage());
            logger.error((Object)ex.getSourceClass());
            for (int i = 0; i < ex.getStackTrace().length; ++i) {
                logger.error((Object)("    " + ex.getStackTrace()[i]));
            }
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(6);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            throw ex;
        }
    }

    public void generateOdmXml() throws InvalidParameterException, TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException, InvalidFormatException {
        try {
            logger.info((Object)"Launching the program...");
            logger.info((Object)"Creating ODM ...");
            OdmXmlWriter writer = new OdmXmlWriter(this.config);
            logger.info((Object)"Writing XML Header...");
            writer.writeXMLHeader();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing Study Section...");
            writer.writeStudySection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing Unit Section...");
            writer.writeUnitSection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing Protocol Section...");
            writer.writeProtocolSection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing EventDef Section...");
            writer.writeEventDefSection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing FormDef Section...");
            writer.writeFormDefSection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing ItemGroup Section...");
            writer.writeItemGroupDefSection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing ItemDef Section...");
            writer.writeItemDefSection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing Codelist Section...");
            writer.writeCodelistSection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing ConditionDef Section...");
            writer.writeConditionDefSection();
            logger.info((Object)"Done.");
            logger.info((Object)"Writing MethodDef Section...");
            writer.writeMethodDefSection();
            logger.info((Object)"Done.");
            writer.writeEndTag("MetaDataVersion");
            writer.writeEndTag("Study");
            writer.writeEndTag("ODM");
            logger.info((Object)"ODM has been created.");
            writer.close();
        }
        catch (InvalidParameterException ex) {
            logger.error((Object)ex.getMessage());
            logger.error((Object)"Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(1);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            throw ex;
        }
        catch (TableNotFoundException ex) {
            logger.error((Object)ex.getMessage());
            logger.error((Object)"Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(2);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            throw ex;
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            logger.error((Object)"Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(4);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            throw ex;
        }
        catch (InvalidOidSyntaxException ex) {
            logger.error((Object)ex.getMessage());
            logger.error((Object)"Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(5);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            throw ex;
        }
        catch (RequiredValueMissingException ex) {
            logger.error((Object)ex.getMessage());
            logger.error((Object)"Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(6);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            throw ex;
        }
    }

    public static void main(String[] args) throws InvalidFormatException {
        PropertyConfigurator.configure((String)"./properties/log4j.properties");
        Object strConfig = null;
        try {
            Properties prop = new Properties();
            FileReader reader = new FileReader("./properties/main.properties");
            prop.load(reader);
            reader.close();
            Config config = new Config(prop);
            XmlGenerator generator = new XmlGenerator(config, Config.RunMode.CLI);
            generator.generateDefineXml();
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)ex.getMessage());
            System.exit(-1);
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            System.exit(-1);
        }
        catch (InvalidParameterException ex) {
            logger.error((Object)ex.getMessage());
            System.exit(-1);
        }
        catch (TableNotFoundException ex) {
            logger.error((Object)ex.getMessage());
            System.exit(-1);
        }
        catch (InvalidOidSyntaxException ex) {
            logger.error((Object)ex.getMessage());
            System.exit(-1);
        }
        catch (RequiredValueMissingException ex) {
            logger.error((Object)ex.getMessage());
            System.exit(-1);
        }
    }

    public static String escapeString(String str) {
        StringBuffer buffer = new StringBuffer(1000);
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (str.charAt(i) == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (str.charAt(i) == '>') {
                buffer.append("&gt;");
                continue;
            }
            if (str.charAt(i) == '\"') {
                buffer.append("&quot;");
                continue;
            }
            if (str.charAt(i) == '\'') {
                buffer.append("&apos;");
                continue;
            }
            buffer.append(str.charAt(i));
        }
        return buffer.toString();
    }
}

