/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.exporter.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class XmlDocument {
    public static final String INDENT_STRING = "  ";
    private XmlHeader xml_header;
    private List<ProcessingInstruction> processing_instructions;
    private XmlElement root_element;

    public XmlDocument(XmlHeader xml_header, XmlElement root_element) {
        this.xml_header = xml_header;
        this.processing_instructions = new ArrayList<ProcessingInstruction>();
        this.root_element = root_element;
    }

    public void addProcessingInstruction(ProcessingInstruction processing_instruction) {
        this.processing_instructions.add(processing_instruction);
    }

    public XmlElement getRootElement() {
        return this.root_element;
    }

    public String toString() {
        String str = "";
        str = this.xml_header.toString();
        for (ProcessingInstruction processing_instruction : this.processing_instructions) {
            str = str + processing_instruction.toString();
        }
        str = str + this.root_element.toString();
        return str;
    }

    public static String escapeString(String str) {
        StringBuffer buffer = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (str.charAt(i) == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (str.charAt(i) == '>') {
                buffer.append("&gt;");
                continue;
            }
            if (str.charAt(i) == '\"') {
                buffer.append("&quot;");
                continue;
            }
            if (str.charAt(i) == '\'') {
                buffer.append("&apos;");
                continue;
            }
            buffer.append(str.charAt(i));
        }
        return buffer.toString();
    }

    public static class XmlElement {
        private int indent_level = 0;
        private String name;
        private LinkedHashMap<String, String> attributes;
        private String text;
        private List<XmlElement> elements = new ArrayList<XmlElement>();

        public XmlElement(String name) {
            this.name = name;
            this.attributes = new LinkedHashMap();
            this.text = "";
        }

        public String getName() {
            return this.name;
        }

        public String getAttribute(String name) {
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                return this.attributes.get(name);
            }
            return null;
        }

        public void addAttribute(String name, String value) {
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                this.attributes.put(name, value);
            }
        }

        public void addAttribute(String name, Integer value) {
            if (value != null && value != 0) {
                this.attributes.put(name, String.valueOf(value));
            }
        }

        public void addText(String text) {
            this.text = text;
        }

        public void addElement(XmlElement element) {
            element.setIndentLevel(this.indent_level + 1);
            this.elements.add(element);
        }

        public XmlElement getElementByName(String name) {
            return this.elements.stream().filter(o -> StringUtils.equals((CharSequence)o.name, (CharSequence)name)).findFirst().orElse(null);
        }

        public List<XmlElement> getElementsByName(String name) {
            return this.elements.stream().filter(o -> StringUtils.equals((CharSequence)o.name, (CharSequence)name)).collect(Collectors.toList());
        }

        public int getElementIndex(XmlElement element) {
            return this.elements.indexOf(element);
        }

        public void sortElements(Comparator<XmlElement> comparator) {
            this.elements = this.elements.stream().sorted(comparator).collect(Collectors.toList());
        }

        public void setIndentLevel(int indent_level) {
            this.indent_level = indent_level;
        }

        public int getIndentLevel() {
            return this.indent_level;
        }

        public String toString() {
            String str = "";
            if (StringUtils.isEmpty((CharSequence)this.text) && this.elements.isEmpty()) {
                for (int i = 0; i < this.indent_level; ++i) {
                    str = str + XmlDocument.INDENT_STRING;
                }
                str = str + "<" + this.name;
                for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                    str = str + " " + entry.getKey() + "=\"" + XmlDocument.escapeString(entry.getValue()) + "\"";
                }
                str = str + "/>" + System.lineSeparator();
            } else {
                for (int i = 0; i < this.indent_level; ++i) {
                    str = str + XmlDocument.INDENT_STRING;
                }
                str = str + "<" + this.name;
                for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                    str = str + " " + entry.getKey() + "=\"" + XmlDocument.escapeString(entry.getValue()) + "\"";
                }
                str = str + ">";
                str = str + XmlDocument.escapeString(this.text);
                if (!this.elements.isEmpty()) {
                    str = str + System.lineSeparator();
                }
                for (XmlElement element : this.elements) {
                    str = str + element.toString();
                }
                if (!this.elements.isEmpty()) {
                    for (int i = 0; i < this.indent_level; ++i) {
                        str = str + XmlDocument.INDENT_STRING;
                    }
                }
                str = str + "</" + this.name + ">" + System.lineSeparator();
            }
            return str;
        }
    }

    public static class ProcessingInstruction {
        private String target;
        private LinkedHashMap<String, String> instructions;

        public ProcessingInstruction(String target) {
            this.target = target;
            this.instructions = new LinkedHashMap();
        }

        public void addInstruction(String name, String value) {
            this.instructions.put(name, value);
        }

        public String toString() {
            String str = "<?" + this.target;
            for (Map.Entry<String, String> entry : this.instructions.entrySet()) {
                str = str + " " + entry.getKey() + "=\"" + XmlDocument.escapeString(entry.getValue()) + "\"";
            }
            str = str + "?>" + System.lineSeparator();
            return str;
        }
    }

    public static class XmlHeader {
        private String encoding;

        public XmlHeader(String encoding) {
            this.encoding = encoding;
        }

        public String toString() {
            String str = "<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>" + System.lineSeparator();
            return str;
        }
    }
}

