/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.gui;

import com.fujitsu.tsc.desktop.gui.EditorPaneAppender;
import com.fujitsu.tsc.desktop.gui.FilePathTransferHandler;
import com.fujitsu.tsc.desktop.gui.GuiConstants;
import com.fujitsu.tsc.desktop.gui.GuiMain;
import com.fujitsu.tsc.desktop.importer.CrfSpecCreator;
import com.fujitsu.tsc.desktop.importer.ExcelWriter2;
import com.fujitsu.tsc.desktop.importer.models.EdcKeysModel;
import com.fujitsu.tsc.desktop.importer.models.OdmCodelistModel;
import com.fujitsu.tsc.desktop.importer.models.OdmConditionModel;
import com.fujitsu.tsc.desktop.importer.models.OdmEventFormModel;
import com.fujitsu.tsc.desktop.importer.models.OdmEventModel;
import com.fujitsu.tsc.desktop.importer.models.OdmFieldModel;
import com.fujitsu.tsc.desktop.importer.models.OdmFormModel;
import com.fujitsu.tsc.desktop.importer.models.OdmMethodModel;
import com.fujitsu.tsc.desktop.importer.models.OdmModel;
import com.fujitsu.tsc.desktop.importer.models.OdmStudyModel;
import com.fujitsu.tsc.desktop.importer.models.OdmUnitModel;
import com.fujitsu.tsc.desktop.util.Config;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class CrfSpecCreatePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
    private Config config;
    private GuiMain parent;
    private Font titleFont;
    private Font defaultFont;
    private Font submitFont;
    private JPanel headerPanel;
    private JLabel titleL;
    private JPanel bodyPanel;
    private JLabel architectLocationL;
    protected JTextField architectLocationTF;
    private JScrollPane sourceFilesScrollPane;
    private JLabel sourceFilesL;
    protected JList<String> sourceFilesLI;
    private JLabel headerCntL;
    protected JTextField headerCntTF;
    private JLabel encodingL;
    protected JComboBox<String> encodingCB;
    private JLabel delimiterL;
    protected JTextField delimiterTF;
    private JLabel textQualifierL;
    protected JComboBox<String> textQualifierCB;
    private JLabel outputLocationL;
    protected JTextField outputLocationTF;
    private JButton browseButton1;
    private JButton clearButton1;
    private JButton browseButton2;
    private JButton clearButton2;
    private JButton browseButton3;
    private JButton clearButton3;
    protected JFileChooser fileChooser1;
    private FileNameExtensionFilter filter1;
    protected JFileChooser fileChooser2;
    protected JFileChooser fileChooser3;
    private JPanel footerPanel;
    private JButton runButton;

    public CrfSpecCreatePanel(GuiMain parent, Config config) {
        this.config = config;
        this.parent = parent;
        this.titleFont = new Font(GuiConstants.FONT_NAME_TITLE, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE_TITLE);
        this.defaultFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE, GuiConstants.FONT_SIZE);
        this.submitFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE);
        this.setBackground(GuiConstants.COLOR_BORDER);
        this.initHeaderPanel();
        this.initBodyPanel();
        this.initFooterPanel();
        GroupLayout panelLayout = new GroupLayout(this);
        this.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerPanel, -2, -1, Short.MAX_VALUE).addComponent(this.bodyPanel, -2, -1, Short.MAX_VALUE).addComponent(this.footerPanel, -2, -1, Short.MAX_VALUE));
        panelLayout.setVerticalGroup(panelLayout.createSequentialGroup().addGap(GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK).addComponent(this.headerPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.bodyPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.footerPanel, -2, -1, -2));
    }

    private void initHeaderPanel() {
        this.headerPanel = new JPanel();
        this.headerPanel.setBackground(GuiConstants.COLOR_BG);
        this.titleL = new JLabel("Create CRF Spec from Datasets");
        this.titleL.setFont(this.titleFont);
        this.titleL.setForeground(GuiConstants.FONT_COLOR_TITLE);
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        headerPanelLayout.setAutoCreateContainerGaps(true);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, Short.MAX_VALUE));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, -2));
    }

    private void initBodyPanel() {
        this.bodyPanel = new JPanel();
        this.bodyPanel.setBackground(GuiConstants.COLOR_BG);
        this.architectLocationL = new JLabel("Architect CRF Location (.xlsx):");
        this.architectLocationL.setEnabled(false);
        this.architectLocationTF = new JTextField("");
        this.architectLocationTF.setEditable(false);
        this.sourceFilesL = new JLabel("Datasets Text Files:");
        this.sourceFilesLI = new JList();
        this.sourceFilesLI.setVisibleRowCount(GuiConstants.VISIBLE_ROWS);
        this.sourceFilesScrollPane = new JScrollPane(this.sourceFilesLI);
        this.headerCntL = new JLabel("# of Header Lines:");
        this.headerCntTF = new JTextField("");
        this.encodingL = new JLabel("Character Encoding:");
        this.encodingCB = new JComboBox<String>(Config.ENCODING);
        this.delimiterL = new JLabel("Delimiter:");
        this.delimiterTF = new JTextField("");
        this.textQualifierL = new JLabel("Text Qualifier:");
        this.textQualifierCB = new JComboBox<String>(Config.TEXT_QUALIFIER);
        this.outputLocationL = new JLabel("Output Location:");
        this.outputLocationTF = new JTextField("");
        this.browseButton1 = new JButton("Browse");
        this.browseButton1.setEnabled(false);
        this.clearButton1 = new JButton("Clear");
        this.clearButton1.setEnabled(false);
        this.browseButton2 = new JButton("Browse");
        this.clearButton2 = new JButton("Clear");
        this.browseButton3 = new JButton("Browse");
        this.clearButton3 = new JButton("Clear");
        this.fileChooser1 = new JFileChooser();
        this.filter1 = new FileNameExtensionFilter("Excel Book (.xlsx)", "xlsx");
        this.fileChooser1.setFileFilter(this.filter1);
        this.architectLocationTF.setTransferHandler(new FilePathTransferHandler(this.architectLocationTF, this.fileChooser1, this.filter1));
        this.fileChooser2 = new JFileChooser();
        this.fileChooser2.setMultiSelectionEnabled(true);
        this.sourceFilesLI.setTransferHandler(new FilePathTransferHandler(this.sourceFilesLI, this.fileChooser2));
        this.fileChooser3 = new JFileChooser();
        this.fileChooser3.setFileSelectionMode(1);
        this.outputLocationTF.setTransferHandler(new FilePathTransferHandler(this.outputLocationTF, this.fileChooser3));
        this.browseButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = CrfSpecCreatePanel.this.fileChooser1.showOpenDialog(CrfSpecCreatePanel.this);
                if (selected == 0) {
                    CrfSpecCreatePanel.this.architectLocationTF.setText(CrfSpecCreatePanel.this.fileChooser1.getSelectedFile().getPath());
                } else if (selected == 1 || selected == -1) {
                    // empty if block
                }
            }
        });
        this.clearButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrfSpecCreatePanel.this.architectLocationTF.setText("");
            }
        });
        this.browseButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = CrfSpecCreatePanel.this.fileChooser2.showOpenDialog(CrfSpecCreatePanel.this);
                if (selected == 0) {
                    Vector<String> paths = new Vector<String>();
                    for (File f : CrfSpecCreatePanel.this.fileChooser2.getSelectedFiles()) {
                        paths.add(f.getAbsolutePath());
                    }
                    CrfSpecCreatePanel.this.sourceFilesLI.setListData(paths);
                } else if (selected == 1 || selected == -1) {
                    // empty if block
                }
            }
        });
        this.clearButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrfSpecCreatePanel.this.sourceFilesLI.setModel(new DefaultListModel());
            }
        });
        this.browseButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = CrfSpecCreatePanel.this.fileChooser3.showOpenDialog(CrfSpecCreatePanel.this);
                if (selected == 0) {
                    CrfSpecCreatePanel.this.outputLocationTF.setText(CrfSpecCreatePanel.this.fileChooser3.getSelectedFile().getPath() + System.getProperty("file.separator") + GuiConstants.CRF_EXCEL_FILE_NAME);
                } else if (selected == 1 || selected == -1) {
                    // empty if block
                }
            }
        });
        this.clearButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrfSpecCreatePanel.this.outputLocationTF.setText("");
            }
        });
        this.architectLocationL.setFont(this.defaultFont);
        this.sourceFilesL.setFont(this.defaultFont);
        this.headerCntL.setFont(this.defaultFont);
        this.headerCntTF.setFont(this.defaultFont);
        this.encodingL.setFont(this.defaultFont);
        this.encodingCB.setFont(this.defaultFont);
        this.delimiterL.setFont(this.defaultFont);
        this.delimiterTF.setFont(this.defaultFont);
        this.textQualifierL.setFont(this.defaultFont);
        this.textQualifierCB.setFont(this.defaultFont);
        this.outputLocationL.setFont(this.defaultFont);
        this.browseButton1.setFont(this.defaultFont);
        this.clearButton1.setFont(this.defaultFont);
        this.browseButton2.setFont(this.defaultFont);
        this.clearButton2.setFont(this.defaultFont);
        this.browseButton3.setFont(this.defaultFont);
        this.clearButton3.setFont(this.defaultFont);
        if (!ArrayUtils.isEmpty((Object[])this.config.crfSourceFiles)) {
            this.sourceFilesLI.setListData((String[])this.config.crfSourceFiles);
        }
        this.headerCntTF.setText(this.config.crfHeaderCnt);
        this.encodingCB.setSelectedItem(this.config.crfEncoding);
        this.delimiterTF.setText(this.config.crfDelimiter);
        this.textQualifierCB.setSelectedItem(this.config.crfTextQualifier);
        this.outputLocationTF.setText(this.config.crfOutputLocation);
        GroupLayout bodyPanelLayout = new GroupLayout(this.bodyPanel);
        this.bodyPanel.setLayout(bodyPanelLayout);
        bodyPanelLayout.setHorizontalGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bodyPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.CONFIG_GAP_LEFT, GuiConstants.CONFIG_GAP_LEFT).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.architectLocationL).addComponent(this.sourceFilesL).addComponent(this.headerCntL).addComponent(this.encodingL).addComponent(this.delimiterL).addComponent(this.textQualifierL).addComponent(this.outputLocationL)).addGap(GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.architectLocationTF, -1, 255, Short.MAX_VALUE).addComponent(this.sourceFilesScrollPane, -1, 255, Short.MAX_VALUE).addComponent(this.headerCntTF, -2, 255, -2).addComponent(this.encodingCB, -2, 255, -2).addComponent(this.delimiterTF, -2, 255, -2).addComponent(this.textQualifierCB, -2, 255, -2).addComponent(this.outputLocationTF, -1, 255, Short.MAX_VALUE)).addGap(GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browseButton1).addComponent(this.browseButton2).addComponent(this.browseButton3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.clearButton1).addComponent(this.clearButton2).addComponent(this.clearButton3)).addContainerGap(GuiConstants.CONFIG_GAP_RIGHT, GuiConstants.CONFIG_GAP_RIGHT)));
        bodyPanelLayout.setVerticalGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bodyPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.CONFIG_GAP_TOP, GuiConstants.CONFIG_GAP_TOP).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.architectLocationL).addComponent(this.architectLocationTF, -2, -1, -2).addComponent(this.browseButton1).addComponent(this.clearButton1)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceFilesL).addComponent(this.sourceFilesScrollPane, -2, -1, -2).addComponent(this.browseButton2).addComponent(this.clearButton2)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.headerCntL).addComponent(this.headerCntTF, -2, -1, -2)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.encodingL).addComponent(this.encodingCB, -2, -1, -2)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.delimiterL).addComponent(this.delimiterTF, -2, -1, -2)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textQualifierL).addComponent(this.textQualifierCB, -2, -1, -2)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputLocationL).addComponent(this.outputLocationTF, -2, -1, -2).addComponent(this.browseButton3).addComponent(this.clearButton3)).addContainerGap(GuiConstants.CONFIG_GAP_BOTTOM, GuiConstants.CONFIG_GAP_BOTTOM)));
    }

    private void initFooterPanel() {
        this.footerPanel = new JPanel();
        this.footerPanel.setBackground(GuiConstants.COLOR_BG);
        this.runButton = new JButton("Create");
        this.runButton.setFont(this.submitFont);
        this.runButton.setForeground(GuiConstants.COLOR_BTN_FG_SUBMIT);
        this.runButton.setBackground(GuiConstants.COLOR_BTN_BG_SUBMIT);
        this.runButton.setActionCommand("Create");
        this.runButton.addActionListener(this);
        GroupLayout footerPanelLayout = new GroupLayout(this.footerPanel);
        footerPanelLayout.setAutoCreateContainerGaps(true);
        this.footerPanel.setLayout(footerPanelLayout);
        footerPanelLayout.setHorizontalGroup(footerPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.FOOTER_GAP_LEFT, Short.MAX_VALUE).addComponent(this.runButton));
        footerPanelLayout.setVerticalGroup(footerPanelLayout.createSequentialGroup().addComponent(this.runButton).addContainerGap(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    public String validateEntry() {
        if (StringUtils.isEmpty((CharSequence)this.architectLocationTF.getText()) && (this.sourceFilesLI.getModel() == null || this.sourceFilesLI.getModel().getSize() < 1)) {
            return "Either \"Architect CRF Location (.xlsx)\" or \"Datasets Text Files\" must be entered.";
        }
        if (this.sourceFilesLI.getModel() != null && this.sourceFilesLI.getModel().getSize() > 0) {
            if (StringUtils.isEmpty((CharSequence)this.headerCntTF.getText()) || NumberUtils.toInt((String)this.headerCntTF.getText(), (int)0) < 1) {
                return "\"# of Header Lines\" cannot be blank and must be a positive integer when \"Datasets Text Files\" is entered.";
            }
            if (NumberUtils.toInt((String)this.headerCntTF.getText(), (int)-1) < 0) {
                return "# of Header Lines must be 0 or a positive number.";
            }
            if (this.encodingCB.getModel() == null) {
                return "\"Character Encoding\" cannot be blank when \"Datasets Text Files\" is entered.";
            }
            if (StringUtils.isEmpty((CharSequence)this.delimiterTF.getText())) {
                return "\"Delimiter\" cannot be blank when \"Datasets Text Files\" is entered.";
            }
            if (StringUtils.length((CharSequence)this.delimiterTF.getText()) != 1 && !StringUtils.equals((CharSequence)this.delimiterTF.getText(), (CharSequence)"\\t")) {
                return "Delimiter must be a single character or a tab (\\t).";
            }
            if (this.textQualifierCB.getModel() == null) {
                return "\"Text Qualifier\" cannot be blank when \"Datasets Text Files\" is entered.";
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.outputLocationTF.getText())) {
            return "Output Location cannot be blank.";
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Create".equals(command)) {
            String errMessage = this.validateEntry();
            if (StringUtils.isEmpty((CharSequence)errMessage)) {
                this.parent.showPanel(this.parent.crfSpecCreateResultPanel);
                this.parent.crfSpecCreateResultPanel.clearBodyPanel();
                Runnable createCrfSpec = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        EditorPaneAppender epAppender = new EditorPaneAppender();
                        epAppender.setEditorPane(((CrfSpecCreatePanel)CrfSpecCreatePanel.this).parent.crfSpecCreateResultPanel.gResultEditorPane);
                        epAppender.setLayout((Layout)new PatternLayout("%-5p %c{2} - %m%n"));
                        logger.addAppender((Appender)epAppender);
                        OdmModel crf = null;
                        File outFile = new File(CrfSpecCreatePanel.this.outputLocationTF.getText());
                        try {
                            if (CrfSpecCreatePanel.this.sourceFilesLI.getModel() != null && CrfSpecCreatePanel.this.sourceFilesLI.getModel().getSize() > 0) {
                                OdmStudyModel params = new OdmStudyModel();
                                params.edc_dataset_type = "Text";
                                params.header_line = NumberUtils.toInt((String)CrfSpecCreatePanel.this.headerCntTF.getText());
                                params.encoding = CrfSpecCreatePanel.this.encodingCB.getSelectedItem().toString();
                                params.delimiter = CrfSpecCreatePanel.this.delimiterTF.getText();
                                params.text_qualifier = CrfSpecCreatePanel.this.textQualifierCB.getSelectedItem().toString();
                                ListModel<String> list = CrfSpecCreatePanel.this.sourceFilesLI.getModel();
                                Vector<File> srcFiles = new Vector<File>();
                                for (int i = 0; i < list.getSize(); ++i) {
                                    srcFiles.add(new File(list.getElementAt(i)));
                                }
                                CrfSpecCreator creator = new CrfSpecCreator(CrfSpecCreatePanel.this.config, params, srcFiles.toArray(new File[srcFiles.size()]));
                                logger.info((Object)"Creating CRF Spec from Datasets...");
                                crf = creator.create();
                                logger.info((Object)"Created CRF Spec from Datasets successfully.");
                            }
                            if (crf == null) {
                                throw new IllegalGuiParameterException();
                            }
                            crf.updateEdcKeys(((CrfSpecCreatePanel)CrfSpecCreatePanel.this).config.valueDelimiter);
                            crf.updateFieldFormName();
                            crf.updateFieldId(((CrfSpecCreatePanel)CrfSpecCreatePanel.this).config.valueDelimiter);
                            logger.info((Object)"Writing to Excel...");
                            ExcelWriter2 excelWriter = new ExcelWriter2();
                            logger.info((Object)"Writing STUDY Sheet...");
                            excelWriter.addData("STUDY", crf.getStudy(), OdmStudyModel.class);
                            logger.info((Object)"Writing UNIT Sheet...");
                            excelWriter.addData("UNIT", crf.listUnit(), OdmUnitModel.class);
                            logger.info((Object)"Writing EVENT Sheet...");
                            excelWriter.addData("EVENT", crf.listEvent(), OdmEventModel.class);
                            logger.info((Object)"Writing EVENTxFORM Sheet...");
                            excelWriter.addData("EVENTxFORM", crf.listEventForm(), OdmEventFormModel.class);
                            logger.info((Object)"Writing FORM Sheet...");
                            excelWriter.addData("FORM", crf.listForm(), OdmFormModel.class);
                            logger.info((Object)"Writing FIELD Sheet...");
                            excelWriter.addData("FIELD", crf.listField(), OdmFieldModel.class);
                            logger.info((Object)"Writing CODELIST Sheet. This could take a few minutes...");
                            excelWriter.addData("CODELIST", crf.listCodelist(), OdmCodelistModel.class);
                            excelWriter.addData("METHOD", crf.listMethod(), OdmMethodModel.class);
                            excelWriter.addData("CONDITION", crf.listCondition(), OdmConditionModel.class);
                            logger.info((Object)"Writing EDC_KEYS Sheet...");
                            excelWriter.addData("EDC_KEYS", crf.getEdcKeys(), EdcKeysModel.class);
                            excelWriter.writeout(outFile);
                            logger.info((Object)"Done.");
                            ((CrfSpecCreatePanel)CrfSpecCreatePanel.this).parent.crfSpecCreateResultPanel.outputLocationUrl.setText(new File(CrfSpecCreatePanel.this.outputLocationTF.getText()).getCanonicalPath());
                        }
                        catch (Exception ex) {
                            logger.error((Object)ExceptionUtils.getStackTrace((Throwable)ex));
                        }
                        finally {
                            logger.removeAppender((Appender)epAppender);
                        }
                    }
                };
                new Thread(createCrfSpec).start();
            } else {
                Object[] options = new String[]{"OK"};
                JLabel errMessageL = new JLabel(errMessage);
                errMessageL.setFont(this.defaultFont);
                JOptionPane.showOptionDialog(this.parent, errMessageL, "Message", -1, 2, null, options, "OK");
            }
        }
    }

    private class IllegalArchitectFormat
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalArchitectFormat() {
            super("Loading Architect CRF failed due to illegal format.");
        }
    }

    private class IllegalGuiParameterException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalGuiParameterException() {
            super("Configuration settings on the GUI is illegal.");
        }
    }
}

