/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.gui;

import com.fujitsu.tsc.desktop.gui.GuiConstants;
import com.fujitsu.tsc.desktop.gui.GuiMain;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class DesktopMenuBar
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = 5574971135909932382L;
    private static Logger logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
    private GuiMain parent;
    private JMenu fileMenu;
    private JMenuItem closeMI;
    private JMenu defineMenu;
    private JMenuItem exportDefineMI;
    private JMenuItem importDefineMI;
    private JMenuItem xmlToHtmlMI;
    private JMenu crfMenu;
    private JMenuItem exportOdmMI;
    private JMenuItem importOdmMI;
    private JMenuItem importCrfMI;
    private JMenu edtMenu;
    private JMenuItem importEdtMI;
    private JMenu validationMenu;
    private JMenuItem validateXmlMI;
    private JMenu helpMenu;
    private JMenuItem aboutMI;

    public DesktopMenuBar(GuiMain parent) {
        this.parent = parent;
        this.initComponents();
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(GuiConstants.FRAME_WIDTH, GuiConstants.MENU_HEIGHT));
        this.setBackground(GuiConstants.COLOR_BG);
        this.setBorderPainted(false);
        this.fileMenu = this.createMenu("File", "custom_folder_open_black_48dp.png");
        this.closeMI = new JMenuItem("Close");
        this.defineMenu = this.createMenu("Define-XML", "custom_integration_instructions_black_48dp.png");
        this.exportDefineMI = new JMenuItem("Convert from Excel to Define-XML");
        this.importDefineMI = new JMenuItem("Convert from Define-XML to Excel");
        this.xmlToHtmlMI = new JMenuItem("Convert from XML to HTML");
        this.crfMenu = this.createMenu("CRF", "custom_ballot_black_48dp.png");
        this.exportOdmMI = new JMenuItem("Convert from Excel to ODM-XML");
        this.importOdmMI = new JMenuItem("Convert from ODM-XML to Excel");
        this.importCrfMI = new JMenuItem("Create CRF Spec from Datasets");
        this.edtMenu = this.createMenu("eDT", "custom_table_view_black_48dp.png");
        this.importEdtMI = new JMenuItem("Create eDT Spec from Datasets");
        this.validationMenu = this.createMenu("Validation", "custom_fact_check_black_48dp.png");
        this.validateXmlMI = new JMenuItem("Validate XML against XML Schema");
        this.helpMenu = this.createMenu("Help", "custom_info_black_48dp.png");
        this.aboutMI = new JMenuItem("About tsClinical Desktop");
        this.add(Box.createRigidArea(new Dimension(10, 1)));
        this.add(this.fileMenu);
        this.fileMenu.add(this.closeMI);
        this.add(Box.createRigidArea(new Dimension(10, 1)));
        this.add(this.defineMenu);
        this.defineMenu.add(this.exportDefineMI);
        this.defineMenu.add(this.importDefineMI);
        this.defineMenu.add(this.xmlToHtmlMI);
        this.add(Box.createRigidArea(new Dimension(10, 1)));
        this.add(this.crfMenu);
        this.crfMenu.add(this.exportOdmMI);
        this.crfMenu.add(this.importOdmMI);
        this.crfMenu.add(this.importCrfMI);
        this.add(Box.createRigidArea(new Dimension(10, 1)));
        this.add(this.edtMenu);
        this.edtMenu.add(this.importEdtMI);
        this.add(Box.createRigidArea(new Dimension(10, 1)));
        this.add(this.validationMenu);
        this.validationMenu.add(this.validateXmlMI);
        this.add(Box.createRigidArea(new Dimension(10, 1)));
        this.add(this.helpMenu);
        this.helpMenu.add(this.aboutMI);
        this.closeMI.setActionCommand("CLOSE");
        this.exportDefineMI.setActionCommand("EXPORT_DEFINE");
        this.importDefineMI.setActionCommand("IMPORT_DEFINE");
        this.xmlToHtmlMI.setActionCommand("XML_TO_HTML");
        this.exportOdmMI.setActionCommand("EXPORT_ODM");
        this.importOdmMI.setActionCommand("IMPORT_ODM");
        this.importCrfMI.setActionCommand("CREATE_CRF");
        this.importEdtMI.setActionCommand("CREATE_EDT");
        this.validateXmlMI.setActionCommand("VALIDATE_XML");
        this.aboutMI.setActionCommand("ABOUT");
        this.closeMI.addActionListener(this);
        this.exportDefineMI.addActionListener(this);
        this.importDefineMI.addActionListener(this);
        this.xmlToHtmlMI.addActionListener(this);
        this.exportOdmMI.addActionListener(this);
        this.importOdmMI.addActionListener(this);
        this.importCrfMI.addActionListener(this);
        this.importEdtMI.addActionListener(this);
        this.validateXmlMI.addActionListener(this);
        this.aboutMI.addActionListener(this);
    }

    private JMenu createMenu(String label, String icon_filename) {
        JMenu menu = new JMenu(label);
        menu.setIcon(new ImageIcon(GuiConstants.ICON_IMAGE_DIR + "/" + icon_filename));
        menu.setHorizontalTextPosition(0);
        menu.setVerticalTextPosition(3);
        return menu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        logger.info((Object)command);
        if ("EXPORT_DEFINE".equals(command)) {
            this.parent.showPanel(this.parent.defineExportPanel);
        } else if ("IMPORT_DEFINE".equals(command)) {
            this.parent.showPanel(this.parent.defineImportPanel);
        } else if ("XML_TO_HTML".equals(command)) {
            this.parent.showPanel(this.parent.xmlToHtmlPanel);
        } else if ("EXPORT_ODM".equals(command)) {
            this.parent.showPanel(this.parent.odmExportPanel);
        } else if ("IMPORT_ODM".equals(command)) {
            this.parent.showPanel(this.parent.odmImportPanel);
        } else if ("CREATE_CRF".equals(command)) {
            this.parent.showPanel(this.parent.crfSpecCreatePanel);
        } else if ("CREATE_EDT".equals(command)) {
            this.parent.showPanel(this.parent.edtSpecCreatePanel);
        } else if ("VALIDATE_XML".equals(command)) {
            this.parent.showPanel(this.parent.xmlValidatePanel);
        } else if ("ABOUT".equals(command)) {
            this.parent.aboutDialog.setVisible(true);
        } else if ("CLOSE".equals(command)) {
            this.parent.dispatchEvent(new WindowEvent(this.parent, 201));
        }
    }
}

