/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer;

import com.fujitsu.tsc.desktop.importer.DefineImportError;
import com.fujitsu.tsc.desktop.importer.models.DefineARMDatasetModel;
import com.fujitsu.tsc.desktop.importer.models.DefineARMDisplayModel;
import com.fujitsu.tsc.desktop.importer.models.DefineARMResultModel;
import com.fujitsu.tsc.desktop.importer.models.DefineCodelistModel;
import com.fujitsu.tsc.desktop.importer.models.DefineCommentModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDatasetModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDictionaryModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDocumentModel;
import com.fujitsu.tsc.desktop.importer.models.DefineMethodModel;
import com.fujitsu.tsc.desktop.importer.models.DefineModel;
import com.fujitsu.tsc.desktop.importer.models.DefineStandardModel;
import com.fujitsu.tsc.desktop.importer.models.DefineStudyModel;
import com.fujitsu.tsc.desktop.importer.models.DefineValueModel;
import com.fujitsu.tsc.desktop.importer.models.DefineVariableModel;
import com.fujitsu.tsc.desktop.importer.models.DefineWCModel;
import com.fujitsu.tsc.desktop.util.Config;
import com.fujitsu.tsc.desktop.util.ErrorInfo;
import com.fujitsu.tsc.desktop.util.TscStack;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DefineXmlReader
extends DefaultHandler {
    private static Logger logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
    private static String MESSAGE_ORPHANED = "An orphaned element found.";
    private Config config;
    private Locator locator;
    private List<ErrorInfo> errors = new ArrayList<ErrorInfo>();
    private TscStack path_stack = new TscStack();
    private DefineModel define = new DefineModel();
    private String cached_document_id = "";
    private int cached_document_ordinal = 1;
    private String cached_itemgroup_name = "";
    private int cached_itemgroup_ordinal = 1;
    private int cached_itemref_ordinal = 1;
    private String cached_itemdef_oid = "";
    private String cached_valuelist_oid = "";
    private String cached_itemref_oid = "";
    private String cached_wc_oid = "";
    private DefineWCModel.WCCondition cached_wc_condition = null;
    private int cached_codelist_ordinal = 1;
    private String cached_codelist_oid = "";
    private String cached_codelist_name = "";
    private String cached_codelist_datatype = "";
    private String cached_codelist_sasformat = "";
    private String cached_codelist_standard_oid = "";
    private String cached_codelist_comment_oid = "";
    private DefineCodelistModel cached_codelist = null;
    private int cached_arm_display_ordinal = 1;
    private DefineARMDisplayModel cached_arm_display = null;
    private int cached_arm_result_ordinal = 1;
    private DefineModel.DocumentRef cached_display_doc = null;
    private DefineARMResultModel cached_arm_result = null;
    private DefineARMDatasetModel cached_arm_dataset = null;
    private int cached_arm_dataset_ordinal = 1;
    private DefineModel.DocumentRef cached_docm_doc = null;
    private DefineModel.DocumentRef cached_prog_code_doc = null;
    private String cached_method_id = "";
    private DefineModel.DocumentRef cached_method_doc = null;
    private String cached_comment_id = "";
    private DefineModel.DocumentRef cached_comment_doc = null;

    public DefineXmlReader(Config config) {
        logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
        this.config = config;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) {
        this.path_stack.push(qName);
        this.bindAttributes(this.path_stack.getPath(), attr);
    }

    private void bindAttributes(String path, Attributes attr) {
        String analysis_variable_oid;
        if ("/ODM/".equals(path)) {
            DefineStudyModel study = new DefineStudyModel();
            study.file_oid = attr.getValue("FileOID");
            study.odm_version = attr.getValue("ODMVersion");
            study.file_type = attr.getValue("FileType");
            study.as_of_date_time = attr.getValue("AsOfDateTime");
            study.originator = attr.getValue("Originator");
            study.context = attr.getValue("def:Context");
            this.define.put(study);
        } else if ("/ODM/Study/".equals(path)) {
            DefineStudyModel study = this.define.getStudy();
            if (study != null) {
                study.study_oid = attr.getValue("OID");
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/".equals(path)) {
            DefineStudyModel study = this.define.getStudy();
            if (study != null) {
                study.metadata_oid = attr.getValue("OID");
                study.metadata_name = attr.getValue("Name");
                study.metadata_description = attr.getValue("Description");
                study.define_version = attr.getValue("def:DefineVersion");
                study.comment_oid = attr.getValue("def:CommentOID");
                study.standard_name = attr.getValue("def:StandardName");
                study.standard_version = attr.getValue("def:StandardVersion");
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/def:Standards/def:Standard/".equals(path)) {
            DefineStandardModel.DefineStandardPk key = new DefineStandardModel.DefineStandardPk(attr.getValue("OID"));
            DefineStandardModel standard = new DefineStandardModel(key);
            standard.standard_name = attr.getValue("Name");
            standard.standard_type = DefineStandardModel.StandardType.parse(attr.getValue("Type"));
            standard.publishing_set = attr.getValue("PublishingSet");
            standard.standard_version = attr.getValue("Version");
            standard.standard_status = attr.getValue("Status");
            standard.comment_oid = attr.getValue("def:CommentOID");
            this.define.put(key, standard);
        } else if ("/ODM/Study/MetaDataVersion/def:AnnotatedCRF/def:DocumentRef/".equals(path)) {
            DefineDocumentModel.DefineDocumentPk key = new DefineDocumentModel.DefineDocumentPk(attr.getValue("leafID"));
            DefineDocumentModel document = new DefineDocumentModel(key);
            document.document_type = DefineModel.DocType.AnnotatedCRF;
            this.define.put(key, document);
        } else if ("/ODM/Study/MetaDataVersion/def:SupplementalDoc/def:DocumentRef/".equals(path)) {
            DefineDocumentModel.DefineDocumentPk key = new DefineDocumentModel.DefineDocumentPk(attr.getValue("leafID"));
            DefineDocumentModel document = new DefineDocumentModel(key);
            document.document_type = DefineModel.DocType.SupplementalDoc;
            this.define.put(key, document);
        } else if ("/ODM/Study/MetaDataVersion/def:leaf/".equals(path)) {
            DefineDocumentModel.DefineDocumentPk key = new DefineDocumentModel.DefineDocumentPk(attr.getValue("ID"));
            DefineDocumentModel document = this.define.get(key);
            if (document == null) {
                document = new DefineDocumentModel(key);
                this.define.put(key, document);
                document.document_type = DefineModel.DocType.Other;
            }
            document.ordinal = this.cached_document_ordinal++;
            document.document_href = attr.getValue("xlink:href");
            this.cached_document_id = document.document_id;
        } else if ("/ODM/Study/MetaDataVersion/ItemGroupDef/".equals(path)) {
            this.cached_itemgroup_name = attr.getValue("Name");
            DefineDatasetModel.DefineDatasetPk key = new DefineDatasetModel.DefineDatasetPk(this.cached_itemgroup_name);
            DefineDatasetModel dataset = new DefineDatasetModel(key);
            dataset.ordinal = this.cached_itemgroup_ordinal++;
            dataset.domain = attr.getValue("Domain");
            dataset.dataset_oid = attr.getValue("OID");
            dataset.has_no_data = DefineModel.YorNull.parse(attr.getValue("def:HasNoData"));
            dataset.repeating = DefineModel.YorN.parse(attr.getValue("Repeating"));
            dataset.is_reference_data = DefineModel.YorN.parse(attr.getValue("IsReferenceData"));
            dataset.purpose = attr.getValue("Purpose");
            dataset.sas_dataset_name = attr.getValue("SASDatasetName");
            dataset.standard_oid = attr.getValue("def:StandardOID");
            dataset.structure = attr.getValue("def:Structure");
            dataset.dataset_class = attr.getValue("def:Class");
            dataset.comment_oid = attr.getValue("def:CommentOID");
            this.define.put(key, dataset);
        } else if ("/ODM/Study/MetaDataVersion/ItemGroupDef/ItemRef/".equals(path)) {
            DefineDatasetModel.DefineDatasetPk dkey = new DefineDatasetModel.DefineDatasetPk(this.cached_itemgroup_name);
            DefineDatasetModel dataset = this.define.get(dkey);
            if (dataset != null) {
                DefineVariableModel.DefineVariablePk key = new DefineVariableModel.DefineVariablePk(this.cached_itemgroup_name, attr.getValue("ItemOID"));
                DefineVariableModel variable = new DefineVariableModel(key);
                try {
                    variable.ordinal = Integer.parseInt(attr.getValue("OrderNumber"));
                }
                catch (Exception ex) {
                    variable.ordinal = this.cached_itemref_ordinal++;
                }
                variable.mandatory = DefineModel.YorN.parse(attr.getValue("Mandatory"));
                variable.key_sequence = attr.getValue("KeySequence");
                variable.role = attr.getValue("Role");
                variable.role_codelist = attr.getValue("RoleCodeListOID");
                variable.method_oid = attr.getValue("MethodOID");
                variable.has_no_data = DefineModel.YorNull.parse(attr.getValue("def:HasNoData"));
                this.define.put(key, variable);
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemGroupDef/Alias/".equals(path)) {
            DefineDatasetModel.DefineDatasetPk key = new DefineDatasetModel.DefineDatasetPk(this.cached_itemgroup_name);
            DefineDatasetModel dataset = this.define.get(key);
            if (dataset != null) {
                dataset.alias_name = attr.getValue("Name");
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemGroupDef/def:leaf/".equals(path)) {
            DefineDatasetModel.DefineDatasetPk key = new DefineDatasetModel.DefineDatasetPk(this.cached_itemgroup_name);
            DefineDatasetModel dataset = this.define.get(key);
            if (dataset != null) {
                dataset.leaf_href = attr.getValue("xlink:href");
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemGroupDef/def:Class/".equals(path)) {
            DefineDatasetModel.DefineDatasetPk key = new DefineDatasetModel.DefineDatasetPk(this.cached_itemgroup_name);
            DefineDatasetModel dataset = this.define.get(key);
            if (dataset != null) {
                dataset.dataset_class = attr.getValue("Name");
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemGroupDef/def:Class/def:SubClass/".equals(path)) {
            DefineDatasetModel.DefineDatasetPk key = new DefineDatasetModel.DefineDatasetPk(this.cached_itemgroup_name);
            DefineDatasetModel dataset = this.define.get(key);
            if (dataset != null) {
                dataset.dataset_subclass = attr.getValue("Name");
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/".equals(path)) {
            this.cached_itemdef_oid = attr.getValue("OID");
            List<DefineVariableModel> variables = this.define.getVariableByOid(this.cached_itemdef_oid);
            if (!variables.isEmpty()) {
                for (DefineVariableModel variable : variables) {
                    variable.variable_name = attr.getValue("Name");
                    variable.data_type = attr.getValue("DataType");
                    variable.length = attr.getValue("Length");
                    variable.significant_digits = attr.getValue("SignificantDigits");
                    variable.sas_field_name = attr.getValue("SASFieldName");
                    variable.display_format = attr.getValue("def:DisplayFormat");
                    variable.comment_oid = attr.getValue("def:CommentOID");
                }
            } else {
                DefineValueModel value = this.define.get(new DefineValueModel.DefineValuePk(this.cached_itemdef_oid));
                if (value != null) {
                    value.value_name = attr.getValue("Name");
                    value.data_type = attr.getValue("DataType");
                    value.length = attr.getValue("Length");
                    value.significant_digits = attr.getValue("SignificantDigits");
                    value.sas_field_name = attr.getValue("SASFieldName");
                    value.display_format = attr.getValue("def:DisplayFormat");
                    value.comment_oid = attr.getValue("def:CommentOID");
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/CodeListRef/".equals(path)) {
            List<DefineVariableModel> variables = this.define.getVariableByOid(this.cached_itemdef_oid);
            if (!variables.isEmpty()) {
                for (DefineVariableModel variable : variables) {
                    variable.codelist = attr.getValue("CodeListOID");
                }
            } else {
                DefineValueModel value = this.define.get(new DefineValueModel.DefineValuePk(this.cached_itemdef_oid));
                if (value != null) {
                    value.codelist = attr.getValue("CodeListOID");
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/def:Origin/".equals(path)) {
            List<DefineVariableModel> variables = this.define.getVariableByOid(this.cached_itemdef_oid);
            if (!variables.isEmpty()) {
                for (DefineVariableModel variable : variables) {
                    variable.origin = attr.getValue("Type");
                    variable.source = attr.getValue("Source");
                }
            } else {
                DefineValueModel value = this.define.get(new DefineValueModel.DefineValuePk(this.cached_itemdef_oid));
                if (value != null) {
                    value.origin = attr.getValue("Type");
                    value.source = attr.getValue("Source");
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/Alias/".equals(path)) {
            List<DefineVariableModel> variables = this.define.getVariableByOid(this.cached_itemdef_oid);
            if (!variables.isEmpty()) {
                for (DefineVariableModel variable : variables) {
                    variable.alias_context = attr.getValue("Context");
                    variable.alias_name = attr.getValue("Name");
                }
            } else {
                DefineValueModel value = this.define.get(new DefineValueModel.DefineValuePk(this.cached_itemdef_oid));
                if (value != null) {
                    value.alias_context = attr.getValue("Context");
                    value.alias_name = attr.getValue("Name");
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/def:Origin/def:DocumentRef/".equals(path)) {
            List<DefineVariableModel> variables = this.define.getVariableByOid(this.cached_itemdef_oid);
            if (!variables.isEmpty()) {
                for (DefineVariableModel variable : variables) {
                    variable.crf_id = attr.getValue("leafID");
                }
            } else {
                DefineValueModel value = this.define.get(new DefineValueModel.DefineValuePk(this.cached_itemdef_oid));
                if (value != null) {
                    value.crf_id = attr.getValue("leafID");
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/def:Origin/def:DocumentRef/def:PDFPageRef/".equals(path)) {
            List<DefineVariableModel> variables = this.define.getVariableByOid(this.cached_itemdef_oid);
            if (!variables.isEmpty()) {
                for (DefineVariableModel variable : variables) {
                    variable.crf_page_type = attr.getValue("Type");
                    variable.crf_page_reference = attr.getValue("PageRefs");
                    variable.crf_first_page = attr.getValue("FirstPage");
                    variable.crf_last_page = attr.getValue("LastPage");
                    variable.crf_page_title = attr.getValue("Title");
                }
            } else {
                DefineValueModel value = this.define.get(new DefineValueModel.DefineValuePk(this.cached_itemdef_oid));
                if (value != null) {
                    value.crf_page_type = attr.getValue("Type");
                    value.crf_page_reference = attr.getValue("PageRefs");
                    value.crf_first_page = attr.getValue("FirstPage");
                    value.crf_last_page = attr.getValue("LastPage");
                    value.crf_page_title = attr.getValue("Title");
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/def:ValueListRef/".equals(path)) {
            List<DefineVariableModel> variables = this.define.getVariableByOid(this.cached_itemdef_oid);
            if (!variables.isEmpty()) {
                for (DefineVariableModel variable : variables) {
                    variable.valuelist_oid = attr.getValue("ValueListOID");
                }
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/def:ValueListDef/".equals(path)) {
            this.cached_valuelist_oid = attr.getValue("OID");
            this.cached_itemref_ordinal = 1;
        } else if ("/ODM/Study/MetaDataVersion/def:ValueListDef/ItemRef/".equals(path)) {
            this.cached_itemref_oid = attr.getValue("ItemOID");
            DefineValueModel.DefineValuePk key = new DefineValueModel.DefineValuePk(this.cached_itemref_oid);
            DefineValueModel value = new DefineValueModel(key);
            value.valuelist_oid = this.cached_valuelist_oid;
            try {
                value.ordinal = Integer.parseInt(attr.getValue("OrderNumber"));
            }
            catch (Exception ex) {
                value.ordinal = this.cached_itemref_ordinal++;
            }
            value.mandatory = DefineModel.YorN.parse(attr.getValue("Mandatory"));
            value.key_sequence = attr.getValue("KeySequence");
            value.method_oid = attr.getValue("MethodOID");
            value.has_no_data = DefineModel.YorNull.parse(attr.getValue("def:HasNoData"));
            this.define.put(key, value);
        } else if ("/ODM/Study/MetaDataVersion/def:ValueListDef/ItemRef/def:WhereClauseRef/".equals(path)) {
            DefineValueModel.DefineValuePk vkey = new DefineValueModel.DefineValuePk(this.cached_itemref_oid);
            DefineValueModel value = this.define.get(vkey);
            DefineWCModel.DefineWCPk wc_key = new DefineWCModel.DefineWCPk(attr.getValue("WhereClauseOID"));
            value.where_clause_pks.add(wc_key);
        } else if ("/ODM/Study/MetaDataVersion/def:WhereClauseDef/".equals(path)) {
            this.cached_wc_oid = attr.getValue("OID");
            DefineWCModel.DefineWCPk key = new DefineWCModel.DefineWCPk(this.cached_wc_oid);
            DefineWCModel wc = new DefineWCModel(key);
            wc.comment_oid = attr.getValue("def:CommentOID");
            this.define.put(key, wc);
        } else if ("/ODM/Study/MetaDataVersion/def:WhereClauseDef/RangeCheck/".equals(path)) {
            DefineWCModel.DefineWCPk key = new DefineWCModel.DefineWCPk(this.cached_wc_oid);
            DefineWCModel wc = this.define.get(key);
            if (wc != null) {
                this.cached_wc_condition = new DefineWCModel.WCCondition();
                this.cached_wc_condition.variable_oid = attr.getValue("def:ItemOID");
                this.cached_wc_condition.operator = attr.getValue("Comparator");
                wc.wc_conditions.add(this.cached_wc_condition);
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/CodeList/".equals(path)) {
            this.cached_codelist_oid = attr.getValue("OID");
            this.cached_codelist_ordinal = 1;
            this.cached_codelist_name = attr.getValue("Name");
            this.cached_codelist_datatype = attr.getValue("DataType");
            this.cached_codelist_sasformat = attr.getValue("SASFormatName");
            this.cached_codelist_comment_oid = attr.getValue("def:CommentOID");
            this.cached_codelist_standard_oid = attr.getValue("def:StandardOID");
        } else if ("/ODM/Study/MetaDataVersion/CodeList/ExternalCodeList/".equals(path)) {
            DefineDictionaryModel.DefineDictionaryPk key = new DefineDictionaryModel.DefineDictionaryPk(this.cached_codelist_oid);
            DefineDictionaryModel dictionary = new DefineDictionaryModel(key);
            dictionary.dictionary_id = this.cached_codelist_oid;
            dictionary.dictionary_name = attr.getValue("Dictionary");
            dictionary.data_type = this.cached_codelist_datatype;
            dictionary.dictionary_version = attr.getValue("Version");
            dictionary.dictionary_ref = attr.getValue("ref");
            dictionary.dictionary_href = attr.getValue("href");
            dictionary.comment_oid = this.cached_codelist_comment_oid;
            this.define.put(key, dictionary);
        } else if ("/ODM/Study/MetaDataVersion/CodeList/CodeListItem/".equals(path)) {
            DefineCodelistModel.DefineCodelistPk key = new DefineCodelistModel.DefineCodelistPk(this.cached_codelist_oid, attr.getValue("CodedValue"));
            DefineCodelistModel codelist = new DefineCodelistModel(key);
            codelist.codelist_label = this.cached_codelist_name;
            codelist.data_type = this.cached_codelist_datatype;
            codelist.sas_format_name = this.cached_codelist_sasformat;
            codelist.comment_oid = this.cached_codelist_comment_oid;
            codelist.standard_oid = this.cached_codelist_standard_oid;
            try {
                if (!StringUtils.isEmpty((CharSequence)attr.getValue("Rank"))) {
                    codelist.rank = Integer.parseInt(attr.getValue("Rank"));
                }
                if (!StringUtils.isEmpty((CharSequence)attr.getValue("OrderNumber"))) {
                    codelist.ordinal = codelist.order_number = Integer.valueOf(Integer.parseInt(attr.getValue("OrderNumber")));
                }
            }
            catch (Exception ex) {
                codelist.ordinal = this.cached_codelist_ordinal++;
                DefineImportError error = new DefineImportError(new DefineCodelistModel.DefineCodelistPk(codelist.codelist_id, codelist.submission_value));
                error.putMessage("Error parsing Codelist Rank/OrderNumber attributes.");
                logger.warn((Object)error.toString());
            }
            codelist.extended_value = DefineModel.YorNull.parse(attr.getValue("def:ExtendedValue"));
            this.define.put(key, codelist);
            this.cached_codelist = codelist;
        } else if ("/ODM/Study/MetaDataVersion/CodeList/CodeListItem/Decode/TranslatedText/".equals(path)) {
            this.cached_codelist.xml_lang = attr.getValue("xml:lang");
        } else if ("/ODM/Study/MetaDataVersion/CodeList/CodeListItem/Alias/".equals(path)) {
            String alias_context = attr.getValue("Context");
            if ("nci:ExtCodeID".equals(alias_context)) {
                this.cached_codelist.code = attr.getValue("Name");
            } else {
                this.cached_codelist.alias_context = alias_context;
                this.cached_codelist.alias_name = attr.getValue("Name");
            }
        } else if ("/ODM/Study/MetaDataVersion/CodeList/EnumeratedItem/".equals(path)) {
            DefineCodelistModel.DefineCodelistPk key = new DefineCodelistModel.DefineCodelistPk(this.cached_codelist_oid, attr.getValue("CodedValue"));
            DefineCodelistModel codelist = new DefineCodelistModel(key);
            codelist.codelist_label = this.cached_codelist_name;
            codelist.data_type = this.cached_codelist_datatype;
            codelist.sas_format_name = this.cached_codelist_sasformat;
            try {
                if (!StringUtils.isEmpty((CharSequence)attr.getValue("Rank"))) {
                    codelist.rank = Integer.parseInt(attr.getValue("Rank"));
                }
                if (!StringUtils.isEmpty((CharSequence)attr.getValue("OrderNumber"))) {
                    codelist.ordinal = codelist.order_number = Integer.valueOf(Integer.parseInt(attr.getValue("OrderNumber")));
                }
            }
            catch (Exception ex) {
                codelist.ordinal = this.cached_codelist_ordinal++;
                DefineImportError error = new DefineImportError(new DefineCodelistModel.DefineCodelistPk(codelist.codelist_id, codelist.submission_value));
                error.putMessage("Error parsing Codelist Rank/OrderNumber attributes.");
                logger.warn((Object)error.toString());
            }
            codelist.extended_value = DefineModel.YorNull.parse(attr.getValue("def:ExtendedValue"));
            this.define.put(key, codelist);
            this.cached_codelist = codelist;
        } else if ("/ODM/Study/MetaDataVersion/CodeList/EnumeratedItem/Alias/".equals(path)) {
            this.cached_codelist.code = attr.getValue("Name");
        } else if ("/ODM/Study/MetaDataVersion/CodeList/Alias/".equals(path)) {
            List<DefineCodelistModel> codelists = this.define.getCodelistByCodelistId(this.cached_codelist_oid);
            for (DefineCodelistModel codelist : codelists) {
                codelist.codelist_code = attr.getValue("Name");
            }
        } else if ("/ODM/Study/MetaDataVersion/MethodDef/".equals(path)) {
            this.cached_method_id = attr.getValue("OID");
            DefineMethodModel.DefineMethodPk key = new DefineMethodModel.DefineMethodPk(this.cached_method_id);
            DefineMethodModel method = new DefineMethodModel(key);
            method.method_name = attr.getValue("Name");
            method.method_type = attr.getValue("Type");
            this.define.put(key, method);
        } else if ("/ODM/Study/MetaDataVersion/MethodDef/Description/TranslatedText/".equals(path)) {
            DefineMethodModel.DefineMethodPk key = new DefineMethodModel.DefineMethodPk(this.cached_method_id);
            DefineMethodModel method = this.define.get(key);
            if (method != null) {
                method.description_lang = attr.getValue("xml:lang");
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/MethodDef/FormalExpression/".equals(path)) {
            DefineMethodModel.DefineMethodPk key = new DefineMethodModel.DefineMethodPk(this.cached_method_id);
            DefineMethodModel method = this.define.get(key);
            if (method != null) {
                method.formal_expression_context = attr.getValue("Context");
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/MethodDef/def:DocumentRef/".equals(path)) {
            DefineMethodModel.DefineMethodPk key = new DefineMethodModel.DefineMethodPk(this.cached_method_id);
            DefineMethodModel method = this.define.get(key);
            String document_id = attr.getValue("leafID");
            if (method != null && StringUtils.isNotEmpty((CharSequence)document_id)) {
                this.cached_method_doc = new DefineModel.DocumentRef(document_id);
                method.document_refs.add(this.cached_method_doc);
            } else {
                this.cached_method_doc = null;
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/MethodDef/def:DocumentRef/def:PDFPageRef/".equals(path)) {
            if (this.cached_method_doc != null) {
                this.cached_method_doc.document_page_type = attr.getValue("Type");
                this.cached_method_doc.document_page_reference = attr.getValue("PageRefs");
                this.cached_method_doc.document_first_page = attr.getValue("FirstPage");
                this.cached_method_doc.document_last_page = attr.getValue("LastPage");
                this.cached_method_doc.document_page_title = attr.getValue("Title");
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/def:CommentDef/".equals(path)) {
            this.cached_comment_id = attr.getValue("OID");
            DefineCommentModel.DefineCommentPk key = new DefineCommentModel.DefineCommentPk(this.cached_comment_id);
            DefineCommentModel comment = new DefineCommentModel(key);
            this.define.put(key, comment);
        } else if ("/ODM/Study/MetaDataVersion/def:CommentDef/Description/TranslatedText/".equals(path)) {
            DefineCommentModel.DefineCommentPk key = new DefineCommentModel.DefineCommentPk(this.cached_comment_id);
            DefineCommentModel comment = this.define.get(key);
            if (comment != null) {
                comment.comment_lang = attr.getValue("xml:lang");
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/def:CommentDef/def:DocumentRef/".equals(path)) {
            DefineCommentModel.DefineCommentPk key = new DefineCommentModel.DefineCommentPk(this.cached_comment_id);
            DefineCommentModel comment = this.define.get(key);
            String document_id = attr.getValue("leafID");
            if (comment != null && StringUtils.isNotEmpty((CharSequence)document_id)) {
                this.cached_comment_doc = new DefineModel.DocumentRef(document_id);
                comment.document_refs.add(this.cached_comment_doc);
            } else {
                this.cached_comment_doc = null;
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/def:CommentDef/def:DocumentRef/def:PDFPageRef/".equals(path)) {
            if (this.cached_comment_doc != null) {
                this.cached_comment_doc.document_page_type = attr.getValue("Type");
                this.cached_comment_doc.document_page_reference = attr.getValue("PageRefs");
                this.cached_comment_doc.document_first_page = attr.getValue("FirstPage");
                this.cached_comment_doc.document_last_page = attr.getValue("LastPage");
                this.cached_comment_doc.document_page_title = attr.getValue("Title");
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/".equals(path)) {
            DefineARMDisplayModel.DefineARMDisplayPk key = new DefineARMDisplayModel.DefineARMDisplayPk(attr.getValue("Name"));
            this.cached_arm_display = new DefineARMDisplayModel(key);
            this.cached_arm_display.ordinal = this.cached_arm_display_ordinal++;
            this.cached_arm_result_ordinal = 1;
            this.define.put(key, this.cached_arm_display);
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/Description/TranslatedText/".equals(path)) {
            this.cached_arm_display.display_lang = attr.getValue("xml:lang");
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/def:DocumentRef/".equals(path)) {
            String leaf_id = attr.getValue("leafID");
            if (StringUtils.isNotEmpty((CharSequence)leaf_id)) {
                this.cached_display_doc = new DefineModel.DocumentRef(leaf_id);
                this.cached_arm_display.document_refs.add(this.cached_display_doc);
            } else {
                this.cached_display_doc = null;
            }
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/def:DocumentRef/def:PDFPageRef/".equals(path)) {
            if (this.cached_display_doc != null) {
                this.cached_display_doc.document_page_type = attr.getValue("Type");
                this.cached_display_doc.document_page_reference = attr.getValue("PageRefs");
                this.cached_display_doc.document_first_page = attr.getValue("FirstPage");
                this.cached_display_doc.document_last_page = attr.getValue("LastPage");
                this.cached_display_doc.document_page_title = attr.getValue("Title");
            }
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/arm:AnalysisResult/".equals(path)) {
            DefineARMResultModel.DefineARMResultPk key = new DefineARMResultModel.DefineARMResultPk(this.cached_arm_display.display_name, attr.getValue("OID"));
            DefineARMResultModel result = new DefineARMResultModel(key);
            result.ordinal = this.cached_arm_result_ordinal++;
            result.param_oid = attr.getValue("ParameterOID");
            result.analysis_reason = attr.getValue("AnalysisReason");
            result.analysis_purpose = attr.getValue("AnalysisPurpose");
            this.cached_arm_display.arm_result_pks.add(key);
            this.cached_arm_result = result;
            this.define.put(key, this.cached_arm_result);
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/arm:AnalysisResult/Description/TranslatedText/".equals(path)) {
            this.cached_arm_result.result_lang = attr.getValue("xml:lang");
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/arm:AnalysisResult/arm:AnalysisDatasets/".equals(path)) {
            this.cached_arm_result.dataset_comment_oid = attr.getValue("def:CommentOID");
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/arm:AnalysisResult/arm:Documentation/Description/TranslatedText/".equals(path)) {
            this.cached_arm_result.docm_lang = attr.getValue("xml:lang");
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/arm:AnalysisResult/arm:Documentation/def:DocumentRef/".equals(path)) {
            String document_id = attr.getValue("leafID");
            if (StringUtils.isNotEmpty((CharSequence)document_id)) {
                this.cached_docm_doc = new DefineModel.DocumentRef(document_id);
                this.cached_arm_result.docm_document_refs.add(this.cached_docm_doc);
            } else {
                this.cached_docm_doc = null;
            }
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/arm:AnalysisResult/arm:Documentation/def:DocumentRef/def:PDFPageRef/".equals(path)) {
            if (this.cached_docm_doc != null) {
                this.cached_docm_doc.document_page_type = attr.getValue("Type");
                this.cached_docm_doc.document_page_reference = attr.getValue("PageRefs");
                this.cached_docm_doc.document_first_page = attr.getValue("FirstPage");
                this.cached_docm_doc.document_last_page = attr.getValue("LastPage");
                this.cached_docm_doc.document_page_title = attr.getValue("Title");
            }
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/arm:AnalysisResult/arm:ProgrammingCode/".equals(path)) {
            this.cached_arm_result.prog_code_context = attr.getValue("Context");
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/arm:AnalysisResult/arm:ProgrammingCode/def:DocumentRef/".equals(path)) {
            String document_id = attr.getValue("leafID");
            if (StringUtils.isNotEmpty((CharSequence)document_id)) {
                this.cached_prog_code_doc = new DefineModel.DocumentRef(document_id);
                this.cached_arm_result.prog_code_document_refs.add(this.cached_prog_code_doc);
            } else {
                this.cached_prog_code_doc = null;
            }
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/arm:AnalysisResult/arm:ProgrammingCode/def:DocumentRef/def:PDFPageRef/".equals(path)) {
            if (this.cached_prog_code_doc != null) {
                this.cached_prog_code_doc.document_page_type = attr.getValue("Type");
                this.cached_prog_code_doc.document_page_reference = attr.getValue("PageRefs");
                this.cached_prog_code_doc.document_first_page = attr.getValue("FirstPage");
                this.cached_prog_code_doc.document_last_page = attr.getValue("LastPage");
                this.cached_prog_code_doc.document_page_title = attr.getValue("Title");
            }
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/arm:AnalysisResult/arm:AnalysisDatasets/arm:AnalysisDataset/".equals(path)) {
            DefineARMDatasetModel.DefineARMDatasetPk key = new DefineARMDatasetModel.DefineARMDatasetPk(this.cached_arm_display.display_name, this.cached_arm_result.result_key, attr.getValue("ItemGroupOID"));
            DefineARMDatasetModel arm_dataset = new DefineARMDatasetModel(key);
            arm_dataset.ordinal = this.cached_arm_dataset_ordinal++;
            this.define.put(key, arm_dataset);
            this.cached_arm_dataset = arm_dataset;
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/arm:AnalysisResult/arm:AnalysisDatasets/arm:AnalysisDataset/def:WhereClauseRef/".equals(path)) {
            this.cached_arm_dataset.where_clause_pk = new DefineWCModel.DefineWCPk(attr.getValue("WhereClauseOID"));
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/arm:AnalysisResult/arm:AnalysisDatasets/arm:AnalysisDataset/arm:AnalysisVariable/".equals(path) && StringUtils.isNotEmpty((CharSequence)(analysis_variable_oid = attr.getValue("ItemOID")))) {
            this.cached_arm_dataset.analysis_variable_oids.add(analysis_variable_oid);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String text = new String(ch, start, length).trim();
        if (text != null) {
            this.bindText(this.path_stack.getPath(), text);
        }
    }

    public void bindText(String path, String text) {
        if ("/ODM/Study/GlobalVariables/StudyName/".equals(path)) {
            DefineStudyModel study = this.define.getStudy();
            if (study != null) {
                study.study_name = study.study_name + text;
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/GlobalVariables/StudyDescription/".equals(path)) {
            DefineStudyModel study = this.define.getStudy();
            if (study != null) {
                study.study_description = study.study_description + text;
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/GlobalVariables/ProtocolName/".equals(path)) {
            DefineStudyModel study = this.define.getStudy();
            if (study != null) {
                study.protocol_name = study.protocol_name + text;
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/def:leaf/def:title/".equals(path)) {
            DefineDocumentModel.DefineDocumentPk key = new DefineDocumentModel.DefineDocumentPk(this.cached_document_id);
            DefineDocumentModel document = this.define.get(key);
            if (document != null) {
                document.document_title = document.document_title + text;
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemGroupDef/Description/TranslatedText/".equals(path)) {
            DefineDatasetModel.DefineDatasetPk key = new DefineDatasetModel.DefineDatasetPk(this.cached_itemgroup_name);
            DefineDatasetModel dataset = this.define.get(key);
            if (dataset != null) {
                dataset.description = dataset.description + text;
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemGroupDef/def:leaf/def:title/".equals(path)) {
            DefineDatasetModel.DefineDatasetPk key = new DefineDatasetModel.DefineDatasetPk(this.cached_itemgroup_name);
            DefineDatasetModel dataset = this.define.get(key);
            if (dataset != null) {
                dataset.leaf_title = dataset.leaf_title + text;
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/Description/TranslatedText/".equals(path)) {
            List<DefineVariableModel> variables = this.define.getVariableByOid(this.cached_itemdef_oid);
            if (!variables.isEmpty()) {
                for (DefineVariableModel variable : variables) {
                    variable.variable_label = variable.variable_label + text;
                }
            } else {
                DefineValueModel value = this.define.get(new DefineValueModel.DefineValuePk(this.cached_itemdef_oid));
                if (value != null) {
                    value.value_label = value.value_label + text;
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/ItemDef/def:Origin/Description/TranslatedText/".equals(path)) {
            List<DefineVariableModel> variables = this.define.getVariableByOid(this.cached_itemdef_oid);
            if (!variables.isEmpty()) {
                for (DefineVariableModel variable : variables) {
                    variable.predecessor = variable.predecessor + text;
                }
            } else {
                DefineValueModel value = this.define.get(new DefineValueModel.DefineValuePk(this.cached_itemdef_oid));
                if (value != null) {
                    value.predecessor = value.predecessor + text;
                } else {
                    logger.warn((Object)MESSAGE_ORPHANED);
                }
            }
        } else if ("/ODM/Study/MetaDataVersion/def:WhereClauseDef/RangeCheck/CheckValue/".equals(path)) {
            if (this.cached_wc_condition != null) {
                this.cached_wc_condition.values.add(text);
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/CodeList/CodeListItem/Decode/TranslatedText/".equals(path)) {
            this.cached_codelist.decode = this.cached_codelist.decode + text;
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/Description/TranslatedText/".equals(path)) {
            this.cached_arm_display.display_desc = this.cached_arm_display.display_desc + text;
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/arm:AnalysisResult/Description/TranslatedText/".equals(path)) {
            this.cached_arm_result.result_desc = this.cached_arm_result.result_desc + text;
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/arm:AnalysisResult/arm:Documentation/Description/TranslatedText/".equals(path)) {
            this.cached_arm_result.docm_text = this.cached_arm_result.docm_text + text;
        } else if ("/ODM/Study/MetaDataVersion/arm:AnalysisResultDisplays/arm:ResultDisplay/arm:AnalysisResult/arm:ProgrammingCode/arm:Code/".equals(path)) {
            this.cached_arm_result.prog_code_text = this.cached_arm_result.prog_code_text + text;
        } else if ("/ODM/Study/MetaDataVersion/MethodDef/Description/TranslatedText/".equals(path)) {
            DefineMethodModel.DefineMethodPk key = new DefineMethodModel.DefineMethodPk(this.cached_method_id);
            DefineMethodModel method = this.define.get(key);
            if (method != null) {
                method.description = method.description + text;
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/MethodDef/FormalExpression/".equals(path)) {
            DefineMethodModel.DefineMethodPk key = new DefineMethodModel.DefineMethodPk(this.cached_method_id);
            DefineMethodModel method = this.define.get(key);
            if (method != null) {
                method.formal_expression = method.formal_expression + text;
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        } else if ("/ODM/Study/MetaDataVersion/def:CommentDef/Description/TranslatedText/".equals(path)) {
            DefineCommentModel.DefineCommentPk key = new DefineCommentModel.DefineCommentPk(this.cached_comment_id);
            DefineCommentModel comment = this.define.get(key);
            if (comment != null) {
                comment.comment_text = comment.comment_text + text;
            } else {
                logger.warn((Object)MESSAGE_ORPHANED);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        this.path_stack.pop();
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        ErrorInfo error = new ErrorInfo();
        error.setId(exception.getSystemId());
        error.setLine(exception.getLineNumber());
        error.setColumn(exception.getColumnNumber());
        error.setMessage(exception.getMessage());
        error.setMessage(exception.getMessage() + "\nnear the line number " + this.locator.getLineNumber() + ".");
        this.errors.add(error);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        ErrorInfo error = new ErrorInfo();
        error.setId(exception.getSystemId());
        error.setLine(exception.getLineNumber());
        error.setColumn(exception.getColumnNumber());
        error.setMessage(exception.getMessage() + "\nnear the line number " + this.locator.getLineNumber() + ".");
        this.errors.add(error);
    }

    public DefineModel getDefineModel() {
        return this.define;
    }

    public List<ErrorInfo> getErrors() {
        return this.errors;
    }

    private String concat(String current_text, String new_text) {
        if (StringUtils.isEmpty((CharSequence)current_text)) {
            return new_text;
        }
        return current_text + this.config.valueDelimiter + new_text;
    }
}

