/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer;

import com.fujitsu.tsc.desktop.importer.ExcelWriter2;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class EdtSpecCreator {
    private static final int MAX_ROW_SIZE = 10000;
    private static List<RegexDateMatcher> dateMatchers = new ArrayList<RegexDateMatcher>();
    private static Pattern integerRegex;
    private static Pattern floatRegex;
    private StudyEdtGeneral param;
    private File srcFile;
    private List<String[]> lines = new ArrayList<String[]>();

    public EdtSpecCreator(StudyEdtGeneral param, File srcFile) {
        this.param = param;
        this.srcFile = srcFile;
    }

    public Pair<List<StudyEdtColumn>, List<StudyEdtCodelist>> create() throws IOException, CsvException {
        ArrayList<StudyEdtColumn> rtnColumn = new ArrayList<StudyEdtColumn>();
        ArrayList<StudyEdtCodelist> rtnCodelist = new ArrayList<StudyEdtCodelist>();
        Pair rtn = Pair.of(rtnColumn, rtnCodelist);
        this.lines = EdtSpecCreator.readToStringArray(this.srcFile, this.param.encoding, this.param.delimiter, this.param.text_qualifier);
        ArrayList<Integer> codeColumns = new ArrayList<Integer>();
        for (int i = 0; i < this.columnSize(); ++i) {
            StudyEdtColumn column = new StudyEdtColumn();
            column.column_no = i + 1;
            column.name = this.getColumnName(i);
            if (this.lines != null && this.lines.size() > this.param.header_line) {
                ColumnType columnType = this.getColumnType(i);
                switch (columnType.getType()) {
                    case DATE: {
                        column.date_time_format = columnType.detail;
                        column.unk_date_time_text = StringUtils.defaultString((String)this.searchUnkDateTime(i, columnType.getDetail()));
                        break;
                    }
                    case STRING: 
                    case INTEGER: {
                        codeColumns.add(i);
                        column.controlled_terms = this.getColumnName(i);
                        break;
                    }
                }
            }
            rtnColumn.add(column);
        }
        for (Integer colIndex : codeColumns) {
            LinkedHashSet<String> userCodes = new LinkedHashSet<String>();
            for (int r = this.param.header_line; r < this.lines.size(); ++r) {
                String txt = this.getStr(r, colIndex);
                if (!StringUtils.isNotBlank((CharSequence)txt)) continue;
                userCodes.add(txt);
            }
            for (String userCode : userCodes) {
                StudyEdtCodelist codelist = new StudyEdtCodelist();
                codelist.codelist = codelist.codelist_label = this.getColumnName(colIndex);
                codelist.data_type = this.getColumnType(colIndex).getType() == CType.STRING ? "text" : "integer";
                codelist.submission_value = codelist.user_code = userCode;
                codelist.extended_value = YorN.No;
                rtnCodelist.add(codelist);
            }
        }
        HashSet<String> codelists = new HashSet<String>();
        for (StudyEdtCodelist codelist : rtnCodelist) {
            codelists.add(codelist.codelist);
        }
        for (StudyEdtColumn column : rtnColumn) {
            if (codelists.contains(column.controlled_terms)) continue;
            column.controlled_terms = "";
        }
        return rtn;
    }

    private String getStr(int rowIndex, int colIndex) {
        String rtn = this.lines.get(rowIndex)[colIndex];
        return rtn;
    }

    private String searchUnkDateTime(int columnIdx, String format) {
        List<String> MON = Arrays.asList("JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC");
        RegexDateMatcher matcher = null;
        for (RegexDateMatcher dateMatcher : dateMatchers) {
            if (!dateMatcher.getFormat().equals(format)) continue;
            matcher = dateMatcher;
            break;
        }
        for (int i = this.param.header_line; i < this.lines.size(); ++i) {
            String txt = this.getStr(i, columnIdx);
            if (StringUtils.isEmpty((CharSequence)txt)) continue;
            List<String> strs = matcher.getMatchStrings(txt);
            for (String str : strs) {
                if (StringUtils.isNumeric((CharSequence)str) || MON.contains(str.toUpperCase())) continue;
                return str;
            }
        }
        return null;
    }

    private ColumnType getColumnType(int columnIdx) {
        String txt = this.getStr(this.param.header_line, columnIdx);
        if (integerRegex.matcher(txt).find()) {
            return new ColumnType(CType.INTEGER);
        }
        if (floatRegex.matcher(txt).find()) {
            return new ColumnType(CType.FLOAT);
        }
        for (RegexDateMatcher matcher : dateMatchers) {
            if (!matcher.isMatch(txt)) continue;
            return new ColumnType(CType.DATE, matcher.getFormat());
        }
        return new ColumnType(CType.STRING);
    }

    private String getColumnName(int columnIdx) {
        if (this.param.header_line >= 1) {
            return this.getStr(0, columnIdx);
        }
        return "Column" + columnIdx;
    }

    private int columnSize() {
        return this.lines.get(0).length;
    }

    public static List<String[]> readToStringArray(File srcFile, String encoding, String delimiter, String text_qualifier) throws IOException, CsvException {
        String[] line;
        char separator = ',';
        if (StringUtils.length((CharSequence)delimiter) > 0) {
            separator = "\\t".equals(delimiter) ? (char)'\t' : delimiter.toCharArray()[0];
        }
        char qualifier = '\"';
        qualifier = StringUtils.isEmpty((CharSequence)text_qualifier) || "(None)".equals(text_qualifier) ? (char)'\b' : text_qualifier.toCharArray()[0];
        char escape = '\\';
        CSVParserBuilder builder = new CSVParserBuilder().withSeparator(separator).withQuoteChar(qualifier).withEscapeChar(escape);
        CSVParser parser = builder.build();
        CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader((InputStream)new FileInputStream(srcFile), Charset.forName(encoding))).withCSVParser((ICSVParser)parser).build();
        reader.setErrorLocale(new Locale("en"));
        ArrayList<String[]> rtn = new ArrayList<String[]>();
        for (int i = 0; i < 10000 && (line = reader.readNext()) != null; ++i) {
            rtn.add(line);
        }
        reader.close();
        return rtn;
    }

    static {
        dateMatchers.add(new RegexDateMatcher("^(\\d{4})/(\\d{2})/(\\d{2})$", "YYYY/MM/DD"));
        dateMatchers.add(new RegexDateMatcher("^(\\d{4})/(\\d{2})/(\\d{2}) (\\d{2}):(\\d{2}):(\\d{2})$", "YYYY/MM/DD HH24:MI:SS"));
        dateMatchers.add(new RegexDateMatcher("^(\\d{4})-(\\d{2})-(\\d{2})$", "YYYY-MM-DD"));
        dateMatchers.add(new RegexDateMatcher("^(\\d{4})-(\\d{2})-(\\d{2})\"T\"(\\d{2}):(\\d{2}):(\\d{2})$", "YYYY-MM-DD\"T\"HH24:MI:SS"));
        dateMatchers.add(new RegexDateMatcher("^(\\d{2})(\\D{3})(\\d{4}) (\\d{2}):(\\d{2}):(\\d{2})$", "DDMONYYYY HH24:MI:SS"));
        dateMatchers.add(new RegexDateMatcher("^(\\d{2})(\\D{3})(\\d{4})$", "DDMONYYYY"));
        integerRegex = Pattern.compile("^[1-9]+?\\\\d*?$");
        floatRegex = Pattern.compile("^[+-]?\\d+?\\.\\d+?$");
    }

    public static enum YorN {
        Yes,
        No;

    }

    public class StudyEdtCodelist {
        public String company_id;
        public int dataspec_id;
        public int ordinal;
        @ExcelWriter2.ExcelColumn(name="Codelist ID", ordinal=1)
        public String codelist;
        @ExcelWriter2.ExcelColumn(name="Codelist Code", ordinal=2)
        public String codelist_code;
        @ExcelWriter2.ExcelColumn(name="Codelist Label", ordinal=3)
        public String codelist_label;
        @ExcelWriter2.ExcelColumn(name="DataType", ordinal=4)
        public String data_type;
        @ExcelWriter2.ExcelColumn(name="SASFormatName", ordinal=5)
        public String sas_format_name;
        @ExcelWriter2.ExcelColumn(name="Code", ordinal=6)
        public String code;
        @ExcelWriter2.ExcelColumn(name="User Code", ordinal=7)
        public String user_code;
        @ExcelWriter2.ExcelColumn(name="Order Number", ordinal=10)
        public String order_number;
        @ExcelWriter2.ExcelColumn(name="Rank", ordinal=11)
        public String rank;
        @ExcelWriter2.ExcelColumn(name="ExtendedValue", ordinal=12)
        public YorN extended_value;
        @ExcelWriter2.ExcelColumn(name="Submission Value", ordinal=13)
        public String submission_value;
        @ExcelWriter2.ExcelColumn(name="Decode", ordinal=8)
        public String decode;
        @ExcelWriter2.ExcelColumn(name="xml:lang", ordinal=9)
        public String xml_lang;
        @ExcelWriter2.ExcelColumn(name="Alias Context", ordinal=14)
        public String alias_context;
        @ExcelWriter2.ExcelColumn(name="Alias Name", ordinal=15)
        public String alias_name;
        @ExcelWriter2.ExcelColumn(name="User Note 1", ordinal=16)
        public String user_note1;
        @ExcelWriter2.ExcelColumn(name="User Note 2", ordinal=17)
        public String user_note2;
    }

    public class StudyEdtColumn {
        public String company_id;
        public int dataspec_id;
        @ExcelWriter2.ExcelColumn(name="Column #", ordinal=1)
        public int column_no;
        public int ordinal;
        @ExcelWriter2.ExcelColumn(name="Column Name", ordinal=2)
        public String name;
        @ExcelWriter2.ExcelColumn(name="Column Alias", ordinal=3)
        public String alias;
        @ExcelWriter2.ExcelColumn(name="Source Test Name", ordinal=4)
        public String source_test_name;
        @ExcelWriter2.ExcelColumn(name="Key Sequence", ordinal=5)
        public String key_sequence;
        @ExcelWriter2.ExcelColumn(name="Date/Time Format", ordinal=6)
        public String date_time_format;
        @ExcelWriter2.ExcelColumn(name="Unknown Date/Time Text", ordinal=7)
        public String unk_date_time_text;
        @ExcelWriter2.ExcelColumn(name="Start Position", ordinal=8)
        public Integer start_position;
        @ExcelWriter2.ExcelColumn(name="Width", ordinal=9)
        public Integer width;
        @ExcelWriter2.ExcelColumn(name="Codelist ID", ordinal=10)
        public String controlled_terms;
        @ExcelWriter2.ExcelColumn(name="Inclusion Selection Criteria", ordinal=11)
        public String inclusion_selection_criteria;
        @ExcelWriter2.ExcelColumn(name="Exclusion Selection Criteria", ordinal=12)
        public String exclusion_selection_criteria;
        @ExcelWriter2.ExcelColumn(name="User Note 1", ordinal=13)
        public String user_note1;
        @ExcelWriter2.ExcelColumn(name="User Note 2", ordinal=14)
        public String user_note2;
    }

    public static class StudyEdtGeneral {
        @ExcelWriter2.ExcelColumn(name="Source ID", ordinal=1)
        public String soruce_id;
        @ExcelWriter2.ExcelColumn(name="Source Name", ordinal=2)
        public String soruce_name;
        @ExcelWriter2.ExcelColumn(name="STUDYID", ordinal=3)
        public String study_id;
        @ExcelWriter2.ExcelColumn(name="Type", ordinal=4)
        public String type_id;
        @ExcelWriter2.ExcelColumn(name="# of Header Lines", ordinal=5)
        public int header_line;
        @ExcelWriter2.ExcelColumn(name="Character Encoding", ordinal=6)
        public String encoding;
        @ExcelWriter2.ExcelColumn(name="Delimited/Fixed Width", ordinal=7)
        public String separating_method;
        @ExcelWriter2.ExcelColumn(name="Delimiter", ordinal=8)
        public String delimiter;
        @ExcelWriter2.ExcelColumn(name="Text Qualifier", ordinal=9)
        public String text_qualifier;
        @ExcelWriter2.ExcelColumn(name="User Note 1", ordinal=10)
        public String user_note1;
        @ExcelWriter2.ExcelColumn(name="User Note 2", ordinal=11)
        public String user_note2;
    }

    private static class RegexDateMatcher {
        private Pattern pattern;
        private String format;

        public RegexDateMatcher(String regex, String format) {
            this.format = format;
            this.pattern = Pattern.compile(regex);
        }

        boolean isMatch(String str) {
            return this.pattern.matcher(str).find();
        }

        List<String> getMatchStrings(String str) {
            Matcher matcher = this.pattern.matcher(str);
            ArrayList<String> rtn = new ArrayList<String>();
            boolean res = matcher.find();
            if (res) {
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    rtn.add(matcher.group(i + 1));
                }
            }
            return rtn;
        }

        public String getFormat() {
            return this.format;
        }
    }

    private static enum CType {
        DATE,
        STRING,
        INTEGER,
        FLOAT;

    }

    private class ColumnType {
        private final CType ctype;
        private String detail;

        public ColumnType(CType cType) {
            this.ctype = cType;
        }

        public ColumnType(CType cType, String detail) {
            this.ctype = cType;
            this.detail = detail;
        }

        public CType getType() {
            return this.ctype;
        }

        public String getDetail() {
            return this.detail;
        }
    }
}

