/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;

public class KeyStorage {
    private Hashtable<String, Oid> tableStorage = new Hashtable();
    private ArrayList<String> arrayStorage = new ArrayList();

    public int storageCount() {
        return this.tableStorage.size();
    }

    public boolean storageExists(String storage) {
        return this.tableStorage.containsKey(storage);
    }

    public ArrayList<String> list() {
        return this.arrayStorage;
    }

    public Oid storage(String storage) {
        Oid oids;
        if (this.tableStorage.containsKey(storage)) {
            oids = this.tableStorage.get(storage);
        } else {
            oids = new Oid();
            this.tableStorage.put(storage, oids);
            this.arrayStorage.add(storage);
        }
        return oids;
    }

    public class Oid {
        private Hashtable<String, Members> tableOid = new Hashtable();
        private ArrayList<String> arrayOid = new ArrayList();
        private String lastOid;

        public Oid() {
            this.clearLastOid();
        }

        public void clearLastOid() {
            this.lastOid = null;
        }

        public String getLastOid() {
            return this.lastOid;
        }

        public int oidCount() {
            return this.tableOid.size();
        }

        public boolean oidExists(String oid) {
            return this.tableOid.containsKey(oid);
        }

        public ArrayList<String> oidList() {
            return this.arrayOid;
        }

        public Members oid(String oid) {
            Members members;
            this.lastOid = oid;
            if (this.tableOid.containsKey(oid)) {
                members = this.tableOid.get(oid);
            } else {
                members = new Members();
                this.tableOid.put(oid, members);
                this.arrayOid.add(oid);
            }
            return members;
        }

        public class Members {
            private Hashtable<String, LinkedHashMap<String, String>> tableMembers = new Hashtable();
            private ArrayList<String> arrayMembers = new ArrayList();

            private Members() {
            }

            public int oidCount() {
                return this.tableMembers.size();
            }

            public ArrayList<String> memberList() {
                return this.arrayMembers;
            }

            public ArrayList<String> subkeyList(String member) {
                ArrayList<String> subkeyList = new ArrayList<String>();
                for (String subkey : this.tableMembers.get(member).keySet()) {
                    subkeyList.add(subkey);
                }
                return subkeyList;
            }

            public int subkeyCount(String member) {
                return this.tableMembers.get(member).size();
            }

            public boolean memberExists(String member) {
                return this.tableMembers.containsKey(member);
            }

            public String get(String member) {
                return this.get(member, "");
            }

            public String get(String member, String subkey) {
                String value = "";
                if (this.tableMembers.get(member) != null && this.tableMembers.get(member).get(subkey) != null) {
                    value = this.tableMembers.get(member).get(subkey);
                }
                return value;
            }

            public void put(String key, String value) {
                this.put(key, "", value);
            }

            public void put(String member, String subkey, String value) {
                LinkedHashMap<String, String> valueTable = new LinkedHashMap<String, String>();
                if (this.tableMembers.containsKey(member)) {
                    valueTable = this.tableMembers.get(member);
                }
                valueTable.put(subkey, value);
                this.tableMembers.put(member, valueTable);
                if (!this.arrayMembers.contains(member)) {
                    this.arrayMembers.add(member);
                }
            }

            public void remove(String key) {
                this.tableMembers.remove(key);
                this.arrayMembers.remove(key);
            }
        }
    }
}

