/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer;

import com.fujitsu.tsc.desktop.importer.models.DefineARMDatasetModel;
import com.fujitsu.tsc.desktop.importer.models.DefineARMDisplayModel;
import com.fujitsu.tsc.desktop.importer.models.DefineARMResultModel;
import com.fujitsu.tsc.desktop.importer.models.DefineCodelistModel;
import com.fujitsu.tsc.desktop.importer.models.DefineCommentModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDatasetModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDictionaryModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDocumentModel;
import com.fujitsu.tsc.desktop.importer.models.DefineMethodModel;
import com.fujitsu.tsc.desktop.importer.models.DefineModel;
import com.fujitsu.tsc.desktop.importer.models.DefineStandardModel;
import com.fujitsu.tsc.desktop.importer.models.DefineStudyModel;
import com.fujitsu.tsc.desktop.importer.models.DefineValueModel;
import com.fujitsu.tsc.desktop.importer.models.DefineVariableModel;
import com.fujitsu.tsc.desktop.importer.models.DefineWCModel;
import com.fujitsu.tsc.desktop.util.Config;
import com.fujitsu.tsc.desktop.util.ErrorLog;
import com.fujitsu.tsc.desktop.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class SdtmAdamSpecImporter {
    private Config config;
    private DefineModel define;
    private Workbook workbook;

    public SdtmAdamSpecImporter(Config config, Workbook workbook) {
        this.config = config;
        this.workbook = workbook;
        this.define = new DefineModel();
    }

    public List<ErrorLog> parse() {
        ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
        List<ErrorLog> errors = this.importDocument(this.config.defineDocumentTableName);
        ErrorLog error = errors.stream().filter(o -> o.getErrorLevel() == ErrorLog.ErrorLevel.ERROR).findAny().orElse(null);
        if (error != null) {
            return errors;
        }
        rtn.addAll(errors);
        errors = this.importMethod(this.config.defineMethodTableName);
        error = errors.stream().filter(o -> o.getErrorLevel() == ErrorLog.ErrorLevel.ERROR).findAny().orElse(null);
        if (error != null) {
            return errors;
        }
        rtn.addAll(errors);
        errors = this.importComment(this.config.defineCommentTableName);
        error = errors.stream().filter(o -> o.getErrorLevel() == ErrorLog.ErrorLevel.ERROR).findAny().orElse(null);
        if (error != null) {
            return errors;
        }
        rtn.addAll(errors);
        errors = this.importStudy(this.config.defineStudyTableName);
        error = errors.stream().filter(o -> o.getErrorLevel() == ErrorLog.ErrorLevel.ERROR).findAny().orElse(null);
        if (error != null) {
            return errors;
        }
        rtn.addAll(errors);
        errors = this.importStandard(this.config.defineStandardTableName);
        error = errors.stream().filter(o -> o.getErrorLevel() == ErrorLog.ErrorLevel.ERROR).findAny().orElse(null);
        if (error != null) {
            return errors;
        }
        rtn.addAll(errors);
        errors = this.importDataset(this.config.defineDatasetTableName);
        error = errors.stream().filter(o -> o.getErrorLevel() == ErrorLog.ErrorLevel.ERROR).findAny().orElse(null);
        if (error != null) {
            return errors;
        }
        rtn.addAll(errors);
        errors = this.importCodelist(this.config.defineCodelistTableName);
        error = errors.stream().filter(o -> o.getErrorLevel() == ErrorLog.ErrorLevel.ERROR).findAny().orElse(null);
        if (error != null) {
            return errors;
        }
        errors.addAll(this.checkCodelistDecode());
        rtn.addAll(errors);
        errors = this.importDictionary(this.config.defineDictionaryTableName);
        error = errors.stream().filter(o -> o.getErrorLevel() == ErrorLog.ErrorLevel.ERROR).findAny().orElse(null);
        if (error != null) {
            return errors;
        }
        rtn.addAll(errors);
        errors = this.importVariable(this.config.defineVariableTableName);
        error = errors.stream().filter(o -> o.getErrorLevel() == ErrorLog.ErrorLevel.ERROR).findAny().orElse(null);
        if (error != null) {
            return errors;
        }
        rtn.addAll(errors);
        errors = this.importValue(this.config.defineValueTableName);
        error = errors.stream().filter(o -> o.getErrorLevel() == ErrorLog.ErrorLevel.ERROR).findAny().orElse(null);
        if (error != null) {
            return errors;
        }
        rtn.addAll(errors);
        if (this.config.e2dDatasetType.equals((Object)Config.DatasetType.ADaM) && this.config.e2dIncludeResultMetadata) {
            errors = this.importArmDisplay(this.config.defineResult1TableName);
            error = errors.stream().filter(o -> o.getErrorLevel() == ErrorLog.ErrorLevel.ERROR).findAny().orElse(null);
            if (error != null) {
                return errors;
            }
            rtn.addAll(errors);
            errors = this.importArmDataset(this.config.defineResult2TableName);
            error = errors.stream().filter(o -> o.getErrorLevel() == ErrorLog.ErrorLevel.ERROR).findAny().orElse(null);
            if (error != null) {
                return errors;
            }
            rtn.addAll(errors);
        }
        this.define.updateHasSupp();
        this.define.processRepeatN(this.config.e2dDatasetType);
        this.define.updateVariableOrdinal();
        return rtn;
    }

    List<ErrorLog> importDocument(String sheet_name) {
        HorizontalExcelSheet excel_sheet = new HorizontalExcelSheet(sheet_name, true, new ExcelColumn[]{new ExcelColumn("ID", true), new ExcelColumn("Type", true), new ExcelColumn("href", true), new ExcelColumn("Title", true), new ExcelColumn("User Note 1", false), new ExcelColumn("User Note 2", false)});
        List<ErrorLog> errors = excel_sheet.validate();
        if (!errors.isEmpty()) {
            return errors;
        }
        Function<ExcelRow, List<ErrorLog>> binder = new Function<ExcelRow, List<ErrorLog>>(){
            int ordinal = 1;

            @Override
            public List<ErrorLog> apply(ExcelRow cells) {
                ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
                String document_id = ExcelCell.getAsString(cells.get("ID"));
                if (StringUtils.isEmpty((CharSequence)document_id)) {
                    String message = "The 'ID' column is required and cannot be empty. Skipping the row...";
                    ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                    error.setColumnName("ID");
                    rtn.add(error);
                    return rtn;
                }
                DefineDocumentModel.DefineDocumentPk pk = new DefineDocumentModel.DefineDocumentPk(document_id);
                DefineDocumentModel document2 = SdtmAdamSpecImporter.this.define.get(pk);
                if (document2 != null) {
                    String message = "The row (" + document_id + ") is duplicated. Skipping the row...";
                    ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                    rtn.add(error);
                    return rtn;
                }
                DefineDocumentModel document = new DefineDocumentModel(pk);
                document.document_type = DefineModel.DocType.parse(ExcelCell.getAsString(cells.get("Type")));
                document.document_href = ExcelCell.getAsString(cells.get("href"));
                document.document_title = ExcelCell.getAsString(cells.get("Title"));
                document.ordinal = this.ordinal++;
                document.user_note1 = ExcelCell.getAsString(cells.get("User Note 1"));
                document.user_note2 = ExcelCell.getAsString(cells.get("User Note 2"));
                SdtmAdamSpecImporter.this.define.put(pk, document);
                return rtn;
            }
        };
        return excel_sheet.doImport(binder);
    }

    List<ErrorLog> importMethod(String sheet_name) {
        HorizontalExcelSheet excel_sheet = new HorizontalExcelSheet(sheet_name, true, new ExcelColumn[]{new ExcelColumn("OID", true), new ExcelColumn("Name", true), new ExcelColumn("Type", true), new ExcelColumn("Description", true), new ExcelColumn("Language", false), new ExcelColumn("DocumentID", false), new ExcelColumn("Document Page Type", false), new ExcelColumn("Document Page Reference", false), new ExcelColumn("Document First Page", false), new ExcelColumn("Document Last Page", false), new ExcelColumn("Document Page Title", false), new ExcelColumn("FormalExpression Context", false), new ExcelColumn("FormalExpression Text", false), new ExcelColumn("User Note 1", false), new ExcelColumn("User Note 2", false)});
        if (!excel_sheet.exists()) {
            return new ArrayList<ErrorLog>();
        }
        List<ErrorLog> errors = excel_sheet.validate();
        if (!errors.isEmpty()) {
            return errors;
        }
        Function<ExcelRow, List<ErrorLog>> binder = new Function<ExcelRow, List<ErrorLog>>(){
            int ordinal = 1;

            @Override
            public List<ErrorLog> apply(ExcelRow cells) {
                ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
                String method_oid = ExcelCell.getAsString(cells.get("OID"));
                if (StringUtils.isEmpty((CharSequence)method_oid)) {
                    String message = "The 'OID' column is required and cannot be empty. Skipping the row...";
                    ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                    error.setColumnName("OID");
                    rtn.add(error);
                    return rtn;
                }
                DefineMethodModel.DefineMethodPk pk = new DefineMethodModel.DefineMethodPk(method_oid);
                DefineMethodModel method2 = SdtmAdamSpecImporter.this.define.get(pk);
                if (method2 != null) {
                    String message = "The row (" + method_oid + ") is duplicated. Skipping the row...";
                    ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                    rtn.add(error);
                    return rtn;
                }
                DefineMethodModel method = new DefineMethodModel(pk);
                method.ordinal = this.ordinal++;
                method.method_name = ExcelCell.getAsString(cells.get("Name"));
                method.method_type = ExcelCell.getAsString(cells.get("Type"));
                method.description = ExcelCell.getAsString(cells.get("Description"));
                String description_lang = ExcelCell.getAsString(cells.get("Language"));
                if (StringUtils.isEmpty((CharSequence)description_lang)) {
                    description_lang = ExcelCell.getAsString(cells.get("xml:lang"));
                }
                method.description_lang = description_lang;
                List<String> document_ids = Utils.split(ExcelCell.getAsString(cells.get("DocumentID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> document_page_types = Utils.split(ExcelCell.getAsString(cells.get("Document Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> document_page_references = Utils.split(ExcelCell.getAsString(cells.get("Document Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> document_first_pages = Utils.split(ExcelCell.getAsString(cells.get("Document First Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> document_last_pages = Utils.split(ExcelCell.getAsString(cells.get("Document Last Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> document_page_titles = Utils.split(ExcelCell.getAsString(cells.get("Document Page Title")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List document_refs = SdtmAdamSpecImporter.this.createDocumentRefs(rtn, document_ids, document_page_types, document_page_references, document_first_pages, document_last_pages, document_page_titles);
                method.document_refs.addAll(document_refs);
                method.formal_expression_context = ExcelCell.getAsString(cells.get("FormalExpression Context"));
                method.formal_expression = ExcelCell.getAsString(cells.get("FormalExpression Text"));
                if (StringUtils.isEmpty((CharSequence)method.formal_expression_context) && StringUtils.isNotEmpty((CharSequence)method.formal_expression) || StringUtils.isNotEmpty((CharSequence)method.formal_expression_context) && StringUtils.isEmpty((CharSequence)method.formal_expression)) {
                    String message = "'FormalExpression Context' and 'FormalExpression Text' columns must be both empty or both entered. They are ignored.";
                    ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                    error.setColumnName("FormalExpression Context, FormalExpression Text");
                    rtn.add(error);
                }
                method.user_note1 = ExcelCell.getAsString(cells.get("User Note 1"));
                method.user_note2 = ExcelCell.getAsString(cells.get("User Note 2"));
                SdtmAdamSpecImporter.this.define.put(pk, method);
                return rtn;
            }
        };
        return excel_sheet.doImport(binder);
    }

    List<ErrorLog> importComment(String sheet_name) {
        HorizontalExcelSheet excel_sheet = new HorizontalExcelSheet(sheet_name, true, new ExcelColumn[]{new ExcelColumn("OID", true), new ExcelColumn("Comment", true), new ExcelColumn("Language", false), new ExcelColumn("DocumentID", false), new ExcelColumn("Document Page Type", false), new ExcelColumn("Document Page Reference", false), new ExcelColumn("Document First Page", false), new ExcelColumn("Document Last Page", false), new ExcelColumn("Document Page Title", false), new ExcelColumn("User Note 1", false), new ExcelColumn("User Note 2", false)});
        if (!excel_sheet.exists()) {
            return new ArrayList<ErrorLog>();
        }
        List<ErrorLog> errors = excel_sheet.validate();
        if (!errors.isEmpty()) {
            return errors;
        }
        Function<ExcelRow, List<ErrorLog>> binder = new Function<ExcelRow, List<ErrorLog>>(){
            int ordinal = 1;

            @Override
            public List<ErrorLog> apply(ExcelRow cells) {
                ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
                String comment_oid = ExcelCell.getAsString(cells.get("OID"));
                if (StringUtils.isEmpty((CharSequence)comment_oid)) {
                    String message = "The 'OID' column is required and cannot be empty. Skipping the row...";
                    ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                    error.setColumnName("OID");
                    rtn.add(error);
                    return rtn;
                }
                DefineCommentModel.DefineCommentPk pk = new DefineCommentModel.DefineCommentPk(comment_oid);
                DefineCommentModel comment2 = SdtmAdamSpecImporter.this.define.get(pk);
                if (comment2 != null) {
                    String message = "The row (" + comment_oid + ") is duplicated. Skipping the row...";
                    ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                    rtn.add(error);
                    return rtn;
                }
                DefineCommentModel comment = new DefineCommentModel(pk);
                comment.ordinal = this.ordinal++;
                comment.comment_text = ExcelCell.getAsString(cells.get("Comment"));
                comment.comment_lang = ExcelCell.getAsString(cells.get("Language"));
                List<String> document_ids = Utils.split(ExcelCell.getAsString(cells.get("DocumentID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> document_page_types = Utils.split(ExcelCell.getAsString(cells.get("Document Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> document_page_references = Utils.split(ExcelCell.getAsString(cells.get("Document Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> document_first_pages = Utils.split(ExcelCell.getAsString(cells.get("Document First Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> document_last_pages = Utils.split(ExcelCell.getAsString(cells.get("Document Last Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> document_page_titles = Utils.split(ExcelCell.getAsString(cells.get("Document Page Title")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List document_refs = SdtmAdamSpecImporter.this.createDocumentRefs(rtn, document_ids, document_page_types, document_page_references, document_first_pages, document_last_pages, document_page_titles);
                comment.document_refs.addAll(document_refs);
                comment.user_note1 = ExcelCell.getAsString(cells.get("User Note 1"));
                comment.user_note2 = ExcelCell.getAsString(cells.get("User Note 2"));
                SdtmAdamSpecImporter.this.define.put(pk, comment);
                return rtn;
            }
        };
        return excel_sheet.doImport(binder);
    }

    List<ErrorLog> importStudy(String sheet_name) {
        VerticalExcelSheet excel_sheet = new VerticalExcelSheet(sheet_name, true, new ExcelColumn[]{new ExcelColumn("ODMVersion", false), new ExcelColumn("FileType", false), new ExcelColumn("FileOID", false), new ExcelColumn("AsOfDateTime", false), new ExcelColumn("Originator", false), new ExcelColumn("Context", false), new ExcelColumn("StudyOID", false), new ExcelColumn("StudyName", true), new ExcelColumn("StudyDescription", true), new ExcelColumn("ProtocolName", true), new ExcelColumn("MetaDataOID", false), new ExcelColumn("MetaDataName", false), new ExcelColumn("MetaDataDescription", false), new ExcelColumn("DefineVersion", true), new ExcelColumn("StandardName", false), new ExcelColumn("StandardVersion", false), new ExcelColumn("CommentOID", false), new ExcelColumn("Comment", false), new ExcelColumn("Language", false), new ExcelColumn("xml:lang", false), new ExcelColumn("DocumentID", false), new ExcelColumn("Document Page Type", false), new ExcelColumn("Document Page Reference", false), new ExcelColumn("Document First Page", false), new ExcelColumn("Document Last Page", false), new ExcelColumn("Document Page Title", false), new ExcelColumn("User Note 1", false), new ExcelColumn("User Note 2", false)});
        List<ErrorLog> errors = excel_sheet.validate();
        if (!errors.isEmpty()) {
            return errors;
        }
        Function<ExcelRow, List<ErrorLog>> binder = new Function<ExcelRow, List<ErrorLog>>(){

            @Override
            public List<ErrorLog> apply(ExcelRow cells) {
                ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
                DefineStudyModel study = new DefineStudyModel();
                study.file_oid = ExcelCell.getAsString(cells.get("FileOID"));
                study.as_of_date_time = ExcelCell.getAsString(cells.get("AsOfDateTime"));
                study.originator = ExcelCell.getAsString(cells.get("Originator"));
                String context = ExcelCell.getAsString(cells.get("Context"));
                study.context = StringUtils.isEmpty((CharSequence)context) ? "Submission" : context;
                study.study_oid = ExcelCell.getAsString(cells.get("StudyOID"));
                study.study_name = ExcelCell.getAsString(cells.get("StudyName"));
                study.study_description = ExcelCell.getAsString(cells.get("StudyDescription"));
                study.protocol_name = ExcelCell.getAsString(cells.get("ProtocolName"));
                study.metadata_oid = ExcelCell.getAsString(cells.get("MetaDataOID"));
                study.metadata_name = ExcelCell.getAsString(cells.get("MetaDataName"));
                study.metadata_description = ExcelCell.getAsString(cells.get("MetaDataDescription"));
                study.define_version = ExcelCell.getAsString(cells.get("DefineVersion"));
                study.standard_name = ExcelCell.getAsString(cells.get("StandardName"));
                study.standard_version = ExcelCell.getAsString(cells.get("StandardVersion"));
                String comment_oid = ExcelCell.getAsString(cells.get("CommentOID"));
                String str_comment = ExcelCell.getAsString(cells.get("Comment"));
                if (!"2.0.0".equals(((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.e2dDefineVersion)) {
                    if (StringUtils.isNotEmpty((CharSequence)comment_oid)) {
                        study.comment_oid = comment_oid;
                        if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                            String message = "Either of the 'CommentOID' or 'Comment' column can be entered. The 'Comment' and associated information is ignored.";
                            ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                            error.setColumnName("Comment");
                            rtn.add(error);
                        }
                    } else if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                        study.comment_oid = DefineCommentModel.createCommentOID(study);
                        DefineCommentModel.DefineCommentPk comment_pk = new DefineCommentModel.DefineCommentPk(study.comment_oid);
                        DefineCommentModel comment = new DefineCommentModel(comment_pk);
                        comment.comment_text = str_comment;
                        String comment_lang = ExcelCell.getAsString(cells.get("Language"));
                        if (StringUtils.isEmpty((CharSequence)comment_lang)) {
                            comment_lang = ExcelCell.getAsString(cells.get("xml:lang"));
                        }
                        comment.comment_lang = comment_lang;
                        List<String> document_ids = Utils.split(ExcelCell.getAsString(cells.get("DocumentID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List<String> document_page_types = Utils.split(ExcelCell.getAsString(cells.get("Document Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List<String> document_page_references = Utils.split(ExcelCell.getAsString(cells.get("Document Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List<String> document_first_pages = Utils.split(ExcelCell.getAsString(cells.get("Document First Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List<String> document_last_pages = Utils.split(ExcelCell.getAsString(cells.get("Document Last Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List<String> document_page_titles = Utils.split(ExcelCell.getAsString(cells.get("Document Page Title")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List document_refs = SdtmAdamSpecImporter.this.createDocumentRefs(rtn, document_ids, document_page_types, document_page_references, document_first_pages, document_last_pages, document_page_titles);
                        comment.document_refs.addAll(document_refs);
                        SdtmAdamSpecImporter.this.define.put(comment_pk, comment);
                    } else {
                        String document_id = ExcelCell.getAsString(cells.get("DocumentID"));
                        if (StringUtils.isNotEmpty((CharSequence)document_id)) {
                            String message = "The 'Comment' column is required when 'DocumentID' is entered. The 'DocumentID' and associated information is ignored.";
                            ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                            error.setColumnName("Comment");
                            rtn.add(error);
                        }
                    }
                }
                study.user_note1 = ExcelCell.getAsString(cells.get("User Note 1"));
                study.user_note2 = ExcelCell.getAsString(cells.get("User Note 2"));
                SdtmAdamSpecImporter.this.define.put(study);
                return rtn;
            }
        };
        return excel_sheet.doImport(binder);
    }

    List<ErrorLog> importStandard(String sheet_name) {
        HorizontalExcelSheet excel_sheet = new HorizontalExcelSheet(sheet_name, true, new ExcelColumn[]{new ExcelColumn("Name", true), new ExcelColumn("Type", true), new ExcelColumn("Publishing Set", true), new ExcelColumn("Version", true), new ExcelColumn("Status", true), new ExcelColumn("CommentOID", false), new ExcelColumn("Comment", false), new ExcelColumn("Language", false), new ExcelColumn("xml:lang", false), new ExcelColumn("DocumentID", false), new ExcelColumn("Document Page Type", false), new ExcelColumn("Document Page Reference", false), new ExcelColumn("Document First Page", false), new ExcelColumn("Document Last Page", false), new ExcelColumn("Document Page Title", false), new ExcelColumn("User Note 1", false), new ExcelColumn("User Note 2", false)});
        if (!excel_sheet.exists()) {
            return new ArrayList<ErrorLog>();
        }
        List<ErrorLog> errors = excel_sheet.validate();
        if (!errors.isEmpty()) {
            return errors;
        }
        Function<ExcelRow, List<ErrorLog>> binder = new Function<ExcelRow, List<ErrorLog>>(){
            int ordinal = 1;

            @Override
            public List<ErrorLog> apply(ExcelRow cells) {
                ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
                String standard_name = ExcelCell.getAsString(cells.get("Name"));
                String standard_version = ExcelCell.getAsString(cells.get("Version"));
                String publishing_set = ExcelCell.getAsString(cells.get("Publishing Set"));
                if (StringUtils.isEmpty((CharSequence)standard_name) || StringUtils.isEmpty((CharSequence)standard_version)) {
                    String message = "The 'Name' and 'Version' columns are required and cannot be empty. Skipping the row...";
                    ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                    rtn.add(error);
                    return rtn;
                }
                DefineStandardModel.DefineStandardPk pk = new DefineStandardModel.DefineStandardPk(DefineStandardModel.createOid(standard_name, standard_version, publishing_set));
                DefineStandardModel standard2 = SdtmAdamSpecImporter.this.define.get(pk);
                if (standard2 != null) {
                    String message = "The row (" + standard_name + "/" + standard_version + ") is duplicated. Skipping the row...";
                    ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                    rtn.add(error);
                    return rtn;
                }
                DefineStandardModel standard = new DefineStandardModel(pk);
                standard.standard_name = standard_name;
                standard.standard_version = standard_version;
                standard.publishing_set = publishing_set;
                standard.standard_type = DefineStandardModel.StandardType.parse(ExcelCell.getAsString(cells.get("Type")));
                standard.standard_status = ExcelCell.getAsString(cells.get("Status"));
                standard.ordinal = this.ordinal++;
                String comment_oid = ExcelCell.getAsString(cells.get("CommentOID"));
                String str_comment = ExcelCell.getAsString(cells.get("Comment"));
                if (StringUtils.isNotEmpty((CharSequence)comment_oid)) {
                    ErrorLog error;
                    String message;
                    DefineCommentModel comment = SdtmAdamSpecImporter.this.define.listSortedComment().stream().filter(o -> StringUtils.equals((CharSequence)o.oid, (CharSequence)comment_oid)).findFirst().orElse(null);
                    if (comment == null) {
                        message = "The 'CommentOID' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineCommentTableName + " sheet. The 'CommentOID' is ignored.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("CommentOID");
                        rtn.add(error);
                    } else {
                        standard.comment_oid = comment_oid;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                        message = "Either of the 'CommentOID' or 'Comment' column can be entered. The 'Comment' and associated information is ignored.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("Comment");
                        rtn.add(error);
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                    standard.comment_oid = DefineCommentModel.createCommentOID(standard);
                    DefineCommentModel.DefineCommentPk comment_pk = new DefineCommentModel.DefineCommentPk(standard.comment_oid);
                    DefineCommentModel comment = new DefineCommentModel(comment_pk);
                    comment.comment_text = str_comment;
                    String comment_lang = ExcelCell.getAsString(cells.get("Language"));
                    if (StringUtils.isEmpty((CharSequence)comment_lang)) {
                        comment_lang = ExcelCell.getAsString(cells.get("xml:lang"));
                    }
                    comment.comment_lang = comment_lang;
                    List<String> document_ids = Utils.split(ExcelCell.getAsString(cells.get("DocumentID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_types = Utils.split(ExcelCell.getAsString(cells.get("Document Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_references = Utils.split(ExcelCell.getAsString(cells.get("Document Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_first_pages = Utils.split(ExcelCell.getAsString(cells.get("Document First Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_last_pages = Utils.split(ExcelCell.getAsString(cells.get("Document Last Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_titles = Utils.split(ExcelCell.getAsString(cells.get("Document Page Title")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List document_refs = SdtmAdamSpecImporter.this.createDocumentRefs(rtn, document_ids, document_page_types, document_page_references, document_first_pages, document_last_pages, document_page_titles);
                    comment.document_refs.addAll(document_refs);
                    SdtmAdamSpecImporter.this.define.put(comment_pk, comment);
                } else {
                    String document_id = ExcelCell.getAsString(cells.get("DocumentID"));
                    if (StringUtils.isNotEmpty((CharSequence)document_id)) {
                        String message = "The 'Comment' column is required when 'DocumentID' is entered. The 'DocumentID' and associated information is ignored.";
                        ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("Comment");
                        rtn.add(error);
                    }
                }
                standard.user_note1 = ExcelCell.getAsString(cells.get("User Note 1"));
                standard.user_note2 = ExcelCell.getAsString(cells.get("User Note 2"));
                SdtmAdamSpecImporter.this.define.put(pk, standard);
                return rtn;
            }
        };
        return excel_sheet.doImport(binder);
    }

    List<ErrorLog> importDataset(String sheet_name) {
        HorizontalExcelSheet excel_sheet = new HorizontalExcelSheet(sheet_name, true, new ExcelColumn[]{new ExcelColumn("Domain", false), new ExcelColumn("Dataset Name", true), new ExcelColumn("Description", true), new ExcelColumn("TranslatedText", false), new ExcelColumn("No Data", false), new ExcelColumn("SASDatasetName", false), new ExcelColumn("Repeating", true), new ExcelColumn("IsReferenceData", true), new ExcelColumn("Purpose", true), new ExcelColumn("Standard", false), new ExcelColumn("Structure", true), new ExcelColumn("Class", true), new ExcelColumn("Subclass", false), new ExcelColumn("CommentOID", false), new ExcelColumn("Comment", false), new ExcelColumn("Language", false), new ExcelColumn("xml:lang", false), new ExcelColumn("DocumentID", false), new ExcelColumn("Document Page Type", false), new ExcelColumn("Document Page Reference", false), new ExcelColumn("Document First Page", false), new ExcelColumn("Document Last Page", false), new ExcelColumn("Document Page Title", false), new ExcelColumn("Alias", false), new ExcelColumn("Leaf href", false), new ExcelColumn("href", false), new ExcelColumn("Leaf Title", false), new ExcelColumn("Title", false), new ExcelColumn("User Note 1", false), new ExcelColumn("User Note 2", false)});
        List<ErrorLog> errors = excel_sheet.validate();
        if (!errors.isEmpty()) {
            return errors;
        }
        Function<ExcelRow, List<ErrorLog>> binder = new Function<ExcelRow, List<ErrorLog>>(){
            int ordinal = 1;

            @Override
            public List<ErrorLog> apply(ExcelRow cells) {
                ErrorLog error;
                String message;
                String str_standard;
                ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
                String dataset_name = ExcelCell.getAsString(cells.get("Dataset Name"));
                if (StringUtils.isEmpty((CharSequence)dataset_name)) {
                    ErrorLog error2 = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'Dataset Name' column is required and cannot be empty. Skipping the row...");
                    error2.setColumnName("Dataset Name");
                    rtn.add(error2);
                    return rtn;
                }
                DefineDatasetModel.DefineDatasetPk pk = new DefineDatasetModel.DefineDatasetPk(dataset_name);
                DefineDatasetModel dataset2 = SdtmAdamSpecImporter.this.define.get(pk);
                if (dataset2 != null) {
                    String message2 = "The row (" + dataset_name + ") is duplicated. Skipping the row...";
                    ErrorLog error3 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message2);
                    rtn.add(error3);
                    return rtn;
                }
                DefineDatasetModel dataset = new DefineDatasetModel(pk);
                String domain = ExcelCell.getAsString(cells.get("Domain"));
                if (((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.e2dDatasetType != Config.DatasetType.ADaM) {
                    dataset.domain = StringUtils.isEmpty((CharSequence)domain) ? Utils.deriveDomain(((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.e2dDatasetType, dataset_name) : domain;
                }
                dataset.ordinal = this.ordinal++;
                dataset.description = ExcelCell.getAsString(cells.get("Description"));
                if (StringUtils.isEmpty((CharSequence)dataset.description)) {
                    dataset.description = ExcelCell.getAsString(cells.get("TranslatedText"));
                }
                dataset.has_no_data = DefineModel.YorNull.parse(ExcelCell.getAsString(cells.get("No Data")));
                String sas_dataset_name = ExcelCell.getAsString(cells.get("SASDatasetName"));
                if (StringUtils.isEmpty((CharSequence)sas_dataset_name)) {
                    sas_dataset_name = dataset.dataset_name;
                }
                dataset.sas_dataset_name = sas_dataset_name;
                dataset.repeating = DefineModel.YorN.parse(ExcelCell.getAsString(cells.get("Repeating")));
                dataset.is_reference_data = DefineModel.YorN.parse(ExcelCell.getAsString(cells.get("IsReferenceData")));
                dataset.purpose = ExcelCell.getAsString(cells.get("Purpose"));
                if (!"2.0.0".equals(((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.e2dDefineVersion) && StringUtils.isNotEmpty((CharSequence)(str_standard = ExcelCell.getAsString(cells.get("Standard"))))) {
                    String standard_oid = "";
                    List<DefineStandardModel> standards = SdtmAdamSpecImporter.this.define.listSortedStandard();
                    for (DefineStandardModel standard : standards) {
                        String standard_id2;
                        String standard_id1;
                        if (standard.standard_type != DefineStandardModel.StandardType.IG || !(standard_id1 = Utils.codedText(standard.standard_name + standard.standard_version).toLowerCase()).equals(standard_id2 = Utils.codedText(str_standard).toLowerCase())) continue;
                        standard_oid = standard.toOid();
                        break;
                    }
                    if (StringUtils.isEmpty((CharSequence)standard_oid)) {
                        message = "The value in the 'Standard' column is ignored because it is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineStandardTableName + " sheet. Check if both Standard Name and Standard Version are entered.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("Standard");
                        rtn.add(error);
                    } else {
                        dataset.standard_oid = standard_oid;
                    }
                }
                dataset.structure = ExcelCell.getAsString(cells.get("Structure"));
                dataset.dataset_class = ExcelCell.getAsString(cells.get("Class"));
                dataset.dataset_subclass = ExcelCell.getAsString(cells.get("Subclass"));
                String comment_oid = ExcelCell.getAsString(cells.get("CommentOID"));
                String str_comment = ExcelCell.getAsString(cells.get("Comment"));
                if (StringUtils.isNotEmpty((CharSequence)comment_oid)) {
                    DefineCommentModel comment = SdtmAdamSpecImporter.this.define.listSortedComment().stream().filter(o -> StringUtils.equals((CharSequence)o.oid, (CharSequence)comment_oid)).findFirst().orElse(null);
                    if (comment == null) {
                        message = "The 'CommentOID' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineCommentTableName + " sheet. The 'CommentOID' is ignored.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("CommentOID");
                        rtn.add(error);
                    } else {
                        dataset.comment_oid = comment_oid;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                        message = "Either of the 'CommentOID' or 'Comment' column can be entered. The 'Comment' and associated information is ignored.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("Comment");
                        rtn.add(error);
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                    dataset.comment_oid = DefineCommentModel.createCommentOID(dataset);
                    DefineCommentModel.DefineCommentPk comment_pk = new DefineCommentModel.DefineCommentPk(dataset.comment_oid);
                    DefineCommentModel comment = new DefineCommentModel(comment_pk);
                    comment.comment_text = str_comment;
                    String comment_lang = ExcelCell.getAsString(cells.get("Language"));
                    if (StringUtils.isEmpty((CharSequence)comment_lang)) {
                        comment_lang = ExcelCell.getAsString(cells.get("xml:lang"));
                    }
                    comment.comment_lang = comment_lang;
                    List<String> document_ids = Utils.split(ExcelCell.getAsString(cells.get("DocumentID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_types = Utils.split(ExcelCell.getAsString(cells.get("Document Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_references = Utils.split(ExcelCell.getAsString(cells.get("Document Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_first_pages = Utils.split(ExcelCell.getAsString(cells.get("Document First Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_last_pages = Utils.split(ExcelCell.getAsString(cells.get("Document Last Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_titles = Utils.split(ExcelCell.getAsString(cells.get("Document Page Title")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List document_refs = SdtmAdamSpecImporter.this.createDocumentRefs(rtn, document_ids, document_page_types, document_page_references, document_first_pages, document_last_pages, document_page_titles);
                    comment.document_refs.addAll(document_refs);
                    SdtmAdamSpecImporter.this.define.put(comment_pk, comment);
                } else {
                    String document_id = ExcelCell.getAsString(cells.get("DocumentID"));
                    if (StringUtils.isNotEmpty((CharSequence)document_id)) {
                        message = "The 'Comment' column is required when 'DocumentID' is entered. The 'DocumentID' and associated information is ignored.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("Comment");
                        rtn.add(error);
                    }
                }
                dataset.alias_name = ExcelCell.getAsString(cells.get("Alias"));
                String leaf_href = ExcelCell.getAsString(cells.get("Leaf href"));
                if (StringUtils.isEmpty((CharSequence)leaf_href)) {
                    leaf_href = ExcelCell.getAsString(cells.get("href"));
                }
                if (StringUtils.isEmpty((CharSequence)leaf_href)) {
                    leaf_href = StringUtils.lowerCase((String)dataset.dataset_name) + ".xpt";
                }
                dataset.leaf_href = leaf_href;
                String leaf_title = ExcelCell.getAsString(cells.get("Leaf Title"));
                if (StringUtils.isEmpty((CharSequence)leaf_title)) {
                    leaf_title = ExcelCell.getAsString(cells.get("Title"));
                }
                if (StringUtils.isEmpty((CharSequence)leaf_title)) {
                    leaf_title = leaf_href;
                }
                dataset.leaf_title = leaf_title;
                dataset.user_note1 = ExcelCell.getAsString(cells.get("User Note 1"));
                dataset.user_note2 = ExcelCell.getAsString(cells.get("User Note 2"));
                SdtmAdamSpecImporter.this.define.put(pk, dataset);
                return rtn;
            }
        };
        return excel_sheet.doImport(binder);
    }

    List<ErrorLog> importCodelist(String sheet_name) {
        HorizontalExcelSheet excel_sheet = new HorizontalExcelSheet(sheet_name, true, new ExcelColumn[]{new ExcelColumn("Codelist ID", true), new ExcelColumn("Codelist Code", true), new ExcelColumn("Codelist Label", true), new ExcelColumn("DataType", true), new ExcelColumn("SASFormatName", true), new ExcelColumn("Standard", false), new ExcelColumn("CommentOID", false), new ExcelColumn("Comment", false), new ExcelColumn("Language", false), new ExcelColumn("DocumentID", false), new ExcelColumn("Document Page Type", false), new ExcelColumn("Document Page Reference", false), new ExcelColumn("Document First Page", false), new ExcelColumn("Document Last Page", false), new ExcelColumn("Document Page Title", false), new ExcelColumn("Code", true), new ExcelColumn("User Code", false), new ExcelColumn("Order Number", true), new ExcelColumn("Rank", true), new ExcelColumn("ExtendedValue", true), new ExcelColumn("Submission Value", true), new ExcelColumn("Decode", true), new ExcelColumn("Translated Text", false), new ExcelColumn("Decode Language", false), new ExcelColumn("xml:lang", false), new ExcelColumn("Alias Context", false), new ExcelColumn("Alias Name", false), new ExcelColumn("User Note 1", true), new ExcelColumn("User Note 2", true)});
        List<ErrorLog> errors = excel_sheet.validate();
        if (!errors.isEmpty()) {
            return errors;
        }
        Function<ExcelRow, List<ErrorLog>> binder = new Function<ExcelRow, List<ErrorLog>>(){
            String last_codelist_id = "";
            int ordinal = 1;

            @Override
            public List<ErrorLog> apply(ExcelRow cells) {
                ErrorLog error;
                String message;
                ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
                String codelist_id = ExcelCell.getAsString(cells.get("Codelist ID"));
                if (StringUtils.isEmpty((CharSequence)codelist_id)) {
                    String message2 = "The 'Codelist ID' column is required and cannot be empty. Skipping the row...";
                    ErrorLog error2 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message2);
                    error2.setColumnName("Codelist ID");
                    rtn.add(error2);
                    return rtn;
                }
                String submission_value = ExcelCell.getAsString(cells.get("Submission Value"));
                if (StringUtils.isEmpty((CharSequence)submission_value)) {
                    String message3 = "The 'Submission Value' column is required and cannot be empty. Skipping the row...";
                    ErrorLog error3 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message3);
                    error3.setColumnName("Submission Value");
                    rtn.add(error3);
                    return rtn;
                }
                DefineCodelistModel.DefineCodelistPk pk = new DefineCodelistModel.DefineCodelistPk(codelist_id, submission_value);
                DefineCodelistModel codelist_item2 = SdtmAdamSpecImporter.this.define.get(pk);
                if (codelist_item2 != null) {
                    String message4 = "The row (" + codelist_id + "/" + submission_value + ") is duplicated. Skipping the row...";
                    ErrorLog error4 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message4);
                    rtn.add(error4);
                    return rtn;
                }
                DefineCodelistModel codelist_item = new DefineCodelistModel(pk);
                if (StringUtils.equals((CharSequence)codelist_item.codelist_id, (CharSequence)this.last_codelist_id)) {
                    codelist_item.ordinal = this.ordinal++;
                } else {
                    codelist_item.ordinal = 1;
                    this.last_codelist_id = codelist_item.codelist_id;
                }
                codelist_item.codelist_code = ExcelCell.getAsString(cells.get("Codelist Code"));
                codelist_item.codelist_label = ExcelCell.getAsString(cells.get("Codelist Label"));
                codelist_item.data_type = ExcelCell.getAsString(cells.get("DataType"));
                codelist_item.sas_format_name = ExcelCell.getAsString(cells.get("SASFormatName"));
                if (!"2.0.0".equals(((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.e2dDefineVersion)) {
                    String str_standard = ExcelCell.getAsString(cells.get("Standard"));
                    if (StringUtils.isEmpty((CharSequence)codelist_item.codelist_code)) {
                        if (StringUtils.isNotEmpty((CharSequence)str_standard)) {
                            String message5 = "The 'Standard' column is ignored because 'Codelist Code' is empty (indicating Non Standard).";
                            ErrorLog error5 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message5);
                            error5.setColumnName("Standard");
                            rtn.add(error5);
                        }
                    } else if (StringUtils.isEmpty((CharSequence)str_standard)) {
                        List standards = SdtmAdamSpecImporter.this.define.listSortedStandard().stream().filter(o -> o.standard_type == DefineStandardModel.StandardType.CT && !"DEFINE-XML".equals(o.publishing_set)).collect(Collectors.toList());
                        if (standards.size() == 1) {
                            codelist_item.standard_oid = ((DefineStandardModel)standards.get(0)).toOid();
                        } else if (!"2.0.0".equals(((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.e2dDefineVersion)) {
                            String message6 = "Failed to identify a Controled Terminology to be assigned to the codelist. Make sure to fill out the 'Standard' column.";
                            ErrorLog error6 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message6);
                            error6.setColumnName("Standard");
                            rtn.add(error6);
                        }
                    } else {
                        String standard_oid = "";
                        List<DefineStandardModel> standards = SdtmAdamSpecImporter.this.define.listSortedStandard();
                        for (DefineStandardModel standard : standards) {
                            if (standard.standard_type != DefineStandardModel.StandardType.CT) continue;
                            String ct_id1_short = Utils.codedText(standard.publishing_set + standard.standard_version).toLowerCase();
                            String ct_id1_long = Utils.codedText(standard.standard_name).toLowerCase() + ct_id1_short;
                            String ct_id2 = Utils.codedText(str_standard).toLowerCase();
                            if (!ct_id1_short.equals(ct_id2) && !ct_id1_long.equals(ct_id2)) continue;
                            standard_oid = standard.toOid();
                            break;
                        }
                        if (StringUtils.isEmpty((CharSequence)standard_oid)) {
                            message = "The value in the 'Standard' column is ignored because it is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineStandardTableName + " sheet. Check if both Publishing Set and Standard Version are entered.";
                            error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                            error.setColumnName("Standard");
                            rtn.add(error);
                        } else {
                            codelist_item.standard_oid = standard_oid;
                        }
                    }
                }
                String comment_oid = ExcelCell.getAsString(cells.get("CommentOID"));
                String str_comment = ExcelCell.getAsString(cells.get("Comment"));
                if (StringUtils.isNotEmpty((CharSequence)comment_oid)) {
                    DefineCommentModel comment = SdtmAdamSpecImporter.this.define.listSortedComment().stream().filter(o -> StringUtils.equals((CharSequence)o.oid, (CharSequence)comment_oid)).findFirst().orElse(null);
                    if (comment == null) {
                        message = "The 'CommentOID' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineCommentTableName + " sheet. The 'CommentOID' is ignored.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("CommentOID");
                        rtn.add(error);
                    } else {
                        codelist_item.comment_oid = comment_oid;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                        message = "Either of the 'CommentOID' or 'Comment' column can be entered. The 'Comment' and associated information is ignored.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("Comment");
                        rtn.add(error);
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                    codelist_item.comment_oid = DefineCommentModel.createCommentOID(codelist_item);
                    DefineCommentModel.DefineCommentPk comment_pk = new DefineCommentModel.DefineCommentPk(codelist_item.comment_oid);
                    DefineCommentModel comment = new DefineCommentModel(comment_pk);
                    comment.comment_text = str_comment;
                    String comment_lang = ExcelCell.getAsString(cells.get("Language"));
                    if (StringUtils.isEmpty((CharSequence)comment_lang)) {
                        comment_lang = ExcelCell.getAsString(cells.get("xml:lang"));
                    }
                    comment.comment_lang = comment_lang;
                    List<String> document_ids = Utils.split(ExcelCell.getAsString(cells.get("DocumentID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_types = Utils.split(ExcelCell.getAsString(cells.get("Document Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_references = Utils.split(ExcelCell.getAsString(cells.get("Document Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_first_pages = Utils.split(ExcelCell.getAsString(cells.get("Document First Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_last_pages = Utils.split(ExcelCell.getAsString(cells.get("Document Last Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_titles = Utils.split(ExcelCell.getAsString(cells.get("Document Page Title")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List document_refs = SdtmAdamSpecImporter.this.createDocumentRefs(rtn, document_ids, document_page_types, document_page_references, document_first_pages, document_last_pages, document_page_titles);
                    comment.document_refs.addAll(document_refs);
                    SdtmAdamSpecImporter.this.define.put(comment_pk, comment);
                } else {
                    String document_id = ExcelCell.getAsString(cells.get("DocumentID"));
                    if (StringUtils.isNotEmpty((CharSequence)document_id)) {
                        message = "The 'Comment' column is required when 'DocumentID' is entered. The 'DocumentID' and associated information is ignored.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("Comment");
                        rtn.add(error);
                    }
                }
                codelist_item.code = ExcelCell.getAsString(cells.get("Code"));
                codelist_item.order_number = ExcelCell.getAsInteger(cells.get("Order Number"));
                codelist_item.rank = ExcelCell.getAsInteger(cells.get("Rank"));
                codelist_item.extended_value = DefineModel.YorNull.parse(ExcelCell.getAsString(cells.get("ExtendedValue")));
                String str_decode = ExcelCell.getAsString(cells.get("Decode"));
                if (StringUtils.isEmpty((CharSequence)str_decode)) {
                    str_decode = ExcelCell.getAsString(cells.get("Translated Text"));
                }
                codelist_item.decode = str_decode;
                String xml_lang = ExcelCell.getAsString(cells.get("Decode Language"));
                if (StringUtils.isEmpty((CharSequence)xml_lang)) {
                    xml_lang = ExcelCell.getAsString(cells.get("xml:lang"));
                }
                codelist_item.xml_lang = xml_lang;
                codelist_item.alias_context = ExcelCell.getAsString(cells.get("Alias Context"));
                codelist_item.alias_name = ExcelCell.getAsString(cells.get("Alias Name"));
                codelist_item.user_note1 = ExcelCell.getAsString(cells.get("User Note 1"));
                codelist_item.user_note2 = ExcelCell.getAsString(cells.get("User Note 2"));
                SdtmAdamSpecImporter.this.define.put(pk, codelist_item);
                return rtn;
            }
        };
        return excel_sheet.doImport(binder);
    }

    List<ErrorLog> checkCodelistDecode() {
        ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
        List<DefineCodelistModel> codelist_items = this.define.listSortedCodelist();
        ArrayList<String> codelist_ids = new ArrayList<String>();
        for (DefineCodelistModel codelist_item : codelist_items) {
            if (codelist_ids.contains(codelist_item.codelist_id)) continue;
            codelist_ids.add(codelist_item.codelist_id);
        }
        for (String codelist_id : codelist_ids) {
            List filtered_codelist_items = codelist_items.stream().filter(o -> StringUtils.equals((CharSequence)o.codelist_id, (CharSequence)codelist_id)).collect(Collectors.toList());
            List coded_codelist_items = filtered_codelist_items.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.codelist_id)).collect(Collectors.toList());
            if (coded_codelist_items.size() <= 0 || coded_codelist_items.size() == filtered_codelist_items.size()) continue;
            String message = "The 'Decode' must be all empty or all filled out for each Codelist ID. 'Decode' for the " + codelist_id + " codelist is ignored.";
            ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
            error.setColumnName("Decode");
            rtn.add(error);
            for (int i = 0; i < filtered_codelist_items.size(); ++i) {
                DefineCodelistModel filtered_codelist_item = (DefineCodelistModel)filtered_codelist_items.get(i);
                filtered_codelist_item.decode = "";
            }
        }
        return rtn;
    }

    List<ErrorLog> importVariable(String sheet_name) {
        HorizontalExcelSheet excel_sheet = new HorizontalExcelSheet(sheet_name, true, new ExcelColumn[]{new ExcelColumn("Domain", false), new ExcelColumn("Dataset Name", true), new ExcelColumn("Variable Name", true), new ExcelColumn("Is SUPP", false), new ExcelColumn("Repeat N", false), new ExcelColumn("Label", true), new ExcelColumn("No Data", false), new ExcelColumn("Non Standard", false), new ExcelColumn("Mandatory", true), new ExcelColumn("Key Sequence", true), new ExcelColumn("Sort Order", false), new ExcelColumn("DataType", true), new ExcelColumn("Length", true), new ExcelColumn("SignificantDigits", true), new ExcelColumn("SASFieldName", true), new ExcelColumn("DisplayFormat", true), new ExcelColumn("Codelist", true), new ExcelColumn("Origin", true), new ExcelColumn("Source", false), new ExcelColumn("Evaluator", false), new ExcelColumn("CRF ID", false), new ExcelColumn("CRF Page Type", false), new ExcelColumn("CRF Page Reference", false), new ExcelColumn("CRF First Page", false), new ExcelColumn("CRF Last Page", false), new ExcelColumn("CRF Page Title", false), new ExcelColumn("MethodOID", false), new ExcelColumn("Derivation Type", false), new ExcelColumn("Predecessor", false), new ExcelColumn("Derivation", false), new ExcelColumn("Predecessor/Derivation", false), new ExcelColumn("CommentOID", false), new ExcelColumn("Comment", false), new ExcelColumn("Language", false), new ExcelColumn("xml:lang", false), new ExcelColumn("DocumentID", false), new ExcelColumn("Document Page Type", false), new ExcelColumn("Document Page Reference", false), new ExcelColumn("Document First Page", false), new ExcelColumn("Document Last Page", false), new ExcelColumn("Document Page Title", false), new ExcelColumn("Role", false), new ExcelColumn("Role codelist", false), new ExcelColumn("FormalExpression Context", false), new ExcelColumn("FormalExpression Text", false), new ExcelColumn("FormalExpression", false), new ExcelColumn("Alias Context", false), new ExcelColumn("Alias Name", false), new ExcelColumn("User Note 1", false), new ExcelColumn("User Note 2", false)});
        List<ErrorLog> errors = excel_sheet.validate();
        if (!errors.isEmpty()) {
            return errors;
        }
        Function<ExcelRow, List<ErrorLog>> binder = new Function<ExcelRow, List<ErrorLog>>(){
            String last_dataset_name = "";
            int ordinal = 1;

            @Override
            public List<ErrorLog> apply(ExcelRow cells) {
                ErrorLog error;
                String message;
                ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
                String dataset_name = ExcelCell.getAsString(cells.get("Dataset Name"));
                if (StringUtils.isEmpty((CharSequence)dataset_name)) {
                    ErrorLog error2 = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'Dataset Name' column is required and cannot be empty. Skipping the row...");
                    error2.setColumnName("Dataset Name");
                    rtn.add(error2);
                    return rtn;
                }
                DefineDatasetModel dataset = SdtmAdamSpecImporter.this.define.get(new DefineDatasetModel.DefineDatasetPk(dataset_name));
                if (dataset == null) {
                    ErrorLog error3 = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'Dataset Name' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineDatasetTableName + " sheet. Skipping the row...");
                    error3.setColumnName("Dataset Name");
                    rtn.add(error3);
                    return rtn;
                }
                String variable_name = ExcelCell.getAsString(cells.get("Variable Name"));
                if (StringUtils.isEmpty((CharSequence)variable_name)) {
                    ErrorLog error4 = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'Variable Name' column is required and cannot be empty. Skipping the row...");
                    error4.setColumnName("Variable Name");
                    rtn.add(error4);
                    return rtn;
                }
                DefineVariableModel.DefineVariablePk pk = new DefineVariableModel.DefineVariablePk(dataset_name, DefineVariableModel.createOid(dataset_name, variable_name));
                DefineVariableModel variable2 = SdtmAdamSpecImporter.this.define.get(pk);
                if (variable2 != null) {
                    String message2 = "The row (" + dataset_name + "/" + variable_name + ") is duplicated. Skipping the row...";
                    ErrorLog error5 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message2);
                    rtn.add(error5);
                    return rtn;
                }
                DefineVariableModel variable = new DefineVariableModel(pk);
                variable.variable_name = variable_name;
                if (StringUtils.equals((CharSequence)this.last_dataset_name, (CharSequence)dataset_name)) {
                    variable.ordinal = this.ordinal++;
                } else {
                    this.ordinal = 1;
                    variable.ordinal = this.ordinal++;
                    this.last_dataset_name = dataset_name;
                }
                variable.is_supp = DefineModel.YorN.parse(ExcelCell.getAsString(cells.get("Is SUPP")));
                int repeat_n = ExcelCell.getAsInteger(cells.get("Repeat N"));
                if (repeat_n > 99) {
                    String message3 = "The 'Repeat N' value must be less than 100. The 'Repeat N' is ignored.";
                    ErrorLog error6 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message3);
                    error6.setColumnName("Repeat N");
                    rtn.add(error6);
                    repeat_n = 0;
                }
                variable.repeat_n = repeat_n;
                variable.variable_label = ExcelCell.getAsString(cells.get("Label"));
                variable.has_no_data = DefineModel.YorNull.parse(ExcelCell.getAsString(cells.get("No Data")));
                variable.has_no_data_derived = variable.deriveHasNoData(SdtmAdamSpecImporter.this.define);
                variable.is_non_standard = DefineModel.YorNull.parse(ExcelCell.getAsString(cells.get("Non Standard")));
                variable.mandatory = DefineModel.YorN.parse(ExcelCell.getAsString(cells.get("Mandatory")));
                variable.key_sequence = ExcelCell.getAsString(cells.get("Key Sequence"));
                variable.sort_order = ExcelCell.getAsString(cells.get("Sort Order"));
                variable.data_type = ExcelCell.getAsString(cells.get("DataType"));
                variable.length = ExcelCell.getAsString(cells.get("Length"));
                if (variable.repeat_n > 0) {
                    List<String> length_0_n = Utils.split(variable.length, ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    if (length_0_n.size() == 1) {
                        variable.repeat_n_length = new ArrayList<String>();
                    } else if (variable.repeat_n + 1 == length_0_n.size()) {
                        variable.repeat_n_length = length_0_n;
                    } else {
                        String message4 = "The 'Length' should be a list of Length split by \"" + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter + "\". The 'Length' is ignored.";
                        ErrorLog error7 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message4);
                        error7.setColumnName("Length");
                        rtn.add(error7);
                    }
                }
                variable.significant_digits = ExcelCell.getAsString(cells.get("SignificantDigits"));
                variable.sas_field_name = ExcelCell.getAsString(cells.get("SASFieldName"));
                variable.display_format = ExcelCell.getAsString(cells.get("DisplayFormat"));
                String str_codelist = ExcelCell.getAsString(cells.get("Codelist"));
                if (StringUtils.isNotEmpty((CharSequence)str_codelist)) {
                    DefineCodelistModel codelist = SdtmAdamSpecImporter.this.define.listSortedCodelist().stream().filter(o -> StringUtils.equals((CharSequence)o.codelist_id, (CharSequence)str_codelist)).findAny().orElse(null);
                    DefineDictionaryModel dictionary = SdtmAdamSpecImporter.this.define.listSortedDictionary().stream().filter(o -> StringUtils.equals((CharSequence)o.dictionary_id, (CharSequence)str_codelist)).findAny().orElse(null);
                    if (codelist == null && dictionary == null) {
                        String message5 = "The '" + str_codelist + "' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineCodelistTableName + " or " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineDictionaryTableName + " sheet. The Codelist is ignored.";
                        ErrorLog error8 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message5);
                        error8.setColumnName("Codelist");
                        rtn.add(error8);
                    } else {
                        variable.codelist = str_codelist;
                    }
                }
                variable.origin = ExcelCell.getAsString(cells.get("Origin"));
                variable.source = ExcelCell.getAsString(cells.get("Source"));
                variable.evaluator = ExcelCell.getAsString(cells.get("Evaluator"));
                variable.crf_id = ExcelCell.getAsString(cells.get("CRF ID"));
                variable.crf_page_type = ExcelCell.getAsString(cells.get("CRF Page Type"));
                variable.crf_page_reference = ExcelCell.getAsString(cells.get("CRF Page Reference"));
                variable.crf_first_page = ExcelCell.getAsString(cells.get("CRF First Page"));
                variable.crf_last_page = ExcelCell.getAsString(cells.get("CRF Last Page"));
                variable.crf_page_title = ExcelCell.getAsString(cells.get("CRF Page Title"));
                variable.predecessor = ExcelCell.getAsString(cells.get("Predecessor"));
                String predecessor_derivation = ExcelCell.getAsString(cells.get("Predecessor/Derivation"));
                if (StringUtils.isEmpty((CharSequence)variable.predecessor) && !"Derived".equals(variable.origin)) {
                    variable.predecessor = predecessor_derivation;
                }
                String method_oid = ExcelCell.getAsString(cells.get("MethodOID"));
                String derivation = ExcelCell.getAsString(cells.get("Derivation"));
                DefineMethodModel method = null;
                if (StringUtils.isNotEmpty((CharSequence)method_oid)) {
                    ErrorLog error9;
                    String message6;
                    method = SdtmAdamSpecImporter.this.define.listSortedMethod().stream().filter(o -> StringUtils.equals((CharSequence)o.oid, (CharSequence)method_oid)).findFirst().orElse(null);
                    if (method == null) {
                        message6 = "The 'MethodOID' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineMethodTableName + " sheet. The 'MethodOID' is ignored.";
                        error9 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message6);
                        error9.setColumnName("MethodOID");
                        rtn.add(error9);
                    } else {
                        variable.method_oid = method_oid;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)derivation)) {
                        message6 = "Either of the 'MethodOID' or 'Derivation' column can be entered. The 'Derivation' is ignored.";
                        error9 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message6);
                        error9.setColumnName("Derivation");
                        rtn.add(error9);
                    } else if (StringUtils.isNotEmpty((CharSequence)predecessor_derivation)) {
                        message6 = "Either of the 'MethodOID' or 'Predecessor/Derivation' column can be entered. The 'Predecessor/Derivation' is ignored.";
                        error9 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message6);
                        error9.setColumnName("Predecessor/Derivation");
                        rtn.add(error9);
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)derivation) || "Derived".equals(variable.origin) && StringUtils.isNotEmpty((CharSequence)predecessor_derivation)) {
                    variable.method_oid = DefineMethodModel.createMethodOID(variable);
                    DefineMethodModel.DefineMethodPk method_pk = new DefineMethodModel.DefineMethodPk(variable.method_oid);
                    method = new DefineMethodModel(method_pk);
                    method.method_name = "Algorithm to derive " + variable_name;
                    method.method_type = ExcelCell.getAsString(cells.get("Derivation Type"));
                    method.description = StringUtils.isNotEmpty((CharSequence)derivation) ? derivation : predecessor_derivation;
                    method.description_lang = ExcelCell.getAsString(cells.get("Language"));
                    if (StringUtils.isEmpty((CharSequence)method.description_lang)) {
                        method.description_lang = ExcelCell.getAsString(cells.get("xml:lang"));
                    }
                    List<String> document_ids = Utils.split(ExcelCell.getAsString(cells.get("DocumentID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_types = Utils.split(ExcelCell.getAsString(cells.get("Document Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_references = Utils.split(ExcelCell.getAsString(cells.get("Document Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_first_pages = Utils.split(ExcelCell.getAsString(cells.get("Document First Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_last_pages = Utils.split(ExcelCell.getAsString(cells.get("Document Last Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_titles = Utils.split(ExcelCell.getAsString(cells.get("Document Page Title")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List document_refs = SdtmAdamSpecImporter.this.createDocumentRefs(rtn, document_ids, document_page_types, document_page_references, document_first_pages, document_last_pages, document_page_titles);
                    method.document_refs.addAll(document_refs);
                    method.formal_expression_context = ExcelCell.getAsString(cells.get("FormalExpression Context"));
                    method.formal_expression = ExcelCell.getAsString(cells.get("FormalExpression Text"));
                    if (StringUtils.isEmpty((CharSequence)method.formal_expression)) {
                        method.formal_expression = ExcelCell.getAsString(cells.get("Formal expression"));
                    }
                    SdtmAdamSpecImporter.this.define.put(method_pk, method);
                }
                String comment_oid = ExcelCell.getAsString(cells.get("CommentOID"));
                String str_comment = ExcelCell.getAsString(cells.get("Comment"));
                if (StringUtils.isNotEmpty((CharSequence)comment_oid)) {
                    DefineCommentModel comment = SdtmAdamSpecImporter.this.define.listSortedComment().stream().filter(o -> StringUtils.equals((CharSequence)o.oid, (CharSequence)comment_oid)).findFirst().orElse(null);
                    if (comment == null) {
                        message = "The 'CommentOID' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineCommentTableName + " sheet. The 'CommentOID' is ignored.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("CommentOID");
                        rtn.add(error);
                    } else {
                        variable.comment_oid = comment_oid;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                        message = "Either of the 'CommentOID' or 'Comment' column can be entered. The 'Comment' and associated information is ignored.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("Comment");
                        rtn.add(error);
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                    if (method == null) {
                        variable.comment_oid = DefineCommentModel.createCommentOID(variable);
                        DefineCommentModel.DefineCommentPk comment_pk = new DefineCommentModel.DefineCommentPk(variable.comment_oid);
                        DefineCommentModel comment = new DefineCommentModel(comment_pk);
                        comment.comment_text = str_comment;
                        String comment_lang = ExcelCell.getAsString(cells.get("Language"));
                        if (StringUtils.isEmpty((CharSequence)comment_lang)) {
                            comment_lang = ExcelCell.getAsString(cells.get("xml:lang"));
                        }
                        comment.comment_lang = comment_lang;
                        List<String> document_ids = Utils.split(ExcelCell.getAsString(cells.get("DocumentID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List<String> document_page_types = Utils.split(ExcelCell.getAsString(cells.get("Document Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List<String> document_page_references = Utils.split(ExcelCell.getAsString(cells.get("Document Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List<String> document_first_pages = Utils.split(ExcelCell.getAsString(cells.get("Document First Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List<String> document_last_pages = Utils.split(ExcelCell.getAsString(cells.get("Document Last Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List<String> document_page_titles = Utils.split(ExcelCell.getAsString(cells.get("Document Page Title")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List document_refs = SdtmAdamSpecImporter.this.createDocumentRefs(rtn, document_ids, document_page_types, document_page_references, document_first_pages, document_last_pages, document_page_titles);
                        comment.document_refs.addAll(document_refs);
                        SdtmAdamSpecImporter.this.define.put(comment_pk, comment);
                    } else {
                        String message7 = "Either of the 'Derivation' or 'Comment' column can be entered. The 'Comment' and associated information is ignored.";
                        ErrorLog error10 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message7);
                        error10.setColumnName("Comment");
                        rtn.add(error10);
                    }
                } else {
                    String document_id = ExcelCell.getAsString(cells.get("DocumentID"));
                    if (StringUtils.isNotEmpty((CharSequence)document_id) && method == null) {
                        message = "The 'Derivation' or 'Comment' column is required when 'DocumentID' is entered. The 'DocumentID' and associated information is ignored.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("Comment");
                        rtn.add(error);
                    }
                }
                variable.role = ExcelCell.getAsString(cells.get("Role"));
                String str_role_codelist = ExcelCell.getAsString(cells.get("Role codelist"));
                if (StringUtils.isNotEmpty((CharSequence)str_role_codelist)) {
                    DefineCodelistModel role_codelist = SdtmAdamSpecImporter.this.define.listSortedCodelist().stream().filter(o -> StringUtils.equals((CharSequence)o.codelist_id, (CharSequence)str_role_codelist)).findAny().orElse(null);
                    if (role_codelist == null) {
                        String message8 = "The '" + str_role_codelist + "' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineCodelistTableName + " sheet. The Role Codelist is ignored.";
                        ErrorLog error11 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message8);
                        error11.setColumnName("Role codelist");
                        rtn.add(error11);
                    } else {
                        variable.role_codelist = str_role_codelist;
                    }
                }
                variable.alias_context = ExcelCell.getAsString(cells.get("Alias Context"));
                variable.alias_name = ExcelCell.getAsString(cells.get("Alias Name"));
                variable.user_note1 = ExcelCell.getAsString(cells.get("User Note 1"));
                variable.user_note2 = ExcelCell.getAsString(cells.get("User Note 2"));
                SdtmAdamSpecImporter.this.define.put(pk, variable);
                return rtn;
            }
        };
        return excel_sheet.doImport(binder);
    }

    List<ErrorLog> importValue(String sheet_name) {
        HorizontalExcelSheet excel_sheet = new HorizontalExcelSheet(sheet_name, true, new ExcelColumn[]{new ExcelColumn("Domain", false), new ExcelColumn("Dataset Name", true), new ExcelColumn("Variable Name", true), new ExcelColumn("Value Name", true), new ExcelColumn("Value Key", false), new ExcelColumn("Label", true), new ExcelColumn("No Data", false), new ExcelColumn("Mandatory", false), new ExcelColumn("Key Sequence", false), new ExcelColumn("DataType", true), new ExcelColumn("Length", true), new ExcelColumn("SignificantDigits", true), new ExcelColumn("SASFieldName", true), new ExcelColumn("DisplayFormat", true), new ExcelColumn("Codelist", true), new ExcelColumn("Origin", true), new ExcelColumn("Source", false), new ExcelColumn("CRF ID", false), new ExcelColumn("CRF Page Type", false), new ExcelColumn("CRF Page Reference", false), new ExcelColumn("CRF First Page", false), new ExcelColumn("CRF Last Page", false), new ExcelColumn("CRF Page Title", false), new ExcelColumn("MethodOID", false), new ExcelColumn("Derivation Type", true), new ExcelColumn("Predecessor", false), new ExcelColumn("Derivation", false), new ExcelColumn("Predecessor/Derivation", false), new ExcelColumn("CommentOID", false), new ExcelColumn("Comment", false), new ExcelColumn("Language", false), new ExcelColumn("xml:lang", false), new ExcelColumn("DocumentID", false), new ExcelColumn("Document Page Type", false), new ExcelColumn("Document Page Reference", false), new ExcelColumn("Document First Page", false), new ExcelColumn("Document Last Page", false), new ExcelColumn("Document Page Title", false), new ExcelColumn("FormalExpression Context", false), new ExcelColumn("FormalExpression Text", false), new ExcelColumn("FormalExpression", false), new ExcelColumn("Alias Context", false), new ExcelColumn("Alias Name", false), new ExcelColumn("User Note 1", false), new ExcelColumn("User Note 2", false), new ExcelColumn("W Domain", false), new ExcelColumn("W Dataset Name", false), new ExcelColumn("W Variable Name", false), new ExcelColumn("W Value Key", false), new ExcelColumn("WhereClauseGroupID", false), new ExcelColumn("WhereClauseDataset", true), new ExcelColumn("WhereClauseVariable", true), new ExcelColumn("WhereClauseOperator", true), new ExcelColumn("WhereClauseValue", true), new ExcelColumn("WhereClause CommentOID", false), new ExcelColumn("WhereClause Comment", false), new ExcelColumn("WhereClause Language", false), new ExcelColumn("W xml:lang", false)});
        List<ErrorLog> errors = excel_sheet.validate();
        if (!errors.isEmpty()) {
            return errors;
        }
        Function<ExcelRow, List<ErrorLog>> binder = new Function<ExcelRow, List<ErrorLog>>(){
            String last_dataset_name = "";
            DefineValueModel.DefineValuePk last_value_pk;
            DefineWCModel.DefineWCPk last_wc_pk;
            String last_wc_group_id = "";
            int ordinal = 1;

            @Override
            public List<ErrorLog> apply(ExcelRow cells) {
                ErrorLog error;
                String message;
                ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
                String wc_dataset = ExcelCell.getAsString(cells.get("WhereClauseDataset"));
                if (StringUtils.isEmpty((CharSequence)wc_dataset)) {
                    ErrorLog error2 = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'WhereClauseDataset' column is required and cannot be empty. Skipping the row...");
                    error2.setColumnName("WhereClauseDataset");
                    rtn.add(error2);
                    return rtn;
                }
                String wc_variable = ExcelCell.getAsString(cells.get("WhereClauseVariable"));
                if (StringUtils.isEmpty((CharSequence)wc_variable)) {
                    ErrorLog error3 = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'WhereClauseVariable' column is required and cannot be empty. Skipping the row...");
                    error3.setColumnName("WhereClauseVariable");
                    rtn.add(error3);
                    return rtn;
                }
                String wc_operator = ExcelCell.getAsString(cells.get("WhereClauseOperator"));
                if (StringUtils.isEmpty((CharSequence)wc_operator)) {
                    ErrorLog error4 = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'WhereClauseOperator' column is required and cannot be empty. Skipping the row...");
                    error4.setColumnName("WhereClauseOperator");
                    rtn.add(error4);
                    return rtn;
                }
                String wc_value = ExcelCell.getAsString(cells.get("WhereClauseValue"));
                if (StringUtils.isEmpty((CharSequence)wc_value)) {
                    ErrorLog error5 = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'WhereClauseValue' column is required and cannot be empty. Skipping the row...");
                    error5.setColumnName("WhereClauseValue");
                    rtn.add(error5);
                    return rtn;
                }
                String dataset_name = ExcelCell.getAsString(cells.get("Dataset Name"));
                String variable_name = ExcelCell.getAsString(cells.get("Variable Name"));
                String value_name = ExcelCell.getAsString(cells.get("Value Name"));
                if (this.last_value_pk == null) {
                    if (StringUtils.isEmpty((CharSequence)dataset_name)) {
                        ErrorLog error6 = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'Dataset Name' column is required and cannot be empty. Skipping the row...");
                        error6.setColumnName("Dataset Name");
                        rtn.add(error6);
                        return rtn;
                    }
                    if (StringUtils.isEmpty((CharSequence)variable_name)) {
                        ErrorLog error7 = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'Variable Name' column is required and cannot be empty. Skipping the row...");
                        error7.setColumnName("Variable Name");
                        rtn.add(error7);
                        return rtn;
                    }
                    if (StringUtils.isEmpty((CharSequence)value_name)) {
                        ErrorLog error8 = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'Value Name' column is required and cannot be empty. Skipping the row...");
                        error8.setColumnName("Value Name");
                        rtn.add(error8);
                        return rtn;
                    }
                }
                String value_key = ExcelCell.getAsString(cells.get("Value Key"));
                String value_oid = DefineValueModel.createOid(dataset_name, variable_name, value_name, value_key);
                DefineValueModel.DefineValuePk pk = new DefineValueModel.DefineValuePk(value_oid);
                if (StringUtils.isNotEmpty((CharSequence)value_oid) && !pk.equals(this.last_value_pk)) {
                    ErrorLog error9;
                    String message2;
                    DefineValueModel value2 = SdtmAdamSpecImporter.this.define.get(pk);
                    if (value2 != null) {
                        String message3 = "The row (" + dataset_name + "/" + variable_name + "/" + (StringUtils.isEmpty((CharSequence)value_key) ? value_name : value_key) + ") is duplicated. Skipping the row...";
                        ErrorLog error10 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message3);
                        rtn.add(error10);
                        return rtn;
                    }
                    DefineVariableModel variable = SdtmAdamSpecImporter.this.define.get(new DefineVariableModel.DefineVariablePk(dataset_name, DefineVariableModel.createOid(dataset_name, variable_name)));
                    if (variable == null) {
                        ErrorLog error11 = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The pair of 'Dataset Name' and 'Variable Name' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineVariableTableName + " sheet. Skipping the row...");
                        error11.setColumnName("Dataset Name/Variable Name");
                        rtn.add(error11);
                        return rtn;
                    }
                    DefineValueModel value = new DefineValueModel(pk);
                    value.dataset_name = dataset_name;
                    value.variable_name = variable_name;
                    value.value_name = value_name;
                    value.value_key = value_key;
                    if (StringUtils.equals((CharSequence)this.last_dataset_name, (CharSequence)dataset_name)) {
                        value.ordinal = this.ordinal++;
                    } else {
                        this.ordinal = 1;
                        value.ordinal = this.ordinal++;
                        this.last_dataset_name = dataset_name;
                    }
                    value.value_label = ExcelCell.getAsString(cells.get("Label"));
                    value.has_no_data = DefineModel.YorNull.parse(ExcelCell.getAsString(cells.get("No Data")));
                    value.has_no_data_derived = value.deriveHasNoData(SdtmAdamSpecImporter.this.define);
                    value.mandatory = DefineModel.YorN.parse(ExcelCell.getAsString(cells.get("Mandatory")));
                    value.data_type = ExcelCell.getAsString(cells.get("DataType"));
                    value.length = ExcelCell.getAsString(cells.get("Length"));
                    value.significant_digits = ExcelCell.getAsString(cells.get("SignificantDigits"));
                    value.sas_field_name = ExcelCell.getAsString(cells.get("SASFieldName"));
                    value.display_format = ExcelCell.getAsString(cells.get("DisplayFormat"));
                    String str_codelist = ExcelCell.getAsString(cells.get("Codelist"));
                    if (StringUtils.isNotEmpty((CharSequence)str_codelist)) {
                        DefineCodelistModel codelist = SdtmAdamSpecImporter.this.define.listSortedCodelist().stream().filter(o -> StringUtils.equals((CharSequence)o.codelist_id, (CharSequence)str_codelist)).findAny().orElse(null);
                        DefineDictionaryModel dictionary = SdtmAdamSpecImporter.this.define.listSortedDictionary().stream().filter(o -> StringUtils.equals((CharSequence)o.dictionary_id, (CharSequence)str_codelist)).findAny().orElse(null);
                        if (codelist == null && dictionary == null) {
                            message = "The '" + str_codelist + "' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineCodelistTableName + " or " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineDictionaryTableName + " sheet. The Codelist is ignored.";
                            error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                            error.setColumnName("Codelist");
                            rtn.add(error);
                        } else {
                            value.codelist = str_codelist;
                        }
                    }
                    value.origin = ExcelCell.getAsString(cells.get("Origin"));
                    value.source = ExcelCell.getAsString(cells.get("Source"));
                    value.crf_id = ExcelCell.getAsString(cells.get("CRF ID"));
                    value.crf_page_type = ExcelCell.getAsString(cells.get("CRF Page Type"));
                    value.crf_page_reference = ExcelCell.getAsString(cells.get("CRF Page Reference"));
                    value.crf_first_page = ExcelCell.getAsString(cells.get("CRF First Page"));
                    value.crf_last_page = ExcelCell.getAsString(cells.get("CRF Last Page"));
                    value.crf_page_title = ExcelCell.getAsString(cells.get("CRF Page Title"));
                    value.predecessor = ExcelCell.getAsString(cells.get("Predecessor"));
                    String predecessor_derivation = ExcelCell.getAsString(cells.get("Predecessor/Derivation"));
                    if (StringUtils.isEmpty((CharSequence)value.predecessor) && !"Derived".equals(value.origin)) {
                        value.predecessor = predecessor_derivation;
                    }
                    String method_oid = ExcelCell.getAsString(cells.get("MethodOID"));
                    String derivation = ExcelCell.getAsString(cells.get("Derivation"));
                    DefineMethodModel method = null;
                    if (StringUtils.isNotEmpty((CharSequence)method_oid)) {
                        ErrorLog error12;
                        String message4;
                        method = SdtmAdamSpecImporter.this.define.listSortedMethod().stream().filter(o -> StringUtils.equals((CharSequence)o.oid, (CharSequence)method_oid)).findFirst().orElse(null);
                        if (method == null) {
                            message4 = "The 'MethodOID' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineMethodTableName + " sheet. The 'MethodOID' is ignored.";
                            error12 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message4);
                            error12.setColumnName("MethodOID");
                            rtn.add(error12);
                        } else {
                            value.method_oid = method_oid;
                        }
                        if (StringUtils.isNotEmpty((CharSequence)derivation)) {
                            message4 = "Either of the 'MethodOID' or 'Derivation' column can be entered. The 'Derivation' is ignored.";
                            error12 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message4);
                            error12.setColumnName("Derivation");
                            rtn.add(error12);
                        } else if (StringUtils.isNotEmpty((CharSequence)predecessor_derivation)) {
                            message4 = "Either of the 'MethodOID' or 'Predecessor/Derivation' column can be entered. The 'Predecessor/Derivation' is ignored.";
                            error12 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message4);
                            error12.setColumnName("Predecessor/Derivation");
                            rtn.add(error12);
                        }
                    } else if (StringUtils.isNotEmpty((CharSequence)derivation) || "Derived".equals(value.origin) && StringUtils.isNotEmpty((CharSequence)predecessor_derivation)) {
                        value.method_oid = DefineMethodModel.createMethodOID(value);
                        DefineMethodModel.DefineMethodPk method_pk = new DefineMethodModel.DefineMethodPk(value.method_oid);
                        method = new DefineMethodModel(method_pk);
                        method.method_name = "Algorithm to derive " + variable_name + "." + (StringUtils.isEmpty((CharSequence)value_key) ? value_name : value_key);
                        method.method_type = ExcelCell.getAsString(cells.get("Derivation Type"));
                        method.description = StringUtils.isNotEmpty((CharSequence)derivation) ? derivation : predecessor_derivation;
                        String description_lang = ExcelCell.getAsString(cells.get("Language"));
                        if (StringUtils.isEmpty((CharSequence)description_lang)) {
                            method.description_lang = ExcelCell.getAsString(cells.get("xml:lang"));
                        }
                        List<String> document_ids = Utils.split(ExcelCell.getAsString(cells.get("DocumentID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List<String> document_page_types = Utils.split(ExcelCell.getAsString(cells.get("Document Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List<String> document_page_references = Utils.split(ExcelCell.getAsString(cells.get("Document Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List<String> document_first_pages = Utils.split(ExcelCell.getAsString(cells.get("Document First Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List<String> document_last_pages = Utils.split(ExcelCell.getAsString(cells.get("Document Last Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List<String> document_page_titles = Utils.split(ExcelCell.getAsString(cells.get("Document Page Title")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                        List document_refs = SdtmAdamSpecImporter.this.createDocumentRefs(rtn, document_ids, document_page_types, document_page_references, document_first_pages, document_last_pages, document_page_titles);
                        method.document_refs.addAll(document_refs);
                        method.formal_expression_context = ExcelCell.getAsString(cells.get("FormalExpression Context"));
                        method.formal_expression = ExcelCell.getAsString(cells.get("FormalExpression Text"));
                        if (StringUtils.isEmpty((CharSequence)method.formal_expression)) {
                            method.formal_expression = ExcelCell.getAsString(cells.get("Formal expression"));
                        }
                        SdtmAdamSpecImporter.this.define.put(method_pk, method);
                    }
                    String comment_oid = ExcelCell.getAsString(cells.get("CommentOID"));
                    String str_comment = ExcelCell.getAsString(cells.get("Comment"));
                    if (StringUtils.isNotEmpty((CharSequence)comment_oid)) {
                        DefineCommentModel comment = SdtmAdamSpecImporter.this.define.listSortedComment().stream().filter(o -> StringUtils.equals((CharSequence)o.oid, (CharSequence)comment_oid)).findFirst().orElse(null);
                        if (comment == null) {
                            message2 = "The 'CommentOID' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineCommentTableName + " sheet. The 'CommentOID' is ignored.";
                            error9 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message2);
                            error9.setColumnName("CommentOID");
                            rtn.add(error9);
                        } else {
                            value.comment_oid = comment_oid;
                        }
                        if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                            message2 = "Either of the 'CommentOID' or 'Comment' column can be entered. The 'Comment' and associated information is ignored.";
                            error9 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message2);
                            error9.setColumnName("Comment");
                            rtn.add(error9);
                        }
                    } else if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                        if (method == null) {
                            value.comment_oid = DefineCommentModel.createCommentOID(value);
                            DefineCommentModel.DefineCommentPk comment_pk = new DefineCommentModel.DefineCommentPk(value.comment_oid);
                            DefineCommentModel comment = new DefineCommentModel(comment_pk);
                            comment.comment_text = str_comment;
                            String comment_lang = ExcelCell.getAsString(cells.get("Language"));
                            if (StringUtils.isEmpty((CharSequence)comment_lang)) {
                                comment_lang = ExcelCell.getAsString(cells.get("xml:lang"));
                            }
                            comment.comment_lang = comment_lang;
                            List<String> document_ids = Utils.split(ExcelCell.getAsString(cells.get("DocumentID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                            List<String> document_page_types = Utils.split(ExcelCell.getAsString(cells.get("Document Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                            List<String> document_page_references = Utils.split(ExcelCell.getAsString(cells.get("Document Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                            List<String> document_first_pages = Utils.split(ExcelCell.getAsString(cells.get("Document First Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                            List<String> document_last_pages = Utils.split(ExcelCell.getAsString(cells.get("Document Last Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                            List<String> document_page_titles = Utils.split(ExcelCell.getAsString(cells.get("Document Page Title")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                            List document_refs = SdtmAdamSpecImporter.this.createDocumentRefs(rtn, document_ids, document_page_types, document_page_references, document_first_pages, document_last_pages, document_page_titles);
                            comment.document_refs.addAll(document_refs);
                            SdtmAdamSpecImporter.this.define.put(comment_pk, comment);
                        } else {
                            String message5 = "Either of the 'Predecessor' or 'Comment' column can be entered. The 'Comment' and associated information is ignored.";
                            ErrorLog error13 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message5);
                            error13.setColumnName("Comment");
                            rtn.add(error13);
                        }
                    } else {
                        String document_id = ExcelCell.getAsString(cells.get("DocumentID"));
                        if (StringUtils.isNotEmpty((CharSequence)document_id) && method == null) {
                            message2 = "The 'Derivation' or 'Comment' column is required when 'DocumentID' is entered. The 'DocumentID' and associated information is ignored.";
                            error9 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message2);
                            error9.setColumnName("Comment");
                            rtn.add(error9);
                        }
                    }
                    value.user_note1 = ExcelCell.getAsString(cells.get("User Note 1"));
                    value.user_note2 = ExcelCell.getAsString(cells.get("User Note 2"));
                    SdtmAdamSpecImporter.this.define.put(pk, value);
                    this.last_value_pk = pk;
                }
                DefineValueModel last_value = SdtmAdamSpecImporter.this.define.get(this.last_value_pk);
                String wc_group_id = ExcelCell.getAsString(cells.get("WhereClauseGroupID"));
                String wc_oid = DefineWCModel.createOid(last_value.dataset_name, last_value.variable_name, last_value.value_name, last_value.value_key, wc_group_id);
                DefineWCModel wc = null;
                DefineWCModel.DefineWCPk wc_pk = new DefineWCModel.DefineWCPk(wc_oid);
                if (wc_pk.equals(this.last_wc_pk) && StringUtils.equals((CharSequence)wc_group_id, (CharSequence)this.last_wc_group_id)) {
                    wc = SdtmAdamSpecImporter.this.define.get(this.last_wc_pk);
                    DefineWCModel.WCCondition wc_condition = new DefineWCModel.WCCondition();
                    wc_condition.dataset_name = wc_dataset;
                    wc_condition.variable_name = wc_variable;
                    wc_condition.operator = wc_operator;
                    wc_condition.values.addAll(Utils.split(wc_value, ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter));
                    wc.wc_conditions.add(wc_condition);
                } else {
                    DefineWCModel wc2 = SdtmAdamSpecImporter.this.define.get(wc_pk);
                    if (wc2 != null) {
                        message = "The row (" + (StringUtils.isEmpty((CharSequence)wc_group_id) ? "" : wc_group_id + "/") + wc_dataset + "/" + wc_variable + "/" + wc_operator + "/" + wc_value + ") is duplicated. Skipping the row...";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        rtn.add(error);
                        return rtn;
                    }
                    wc = new DefineWCModel(wc_pk);
                    last_value.where_clause_pks.add(wc_pk);
                    String comment_oid = ExcelCell.getAsString(cells.get("WhereClause CommentOID"));
                    String str_comment = ExcelCell.getAsString(cells.get("WhereClause Comment"));
                    if (StringUtils.isNotEmpty((CharSequence)comment_oid)) {
                        ErrorLog error14;
                        String message6;
                        DefineCommentModel comment = SdtmAdamSpecImporter.this.define.listSortedComment().stream().filter(o -> StringUtils.equals((CharSequence)o.oid, (CharSequence)comment_oid)).findFirst().orElse(null);
                        if (comment == null) {
                            message6 = "The 'CommentOID' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineCommentTableName + " sheet. The 'CommentOID' is ignored.";
                            error14 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message6);
                            error14.setColumnName("CommentOID");
                            rtn.add(error14);
                        } else {
                            wc.comment_oid = comment_oid;
                        }
                        if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                            message6 = "Either of the 'WhereClause CommentOID' or 'WhereClause Comment' column can be entered. The 'WhereClause Comment' and associated information is ignored.";
                            error14 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message6);
                            error14.setColumnName("WhereClause Comment");
                            rtn.add(error14);
                        }
                    } else if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                        wc.comment_oid = DefineCommentModel.createCommentOID(wc);
                        DefineCommentModel.DefineCommentPk comment_pk = new DefineCommentModel.DefineCommentPk(wc.comment_oid);
                        DefineCommentModel comment = new DefineCommentModel(comment_pk);
                        comment.comment_text = str_comment;
                        String comment_lang = ExcelCell.getAsString(cells.get("WhereClause Language"));
                        if (StringUtils.isEmpty((CharSequence)comment_lang)) {
                            comment_lang = ExcelCell.getAsString(cells.get("W xml:lang"));
                        }
                        comment.comment_lang = comment_lang;
                        SdtmAdamSpecImporter.this.define.put(comment_pk, comment);
                    }
                    DefineWCModel.WCCondition wc_condition = new DefineWCModel.WCCondition();
                    wc_condition.dataset_name = wc_dataset;
                    wc_condition.variable_name = wc_variable;
                    wc_condition.operator = wc_operator;
                    wc_condition.values.addAll(Utils.split(wc_value, ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter));
                    wc.wc_conditions.add(wc_condition);
                    SdtmAdamSpecImporter.this.define.put(wc_pk, wc);
                }
                this.last_wc_group_id = wc_group_id;
                this.last_wc_pk = wc_pk;
                return rtn;
            }
        };
        return excel_sheet.doImport(binder);
    }

    List<ErrorLog> importDictionary(String sheet_name) {
        HorizontalExcelSheet excel_sheet = new HorizontalExcelSheet(sheet_name, true, new ExcelColumn[]{new ExcelColumn("Dictionary ID", true), new ExcelColumn("Name", true), new ExcelColumn("DataType", true), new ExcelColumn("Version", true), new ExcelColumn("ref", true), new ExcelColumn("href", true), new ExcelColumn("CommentOID", false), new ExcelColumn("Comment", false), new ExcelColumn("Language", false), new ExcelColumn("DocumentID", false), new ExcelColumn("Document Page Type", false), new ExcelColumn("Document Page Reference", false), new ExcelColumn("Document First Page", false), new ExcelColumn("Document Last Page", false), new ExcelColumn("Document Page Title", false), new ExcelColumn("User Note 1", true), new ExcelColumn("User Note 2", true)});
        List<ErrorLog> errors = excel_sheet.validate();
        if (!errors.isEmpty()) {
            return errors;
        }
        Function<ExcelRow, List<ErrorLog>> binder = new Function<ExcelRow, List<ErrorLog>>(){
            int ordinal = 1;

            @Override
            public List<ErrorLog> apply(ExcelRow cells) {
                ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
                String dictionary_id = ExcelCell.getAsString(cells.get("Dictionary ID"));
                if (StringUtils.isEmpty((CharSequence)dictionary_id)) {
                    String message = "The 'Dictionary ID' column is required and cannot be empty. Skipping the row...";
                    ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                    error.setColumnName("Dictionary ID");
                    rtn.add(error);
                    return rtn;
                }
                DefineDictionaryModel.DefineDictionaryPk pk = new DefineDictionaryModel.DefineDictionaryPk(DefineDictionaryModel.createOid(dictionary_id));
                DefineDictionaryModel dictionary2 = SdtmAdamSpecImporter.this.define.get(pk);
                if (dictionary2 != null) {
                    String message = "The row (" + dictionary_id + ") is duplicated. Skipping the row...";
                    ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                    rtn.add(error);
                }
                DefineDictionaryModel dictionary = new DefineDictionaryModel(pk);
                dictionary.dictionary_id = dictionary_id;
                dictionary.ordinal = this.ordinal++;
                dictionary.dictionary_name = ExcelCell.getAsString(cells.get("Name"));
                dictionary.data_type = ExcelCell.getAsString(cells.get("DataType"));
                dictionary.dictionary_version = ExcelCell.getAsString(cells.get("Version"));
                dictionary.dictionary_ref = ExcelCell.getAsString(cells.get("ref"));
                dictionary.dictionary_href = ExcelCell.getAsString(cells.get("href"));
                String comment_oid = ExcelCell.getAsString(cells.get("CommentOID"));
                String str_comment = ExcelCell.getAsString(cells.get("Comment"));
                if (StringUtils.isNotEmpty((CharSequence)comment_oid)) {
                    ErrorLog error;
                    String message;
                    DefineCommentModel comment = SdtmAdamSpecImporter.this.define.listSortedComment().stream().filter(o -> StringUtils.equals((CharSequence)o.oid, (CharSequence)comment_oid)).findFirst().orElse(null);
                    if (comment == null) {
                        message = "The 'CommentOID' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineCommentTableName + " sheet. The 'CommentOID' is ignored.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("CommentOID");
                        rtn.add(error);
                    } else {
                        dictionary.comment_oid = comment_oid;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                        message = "Either of the 'CommentOID' or 'Comment' column can be entered. The 'Comment' and associated information is ignored.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("Comment");
                        rtn.add(error);
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                    dictionary.comment_oid = DefineCommentModel.createCommentOID(dictionary);
                    DefineCommentModel.DefineCommentPk comment_pk = new DefineCommentModel.DefineCommentPk(dictionary.comment_oid);
                    DefineCommentModel comment = new DefineCommentModel(comment_pk);
                    comment.comment_text = str_comment;
                    comment.comment_lang = ExcelCell.getAsString(cells.get("Language"));
                    List<String> document_ids = Utils.split(ExcelCell.getAsString(cells.get("DocumentID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_types = Utils.split(ExcelCell.getAsString(cells.get("Document Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_references = Utils.split(ExcelCell.getAsString(cells.get("Document Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_first_pages = Utils.split(ExcelCell.getAsString(cells.get("Document First Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_last_pages = Utils.split(ExcelCell.getAsString(cells.get("Document Last Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_titles = Utils.split(ExcelCell.getAsString(cells.get("Document Page Title")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List document_refs = SdtmAdamSpecImporter.this.createDocumentRefs(rtn, document_ids, document_page_types, document_page_references, document_first_pages, document_last_pages, document_page_titles);
                    comment.document_refs.addAll(document_refs);
                    SdtmAdamSpecImporter.this.define.put(comment_pk, comment);
                } else {
                    String document_id = ExcelCell.getAsString(cells.get("DocumentID"));
                    if (StringUtils.isNotEmpty((CharSequence)document_id)) {
                        String message = "The 'Comment' column is required when 'DocumentID' is entered. The 'DocumentID' and associated information is ignored.";
                        ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("Comment");
                        rtn.add(error);
                    }
                }
                dictionary.user_note1 = ExcelCell.getAsString(cells.get("User Note 1"));
                dictionary.user_note2 = ExcelCell.getAsString(cells.get("User Note 2"));
                SdtmAdamSpecImporter.this.define.put(pk, dictionary);
                return rtn;
            }
        };
        return excel_sheet.doImport(binder);
    }

    List<ErrorLog> importArmDisplay(String sheet_name) {
        HorizontalExcelSheet excel_sheet = new HorizontalExcelSheet(sheet_name, true, new ExcelColumn[]{new ExcelColumn("Display Name", true), new ExcelColumn("Display Description", true), new ExcelColumn("Display Language", false), new ExcelColumn("Display xml:lang", false), new ExcelColumn("Leaf ID", false), new ExcelColumn("Leaf Page Type", false), new ExcelColumn("Leaf Page Reference", false), new ExcelColumn("Leaf First Page", false), new ExcelColumn("Leaf Last Page", false), new ExcelColumn("Leaf Page Title", false), new ExcelColumn("User Note1", false), new ExcelColumn("User Note2", false), new ExcelColumn("W Display Name", false), new ExcelColumn("Result Key", true), new ExcelColumn("Result Description", true), new ExcelColumn("Result Language", false), new ExcelColumn("Result xml:lang", false), new ExcelColumn("ParameterOID Dataset", true), new ExcelColumn("Analysis Reason", true), new ExcelColumn("Analysis Purpose", true), new ExcelColumn("Documentation ID", false), new ExcelColumn("Documentation Page Type", false), new ExcelColumn("Documentation Page Reference", false), new ExcelColumn("Documentation First Page", false), new ExcelColumn("Documentation Last Page", false), new ExcelColumn("Documentation Page Title", false), new ExcelColumn("Documentation Text", false), new ExcelColumn("Documentation Language", false), new ExcelColumn("Documentation xml:lang", false), new ExcelColumn("Programming Code Context", false), new ExcelColumn("Programming Code Text", false), new ExcelColumn("Programming Code Document ID", false), new ExcelColumn("Programming Code Document Page Type", false), new ExcelColumn("Programming Code Document Page Reference", false), new ExcelColumn("Programming Code Document First Page", false), new ExcelColumn("Programming Code Document Last Page", false), new ExcelColumn("Datasets CommentOID", false), new ExcelColumn("Datasets Comment", false), new ExcelColumn("Datasets Language", false), new ExcelColumn("Datasets xml:lang", false), new ExcelColumn("Datasets DocumentID", false), new ExcelColumn("DocumentID", false), new ExcelColumn("Datasets Document Page Type", false), new ExcelColumn("Document Page Type", false), new ExcelColumn("Datasets Document Page Reference", false), new ExcelColumn("Document Page Reference", false), new ExcelColumn("Datasets Document First Page", false), new ExcelColumn("Datasets Document Last Page", false), new ExcelColumn("Datasets Document Page Title", false)});
        if (!excel_sheet.exists()) {
            return new ArrayList<ErrorLog>();
        }
        List<ErrorLog> errors = excel_sheet.validate();
        if (!errors.isEmpty()) {
            return errors;
        }
        Function<ExcelRow, List<ErrorLog>> binder = new Function<ExcelRow, List<ErrorLog>>(){
            DefineARMDisplayModel.DefineARMDisplayPk last_display_pk;
            int ordinal = 1;

            @Override
            public List<ErrorLog> apply(ExcelRow cells) {
                ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
                String result_key = ExcelCell.getAsString(cells.get("Result Key"));
                if (StringUtils.isEmpty((CharSequence)result_key)) {
                    ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'Result Key' column is required and cannot be empty. Skipping the row...");
                    error.setColumnName("Result Key");
                    rtn.add(error);
                    return rtn;
                }
                String display_name = ExcelCell.getAsString(cells.get("Display Name"));
                if (this.last_display_pk == null && StringUtils.isEmpty((CharSequence)display_name)) {
                    ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'Display Name' column is required and cannot be empty. Skipping the row...");
                    error.setColumnName("Display Name");
                    rtn.add(error);
                    return rtn;
                }
                DefineARMDisplayModel.DefineARMDisplayPk pk = new DefineARMDisplayModel.DefineARMDisplayPk(display_name);
                if (StringUtils.isNotEmpty((CharSequence)display_name) && !pk.equals(this.last_display_pk)) {
                    DefineARMDisplayModel display2 = SdtmAdamSpecImporter.this.define.get(pk);
                    if (display2 != null) {
                        String message = "The row (" + display_name + ") is duplicated. Skipping the row...";
                        ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        rtn.add(error);
                        return rtn;
                    }
                    DefineARMDisplayModel display = new DefineARMDisplayModel(pk);
                    display.ordinal = this.ordinal++;
                    display.display_desc = ExcelCell.getAsString(cells.get("Display Description"));
                    String display_lang = ExcelCell.getAsString(cells.get("Display Language"));
                    if (StringUtils.isEmpty((CharSequence)display_lang)) {
                        display_lang = ExcelCell.getAsString(cells.get("Display xml:lang"));
                    }
                    display.display_lang = display_lang;
                    List<String> leaf_ids = Utils.split(ExcelCell.getAsString(cells.get("Leaf ID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> leaf_page_types = Utils.split(ExcelCell.getAsString(cells.get("Leaf Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> leaf_page_references = Utils.split(ExcelCell.getAsString(cells.get("Leaf Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> leaf_first_pages = Utils.split(ExcelCell.getAsString(cells.get("Leaf First Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> leaf_last_pages = Utils.split(ExcelCell.getAsString(cells.get("Leaf Last Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    ArrayList leaf_page_titles = new ArrayList();
                    List leaf_document_refs = SdtmAdamSpecImporter.this.createDocumentRefs(rtn, leaf_ids, leaf_page_types, leaf_page_references, leaf_first_pages, leaf_last_pages, leaf_page_titles);
                    display.document_refs.addAll(leaf_document_refs);
                    display.user_note1 = ExcelCell.getAsString(cells.get("User Note 1"));
                    display.user_note2 = ExcelCell.getAsString(cells.get("User Note 2"));
                    SdtmAdamSpecImporter.this.define.put(pk, display);
                    this.last_display_pk = pk;
                }
                DefineARMDisplayModel last_display = SdtmAdamSpecImporter.this.define.get(this.last_display_pk);
                DefineARMResultModel.DefineARMResultPk result_pk = new DefineARMResultModel.DefineARMResultPk(display_name, result_key);
                DefineARMResultModel result2 = SdtmAdamSpecImporter.this.define.get(result_pk);
                if (result2 != null) {
                    String message = "The row (" + display_name + "/" + result_key + ") is duplicated. Skipping the row...";
                    ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                    rtn.add(error);
                    return rtn;
                }
                DefineARMResultModel result = new DefineARMResultModel(result_pk);
                result.result_desc = ExcelCell.getAsString(cells.get("Result Description"));
                String result_lang = ExcelCell.getAsString(cells.get("Result Language"));
                if (StringUtils.isEmpty((CharSequence)result_lang)) {
                    result_lang = ExcelCell.getAsString(cells.get("Result xml:lang"));
                }
                result.result_lang = result_lang;
                String param_dataset = ExcelCell.getAsString(cells.get("ParameterOID Dataset"));
                DefineVariableModel variable = SdtmAdamSpecImporter.this.define.listSortedVariable().stream().filter(o -> StringUtils.equals((CharSequence)o.variable_oid, (CharSequence)DefineVariableModel.createOid(param_dataset, "PARAMCD"))).findFirst().orElse(null);
                if (StringUtils.isNotEmpty((CharSequence)param_dataset)) {
                    if (StringUtils.isNotEmpty((CharSequence)param_dataset) && variable == null) {
                        String message = "The PARAMCD variable of the " + param_dataset + " dataset is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineDatasetTableName + " sheet. The 'ParameterOID Dataset' is ignored.";
                        ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("ParameterOID Dataset");
                        rtn.add(error);
                    } else {
                        result.param_dataset = param_dataset;
                        result.param_oid = variable.toOid();
                    }
                }
                result.analysis_reason = ExcelCell.getAsString(cells.get("Analysis Reason"));
                result.analysis_purpose = ExcelCell.getAsString(cells.get("Analysis Purpose"));
                result.docm_text = ExcelCell.getAsString(cells.get("Documentation Text"));
                String docm_lang = ExcelCell.getAsString(cells.get("Documentation Language"));
                if (StringUtils.isEmpty((CharSequence)docm_lang)) {
                    docm_lang = ExcelCell.getAsString(cells.get("Documentation xml:lang"));
                }
                result.docm_lang = docm_lang;
                List<String> docm_ids = Utils.split(ExcelCell.getAsString(cells.get("Documentation ID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> docm_page_types = Utils.split(ExcelCell.getAsString(cells.get("Documentation Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> docm_page_references = Utils.split(ExcelCell.getAsString(cells.get("Documentation Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> docm_first_pages = Utils.split(ExcelCell.getAsString(cells.get("Documentation First Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> docm_last_pages = Utils.split(ExcelCell.getAsString(cells.get("Documentation Last Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> docm_page_titles = Utils.split(ExcelCell.getAsString(cells.get("Documentation Page Title")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List docm_document_refs = SdtmAdamSpecImporter.this.createDocumentRefs(rtn, docm_ids, docm_page_types, docm_page_references, docm_first_pages, docm_last_pages, docm_page_titles);
                result.docm_document_refs.addAll(docm_document_refs);
                result.prog_code_context = ExcelCell.getAsString(cells.get("Programming Code Context"));
                result.prog_code_text = ExcelCell.getAsString(cells.get("Programming Code Text"));
                List<String> code_ids = Utils.split(ExcelCell.getAsString(cells.get("Programming Code Document ID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> code_page_types = Utils.split(ExcelCell.getAsString(cells.get("Programming Code Document Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> code_page_references = Utils.split(ExcelCell.getAsString(cells.get("Programming Code Document Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> code_first_pages = Utils.split(ExcelCell.getAsString(cells.get("Programming Code Document First Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> code_last_pages = Utils.split(ExcelCell.getAsString(cells.get("Programming Code Document Last Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List<String> code_page_titles = Utils.split(ExcelCell.getAsString(cells.get("Programming Code Document Page Title")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                List code_document_refs = SdtmAdamSpecImporter.this.createDocumentRefs(rtn, code_ids, code_page_types, code_page_references, code_first_pages, code_last_pages, code_page_titles);
                result.prog_code_document_refs.addAll(code_document_refs);
                String comment_oid = ExcelCell.getAsString(cells.get("Datasets CommentOID"));
                String str_comment = ExcelCell.getAsString(cells.get("Datasets Comment"));
                if (StringUtils.isNotEmpty((CharSequence)comment_oid)) {
                    ErrorLog error;
                    String message;
                    DefineCommentModel comment = SdtmAdamSpecImporter.this.define.listSortedComment().stream().filter(o -> StringUtils.equals((CharSequence)o.oid, (CharSequence)comment_oid)).findFirst().orElse(null);
                    if (comment == null) {
                        message = "The 'Datasets CommentOID' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineCommentTableName + " sheet. The 'Datasets CommentOID' is ignored.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("Datasets CommentOID");
                        rtn.add(error);
                    } else {
                        result.dataset_comment_oid = comment_oid;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                        message = "Either of the 'Datasets CommentOID' or 'Datasets Comment' column can be entered. The 'Datasets Comment' and associated information is ignored.";
                        error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("Datasets Comment");
                        rtn.add(error);
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                    List<String> document_page_references;
                    List<String> document_page_types;
                    result.dataset_comment_oid = DefineCommentModel.createCommentOID(result);
                    DefineCommentModel.DefineCommentPk comment_pk = new DefineCommentModel.DefineCommentPk(result.dataset_comment_oid);
                    DefineCommentModel comment = new DefineCommentModel(comment_pk);
                    comment.comment_text = str_comment;
                    String comment_lang = ExcelCell.getAsString(cells.get("Datasets Language"));
                    if (StringUtils.isEmpty((CharSequence)comment_lang)) {
                        comment_lang = ExcelCell.getAsString(cells.get("Datasets xml:lang"));
                    }
                    comment.comment_lang = comment_lang;
                    List<String> document_ids = Utils.split(ExcelCell.getAsString(cells.get("Datasets DocumentID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    if (document_ids.isEmpty()) {
                        document_ids = Utils.split(ExcelCell.getAsString(cells.get("DocumentID")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    }
                    if ((document_page_types = Utils.split(ExcelCell.getAsString(cells.get("Datasets Document Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter)).isEmpty()) {
                        document_page_types = Utils.split(ExcelCell.getAsString(cells.get("Document Page Type")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    }
                    if ((document_page_references = Utils.split(ExcelCell.getAsString(cells.get("Datasets Document Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter)).isEmpty()) {
                        document_page_references = Utils.split(ExcelCell.getAsString(cells.get("Document Page Reference")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    }
                    List<String> document_first_pages = Utils.split(ExcelCell.getAsString(cells.get("Datasets Document First Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_last_pages = Utils.split(ExcelCell.getAsString(cells.get("Datasets Document Last Page")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List<String> document_page_titles = Utils.split(ExcelCell.getAsString(cells.get("Datasets Document Page Title")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    List document_refs = SdtmAdamSpecImporter.this.createDocumentRefs(rtn, document_ids, document_page_types, document_page_references, document_first_pages, document_last_pages, document_page_titles);
                    comment.document_refs.addAll(document_refs);
                    SdtmAdamSpecImporter.this.define.put(comment_pk, comment);
                } else {
                    String document_id = ExcelCell.getAsString(cells.get("Datasets DocumentID"));
                    if (StringUtils.isEmpty((CharSequence)document_id)) {
                        document_id = ExcelCell.getAsString(cells.get("DocumentID"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)document_id)) {
                        String message = "The 'Datasets Comment' column is required when 'Datasets DocumentID' is entered. The 'Datasets DocumentID' and associated information is ignored.";
                        ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                        error.setColumnName("Datasets Comment");
                        rtn.add(error);
                    }
                }
                last_display.arm_result_pks.add(result_pk);
                SdtmAdamSpecImporter.this.define.put(result_pk, result);
                return rtn;
            }
        };
        return excel_sheet.doImport(binder);
    }

    List<ErrorLog> importArmDataset(String sheet_name) {
        HorizontalExcelSheet excel_sheet = new HorizontalExcelSheet(sheet_name, true, new ExcelColumn[]{new ExcelColumn("Display Name", true), new ExcelColumn("Result Key", true), new ExcelColumn("Dataset Name", true), new ExcelColumn("Analysis Variable", true), new ExcelColumn("User Note1", false), new ExcelColumn("User Note2", false), new ExcelColumn("W Display Name", false), new ExcelColumn("W Result Key", false), new ExcelColumn("W Dataset Name", false), new ExcelColumn("WhereClauseDataset", true), new ExcelColumn("WhereClauseVariable", true), new ExcelColumn("WhereClauseOperator", true), new ExcelColumn("WhereClauseValue", true), new ExcelColumn("WhereClause CommentOID", false), new ExcelColumn("WhereClause Comment", false), new ExcelColumn("WhereClause Language", false), new ExcelColumn("W xml:lang", false)});
        if (!excel_sheet.exists()) {
            return new ArrayList<ErrorLog>();
        }
        List<ErrorLog> errors = excel_sheet.validate();
        if (!errors.isEmpty()) {
            return errors;
        }
        Function<ExcelRow, List<ErrorLog>> binder = new Function<ExcelRow, List<ErrorLog>>(){
            DefineARMDatasetModel.DefineARMDatasetPk last_arm_dataset_pk;
            DefineWCModel.DefineWCPk last_wc_pk;
            int ordinal = 1;

            @Override
            public List<ErrorLog> apply(ExcelRow cells) {
                ErrorLog error;
                String message;
                ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
                String wc_dataset = ExcelCell.getAsString(cells.get("WhereClauseDataset"));
                String wc_variable = ExcelCell.getAsString(cells.get("WhereClauseVariable"));
                String wc_operator = ExcelCell.getAsString(cells.get("WhereClauseOperator"));
                String wc_value = ExcelCell.getAsString(cells.get("WhereClauseValue"));
                String display_name = ExcelCell.getAsString(cells.get("Display Name"));
                String result_key = ExcelCell.getAsString(cells.get("Result Key"));
                String dataset_name = ExcelCell.getAsString(cells.get("Dataset Name"));
                if (this.last_arm_dataset_pk == null) {
                    if (StringUtils.isEmpty((CharSequence)display_name)) {
                        ErrorLog error2 = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'Display Name' column is required and cannot be empty. Skipping the row...");
                        error2.setColumnName("Display Name");
                        rtn.add(error2);
                        return rtn;
                    }
                    if (StringUtils.isEmpty((CharSequence)result_key)) {
                        ErrorLog error3 = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'Result Key' column is required and cannot be empty. Skipping the row...");
                        error3.setColumnName("Result Key");
                        rtn.add(error3);
                        return rtn;
                    }
                    if (StringUtils.isEmpty((CharSequence)dataset_name)) {
                        ErrorLog error4 = new ErrorLog(ErrorLog.ErrorLevel.WARN, "The 'Dataset Name' column is required and cannot be empty. Skipping the row...");
                        error4.setColumnName("Dataset Name");
                        rtn.add(error4);
                        return rtn;
                    }
                }
                DefineARMDatasetModel.DefineARMDatasetPk pk = new DefineARMDatasetModel.DefineARMDatasetPk(display_name, result_key, DefineDatasetModel.createOid(dataset_name));
                if (StringUtils.isNotEmpty((CharSequence)display_name) && StringUtils.isNotEmpty((CharSequence)result_key) && StringUtils.isNotEmpty((CharSequence)dataset_name) && !pk.equals(this.last_arm_dataset_pk)) {
                    DefineARMDatasetModel arm_dataset2 = SdtmAdamSpecImporter.this.define.get(pk);
                    if (arm_dataset2 != null) {
                        String message2 = "The row (" + display_name + "/" + result_key + "/" + dataset_name + ") is duplicated. Skipping the row...";
                        ErrorLog error5 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message2);
                        rtn.add(error5);
                        return rtn;
                    }
                    DefineDatasetModel dataset = SdtmAdamSpecImporter.this.define.get(new DefineDatasetModel.DefineDatasetPk(dataset_name));
                    if (dataset == null) {
                        String message3 = "The dataset " + dataset_name + "is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineDatasetTableName + " sheet. Skipping the row...";
                        ErrorLog error6 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message3);
                        rtn.add(error6);
                        return rtn;
                    }
                    DefineARMDatasetModel arm_dataset = new DefineARMDatasetModel(pk);
                    arm_dataset.dataset_name = dataset_name;
                    arm_dataset.dataset_oid = dataset.toOid();
                    arm_dataset.ordinal = this.ordinal++;
                    List<String> analysis_variables = Utils.split(ExcelCell.getAsString(cells.get("Analysis Variable")), ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter);
                    for (String analysis_variable : analysis_variables) {
                        String analysis_variable_oid = DefineVariableModel.createOid(dataset_name, analysis_variable);
                        DefineVariableModel variable = SdtmAdamSpecImporter.this.define.listSortedVariable().stream().filter(o -> StringUtils.equals((CharSequence)o.variable_oid, (CharSequence)analysis_variable_oid)).findFirst().orElse(null);
                        if (variable == null) {
                            message = "The variable " + analysis_variable + " is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineVariableTableName + " sheet. The 'Analysis Variable' is ignored.";
                            error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                            error.setColumnName("Analysis Variable");
                            rtn.add(error);
                            continue;
                        }
                        arm_dataset.analysis_variable_oids.add(analysis_variable_oid);
                    }
                    arm_dataset.user_note1 = ExcelCell.getAsString(cells.get("User Note1"));
                    arm_dataset.user_note2 = ExcelCell.getAsString(cells.get("User Note2"));
                    SdtmAdamSpecImporter.this.define.put(pk, arm_dataset);
                    this.last_arm_dataset_pk = pk;
                }
                DefineARMDatasetModel last_arm_dataset = SdtmAdamSpecImporter.this.define.get(this.last_arm_dataset_pk);
                String wc_oid = DefineWCModel.createOid(last_arm_dataset);
                DefineWCModel wc = null;
                DefineWCModel.DefineWCPk wc_pk = new DefineWCModel.DefineWCPk(wc_oid);
                if (wc_pk.equals(this.last_wc_pk)) {
                    wc = SdtmAdamSpecImporter.this.define.get(this.last_wc_pk);
                    DefineWCModel.WCCondition wc_condition = new DefineWCModel.WCCondition();
                    wc_condition.dataset_name = wc_dataset;
                    wc_condition.variable_name = wc_variable;
                    wc_condition.operator = wc_operator;
                    wc_condition.values.addAll(Utils.split(wc_value, ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter));
                    wc.wc_conditions.add(wc_condition);
                } else {
                    DefineWCModel wc2 = SdtmAdamSpecImporter.this.define.get(wc_pk);
                    if (wc2 != null) {
                        String message4 = "The row (" + wc_dataset + "/" + wc_variable + "/" + wc_operator + "/" + wc_value + ") is duplicated. Skipping the row...";
                        ErrorLog error7 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message4);
                        rtn.add(error7);
                        return rtn;
                    }
                    wc = new DefineWCModel(wc_pk);
                    String comment_oid = ExcelCell.getAsString(cells.get("WhereClause CommentOID"));
                    String str_comment = ExcelCell.getAsString(cells.get("WhereClause Comment"));
                    if (StringUtils.isNotEmpty((CharSequence)comment_oid)) {
                        DefineCommentModel comment = SdtmAdamSpecImporter.this.define.listSortedComment().stream().filter(o -> StringUtils.equals((CharSequence)o.oid, (CharSequence)comment_oid)).findFirst().orElse(null);
                        if (comment == null) {
                            message = "The 'CommentOID' is not found in the " + ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.defineCommentTableName + " sheet. The 'CommentOID' is ignored.";
                            error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                            error.setColumnName("CommentOID");
                            rtn.add(error);
                        } else {
                            wc.comment_oid = comment_oid;
                        }
                        if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                            message = "Either of the 'WhereClause CommentOID' or 'WhereClause Comment' column can be entered. The 'WhereClause Comment' and associated information is ignored.";
                            error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                            error.setColumnName("WhereClause Comment");
                            rtn.add(error);
                        }
                    } else if (StringUtils.isNotEmpty((CharSequence)str_comment)) {
                        wc.comment_oid = DefineCommentModel.createCommentOID(wc);
                        DefineCommentModel.DefineCommentPk comment_pk = new DefineCommentModel.DefineCommentPk(wc.comment_oid);
                        DefineCommentModel comment = new DefineCommentModel(comment_pk);
                        comment.comment_text = str_comment;
                        String comment_lang = ExcelCell.getAsString(cells.get("WhereClause Language"));
                        if (StringUtils.isEmpty((CharSequence)comment_lang)) {
                            comment_lang = ExcelCell.getAsString(cells.get("W xml:lang"));
                        }
                        comment.comment_lang = comment_lang;
                        SdtmAdamSpecImporter.this.define.put(comment_pk, comment);
                    }
                    DefineWCModel.WCCondition wc_condition = new DefineWCModel.WCCondition();
                    wc_condition.dataset_name = wc_dataset;
                    wc_condition.variable_name = wc_variable;
                    wc_condition.operator = wc_operator;
                    wc_condition.values.addAll(Utils.split(wc_value, ((SdtmAdamSpecImporter)SdtmAdamSpecImporter.this).config.valueDelimiter));
                    wc.wc_conditions.add(wc_condition);
                    last_arm_dataset.where_clause_pk = wc_pk;
                    SdtmAdamSpecImporter.this.define.put(wc_pk, wc);
                }
                this.last_wc_pk = wc_pk;
                return rtn;
            }
        };
        return excel_sheet.doImport(binder);
    }

    private List<DefineModel.DocumentRef> createDocumentRefs(List<ErrorLog> error_logs, List<String> document_ids, List<String> document_page_types, List<String> document_page_references, List<String> document_first_pages, List<String> document_last_pages, List<String> document_page_titles) {
        ErrorLog error;
        String message;
        ArrayList<DefineModel.DocumentRef> rtn = new ArrayList<DefineModel.DocumentRef>();
        if (document_ids.isEmpty()) {
            return rtn;
        }
        if (document_page_types.size() > 0 && document_page_types.size() != document_ids.size()) {
            message = "The count of 'Document Page Type' is different from the count of 'Document ID'. The 'Document Page Type' and associated information is ignored.";
            error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
            error.setColumnName("Document Page Type");
            error_logs.add(error);
            document_page_types = new ArrayList<String>();
            document_page_references = new ArrayList<String>();
            document_first_pages = new ArrayList<String>();
            document_last_pages = new ArrayList<String>();
        } else {
            if (document_page_references.size() > 0 && document_page_references.size() != document_ids.size()) {
                message = "The count of 'Document Page Reference' is different from the count of 'Document ID'. The 'Document Page Reference' and associated information is ignored.";
                error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                error.setColumnName("Document Page Reference");
                error_logs.add(error);
                document_page_references = new ArrayList<String>();
            }
            if (document_page_references.size() > 0 && (document_first_pages.size() > 0 || document_last_pages.size() > 0)) {
                message = "The 'Document First Page' and 'Document Last Page' columns are ignored when 'Document Page Reference' is filled out.";
                error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                error.setColumnName("Document First Page, Document Last Page");
                error_logs.add(error);
                document_first_pages = new ArrayList<String>();
                document_last_pages = new ArrayList<String>();
            }
            if (document_first_pages.size() > 0 && document_first_pages.size() != document_ids.size() || document_last_pages.size() > 0 && document_last_pages.size() != document_ids.size()) {
                message = "The count of 'Document First Page' or 'Document Last Page' is different from the count of 'Document ID'. The columns are ignored.";
                error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                error.setColumnName("Document First Page, Document Last Page");
                error_logs.add(error);
                document_first_pages = new ArrayList<String>();
                document_last_pages = new ArrayList<String>();
            }
            if (document_page_titles.size() > 0 && document_page_titles.size() != document_ids.size()) {
                message = "The count of 'Document Page Title' is different from the count of 'Document ID'. The column is ignored.";
                error = new ErrorLog(ErrorLog.ErrorLevel.WARN, message);
                error.setColumnName("Document Page Title");
                error_logs.add(error);
                document_page_titles = new ArrayList<String>();
            }
        }
        for (int i = 0; i < document_ids.size(); ++i) {
            String document_id = document_ids.get(i);
            DefineDocumentModel document = this.define.listSortedDocument().stream().filter(o -> StringUtils.equals((CharSequence)o.document_id, (CharSequence)document_id)).findFirst().orElse(null);
            if (document == null) {
                String message2 = "The 'DocumentID' is not found in the " + this.config.defineDocumentTableName + " sheet. The 'DocumentID' and associated information is ignored.";
                ErrorLog error2 = new ErrorLog(ErrorLog.ErrorLevel.WARN, message2);
                error2.setColumnName("DocumentID");
                error_logs.add(error2);
                continue;
            }
            DefineModel.DocumentRef document_ref = new DefineModel.DocumentRef(document_id);
            if (!document_page_types.isEmpty()) {
                document_ref.document_page_type = document_page_types.get(i);
            }
            if (!document_page_references.isEmpty()) {
                document_ref.document_page_reference = document_page_references.get(i);
            }
            if (!document_first_pages.isEmpty()) {
                document_ref.document_first_page = document_first_pages.get(i);
            }
            if (!document_last_pages.isEmpty()) {
                document_ref.document_last_page = document_last_pages.get(i);
            }
            if (!document_page_titles.isEmpty()) {
                document_ref.document_page_title = document_page_titles.get(i);
            }
            rtn.add(document_ref);
        }
        return rtn;
    }

    private Config.DatasetType findDatasetType() {
        List<DefineStandardModel> standards;
        DefineStandardModel standard;
        DefineStudyModel study = this.define.getStudy();
        if (study != null && StringUtils.isNotEmpty((CharSequence)study.standard_name)) {
            if (StringUtils.startsWith((CharSequence)study.standard_name, (CharSequence)"SDTM")) {
                return Config.DatasetType.SDTM;
            }
            if (StringUtils.startsWith((CharSequence)study.standard_name, (CharSequence)"SEND")) {
                return Config.DatasetType.SEND;
            }
            if (StringUtils.startsWith((CharSequence)study.standard_name, (CharSequence)"ADaM")) {
                return Config.DatasetType.ADaM;
            }
        }
        if ((standard = (DefineStandardModel)(standards = this.define.listSortedStandard()).stream().filter(o -> StringUtils.startsWith((CharSequence)o.standard_name, (CharSequence)"ADaM")).findFirst().orElse(null)) != null) {
            return Config.DatasetType.ADaM;
        }
        standard = standards.stream().filter(o -> StringUtils.startsWith((CharSequence)o.standard_name, (CharSequence)"SDTM")).findFirst().orElse(null);
        if (standard != null) {
            return Config.DatasetType.SDTM;
        }
        standard = standards.stream().filter(o -> StringUtils.startsWith((CharSequence)o.standard_name, (CharSequence)"SEND")).findFirst().orElse(null);
        if (standard != null) {
            return Config.DatasetType.SEND;
        }
        return Config.DatasetType.ADaM;
    }

    public DefineModel getDefineModel() {
        return this.define;
    }

    public void setDefineModel(DefineModel define) {
        this.define = define;
    }

    private static class ExcelCell {
        private ExcelCell() {
        }

        public static String getAsString(Cell cell) {
            if (cell == null) {
                return "";
            }
            CellType cell_type = cell.getCellTypeEnum();
            switch (cell_type) {
                case STRING: {
                    return cell.getStringCellValue();
                }
                case BOOLEAN: {
                    return String.valueOf(cell.getBooleanCellValue());
                }
                case FORMULA: {
                    return cell.getCellFormula();
                }
                case NUMERIC: {
                    return String.valueOf(cell.getNumericCellValue());
                }
                case ERROR: {
                    return String.valueOf(cell.getErrorCellValue());
                }
            }
            return "";
        }

        public static int getAsInteger(Cell cell) {
            if (cell == null) {
                return 0;
            }
            String val = ExcelCell.getAsString(cell);
            try {
                val = StringUtils.removeEnd((String)val, (String)".0");
                return Integer.parseInt(val);
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }
    }

    private class ExcelColumn {
        String name = "";
        boolean is_required = false;

        public ExcelColumn(String name, boolean is_required) {
            this.name = name;
            this.is_required = is_required;
        }
    }

    private class ExcelRow {
        private Map<String, Cell> cells = new HashMap<String, Cell>();

        private ExcelRow() {
        }

        public void put(String key, Cell cell) {
            this.cells.put(StringUtils.deleteWhitespace((String)key).toUpperCase(), cell);
        }

        public Cell get(String key) {
            return this.cells.get(StringUtils.deleteWhitespace((String)key).toUpperCase());
        }
    }

    private class HorizontalExcelSheet
    extends ExcelSheet {
        final int HEADER_ROW_NUM = 0;
        final int FIRST_ROW_NUM = 1;
        final int FIRST_COLUMN_NUM = 0;

        public HorizontalExcelSheet(String name, boolean is_required, ExcelColumn[] columns) {
            this.HEADER_ROW_NUM = 0;
            this.FIRST_ROW_NUM = 1;
            this.FIRST_COLUMN_NUM = 0;
            this.name = name;
            this.is_required = is_required;
            this.sheet_type = SheetType.Horizontal;
            this.columns = columns;
        }

        public boolean exists() {
            Sheet sheet = SdtmAdamSpecImporter.this.workbook.getSheet(this.name);
            return sheet != null;
        }

        public int getHeaderRowNum() {
            return 0;
        }

        public int getFirstRowNum() {
            return 1;
        }

        public int getFirstColumnNum() {
            return 0;
        }

        public List<ErrorLog> validate() {
            ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
            Sheet sheet = SdtmAdamSpecImporter.this.workbook.getSheet(this.name);
            if (sheet == null) {
                ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.ERROR, "The sheet '" + this.name + "' is not found in the given spreadsheet.");
                rtn.add(error);
                return rtn;
            }
            ArrayList<String> actual_column_names = new ArrayList<String>();
            Row header_row = sheet.getRow(this.getHeaderRowNum());
            if (header_row == null) {
                String message = "A header row is not found.";
                ErrorLog error = new ErrorLog(this.name, this.getHeaderRowNum() + 1, "", ErrorLog.ErrorLevel.ERROR, message);
                rtn.add(error);
            } else {
                for (int i = 0; i <= header_row.getLastCellNum(); ++i) {
                    Cell cell = header_row.getCell(i);
                    if (cell == null) continue;
                    String column_name = ExcelCell.getAsString(cell);
                    actual_column_names.add(StringUtils.deleteWhitespace((String)column_name).toUpperCase());
                }
                for (ExcelColumn column : this.columns) {
                    String column_name;
                    if (!column.is_required || actual_column_names.indexOf(column_name = StringUtils.deleteWhitespace((String)column.name).toUpperCase()) != -1) continue;
                    String message = "A required column '" + column.name + "' is not found.";
                    ErrorLog error = new ErrorLog(this.name, this.getHeaderRowNum() + 1, "", ErrorLog.ErrorLevel.ERROR, message);
                    rtn.add(error);
                }
            }
            return rtn;
        }

        public List<ErrorLog> doImport(Function<ExcelRow, List<ErrorLog>> binder) {
            ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
            Sheet sheet = SdtmAdamSpecImporter.this.workbook.getSheet(this.name);
            this.getClass();
            Row header_row = sheet.getRow(0);
            for (int rowNum = this.getFirstRowNum(); rowNum <= sheet.getLastRowNum(); ++rowNum) {
                Row row = sheet.getRow(rowNum);
                ExcelRow cells = new ExcelRow();
                for (int cellNum = this.getFirstColumnNum(); cellNum <= row.getLastCellNum(); ++cellNum) {
                    String key = ExcelCell.getAsString(header_row.getCell(cellNum));
                    if (StringUtils.isEmpty((CharSequence)key)) continue;
                    cells.put(key, row.getCell(cellNum));
                }
                List<ErrorLog> errors = binder.apply(cells);
                for (ErrorLog error : errors) {
                    error.setTabName(this.name);
                    error.setLineNum(rowNum + 1);
                }
                rtn.addAll(errors);
            }
            return rtn;
        }
    }

    private class VerticalExcelSheet
    extends ExcelSheet {
        final int KEY_COLUMN_NUM = 0;
        final int VALUE_COLUMN_NUM = 1;
        final int FIRST_ROW_NUM = 1;

        public VerticalExcelSheet(String name, boolean is_required, ExcelColumn[] columns) {
            this.KEY_COLUMN_NUM = 0;
            this.VALUE_COLUMN_NUM = 1;
            this.FIRST_ROW_NUM = 1;
            this.name = name;
            this.is_required = is_required;
            this.sheet_type = SheetType.Vertical;
            this.columns = columns;
        }

        public int getKeyColumnNum() {
            return 0;
        }

        public int getValueColumnNum() {
            return 1;
        }

        public int getFirstRowNum() {
            return 1;
        }

        public List<ErrorLog> validate() {
            ArrayList<ErrorLog> rtn = new ArrayList<ErrorLog>();
            Sheet sheet = SdtmAdamSpecImporter.this.workbook.getSheet(this.name);
            if (sheet == null) {
                ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.ERROR, "The sheet '" + this.name + "' is not found in the given spreadsheet.");
                rtn.add(error);
                return rtn;
            }
            ArrayList<String> actual_column_names = new ArrayList<String>();
            for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
                Row row = sheet.getRow(i);
                Cell cell = row.getCell(this.getKeyColumnNum());
                if (cell == null) continue;
                actual_column_names.add(ExcelCell.getAsString(cell));
            }
            for (ExcelColumn column : this.columns) {
                if (!column.is_required || actual_column_names.indexOf(column.name) != -1) continue;
                String message = "A required property '" + column.name + "' is not found.";
                ErrorLog error = new ErrorLog(ErrorLog.ErrorLevel.ERROR, message);
                error.setTabName(this.name);
                error.setColumnNum(this.getKeyColumnNum() + 1);
                rtn.add(error);
            }
            return rtn;
        }

        public List<ErrorLog> doImport(Function<ExcelRow, List<ErrorLog>> binder) {
            Sheet sheet = SdtmAdamSpecImporter.this.workbook.getSheet(this.name);
            ExcelRow cells = new ExcelRow();
            for (int rowNum = this.getFirstRowNum(); rowNum <= sheet.getLastRowNum(); ++rowNum) {
                Row row = sheet.getRow(rowNum);
                String key = ExcelCell.getAsString(row.getCell(this.getKeyColumnNum()));
                if (StringUtils.isEmpty((CharSequence)key)) continue;
                cells.put(key, row.getCell(this.getValueColumnNum()));
            }
            return binder.apply(cells);
        }
    }

    private abstract class ExcelSheet {
        String name;
        boolean is_required;
        SheetType sheet_type;
        ExcelColumn[] columns = new ExcelColumn[0];

        private ExcelSheet() {
        }
    }

    private static enum SheetType {
        Vertical,
        Horizontal;

    }
}

