/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer.models;

import com.fujitsu.tsc.desktop.importer.models.DefineARMResultModel;
import com.fujitsu.tsc.desktop.importer.models.DefineModel;
import com.fujitsu.tsc.desktop.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefineARMDisplayModel
implements Comparable<DefineARMDisplayModel> {
    public final String display_name;
    public Integer ordinal;
    public String display_desc;
    public String display_lang;
    public List<DefineModel.DocumentRef> document_refs;
    public String user_note1;
    public String user_note2;
    public List<DefineARMResultModel.DefineARMResultPk> arm_result_pks;

    public DefineARMDisplayModel(DefineARMDisplayPk key) {
        this.display_name = key.display_name;
        this.ordinal = 0;
        this.display_desc = "";
        this.display_lang = "";
        this.document_refs = new ArrayList<DefineModel.DocumentRef>();
        this.user_note1 = "";
        this.user_note2 = "";
        this.arm_result_pks = new ArrayList<DefineARMResultModel.DefineARMResultPk>();
    }

    public void copy(DefineARMDisplayModel arm) {
        if (arm.ordinal > 0) {
            this.ordinal = arm.ordinal;
        }
        if (!StringUtils.isEmpty((CharSequence)arm.display_desc)) {
            this.display_desc = arm.display_desc;
        }
        if (!StringUtils.isEmpty((CharSequence)arm.display_lang)) {
            this.display_lang = arm.display_lang;
        }
        if (!arm.document_refs.isEmpty()) {
            this.document_refs = arm.document_refs;
        }
        if (arm.arm_result_pks != null && !arm.arm_result_pks.isEmpty()) {
            this.arm_result_pks = arm.arm_result_pks;
        }
    }

    public String toOid() {
        return "RD." + Utils.codedText(this.display_name);
    }

    public String getDocumentIdString(String delimiter) {
        String rtn = "";
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_id;
        }
        return rtn;
    }

    public String getDocumentPageTypeString(String delimiter) {
        String rtn = "";
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_page_type;
        }
        return rtn;
    }

    public String getDocumentPageRefString(String delimiter) {
        String rtn = "";
        if (this.document_refs.isEmpty()) {
            return rtn;
        }
        List document_page_references = this.document_refs.stream().map(o -> o.document_page_reference).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_page_references.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_page_reference;
        }
        return rtn;
    }

    public String getDocumentFirstPageString(String delimiter) {
        String rtn = "";
        if (this.document_refs.isEmpty()) {
            return rtn;
        }
        List document_first_pages = this.document_refs.stream().map(o -> o.document_first_page).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_first_pages.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_first_page;
        }
        return rtn;
    }

    public String getDocumentLastPageString(String delimiter) {
        String rtn = "";
        if (this.document_refs.isEmpty()) {
            return rtn;
        }
        List document_last_pages = this.document_refs.stream().map(o -> o.document_last_page).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_last_pages.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_last_page;
        }
        return rtn;
    }

    @Override
    public int compareTo(DefineARMDisplayModel arm) {
        return this.display_name.compareTo(arm.display_name);
    }

    public static class DefineARMDisplayPk
    implements Comparable<DefineARMDisplayPk> {
        public final String display_name;

        public DefineARMDisplayPk(String display_name) {
            this.display_name = display_name;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.display_name.equals(((DefineARMDisplayPk)obj).display_name);
        }

        @Override
        public int compareTo(DefineARMDisplayPk key) {
            return this.display_name.compareTo(key.display_name);
        }

        public String toString() {
            String rtn = "Display Name: " + this.display_name;
            return rtn;
        }

        public int hashCode() {
            return Objects.hash(this.display_name);
        }
    }
}

