/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.util;

import com.fujitsu.tsc.desktop.util.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    public static List<String> split(String s, String delimiter) {
        ArrayList<String> rtn = new ArrayList<String>();
        String[] values = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)s, (String)delimiter);
        if (values == null) {
            return rtn;
        }
        for (String value : values) {
            rtn.add(StringUtils.trim((String)value));
        }
        return rtn;
    }

    public static String join(List<String> values, String delimiter) {
        String rtn = "";
        if (values == null || values.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + values.get(i);
        }
        return rtn;
    }

    public static String codedText(String s) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return "";
        }
        return RegExUtils.removeAll((String)s, (Pattern)Pattern.compile("[^a-zA-Z._0-9]"));
    }

    public static String deriveDomain(Config.DatasetType standard_type, String dataset_name) {
        String domain = "";
        if (StringUtils.isEmpty((CharSequence)dataset_name)) {
            return domain;
        }
        if (standard_type == Config.DatasetType.ADaM) {
            return domain;
        }
        if (dataset_name.length() < 2) {
            return domain;
        }
        domain = dataset_name.startsWith("SUPP") && dataset_name.length() >= 6 && !"SUPPQUAL".equals(dataset_name) ? StringUtils.substring((String)dataset_name, (int)4, (int)6) : StringUtils.substring((String)dataset_name, (int)0, (int)2);
        return domain;
    }

    public static boolean isSplitDataset(Config.DatasetType standard_type, String dataset_name) {
        boolean rtn = false;
        if (StringUtils.isEmpty((CharSequence)dataset_name)) {
            return rtn;
        }
        if (standard_type == Config.DatasetType.ADaM) {
            return rtn;
        }
        rtn = dataset_name.length() == 4 ? true : dataset_name.startsWith("SUPP") && dataset_name.length() == 8 && !"SUPPQUAL".equals(dataset_name);
        return rtn;
    }
}

