/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.exporter;

import com.fujitsu.tsc.desktop.util.MetaDataReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class SuppUtil {
    private boolean is_autosupp_active = false;
    private ArrayList<SuppDataset> supp_datasets = new ArrayList();
    private final Set<String> supp_dataset_names;
    private ArrayList<Variable> qval_values = new ArrayList();
    private final Set<String> qval_value_keys;
    private Hashtable seqList = new Hashtable();

    public SuppUtil(MetaDataReader reader1, MetaDataReader reader2) {
        Hashtable<String, String> hash;
        while ((hash = reader2.read()) != null) {
            String variable_name = hash.get("Variable Name");
            String str_is_supp = hash.get("Is SUPP");
            String str_repeat_n = hash.get("Repeat N");
            int repeat_n = SuppUtil.parseRepeatN(str_repeat_n);
            if (!StringUtils.isEmpty((CharSequence)str_is_supp) && "Yes".equals(str_is_supp) || repeat_n > 0 && !"TSVAL".equals(variable_name) && !"COVAL".equals(variable_name)) {
                int start;
                for (int i = start = "Yes".equals(str_is_supp) ? 0 : 1; i <= repeat_n; ++i) {
                    Variable qval_value = new Variable();
                    qval_value.dataset_name = hash.get("Dataset Name");
                    qval_value.variable_name = SuppUtil.getRepeatVariableName(variable_name, i);
                    qval_value.label = SuppUtil.getRepeatVariableLabel(hash.get("Label"), i);
                    qval_value.data_type = hash.get("DataType");
                    qval_value.length = SuppUtil.getRepeatLength(hash.get("Length"), i);
                    qval_value.sig_digits = hash.get("SignificantDigits");
                    qval_value.origin.origin = hash.get("Origin");
                    qval_value.origin.crf_id = hash.get("CRF ID");
                    qval_value.origin.crf_page_type = hash.get("CRF Page Type");
                    qval_value.origin.str_crf_page_reference = hash.get("CRF Page Reference");
                    qval_value.mandatory = hash.get("Mandatory");
                    this.qval_values.add(qval_value);
                }
            }
            if (str_is_supp == null || str_is_supp.equals("Yes") || !variable_name.endsWith("SEQ") || variable_name.length() != 5 || hash.get("Length") == null) continue;
            this.seqList.put(hash.get("Dataset Name"), hash.get("Length"));
        }
        Set supp_dataset_set = this.qval_values.stream().map(o -> o.dataset_name).collect(Collectors.toSet());
        while ((hash = reader1.read()) != null) {
            String dataset_name = hash.get("Dataset Name");
            IsEmpty is_empty = IsEmpty.parse(hash.get("Is Empty"));
            if (!supp_dataset_set.contains(dataset_name) || is_empty != IsEmpty.No) continue;
            SuppDataset dataset = new SuppDataset();
            dataset.domain = hash.get("Domain");
            dataset.dataset_name = dataset_name;
            this.supp_datasets.add(dataset);
        }
        if (!this.supp_datasets.isEmpty()) {
            this.is_autosupp_active = true;
        }
        this.supp_dataset_names = this.supp_datasets.stream().map(o -> o.dataset_name).collect(Collectors.toSet());
        this.qval_value_keys = this.qval_values.stream().map(o -> o.dataset_name + "/" + o.variable_name).collect(Collectors.toSet());
    }

    public boolean isAutoSuppActive() {
        return this.is_autosupp_active;
    }

    public List<SuppDataset> listSuppDatasets() {
        return this.supp_datasets;
    }

    public Set<String> getSuppDatasetNames() {
        return this.supp_dataset_names;
    }

    public List<Variable> listSuppVariables() {
        return this.qval_values;
    }

    public List<Variable> listSuppVariables(String dataset_name) {
        if (StringUtils.isEmpty((CharSequence)dataset_name)) {
            return new ArrayList<Variable>();
        }
        return this.qval_values.stream().filter(o -> StringUtils.equals((CharSequence)dataset_name, (CharSequence)o.dataset_name)).collect(Collectors.toList());
    }

    public Set<String> getSuppVariableNames() {
        return this.qval_value_keys;
    }

    public static int parseRepeatN(String str_repeat_n) {
        int repeat_n = 0;
        if (StringUtils.isEmpty((CharSequence)str_repeat_n)) {
            return repeat_n;
        }
        try {
            repeat_n = Integer.parseInt(str_repeat_n);
            if (repeat_n > 99) {
                repeat_n = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return repeat_n;
    }

    public static String getRepeatIsSupp(String variable_name, String is_supp, int N) {
        if (StringUtils.isEmpty((CharSequence)variable_name)) {
            return "No";
        }
        if (StringUtils.isEmpty((CharSequence)is_supp)) {
            return "No";
        }
        if (N == 0) {
            return is_supp;
        }
        if (N > 0 && !"TSVAL".equals(variable_name) && !"COVAL".equals(variable_name)) {
            return "Yes";
        }
        return "No";
    }

    public static String getRepeatVariableName(String variable_name, int N) {
        if (StringUtils.isEmpty((CharSequence)variable_name)) {
            return variable_name;
        }
        if (N == 0) {
            return variable_name;
        }
        variable_name = variable_name.length() >= 8 && 1 <= N && N < 10 ? variable_name.substring(0, 7) + N : (variable_name.length() == 7 && 10 <= N && N < 100 ? variable_name.substring(0, 6) + N : variable_name + N);
        return variable_name;
    }

    public static String getRepeatVariableLabel(String variable_label, int N) {
        if (StringUtils.isEmpty((CharSequence)variable_label)) {
            return variable_label;
        }
        if (N == 0) {
            return variable_label;
        }
        variable_label = variable_label.length() >= 39 && 1 <= N && N < 10 ? variable_label.substring(0, 38) + " " + N : (variable_label.length() == 38 && 10 <= N && N < 100 ? variable_label.substring(0, 37) + " " + N : variable_label + " " + N);
        return variable_label;
    }

    public static String getRepeatLength(String strLength, int N) {
        if (StringUtils.isEmpty((CharSequence)strLength)) {
            return "";
        }
        if (N == 0) {
            return strLength;
        }
        try {
            int length = Integer.parseInt(strLength);
            if ((length -= 200 * N) < 1) {
                length = 1;
            }
            return String.valueOf(length);
        }
        catch (NumberFormatException ex) {
            return "";
        }
    }

    public static String getRepeatSasFieldName(String r_variable_name, String sas_field_name, int N) {
        if (StringUtils.isEmpty((CharSequence)sas_field_name)) {
            return r_variable_name;
        }
        return SuppUtil.getRepeatVariableName(sas_field_name, N);
    }

    public int getQnamLength(String dataset) {
        List<Variable> variables = null;
        int length = 0;
        variables = this.listSuppVariables(dataset);
        for (Variable var : variables) {
            if (var.variable_name == null || length >= var.variable_name.length()) continue;
            length = var.variable_name.length();
        }
        return length;
    }

    public int getQlabelLength(String dataset) {
        List<Variable> variables = null;
        int length = 0;
        variables = this.listSuppVariables(dataset);
        for (Variable var : variables) {
            if (var.label == null || length >= var.label.length()) continue;
            length = var.label.length();
        }
        return length;
    }

    public String getQvalDataType(String dataset) {
        List<Variable> variables = this.listSuppVariables(dataset);
        String DEFAULT_TYPE = "text";
        if (variables == null) {
            return DEFAULT_TYPE;
        }
        String data_type = DEFAULT_TYPE;
        for (int i = 0; i < variables.size(); ++i) {
            Variable var = variables.get(i);
            if (var == null) continue;
            if (i == 0) {
                data_type = var.data_type;
                continue;
            }
            if (StringUtils.equals((CharSequence)data_type, (CharSequence)var.data_type)) continue;
            return DEFAULT_TYPE;
        }
        return data_type;
    }

    public String getQvalLength(String dataset) {
        List<Variable> variables = null;
        int length = 0;
        variables = this.listSuppVariables(dataset);
        for (Variable var : variables) {
            try {
                if (!StringUtils.isNotEmpty((CharSequence)var.length) || length >= Integer.parseInt(var.length)) continue;
                length = Integer.parseInt(var.length);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (length > 0) {
            return new Integer(length).toString();
        }
        return "";
    }

    public String getQvalSigDigits(String dataset) {
        List<Variable> variables = null;
        int sig_digits = 0;
        variables = this.listSuppVariables(dataset);
        for (Variable var : variables) {
            try {
                if (!StringUtils.isNotEmpty((CharSequence)var.sig_digits) || sig_digits >= Integer.parseInt(var.sig_digits)) continue;
                sig_digits = Integer.parseInt(var.sig_digits);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (sig_digits > 0) {
            return new Integer(sig_digits).toString();
        }
        return "";
    }

    public Origin getQvalOrigin(String dataset) {
        List<Variable> variables = null;
        Origin origin = new Origin();
        boolean isFirst = true;
        boolean notSame = false;
        variables = this.listSuppVariables(dataset);
        for (Variable var : variables) {
            String[] pages;
            if (var.origin != null && isFirst) {
                origin.origin = var.origin.origin;
                if ("CRF".equals(origin.origin)) {
                    origin.crf_id = var.origin.crf_id;
                    origin.crf_page_type = var.origin.crf_page_type;
                    if (var.origin.str_crf_page_reference != null) {
                        if ("PhysicalRef".equals(origin.crf_page_type)) {
                            for (String page : pages = var.origin.str_crf_page_reference.split(" ")) {
                                origin.crf_page_reference.add(NumberUtils.toInt((String)page));
                            }
                        } else {
                            origin.str_crf_page_reference = var.origin.str_crf_page_reference;
                        }
                    }
                }
                isFirst = false;
                continue;
            }
            if (var.origin != null && !isFirst) {
                if (StringUtils.equals((CharSequence)origin.origin, (CharSequence)var.origin.origin)) {
                    if (!"CRF".equals(origin.origin)) continue;
                    if (StringUtils.equals((CharSequence)origin.crf_id, (CharSequence)var.origin.crf_id) && StringUtils.isEmpty((CharSequence)origin.str_crf_page_reference) && "PhysicalRef".equals(var.origin.crf_page_type)) {
                        for (String page : pages = var.origin.str_crf_page_reference.split(" ")) {
                            origin.crf_page_reference.add(NumberUtils.toInt((String)page));
                        }
                        continue;
                    }
                    notSame = true;
                    continue;
                }
                notSame = true;
                continue;
            }
            notSame = true;
        }
        if (notSame) {
            return null;
        }
        return origin;
    }

    public int getQorigLength(String dataset) {
        List<Variable> variables = null;
        int length = 0;
        variables = this.listSuppVariables(dataset);
        for (Variable var : variables) {
            if (var.origin == null || length >= StringUtils.length((CharSequence)var.origin.origin)) continue;
            length = StringUtils.length((CharSequence)var.origin.origin);
        }
        return length;
    }

    public int getQevalLength(String dataset) {
        List<Variable> variables = null;
        int length = 1;
        variables = this.listSuppVariables(dataset);
        for (Variable var : variables) {
            if (var.evaluator == null || length >= StringUtils.length((CharSequence)var.evaluator)) continue;
            length = StringUtils.length((CharSequence)var.evaluator);
        }
        return length;
    }

    public String getIdVarvalLength(String dataset) {
        String length = null;
        length = this.seqList.containsKey(dataset) ? this.seqList.get(dataset).toString() : "";
        return length;
    }

    public class Origin {
        public String origin = "";
        public String crf_id = "";
        public String crf_page_type = "";
        public Set<Integer> crf_page_reference = new HashSet<Integer>();
        public String str_crf_page_reference = "";

        public String pagesInString() {
            if (this.crf_page_reference == null || this.crf_page_reference.size() == 0) {
                return "";
            }
            List pages = this.crf_page_reference.stream().sorted((num1, num2) -> Integer.compare(num1, num2)).collect(Collectors.toList());
            String str_pages = "";
            for (int i = 0; i < pages.size(); ++i) {
                if (i > 0) {
                    str_pages = str_pages + " ";
                }
                str_pages = str_pages + pages.get(i);
            }
            return str_pages;
        }
    }

    public class Variable {
        public String dataset_name = "";
        public String variable_name = "";
        public String label = "";
        public String data_type = "";
        public String length = "";
        public String sig_digits = "";
        public Origin origin = new Origin();
        public String mandatory = "";
        public String evaluator = "";
    }

    public class SuppDataset {
        public String domain = "";
        public String dataset_name = "";
        public IsEmpty is_empty = IsEmpty.No;
    }

    public static enum IsEmpty {
        Yes,
        No,
        SUPP;


        public static IsEmpty parse(String isEmpty) {
            if (isEmpty == null) {
                return No;
            }
            if ("YES".equals(isEmpty.toUpperCase())) {
                return Yes;
            }
            if ("SUPP".equals(isEmpty.toUpperCase())) {
                return SUPP;
            }
            return No;
        }
    }
}

