/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.exporter;

import com.fujitsu.tsc.desktop.exporter.DefineXmlWriter;
import com.fujitsu.tsc.desktop.exporter.InvalidOidSyntaxException;
import com.fujitsu.tsc.desktop.exporter.OdmXmlWriter;
import com.fujitsu.tsc.desktop.exporter.RequiredValueMissingException;
import com.fujitsu.tsc.desktop.exporter.TableNotFoundException;
import com.fujitsu.tsc.desktop.util.Config;
import com.fujitsu.tsc.desktop.util.InvalidParameterException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class XmlGenerator {
    private static Logger logger;
    private Properties prop;
    private Config config;
    private Config.RunMode mode;

    public XmlGenerator() {
        logger = LogManager.getLogger();
        this.config = new Config();
        this.mode = this.config.runMode;
    }

    public XmlGenerator(Config config) {
        logger = LogManager.getLogger();
        this.config = config;
        this.mode = Config.RunMode.API;
    }

    public XmlGenerator(Config config, Config.RunMode mode) {
        logger = LogManager.getLogger();
        this.config = config;
        this.mode = mode;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void generateDefineXml() throws InvalidParameterException, TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException, InvalidFormatException {
        try {
            logger.info("Launching the program...");
            logger.info("Creating define.xml for " + (Object)((Object)this.config.e2dDatasetType) + "...");
            DefineXmlWriter writer = new DefineXmlWriter(this.config);
            logger.info("Writing XML Header...");
            writer.writeXMLHeader();
            logger.info("Done.");
            logger.info("Writing Study Section...");
            writer.writeStudySection();
            logger.info("Done.");
            logger.info("Writing Document Section...");
            if (this.config.e2dDatasetType.name().equals("SDTM")) {
                writer.writeDocumentSection("AnnotatedCRF");
            }
            writer.writeDocumentSection("SupplementalDoc");
            logger.info("Done.");
            logger.info("Writing ValueListDef Section...");
            writer.writeValueListDefSection();
            logger.info("Done.");
            logger.info("Writing WhereClauseDef Section...");
            writer.writeWhereClauseDefSection();
            logger.info("Done.");
            logger.info("Writing ItemGroupDef Section...");
            writer.writeItemGroupDefSection();
            logger.info("Done.");
            logger.info("Writing ItemDef Section...");
            writer.writeItemDefSection();
            logger.info("Done.");
            logger.info("Writing Codelist Section...");
            writer.writeCodelistSection();
            logger.info("Done.");
            logger.info("Writing MethodDef Section...");
            writer.writeMethodDefSection();
            logger.info("Done.");
            logger.info("Writing CommentDef Section...");
            writer.writeCommentDefSection();
            logger.info("Done.");
            logger.info("Writing Leaf Section...");
            writer.writeLeafSection();
            logger.info("Done.");
            if (this.config.e2dDatasetType.name().equals("ADaM") && this.config.e2dIncludeResultMetadata) {
                logger.info("Writing AnalysisResult Section...");
                writer.writeAnalysisResultSection();
                logger.info("Done.");
            }
            writer.writeEndTag("MetaDataVersion");
            writer.writeEndTag("Study");
            writer.writeEndTag("ODM");
            logger.info("Define.xml has been created.");
            writer.close();
        }
        catch (InvalidParameterException ex) {
            logger.error(ex.getMessage());
            logger.error("Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(1);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
            }
            throw ex;
        }
        catch (TableNotFoundException ex) {
            logger.error(ex.getMessage());
            logger.error("Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(2);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
            }
            throw ex;
        }
        catch (FileNotFoundException ex) {
            logger.error(ex.getMessage());
            logger.error("Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(3);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
            }
            throw ex;
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
            logger.error("Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(4);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
            }
            throw ex;
        }
        catch (InvalidOidSyntaxException ex) {
            logger.error(ex.getMessage());
            logger.error("Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(5);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
            }
            throw ex;
        }
        catch (RequiredValueMissingException ex) {
            logger.error(ex.getMessage());
            logger.error(ex.getSourceClass());
            for (int i = 0; i < ex.getStackTrace().length; ++i) {
                logger.error("    " + ex.getStackTrace()[i]);
            }
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(6);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
            }
            throw ex;
        }
    }

    public void generateOdmXml() throws InvalidParameterException, TableNotFoundException, IOException, InvalidOidSyntaxException, RequiredValueMissingException, InvalidFormatException {
        try {
            logger.info("Launching the program...");
            logger.info("Creating ODM ...");
            OdmXmlWriter writer = new OdmXmlWriter(this.config);
            logger.info("Writing XML Header...");
            writer.writeXMLHeader();
            logger.info("Done.");
            logger.info("Writing Study Section...");
            writer.writeStudySection();
            logger.info("Done.");
            logger.info("Writing Unit Section...");
            writer.writeUnitSection();
            logger.info("Done.");
            logger.info("Writing Protocol Section...");
            writer.writeProtocolSection();
            logger.info("Done.");
            logger.info("Writing EventDef Section...");
            writer.writeEventDefSection();
            logger.info("Done.");
            logger.info("Writing FormDef Section...");
            writer.writeFormDefSection();
            logger.info("Done.");
            logger.info("Writing ItemGroup Section...");
            writer.writeItemGroupDefSection();
            logger.info("Done.");
            logger.info("Writing ItemDef Section...");
            writer.writeItemDefSection();
            logger.info("Done.");
            logger.info("Writing Codelist Section...");
            writer.writeCodelistSection();
            logger.info("Done.");
            logger.info("Writing ConditionDef Section...");
            writer.writeConditionDefSection();
            logger.info("Done.");
            logger.info("Writing MethodDef Section...");
            writer.writeMethodDefSection();
            logger.info("Done.");
            writer.writeEndTag("MetaDataVersion");
            writer.writeEndTag("Study");
            writer.writeEndTag("ODM");
            logger.info("ODM has been created.");
            writer.close();
        }
        catch (InvalidParameterException ex) {
            logger.error(ex.getMessage());
            logger.error("Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(1);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
            }
            throw ex;
        }
        catch (TableNotFoundException ex) {
            logger.error(ex.getMessage());
            logger.error("Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(2);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
            }
            throw ex;
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
            logger.error("Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(4);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
            }
            throw ex;
        }
        catch (InvalidOidSyntaxException ex) {
            logger.error(ex.getMessage());
            logger.error("Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(5);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
            }
            throw ex;
        }
        catch (RequiredValueMissingException ex) {
            logger.error(ex.getMessage());
            logger.error("Exiting the program...");
            if (this.mode.equals((Object)Config.RunMode.CLI)) {
                System.exit(6);
            }
            if (this.mode.equals((Object)Config.RunMode.GUI)) {
                try {
                    Thread.currentThread().join();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
            }
            throw ex;
        }
    }

    public static void main(String[] args) throws InvalidFormatException {
        Object strConfig = null;
        logger.info("Command Line Interface (CLI) is not supported.");
        System.exit(-1);
        try {
            Properties prop = new Properties();
            FileReader reader = new FileReader("./properties/main.properties");
            prop.load(reader);
            reader.close();
            Config config = new Config(prop);
            XmlGenerator generator = new XmlGenerator(config, Config.RunMode.CLI);
            generator.generateDefineXml();
        }
        catch (FileNotFoundException ex) {
            logger.error(ex.getMessage());
            System.exit(-1);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
            System.exit(-1);
        }
        catch (InvalidParameterException ex) {
            logger.error(ex.getMessage());
            System.exit(-1);
        }
        catch (TableNotFoundException ex) {
            logger.error(ex.getMessage());
            System.exit(-1);
        }
        catch (InvalidOidSyntaxException ex) {
            logger.error(ex.getMessage());
            System.exit(-1);
        }
        catch (RequiredValueMissingException ex) {
            logger.error(ex.getMessage());
            System.exit(-1);
        }
    }

    public static String escapeString(String str) {
        StringBuffer buffer = new StringBuffer(1000);
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (str.charAt(i) == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (str.charAt(i) == '>') {
                buffer.append("&gt;");
                continue;
            }
            if (str.charAt(i) == '\"') {
                buffer.append("&quot;");
                continue;
            }
            if (str.charAt(i) == '\'') {
                buffer.append("&apos;");
                continue;
            }
            buffer.append(str.charAt(i));
        }
        return buffer.toString();
    }
}

