/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.gui;

import com.fujitsu.tsc.desktop.gui.FilePathTransferHandler;
import com.fujitsu.tsc.desktop.gui.GuiConstants;
import com.fujitsu.tsc.desktop.gui.GuiMain;
import com.fujitsu.tsc.desktop.gui.XmlValidationAppender;
import com.fujitsu.tsc.desktop.importer.OdmImporter;
import com.fujitsu.tsc.desktop.util.Config;
import com.fujitsu.tsc.desktop.util.ErrorInfo;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OdmImportPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LogManager.getLogger();
    private Config config;
    private GuiMain parent;
    private Font titleFont;
    private Font defaultFont;
    private Font submitFont;
    private JPanel headerPanel;
    private JLabel titleL;
    private JPanel bodyPanel;
    private JLabel odmVersionL;
    protected JComboBox<String> odmVersionCB;
    private JLabel dataSourceLocationL;
    protected JTextField dataSourceLocationTF;
    private JLabel outputLocationL;
    protected JTextField outputLocationTF;
    private JButton browseButton1;
    private JButton clearButton1;
    private JButton browseButton2;
    private JButton clearButton2;
    protected JFileChooser fileChooser1;
    private FileNameExtensionFilter filter1;
    protected JFileChooser fileChooser2;
    private JPanel footerPanel;
    private JButton runButton;

    public OdmImportPanel(GuiMain parent, Config config) {
        this.config = config;
        this.parent = parent;
        this.titleFont = new Font(GuiConstants.FONT_NAME_TITLE, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE_TITLE);
        this.defaultFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE, GuiConstants.FONT_SIZE);
        this.submitFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE);
        this.setBackground(GuiConstants.COLOR_BORDER);
        this.initHeaderPanel();
        this.initBodyPanel();
        this.initFooterPanel();
        GroupLayout panelLayout = new GroupLayout(this);
        this.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerPanel, -2, -1, Short.MAX_VALUE).addComponent(this.bodyPanel, -2, -1, Short.MAX_VALUE).addComponent(this.footerPanel, -2, -1, Short.MAX_VALUE));
        panelLayout.setVerticalGroup(panelLayout.createSequentialGroup().addGap(GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK).addComponent(this.headerPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.bodyPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.footerPanel, -2, -1, -2));
    }

    private void initHeaderPanel() {
        this.headerPanel = new JPanel();
        this.headerPanel.setBackground(GuiConstants.COLOR_BG);
        this.titleL = new JLabel("Convert from ODM-XML to Excel");
        this.titleL.setFont(this.titleFont);
        this.titleL.setForeground(GuiConstants.FONT_COLOR_TITLE);
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        headerPanelLayout.setAutoCreateContainerGaps(true);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, Short.MAX_VALUE));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, -2));
    }

    private void initBodyPanel() {
        this.bodyPanel = new JPanel();
        this.bodyPanel.setBackground(GuiConstants.COLOR_BG);
        this.odmVersionL = new JLabel("ODM Version");
        this.odmVersionCB = new JComboBox();
        this.dataSourceLocationL = new JLabel("Data Source Location (.xml):");
        this.dataSourceLocationTF = new JTextField("");
        this.outputLocationL = new JLabel("Output Location:");
        this.outputLocationTF = new JTextField("");
        this.browseButton1 = new JButton("Browse");
        this.clearButton1 = new JButton("Clear");
        this.browseButton2 = new JButton("Browse");
        this.clearButton2 = new JButton("Clear");
        this.fileChooser1 = new JFileChooser();
        this.filter1 = new FileNameExtensionFilter("XML (.xml)", "xml");
        this.fileChooser1.setFileFilter(this.filter1);
        this.dataSourceLocationTF.setTransferHandler(new FilePathTransferHandler(this.dataSourceLocationTF, this.fileChooser1, this.filter1));
        this.fileChooser2 = new JFileChooser();
        this.fileChooser2.setFileSelectionMode(1);
        this.outputLocationTF.setTransferHandler(new FilePathTransferHandler(this.outputLocationTF, this.fileChooser2));
        this.browseButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = OdmImportPanel.this.fileChooser1.showOpenDialog(OdmImportPanel.this);
                if (selected == 0) {
                    OdmImportPanel.this.dataSourceLocationTF.setText(OdmImportPanel.this.fileChooser1.getSelectedFile().getPath());
                } else if (selected == 1 || selected == -1) {
                    // empty if block
                }
            }
        });
        this.clearButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OdmImportPanel.this.dataSourceLocationTF.setText("");
            }
        });
        this.browseButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = OdmImportPanel.this.fileChooser2.showOpenDialog(OdmImportPanel.this);
                if (selected == 0) {
                    OdmImportPanel.this.outputLocationTF.setText(OdmImportPanel.this.fileChooser2.getSelectedFile().getPath() + System.getProperty("file.separator") + GuiConstants.ODM_EXCEL_FILE_NAME);
                } else if (selected == 1 || selected == -1) {
                    // empty if block
                }
            }
        });
        this.clearButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OdmImportPanel.this.outputLocationTF.setText("");
            }
        });
        this.odmVersionL.setFont(this.defaultFont);
        this.odmVersionCB.setFont(this.defaultFont);
        this.odmVersionCB.setModel(new DefaultComboBoxModel<String>(GuiConstants.ODM_VERSIONS));
        this.dataSourceLocationL.setFont(this.defaultFont);
        this.dataSourceLocationTF.setEditable(false);
        this.outputLocationL.setFont(this.defaultFont);
        this.outputLocationTF.setForeground(GuiConstants.FONT_COLOR_ON_WHITE);
        this.browseButton1.setFont(this.defaultFont);
        this.clearButton1.setFont(this.defaultFont);
        this.browseButton2.setFont(this.defaultFont);
        this.clearButton2.setFont(this.defaultFont);
        this.odmVersionCB.setSelectedItem(this.config.o2eOdmVersion);
        this.dataSourceLocationTF.setText(this.config.o2eOdmLocation);
        this.outputLocationTF.setText(this.config.o2eOutputLocation);
        GroupLayout bodyPanelLayout = new GroupLayout(this.bodyPanel);
        this.bodyPanel.setLayout(bodyPanelLayout);
        bodyPanelLayout.setHorizontalGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bodyPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.CONFIG_GAP_LEFT, GuiConstants.CONFIG_GAP_LEFT).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.odmVersionL).addComponent(this.dataSourceLocationL).addComponent(this.outputLocationL)).addGap(GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.odmVersionCB, -2, 160, -2).addComponent(this.dataSourceLocationTF, -1, 255, Short.MAX_VALUE).addComponent(this.outputLocationTF, -1, 255, Short.MAX_VALUE)).addGap(GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browseButton1).addComponent(this.browseButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.clearButton1).addComponent(this.clearButton2)).addContainerGap(GuiConstants.CONFIG_GAP_RIGHT, GuiConstants.CONFIG_GAP_RIGHT)));
        bodyPanelLayout.setVerticalGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bodyPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.CONFIG_GAP_TOP, GuiConstants.CONFIG_GAP_TOP).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.odmVersionL).addComponent(this.odmVersionCB, -2, -1, -2)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataSourceLocationL).addComponent(this.dataSourceLocationTF, -2, -1, -2).addComponent(this.browseButton1).addComponent(this.clearButton1)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputLocationL).addComponent(this.outputLocationTF, -2, -1, -2).addComponent(this.browseButton2).addComponent(this.clearButton2)).addContainerGap(GuiConstants.CONFIG_GAP_BOTTOM, GuiConstants.CONFIG_GAP_BOTTOM)));
    }

    private void initFooterPanel() {
        this.footerPanel = new JPanel();
        this.footerPanel.setBackground(GuiConstants.COLOR_BG);
        this.runButton = new JButton("Import");
        this.runButton.setFont(this.submitFont);
        this.runButton.setForeground(GuiConstants.COLOR_BTN_FG_SUBMIT);
        this.runButton.setBackground(GuiConstants.COLOR_BTN_BG_SUBMIT);
        this.runButton.setActionCommand("Import");
        this.runButton.addActionListener(this);
        GroupLayout footerPanelLayout = new GroupLayout(this.footerPanel);
        footerPanelLayout.setAutoCreateContainerGaps(true);
        this.footerPanel.setLayout(footerPanelLayout);
        footerPanelLayout.setHorizontalGroup(footerPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.FOOTER_GAP_LEFT, Short.MAX_VALUE).addComponent(this.runButton));
        footerPanelLayout.setVerticalGroup(footerPanelLayout.createSequentialGroup().addComponent(this.runButton).addContainerGap(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    public String validateEntry() {
        if (this.odmVersionCB.getSelectedItem() == null) {
            return "ODM Version cannot be blank.";
        }
        if (StringUtils.isEmpty((CharSequence)this.dataSourceLocationTF.getText())) {
            return "Data Source Location (.xml) cannot be blank.";
        }
        if (StringUtils.isEmpty((CharSequence)this.outputLocationTF.getText())) {
            return "Output Location cannot be blank.";
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Import".equals(command)) {
            String errMessage = this.validateEntry();
            if (StringUtils.isEmpty((CharSequence)errMessage)) {
                this.parent.showPanel(this.parent.odmImportResultPanel);
                Runnable runOdmImport = new Runnable(){

                    @Override
                    public void run() {
                        XmlValidationAppender appender = new XmlValidationAppender(((OdmImportPanel)OdmImportPanel.this).parent.odmImportResultPanel.iResultTable);
                        appender.clear();
                        ((OdmImportPanel)OdmImportPanel.this).parent.odmImportResultPanel.outputLocationUrl.setText(null);
                        ((OdmImportPanel)OdmImportPanel.this).config.o2eOdmVersion = OdmImportPanel.this.odmVersionCB.getSelectedItem().toString();
                        ((OdmImportPanel)OdmImportPanel.this).config.o2eOdmLocation = OdmImportPanel.this.dataSourceLocationTF.getText();
                        ((OdmImportPanel)OdmImportPanel.this).config.o2eOutputLocation = OdmImportPanel.this.outputLocationTF.getText();
                        List<Object> errors = new ArrayList();
                        OdmImporter odmImporter = new OdmImporter(OdmImportPanel.this.config);
                        String odm_path = OdmImportPanel.this.dataSourceLocationTF.getText();
                        try {
                            if (!StringUtils.isEmpty((CharSequence)odm_path)) {
                                errors = odmImporter.validateHard();
                                if (!errors.isEmpty()) {
                                    for (ErrorInfo errorInfo : errors) {
                                        appender.writeNext(errorInfo);
                                        logger.info(errorInfo.getMessage());
                                    }
                                    appender.writeMessage("Failed to import the ODM-XML due to fatal errors.");
                                    logger.error("Failed to import the ODM-XML due to fatal errors.");
                                    return;
                                }
                                appender.writeMessage("No fatal errors have been found in the ODM-XML. Importing...");
                                logger.info("No fatal errors have been found in the ODM-XML. Importing...");
                                errors = odmImporter.validateSoft();
                            }
                            odmImporter.generateExcel();
                            if (!errors.isEmpty()) {
                                for (ErrorInfo errorInfo : errors) {
                                    appender.writeNext(errorInfo);
                                    logger.info(errorInfo.getMessage());
                                }
                                appender.writeMessage("An Excel file has been created, but some warning(s) exist.");
                                logger.info("An Excel file has been created, but some warning(s) exist.");
                            } else {
                                appender.writeMessage("An Excel file has been created. No warnings have been found.");
                                logger.info("An Excel file has been created. No warnings have been found.");
                            }
                            ((OdmImportPanel)OdmImportPanel.this).parent.odmImportResultPanel.outputLocationUrl.setText(new File(OdmImportPanel.this.outputLocationTF.getText()).getCanonicalPath());
                        }
                        catch (Exception ex) {
                            appender.writeErrorMessage(ExceptionUtils.getStackTrace((Throwable)ex));
                            logger.error(ExceptionUtils.getStackTrace((Throwable)ex));
                        }
                    }
                };
                new Thread(runOdmImport).start();
            } else {
                Object[] options = new String[]{"OK"};
                JLabel errMessageL = new JLabel(errMessage);
                errMessageL.setFont(this.defaultFont);
                JOptionPane.showOptionDialog(this.parent, errMessageL, "Message", -1, 2, null, options, "OK");
            }
        }
    }
}

