/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.gui;

import com.fujitsu.tsc.desktop.gui.EditorPaneAppender;
import com.fujitsu.tsc.desktop.gui.FilePathTransferHandler;
import com.fujitsu.tsc.desktop.gui.GuiConstants;
import com.fujitsu.tsc.desktop.gui.GuiMain;
import com.fujitsu.tsc.desktop.util.Config;
import com.fujitsu.tsc.desktop.util.Utils;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class XmlToHtmlPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LogManager.getLogger();
    private Config config;
    private GuiMain parent;
    private Font titleFont;
    private Font defaultFont;
    private Font submitFont;
    private JPanel headerPanel;
    private JLabel titleL;
    private JPanel bodyPanel;
    private JLabel xmlLocationL;
    public JTextField xmlLocationTF;
    private JButton xmlClearBT;
    private JButton xmlBrowseBT;
    private JLabel xslLocationL;
    public JTextField xslLocationTF;
    private JButton xslClearBT;
    private JButton xslBrowseBT;
    private JLabel outputLocationL;
    protected JTextField outputLocationTF;
    private JButton outputClearBT;
    private JButton outputBrowseBT;
    protected JFileChooser fileChooser1;
    private FileNameExtensionFilter filter1;
    protected JFileChooser fileChooser2;
    private FileNameExtensionFilter filter2;
    protected JFileChooser fileChooser3;
    private JPanel footerPanel;
    private JButton runButton;

    public XmlToHtmlPanel(GuiMain parent, Config config) {
        this.parent = parent;
        this.titleFont = new Font(GuiConstants.FONT_NAME_TITLE, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE_TITLE);
        this.defaultFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE, GuiConstants.FONT_SIZE);
        this.submitFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE);
        this.setBackground(GuiConstants.COLOR_BORDER);
        this.initHeaderPanel();
        this.initBodyPanel(config);
        this.initFooterPanel();
        GroupLayout panelLayout = new GroupLayout(this);
        this.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerPanel, -2, -1, Short.MAX_VALUE).addComponent(this.bodyPanel, -2, -1, Short.MAX_VALUE).addComponent(this.footerPanel, -2, -1, Short.MAX_VALUE));
        panelLayout.setVerticalGroup(panelLayout.createSequentialGroup().addGap(GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK).addComponent(this.headerPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.bodyPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.footerPanel, -2, -1, -2));
    }

    private void initHeaderPanel() {
        this.headerPanel = new JPanel();
        this.headerPanel.setBackground(GuiConstants.COLOR_BG);
        this.titleL = new JLabel("Convert from XML to HTML");
        this.titleL.setFont(this.titleFont);
        this.titleL.setForeground(GuiConstants.FONT_COLOR_TITLE);
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        headerPanelLayout.setAutoCreateContainerGaps(true);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, Short.MAX_VALUE));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, -2));
    }

    private void initBodyPanel(Config config) {
        this.bodyPanel = new JPanel();
        this.bodyPanel.setBackground(GuiConstants.COLOR_BG);
        this.xmlLocationL = new JLabel("XML File Location (.xml):");
        this.xmlLocationL.setFont(this.defaultFont);
        this.xmlLocationTF = new JTextField("");
        this.xmlLocationTF.setEditable(false);
        this.xslLocationL = new JLabel("Style Sheet Location (.xsl):");
        this.xslLocationL.setFont(this.defaultFont);
        this.xslLocationTF = new JTextField("");
        this.xslLocationTF.setEditable(false);
        this.outputLocationL = new JLabel("Output Location:");
        this.outputLocationL.setFont(this.defaultFont);
        this.outputLocationTF = new JTextField("");
        this.fileChooser1 = new JFileChooser();
        this.filter1 = new FileNameExtensionFilter("XML(.xml)", "xml");
        this.fileChooser1.setFileFilter(this.filter1);
        this.xmlLocationTF.setTransferHandler(new FilePathTransferHandler(this.xmlLocationTF, this.fileChooser1, this.filter1));
        this.fileChooser2 = new JFileChooser();
        this.filter2 = new FileNameExtensionFilter("Style Sheet(.xsl)", "xsl");
        this.fileChooser2.setFileFilter(this.filter2);
        this.fileChooser2.setDialogTitle("Schema");
        this.xslLocationTF.setTransferHandler(new FilePathTransferHandler(this.xslLocationTF, this.fileChooser2, this.filter2));
        this.fileChooser3 = new JFileChooser();
        this.fileChooser3.setFileSelectionMode(1);
        this.outputLocationTF.setTransferHandler(new FilePathTransferHandler(this.outputLocationTF, this.fileChooser3));
        this.xmlBrowseBT = new JButton("Browse");
        this.xmlBrowseBT.setFont(this.defaultFont);
        this.xmlBrowseBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = XmlToHtmlPanel.this.fileChooser1.showOpenDialog(XmlToHtmlPanel.this);
                if (selected == 0) {
                    XmlToHtmlPanel.this.xmlLocationTF.setText(XmlToHtmlPanel.this.fileChooser1.getSelectedFile().getPath());
                } else if (selected == 1 || selected == -1) {
                    // empty if block
                }
            }
        });
        this.xmlClearBT = new JButton("Clear");
        this.xmlClearBT.setFont(this.defaultFont);
        this.xmlClearBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlToHtmlPanel.this.xmlLocationTF.setText("");
            }
        });
        this.xslBrowseBT = new JButton("Browse");
        this.xslBrowseBT.setFont(this.defaultFont);
        this.xslBrowseBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int selected = XmlToHtmlPanel.this.fileChooser2.showOpenDialog(XmlToHtmlPanel.this);
                if (selected == 0) {
                    XmlToHtmlPanel.this.xslLocationTF.setText(XmlToHtmlPanel.this.fileChooser2.getSelectedFile().getPath());
                } else if (selected == 1 || selected == -1) {
                    // empty if block
                }
            }
        });
        this.xslClearBT = new JButton("Clear");
        this.xslClearBT.setFont(this.defaultFont);
        this.xslClearBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlToHtmlPanel.this.xslLocationTF.setText("");
            }
        });
        this.outputBrowseBT = new JButton("Browse");
        this.outputBrowseBT.setFont(this.defaultFont);
        this.outputBrowseBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = XmlToHtmlPanel.this.fileChooser3.showOpenDialog(XmlToHtmlPanel.this);
                if (selected == 0) {
                    XmlToHtmlPanel.this.outputLocationTF.setText(XmlToHtmlPanel.this.fileChooser3.getSelectedFile().getPath() + System.getProperty("file.separator") + GuiConstants.DEFINE_HTML_FILE_NAME);
                } else if (selected == 1 || selected == -1) {
                    // empty if block
                }
            }
        });
        this.outputClearBT = new JButton("Clear");
        this.outputClearBT.setFont(this.defaultFont);
        this.outputClearBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlToHtmlPanel.this.outputLocationTF.setText("");
            }
        });
        this.xmlLocationTF.setText(config.x2hXmlLocation);
        this.xslLocationTF.setText(config.x2hXslLocation);
        this.outputLocationTF.setText(config.x2hOutputLocation);
        GroupLayout bodyPanelLayout = new GroupLayout(this.bodyPanel);
        this.bodyPanel.setLayout(bodyPanelLayout);
        bodyPanelLayout.setHorizontalGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bodyPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.CONFIG_GAP_LEFT, GuiConstants.CONFIG_GAP_LEFT).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.xmlLocationL).addComponent(this.xslLocationL).addComponent(this.outputLocationL)).addGap(GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.xmlLocationTF, -1, 255, Short.MAX_VALUE).addComponent(this.xslLocationTF, -1, 255, Short.MAX_VALUE).addComponent(this.outputLocationTF, -1, 255, Short.MAX_VALUE)).addGap(GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bodyPanelLayout.createSequentialGroup().addComponent(this.xmlBrowseBT).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xmlClearBT)).addGroup(bodyPanelLayout.createSequentialGroup().addComponent(this.xslBrowseBT).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xslClearBT)).addGroup(bodyPanelLayout.createSequentialGroup().addComponent(this.outputBrowseBT).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputClearBT))).addContainerGap()));
        bodyPanelLayout.setVerticalGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bodyPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.CONFIG_GAP_TOP, GuiConstants.CONFIG_GAP_TOP).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.xmlLocationL).addComponent(this.xmlLocationTF, -2, -1, -2).addComponent(this.xmlBrowseBT).addComponent(this.xmlClearBT)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.xslLocationL).addComponent(this.xslLocationTF, -2, -1, -2).addComponent(this.xslBrowseBT).addComponent(this.xslClearBT)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputLocationL).addComponent(this.outputLocationTF, -2, -1, -2).addComponent(this.outputBrowseBT).addComponent(this.outputClearBT)).addContainerGap(GuiConstants.CONFIG_GAP_BOTTOM, GuiConstants.CONFIG_GAP_BOTTOM)));
    }

    private void initFooterPanel() {
        this.footerPanel = new JPanel();
        this.footerPanel.setBackground(GuiConstants.COLOR_BG);
        this.runButton = new JButton("Generate");
        this.runButton.setFont(this.submitFont);
        this.runButton.setForeground(GuiConstants.COLOR_BTN_FG_SUBMIT);
        this.runButton.setBackground(GuiConstants.COLOR_BTN_BG_SUBMIT);
        this.runButton.setActionCommand("Generate");
        this.runButton.addActionListener(this);
        GroupLayout footerPanelLayout = new GroupLayout(this.footerPanel);
        footerPanelLayout.setAutoCreateContainerGaps(true);
        this.footerPanel.setLayout(footerPanelLayout);
        footerPanelLayout.setHorizontalGroup(footerPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.FOOTER_GAP_LEFT, Short.MAX_VALUE).addComponent(this.runButton));
        footerPanelLayout.setVerticalGroup(footerPanelLayout.createSequentialGroup().addComponent(this.runButton).addContainerGap(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    public String validateEntry() {
        if (StringUtils.isEmpty((CharSequence)this.xmlLocationTF.getText())) {
            return "XML File Location cannot be blank.";
        }
        if (StringUtils.isEmpty((CharSequence)this.xslLocationTF.getText())) {
            return "Style Sheet Location cannot be blank.";
        }
        if (StringUtils.isEmpty((CharSequence)this.outputLocationTF.getText())) {
            return "Output Location cannot be blank.";
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Generate".equals(command)) {
            String errMessage = this.validateEntry();
            if (StringUtils.isEmpty((CharSequence)errMessage)) {
                this.parent.showPanel(this.parent.xmlToHtmlResultPanel);
                this.parent.xmlToHtmlResultPanel.clearBodyPanel();
                Runnable runValidation = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
                        Configuration loggerConfig = loggerContext.getConfiguration();
                        PatternLayout patternLayout = PatternLayout.newBuilder().withPattern("[%p] %m%n").build();
                        EditorPaneAppender epAppender = new EditorPaneAppender(patternLayout);
                        epAppender.setEditorPane(((XmlToHtmlPanel)XmlToHtmlPanel.this).parent.xmlToHtmlResultPanel.gResultEditorPane);
                        epAppender.start();
                        loggerConfig.getRootLogger().addAppender((Appender)epAppender, Level.INFO, null);
                        try {
                            logger.info("Converting XML to HTML...");
                            TransformerFactory factory = TransformerFactory.newInstance();
                            Utils.setTransformerFactorySecureFeatures(factory);
                            Transformer transformer = factory.newTransformer(new StreamSource(XmlToHtmlPanel.this.xslLocationTF.getText()));
                            transformer.transform(new StreamSource(XmlToHtmlPanel.this.xmlLocationTF.getText()), new StreamResult(XmlToHtmlPanel.this.outputLocationTF.getText()));
                            logger.info("An HTML file has been created.");
                            ((XmlToHtmlPanel)XmlToHtmlPanel.this).parent.xmlToHtmlResultPanel.outputLocationUrl.setText(new File(XmlToHtmlPanel.this.outputLocationTF.getText()).getCanonicalPath());
                        }
                        catch (Exception ex) {
                            logger.error(ExceptionUtils.getStackTrace((Throwable)ex));
                        }
                        finally {
                            epAppender.stop();
                            loggerConfig.getRootLogger().removeAppender("EditorPane");
                        }
                    }
                };
                new Thread(runValidation).start();
            } else {
                Object[] options = new String[]{"OK"};
                JLabel errMessageL = new JLabel(errMessage);
                errMessageL.setFont(this.defaultFont);
                JOptionPane.showOptionDialog(this.parent, errMessageL, "Message", -1, 2, null, options, "OK");
            }
        }
    }
}

