/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer;

import com.fujitsu.tsc.desktop.importer.DefineXmlReader;
import com.fujitsu.tsc.desktop.importer.models.DefineARMDatasetModel;
import com.fujitsu.tsc.desktop.importer.models.DefineARMDisplayModel;
import com.fujitsu.tsc.desktop.importer.models.DefineARMResultModel;
import com.fujitsu.tsc.desktop.importer.models.DefineCodelistModel;
import com.fujitsu.tsc.desktop.importer.models.DefineCommentModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDatasetModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDictionaryModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDocumentModel;
import com.fujitsu.tsc.desktop.importer.models.DefineMethodModel;
import com.fujitsu.tsc.desktop.importer.models.DefineModel;
import com.fujitsu.tsc.desktop.importer.models.DefineStandardModel;
import com.fujitsu.tsc.desktop.importer.models.DefineStudyModel;
import com.fujitsu.tsc.desktop.importer.models.DefineValueModel;
import com.fujitsu.tsc.desktop.importer.models.DefineVariableModel;
import com.fujitsu.tsc.desktop.importer.models.DefineWCModel;
import com.fujitsu.tsc.desktop.util.Config;
import com.fujitsu.tsc.desktop.util.ErrorInfo;
import com.fujitsu.tsc.desktop.util.ExcelStyle;
import com.fujitsu.tsc.desktop.util.Utils;
import com.fujitsu.tsc.desktop.validator.DefaultValidationHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefineImporter {
    private static Logger logger = LogManager.getLogger();
    private ExcelStyle excelStyle;
    private Config config;
    private DefineModel define;

    public DefineImporter(Config config) {
        this.config = config;
    }

    public List<ErrorInfo> validateHard() throws SAXException, ParserConfigurationException, IOException {
        logger.info("Hard validation in progress...");
        return this.parse(Type.HARD);
    }

    public List<ErrorInfo> validateSoft() throws SAXException, ParserConfigurationException, IOException {
        logger.info("Soft validation in progress...");
        return this.parse(Type.SOFT);
    }

    private List<ErrorInfo> parse(Type type) throws SAXException, ParserConfigurationException, IOException {
        SchemaFactory sch_factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Utils.setSchemaFactorySecureFeatures(sch_factory);
        SAXParserFactory sax_factory = SAXParserFactory.newInstance();
        Schema schema = null;
        schema = type == Type.HARD ? sch_factory.newSchema(this.getClass().getClassLoader().getResource("schema/xml/xml.xsd")) : ("2.1.n".equals(this.config.d2eDefineVersion) ? sch_factory.newSchema(this.getClass().getClassLoader().getResource("schema/2.1.n/cdisc-arm-1.0/arm1-0-0.xsd")) : sch_factory.newSchema(this.getClass().getClassLoader().getResource("schema/2.0.0/cdisc-arm-1.0/arm1-0-0.xsd")));
        sax_factory.setSchema(schema);
        sax_factory.setNamespaceAware(true);
        sax_factory.setValidating(false);
        Utils.setSaxParserFactorySecureFeatures(sax_factory);
        SAXParser parser = sax_factory.newSAXParser();
        if (type == Type.HARD) {
            DefaultValidationHandler handler = new DefaultValidationHandler();
            return handler.getErrors();
        }
        DefineXmlReader handler = new DefineXmlReader(this.config);
        parser.parse(new File(this.config.d2eDataSourceLocation), (DefaultHandler)handler);
        this.define = handler.getDefineModel();
        return handler.getErrors();
    }

    public DefineModel getDefineModel() {
        return this.define;
    }

    public void setDefineModel(DefineModel define) {
        this.define = define;
    }

    public XSSFWorkbook generateWorkbook() throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        this.excelStyle = new ExcelStyle(wb, this.config);
        this.define.updateVLM();
        this.define.updateARMDisplay();
        this.define.updateARMDataset();
        if (this.config.d2eDatasetType.equals("SDTM") && this.config.d2eMergeNSVtoParent) {
            this.define.convertToAutoSupp();
            this.define.updateHasSupp();
        }
        this.define.updateVariableOrdinal();
        this.writeStudySheet(wb, this.define);
        this.writeStandardSheet(wb, this.define);
        this.writeDocumentSheet(wb, this.define);
        this.writeDatasetSheet(wb, this.define);
        this.writeVariableSheet(wb, this.define);
        this.writeValueSheet(wb, this.define);
        if (this.config.d2eDatasetType.equals("ADaM")) {
            this.writeResult1Sheet(wb, this.define);
            this.writeResult2Sheet(wb, this.define);
        }
        this.writeDictionarySheet(wb, this.define);
        this.writeCodelistSheet(wb, this.define);
        if (this.config.d2eSeparateSheet) {
            this.writeMethodSheet(wb, this.define);
            this.writeCommentSheet(wb, this.define);
        }
        return wb;
    }

    public void writeStudySheet(XSSFWorkbook wb, DefineModel define) {
        logger.info("Generating " + this.config.defineStudyTableName + " Sheet");
        XSSFSheet sheet = wb.createSheet(this.config.defineStudyTableName);
        DefineStudyModel study = define.getStudy();
        DefineCommentModel comment = define.get(new DefineCommentModel.DefineCommentPk(study.comment_oid));
        String[][] cells = new String[][]{{"Property Name", "Property Value"}, {"FileOID", study.file_oid}, {"AsOfDateTime", study.as_of_date_time}, {"Originator", study.originator}, {"Context", study.context}, {"StudyOID", study.study_oid}, {"StudyName", study.study_name}, {"StudyDescription", StringUtils.isEmpty((CharSequence)study.study_description) ? study.study_name : study.study_description}, {"ProtocolName", study.protocol_name}, {"MetaDataOID", study.metadata_oid}, {"MetaDataName", study.metadata_name}, {"MetaDataDescription", study.metadata_description}, {"DefineVersion", study.define_version}, {"StandardName", study.standard_name}, {"StandardVersion", study.standard_version}, {"CommentOID", comment != null && this.config.d2eSeparateSheet ? comment.oid : ""}, {"Comment", comment == null || this.config.d2eSeparateSheet ? "" : comment.comment_text}, {"Language", comment == null || this.config.d2eSeparateSheet ? "" : comment.comment_lang}, {"DocumentID", comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentIdString(this.config.valueDelimiter)}, {"Document Page Type", comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageTypeString(this.config.valueDelimiter)}, {"Document Page Reference", comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageRefString(this.config.valueDelimiter)}, {"Document First Page", comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentFirstPageString(this.config.valueDelimiter)}, {"Document Last Page", comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentLastPageString(this.config.valueDelimiter)}, {"Document Page Title", comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageTitleString(this.config.valueDelimiter)}, {"User Note 1", ""}, {"User Note 2", ""}};
        for (int i = 0; i < cells.length; ++i) {
            XSSFRow row = sheet.createRow(i);
            row.createCell(0).setCellValue(cells[i][0]);
            row.createCell(1).setCellValue(cells[i][1]);
        }
        this.excelStyle.setStyleDefine_StudySheet(sheet);
        this.excelStyle.setColumnWidth(sheet);
    }

    public void writeStandardSheet(XSSFWorkbook wb, DefineModel define) {
        logger.info("Generating " + this.config.defineStandardTableName + " Sheet");
        XSSFSheet sheet = wb.createSheet(this.config.defineStandardTableName);
        List<DefineStandardModel> standards = define.listSortedStandard();
        String[] header = new String[]{"Name", "Type", "Publishing Set", "Version", "Status", "CommentOID", "Comment", "Language", "DocumentID", "Document Page Type", "Document Page Reference", "Document First Page", "Document Last Page", "Document Page Title", "User Note 1", "User Note 2"};
        XSSFRow row = sheet.createRow(0);
        for (int i = 0; i < header.length; ++i) {
            row.createCell(i).setCellValue(header[i]);
        }
        int row_num = 1;
        for (DefineStandardModel standard : standards) {
            DefineCommentModel comment = define.get(new DefineCommentModel.DefineCommentPk(standard.comment_oid));
            row = sheet.createRow(row_num++);
            String[] data = new String[]{standard.standard_name, standard.standard_type.name(), standard.publishing_set, standard.standard_version, standard.standard_status, comment != null && this.config.d2eSeparateSheet ? comment.oid : "", comment == null || this.config.d2eSeparateSheet ? "" : comment.comment_text, comment == null || this.config.d2eSeparateSheet ? "" : comment.comment_lang, comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentIdString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageTypeString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageRefString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentFirstPageString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentLastPageString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageTitleString(this.config.valueDelimiter), standard.user_note1, standard.user_note2};
            for (int i = 0; i < header.length; ++i) {
                row.createCell(i).setCellValue(data[i]);
            }
        }
        this.excelStyle.setStyleDefine_StandardSheet(sheet);
        this.excelStyle.setColumnWidth(sheet);
    }

    public void writeDocumentSheet(XSSFWorkbook wb, DefineModel define) {
        logger.info("Generating " + this.config.defineDocumentTableName + " Sheet");
        XSSFSheet sheet = wb.createSheet(this.config.defineDocumentTableName);
        List<DefineDocumentModel> documents = define.listSortedDocument();
        String[] header = new String[]{"ID", "Type", "href", "Title", "User Note 1", "User Note 2"};
        XSSFRow row = sheet.createRow(0);
        for (int i = 0; i < header.length; ++i) {
            row.createCell(i).setCellValue(header[i]);
        }
        int row_num = 1;
        for (DefineDocumentModel document : documents) {
            row = sheet.createRow(row_num++);
            String[] data = new String[]{document.document_id, document.document_type.name(), document.document_href, document.document_title, document.user_note1, document.user_note2};
            for (int i = 0; i < header.length; ++i) {
                row.createCell(i).setCellValue(data[i]);
            }
        }
        this.excelStyle.setStyleDefine_DocumentSheet(sheet);
        this.excelStyle.setColumnWidth(sheet);
    }

    public void writeDatasetSheet(XSSFWorkbook wb, DefineModel define) {
        logger.info("Generating " + this.config.defineDatasetTableName + " Sheet");
        XSSFSheet sheet = wb.createSheet(this.config.defineDatasetTableName);
        List<DefineDatasetModel> datasets = define.listSortedDataset();
        String[] header = new String[]{"Domain", "Dataset Name", "Has SUPP", "Description", "No Data", "SASDatasetName", "Repeating", "IsReferenceData", "Purpose", "Standard", "Structure", "Class", "Subclass", "CommentOID", "Comment", "Language", "DocumentID", "Document Page Type", "Document Page Reference", "Document First Page", "Document Last Page", "Document Page Title", "Alias", "Leaf href", "Leaf Title", "User Note 1", "User Note 2"};
        XSSFRow row = sheet.createRow(0);
        for (int i = 0; i < header.length; ++i) {
            row.createCell(i).setCellValue(header[i]);
        }
        int row_num = 1;
        for (DefineDatasetModel dataset : datasets) {
            DefineCommentModel comment = define.get(new DefineCommentModel.DefineCommentPk(dataset.comment_oid));
            DefineStandardModel standard = define.get(new DefineStandardModel.DefineStandardPk(dataset.standard_oid));
            row = sheet.createRow(row_num++);
            String[] data = new String[]{StringUtils.isEmpty((CharSequence)dataset.domain) ? dataset.dataset_name : dataset.domain, dataset.dataset_name, dataset.has_supp.name(), dataset.description, dataset.has_no_data == null ? "" : dataset.has_no_data.name(), dataset.sas_dataset_name, dataset.repeating.name(), dataset.is_reference_data.name(), dataset.purpose, standard == null ? "" : standard.name(DefineStandardModel.StandardType.IG), dataset.structure, dataset.dataset_class, dataset.dataset_subclass, comment != null && this.config.d2eSeparateSheet ? comment.oid : "", comment == null || this.config.d2eSeparateSheet ? "" : comment.comment_text, comment == null || this.config.d2eSeparateSheet ? "" : comment.comment_lang, comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentIdString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageTypeString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageRefString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentFirstPageString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentLastPageString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageTitleString(this.config.valueDelimiter), dataset.alias_name, dataset.leaf_href, dataset.leaf_title, dataset.user_note1, dataset.user_note2};
            for (int i = 0; i < header.length; ++i) {
                row.createCell(i).setCellValue(data[i]);
            }
        }
        this.excelStyle.setStyleDefine_DatasetSheet(sheet);
        this.excelStyle.setColumnWidth(sheet);
    }

    public void writeVariableSheet(XSSFWorkbook wb, DefineModel define) {
        logger.info("Generating " + this.config.defineVariableTableName + " Sheet");
        XSSFSheet sheet = wb.createSheet(this.config.defineVariableTableName);
        List<DefineVariableModel> variables = define.listSortedVariable();
        String[] header = new String[]{"Dataset Name", "Variable Name", "Is SUPP", "Repeat N", "Label", "No Data", "Non Standard", "Mandatory", "Key Sequence", "Sort Order", "DataType", "Length", "SignificantDigits", "SASFieldName", "DisplayFormat", "Codelist", "Origin", "Source", "Evaluator", "CRF ID", "CRF Page Type", "CRF Page Reference", "CRF First Page", "CRF Last Page", "CRF Page Title", "Has VLM", "MethodOID", "Derivation Type", "Predecessor/Derivation", "CommentOID", "Comment", "Language", "DocumentID", "Document Page Type", "Document Page Reference", "Document First Page", "Document Last Page", "Document Page Title", "Role", "Role Codelist", "FormalExpression Context", "FormalExpression Text", "Alias Context", "Alias Name", "User Note 1", "User Note 2"};
        XSSFRow row = sheet.createRow(0);
        for (int i = 0; i < header.length; ++i) {
            row.createCell(i).setCellValue(header[i]);
        }
        int row_num = 1;
        for (DefineVariableModel variable : variables) {
            DefineMethodModel method = define.get(new DefineMethodModel.DefineMethodPk(variable.method_oid));
            DefineCommentModel comment = define.get(new DefineCommentModel.DefineCommentPk(variable.comment_oid));
            row = sheet.createRow(row_num++);
            String[] stringArray = new String[46];
            stringArray[0] = variable.dataset_name;
            stringArray[1] = variable.variable_name;
            stringArray[2] = variable.is_supp.name();
            stringArray[3] = variable.repeat_n > 0 ? String.valueOf(variable.repeat_n) : "";
            stringArray[4] = variable.variable_label;
            stringArray[5] = variable.has_no_data == null ? "" : variable.has_no_data.name();
            stringArray[6] = variable.is_non_standard == null ? "" : variable.is_non_standard.name();
            stringArray[7] = variable.mandatory.name();
            stringArray[8] = variable.key_sequence;
            stringArray[9] = variable.sort_order;
            stringArray[10] = variable.data_type;
            stringArray[11] = variable.length;
            stringArray[12] = variable.significant_digits;
            stringArray[13] = variable.sas_field_name;
            stringArray[14] = variable.display_format;
            stringArray[15] = variable.codelist;
            stringArray[16] = variable.origin;
            stringArray[17] = variable.source;
            stringArray[18] = variable.evaluator;
            stringArray[19] = variable.crf_id;
            stringArray[20] = variable.crf_page_type;
            stringArray[21] = variable.crf_page_reference;
            stringArray[22] = variable.crf_first_page;
            stringArray[23] = variable.crf_last_page;
            stringArray[24] = variable.crf_page_title;
            stringArray[25] = variable.has_vlm.name();
            stringArray[26] = method != null && this.config.d2eSeparateSheet ? method.oid : "";
            String string = stringArray[27] = method != null && !this.config.d2eSeparateSheet ? method.method_type : "";
            stringArray[28] = StringUtils.isEmpty((CharSequence)variable.predecessor) ? (method == null || this.config.d2eSeparateSheet ? "" : method.description) : variable.predecessor;
            stringArray[29] = comment != null && this.config.d2eSeparateSheet ? comment.oid : "";
            stringArray[30] = comment == null || this.config.d2eSeparateSheet ? "" : comment.comment_text;
            String string2 = stringArray[31] = comment == null || this.config.d2eSeparateSheet ? "" : comment.comment_lang;
            String string3 = method != null && !this.config.d2eSeparateSheet ? method.getDocumentIdString(this.config.valueDelimiter) : (stringArray[32] = comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentIdString(this.config.valueDelimiter));
            String string4 = method != null && !this.config.d2eSeparateSheet ? method.getDocumentPageTypeString(this.config.valueDelimiter) : (stringArray[33] = comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageTypeString(this.config.valueDelimiter));
            String string5 = method != null && !this.config.d2eSeparateSheet ? method.getDocumentPageRefString(this.config.valueDelimiter) : (stringArray[34] = comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageRefString(this.config.valueDelimiter));
            String string6 = method != null && !this.config.d2eSeparateSheet ? method.getDocumentFirstPageString(this.config.valueDelimiter) : (stringArray[35] = comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentFirstPageString(this.config.valueDelimiter));
            String string7 = method != null && !this.config.d2eSeparateSheet ? method.getDocumentLastPageString(this.config.valueDelimiter) : (stringArray[36] = comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentLastPageString(this.config.valueDelimiter));
            stringArray[37] = method != null && !this.config.d2eSeparateSheet ? method.getDocumentPageTitleString(this.config.valueDelimiter) : (comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageTitleString(this.config.valueDelimiter));
            stringArray[38] = variable.role;
            stringArray[39] = variable.role_codelist;
            stringArray[40] = method == null ? "" : method.formal_expression_context;
            stringArray[41] = method == null ? "" : method.formal_expression;
            stringArray[42] = variable.alias_context;
            stringArray[43] = variable.alias_name;
            stringArray[44] = variable.user_note1;
            stringArray[45] = variable.user_note2;
            String[] data = stringArray;
            for (int i = 0; i < header.length; ++i) {
                row.createCell(i).setCellValue(data[i]);
            }
        }
        this.excelStyle.setStyleDefine_VariableSheet(sheet);
        this.excelStyle.setColumnWidth(sheet);
    }

    public void writeValueSheet(XSSFWorkbook wb, DefineModel define) {
        logger.info("Generating " + this.config.defineValueTableName + " Sheet");
        XSSFSheet sheet = wb.createSheet(this.config.defineValueTableName);
        List<DefineValueModel> values = define.listSortedValue();
        String[] header = new String[]{"Dataset Name", "Variable Name", "Value Name", "Value Key", "Label", "No Data", "Mandatory", "DataType", "Length", "SignificantDigits", "SASFieldName", "DisplayFormat", "Codelist", "Origin", "Source", "CRF ID", "CRF Page Type", "CRF Page Reference", "CRF First Page", "CRF Last Page", "CRF Page Title", "MethodOID", "Derivation Type", "Predecessor/Derivation", "CommentOID", "Comment", "Language", "DocumentID", "Document Page Type", "Document Page Reference", "Document First Page", "Document Last Page", "Document Page Title", "FormalExpression Context", "FormalExpression Text", "Alias Context", "Alias Name", "User Note 1", "User Note 2", "WhereClauseGroupID", "WhereClauseDataset", "WhereClauseVariable", "WhereClauseOperator", "WhereClauseValue", "WhereClause CommentOID", "WhereClause Comment", "WhereClause Language"};
        XSSFRow row = sheet.createRow(0);
        for (int i = 0; i < header.length; ++i) {
            row.createCell(i).setCellValue(header[i]);
        }
        int row_num = 1;
        for (DefineValueModel value : values) {
            DefineMethodModel method = define.get(new DefineMethodModel.DefineMethodPk(value.method_oid));
            DefineCommentModel comment = define.get(new DefineCommentModel.DefineCommentPk(value.comment_oid));
            List<Object> where_clause_pks = value.where_clause_pks.isEmpty() ? new ArrayList() : value.where_clause_pks;
            for (int i = 0; i == 0 || i < where_clause_pks.size(); ++i) {
                DefineWCModel.DefineWCPk where_clause_pk = where_clause_pks.isEmpty() ? null : (DefineWCModel.DefineWCPk)where_clause_pks.get(i);
                DefineWCModel wc = where_clause_pk == null ? null : define.get(where_clause_pk);
                DefineCommentModel wc_comment = wc == null ? null : define.get(new DefineCommentModel.DefineCommentPk(wc.comment_oid));
                ArrayList wc_conditions = wc == null || wc.wc_conditions.isEmpty() ? new ArrayList() : wc.wc_conditions;
                for (int j = 0; j == 0 || j < wc_conditions.size(); ++j) {
                    DefineWCModel.WCCondition wc_condition = wc_conditions.isEmpty() ? null : (DefineWCModel.WCCondition)wc_conditions.get(j);
                    row = sheet.createRow(row_num++);
                    String[] stringArray = new String[47];
                    stringArray[0] = value.dataset_name;
                    stringArray[1] = value.variable_name;
                    stringArray[2] = value.value_name;
                    stringArray[3] = value.value_key;
                    stringArray[4] = value.value_label;
                    stringArray[5] = value.has_no_data == null ? "" : value.has_no_data.name();
                    stringArray[6] = value.mandatory.name();
                    stringArray[7] = value.data_type;
                    stringArray[8] = value.length;
                    stringArray[9] = value.significant_digits;
                    stringArray[10] = value.sas_field_name;
                    stringArray[11] = value.display_format;
                    stringArray[12] = value.codelist;
                    stringArray[13] = value.origin;
                    stringArray[14] = value.source;
                    stringArray[15] = value.crf_id;
                    stringArray[16] = value.crf_page_type;
                    stringArray[17] = value.crf_page_reference;
                    stringArray[18] = value.crf_first_page;
                    stringArray[19] = value.crf_last_page;
                    stringArray[20] = value.crf_page_title;
                    stringArray[21] = method != null && this.config.d2eSeparateSheet ? method.oid : "";
                    String string = stringArray[22] = method != null && !this.config.d2eSeparateSheet ? method.method_type : "";
                    stringArray[23] = StringUtils.isEmpty((CharSequence)value.predecessor) ? (method == null || this.config.d2eSeparateSheet ? "" : method.description) : value.predecessor;
                    stringArray[24] = comment != null && this.config.d2eSeparateSheet ? comment.oid : "";
                    stringArray[25] = comment == null || this.config.d2eSeparateSheet ? "" : comment.comment_text;
                    String string2 = stringArray[26] = comment == null || this.config.d2eSeparateSheet ? "" : comment.comment_lang;
                    String string3 = method != null && !this.config.d2eSeparateSheet ? method.getDocumentIdString(this.config.valueDelimiter) : (stringArray[27] = comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentIdString(this.config.valueDelimiter));
                    String string4 = method != null && !this.config.d2eSeparateSheet ? method.getDocumentPageTypeString(this.config.valueDelimiter) : (stringArray[28] = comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageTypeString(this.config.valueDelimiter));
                    String string5 = method != null && !this.config.d2eSeparateSheet ? method.getDocumentPageRefString(this.config.valueDelimiter) : (stringArray[29] = comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageRefString(this.config.valueDelimiter));
                    String string6 = method != null && !this.config.d2eSeparateSheet ? method.getDocumentFirstPageString(this.config.valueDelimiter) : (stringArray[30] = comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentFirstPageString(this.config.valueDelimiter));
                    String string7 = method != null && !this.config.d2eSeparateSheet ? method.getDocumentLastPageString(this.config.valueDelimiter) : (stringArray[31] = comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentLastPageString(this.config.valueDelimiter));
                    stringArray[32] = method != null && !this.config.d2eSeparateSheet ? method.getDocumentPageTitleString(this.config.valueDelimiter) : (comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageTitleString(this.config.valueDelimiter));
                    stringArray[33] = method != null && !this.config.d2eSeparateSheet ? method.formal_expression_context : "";
                    stringArray[34] = method != null && !this.config.d2eSeparateSheet ? method.formal_expression : "";
                    stringArray[35] = value.alias_context;
                    stringArray[36] = value.alias_name;
                    stringArray[37] = value.user_note1;
                    stringArray[38] = value.user_note2;
                    stringArray[39] = wc == null ? "" : wc.group_id;
                    stringArray[40] = wc_condition == null ? "" : wc_condition.dataset_name;
                    stringArray[41] = wc_condition == null ? "" : wc_condition.variable_name;
                    stringArray[42] = wc_condition == null ? "" : wc_condition.operator;
                    stringArray[43] = wc_condition == null ? "" : Utils.join(wc_condition.values, this.config.valueDelimiter);
                    stringArray[44] = wc_comment != null && this.config.d2eSeparateSheet ? wc_comment.oid : "";
                    stringArray[45] = wc_comment == null || this.config.d2eSeparateSheet ? "" : wc_comment.comment_text;
                    stringArray[46] = wc_comment == null || this.config.d2eSeparateSheet ? "" : wc_comment.comment_lang;
                    String[] data = stringArray;
                    for (int k = 0; k < header.length; ++k) {
                        row.createCell(k).setCellValue(data[k]);
                    }
                }
            }
        }
        this.excelStyle.setStyleDefine_ValueSheet(sheet);
        this.excelStyle.setColumnWidth(sheet);
    }

    public void writeResult1Sheet(XSSFWorkbook wb, DefineModel define) {
        logger.info("Generating " + this.config.defineResult1TableName + " Sheet");
        XSSFSheet sheet = wb.createSheet(this.config.defineResult1TableName);
        List<DefineARMDisplayModel> arm_displays = define.listSortedARMDisplay();
        String[] header = new String[]{"Display Name", "Display Description", "Display Language", "Leaf ID", "Leaf Page Type", "Leaf Page Reference", "Leaf First Page", "Leaf Last Page", "User Note 1", "User Note 2", "Result Key", "Result Description", "Result Language", "ParameterOID Dataset", "Analysis Reason", "Analysis Purpose", "Documentation ID", "Documentation Page Type", "Documentation Page Reference", "Documentation First Page", "Documentation Last Page", "Documentation Text", "Documentation Language", "Programming Code Context", "Programming Code Text", "Programming Code Document ID", "Programming Code Document Page Type", "Programming Code Document Page Reference", "Programming Code Document First Page", "Programming Code Document Last Page", "Datasets CommentOID", "Datasets Comment", "Datasets Language", "Datasets DocumentID", "Datasets Document Page Type", "Datasets Document Page Reference", "Datasets Document First Page", "Datasets Document Last Page"};
        XSSFRow row = sheet.createRow(0);
        for (int i = 0; i < header.length; ++i) {
            row.createCell(i).setCellValue(header[i]);
        }
        int row_num = 1;
        for (DefineARMDisplayModel arm_display : arm_displays) {
            List<Object> arm_result_pks = arm_display.arm_result_pks.isEmpty() ? new ArrayList() : arm_display.arm_result_pks;
            for (int i = 0; i == 0 || i < arm_result_pks.size(); ++i) {
                DefineARMResultModel arm_result = arm_result_pks.isEmpty() ? null : define.get((DefineARMResultModel.DefineARMResultPk)arm_result_pks.get(i));
                DefineCommentModel dataset_comment = arm_result == null ? null : define.get(new DefineCommentModel.DefineCommentPk(arm_result.dataset_comment_oid));
                row = sheet.createRow(row_num++);
                String[] data = new String[]{arm_display.display_name, arm_display.display_desc, arm_display.display_lang, arm_display.getDocumentIdString(this.config.valueDelimiter), arm_display.getDocumentPageTypeString(this.config.valueDelimiter), arm_display.getDocumentPageRefString(this.config.valueDelimiter), arm_display.getDocumentFirstPageString(this.config.valueDelimiter), arm_display.getDocumentLastPageString(this.config.valueDelimiter), arm_display.user_note1, arm_display.user_note2, arm_result == null ? "" : arm_result.result_key, arm_result == null ? "" : arm_result.result_desc, arm_result == null ? "" : arm_result.result_lang, arm_result == null ? "" : arm_result.param_dataset, arm_result == null ? "" : arm_result.analysis_reason, arm_result == null ? "" : arm_result.analysis_purpose, arm_result == null ? "" : arm_result.getDocumentationIdString(this.config.valueDelimiter), arm_result == null ? "" : arm_result.getDocumentationPageTypeString(this.config.valueDelimiter), arm_result == null ? "" : arm_result.getDocumentationPageRefString(this.config.valueDelimiter), arm_result == null ? "" : arm_result.getDocumentationFirstPageString(this.config.valueDelimiter), arm_result == null ? "" : arm_result.getDocumentationLastPageString(this.config.valueDelimiter), arm_result == null ? "" : arm_result.docm_text, arm_result == null ? "" : arm_result.docm_lang, arm_result == null ? "" : arm_result.prog_code_context, arm_result == null ? "" : arm_result.prog_code_text, arm_result == null ? "" : arm_result.getCodeIdString(this.config.valueDelimiter), arm_result == null ? "" : arm_result.getCodePageTypeString(this.config.valueDelimiter), arm_result == null ? "" : arm_result.getCodePageRefString(this.config.valueDelimiter), arm_result == null ? "" : arm_result.getCodeFirstPageString(this.config.valueDelimiter), arm_result == null ? "" : arm_result.getCodeLastPageString(this.config.valueDelimiter), dataset_comment != null && this.config.d2eSeparateSheet ? dataset_comment.oid : "", dataset_comment == null || this.config.d2eSeparateSheet ? "" : dataset_comment.comment_text, dataset_comment == null || this.config.d2eSeparateSheet ? "" : dataset_comment.comment_lang, dataset_comment == null || this.config.d2eSeparateSheet ? "" : dataset_comment.getDocumentIdString(this.config.valueDelimiter), dataset_comment == null || this.config.d2eSeparateSheet ? "" : dataset_comment.getDocumentPageTypeString(this.config.valueDelimiter), dataset_comment == null || this.config.d2eSeparateSheet ? "" : dataset_comment.getDocumentPageRefString(this.config.valueDelimiter), dataset_comment == null || this.config.d2eSeparateSheet ? "" : dataset_comment.getDocumentFirstPageString(this.config.valueDelimiter), dataset_comment == null || this.config.d2eSeparateSheet ? "" : dataset_comment.getDocumentLastPageString(this.config.valueDelimiter)};
                for (int j = 0; j < header.length; ++j) {
                    row.createCell(j).setCellValue(data[j]);
                }
            }
        }
        this.excelStyle.setStyleDefine_Result1Sheet(sheet);
        this.excelStyle.setColumnWidth(sheet);
    }

    public void writeResult2Sheet(XSSFWorkbook wb, DefineModel define) {
        logger.info("Generating " + this.config.defineResult2TableName + " Sheet");
        XSSFSheet sheet = wb.createSheet(this.config.defineResult2TableName);
        List<DefineARMDatasetModel> arm_datasets = define.listSortedARMDataset();
        String[] header = new String[]{"Display Name", "Result Key", "Dataset Name", "Analysis Variable", "User Note 1", "User Note 2", "WhereClauseDataset", "WhereClauseVariable", "WhereClauseOperator", "WhereClauseValue", "WhereClause CommentOID", "WhereClause Comment", "WhereClause Language"};
        XSSFRow row = sheet.createRow(0);
        for (int i = 0; i < header.length; ++i) {
            row.createCell(i).setCellValue(header[i]);
        }
        int row_num = 1;
        for (DefineARMDatasetModel arm_dataset : arm_datasets) {
            DefineWCModel.DefineWCPk where_clause_pk = arm_dataset.where_clause_pk == null ? null : arm_dataset.where_clause_pk;
            DefineWCModel wc = where_clause_pk == null ? null : define.get(where_clause_pk);
            DefineCommentModel wc_comment = wc == null ? null : define.get(new DefineCommentModel.DefineCommentPk(wc.comment_oid));
            ArrayList wc_conditions = wc == null || wc.wc_conditions.isEmpty() ? new ArrayList() : wc.wc_conditions;
            for (int j = 0; j == 0 || j < wc_conditions.size(); ++j) {
                DefineWCModel.WCCondition wc_condition = wc_conditions.isEmpty() ? null : (DefineWCModel.WCCondition)wc_conditions.get(j);
                row = sheet.createRow(row_num++);
                String[] data = new String[]{arm_dataset.display_name, arm_dataset.result_key, arm_dataset.dataset_name, Utils.join(arm_dataset.analysis_variables, this.config.valueDelimiter), arm_dataset.user_note1, arm_dataset.user_note2, wc_condition == null ? "" : wc_condition.dataset_name, wc_condition == null ? "" : wc_condition.variable_name, wc_condition == null ? "" : wc_condition.operator, wc_condition == null ? "" : Utils.join(wc_condition.values, this.config.valueDelimiter), wc_comment != null && this.config.d2eSeparateSheet ? wc_comment.oid : "", wc_comment == null || this.config.d2eSeparateSheet ? "" : wc_comment.comment_text, wc_comment == null || this.config.d2eSeparateSheet ? "" : wc_comment.comment_lang};
                for (int k = 0; k < header.length; ++k) {
                    row.createCell(k).setCellValue(data[k]);
                }
            }
        }
        this.excelStyle.setStyleDefine_Result2Sheet(sheet);
        this.excelStyle.setColumnWidth(sheet);
    }

    public void writeDictionarySheet(XSSFWorkbook wb, DefineModel define) {
        logger.info("Generating " + this.config.defineDictionaryTableName + " Sheet");
        XSSFSheet sheet = wb.createSheet(this.config.defineDictionaryTableName);
        List<DefineDictionaryModel> dictionaries = define.listSortedDictionary();
        String[] header = new String[]{"Dictionary ID", "Name", "DataType", "Version", "ref", "href", "CommentOID", "Comment", "Language", "DocumentID", "Document Page Type", "Document Page Reference", "Document First Page", "Document Last Page", "Document Page Title", "User Note 1", "User Note 2"};
        XSSFRow row = sheet.createRow(0);
        for (int i = 0; i < header.length; ++i) {
            row.createCell(i).setCellValue(header[i]);
        }
        int row_num = 1;
        for (DefineDictionaryModel dictionary : dictionaries) {
            DefineCommentModel comment = define.get(new DefineCommentModel.DefineCommentPk(dictionary.comment_oid));
            row = sheet.createRow(row_num++);
            String[] data = new String[]{dictionary.dictionary_id, dictionary.dictionary_name, dictionary.data_type, dictionary.dictionary_version, dictionary.dictionary_ref, dictionary.dictionary_href, comment != null && this.config.d2eSeparateSheet ? comment.oid : "", comment == null || this.config.d2eSeparateSheet ? "" : comment.comment_text, comment == null || this.config.d2eSeparateSheet ? "" : comment.comment_lang, comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentIdString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageTypeString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageRefString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentFirstPageString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentLastPageString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageTitleString(this.config.valueDelimiter), dictionary.user_note1, dictionary.user_note2};
            for (int i = 0; i < header.length; ++i) {
                row.createCell(i).setCellValue(data[i]);
            }
        }
        this.excelStyle.setStyleDefine_DictionarySheet(sheet);
        this.excelStyle.setColumnWidth(sheet);
    }

    public void writeCodelistSheet(XSSFWorkbook wb, DefineModel define) {
        logger.info("Generating " + this.config.defineCodelistTableName + " Sheet");
        XSSFSheet sheet = wb.createSheet(this.config.defineCodelistTableName);
        List<DefineCodelistModel> codelists = define.listSortedCodelist();
        String[] header = new String[]{"Codelist ID", "Codelist Code", "Codelist Label", "DataType", "SASFormatName", "Standard", "CommentOID", "Comment", "Language", "DocumentID", "Document Page Type", "Document Page Reference", "Document First Page", "Document Last Page", "Document Page Title", "Code", "User Code", "Order Number", "Rank", "ExtendedValue", "Submission Value", "Decode", "Decode Language", "Alias Context", "Alias Name", "User Note 1", "User Note 2"};
        XSSFRow row = sheet.createRow(0);
        for (int i = 0; i < header.length; ++i) {
            row.createCell(i).setCellValue(header[i]);
        }
        int row_num = 1;
        for (DefineCodelistModel codelist : codelists) {
            DefineCommentModel comment = define.get(new DefineCommentModel.DefineCommentPk(codelist.comment_oid));
            DefineStandardModel standard = define.get(new DefineStandardModel.DefineStandardPk(codelist.standard_oid));
            row = sheet.createRow(row_num++);
            String[] data = new String[]{codelist.codelist_id, codelist.codelist_code, codelist.codelist_label, codelist.data_type, codelist.sas_format_name, standard == null ? "" : standard.name(DefineStandardModel.StandardType.CT), comment != null && this.config.d2eSeparateSheet ? comment.oid : "", comment == null || this.config.d2eSeparateSheet ? "" : comment.comment_text, comment == null || this.config.d2eSeparateSheet ? "" : comment.comment_lang, comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentIdString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageTypeString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageRefString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentFirstPageString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentLastPageString(this.config.valueDelimiter), comment == null || this.config.d2eSeparateSheet ? "" : comment.getDocumentPageTitleString(this.config.valueDelimiter), codelist.code, "", codelist.order_number > 0 ? codelist.order_number.toString() : "", codelist.rank > 0 ? codelist.rank.toString() : "", codelist.extended_value == null ? "" : codelist.extended_value.name(), codelist.submission_value, codelist.decode, codelist.xml_lang, codelist.alias_context, codelist.alias_name, codelist.user_note1, codelist.user_note2};
            for (int i = 0; i < header.length; ++i) {
                row.createCell(i).setCellValue(data[i]);
            }
        }
        this.excelStyle.setStyleDefine_CodelistSheet(sheet);
        this.excelStyle.setColumnWidth(sheet);
    }

    public void writeMethodSheet(XSSFWorkbook wb, DefineModel define) {
        logger.info("Generating " + this.config.defineMethodTableName + " Sheet");
        XSSFSheet sheet = wb.createSheet(this.config.defineMethodTableName);
        List<DefineMethodModel> methods = define.listSortedMethod();
        String[] header = new String[]{"OID", "Name", "Type", "Description", "Language", "DocumentID", "Document Page Type", "Document Page Reference", "Document First Page", "Document Last Page", "Document Page Title", "FormalExpression Context", "FormalExpression Text", "User Note 1", "User Note 2"};
        XSSFRow row = sheet.createRow(0);
        for (int i = 0; i < header.length; ++i) {
            row.createCell(i).setCellValue(header[i]);
        }
        int row_num = 1;
        for (DefineMethodModel method : methods) {
            row = sheet.createRow(row_num++);
            String[] data = new String[]{method.oid, method.method_name, method.method_type, method.description, method.description_lang, method.getDocumentIdString(this.config.valueDelimiter), method.getDocumentPageTypeString(this.config.valueDelimiter), method.getDocumentPageRefString(this.config.valueDelimiter), method.getDocumentFirstPageString(this.config.valueDelimiter), method.getDocumentLastPageString(this.config.valueDelimiter), method.getDocumentPageTitleString(this.config.valueDelimiter), method.formal_expression_context, method.formal_expression, method.user_note1, method.user_note2};
            for (int i = 0; i < header.length; ++i) {
                row.createCell(i).setCellValue(data[i]);
            }
        }
        this.excelStyle.setStyleDefine_MethodSheet(sheet);
        this.excelStyle.setColumnWidth(sheet);
    }

    public void writeCommentSheet(XSSFWorkbook wb, DefineModel define) {
        logger.info("Generating " + this.config.defineCommentTableName + " Sheet");
        XSSFSheet sheet = wb.createSheet(this.config.defineCommentTableName);
        List<DefineCommentModel> comments = define.listSortedComment();
        String[] header = new String[]{"OID", "Comment", "Language", "DocumentID", "Document Page Type", "Document Page Reference", "Document First Page", "Document Last Page", "Document Page Title", "User Note 1", "User Note 2"};
        XSSFRow row = sheet.createRow(0);
        for (int i = 0; i < header.length; ++i) {
            row.createCell(i).setCellValue(header[i]);
        }
        int row_num = 1;
        for (DefineCommentModel comment : comments) {
            row = sheet.createRow(row_num++);
            String[] data = new String[]{comment.oid, comment.comment_text, comment.comment_lang, comment.getDocumentIdString(this.config.valueDelimiter), comment.getDocumentPageTypeString(this.config.valueDelimiter), comment.getDocumentPageRefString(this.config.valueDelimiter), comment.getDocumentFirstPageString(this.config.valueDelimiter), comment.getDocumentLastPageString(this.config.valueDelimiter), comment.getDocumentPageTitleString(this.config.valueDelimiter), comment.user_note1, comment.user_note2};
            for (int i = 0; i < header.length; ++i) {
                row.createCell(i).setCellValue(data[i]);
            }
        }
        this.excelStyle.setStyleDefine_CommentSheet(sheet);
        this.excelStyle.setColumnWidth(sheet);
    }

    private static enum Type {
        SOFT,
        HARD;

    }
}

