/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer.models;

import com.fujitsu.tsc.desktop.importer.models.DefineModel;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefineCodelistModel
implements Comparable<DefineCodelistModel> {
    public final String codelist_id;
    public String codelist_code;
    public String codelist_label;
    public String data_type;
    public String sas_format_name;
    public String standard_oid;
    public String comment_oid;
    public String code;
    public Integer ordinal;
    public Integer order_number;
    public Integer rank;
    public DefineModel.YorNull extended_value;
    public final String submission_value;
    public String decode;
    public String xml_lang;
    public String alias_context;
    public String alias_name;
    public String user_note1;
    public String user_note2;

    public DefineCodelistModel(DefineCodelistPk key) {
        this.codelist_id = key.codelist_id;
        this.codelist_code = "";
        this.codelist_label = "";
        this.data_type = "";
        this.sas_format_name = "";
        this.standard_oid = "";
        this.comment_oid = "";
        this.code = "";
        this.ordinal = 0;
        this.order_number = -1;
        this.rank = -1;
        this.extended_value = null;
        this.submission_value = key.submission_value;
        this.decode = "";
        this.xml_lang = "";
        this.alias_context = "";
        this.alias_name = "";
        this.user_note1 = "";
        this.user_note2 = "";
    }

    public DefineCodelistPk getKey() {
        return new DefineCodelistPk(this.codelist_id, this.submission_value);
    }

    public void copy(DefineCodelistModel codelist) {
        if (!StringUtils.isEmpty((CharSequence)codelist.codelist_code)) {
            this.codelist_code = codelist.codelist_code;
        }
        if (!StringUtils.isEmpty((CharSequence)codelist.codelist_label)) {
            this.codelist_label = codelist.codelist_label;
        }
        if (!StringUtils.isEmpty((CharSequence)codelist.data_type)) {
            this.data_type = codelist.data_type;
        }
        if (!StringUtils.isEmpty((CharSequence)codelist.sas_format_name)) {
            this.sas_format_name = codelist.sas_format_name;
        }
        if (!StringUtils.isEmpty((CharSequence)codelist.standard_oid)) {
            this.standard_oid = codelist.standard_oid;
        }
        if (!StringUtils.isEmpty((CharSequence)codelist.comment_oid)) {
            this.comment_oid = codelist.comment_oid;
        }
        if (!StringUtils.isEmpty((CharSequence)codelist.code)) {
            this.code = codelist.code;
        }
        if (codelist.ordinal > 0) {
            this.ordinal = codelist.ordinal;
        }
        if (codelist.order_number > -1) {
            this.order_number = codelist.order_number;
        }
        if (codelist.rank > -1) {
            this.rank = codelist.rank;
        }
        if (codelist.extended_value != null) {
            this.extended_value = codelist.extended_value;
        }
        if (!StringUtils.isEmpty((CharSequence)codelist.decode)) {
            this.decode = codelist.decode;
        }
        if (!StringUtils.isEmpty((CharSequence)codelist.xml_lang)) {
            this.xml_lang = codelist.xml_lang;
        }
        if (!StringUtils.isEmpty((CharSequence)codelist.alias_context)) {
            this.alias_context = codelist.alias_context;
        }
        if (!StringUtils.isEmpty((CharSequence)codelist.alias_name)) {
            this.alias_name = codelist.alias_name;
        }
        if (!StringUtils.isEmpty((CharSequence)codelist.user_note1)) {
            this.user_note1 = codelist.user_note1;
        }
        if (!StringUtils.isEmpty((CharSequence)codelist.user_note2)) {
            this.user_note2 = codelist.user_note2;
        }
    }

    public String getCodelistOid() {
        return DefineCodelistModel.createCodelistOid(this.codelist_id);
    }

    public static String createCodelistOid(String codelist_id) {
        return "CL." + codelist_id;
    }

    public static List<DefineCodelistModel> listByCodelistId(DefineModel define, String codelist_id) {
        List<DefineCodelistModel> codelists = define.listSortedCodelist().stream().filter(o -> StringUtils.equals((CharSequence)o.codelist_id, (CharSequence)codelist_id)).collect(Collectors.toList());
        return codelists;
    }

    @Override
    public int compareTo(DefineCodelistModel codelist) {
        if (this.codelist_id.equals(codelist.codelist_id)) {
            return Integer.compare(this.ordinal, codelist.ordinal);
        }
        return this.codelist_id.compareTo(codelist.codelist_id);
    }

    public static class DefineCodelistPk
    implements Comparable<DefineCodelistPk> {
        public final String codelist_id;
        public final String submission_value;

        public DefineCodelistPk(String codelist_id, String submission_value) {
            this.codelist_id = codelist_id;
            this.submission_value = submission_value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.codelist_id.equals(((DefineCodelistPk)obj).codelist_id) && this.submission_value.equals(((DefineCodelistPk)obj).submission_value);
        }

        @Override
        public int compareTo(DefineCodelistPk key) {
            return (this.codelist_id + this.submission_value).compareTo(key.codelist_id + key.submission_value);
        }

        public String toString() {
            String rtn = "Codelist ID: " + this.codelist_id + System.lineSeparator();
            rtn = rtn + "Submission Value: " + this.submission_value;
            return rtn;
        }

        public int hashCode() {
            return Objects.hash(this.codelist_id, this.submission_value);
        }
    }
}

