/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer.models;

import com.fujitsu.tsc.desktop.importer.models.DefineARMResultModel;
import com.fujitsu.tsc.desktop.importer.models.DefineCodelistModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDatasetModel;
import com.fujitsu.tsc.desktop.importer.models.DefineDictionaryModel;
import com.fujitsu.tsc.desktop.importer.models.DefineModel;
import com.fujitsu.tsc.desktop.importer.models.DefineStandardModel;
import com.fujitsu.tsc.desktop.importer.models.DefineStudyModel;
import com.fujitsu.tsc.desktop.importer.models.DefineValueModel;
import com.fujitsu.tsc.desktop.importer.models.DefineVariableModel;
import com.fujitsu.tsc.desktop.importer.models.DefineWCModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefineCommentModel
implements Comparable<DefineCommentModel> {
    public final String oid;
    public Integer ordinal;
    public String comment_text;
    public String comment_lang;
    public List<DefineModel.DocumentRef> document_refs;
    public String user_note1;
    public String user_note2;
    private static final String PREFIX = "COM.";

    public DefineCommentModel(DefineCommentPk key) {
        this.oid = key.oid;
        this.ordinal = 0;
        this.comment_text = "";
        this.comment_lang = "";
        this.document_refs = new ArrayList<DefineModel.DocumentRef>();
    }

    public void copy(DefineCommentModel comment) {
        if (comment.ordinal > 0) {
            this.ordinal = comment.ordinal;
        }
        if (!StringUtils.isEmpty((CharSequence)comment.comment_text)) {
            this.comment_text = comment.comment_text;
        }
        if (!StringUtils.isEmpty((CharSequence)comment.comment_lang)) {
            this.comment_lang = comment.comment_lang;
        }
        if (!comment.document_refs.isEmpty()) {
            this.document_refs = comment.document_refs;
        }
    }

    public static String createCommentOID(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj.getClass() == DefineStudyModel.class) {
            return PREFIX + ((DefineStudyModel)obj).toMetaDataOid();
        }
        if (obj.getClass() == DefineStandardModel.class) {
            return PREFIX + ((DefineStandardModel)obj).toOid();
        }
        if (obj.getClass() == DefineDatasetModel.class) {
            return PREFIX + ((DefineDatasetModel)obj).toOid();
        }
        if (obj.getClass() == DefineVariableModel.class) {
            return PREFIX + ((DefineVariableModel)obj).toOid();
        }
        if (obj.getClass() == DefineValueModel.class) {
            return PREFIX + ((DefineValueModel)obj).toOid();
        }
        if (obj.getClass() == DefineWCModel.class) {
            return PREFIX + ((DefineWCModel)obj).toOid();
        }
        if (obj.getClass() == DefineDictionaryModel.class) {
            return PREFIX + ((DefineDictionaryModel)obj).toOid();
        }
        if (obj.getClass() == DefineCodelistModel.class) {
            return PREFIX + ((DefineCodelistModel)obj).getCodelistOid();
        }
        if (obj.getClass() == DefineARMResultModel.class) {
            return PREFIX + ((DefineARMResultModel)obj).toOid();
        }
        return "";
    }

    public static String createCommentOID(String obj_oid) {
        if (StringUtils.isEmpty((CharSequence)obj_oid)) {
            return "";
        }
        return PREFIX + obj_oid;
    }

    public static DefineCommentModel findByOid(DefineModel define, String comment_oid) {
        DefineCommentModel comment = define.listSortedComment().stream().filter(o -> StringUtils.equals((CharSequence)o.oid, (CharSequence)comment_oid)).findFirst().orElse(null);
        return comment;
    }

    public String getDocumentIdString(String delimiter) {
        String rtn = "";
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_id;
        }
        return rtn;
    }

    public String getDocumentPageTypeString(String delimiter) {
        String rtn = "";
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_page_type;
        }
        return rtn;
    }

    public String getDocumentPageRefString(String delimiter) {
        String rtn = "";
        if (this.document_refs.isEmpty()) {
            return rtn;
        }
        List document_page_references = this.document_refs.stream().map(o -> o.document_page_reference).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_page_references.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_page_reference;
        }
        return rtn;
    }

    public String getDocumentFirstPageString(String delimiter) {
        String rtn = "";
        if (this.document_refs.isEmpty()) {
            return rtn;
        }
        List document_first_pages = this.document_refs.stream().map(o -> o.document_first_page).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_first_pages.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_first_page;
        }
        return rtn;
    }

    public String getDocumentLastPageString(String delimiter) {
        String rtn = "";
        if (this.document_refs.isEmpty()) {
            return rtn;
        }
        List document_last_pages = this.document_refs.stream().map(o -> o.document_last_page).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_last_pages.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_last_page;
        }
        return rtn;
    }

    public String getDocumentPageTitleString(String delimiter) {
        String rtn = "";
        if (this.document_refs.isEmpty()) {
            return rtn;
        }
        List document_page_titles = this.document_refs.stream().map(o -> o.document_page_title).filter(o -> StringUtils.isNotEmpty((CharSequence)o)).collect(Collectors.toList());
        if (document_page_titles.isEmpty()) {
            return rtn;
        }
        for (int i = 0; i < this.document_refs.size(); ++i) {
            if (i > 0) {
                rtn = rtn + delimiter;
            }
            rtn = rtn + this.document_refs.get((int)i).document_page_title;
        }
        return rtn;
    }

    @Override
    public int compareTo(DefineCommentModel comment) {
        return this.oid.compareTo(comment.oid);
    }

    public static class DefineCommentPk
    implements Comparable<DefineCommentPk> {
        public final String oid;

        public DefineCommentPk(String oid) {
            this.oid = oid;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.oid.equals(((DefineCommentPk)obj).oid);
        }

        @Override
        public int compareTo(DefineCommentPk key) {
            return this.oid.compareTo(key.oid);
        }

        public String toString() {
            String rtn = "Comment OID: " + this.oid;
            return rtn;
        }

        public int hashCode() {
            return Objects.hash(this.oid);
        }
    }
}

