/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer.models;

import com.fujitsu.tsc.desktop.importer.models.DefineModel;
import java.util.Objects;

public class DefineDatasetModel
implements Comparable<DefineDatasetModel> {
    public String domain;
    public final String dataset_name;
    public String dataset_oid;
    public Integer ordinal;
    public DefineModel.YorN has_supp;
    public String description;
    public DefineModel.YorNull has_no_data;
    public String sas_dataset_name;
    public DefineModel.YorN repeating;
    public DefineModel.YorN is_reference_data;
    public String purpose;
    public String standard_oid;
    public String structure;
    public String dataset_class;
    public String dataset_subclass;
    public String comment_oid;
    public String alias_name;
    public String leaf_href;
    public String leaf_title;
    public String user_note1;
    public String user_note2;

    public DefineDatasetModel(DefineDatasetPk key) {
        this.dataset_name = key.dataset_name;
        this.dataset_oid = "";
        this.domain = "";
        this.ordinal = 0;
        this.has_supp = DefineModel.YorN.No;
        this.description = "";
        this.has_no_data = null;
        this.sas_dataset_name = "";
        this.repeating = DefineModel.YorN.No;
        this.is_reference_data = DefineModel.YorN.No;
        this.purpose = "";
        this.standard_oid = "";
        this.structure = "";
        this.dataset_class = "";
        this.dataset_subclass = "";
        this.comment_oid = "";
        this.alias_name = "";
        this.leaf_href = "";
        this.leaf_title = "";
        this.user_note1 = "";
        this.user_note2 = "";
    }

    public String toOid() {
        return DefineDatasetModel.createOid(this.dataset_name);
    }

    public static String createOid(String dataset_name) {
        return "IG." + dataset_name;
    }

    public String getLeafOid() {
        return DefineDatasetModel.createLeafOid(this.dataset_name);
    }

    public static String createLeafOid(String dataset_name) {
        return "LF." + dataset_name;
    }

    @Override
    public int compareTo(DefineDatasetModel dataset) {
        return Integer.compare(this.ordinal, dataset.ordinal);
    }

    public static class DefineDatasetPk
    implements Comparable<DefineDatasetPk> {
        public final String dataset_name;

        public DefineDatasetPk(String dataset_name) {
            this.dataset_name = dataset_name;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.dataset_name.equals(((DefineDatasetPk)obj).dataset_name);
        }

        @Override
        public int compareTo(DefineDatasetPk key) {
            return this.dataset_name.compareTo(key.dataset_name);
        }

        public String toString() {
            String rtn = "Dataset Name: " + this.dataset_name;
            return rtn;
        }

        public int hashCode() {
            return Objects.hash(this.dataset_name);
        }
    }
}

