/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer.models;

import com.fujitsu.tsc.desktop.importer.models.DefineDatasetModel;
import com.fujitsu.tsc.desktop.importer.models.DefineModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefineVariableModel
implements Comparable<DefineVariableModel> {
    public final String dataset_name;
    public final String variable_oid;
    public String variable_name;
    public Integer dataset_ordinal;
    public Integer ordinal;
    public String domain;
    public DefineModel.YorN is_supp;
    public Integer repeat_n;
    public String variable_label;
    public DefineModel.YorNull has_no_data;
    public DefineModel.YorNull has_no_data_derived;
    public DefineModel.YorNull is_non_standard;
    public DefineModel.YorN mandatory;
    public String key_sequence;
    public String sort_order;
    public String data_type;
    public String length;
    public List<String> repeat_n_length;
    public String significant_digits;
    public String sas_field_name;
    public String display_format;
    public String codelist;
    public String origin;
    public String source;
    public String evaluator;
    public String crf_id;
    public String crf_page_type;
    public String crf_page_reference;
    public String crf_first_page;
    public String crf_last_page;
    public String crf_page_title;
    public DefineModel.YorN has_vlm;
    public String predecessor;
    public String method_oid;
    public String comment_oid;
    public String role;
    public String role_codelist;
    public String alias_context;
    public String alias_name;
    public String user_note1;
    public String user_note2;
    public String valuelist_oid;

    public DefineVariableModel(DefineVariablePk key) {
        this.dataset_name = key.dataset_name;
        this.variable_oid = key.variable_oid;
        this.variable_name = "";
        this.dataset_ordinal = 0;
        this.ordinal = 0;
        this.domain = "";
        this.is_supp = DefineModel.YorN.No;
        this.repeat_n = 0;
        this.variable_label = "";
        this.has_no_data = null;
        this.has_no_data_derived = null;
        this.is_non_standard = null;
        this.mandatory = DefineModel.YorN.No;
        this.key_sequence = "";
        this.sort_order = "";
        this.data_type = "";
        this.length = "";
        this.repeat_n_length = new ArrayList<String>();
        this.significant_digits = "";
        this.sas_field_name = "";
        this.display_format = "";
        this.codelist = "";
        this.origin = "";
        this.source = "";
        this.evaluator = "";
        this.crf_id = "";
        this.crf_page_type = "";
        this.crf_page_reference = "";
        this.crf_first_page = "";
        this.crf_last_page = "";
        this.crf_page_title = "";
        this.has_vlm = DefineModel.YorN.No;
        this.predecessor = "";
        this.method_oid = "";
        this.comment_oid = "";
        this.role = "";
        this.role_codelist = "";
        this.alias_context = "";
        this.alias_name = "";
        this.user_note1 = "";
        this.user_note2 = "";
    }

    public void copy(DefineVariableModel variable) {
        if (variable == null) {
            return;
        }
        this.variable_name = variable.variable_name;
        this.dataset_ordinal = variable.dataset_ordinal;
        this.ordinal = 0;
        this.domain = variable.domain;
        this.is_supp = variable.is_supp;
        this.repeat_n = variable.repeat_n;
        this.variable_label = variable.variable_label;
        this.has_no_data = variable.has_no_data;
        this.has_no_data_derived = variable.has_no_data_derived;
        this.is_non_standard = variable.is_non_standard;
        this.mandatory = variable.mandatory;
        this.key_sequence = variable.key_sequence;
        this.sort_order = variable.sort_order;
        this.data_type = variable.data_type;
        this.length = variable.length;
        this.repeat_n_length = variable.repeat_n_length;
        this.significant_digits = variable.significant_digits;
        this.sas_field_name = variable.sas_field_name;
        this.display_format = variable.display_format;
        this.codelist = variable.codelist;
        this.origin = variable.origin;
        this.source = variable.source;
        this.evaluator = variable.evaluator;
        this.crf_id = variable.crf_id;
        this.crf_page_type = variable.crf_page_type;
        this.crf_page_reference = variable.crf_page_reference;
        this.crf_first_page = variable.crf_first_page;
        this.crf_last_page = variable.crf_last_page;
        this.crf_page_title = variable.crf_page_title;
        this.has_vlm = variable.has_vlm;
        this.predecessor = variable.predecessor;
        this.method_oid = variable.method_oid;
        this.comment_oid = variable.comment_oid;
        this.role = variable.role;
        this.role_codelist = variable.role_codelist;
        this.alias_context = variable.alias_context;
        this.alias_name = variable.alias_name;
        this.user_note1 = variable.user_note1;
        this.user_note2 = variable.user_note2;
    }

    public DefineVariablePk getKey() {
        return new DefineVariablePk(this.dataset_name, this.variable_oid);
    }

    public String toOid() {
        return this.variable_oid;
    }

    public static String createOid(String dataset_name, String variable_name) {
        return "IT." + dataset_name + "." + variable_name;
    }

    public static String createValueListOid(String dataset_name, String variable_name) {
        return "VL." + dataset_name + "." + variable_name;
    }

    public static String createMethodOid(String dataset_name, String variable_name) {
        return "MT." + DefineVariableModel.createOid(dataset_name, variable_name);
    }

    public DefineModel.YorNull deriveHasNoData(DefineModel define) {
        DefineDatasetModel dataset = define.get(new DefineDatasetModel.DefineDatasetPk(this.dataset_name));
        if (dataset == null || dataset.has_no_data == null) {
            return this.has_no_data;
        }
        return DefineModel.YorNull.Yes;
    }

    @Override
    public int compareTo(DefineVariableModel variable) {
        if (this.dataset_ordinal == variable.dataset_ordinal) {
            return Integer.compare(this.ordinal, variable.ordinal);
        }
        return Integer.compare(this.dataset_ordinal, variable.dataset_ordinal);
    }

    public static class DefineVariablePk
    implements Comparable<DefineVariablePk> {
        public final String dataset_name;
        public final String variable_oid;

        public DefineVariablePk(String dataset_name, String variable_oid) {
            this.dataset_name = dataset_name;
            this.variable_oid = variable_oid;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.dataset_name.equals(((DefineVariablePk)obj).dataset_name) && this.variable_oid.equals(((DefineVariablePk)obj).variable_oid);
        }

        @Override
        public int compareTo(DefineVariablePk key) {
            return (this.dataset_name + this.variable_oid).compareTo(key.dataset_name + key.variable_oid);
        }

        public String toString() {
            String rtn = "Dataset Name: " + this.dataset_name + System.lineSeparator();
            rtn = rtn + "Variable OID: " + this.variable_oid;
            return rtn;
        }

        public int hashCode() {
            return Objects.hash(this.dataset_name, this.variable_oid);
        }
    }
}

