/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer.models;

import com.fujitsu.tsc.desktop.importer.models.DefineARMDatasetModel;
import com.fujitsu.tsc.desktop.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefineWCModel
implements Comparable<DefineWCModel> {
    public final String oid;
    public String group_id;
    public List<WCCondition> wc_conditions;
    public String comment_oid;

    public DefineWCModel(DefineWCPk key) {
        this.oid = key.oid;
        this.group_id = "";
        this.wc_conditions = new ArrayList<WCCondition>();
        this.comment_oid = "";
    }

    public void copy(DefineWCModel wc) {
        if (wc.wc_conditions != null && !wc.wc_conditions.isEmpty()) {
            this.wc_conditions = wc.wc_conditions;
        }
        if (!StringUtils.isEmpty((CharSequence)wc.comment_oid)) {
            this.comment_oid = wc.comment_oid;
        }
    }

    public String toOid() {
        return this.oid;
    }

    public static String createOid(String dataset_name, String variable_name, String value_name, String value_key, String wc_group_id) {
        String wc_oid = "";
        String coded_wc_group_id = Utils.codedText(wc_group_id);
        wc_oid = StringUtils.isEmpty((CharSequence)value_key) ? "WC." + dataset_name + "." + variable_name + "." + Utils.codedText(value_name) + (StringUtils.isEmpty((CharSequence)coded_wc_group_id) ? "" : "." + coded_wc_group_id) : "WC." + dataset_name + "." + variable_name + "." + Utils.codedText(value_key) + (StringUtils.isEmpty((CharSequence)coded_wc_group_id) ? "" : "." + coded_wc_group_id);
        return wc_oid;
    }

    public static String createOid(DefineARMDatasetModel arm_dataset) {
        if (arm_dataset == null) {
            return "";
        }
        return "WC." + Utils.codedText(arm_dataset.display_name) + "." + Utils.codedText(arm_dataset.result_key) + "." + arm_dataset.dataset_name;
    }

    @Override
    public int compareTo(DefineWCModel wc) {
        return this.oid.compareTo(wc.oid);
    }

    public static class WCCondition {
        public String variable_oid = "";
        public String dataset_name = "";
        public String variable_name = "";
        public String operator = "";
        public List<String> values = new ArrayList<String>();
    }

    public static class DefineWCPk
    implements Comparable<DefineWCPk> {
        public final String oid;

        public DefineWCPk(String oid) {
            this.oid = oid;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.oid.equals(((DefineWCPk)obj).oid);
        }

        @Override
        public int compareTo(DefineWCPk key) {
            return this.oid.compareTo(key.oid);
        }

        public String toString() {
            String rtn = "WhereClause OID: " + this.oid;
            return rtn;
        }

        public int hashCode() {
            return Objects.hash(this.oid);
        }
    }
}

