/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.exporter;

import com.fujitsu.tsc.desktop.util.MetaDataReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class SuppUtil {
    private ArrayList<String> suppDatasets = new ArrayList();
    private Hashtable<String, ArrayList<Variable>> suppVariables = new Hashtable();
    private Hashtable seqList = new Hashtable();
    private Hashtable datasetAndDomainSet = new Hashtable();

    SuppUtil() {
    }

    public boolean scanDatasets(MetaDataReader reader) {
        Hashtable<String, String> hash;
        boolean hasSuppFlag = false;
        while ((hash = reader.read()) != null) {
            if (hash.get("Has SUPP") == null || !hash.get("Has SUPP").equals("Yes")) continue;
            this.suppDatasets.add(hash.get("Dataset Name"));
            hasSuppFlag = true;
            this.datasetAndDomainSet.put(hash.get("Dataset Name"), hash.get("Domain"));
        }
        return hasSuppFlag;
    }

    public boolean scanVariables(MetaDataReader reader) {
        Hashtable<String, String> hash;
        boolean isSuppFlag = false;
        ArrayList<Object> variables = null;
        while ((hash = reader.read()) != null) {
            if (hash.get("Is SUPP") != null && hash.get("Is SUPP").equals("Yes")) {
                Variable var = new Variable();
                if (this.suppVariables.containsKey(hash.get("Dataset Name"))) {
                    variables = this.suppVariables.get(hash.get("Dataset Name"));
                    var.variable_name = hash.get("Variable Name");
                    var.label = hash.get("Label");
                    var.data_type = hash.get("DataType");
                    var.length = hash.get("Length");
                    var.sig_digits = hash.get("SignificantDigits");
                    var.origin.origin = hash.get("Origin");
                    var.origin.crf_id = hash.get("CRF ID");
                    var.origin.crf_page_type = hash.get("CRF Page Type");
                    var.origin.str_crf_page_reference = hash.get("CRF Page Reference");
                    var.mandatory = hash.get("Mandatory");
                    variables.add(var);
                    this.suppVariables.put(hash.get("Dataset Name"), variables);
                } else {
                    variables = new ArrayList();
                    var.variable_name = hash.get("Variable Name");
                    var.label = hash.get("Label");
                    var.data_type = hash.get("DataType");
                    var.length = hash.get("Length");
                    var.sig_digits = hash.get("SignificantDigits");
                    var.origin.origin = hash.get("Origin");
                    var.origin.crf_id = hash.get("CRF ID");
                    var.origin.crf_page_type = hash.get("CRF Page Type");
                    var.origin.str_crf_page_reference = hash.get("CRF Page Reference");
                    var.mandatory = hash.get("Mandatory");
                    variables.add(var);
                    this.suppVariables.put(hash.get("Dataset Name"), variables);
                }
                isSuppFlag = true;
                continue;
            }
            if (hash.get("Is SUPP") == null || hash.get("Is SUPP").equals("Yes") || !hash.get("Variable Name").endsWith("SEQ") || hash.get("Variable Name").length() != 5 || hash.get("Length") == null) continue;
            this.seqList.put(hash.get("Dataset Name"), hash.get("Length"));
        }
        return isSuppFlag;
    }

    public List<String> getSuppDatasets() {
        return this.suppDatasets.stream().sorted((s1, s2) -> s1.compareTo((String)s2)).collect(Collectors.toList());
    }

    public Hashtable<String, String> getDatasetAndDomainSet() {
        return this.datasetAndDomainSet;
    }

    public ArrayList<Variable> getSuppVariables(String dataset) {
        ArrayList<Variable> variables = null;
        variables = this.suppVariables.get(dataset);
        if (variables == null) {
            variables = new ArrayList();
        }
        return variables;
    }

    public int getQnamLength(String dataset) {
        ArrayList<Variable> variables = null;
        int length = 0;
        variables = this.suppVariables.get(dataset);
        for (Variable var : variables) {
            if (var.variable_name == null || length >= var.variable_name.length()) continue;
            length = var.variable_name.length();
        }
        return length;
    }

    public int getQlabelLength(String dataset) {
        ArrayList<Variable> variables = null;
        int length = 0;
        variables = this.suppVariables.get(dataset);
        for (Variable var : variables) {
            if (var.label == null || length >= var.label.length()) continue;
            length = var.label.length();
        }
        return length;
    }

    public String getQvalDataType(String dataset) {
        ArrayList<Variable> variables = this.suppVariables.get(dataset);
        String DEFAULT_TYPE = "text";
        if (variables == null) {
            return DEFAULT_TYPE;
        }
        String data_type = DEFAULT_TYPE;
        int i = 0;
        while (i < variables.size()) {
            Variable var = variables.get(i);
            if (var != null) {
                if (i == 0) {
                    data_type = var.data_type;
                } else if (!StringUtils.equals((CharSequence)data_type, (CharSequence)var.data_type)) {
                    return DEFAULT_TYPE;
                }
            }
            ++i;
        }
        return data_type;
    }

    public String getQvalLength(String dataset) {
        ArrayList<Variable> variables = null;
        int length = 0;
        variables = this.suppVariables.get(dataset);
        for (Variable var : variables) {
            try {
                if (!StringUtils.isNotEmpty((CharSequence)var.length) || length >= Integer.parseInt(var.length)) continue;
                length = Integer.parseInt(var.length);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (length > 0) {
            return new Integer(length).toString();
        }
        return "";
    }

    public String getQvalSigDigits(String dataset) {
        ArrayList<Variable> variables = null;
        int sig_digits = 0;
        variables = this.suppVariables.get(dataset);
        for (Variable var : variables) {
            try {
                if (!StringUtils.isNotEmpty((CharSequence)var.sig_digits) || sig_digits >= Integer.parseInt(var.sig_digits)) continue;
                sig_digits = Integer.parseInt(var.sig_digits);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (sig_digits > 0) {
            return new Integer(sig_digits).toString();
        }
        return "";
    }

    public Origin getQvalOrigin(String dataset) {
        ArrayList<Variable> variables = null;
        Origin origin = new Origin();
        boolean isFirst = true;
        boolean notSame = false;
        variables = this.suppVariables.get(dataset);
        for (Variable var : variables) {
            String page;
            int n;
            int n2;
            String[] stringArray;
            String[] pages;
            if (var.origin != null && isFirst) {
                origin.origin = var.origin.origin;
                if ("CRF".equals(origin.origin)) {
                    origin.crf_id = var.origin.crf_id;
                    origin.crf_page_type = var.origin.crf_page_type;
                    if (var.origin.str_crf_page_reference != null) {
                        if ("PhysicalRef".equals(origin.crf_page_type)) {
                            stringArray = pages = var.origin.str_crf_page_reference.split(" ");
                            n2 = pages.length;
                            n = 0;
                            while (n < n2) {
                                page = stringArray[n];
                                origin.crf_page_reference.add(NumberUtils.toInt((String)page));
                                ++n;
                            }
                        } else {
                            origin.str_crf_page_reference = var.origin.str_crf_page_reference;
                        }
                    }
                }
                isFirst = false;
                continue;
            }
            if (var.origin != null && !isFirst) {
                if (StringUtils.equals((CharSequence)origin.origin, (CharSequence)var.origin.origin)) {
                    if (!"CRF".equals(origin.origin)) continue;
                    if (StringUtils.equals((CharSequence)origin.crf_id, (CharSequence)var.origin.crf_id) && StringUtils.isEmpty((CharSequence)origin.str_crf_page_reference) && "PhysicalRef".equals(var.origin.crf_page_type)) {
                        stringArray = pages = var.origin.str_crf_page_reference.split(" ");
                        n2 = pages.length;
                        n = 0;
                        while (n < n2) {
                            page = stringArray[n];
                            origin.crf_page_reference.add(NumberUtils.toInt((String)page));
                            ++n;
                        }
                        continue;
                    }
                    notSame = true;
                    continue;
                }
                notSame = true;
                continue;
            }
            notSame = true;
        }
        if (notSame) {
            return null;
        }
        return origin;
    }

    public int getQorigLength(String dataset) {
        ArrayList<Variable> variables = null;
        int length = 0;
        variables = this.suppVariables.get(dataset);
        for (Variable var : variables) {
            if (var.origin == null || length >= StringUtils.length((CharSequence)var.origin.origin)) continue;
            length = StringUtils.length((CharSequence)var.origin.origin);
        }
        return length;
    }

    public int getQevalLength(String dataset) {
        ArrayList<Variable> variables = null;
        int length = 1;
        variables = this.suppVariables.get(dataset);
        for (Variable var : variables) {
            if (var.evaluator == null || length >= StringUtils.length((CharSequence)var.evaluator)) continue;
            length = StringUtils.length((CharSequence)var.evaluator);
        }
        return length;
    }

    public String getIdVarvalLength(String dataset) {
        String length = null;
        length = this.seqList.containsKey(dataset) ? this.seqList.get(dataset).toString() : "";
        return length;
    }

    public class Origin {
        public String origin = "";
        public String crf_id = "";
        public String crf_page_type = "";
        public Set<Integer> crf_page_reference = new HashSet<Integer>();
        public String str_crf_page_reference = "";

        public String pagesInString() {
            if (this.crf_page_reference == null || this.crf_page_reference.size() == 0) {
                return "";
            }
            List pages = this.crf_page_reference.stream().sorted((num1, num2) -> Integer.compare(num1, num2)).collect(Collectors.toList());
            String str_pages = "";
            int i = 0;
            while (i < pages.size()) {
                if (i > 0) {
                    str_pages = String.valueOf(str_pages) + " ";
                }
                str_pages = String.valueOf(str_pages) + pages.get(i);
                ++i;
            }
            return str_pages;
        }
    }

    public class Variable {
        public String variable_name = "";
        public String label = "";
        public String data_type = "";
        public String length = "";
        public String sig_digits = "";
        public Origin origin;
        public String mandatory;
        public String evaluator;

        public Variable() {
            this.origin = new Origin();
            this.mandatory = "";
            this.evaluator = "";
        }
    }
}

