/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.gui;

import com.fujitsu.tsc.desktop.gui.FilePathTransferHandler;
import com.fujitsu.tsc.desktop.gui.GuiConstants;
import com.fujitsu.tsc.desktop.gui.GuiMain;
import com.fujitsu.tsc.desktop.gui.XmlValidationAppender;
import com.fujitsu.tsc.desktop.importer.Importer;
import com.fujitsu.tsc.desktop.importer.NotOidConnectException;
import com.fujitsu.tsc.desktop.util.Config;
import com.fujitsu.tsc.desktop.util.ErrorInfo;
import com.fujitsu.tsc.desktop.validator.ValidationResult;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class DefineImportPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
    private Config config;
    private GuiMain parent;
    private Font titleFont;
    private Font defaultFont;
    private Font submitFont;
    private JPanel headerPanel;
    private JLabel titleL;
    private JPanel bodyPanel;
    private JLabel defineVersionL;
    protected JComboBox<String> defineVersionCB;
    private JLabel datasetTypeL;
    protected JComboBox<String> datasetTypeCB;
    protected JCheckBox includeResultMetadataCB;
    protected JComboBox<String> xmlEncodingCB;
    protected JTextField stylesheetLocationTF;
    private JLabel dataSourceLocationL;
    protected JTextField dataSourceLocationTF;
    private JLabel outputLocationL;
    protected JTextField outputLocationTF;
    protected JTextField schema1SourceLocationTF;
    protected JTextField schema2SourceLocationTF;
    private JButton browseButton1;
    private JButton clearButton1;
    private JButton browseButton2;
    private JButton clearButton2;
    protected JFileChooser fileChooser1;
    private FileNameExtensionFilter filter1;
    protected JFileChooser fileChooser2;
    protected JFileChooser fileChooser3;
    protected JFileChooser fileChooser4;
    private JPanel footerPanel;
    private JButton runButton;

    public DefineImportPanel(GuiMain parent, Config config) {
        this.config = config;
        this.parent = parent;
        this.titleFont = new Font(GuiConstants.FONT_NAME_TITLE, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE_TITLE);
        this.defaultFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE, GuiConstants.FONT_SIZE);
        this.submitFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE);
        this.setBackground(GuiConstants.COLOR_BORDER);
        this.initHeaderPanel();
        this.initBodyPanel();
        this.initFooterPanel();
        GroupLayout panelLayout = new GroupLayout(this);
        this.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerPanel, -2, -1, Short.MAX_VALUE).addComponent(this.bodyPanel, -2, -1, Short.MAX_VALUE).addComponent(this.footerPanel, -2, -1, Short.MAX_VALUE));
        panelLayout.setVerticalGroup(panelLayout.createSequentialGroup().addGap(GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK).addComponent(this.headerPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.bodyPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.footerPanel, -2, -1, -2));
    }

    private void initHeaderPanel() {
        this.headerPanel = new JPanel();
        this.headerPanel.setBackground(GuiConstants.COLOR_BG);
        this.titleL = new JLabel("Convert from Define-XML to Excel");
        this.titleL.setFont(this.titleFont);
        this.titleL.setForeground(GuiConstants.FONT_COLOR_TITLE);
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        headerPanelLayout.setAutoCreateContainerGaps(true);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, Short.MAX_VALUE));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, -2));
    }

    private void initBodyPanel() {
        this.bodyPanel = new JPanel();
        this.bodyPanel.setBackground(GuiConstants.COLOR_BG);
        this.defineVersionL = new JLabel("Define-XML Version");
        this.defineVersionCB = new JComboBox();
        this.datasetTypeL = new JLabel("Dataset Type:");
        this.datasetTypeCB = new JComboBox();
        this.dataSourceLocationL = new JLabel("Data Source Location (.xml):");
        this.dataSourceLocationTF = new JTextField("");
        this.outputLocationL = new JLabel("Output Location:");
        this.outputLocationTF = new JTextField("");
        this.browseButton1 = new JButton("Browse");
        this.clearButton1 = new JButton("Clear");
        this.browseButton2 = new JButton("Browse");
        this.clearButton2 = new JButton("Clear");
        this.fileChooser1 = new JFileChooser();
        this.filter1 = new FileNameExtensionFilter("XML (.xml)", "xml");
        this.fileChooser1.setFileFilter(this.filter1);
        this.dataSourceLocationTF.setTransferHandler(new FilePathTransferHandler(this.dataSourceLocationTF, this.fileChooser1, this.filter1));
        this.fileChooser2 = new JFileChooser();
        this.fileChooser2.setFileSelectionMode(1);
        this.outputLocationTF.setTransferHandler(new FilePathTransferHandler(this.outputLocationTF, this.fileChooser2));
        this.browseButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = DefineImportPanel.this.fileChooser1.showOpenDialog(DefineImportPanel.this);
                if (selected == 0) {
                    DefineImportPanel.this.dataSourceLocationTF.setText(DefineImportPanel.this.fileChooser1.getSelectedFile().getPath());
                } else if (selected != 1) {
                    // empty if block
                }
            }
        });
        this.clearButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefineImportPanel.this.dataSourceLocationTF.setText("");
            }
        });
        this.browseButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = DefineImportPanel.this.fileChooser2.showOpenDialog(DefineImportPanel.this);
                if (selected == 0) {
                    DefineImportPanel.this.outputLocationTF.setText(String.valueOf(DefineImportPanel.this.fileChooser2.getSelectedFile().getPath()) + System.getProperty("file.separator") + GuiConstants.EXCEL_FILE_NAME);
                } else if (selected != 1) {
                    // empty if block
                }
            }
        });
        this.clearButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefineImportPanel.this.outputLocationTF.setText("");
            }
        });
        this.defineVersionL.setFont(this.defaultFont);
        this.defineVersionCB.setFont(this.defaultFont);
        this.defineVersionCB.setModel(new DefaultComboBoxModel<String>(Config.DEFINE_VERSIONS));
        this.datasetTypeL.setFont(this.defaultFont);
        this.datasetTypeCB.setFont(this.defaultFont);
        this.datasetTypeCB.setModel(new DefaultComboBoxModel<String>(Config.DatasetType.stringValues()));
        this.dataSourceLocationL.setFont(this.defaultFont);
        this.dataSourceLocationTF.setEditable(false);
        this.outputLocationL.setFont(this.defaultFont);
        this.outputLocationTF.setForeground(GuiConstants.FONT_COLOR_ON_WHITE);
        this.browseButton1.setFont(this.defaultFont);
        this.clearButton1.setFont(this.defaultFont);
        this.browseButton2.setFont(this.defaultFont);
        this.clearButton2.setFont(this.defaultFont);
        this.defineVersionCB.setSelectedItem(this.config.d2eDefineVersion);
        this.datasetTypeCB.setSelectedItem(this.config.d2eDatasetType);
        this.dataSourceLocationTF.setText(this.config.d2eDataSourceLocation);
        this.outputLocationTF.setText(this.config.d2eOutputLocation);
        GroupLayout bodyPanelLayout = new GroupLayout(this.bodyPanel);
        this.bodyPanel.setLayout(bodyPanelLayout);
        bodyPanelLayout.setHorizontalGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bodyPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.CONFIG_GAP_LEFT, GuiConstants.CONFIG_GAP_LEFT).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defineVersionL).addComponent(this.datasetTypeL).addComponent(this.dataSourceLocationL).addComponent(this.outputLocationL)).addGap(GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defineVersionCB, -2, 160, -2).addComponent(this.datasetTypeCB, -2, 160, -2).addComponent(this.dataSourceLocationTF, -1, 255, Short.MAX_VALUE).addComponent(this.outputLocationTF, -1, 255, Short.MAX_VALUE)).addGap(GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browseButton1).addComponent(this.browseButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.clearButton1).addComponent(this.clearButton2)).addContainerGap(GuiConstants.CONFIG_GAP_RIGHT, GuiConstants.CONFIG_GAP_RIGHT)));
        bodyPanelLayout.setVerticalGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bodyPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.CONFIG_GAP_TOP, GuiConstants.CONFIG_GAP_TOP).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defineVersionL).addComponent(this.defineVersionCB, -2, -1, -2)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.datasetTypeL).addComponent(this.datasetTypeCB, -2, -1, -2)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataSourceLocationL).addComponent(this.dataSourceLocationTF, -2, -1, -2).addComponent(this.browseButton1).addComponent(this.clearButton1)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputLocationL).addComponent(this.outputLocationTF, -2, -1, -2).addComponent(this.browseButton2).addComponent(this.clearButton2)).addContainerGap(GuiConstants.CONFIG_GAP_BOTTOM, GuiConstants.CONFIG_GAP_BOTTOM)));
    }

    private void initFooterPanel() {
        this.footerPanel = new JPanel();
        this.footerPanel.setBackground(GuiConstants.COLOR_BG);
        this.runButton = new JButton("Import");
        this.runButton.setFont(this.submitFont);
        this.runButton.setForeground(GuiConstants.COLOR_BTN_FG_SUBMIT);
        this.runButton.setBackground(GuiConstants.COLOR_BTN_BG_SUBMIT);
        this.runButton.setActionCommand("Import");
        this.runButton.addActionListener(this);
        GroupLayout footerPanelLayout = new GroupLayout(this.footerPanel);
        footerPanelLayout.setAutoCreateContainerGaps(true);
        this.footerPanel.setLayout(footerPanelLayout);
        footerPanelLayout.setHorizontalGroup(footerPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.FOOTER_GAP_LEFT, Short.MAX_VALUE).addComponent(this.runButton));
        footerPanelLayout.setVerticalGroup(footerPanelLayout.createSequentialGroup().addComponent(this.runButton).addContainerGap(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    public String validateEntry() {
        if (this.defineVersionCB.getSelectedItem() == null) {
            return "Define-XML Version cannot be blank.";
        }
        if (this.datasetTypeCB.getSelectedItem() == null) {
            return "Dataset Type cannot be blank.";
        }
        if (StringUtils.isEmpty((CharSequence)this.dataSourceLocationTF.getText())) {
            return "Data Source Location (.xml) cannot be blank.";
        }
        if (StringUtils.isEmpty((CharSequence)this.outputLocationTF.getText())) {
            return "Output Location cannot be blank.";
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Import".equals(command)) {
            String errMessage = this.validateEntry();
            if (StringUtils.isEmpty((CharSequence)errMessage)) {
                this.parent.showPanel(this.parent.defineImportResultPanel);
                Runnable runDefineImport = new Runnable(){

                    /*
                     * Unable to fully structure code
                     */
                    @Override
                    public void run() {
                        block9: {
                            appender = new XmlValidationAppender(DefineImportPanel.access$0((DefineImportPanel)DefineImportPanel.this).defineImportResultPanel.iResultTable);
                            appender.clear();
                            DefineImportPanel.access$0((DefineImportPanel)DefineImportPanel.this).defineImportResultPanel.outputLocationUrl.setText(null);
                            DefineImportPanel.access$1((DefineImportPanel)DefineImportPanel.this).d2eDefineVersion = DefineImportPanel.this.defineVersionCB.getSelectedItem().toString();
                            DefineImportPanel.access$1((DefineImportPanel)DefineImportPanel.this).d2eDatasetType = DefineImportPanel.this.datasetTypeCB.getSelectedItem().toString();
                            DefineImportPanel.access$1((DefineImportPanel)DefineImportPanel.this).d2eDataSourceLocation = DefineImportPanel.this.dataSourceLocationTF.getText();
                            DefineImportPanel.access$1((DefineImportPanel)DefineImportPanel.this).d2eOutputLocation = DefineImportPanel.this.outputLocationTF.getText();
                            error1 = new ValidationResult();
                            error2 = new ValidationResult();
                            importer = null;
                            try {
                                importer = new Importer(DefineImportPanel.access$1(DefineImportPanel.this));
                                error1 = importer.validateHard();
                                if (!error1.getResult()) {
                                    for (ErrorInfo ex : error1.getErrors()) {
                                        appender.writeNext(ex);
                                    }
                                    appender.writeMessage(0);
                                } else {
                                    appender.writeMessage(1);
                                    error2 = importer.validateSoft();
                                    importer.writeExcelGui(error2);
                                    if (error2.getErrors().size() != 0) {
                                        for (ErrorInfo ex2 : error2.getErrors()) {
                                            appender.writeNext(ex2);
                                        }
                                        appender.writeMessage(2);
                                    } else {
                                        appender.writeMessage(3);
                                    }
                                    DefineImportPanel.access$0((DefineImportPanel)DefineImportPanel.this).defineImportResultPanel.outputLocationUrl.setText(new File(DefineImportPanel.this.outputLocationTF.getText()).getCanonicalPath());
                                }
                                break block9;
                            }
                            catch (NotOidConnectException | IOException | ParserConfigurationException | SAXException ex) {
                                DefineImportPanel.access$2().error((Object)ex.getMessage());
                                var9_11 = ex.getStackTrace();
                                var8_12 = var9_11.length;
                                var7_13 = 0;
                                ** while (var7_13 < var8_12)
                            }
lbl-1000:
                            // 1 sources

                            {
                                e = var9_11[var7_13];
                                DefineImportPanel.access$2().error((Object)e.toString());
                                ++var7_13;
                                continue;
                            }
lbl42:
                            // 1 sources

                            ex.printStackTrace();
                            appender.writeErrorMessage(ex.getMessage());
                        }
                    }
                };
                new Thread(runDefineImport).start();
            } else {
                Object[] options = new String[]{"OK"};
                JLabel errMessageL = new JLabel(errMessage);
                errMessageL.setFont(this.defaultFont);
                JOptionPane.showOptionDialog(this.parent, errMessageL, "Message", -1, 2, null, options, "OK");
            }
        }
    }

    static /* synthetic */ GuiMain access$0(DefineImportPanel defineImportPanel) {
        return defineImportPanel.parent;
    }

    static /* synthetic */ Config access$1(DefineImportPanel defineImportPanel) {
        return defineImportPanel.config;
    }

    static /* synthetic */ Logger access$2() {
        return logger;
    }
}

