/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.gui;

import com.fujitsu.tsc.desktop.gui.EditorPaneAppender;
import com.fujitsu.tsc.desktop.gui.FilePathTransferHandler;
import com.fujitsu.tsc.desktop.gui.GuiConstants;
import com.fujitsu.tsc.desktop.gui.GuiMain;
import com.fujitsu.tsc.desktop.importer.EdtSpecCreator;
import com.fujitsu.tsc.desktop.importer.ExcelWriter2;
import com.fujitsu.tsc.desktop.util.Config;
import com.opencsv.exceptions.CsvException;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class EdtSpecCreatePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
    private GuiMain parent;
    private Font titleFont;
    private Font defaultFont;
    private Font submitFont;
    private JPanel headerPanel;
    private JLabel titleL;
    private JPanel bodyPanel;
    private JLabel edtTypeL;
    protected JComboBox<String> edtTypeCB;
    private JLabel headerCntL;
    protected JTextField headerCntTF;
    private JLabel encodingL;
    protected JComboBox<String> encodingCB;
    private JLabel delimitedOrFixedL;
    protected JComboBox<String> delimitedOrFixedCB;
    private JLabel delimiterL;
    protected JTextField delimiterTF;
    private JLabel textQualifierL;
    protected JComboBox<String> textQualifierCB;
    private JLabel dataSourceLocationL;
    protected JTextField dataSourceLocationTF;
    private JLabel outputLocationL;
    protected JTextField outputLocationTF;
    private JButton browseButton1;
    private JButton clearButton1;
    private JButton browseButton2;
    private JButton clearButton2;
    protected JFileChooser fileChooser1;
    protected JFileChooser fileChooser2;
    private JPanel footerPanel;
    private JButton runButton;

    public EdtSpecCreatePanel(GuiMain parent, Config config) {
        this.parent = parent;
        this.titleFont = new Font(GuiConstants.FONT_NAME_TITLE, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE_TITLE);
        this.defaultFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE, GuiConstants.FONT_SIZE);
        this.submitFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE);
        this.setBackground(GuiConstants.COLOR_BORDER);
        this.initHeaderPanel();
        this.initBodyPanel(config);
        this.initFooterPanel();
        GroupLayout panelLayout = new GroupLayout(this);
        this.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerPanel, -2, -1, Short.MAX_VALUE).addComponent(this.bodyPanel, -2, -1, Short.MAX_VALUE).addComponent(this.footerPanel, -2, -1, Short.MAX_VALUE));
        panelLayout.setVerticalGroup(panelLayout.createSequentialGroup().addGap(GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK).addComponent(this.headerPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.bodyPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.footerPanel, -2, -1, -2));
    }

    private void initHeaderPanel() {
        this.headerPanel = new JPanel();
        this.headerPanel.setBackground(GuiConstants.COLOR_BG);
        this.titleL = new JLabel("Create eDT Spec from Datasets");
        this.titleL.setFont(this.titleFont);
        this.titleL.setForeground(GuiConstants.FONT_COLOR_TITLE);
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        headerPanelLayout.setAutoCreateContainerGaps(true);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, Short.MAX_VALUE));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, -2));
    }

    private void initBodyPanel(Config config) {
        this.bodyPanel = new JPanel();
        this.bodyPanel.setBackground(GuiConstants.COLOR_BG);
        this.edtTypeL = new JLabel("Type:");
        this.edtTypeCB = new JComboBox<String>(Config.EDT_TYPE);
        this.headerCntL = new JLabel("# of Header Lines:");
        this.headerCntTF = new JTextField("");
        this.encodingL = new JLabel("Character Encoding:");
        this.encodingCB = new JComboBox<String>(Config.ENCODING);
        this.delimitedOrFixedL = new JLabel("Delimited/Fixed Width:");
        this.delimitedOrFixedCB = new JComboBox<String>(Config.DELIMITED_FIXED);
        this.delimiterL = new JLabel("Delimiter:");
        this.delimiterTF = new JTextField("");
        this.textQualifierL = new JLabel("Text Qualifier:");
        this.textQualifierCB = new JComboBox<String>(Config.TEXT_QUALIFIER);
        this.dataSourceLocationL = new JLabel("Data Source Location:");
        this.dataSourceLocationTF = new JTextField("");
        this.dataSourceLocationTF.setEditable(false);
        this.outputLocationL = new JLabel("Output Location:");
        this.outputLocationTF = new JTextField("");
        this.browseButton1 = new JButton("Browse");
        this.clearButton1 = new JButton("Clear");
        this.browseButton2 = new JButton("Browse");
        this.clearButton2 = new JButton("Clear");
        this.fileChooser1 = new JFileChooser();
        this.dataSourceLocationTF.setTransferHandler(new FilePathTransferHandler(this.dataSourceLocationTF, this.fileChooser1));
        this.fileChooser2 = new JFileChooser();
        this.fileChooser2.setFileSelectionMode(1);
        this.outputLocationTF.setTransferHandler(new FilePathTransferHandler(this.outputLocationTF, this.fileChooser2));
        this.browseButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = EdtSpecCreatePanel.this.fileChooser1.showOpenDialog(EdtSpecCreatePanel.this);
                if (selected == 0) {
                    EdtSpecCreatePanel.this.dataSourceLocationTF.setText(EdtSpecCreatePanel.this.fileChooser1.getSelectedFile().getPath());
                } else if (selected != 1) {
                    // empty if block
                }
            }
        });
        this.clearButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdtSpecCreatePanel.this.dataSourceLocationTF.setText("");
            }
        });
        this.browseButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = EdtSpecCreatePanel.this.fileChooser2.showOpenDialog(EdtSpecCreatePanel.this);
                if (selected == 0) {
                    EdtSpecCreatePanel.this.outputLocationTF.setText(String.valueOf(EdtSpecCreatePanel.this.fileChooser2.getSelectedFile().getPath()) + System.getProperty("file.separator") + GuiConstants.EDT_EXCEL_FILE_NAME);
                } else if (selected != 1) {
                    // empty if block
                }
            }
        });
        this.clearButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdtSpecCreatePanel.this.outputLocationTF.setText("");
            }
        });
        this.edtTypeL.setFont(this.defaultFont);
        this.edtTypeCB.setFont(this.defaultFont);
        this.headerCntL.setFont(this.defaultFont);
        this.headerCntTF.setFont(this.defaultFont);
        this.encodingL.setFont(this.defaultFont);
        this.encodingCB.setFont(this.defaultFont);
        this.delimitedOrFixedL.setFont(this.defaultFont);
        this.delimitedOrFixedCB.setFont(this.defaultFont);
        this.delimiterL.setFont(this.defaultFont);
        this.delimiterTF.setFont(this.defaultFont);
        this.textQualifierL.setFont(this.defaultFont);
        this.textQualifierCB.setFont(this.defaultFont);
        this.dataSourceLocationL.setFont(this.defaultFont);
        this.dataSourceLocationTF.setEditable(false);
        this.outputLocationL.setFont(this.defaultFont);
        this.outputLocationTF.setForeground(GuiConstants.FONT_COLOR_ON_WHITE);
        this.browseButton1.setFont(this.defaultFont);
        this.clearButton1.setFont(this.defaultFont);
        this.browseButton2.setFont(this.defaultFont);
        this.clearButton2.setFont(this.defaultFont);
        this.edtTypeCB.setSelectedItem(config.edtType);
        this.headerCntTF.setText(config.edtHeaderCnt);
        this.encodingCB.setSelectedItem(config.edtEncoding);
        this.delimitedOrFixedCB.setSelectedItem(config.edtDelimitedOrFixed);
        this.delimiterTF.setText(config.edtDelimiter);
        this.textQualifierCB.setSelectedItem(config.edtTextQualifier);
        this.dataSourceLocationTF.setText(config.edtDataSourceLocation);
        this.outputLocationTF.setText(config.edtOutputLocation);
        GroupLayout bodyPanelLayout = new GroupLayout(this.bodyPanel);
        this.bodyPanel.setLayout(bodyPanelLayout);
        bodyPanelLayout.setHorizontalGroup(bodyPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.BODY_GAP_LEFT, GuiConstants.BODY_GAP_LEFT).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.edtTypeL).addComponent(this.headerCntL).addComponent(this.encodingL).addComponent(this.delimitedOrFixedL).addComponent(this.delimiterL).addComponent(this.textQualifierL).addComponent(this.dataSourceLocationL).addComponent(this.outputLocationL)).addGap(GuiConstants.BODY_GAP_HORIZONTAL, GuiConstants.BODY_GAP_HORIZONTAL, GuiConstants.BODY_GAP_HORIZONTAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.edtTypeCB, -2, 255, -2).addComponent(this.headerCntTF, -2, 255, -2).addComponent(this.encodingCB, -2, 255, -2).addComponent(this.delimitedOrFixedCB, -2, 255, -2).addComponent(this.delimiterTF, -2, 255, -2).addComponent(this.textQualifierCB, -2, 255, -2).addComponent(this.dataSourceLocationTF, -1, 255, Short.MAX_VALUE).addComponent(this.outputLocationTF, -1, 255, Short.MAX_VALUE)).addGap(GuiConstants.BODY_GAP_HORIZONTAL, GuiConstants.BODY_GAP_HORIZONTAL, GuiConstants.BODY_GAP_HORIZONTAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browseButton1).addComponent(this.browseButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.clearButton1).addComponent(this.clearButton2)).addContainerGap(GuiConstants.BODY_GAP_RIGHT, GuiConstants.BODY_GAP_RIGHT));
        bodyPanelLayout.setVerticalGroup(bodyPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.BODY_GAP_TOP, GuiConstants.BODY_GAP_TOP).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.edtTypeL).addComponent(this.edtTypeCB, -2, -1, -2)).addGap(GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.headerCntL).addComponent(this.headerCntTF, -2, -1, -2)).addGap(GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.encodingL).addComponent(this.encodingCB, -2, -1, -2)).addGap(GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.delimitedOrFixedL).addComponent(this.delimitedOrFixedCB, -2, -1, -2)).addGap(GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.delimiterL).addComponent(this.delimiterTF, -2, -1, -2)).addGap(GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textQualifierL).addComponent(this.textQualifierCB, -2, -1, -2)).addGap(GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataSourceLocationL).addComponent(this.dataSourceLocationTF, -2, -1, -2).addComponent(this.browseButton1).addComponent(this.clearButton1)).addGap(GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL, GuiConstants.BODY_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputLocationL).addComponent(this.outputLocationTF, -2, -1, -2).addComponent(this.browseButton2).addComponent(this.clearButton2)).addContainerGap(GuiConstants.BODY_GAP_BOTTOM, GuiConstants.BODY_GAP_BOTTOM));
    }

    private void initFooterPanel() {
        this.footerPanel = new JPanel();
        this.footerPanel.setBackground(GuiConstants.COLOR_BG);
        this.runButton = new JButton("Create");
        this.runButton.setFont(this.submitFont);
        this.runButton.setForeground(GuiConstants.COLOR_BTN_FG_SUBMIT);
        this.runButton.setBackground(GuiConstants.COLOR_BTN_BG_SUBMIT);
        this.runButton.setActionCommand("Generate");
        this.runButton.addActionListener(this);
        GroupLayout footerPanelLayout = new GroupLayout(this.footerPanel);
        footerPanelLayout.setAutoCreateContainerGaps(true);
        this.footerPanel.setLayout(footerPanelLayout);
        footerPanelLayout.setHorizontalGroup(footerPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.FOOTER_GAP_LEFT, Short.MAX_VALUE).addComponent(this.runButton));
        footerPanelLayout.setVerticalGroup(footerPanelLayout.createSequentialGroup().addComponent(this.runButton).addContainerGap(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    public String validateEntry() {
        if (this.edtTypeCB.getSelectedItem() == null) {
            return "Type cannot be blank.";
        }
        if (NumberUtils.toInt((String)this.headerCntTF.getText(), (int)-1) < 0) {
            return "# of Header Lines must be 0 or a positive number.";
        }
        if (this.encodingCB.getSelectedItem() == null) {
            return "Character Encoding cannot be blank.";
        }
        if (this.delimitedOrFixedCB.getSelectedItem() == null) {
            return "Delimited/Fixed Width cannot be blank.";
        }
        if (StringUtils.length((CharSequence)this.delimiterTF.getText()) != 1 && !StringUtils.equals((CharSequence)this.delimiterTF.getText(), (CharSequence)"\\t")) {
            return "Delimiter must be a single character or a tab (\\t).";
        }
        if (this.textQualifierCB.getSelectedItem() == null) {
            return "Text Qualifier cannot be blank.";
        }
        if (StringUtils.isEmpty((CharSequence)this.dataSourceLocationTF.getText())) {
            return "Data Source Location cannot be blank.";
        }
        if (StringUtils.isEmpty((CharSequence)this.outputLocationTF.getText())) {
            return "Output Location cannot be blank.";
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Generate".equals(command)) {
            String errMessage = this.validateEntry();
            if (StringUtils.isEmpty((CharSequence)errMessage)) {
                this.parent.showPanel(this.parent.edtSpecCreateResultPanel);
                this.parent.edtSpecCreateResultPanel.clearBodyPanel();
                Runnable createEdtSpec = new Runnable(){

                    @Override
                    public void run() {
                        EditorPaneAppender epAppender = new EditorPaneAppender();
                        epAppender.setEditorPane(((EdtSpecCreatePanel)EdtSpecCreatePanel.this).parent.edtSpecCreateResultPanel.gResultEditorPane);
                        epAppender.setLayout((Layout)new PatternLayout("%-5p %c{2} - %m%n"));
                        logger.addAppender((Appender)epAppender);
                        logger.info((Object)"Creating eDT Spec...");
                        EdtSpecCreator.StudyEdtGeneral param = new EdtSpecCreator.StudyEdtGeneral();
                        param.type_id = EdtSpecCreatePanel.this.edtTypeCB.getSelectedItem().toString();
                        param.header_line = NumberUtils.toInt((String)EdtSpecCreatePanel.this.headerCntTF.getText());
                        param.encoding = EdtSpecCreatePanel.this.encodingCB.getSelectedItem().toString();
                        param.separating_method = EdtSpecCreatePanel.this.delimitedOrFixedCB.getSelectedItem().toString();
                        param.delimiter = EdtSpecCreatePanel.this.delimiterTF.getText();
                        param.text_qualifier = EdtSpecCreatePanel.this.textQualifierCB.getSelectedItem().toString();
                        File srcFile = new File(EdtSpecCreatePanel.this.dataSourceLocationTF.getText());
                        File outFile = new File(EdtSpecCreatePanel.this.outputLocationTF.getText());
                        EdtSpecCreator creator = new EdtSpecCreator(param, srcFile);
                        try {
                            try {
                                Pair<List<EdtSpecCreator.StudyEdtColumn>, List<EdtSpecCreator.StudyEdtCodelist>> rtn = creator.create();
                                ExcelWriter2 excelWriter = new ExcelWriter2();
                                excelWriter.addData("GENERAL", param, EdtSpecCreator.StudyEdtGeneral.class);
                                excelWriter.addData("COLUMN", (List)rtn.getLeft(), EdtSpecCreator.StudyEdtColumn.class);
                                excelWriter.addData("CODELIST", (List)rtn.getRight(), EdtSpecCreator.StudyEdtCodelist.class);
                                excelWriter.writeout(outFile);
                                logger.info((Object)"Done.");
                                ((EdtSpecCreatePanel)EdtSpecCreatePanel.this).parent.edtSpecCreateResultPanel.outputLocationUrl.setText(new File(EdtSpecCreatePanel.this.outputLocationTF.getText()).getCanonicalPath());
                            }
                            catch (CsvException | IOException | IllegalAccessException | IllegalArgumentException e1) {
                                logger.error((Object)e1.getMessage());
                                logger.removeAppender((Appender)epAppender);
                            }
                        }
                        finally {
                            logger.removeAppender((Appender)epAppender);
                        }
                    }
                };
                new Thread(createEdtSpec).start();
            } else {
                Object[] options = new String[]{"OK"};
                JLabel errMessageL = new JLabel(errMessage);
                errMessageL.setFont(this.defaultFont);
                JOptionPane.showOptionDialog(this.parent, errMessageL, "Message", -1, 2, null, options, "OK");
            }
        }
    }
}

