/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.gui;

import com.fujitsu.tsc.desktop.exporter.InvalidOidSyntaxException;
import com.fujitsu.tsc.desktop.exporter.RequiredValueMissingException;
import com.fujitsu.tsc.desktop.exporter.TableNotFoundException;
import com.fujitsu.tsc.desktop.exporter.XmlGenerator;
import com.fujitsu.tsc.desktop.gui.EditorPaneAppender;
import com.fujitsu.tsc.desktop.gui.FilePathTransferHandler;
import com.fujitsu.tsc.desktop.gui.GuiConstants;
import com.fujitsu.tsc.desktop.gui.GuiMain;
import com.fujitsu.tsc.desktop.util.Config;
import com.fujitsu.tsc.desktop.util.InvalidParameterException;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class OdmExportPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
    private Config config;
    private GuiMain parent;
    private Font titleFont;
    private Font defaultFont;
    private Font submitFont;
    private JPanel headerPanel;
    private JLabel titleL;
    private JPanel bodyPanel;
    private JLabel odmVersionL;
    protected JComboBox odmVersionCB;
    private JLabel xmlEncodingL;
    protected JComboBox xmlEncodingCB;
    private JLabel stylesheetLocationL;
    protected JTextField stylesheetLocationTF;
    private JLabel dataSourceLocationL;
    protected JTextField dataSourceLocationTF;
    private JLabel outputLocationL;
    protected JTextField outputLocationTF;
    private JButton browseButton1;
    private JButton clearButton1;
    private JButton browseButton2;
    private JButton clearButton2;
    protected JFileChooser fileChooser1;
    private FileNameExtensionFilter filter1;
    protected JFileChooser fileChooser2;
    private JPanel footerPanel;
    private JButton runButton;

    public OdmExportPanel(GuiMain parent, Config config) {
        this.config = config;
        this.parent = parent;
        this.titleFont = new Font(GuiConstants.FONT_NAME_TITLE, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE_TITLE);
        this.defaultFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE, GuiConstants.FONT_SIZE);
        this.submitFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE);
        this.setBackground(GuiConstants.COLOR_BORDER);
        this.initHeaderPanel();
        this.initBodyPanel();
        this.initFooterPanel();
        GroupLayout panelLayout = new GroupLayout(this);
        this.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerPanel, -2, -1, Short.MAX_VALUE).addComponent(this.bodyPanel, -2, -1, Short.MAX_VALUE).addComponent(this.footerPanel, -2, -1, Short.MAX_VALUE));
        panelLayout.setVerticalGroup(panelLayout.createSequentialGroup().addGap(GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK).addComponent(this.headerPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.bodyPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.footerPanel, -2, -1, -2));
    }

    private void initHeaderPanel() {
        this.headerPanel = new JPanel();
        this.headerPanel.setBackground(GuiConstants.COLOR_BG);
        this.titleL = new JLabel("Convert from Excel to ODM-XML");
        this.titleL.setFont(this.titleFont);
        this.titleL.setForeground(GuiConstants.FONT_COLOR_TITLE);
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        headerPanelLayout.setAutoCreateContainerGaps(true);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, Short.MAX_VALUE));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, -2));
    }

    private void initBodyPanel() {
        this.bodyPanel = new JPanel();
        this.bodyPanel.setBackground(GuiConstants.COLOR_BG);
        this.odmVersionL = new JLabel("ODM Version:");
        this.odmVersionCB = new JComboBox<String>(Config.ODM_VERSIONS);
        this.xmlEncodingL = new JLabel("XML Encoding:");
        this.xmlEncodingCB = new JComboBox<String>(Config.ENCODING);
        this.stylesheetLocationL = new JLabel("Stylesheet Location (.xsl):");
        this.stylesheetLocationTF = new JTextField("");
        this.dataSourceLocationL = new JLabel("Data Source Location:");
        this.dataSourceLocationTF = new JTextField("");
        this.outputLocationL = new JLabel("Output Location:");
        this.outputLocationTF = new JTextField("");
        this.browseButton1 = new JButton("Browse");
        this.clearButton1 = new JButton("Clear");
        this.browseButton2 = new JButton("Browse");
        this.clearButton2 = new JButton("Clear");
        this.fileChooser1 = new JFileChooser();
        this.filter1 = new FileNameExtensionFilter("EXCEL (.xlsx)", "xlsx");
        this.fileChooser1.setFileFilter(this.filter1);
        this.dataSourceLocationTF.setTransferHandler(new FilePathTransferHandler(this.dataSourceLocationTF, this.fileChooser1, this.filter1));
        this.fileChooser2 = new JFileChooser();
        this.fileChooser2.setFileSelectionMode(1);
        this.outputLocationTF.setTransferHandler(new FilePathTransferHandler(this.outputLocationTF, this.fileChooser2));
        this.browseButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = OdmExportPanel.this.fileChooser1.showOpenDialog(OdmExportPanel.this);
                if (selected == 0) {
                    OdmExportPanel.this.dataSourceLocationTF.setText(OdmExportPanel.this.fileChooser1.getSelectedFile().getPath());
                } else if (selected != 1) {
                    // empty if block
                }
            }
        });
        this.clearButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OdmExportPanel.this.dataSourceLocationTF.setText("");
            }
        });
        this.browseButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = OdmExportPanel.this.fileChooser2.showOpenDialog(OdmExportPanel.this);
                if (selected == 0) {
                    OdmExportPanel.this.outputLocationTF.setText(String.valueOf(OdmExportPanel.this.fileChooser2.getSelectedFile().getPath()) + System.getProperty("file.separator") + GuiConstants.ODM_FILE_NAME);
                } else if (selected != 1) {
                    // empty if block
                }
            }
        });
        this.clearButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OdmExportPanel.this.outputLocationTF.setText("");
            }
        });
        this.odmVersionL.setFont(this.defaultFont);
        this.odmVersionCB.setFont(this.defaultFont);
        this.xmlEncodingL.setFont(this.defaultFont);
        this.xmlEncodingCB.setFont(this.defaultFont);
        this.stylesheetLocationL.setFont(this.defaultFont);
        this.stylesheetLocationTF.setForeground(GuiConstants.FONT_COLOR_ON_WHITE);
        this.dataSourceLocationL.setFont(this.defaultFont);
        this.dataSourceLocationTF.setEditable(false);
        this.outputLocationL.setFont(this.defaultFont);
        this.outputLocationTF.setForeground(GuiConstants.FONT_COLOR_ON_WHITE);
        this.browseButton1.setFont(this.defaultFont);
        this.clearButton1.setFont(this.defaultFont);
        this.browseButton2.setFont(this.defaultFont);
        this.clearButton2.setFont(this.defaultFont);
        this.odmVersionCB.setSelectedItem(this.config.e2oOdmVersion);
        this.xmlEncodingCB.setSelectedItem(this.config.e2oXmlEncoding);
        this.stylesheetLocationTF.setText(this.config.e2oStylesheetLocation);
        this.dataSourceLocationTF.setText(this.config.e2oDataSourceLocation);
        this.outputLocationTF.setText(this.config.e2oOutputLocation);
        GroupLayout bodyPanelLayout = new GroupLayout(this.bodyPanel);
        this.bodyPanel.setLayout(bodyPanelLayout);
        bodyPanelLayout.setHorizontalGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bodyPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.CONFIG_GAP_LEFT, GuiConstants.CONFIG_GAP_LEFT).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.odmVersionL).addComponent(this.xmlEncodingL).addComponent(this.stylesheetLocationL).addComponent(this.dataSourceLocationL).addComponent(this.outputLocationL)).addGap(GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.odmVersionCB, -2, 160, -2).addComponent(this.xmlEncodingCB, -2, 160, -2).addComponent(this.stylesheetLocationTF, -1, 255, Short.MAX_VALUE).addComponent(this.dataSourceLocationTF, -1, 255, Short.MAX_VALUE).addComponent(this.outputLocationTF, -1, 255, Short.MAX_VALUE)).addGap(GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL, GuiConstants.CONFIG_GAP_HORIZONTAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browseButton1).addComponent(this.browseButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.clearButton1).addComponent(this.clearButton2)).addContainerGap(GuiConstants.CONFIG_GAP_RIGHT, GuiConstants.CONFIG_GAP_RIGHT)));
        bodyPanelLayout.setVerticalGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bodyPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.CONFIG_GAP_TOP, GuiConstants.CONFIG_GAP_TOP).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.odmVersionL).addComponent(this.odmVersionCB, -2, -1, -2)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.xmlEncodingL).addComponent(this.xmlEncodingCB, -2, -1, -2)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stylesheetLocationL).addComponent(this.stylesheetLocationTF, -2, -1, -2)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataSourceLocationL).addComponent(this.dataSourceLocationTF, -2, -1, -2).addComponent(this.browseButton1).addComponent(this.clearButton1)).addGap(GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL, GuiConstants.CONFIG_GAP_VERTICAL).addGroup(bodyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputLocationL).addComponent(this.outputLocationTF, -2, -1, -2).addComponent(this.browseButton2).addComponent(this.clearButton2)).addContainerGap(GuiConstants.CONFIG_GAP_BOTTOM, GuiConstants.CONFIG_GAP_BOTTOM)));
    }

    private void initFooterPanel() {
        this.footerPanel = new JPanel();
        this.footerPanel.setBackground(GuiConstants.COLOR_BG);
        this.runButton = new JButton("Generate");
        this.runButton.setFont(this.submitFont);
        this.runButton.setForeground(GuiConstants.COLOR_BTN_FG_SUBMIT);
        this.runButton.setBackground(GuiConstants.COLOR_BTN_BG_SUBMIT);
        this.runButton.setActionCommand("Generate");
        this.runButton.addActionListener(this);
        GroupLayout footerPanelLayout = new GroupLayout(this.footerPanel);
        footerPanelLayout.setAutoCreateContainerGaps(true);
        this.footerPanel.setLayout(footerPanelLayout);
        footerPanelLayout.setHorizontalGroup(footerPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.FOOTER_GAP_LEFT, Short.MAX_VALUE).addComponent(this.runButton));
        footerPanelLayout.setVerticalGroup(footerPanelLayout.createSequentialGroup().addComponent(this.runButton).addContainerGap(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    public String validateEntry() {
        if (this.odmVersionCB.getSelectedItem() == null) {
            return "ODM Version cannot be blank.";
        }
        if (this.xmlEncodingCB.getSelectedItem() == null) {
            return "XML Encoding cannot be blank.";
        }
        if (StringUtils.isEmpty((CharSequence)this.dataSourceLocationTF.getText())) {
            return "Data Source Location cannot be blank.";
        }
        if (StringUtils.isEmpty((CharSequence)this.outputLocationTF.getText())) {
            return "Output Location cannot be blank.";
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Generate".equals(command)) {
            String errMessage = this.validateEntry();
            if (StringUtils.isEmpty((CharSequence)errMessage)) {
                this.parent.showPanel(this.parent.odmExportResultPanel);
                this.parent.odmExportResultPanel.clearBodyPanel();
                Runnable exportOdm = new Runnable(){

                    @Override
                    public void run() {
                        EditorPaneAppender epAppender = new EditorPaneAppender();
                        epAppender.setEditorPane(((OdmExportPanel)OdmExportPanel.this).parent.odmExportResultPanel.gResultEditorPane);
                        epAppender.setLayout((Layout)new PatternLayout("%-5p %c{2} - %m%n"));
                        logger.addAppender((Appender)epAppender);
                        try {
                            try {
                                ((OdmExportPanel)OdmExportPanel.this).config.e2oOdmVersion = OdmExportPanel.this.odmVersionCB.getSelectedItem().toString();
                                ((OdmExportPanel)OdmExportPanel.this).config.e2oXmlEncoding = OdmExportPanel.this.xmlEncodingCB.getSelectedItem().toString();
                                ((OdmExportPanel)OdmExportPanel.this).config.e2oStylesheetLocation = OdmExportPanel.this.stylesheetLocationTF.getText();
                                ((OdmExportPanel)OdmExportPanel.this).config.e2oDataSourceLocation = OdmExportPanel.this.dataSourceLocationTF.getText();
                                ((OdmExportPanel)OdmExportPanel.this).config.e2oOutputLocation = OdmExportPanel.this.outputLocationTF.getText();
                                XmlGenerator generator = new XmlGenerator(OdmExportPanel.this.config, Config.RunMode.GUI);
                                generator.generateOdmXml();
                                ((OdmExportPanel)OdmExportPanel.this).parent.odmExportResultPanel.outputLocationUrl.setText(new File(OdmExportPanel.this.outputLocationTF.getText()).getCanonicalPath());
                            }
                            catch (InvalidOidSyntaxException | RequiredValueMissingException | TableNotFoundException | InvalidParameterException | IOException | InvalidFormatException ex) {
                                logger.error((Object)ex.getMessage());
                                logger.removeAppender((Appender)epAppender);
                            }
                        }
                        finally {
                            logger.removeAppender((Appender)epAppender);
                        }
                    }
                };
                new Thread(exportOdm).start();
            } else {
                Object[] options = new String[]{"OK"};
                JLabel errMessageL = new JLabel(errMessage);
                errMessageL.setFont(this.defaultFont);
                JOptionPane.showOptionDialog(this.parent, errMessageL, "Message", -1, 2, null, options, "OK");
            }
        }
    }
}

