/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.gui;

import com.fujitsu.tsc.desktop.gui.GuiConstants;
import com.fujitsu.tsc.desktop.gui.GuiMain;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.apache.log4j.Logger;

public class OdmExportResultPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
    private GuiMain parent;
    private Font titleFont;
    private Font defaultFont;
    private JPanel headerPanel;
    private JLabel titleL;
    private JPanel bodyPanel;
    private JLabel gResultMessage;
    protected JScrollPane gResultScrollPane;
    protected JEditorPane gResultEditorPane;
    protected JLabel outputLocationL;
    protected JLabel outputLocationUrl;
    private JPanel footerPanel;
    private JButton backButton;

    public OdmExportResultPanel(GuiMain parent) {
        this.parent = parent;
        this.titleFont = new Font(GuiConstants.FONT_NAME_TITLE, GuiConstants.FONT_STYLE_TITLE, GuiConstants.FONT_SIZE_TITLE);
        this.defaultFont = new Font(GuiConstants.FONT_NAME, GuiConstants.FONT_STYLE, GuiConstants.FONT_SIZE);
        this.setBackground(GuiConstants.COLOR_BORDER);
        this.initHeaderPanel();
        this.initBodyPanel();
        this.initFooterPanel();
        GroupLayout panelLayout = new GroupLayout(this);
        this.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerPanel, -2, -1, Short.MAX_VALUE).addComponent(this.bodyPanel, -2, -1, Short.MAX_VALUE).addComponent(this.footerPanel, -2, -1, Short.MAX_VALUE));
        panelLayout.setVerticalGroup(panelLayout.createSequentialGroup().addGap(GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK, GuiConstants.BORDER_WIDTH_THICK).addComponent(this.headerPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.bodyPanel, -2, -1, -2).addGap(GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH, GuiConstants.BORDER_WIDTH).addComponent(this.footerPanel, -2, -1, -2));
    }

    private void initHeaderPanel() {
        this.headerPanel = new JPanel();
        this.headerPanel.setBackground(GuiConstants.COLOR_BG);
        this.titleL = new JLabel("Convert from Excel to ODM-XML");
        this.titleL.setFont(this.titleFont);
        this.titleL.setForeground(GuiConstants.FONT_COLOR_TITLE);
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        headerPanelLayout.setAutoCreateContainerGaps(true);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, Short.MAX_VALUE));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createSequentialGroup().addComponent(this.titleL, -2, -1, -2));
    }

    public void clearBodyPanel() {
        this.gResultEditorPane.setText("");
        this.outputLocationUrl.setText("");
    }

    private void initBodyPanel() {
        this.bodyPanel = new JPanel();
        this.bodyPanel.setBackground(GuiConstants.COLOR_BG);
        this.gResultScrollPane = new JScrollPane();
        this.gResultEditorPane = new JEditorPane();
        this.gResultScrollPane.setViewportView(this.gResultEditorPane);
        this.gResultScrollPane.setPreferredSize(new Dimension(GuiConstants.EDITOR_PANE_WIDTH, GuiConstants.EDITOR_PANE_HEIGHT));
        this.gResultMessage = new JLabel();
        this.gResultMessage.setFont(this.defaultFont);
        this.gResultMessage.setText("ODM Generator Log:");
        this.outputLocationL = new JLabel();
        this.outputLocationL.setFont(this.defaultFont);
        this.outputLocationL.setText("Output Folder: ");
        this.outputLocationUrl = new JLabel();
        this.outputLocationUrl.setForeground(Color.BLUE);
        this.outputLocationUrl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Desktop.isDesktopSupported() && OdmExportResultPanel.this.outputLocationUrl.getText() != null) {
                    try {
                        Desktop.getDesktop().open(new File(OdmExportResultPanel.this.outputLocationUrl.getText()));
                    }
                    catch (IOException ex) {
                        logger.error((Object)ex.getMessage());
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                OdmExportResultPanel.this.outputLocationUrl.setCursor(new Cursor(12));
            }
        });
        this.gResultEditorPane.setForeground(GuiConstants.FONT_COLOR_ON_WHITE);
        this.gResultEditorPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                OdmExportResultPanel.this.gResultScrollPane.getVerticalScrollBar().setValue(OdmExportResultPanel.this.gResultScrollPane.getVerticalScrollBar().getMaximum());
            }
        });
        GroupLayout layout = new GroupLayout(this.bodyPanel);
        this.bodyPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(GuiConstants.RESULT_GAP_LEFT, GuiConstants.RESULT_GAP_LEFT).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gResultMessage).addComponent(this.gResultScrollPane, -2, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.outputLocationL).addComponent(this.outputLocationUrl, -2, this.gResultScrollPane.getSize().width - this.outputLocationL.getSize().width, Short.MAX_VALUE))).addContainerGap(GuiConstants.RESULT_GAP_RIGHT, GuiConstants.RESULT_GAP_RIGHT)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(GuiConstants.RESULT_GAP_TOP, GuiConstants.RESULT_GAP_TOP).addComponent(this.gResultMessage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gResultScrollPane, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputLocationL).addComponent(this.outputLocationUrl)).addContainerGap(GuiConstants.RESULT_GAP_BOTTOM, GuiConstants.RESULT_GAP_BOTTOM)));
    }

    private void initFooterPanel() {
        this.footerPanel = new JPanel();
        this.footerPanel.setBackground(GuiConstants.COLOR_BG);
        this.backButton = new JButton("Back");
        this.backButton.setFont(this.defaultFont);
        this.backButton.setForeground(GuiConstants.FONT_COLOR);
        this.backButton.setBackground(GuiConstants.COLOR_BG);
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OdmExportResultPanel.this.parent.showPanel(((OdmExportResultPanel)OdmExportResultPanel.this).parent.odmExportPanel);
            }
        });
        GroupLayout footerPanelLayout = new GroupLayout(this.footerPanel);
        footerPanelLayout.setAutoCreateContainerGaps(true);
        this.footerPanel.setLayout(footerPanelLayout);
        footerPanelLayout.setHorizontalGroup(footerPanelLayout.createSequentialGroup().addContainerGap(GuiConstants.FOOTER_GAP_LEFT, Short.MAX_VALUE).addComponent(this.backButton));
        footerPanelLayout.setVerticalGroup(footerPanelLayout.createSequentialGroup().addComponent(this.backButton).addContainerGap(Short.MAX_VALUE, Short.MAX_VALUE));
    }
}

