/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer;

import com.fujitsu.tsc.desktop.importer.NotOidConnectException;
import com.fujitsu.tsc.desktop.importer.XmlReadContainer;
import com.fujitsu.tsc.desktop.importer.XmlReader;
import com.fujitsu.tsc.desktop.util.Config;
import com.fujitsu.tsc.desktop.util.ErrorInfo;
import com.fujitsu.tsc.desktop.util.ExcelStyle;
import com.fujitsu.tsc.desktop.validator.ValidationResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Importer {
    private static Logger logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
    private ExcelStyle excelStyle;
    private Config config;
    private String sourseType;
    private boolean isMadeByFujitsu;
    private SchemaFactory scmfactory;
    private XmlReader xmlReader;
    private XmlReadContainer container;

    public Importer(Config config) throws SAXException {
        this.config = config;
        this.sourseType = config.d2eDatasetType;
        this.scmfactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    }

    public ValidationResult validateHard() throws ParserConfigurationException, SAXException, IOException, NotOidConnectException {
        ValidationResult result = new ValidationResult();
        Schema hardSchema = null;
        if (this.sourseType.equals("ADAM")) {
            hardSchema = this.scmfactory.newSchema(this.getClass().getClassLoader().getResource("schema/hard/cdisc-arm-1.0/arm1-0-0.xsd"));
        } else if (this.sourseType.equals("SDTM") || this.sourseType.equals("SEND")) {
            hardSchema = this.scmfactory.newSchema(this.getClass().getClassLoader().getResource("schema/hard/cdisc-define-2.0/define2-0-0.xsd"));
        }
        SAXParserFactory spfactory = SAXParserFactory.newInstance("org.apache.xerces.jaxp.SAXParserFactoryImpl", null);
        spfactory.setNamespaceAware(true);
        spfactory.setValidating(false);
        spfactory.setSchema(hardSchema);
        SAXParser parser = spfactory.newSAXParser();
        this.xmlReader = new XmlReader();
        parser.parse(new File(this.config.d2eDataSourceLocation), (DefaultHandler)this.xmlReader);
        try {
            this.xmlReader.checkOid();
        }
        catch (NotOidConnectException ex) {
            ErrorInfo error = new ErrorInfo();
            error.setMessage(ex.getMessage());
            ArrayList<ErrorInfo> errors = this.xmlReader.getResult().getErrors();
            errors.add(error);
            this.xmlReader.getResult().setErrors(errors);
            this.xmlReader.getResult().setResult(false);
        }
        result = this.xmlReader.getResult();
        return result;
    }

    public ValidationResult validateSoft() throws ParserConfigurationException, IOException, SAXException {
        ValidationResult result2 = new ValidationResult();
        Schema softSchema = null;
        if (this.sourseType.equals("ADAM")) {
            softSchema = this.scmfactory.newSchema(this.getClass().getClassLoader().getResource("schema/soft/cdisc-arm-1.0/arm1-0-0.xsd"));
        } else if (this.sourseType.equals("SDTM") || this.sourseType.equals("SEND")) {
            softSchema = this.scmfactory.newSchema(this.getClass().getClassLoader().getResource("schema/soft/cdisc-define-2.0/define2-0-0.xsd"));
        }
        SAXParserFactory spfactory = SAXParserFactory.newInstance();
        spfactory.setNamespaceAware(true);
        spfactory.setValidating(false);
        spfactory.setSchema(softSchema);
        SAXParser parser2 = spfactory.newSAXParser();
        this.xmlReader = new XmlReader();
        parser2.parse(new File(this.config.d2eDataSourceLocation), (DefaultHandler)this.xmlReader);
        result2 = this.xmlReader.getResult();
        return result2;
    }

    public void writeExcel(ValidationResult result, OutputStream out) throws IOException {
        this.container = result.getContainer();
        if ("tsClinical Define.xml Generator".equals(this.container.getStudyDef().get("SourceSystem"))) {
            this.isMadeByFujitsu = true;
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        this.excelStyle = new ExcelStyle(wb);
        this.writeStudySheet(wb);
        this.writeDocumentSheet(wb);
        this.writeDatasetSheet(wb);
        this.writeVariableSheet(wb);
        this.writeValueSheet(wb);
        if (this.sourseType.equals("ADAM")) {
            this.writeResult1Sheet(wb);
            this.writeResult2Sheet(wb);
        }
        this.writeDictionarySheet(wb);
        this.writeCodeListSheet(wb);
        wb.write(out);
    }

    public void writeExcelGui(ValidationResult result) throws FileNotFoundException, IOException, NotOidConnectException {
        this.container = result.getContainer();
        if ("tsClinical Define.xml Generator".equals(this.container.getStudyDef().get("SourceSystem"))) {
            this.isMadeByFujitsu = true;
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        this.excelStyle = new ExcelStyle(wb);
        this.writeStudySheet(wb);
        this.writeDocumentSheet(wb);
        this.writeDatasetSheet(wb);
        this.writeVariableSheet(wb);
        this.writeValueSheet(wb);
        if (this.sourseType.equals("ADAM")) {
            this.writeResult1Sheet(wb);
            this.writeResult2Sheet(wb);
        }
        this.writeDictionarySheet(wb);
        this.writeCodeListSheet(wb);
        FileOutputStream out = null;
        out = new FileOutputStream(this.config.d2eOutputLocation);
        wb.write((OutputStream)out);
        out.close();
    }

    public void writeStudySheet(XSSFWorkbook wb) {
        XSSFSheet study = wb.createSheet("STUDY");
        XSSFRow row = study.createRow(0);
        row.createCell(0).setCellValue("Property Name");
        row.createCell(1).setCellValue("Property Value");
        study.createRow(1).createCell(0).setCellValue("ODMVersion");
        study.createRow(2).createCell(0).setCellValue("FileType");
        study.createRow(3).createCell(0).setCellValue("FileOID");
        study.createRow(4).createCell(0).setCellValue("AsOfDateTime");
        study.createRow(5).createCell(0).setCellValue("Originator");
        study.createRow(6).createCell(0).setCellValue("StudyOID");
        study.createRow(7).createCell(0).setCellValue("StudyName");
        study.createRow(8).createCell(0).setCellValue("StudyDescription");
        study.createRow(9).createCell(0).setCellValue("ProtocolName");
        study.createRow(10).createCell(0).setCellValue("MetaDataOID");
        study.createRow(11).createCell(0).setCellValue("MetaDataName");
        study.createRow(12).createCell(0).setCellValue("MetaDataDescription");
        study.createRow(13).createCell(0).setCellValue("DefineVersion");
        study.createRow(14).createCell(0).setCellValue("StandardName");
        study.createRow(15).createCell(0).setCellValue("StandardVersion");
        study.createRow(16).createCell(0).setCellValue("User Note 1");
        study.createRow(17).createCell(0).setCellValue("User Note 2");
        study.getRow(1).createCell(1).setCellValue(this.container.studyDef.get("ODMVersion"));
        study.getRow(2).createCell(1).setCellValue(this.container.studyDef.get("FileType"));
        study.getRow(3).createCell(1).setCellValue(this.container.studyDef.get("FileOID"));
        study.getRow(4).createCell(1).setCellValue(this.container.studyDef.get("AsOfDateTime"));
        study.getRow(5).createCell(1).setCellValue(this.container.studyDef.get("Originator"));
        study.getRow(6).createCell(1).setCellValue(this.container.studyDef.get("StudyOID"));
        study.getRow(7).createCell(1).setCellValue(this.container.studyDef.get("StudyName"));
        study.getRow(8).createCell(1).setCellValue(this.container.studyDef.get("StudyDescription"));
        study.getRow(9).createCell(1).setCellValue(this.container.studyDef.get("ProtocolName"));
        study.getRow(10).createCell(1).setCellValue(this.container.studyDef.get("MetaDataOID"));
        study.getRow(11).createCell(1).setCellValue(this.container.studyDef.get("MetaDataName"));
        study.getRow(12).createCell(1).setCellValue(this.container.studyDef.get("MetaDataDescription"));
        study.getRow(13).createCell(1).setCellValue(this.container.studyDef.get("DefineVersion"));
        study.getRow(14).createCell(1).setCellValue(this.container.studyDef.get("StandardName"));
        study.getRow(15).createCell(1).setCellValue(this.container.studyDef.get("StandardVersion"));
        study.getRow(16).createCell(1);
        study.getRow(17).createCell(1);
        study = this.excelStyle.setColumnWidth(study);
        study = this.excelStyle.setStyleStudySheet(study);
    }

    public void writeDocumentSheet(XSSFWorkbook wb) {
        XSSFSheet document = wb.createSheet("DOCUMENT");
        XSSFRow row = document.createRow(0);
        row.createCell(0).setCellValue("ID");
        row.createCell(1).setCellValue("Type");
        row.createCell(2).setCellValue("href");
        row.createCell(3).setCellValue("Title");
        row.createCell(4).setCellValue("User Note 1");
        row.createCell(5).setCellValue("User Note 2");
        int i = 0;
        while (i < this.container.leafDefList.size()) {
            row = document.createRow(i + 1);
            if (this.isMadeByFujitsu) {
                row.createCell(0).setCellValue(this.removeTag("LF", this.container.leafDefList.get(i).get("ID")));
            } else {
                row.createCell(0).setCellValue(this.container.leafDefList.get(i).get("ID"));
            }
            if (this.container.documentDefList.get(this.container.leafDefList.get(i).get("ID")) != null) {
                row.createCell(1).setCellValue(this.container.documentDefList.get(this.container.leafDefList.get(i).get("ID")).get("Type"));
            } else {
                row.createCell(1).setCellValue("Other");
            }
            row.createCell(2).setCellValue(this.container.leafDefList.get(i).get("xlink:href"));
            row.createCell(3).setCellValue(this.container.leafDefList.get(i).get("def:title"));
            ++i;
        }
        document = this.excelStyle.setColumnWidth(document);
        document = this.excelStyle.setStyleDocumentSheet(document);
    }

    public void writeDatasetSheet(XSSFWorkbook wb) {
        XSSFSheet dataset = wb.createSheet("DATASET");
        XSSFRow row = dataset.createRow(0);
        row.createCell(0).setCellValue("Domain");
        row.createCell(1).setCellValue("Dataset Name");
        row.createCell(2).setCellValue("Has SUPP");
        row.createCell(3).setCellValue("Repeating");
        row.createCell(4).setCellValue("IsReferenceData");
        row.createCell(5).setCellValue("Purpose");
        row.createCell(6).setCellValue("Structure");
        row.createCell(7).setCellValue("Class");
        row.createCell(8).setCellValue("Comment");
        row.createCell(9).setCellValue("xml:lang");
        row.createCell(10).setCellValue("DocumentID");
        row.createCell(11).setCellValue("Document Page Type");
        row.createCell(12).setCellValue("Document Page Reference");
        row.createCell(13).setCellValue("Description");
        row.createCell(14).setCellValue("Alias");
        row.createCell(15).setCellValue("href");
        row.createCell(16).setCellValue("Title");
        row.createCell(17).setCellValue("User Note 1");
        row.createCell(18).setCellValue("User Note 2");
        int j = 0;
        while (j < this.container.itemGroupDefList.size()) {
            if (this.container.itemGroupDefList.get(j).get("DatasetName") != null && this.container.itemGroupDefList.get(j).get("DatasetName").toString().startsWith("SUPP") && !this.container.itemGroupDefList.get(j).get("DatasetName").toString().equals("SUPPQUAL")) {
                String parentDomain = this.container.itemGroupDefList.get(j).get("DatasetName").toString().replace("SUPP", "");
                int k = 0;
                while (k < this.container.itemGroupDefList.size()) {
                    if (this.container.itemGroupDefList.get(k).get("DatasetName") != null && this.container.itemGroupDefList.get(k).get("DatasetName").equals(parentDomain)) {
                        this.container.itemGroupDefList.get(k).put("HasSUPP", "Yes");
                    }
                    ++k;
                }
            }
            ++j;
        }
        int i = 0;
        while (i < this.container.itemGroupDefList.size()) {
            if (this.container.itemGroupDefList.get(i).get("DatasetName") == null || !this.container.itemGroupDefList.get(i).get("DatasetName").toString().startsWith("SUPP") || this.container.itemGroupDefList.get(i).get("Domain").toString().equals("SUPPQUAL")) {
                row = dataset.createRow(i + 1);
                if (this.sourseType.equals("ADAM")) {
                    row.createCell(0).setCellValue(this.container.itemGroupDefList.get(i).get("DatasetName"));
                } else {
                    row.createCell(0).setCellValue(this.container.itemGroupDefList.get(i).get("Domain"));
                }
                row.createCell(1).setCellValue(this.container.itemGroupDefList.get(i).get("DatasetName"));
                if (this.container.itemGroupDefList.get(i).get("HasSUPP") != null && this.container.itemGroupDefList.get(i).get("HasSUPP").equals("Yes")) {
                    row.createCell(2).setCellValue(this.container.itemGroupDefList.get(i).get("HasSUPP"));
                } else {
                    row.createCell(2).setCellValue("No");
                }
                row.createCell(3).setCellValue(this.container.itemGroupDefList.get(i).get("Repeating"));
                row.createCell(4).setCellValue(this.container.itemGroupDefList.get(i).get("IsReferenceData"));
                row.createCell(5).setCellValue(this.container.itemGroupDefList.get(i).get("Purpose"));
                row.createCell(6).setCellValue(this.container.itemGroupDefList.get(i).get("Structure"));
                row.createCell(7).setCellValue(this.container.itemGroupDefList.get(i).get("Class"));
                if (this.container.itemGroupDefList.get(i).get("CommentOID") != null) {
                    row.createCell(8).setCellValue(this.container.commentDefList.get(this.container.itemGroupDefList.get(i).get("CommentOID")).get("TranslatedText"));
                    row.createCell(9).setCellValue(this.container.commentDefList.get(this.container.itemGroupDefList.get(i).get("CommentOID")).get("xml:lang"));
                    if (this.isMadeByFujitsu && this.container.commentDefList.get(this.container.itemGroupDefList.get(i).get("CommentOID")).get("leafID") != null) {
                        String id = this.removeTag("LF", this.container.commentDefList.get(this.container.itemGroupDefList.get(i).get("CommentOID")).get("leafID"));
                        row.createCell(10).setCellValue(id);
                    } else {
                        row.createCell(10).setCellValue(this.container.commentDefList.get(this.container.itemGroupDefList.get(i).get("CommentOID")).get("leafID"));
                    }
                    row.createCell(11).setCellValue(this.container.commentDefList.get(this.container.itemGroupDefList.get(i).get("CommentOID")).get("PageType"));
                    row.createCell(12).setCellValue(this.container.commentDefList.get(this.container.itemGroupDefList.get(i).get("CommentOID")).get("PageRefs"));
                }
                row.createCell(13).setCellValue(this.container.itemGroupDefList.get(i).get("Comment"));
                row.createCell(14).setCellValue(this.container.itemGroupDefList.get(i).get("Alias"));
                row.createCell(15).setCellValue(this.container.itemGroupDefList.get(i).get("href"));
                row.createCell(16).setCellValue(this.container.itemGroupDefList.get(i).get("Title"));
            }
            ++i;
        }
        dataset = this.excelStyle.setColumnWidth(dataset);
        dataset = this.excelStyle.setStyleDatasetSheet(dataset);
    }

    public void writeVariableSheet(XSSFWorkbook wb) {
        XSSFSheet variable = wb.createSheet("VARIABLE");
        XSSFRow row = variable.createRow(0);
        row.createCell(0).setCellValue("Domain");
        row.createCell(1).setCellValue("Dataset Name");
        row.createCell(2).setCellValue("Variable Name");
        row.createCell(3).setCellValue("Is SUPP");
        row.createCell(4).setCellValue("Label");
        row.createCell(5).setCellValue("Mandatory");
        row.createCell(6).setCellValue("Key Sequence");
        row.createCell(7).setCellValue("DataType");
        row.createCell(8).setCellValue("Length");
        row.createCell(9).setCellValue("SignificantDigits");
        row.createCell(10).setCellValue("SASFieldName");
        row.createCell(11).setCellValue("DisplayFormat");
        row.createCell(12).setCellValue("Codelist");
        row.createCell(13).setCellValue("Origin");
        row.createCell(14).setCellValue("Derivation Type");
        row.createCell(15).setCellValue("CRF ID");
        row.createCell(16).setCellValue("CRF Page Type");
        row.createCell(17).setCellValue("CRF Page Reference");
        row.createCell(18).setCellValue("Has Value Metadata");
        row.createCell(19).setCellValue("Predecessor/Derivation");
        row.createCell(20).setCellValue("Comment");
        row.createCell(21).setCellValue("xml:lang");
        row.createCell(22).setCellValue("DocumentID");
        row.createCell(23).setCellValue("Document Page Type");
        row.createCell(24).setCellValue("Document Page Reference");
        row.createCell(25).setCellValue("Role");
        row.createCell(26).setCellValue("Role codelist");
        row.createCell(27).setCellValue("Formal expression context");
        row.createCell(28).setCellValue("Formal expression");
        row.createCell(29).setCellValue("User Note 1");
        row.createCell(30).setCellValue("User Note 2");
        String lastDataset = "lastDataset";
        int n = 0;
        int i = 0;
        while (i < this.container.variableItemRefList.size()) {
            if (!this.container.variableItemRefList.get(i).get("DatasetName").toString().startsWith("SUPP") || this.container.variableItemRefList.get(i).get("DatasetName").toString().equals("SUPPQUAL")) {
                if (!lastDataset.equals(this.container.variableItemRefList.get(i).get("DatasetName"))) {
                    int m = 0;
                    while (m < this.container.valueItemDefIdList.size()) {
                        String key = this.container.valueItemDefIdList.get(m);
                        int k = 0;
                        while (k < this.container.valueItemDefList.get(key).size()) {
                            if (this.container.valueItemDefList.get(key).get(k).get("DatasetName").startsWith("SUPP") && !this.container.valueItemDefList.get(key).get(k).get("DatasetName").equals("SUPPQUAL") && this.container.valueItemDefList.get(key).get(k).get("DatasetName").replace("SUPP", "").equals(lastDataset)) {
                                this.writeSuppVariable(wb, key, k, n);
                                ++n;
                            }
                            ++k;
                        }
                        ++m;
                    }
                }
                row = variable.createRow(i + 1 + n);
                if (this.sourseType == "ADAM") {
                    row.createCell(0).setCellValue(this.container.variableItemRefList.get(i).get("DatasetName"));
                } else {
                    row.createCell(0).setCellValue(this.container.variableItemRefList.get(i).get("Domain"));
                }
                row.createCell(1).setCellValue(this.container.variableItemRefList.get(i).get("DatasetName"));
                row.createCell(2).setCellValue(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("Name"));
                row.createCell(3).setCellValue("No");
                row.createCell(4).setCellValue(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("TranslatedText"));
                row.createCell(5).setCellValue(this.container.variableItemRefList.get(i).get("Mandatory"));
                row.createCell(6).setCellValue(this.container.variableItemRefList.get(i).get("KeySequence"));
                row.createCell(7).setCellValue(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("DataType"));
                row.createCell(8).setCellValue(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("Length"));
                row.createCell(9).setCellValue(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("SignificantDigits"));
                row.createCell(10).setCellValue(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("SASFieldName"));
                row.createCell(11).setCellValue(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("DisplayFormat"));
                if (this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("CodeListOID") != null) {
                    if (this.container.dictionaryIdList.containsKey(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("CodeListOID"))) {
                        row.createCell(12).setCellValue(this.container.dictionaryIdList.get(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("CodeListOID")));
                    } else if (this.isMadeByFujitsu) {
                        String id = this.removeTag("CL", this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("CodeListOID"));
                        row.createCell(12).setCellValue(id);
                    } else {
                        row.createCell(12).setCellValue(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("CodeListOID"));
                    }
                }
                row.createCell(13).setCellValue(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("Type"));
                if (this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("Type") != null) {
                    if (this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("Type").toString().equals("Derived")) {
                        if (this.container.variableItemRefList.get(i).get("MethodOID") != null) {
                            row.createCell(14).setCellValue(this.container.methodDefList.get(this.container.variableItemRefList.get(i).get("MethodOID")).get("Type"));
                            row.createCell(19).setCellValue(this.container.methodDefList.get(this.container.variableItemRefList.get(i).get("MethodOID")).get("TranslatedText"));
                            row.createCell(21).setCellValue(this.container.methodDefList.get(this.container.variableItemRefList.get(i).get("MethodOID")).get("xml:lang"));
                        }
                    } else if (this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("Type").toString().equals("Predecessor")) {
                        row.createCell(19).setCellValue(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("Origin TranslatedText"));
                    }
                }
                if (this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("leafID") != null && this.isMadeByFujitsu) {
                    row.createCell(15).setCellValue(this.removeTag("LF", this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("leafID")));
                } else {
                    row.createCell(15).setCellValue(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("leafID"));
                }
                row.createCell(16).setCellValue(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("PageType"));
                row.createCell(17).setCellValue(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("PageRefs"));
                if (this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("ValueListOID") != null) {
                    row.createCell(18).setCellValue("Yes");
                } else {
                    row.createCell(18).setCellValue("No");
                }
                if (this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("CommentOID") != null) {
                    row.createCell(20).setCellValue(this.container.commentDefList.get(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("CommentOID")).get("TranslatedText"));
                    if (this.container.commentDefList.get(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("CommentOID")).get("TranslatedText") != null) {
                        row.createCell(21).setCellValue(this.container.commentDefList.get(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("CommentOID")).get("xml:lang"));
                    }
                    if (this.container.commentDefList.get(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("CommentOID")).get("leafID") != null && this.isMadeByFujitsu) {
                        String id = this.removeTag("LF", this.container.commentDefList.get(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("CommentOID")).get("leafID"));
                        row.createCell(22).setCellValue(id);
                    } else {
                        row.createCell(22).setCellValue(this.container.commentDefList.get(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("CommentOID")).get("leafID"));
                    }
                    row.createCell(23).setCellValue(this.container.commentDefList.get(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("CommentOID")).get("PageType"));
                    row.createCell(24).setCellValue(this.container.commentDefList.get(this.container.itemDefList.get(this.container.variableItemRefList.get(i).get("ItemOID")).get("CommentOID")).get("PageRefs"));
                }
                row.createCell(25).setCellValue(this.container.variableItemRefList.get(i).get("Role"));
                if (this.isMadeByFujitsu && this.container.variableItemRefList.get(i).get("RoleCodelistOID") != null) {
                    row.createCell(26).setCellValue(this.removeTag("CL", this.container.variableItemRefList.get(i).get("RoleCodelistOID")));
                } else {
                    row.createCell(26).setCellValue(this.container.variableItemRefList.get(i).get("RoleCodelistOID"));
                }
                if (this.container.variableItemRefList.get(i).get("MethodOID") != null) {
                    row.createCell(27).setCellValue(this.container.methodDefList.get(this.container.variableItemRefList.get(i).get("MethodOID")).get("Context"));
                    row.createCell(28).setCellValue(this.container.methodDefList.get(this.container.variableItemRefList.get(i).get("MethodOID")).get("FormalExpression"));
                }
            }
            if (this.container.variableItemRefList.get(i).get("Domain") != null) {
                lastDataset = this.container.variableItemRefList.get(i).get("DatasetName");
            }
            ++i;
        }
        variable = this.excelStyle.setColumnWidth(variable);
        variable = this.excelStyle.setStyleVariableSheet(variable);
    }

    public String writeSuppVariable(XSSFWorkbook wb, String key, int i, int n) {
        String id;
        XSSFRow row = wb.getSheet("VARIABLE").createRow(wb.getSheet("VARIABLE").getLastRowNum() + 1);
        row.createCell(0).setCellValue(this.container.valueItemDefList.get(key).get(i).get("Domain").substring(4, 6));
        row.createCell(1).setCellValue(this.container.valueItemDefList.get(key).get(i).get("DatasetName").replace("SUPP", ""));
        row.createCell(2).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Name"));
        row.createCell(3).setCellValue("Yes");
        row.createCell(4).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("TranslatedText"));
        row.createCell(5).setCellValue(this.container.valueItemDefList.get(key).get(i).get("Mandatory"));
        row.createCell(6).setCellValue(this.container.valueItemDefList.get(key).get(i).get("KeySequence"));
        row.createCell(7).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("DataType"));
        row.createCell(8).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Length"));
        row.createCell(9).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("SignificantDigits"));
        row.createCell(10).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("SASFieldName"));
        row.createCell(11).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("DisplayFormat"));
        if (this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("CodeListOID") != null) {
            if (this.container.dictionaryIdList.containsKey(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("CodeListOID"))) {
                row.createCell(12).setCellValue(this.container.dictionaryIdList.get(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("CodeListOID")));
            } else if (this.isMadeByFujitsu) {
                row.createCell(12).setCellValue(this.removeTag("CL", this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("CodeListOID")));
            } else {
                row.createCell(12).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("CodeListOID"));
            }
        }
        row.createCell(13).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Type"));
        if (this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Type") != null) {
            if (this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Type").toString().equals("Derived")) {
                if (this.container.valueItemDefList.get(key).get(i).get("MethodOID") != null) {
                    row.createCell(14).setCellValue(this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("Type"));
                    row.createCell(19).setCellValue(this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("TranslatedText"));
                    row.createCell(21).setCellValue(this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("xml:lang"));
                }
            } else if (this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Type").toString().equals("Predecessor")) {
                row.createCell(19).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Origin TranslatedText"));
            }
            if (this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Type").equals("CRF")) {
                if (this.isMadeByFujitsu && this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("leafID") != null) {
                    id = this.removeTag("LF", this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("leafID"));
                    row.createCell(15).setCellValue(id);
                } else {
                    row.createCell(15).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("leafID"));
                }
                row.createCell(16).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("PageType"));
                row.createCell(17).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("PageRefs"));
            }
        }
        row.createCell(18).setCellValue("No");
        if (this.container.valueItemDefList.get(key).get(i).get("CommentOID") != null) {
            row.createCell(20).setCellValue(this.container.commentDefList.get(this.container.valueItemDefList.get(key).get(i).get("CommentOID")).get("TranslatedText"));
            row.createCell(21).setCellValue(this.container.commentDefList.get(this.container.valueItemDefList.get(key).get(i).get("CommentOID")).get("xml:lang"));
            if (this.isMadeByFujitsu) {
                id = this.removeTag("LF", this.container.commentDefList.get(this.container.valueItemDefList.get(key).get(i).get("CommentOID")).get("leafID"));
                row.createCell(22).setCellValue(id);
            } else {
                row.createCell(22).setCellValue(this.container.commentDefList.get(this.container.valueItemDefList.get(key).get(i).get("CommentOID")).get("leafID"));
            }
            row.createCell(23).setCellValue(this.container.commentDefList.get(this.container.valueItemDefList.get(key).get(i).get("CommentOID")).get("PageType"));
            row.createCell(24).setCellValue(this.container.commentDefList.get(this.container.valueItemDefList.get(key).get(i).get("CommentOID")).get("PageRefs"));
        }
        row.createCell(25).setCellValue(this.container.variableItemRefList.get(i).get("Role"));
        row.createCell(26).setCellValue(this.container.variableItemRefList.get(i).get("RoleCodelistOID"));
        if (this.container.valueItemDefList.get(key).get(i).get("MethodOID") != null) {
            row.createCell(14).setCellValue(this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("Type"));
            row.createCell(19).setCellValue(this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("TranslatedText"));
            row.createCell(27).setCellValue(this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("Context"));
            row.createCell(28).setCellValue(this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("FormalExpression"));
        }
        return this.container.valueItemDefList.get(key).get(i).get("Domain").replace("SUPP", "");
    }

    public void writeValueSheet(XSSFWorkbook wb) {
        XSSFSheet value = wb.createSheet("VALUE");
        XSSFRow row = value.createRow(0);
        row.createCell(0).setCellValue("Domain");
        row.createCell(1).setCellValue("Dataset Name");
        row.createCell(2).setCellValue("Value Name");
        row.createCell(3).setCellValue("Variable Name");
        row.createCell(4).setCellValue("Value Key");
        row.createCell(5).setCellValue("Label");
        row.createCell(6).setCellValue("Mandatory");
        row.createCell(7).setCellValue("Key Sequence");
        row.createCell(8).setCellValue("DataType");
        row.createCell(9).setCellValue("Length");
        row.createCell(10).setCellValue("SignificantDigits");
        row.createCell(11).setCellValue("SASFieldName");
        row.createCell(12).setCellValue("DisplayFormat");
        row.createCell(13).setCellValue("Codelist");
        row.createCell(14).setCellValue("Origin");
        row.createCell(15).setCellValue("Derivation Type");
        row.createCell(16).setCellValue("CRF ID");
        row.createCell(17).setCellValue("CRF Page Type");
        row.createCell(18).setCellValue("CRF Page Reference");
        row.createCell(19).setCellValue("Predecessor/Derivation");
        row.createCell(20).setCellValue("Comment");
        row.createCell(21).setCellValue("xml:lang");
        row.createCell(22).setCellValue("DocumentID");
        row.createCell(23).setCellValue("Document Page Type");
        row.createCell(24).setCellValue("Document Page Reference");
        row.createCell(25).setCellValue("Formal expression context");
        row.createCell(26).setCellValue("Formal expression");
        row.createCell(27).setCellValue("User Note 1");
        row.createCell(28).setCellValue("User Note 2");
        row.createCell(29).setCellValue("W Domain");
        row.createCell(30).setCellValue("W Dataset Name");
        row.createCell(31).setCellValue("W Variable Name");
        row.createCell(32).setCellValue("W Value Key");
        row.createCell(33).setCellValue("WhereClauseDataset");
        row.createCell(34).setCellValue("WhereClauseVariable");
        row.createCell(35).setCellValue("WhereClauseOperator");
        row.createCell(36).setCellValue("WhereClauseValue");
        row.createCell(37).setCellValue("WhereClause Comment");
        row.createCell(38).setCellValue("W xml:lang");
        int j = 0;
        int m = 0;
        while (m < this.container.valueItemDefIdList.size()) {
            String key = this.container.valueItemDefIdList.get(m);
            int i = 0;
            while (i < this.container.valueItemDefList.get(key).size()) {
                if (this.container.valueItemDefList.get(key).get(i).get("DatasetName").startsWith("SUPP") && !this.container.valueItemDefList.get(key).get(i).get("Domain").equals("SUPPQUAL")) {
                    --j;
                } else {
                    row = value.createRow(i + j + 1);
                    row.createCell(0).setCellValue(this.container.valueItemDefList.get(key).get(i).get("Domain"));
                    row.createCell(1).setCellValue(this.container.valueItemDefList.get(key).get(i).get("DatasetName"));
                    row.createCell(2).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Name"));
                    row.createCell(3).setCellValue(this.container.valueItemDefList.get(key).get(i).get("VariableName"));
                    if (this.isMadeByFujitsu && this.container.valueItemDefList.get(key).get(i).get("ItemOID") != null) {
                        row.createCell(4).setCellValue(this.removeTag("IT", this.container.valueItemDefList.get(key).get(i).get("DatasetName"), this.container.valueItemDefList.get(key).get(i).get("VariableName"), this.container.valueItemDefList.get(key).get(i).get("ItemOID")));
                    } else {
                        row.createCell(4).setCellValue(this.container.valueItemDefList.get(key).get(i).get("ItemOID"));
                    }
                    row.createCell(5).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("TranslatedText"));
                    row.createCell(6).setCellValue(this.container.valueItemDefList.get(key).get(i).get("Mandatory"));
                    row.createCell(8).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("DataType"));
                    row.createCell(9).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Length"));
                    row.createCell(10).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("SignificantDigits"));
                    row.createCell(11).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("SASFieldName"));
                    row.createCell(12).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("DisplayFormat"));
                    if (this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("CodeListOID") != null) {
                        if (this.container.dictionaryIdList.containsKey(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("CodeListOID"))) {
                            row.createCell(13).setCellValue(this.container.dictionaryIdList.get(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("CodeListOID")));
                        } else if (this.isMadeByFujitsu) {
                            row.createCell(13).setCellValue(this.removeTag("CL", this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("CodeListOID")));
                        } else {
                            row.createCell(13).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("CodeListOID"));
                        }
                    }
                    row.createCell(14).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Type"));
                    if (this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Type") != null) {
                        if (this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Type").toString().equals("Derived")) {
                            if (this.container.valueItemDefList.get(key).get(i).get("MethodOID") != null) {
                                row.createCell(15).setCellValue(this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("Type"));
                                row.createCell(19).setCellValue(this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("TranslatedText"));
                                row.createCell(21).setCellValue(this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("xml:lang"));
                            }
                        } else if (this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Type").toString().equals("Predecessor")) {
                            row.createCell(19).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Origin TranslatedText"));
                        }
                        if (this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("Type").toString().equals("CRF")) {
                            if (this.isMadeByFujitsu && this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("leafID") != null) {
                                String id = this.removeTag("LF", this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("leafID"));
                                row.createCell(16).setCellValue(id);
                            } else {
                                row.createCell(16).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("leafID"));
                            }
                            row.createCell(17).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("PageType"));
                            row.createCell(18).setCellValue(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("PageRefs"));
                        }
                    }
                    if (this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("CommentOID") != null) {
                        row.createCell(20).setCellValue(this.container.commentDefList.get(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("CommentOID")).get("TranslatedText"));
                        row.createCell(21).setCellValue(this.container.commentDefList.get(this.container.itemDefList.get(this.container.valueItemDefList.get(key).get(i).get("ItemOID")).get("CommentOID")).get("xml:lang"));
                    }
                    if (this.container.whereClauseDefList.get(this.container.valueItemDefList.get(key).get(i).get("WhereClauseOID")) != null) {
                        ArrayList<Hashtable<String, String>> array = this.container.whereClauseDefList.get(this.container.valueItemDefList.get(key).get(i).get("WhereClauseOID"));
                        int k = 0;
                        while (k < array.size()) {
                            if (k != 0) {
                                row = value.createRow(i + j + k + 1);
                            }
                            row.createCell(29).setCellValue(this.container.valueItemDefList.get(key).get(i).get("Domain"));
                            row.createCell(30).setCellValue(this.container.valueItemDefList.get(key).get(i).get("DatasetName"));
                            row.createCell(31).setCellValue(this.container.valueItemDefList.get(key).get(i).get("VariableName"));
                            if (this.isMadeByFujitsu && this.container.valueItemDefList.get(key).get(i).get("ItemOID") != null) {
                                row.createCell(32).setCellValue(this.removeTag("IT", this.container.valueItemDefList.get(key).get(i).get("DatasetName"), this.container.valueItemDefList.get(key).get(i).get("VariableName"), this.container.valueItemDefList.get(key).get(i).get("ItemOID")));
                            } else {
                                row.createCell(32).setCellValue(this.container.valueItemDefList.get(key).get(i).get("ItemOID"));
                            }
                            int l = 0;
                            while (l < this.container.variableItemRefList.size()) {
                                if (this.container.variableItemRefList.get(l).get("ItemOID") != null && this.container.variableItemRefList.get(l).get("ItemOID").equals(array.get(k).get("def:ItemOID"))) {
                                    row.createCell(33).setCellValue(this.container.variableItemRefList.get(l).get("DatasetName"));
                                }
                                ++l;
                            }
                            row.createCell(34).setCellValue(this.container.itemDefList.get(array.get(k).get("def:ItemOID")).get("Name"));
                            row.createCell(35).setCellValue(array.get(k).get("Comparator"));
                            row.createCell(36).setCellValue(array.get(k).get("CheckValue"));
                            if (this.container.itemDefList.get(array.get(k).get("def:ItemOID")).get("def:CommentOID") != null) {
                                row.createCell(37).setCellValue(this.container.commentDefList.get(array.get(k).get("def:CommentOID")).get("TranslatedText"));
                                row.createCell(38).setCellValue(this.container.commentDefList.get(array.get(k).get("def:CommentOID")).get("xml:lang"));
                            }
                            ++k;
                        }
                        j = j + array.size() - 1;
                    }
                    if (this.container.valueItemDefList.get(key).get(i).get("MethodOID") != null) {
                        if (this.isMadeByFujitsu && this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("leafID") != null) {
                            row.createCell(22).setCellValue(this.removeTag("LF", this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("leafID")));
                        } else {
                            row.createCell(22).setCellValue(this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("leafID"));
                        }
                        row.createCell(23).setCellValue(this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("PageType"));
                        row.createCell(24).setCellValue(this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("PageRefs"));
                        row.createCell(25).setCellValue(this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("Context"));
                        row.createCell(26).setCellValue(this.container.methodDefList.get(this.container.valueItemDefList.get(key).get(i).get("MethodOID")).get("FormalExpression"));
                    }
                }
                ++i;
            }
            j += this.container.valueItemDefList.get(key).size();
            ++m;
        }
        value = this.excelStyle.setColumnWidth(value);
        value = this.excelStyle.setStyleValueSheet(value);
    }

    public void writeDictionarySheet(XSSFWorkbook wb) {
        XSSFSheet dictionary = wb.createSheet("DICTIONARY");
        XSSFRow row = dictionary.createRow(0);
        row.createCell(0).setCellValue("Dictionary ID");
        row.createCell(1).setCellValue("Name");
        row.createCell(2).setCellValue("DataType");
        row.createCell(3).setCellValue("Version");
        row.createCell(4).setCellValue("ref");
        row.createCell(5).setCellValue("href");
        row.createCell(6).setCellValue("User Note 1");
        row.createCell(7).setCellValue("User Note 2");
        int i = 0;
        while (i < this.container.dictionaryDefList.size()) {
            row = dictionary.createRow(i + 1);
            row.createCell(0).setCellValue(this.container.dictionaryDefList.get(i).get("Dictionary"));
            row.createCell(1).setCellValue(this.container.dictionaryDefList.get(i).get("CodeListName"));
            row.createCell(2).setCellValue(this.container.dictionaryDefList.get(i).get("DataType"));
            row.createCell(3).setCellValue(this.container.dictionaryDefList.get(i).get("Version"));
            row.createCell(4).setCellValue(this.container.dictionaryDefList.get(i).get("ref"));
            row.createCell(5).setCellValue(this.container.dictionaryDefList.get(i).get("href"));
            ++i;
        }
        dictionary = this.excelStyle.setColumnWidth(dictionary);
        dictionary = this.excelStyle.setStyleDictionarySheet(dictionary);
    }

    public void writeCodeListSheet(XSSFWorkbook wb) {
        XSSFSheet codelist = wb.createSheet("CODELIST");
        XSSFRow row = codelist.createRow(0);
        row.createCell(0).setCellValue("Codelist ID");
        row.createCell(1).setCellValue("Codelist Code");
        row.createCell(2).setCellValue("Codelist Label");
        row.createCell(3).setCellValue("DataType");
        row.createCell(4).setCellValue("SASFormatName");
        row.createCell(5).setCellValue("Code");
        row.createCell(6).setCellValue("User Code");
        row.createCell(7).setCellValue("Order Number");
        row.createCell(8).setCellValue("Rank");
        row.createCell(9).setCellValue("ExtendedValue");
        row.createCell(10).setCellValue("Submission Value");
        row.createCell(11).setCellValue("Decode");
        row.createCell(12).setCellValue("xml:lang");
        row.createCell(13).setCellValue("User Note 1");
        row.createCell(14).setCellValue("User Note 2");
        int i = 0;
        while (i < this.container.codeListItemDefList.size()) {
            row = codelist.createRow(i + 1);
            if (this.isMadeByFujitsu) {
                row.createCell(0).setCellValue(this.removeTag("CL", this.container.codeListItemDefList.get(i).get("OID")));
            } else {
                row.createCell(0).setCellValue(this.container.codeListItemDefList.get(i).get("OID"));
            }
            row.createCell(1).setCellValue(this.container.codeListDefList.get(this.container.codeListItemDefList.get(i).get("OID")).get("Code"));
            row.createCell(2).setCellValue(this.container.codeListItemDefList.get(i).get("CodeListName"));
            row.createCell(3).setCellValue(this.container.codeListItemDefList.get(i).get("DataType"));
            row.createCell(4).setCellValue(this.container.codeListItemDefList.get(i).get("SASFormatName"));
            row.createCell(5).setCellValue(this.container.codeListItemDefList.get(i).get("Name"));
            row.createCell(7).setCellValue(this.container.codeListItemDefList.get(i).get("OrderNumber"));
            row.createCell(8).setCellValue(this.container.codeListItemDefList.get(i).get("Rank"));
            if (this.container.codeListItemDefList.get(i).get("def:ExtendedValue") != null) {
                row.createCell(9).setCellValue(this.container.codeListItemDefList.get(i).get("def:ExtendedValue"));
            } else {
                row.createCell(9).setCellValue("No");
            }
            row.createCell(10).setCellValue(this.container.codeListItemDefList.get(i).get("CodedValue"));
            row.createCell(11).setCellValue(this.container.codeListItemDefList.get(i).get("TranslatedText"));
            row.createCell(12).setCellValue(this.container.codeListItemDefList.get(i).get("xml:lang"));
            ++i;
        }
        codelist = this.excelStyle.setColumnWidth(codelist);
        codelist = this.excelStyle.setStyleCodelistSheet(codelist);
    }

    public void writeResult1Sheet(XSSFWorkbook wb) {
        XSSFSheet result1 = wb.createSheet("RESULT1");
        XSSFRow row = result1.createRow(0);
        row.createCell(0).setCellValue("Display Name");
        row.createCell(1).setCellValue("Display Description");
        row.createCell(2).setCellValue("Display xml:lang");
        row.createCell(3).setCellValue("Leaf ID");
        row.createCell(4).setCellValue("Leaf Page Type");
        row.createCell(5).setCellValue("Leaf Page Reference");
        row.createCell(6).setCellValue("User Note 1");
        row.createCell(7).setCellValue("User Note 2");
        row.createCell(8).setCellValue("W Display Name");
        row.createCell(9).setCellValue("Result Key");
        row.createCell(10).setCellValue("Result Description");
        row.createCell(11).setCellValue("Result xml:lang");
        row.createCell(12).setCellValue("ParameterOID Dataset");
        row.createCell(13).setCellValue("Analysis Reason");
        row.createCell(14).setCellValue("Analysis Purpose");
        row.createCell(15).setCellValue("Documentation ID");
        row.createCell(16).setCellValue("Documentation Page Type");
        row.createCell(17).setCellValue("Documentation Page Reference");
        row.createCell(18).setCellValue("Documentation Text");
        row.createCell(19).setCellValue("Documentation xml:lang");
        row.createCell(20).setCellValue("Programming Code Context");
        row.createCell(21).setCellValue("Programming Code Text");
        row.createCell(22).setCellValue("Programming Code Document ID");
        row.createCell(23).setCellValue("Programming Code Document Page Type");
        row.createCell(24).setCellValue("Programming Code Document Page Reference");
        row.createCell(25).setCellValue("Datasets Comment");
        row.createCell(26).setCellValue("Datasets xml:lang");
        row.createCell(27).setCellValue("DocumentID");
        row.createCell(28).setCellValue("Document Page Type");
        row.createCell(29).setCellValue("Document Page Reference");
        String lastDisplayName = "lastDisplayName";
        int i = 0;
        while (i < this.container.analysisResultList.size()) {
            row = result1.createRow(i + 1);
            if (!lastDisplayName.equals(this.container.analysisResultList.get(i).get("DisplayName"))) {
                row.createCell(0).setCellValue(this.container.analysisResultList.get(i).get("DisplayName"));
                row.createCell(1).setCellValue(this.container.analysisResultList.get(i).get("DisplayDescription"));
                row.createCell(2).setCellValue(this.container.analysisResultList.get(i).get("DisplayXmlLang"));
                if (this.isMadeByFujitsu && this.container.analysisResultList.get(i).get("DisplayLeafID") != null) {
                    row.createCell(3).setCellValue(this.removeTag("LF", this.container.analysisResultList.get(i).get("DisplayLeafID")));
                } else {
                    row.createCell(3).setCellValue(this.container.analysisResultList.get(i).get("DisplayLeafID"));
                }
                row.createCell(4).setCellValue(this.container.analysisResultList.get(i).get("DisplayPageType"));
                row.createCell(5).setCellValue(this.container.analysisResultList.get(i).get("DisplayPageRefs"));
            }
            row.createCell(8).setCellValue(this.container.analysisResultList.get(i).get("DisplayName"));
            if (this.container.analysisResultList.get(i).get("AnalysisOID") != null) {
                if (this.isMadeByFujitsu) {
                    row.createCell(9).setCellValue(this.removeTag("AR", this.container.analysisResultList.get(i).get("DisplayName"), "", this.container.analysisResultList.get(i).get("AnalysisOID")));
                } else {
                    row.createCell(9).setCellValue(this.container.analysisResultList.get(i).get("AnalysisOID"));
                }
            }
            row.createCell(10).setCellValue(this.container.analysisResultList.get(i).get("AnalysisDescription"));
            row.createCell(11).setCellValue(this.container.analysisResultList.get(i).get("xml:lang"));
            if (this.container.analysisResultList.get(i).get("ParameterOID") != null) {
                row.createCell(12).setCellValue(this.container.itemDefOIDandDatasetNameList.get(this.container.analysisResultList.get(i).get("ParameterOID")));
            }
            row.createCell(13).setCellValue(this.container.analysisResultList.get(i).get("AnalysisReason"));
            row.createCell(14).setCellValue(this.container.analysisResultList.get(i).get("AnalysisPurpose"));
            if (this.isMadeByFujitsu && this.container.analysisResultList.get(i).get("Documentation leafID") != null) {
                row.createCell(15).setCellValue(this.removeTag("LF", this.container.analysisResultList.get(i).get("Documentation leafID")));
            } else {
                row.createCell(15).setCellValue(this.container.analysisResultList.get(i).get("Documentation leafID"));
            }
            row.createCell(16).setCellValue(this.container.analysisResultList.get(i).get("Documentation PageType"));
            row.createCell(17).setCellValue(this.container.analysisResultList.get(i).get("Documentation PageRefs"));
            row.createCell(18).setCellValue(this.container.analysisResultList.get(i).get("Documentation Description"));
            row.createCell(19).setCellValue(this.container.analysisResultList.get(i).get("Documentation xml:lang"));
            row.createCell(20).setCellValue(this.container.analysisResultList.get(i).get("ProgrammingCodeContext"));
            row.createCell(21).setCellValue(this.container.analysisResultList.get(i).get("ProgrammingCodeDescription"));
            if (this.isMadeByFujitsu && this.container.analysisResultList.get(i).get("ProgrammingCodeleafID") != null) {
                row.createCell(22).setCellValue(this.removeTag("LF", this.container.analysisResultList.get(i).get("ProgrammingCodeleafID")));
            } else {
                row.createCell(22).setCellValue(this.container.analysisResultList.get(i).get("ProgrammingCodeleafID"));
            }
            row.createCell(23).setCellValue(this.container.analysisResultList.get(i).get("ProgrammingPageType"));
            row.createCell(24).setCellValue(this.container.analysisResultList.get(i).get("ProgrammingPageRefs"));
            if (this.container.analysisResultList.get(i).get("def:CommentOID") != null) {
                row.createCell(25).setCellValue(this.container.commentDefList.get(this.container.analysisResultList.get(i).get("def:CommentOID")).get("TranslatedText"));
                row.createCell(26).setCellValue(this.container.commentDefList.get(this.container.analysisResultList.get(i).get("def:CommentOID")).get("xml:lang"));
                row.createCell(27).setCellValue(this.container.commentDefList.get(this.container.analysisResultList.get(i).get("def:CommentOID")).get("leafID"));
                row.createCell(28).setCellValue(this.container.commentDefList.get(this.container.analysisResultList.get(i).get("def:CommentOID")).get("PageType"));
                row.createCell(29).setCellValue(this.container.commentDefList.get(this.container.analysisResultList.get(i).get("def:CommentOID")).get("PageRefs"));
            }
            lastDisplayName = this.container.analysisResultList.get(i).get("DisplayName");
            ++i;
        }
        result1 = this.excelStyle.setColumnWidth(result1);
        result1 = this.excelStyle.setStyleResult1Sheet(result1);
    }

    public void writeResult2Sheet(XSSFWorkbook wb) {
        XSSFSheet result2 = wb.createSheet("RESULT2");
        XSSFRow row = result2.createRow(0);
        row.createCell(0).setCellValue("Display Name");
        row.createCell(1).setCellValue("Result Key");
        row.createCell(2).setCellValue("Dataset Name");
        row.createCell(3).setCellValue("Analysis Variable");
        row.createCell(4).setCellValue("User Note 1");
        row.createCell(5).setCellValue("User Note 2");
        row.createCell(6).setCellValue("W Display Name");
        row.createCell(7).setCellValue("W Result Key");
        row.createCell(8).setCellValue("W Dataset Name");
        row.createCell(9).setCellValue("WhereClauseDataset");
        row.createCell(10).setCellValue("WhereClauseVariable");
        row.createCell(11).setCellValue("WhereClauseOperator");
        row.createCell(12).setCellValue("WhereClauseValue");
        row.createCell(13).setCellValue("WhereClause Comment");
        row.createCell(14).setCellValue("W xml:lang");
        int j = 0;
        int i = 0;
        while (i < this.container.analysisDatasetList.size()) {
            row = result2.createRow(i + j + 1);
            row.createCell(0).setCellValue(this.container.analysisDatasetList.get(i).get("DisplayName"));
            if (this.container.analysisDatasetList.get(i).get("AnalysisOID") != null) {
                if (this.isMadeByFujitsu) {
                    row.createCell(1).setCellValue(this.removeTag("AR", this.container.analysisDatasetList.get(i).get("DisplayName"), "", this.container.analysisDatasetList.get(i).get("AnalysisOID")));
                } else {
                    row.createCell(1).setCellValue(this.container.analysisDatasetList.get(i).get("AnalysisOID"));
                }
            }
            row.createCell(2).setCellValue(this.container.analysisDatasetList.get(i).get("DatasetName"));
            row.createCell(3).setCellValue(this.container.analysisDatasetList.get(i).get("Analysis Variable"));
            if (this.container.whereClauseDefList.get(this.container.analysisDatasetList.get(i).get("WhereClauseOID")) != null) {
                ArrayList<Hashtable<String, String>> array = this.container.whereClauseDefList.get(this.container.analysisDatasetList.get(i).get("WhereClauseOID"));
                int k = 0;
                while (k < array.size()) {
                    if (k != 0) {
                        row = result2.createRow(i + j + k + 1);
                    }
                    row.createCell(6).setCellValue(this.container.analysisDatasetList.get(i).get("DisplayName"));
                    if (this.container.analysisDatasetList.get(i).get("AnalysisOID") != null) {
                        if (this.isMadeByFujitsu) {
                            row.createCell(7).setCellValue(this.removeTag("AR", this.container.analysisDatasetList.get(i).get("DisplayName"), "", this.container.analysisDatasetList.get(i).get("AnalysisOID")));
                        } else {
                            row.createCell(7).setCellValue(this.container.analysisDatasetList.get(i).get("AnalysisOID"));
                        }
                    }
                    row.createCell(8).setCellValue(this.container.analysisDatasetList.get(i).get("DatasetName"));
                    row.createCell(9).setCellValue(this.container.analysisDatasetList.get(i).get("DatasetName"));
                    row.createCell(10).setCellValue(this.container.itemDefList.get(array.get(k).get("def:ItemOID")).get("Name"));
                    row.createCell(11).setCellValue(array.get(k).get("Comparator"));
                    row.createCell(12).setCellValue(array.get(k).get("CheckValue"));
                    if (this.container.itemDefList.get(array.get(k).get("def:ItemOID")).get("def:CommentOID") != null) {
                        row.createCell(13).setCellValue(this.container.commentDefList.get(array.get(k).get("def:CommentOID")).get("TranslatedText"));
                        row.createCell(14).setCellValue(this.container.commentDefList.get(array.get(k).get("def:CommentOID")).get("xml:lang"));
                    }
                    ++k;
                }
                j = j + array.size() - 1;
            }
            ++i;
        }
        result2 = this.excelStyle.setColumnWidth(result2);
        result2 = this.excelStyle.setStyleResult2Sheet(result2);
    }

    public String removeTag(String tag, String id) {
        String element = id;
        if (tag.equals("LF")) {
            element = id.replace("LF.", "");
        } else if (tag.equals("CL")) {
            element = id.replace("CL.", "");
        }
        return element;
    }

    public String removeTag(String tag, String datasetName, String variableName, String id) {
        String element = id;
        if (tag.equals("IT")) {
            element = id.replace("IT." + datasetName + "." + variableName + ".", "");
        } else if (tag.equals("AR")) {
            System.out.println("AR." + datasetName + ".");
            element = id.replace("AR." + datasetName + ".", "");
        }
        return element;
    }
}

