/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.importer.models;

import com.fujitsu.tsc.desktop.importer.ExcelWriter2;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class OdmEventFormModel
implements Comparable<OdmEventFormModel> {
    public final String event_id;
    @ExcelWriter2.ExcelColumn(name="Event Name", ordinal=1)
    public String event_name;
    public final String form_id;
    @ExcelWriter2.ExcelColumn(name="Form Name", ordinal=2)
    public String form_name;
    public Integer ordinal;
    @ExcelWriter2.ExcelColumn(name="Mandatory", ordinal=3)
    public String mandatory;
    @ExcelWriter2.ExcelColumn(name="CollectionExceptionCondition", ordinal=4)
    public String collection_exception_cnd;
    @ExcelWriter2.ExcelColumn(name="User Note 1", ordinal=5)
    public String user_note1;
    @ExcelWriter2.ExcelColumn(name="User Note 2", ordinal=6)
    public String user_note2;

    public OdmEventFormModel(OdmEventFormPk key) {
        this.event_id = key.event_id;
        this.event_name = "";
        this.form_id = key.form_id;
        this.form_name = "";
        this.ordinal = 0;
        this.mandatory = "";
        this.collection_exception_cnd = "";
        this.user_note1 = "";
        this.user_note2 = "";
    }

    public void copy(OdmEventFormModel eventform) {
        if (!StringUtils.isEmpty((CharSequence)eventform.event_name)) {
            this.event_name = eventform.event_name;
        }
        if (!StringUtils.isEmpty((CharSequence)eventform.form_name)) {
            this.form_name = eventform.form_name;
        }
        if (eventform.ordinal > 0) {
            this.ordinal = eventform.ordinal;
        }
        if (!StringUtils.isEmpty((CharSequence)eventform.mandatory)) {
            this.mandatory = eventform.mandatory;
        }
        if (!StringUtils.isEmpty((CharSequence)eventform.collection_exception_cnd)) {
            this.collection_exception_cnd = eventform.collection_exception_cnd;
        }
        if (!StringUtils.isEmpty((CharSequence)eventform.user_note1)) {
            this.user_note1 = eventform.user_note1;
        }
        if (!StringUtils.isEmpty((CharSequence)eventform.user_note2)) {
            this.user_note2 = eventform.user_note2;
        }
    }

    @Override
    public int compareTo(OdmEventFormModel eventform) {
        if (this.event_name.equals(eventform.event_name)) {
            return Integer.compare(this.ordinal, eventform.ordinal);
        }
        return this.event_name.compareTo(eventform.event_name);
    }

    public static class OdmEventFormPk
    implements Comparable<OdmEventFormPk> {
        public final String event_id;
        public final String form_id;

        public OdmEventFormPk(String event_id, String form_id) {
            this.event_id = event_id;
            this.form_id = form_id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.event_id.equals(((OdmEventFormPk)obj).event_id) && this.form_id.equals(((OdmEventFormPk)obj).form_id);
        }

        @Override
        public int compareTo(OdmEventFormPk key) {
            return (String.valueOf(this.event_id) + this.form_id).compareTo(String.valueOf(key.event_id) + key.form_id);
        }

        public String toString() {
            String rtn = "Event ID: " + this.event_id + System.lineSeparator();
            rtn = String.valueOf(rtn) + "Form ID: " + this.form_id;
            return rtn;
        }

        public int hashCode() {
            return Objects.hash(this.event_id, this.form_id);
        }
    }
}

