/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.tsc.desktop.validator;

import com.fujitsu.tsc.desktop.util.ErrorInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultValidationHandler
extends DefaultHandler {
    private static Logger logger;
    private Locator locator;
    private List<ErrorInfo> errors = new ArrayList<ErrorInfo>();

    public DefaultValidationHandler() {
        logger = Logger.getLogger((String)"com.fujitsu.tsc.desktop");
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) {
    }

    @Override
    public void characters(char[] ch, int start, int length) {
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        ErrorInfo error = new ErrorInfo();
        error.setId(exception.getSystemId());
        error.setLine(exception.getLineNumber());
        error.setColumn(exception.getColumnNumber());
        error.setMessage(exception.getMessage());
        error.setMessage(String.valueOf(exception.getMessage()) + "\nnear the line number " + this.locator.getLineNumber() + ".");
        this.errors.add(error);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        ErrorInfo error = new ErrorInfo();
        error.setId(exception.getSystemId());
        error.setLine(exception.getLineNumber());
        error.setColumn(exception.getColumnNumber());
        error.setMessage(String.valueOf(exception.getMessage()) + "\nnear the line number " + this.locator.getLineNumber() + ".");
        this.errors.add(error);
    }

    public List<ErrorInfo> getErrors() {
        return this.errors;
    }
}

